"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const time_1 = require("./time");
describe('time', () => {
    test.each([
        [0, '0:00'],
        [2500, '0:02'],
        [time_1.Minute * 3, '3:00'],
        [time_1.Hour + time_1.Minute * 3, '63:00'],
        [time_1.Hour + time_1.Minute * 3 + time_1.Second, '63:01'],
    ])('should support formatting durations', (input, expected) => {
        expect((0, time_1.formatMsToDurationCompat)(input)).toBe(expected);
    });
});
//# sourceMappingURL=time.test.js.map