"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const restoreItems_1 = require("@joplin/lib/services/trash/restoreItems");
class Command extends base_command_1.default {
    usage() {
        return 'restore <pattern>';
    }
    description() {
        return (0, locale_1._)('Restore the items matching <pattern> from the trash.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const pattern = args['pattern'];
        const items = await (0, app_1.default)().loadItems('folderOrNote', pattern);
        if (!items.length)
            throw new Error((0, locale_1._)('Cannot find "%s".', pattern));
        const ids = items.map(n => n.id);
        await (0, restoreItems_1.default)(items[0].type_, ids, { useRestoreFolder: true });
    }
}
module.exports = Command;
//# sourceMappingURL=command-restore.js.map