"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const Note_1 = require("@joplin/lib/models/Note");
const BaseModel_1 = require("@joplin/lib/BaseModel");
class Command extends base_command_1.default {
    usage() {
        return 'rmnote <note-pattern>';
    }
    description() {
        return (0, locale_1._)('Deletes the notes matching <note-pattern>.');
    }
    options() {
        return [
            ['-f, --force', (0, locale_1._)('Deletes the notes without asking for confirmation.')],
            ['-p, --permanent', (0, locale_1._)('Deletes notes permanently, skipping the trash.')],
        ];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        var _a;
        const pattern = args['note-pattern'];
        const force = args.options && args.options.force === true;
        const notes = await (0, app_1.default)().loadItems(BaseModel_1.default.TYPE_NOTE, pattern);
        if (!notes.length)
            throw new Error((0, locale_1._)('Cannot find "%s".', pattern));
        let ok = true;
        if (!force && notes.length > 1) {
            ok = await this.prompt((0, locale_1._n)('%d note matches this pattern. Delete it?', '%d notes match this pattern. Delete them?', notes.length, notes.length), { booleanAnswerDefault: 'n' });
        }
        const permanent = (((_a = args.options) === null || _a === void 0 ? void 0 : _a.permanent) === true) || notes.every(n => !!n.deleted_time);
        if (!force && permanent) {
            const message = ((0, locale_1._n)('%d note will be permanently deleted. Continue?', '%d notes will be permanently deleted. Continue?', notes.length, notes.length));
            ok = await this.prompt(message, { booleanAnswerDefault: 'n' });
        }
        if (!ok)
            return;
        const ids = notes.map(n => n.id);
        const options = {
            toTrash: !permanent,
            sourceDescription: 'rmnote',
        };
        await Note_1.default.batchDelete(ids, options);
    }
}
module.exports = Command;
//# sourceMappingURL=command-rmnote.js.map