"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = htmlpack;
const fs = require("fs-extra");
const Datauri = require('datauri/sync');
const path_1 = require("path");
const packToString_1 = require("./packToString");
const dataUriEncode = (filePath) => {
    const result = Datauri(filePath);
    return result.content;
};
async function htmlpack(inputFile, outputFile) {
    const inputHtml = await fs.readFile(inputFile, 'utf8');
    const baseDir = (0, path_1.dirname)(inputFile);
    const output = await (0, packToString_1.default)(baseDir, inputHtml, {
        exists(path) {
            return fs.exists(path);
        },
        readFileText(path) {
            return fs.readFile(path, 'utf8');
        },
        async readFileDataUri(path) {
            return dataUriEncode(path);
        },
    });
    await fs.writeFile(outputFile, output, 'utf8');
}
//# sourceMappingURL=index.js.map