"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("../shim");
const Resource_1 = require("../models/Resource");
const Note_1 = require("../models/Note");
const test_utils_1 = require("../testing/test-utils");
const renderMarkup_1 = require("./renderMarkup");
const renderer_1 = require("@joplin/renderer");
const testImagePath = `${test_utils_1.supportDir}/photo.jpg`;
const command = (0, renderMarkup_1.runtime)();
describe('renderMarkup', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
    });
    test('should return the rendered note as HTML', async () => {
        {
            const renderedNote = await command.execute(null, renderer_1.MarkupLanguage.Markdown, 'hello **strong**');
            expect(renderedNote.html).toBe('<div id="rendered-md"><p>hello <strong>strong</strong></p>\n</div>');
            expect(!!renderedNote.pluginAssets).toBe(true);
            expect(!!renderedNote.cssStrings).toBe(true);
        }
        {
            const renderedNote = await await command.execute(null, renderer_1.MarkupLanguage.Markdown, '- [ ] Beer\n- [x] Milk\n- [ ] Eggs');
            expect(renderedNote.html).toContain('checkbox-label-unchecked">Beer');
            expect(renderedNote.html).toContain('checkbox-label-checked">Milk');
            expect(renderedNote.html).toContain('checkbox-label-unchecked">Eggs');
            expect(!!renderedNote.pluginAssets).toBe(true);
            expect(!!renderedNote.cssStrings).toBe(true);
        }
        {
            const note = await Note_1.default.save({});
            await shim_1.default.attachFileToNote(note, testImagePath, { resizeLargeImages: 'never' });
            const resource = (await Resource_1.default.all())[0];
            const noteBody = (await Note_1.default.load(note.id)).body;
            const renderedNote = await await command.execute(null, renderer_1.MarkupLanguage.Markdown, noteBody);
            expect(renderedNote.html).toContain(`<div id="rendered-md"><p><img data-from-md data-resource-id="${resource.id}" src="`);
            expect(renderedNote.html).toContain(`/resources-1/${resource.id}.jpg?t=`);
            expect(renderedNote.html).toContain('" title alt="photo.jpg" /></p>');
        }
    });
});
//# sourceMappingURL=renderMarkup.test.js.map