"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const locale_1 = require("../locale");
const getCanBeCollapsedFolderIds_1 = require("../models/utils/getCanBeCollapsedFolderIds");
const Setting_1 = require("../models/Setting");
exports.declaration = {
    name: 'toggleAllFolders',
    label: () => (0, locale_1._)('Toggle all notebooks'),
};
const runtime = () => {
    return {
        execute: async (context, collapseAll) => {
            if (!collapseAll && !Setting_1.default.value('folderHeaderIsExpanded')) {
                Setting_1.default.setValue('folderHeaderIsExpanded', true);
            }
            context.dispatch({
                type: 'FOLDER_SET_COLLAPSED',
                ids: collapseAll ? (0, getCanBeCollapsedFolderIds_1.default)(context.state.folders) : [],
            });
        },
    };
};
exports.runtime = runtime;
//# sourceMappingURL=toggleAllFolders.js.map