"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForElement = exports.isInsideContainer = void 0;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const isInsideContainer = (node, className) => {
    while (node) {
        if (node.classList && node.classList.contains(className))
            return true;
        node = node.parentNode;
    }
    return false;
};
exports.isInsideContainer = isInsideContainer;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const waitForElement = async (parent, id, cancelEvent) => {
    return new Promise((resolve, reject) => {
        const iid = setInterval(() => {
            try {
                const element = parent.getElementById(id);
                if (element || (cancelEvent === null || cancelEvent === void 0 ? void 0 : cancelEvent.cancelled)) {
                    clearInterval(iid);
                    resolve(element);
                }
            }
            catch (error) {
                clearInterval(iid);
                reject(error);
            }
        }, 10);
    });
};
exports.waitForElement = waitForElement;
// cSpell:enable
//# sourceMappingURL=dom.js.map