"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("../shim");
const AsyncActionQueue_1 = require("../AsyncActionQueue");
const { useEffect, useState } = shim_1.default.react();
exports.default = (effect, dependencies, { interval = undefined } = {}) => {
    const [queue] = useState(() => new AsyncActionQueue_1.default(interval));
    useEffect(() => {
        const event = { cancelled: false };
        queue.push(() => effect(event));
        return () => {
            event.cancelled = true;
        };
        // eslint-disable-next-line @seiyab/react-hooks/exhaustive-deps -- This is a custom hook
    }, dependencies);
    useEffect(() => {
        return () => {
            void queue.reset();
        };
    }, [queue]);
};
//# sourceMappingURL=useQueuedAsyncEffect.js.map