"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const react_hooks_1 = require("@testing-library/react-hooks");
const useQueuedAsyncEffect_1 = require("./useQueuedAsyncEffect");
const test_utils_1 = require("../testing/test-utils");
describe('useQueuedAsyncEffect', () => {
    test('should debounce effect updates', async () => {
        const effectFunction = jest.fn(async () => { });
        const useTestHook = (dependencies) => {
            return (0, useQueuedAsyncEffect_1.default)(effectFunction, dependencies);
        };
        await (0, test_utils_1.runWithFakeTimers)(async () => {
            const result = (0, react_hooks_1.renderHook)(useTestHook, { initialProps: ['test'] });
            // Should pause to allow debouncing.
            expect(effectFunction).not.toHaveBeenCalled();
            await jest.advanceTimersByTimeAsync(12500);
            expect(effectFunction).toHaveBeenCalledTimes(1);
            await jest.advanceTimersByTimeAsync(1000);
            // Changing twice quickly: Should only update once
            result.rerender(['changed']);
            expect(effectFunction).toHaveBeenCalledTimes(1);
            result.rerender(['changed again']);
            await jest.advanceTimersByTimeAsync(500);
            expect(effectFunction).toHaveBeenCalledTimes(2);
            await jest.advanceTimersByTimeAsync(500);
            expect(effectFunction).toHaveBeenCalledTimes(2);
        });
    });
});
//# sourceMappingURL=useQueuedAsyncEffect.test.js.map