"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("../../testing/test-utils");
const Folder_1 = require("../Folder");
const areAllFoldersCollapsed_1 = require("./areAllFoldersCollapsed");
describe('areAllFoldersCollapsed', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
    });
    it('should tell if all folders are collapsed', async () => {
        const folder1 = await Folder_1.default.save({});
        await Folder_1.default.save({ parent_id: folder1.id });
        await Folder_1.default.save({ parent_id: folder1.id });
        const folder2 = await Folder_1.default.save({});
        const folder2a = await Folder_1.default.save({ parent_id: folder2.id });
        await Folder_1.default.save({ parent_id: folder2a.id });
        expect((0, areAllFoldersCollapsed_1.default)(await Folder_1.default.all(), [])).toBe(false);
        expect((0, areAllFoldersCollapsed_1.default)(await Folder_1.default.all(), [
            folder1.id,
            folder2.id,
        ])).toBe(false);
        expect((0, areAllFoldersCollapsed_1.default)(await Folder_1.default.all(), [
            folder1.id,
            folder2.id,
            folder2a.id,
        ])).toBe(true);
    });
});
//# sourceMappingURL=areAllFoldersCollapsed.test.js.map