"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("../../types");
const StringToBufferWrapper_1 = require("./StringToBufferWrapper");
const WebCryptoRsa_1 = require("./WebCryptoRsa");
const LongDataWrapper_1 = require("./LongDataWrapper");
const buildRsaCryptoProvider = (rsaMode, crypto) => {
    // Cast: Old versions of @types/node don't include crypto.subtle:
    const cryptoSlice = crypto;
    if (rsaMode === types_1.PublicKeyAlgorithm.RsaV2) {
        const keySizeBits = 2048;
        return new StringToBufferWrapper_1.default(new LongDataWrapper_1.default(new WebCryptoRsa_1.default(cryptoSlice, { modulusLengthBits: keySizeBits }), keySizeBits / 8));
    }
    else if (rsaMode === types_1.PublicKeyAlgorithm.RsaV3) {
        return new StringToBufferWrapper_1.default(new WebCryptoRsa_1.default(cryptoSlice, { modulusLengthBits: 4096 }));
    }
    else {
        throw new Error(`Unsupported mode for webCrypto: ${rsaMode}`);
    }
};
exports.default = buildRsaCryptoProvider;
//# sourceMappingURL=buildRsaCryptoProvider.js.map