"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const ShareService_1 = require("./ShareService");
const Logger_1 = require("@joplin/utils/Logger");
const Folder_1 = require("../../models/Folder");
const registry_1 = require("../../registry");
const locale_1 = require("../../locale");
const shim_1 = require("../../shim");
const logger = Logger_1.default.create('invitationRespond');
async function default_1(shareUserId, folderId, masterKey, accept) {
    // The below functions can take a bit of time to complete so in the
    // meantime we hide the notification so that the user doesn't click
    // multiple times on the Accept link.
    ShareService_1.default.instance().setProcessingShareInvitationResponse(true);
    try {
        await ShareService_1.default.instance().respondInvitation(shareUserId, masterKey, accept);
    }
    catch (error) {
        logger.error(error);
        if (shim_1.default.mobilePlatform() === 'web' && masterKey) {
            alert((0, locale_1._)('The web client does not support accepting encrypted shared notebooks. Please switch to the desktop or mobile app before accepting the share.\n\nError: "%s"', error.message));
        }
        else {
            alert((0, locale_1._)('Could not respond to the invitation. Please try again, or check with the notebook owner if they are still sharing it.\n\nThe error was: "%s"', error.message));
        }
    }
    // This is to handle an edge case that can happen if:
    //
    // - The user is a recipient of a share.
    // - The sender removes the recipient from the share, then add him again.
    // - The recipient gets the invitation, but reply "Reject" to it.
    //
    // If we don't handle this case, it would kind of work but would create
    // conflicts because the shared notes would be converted to local ones, then
    // during sync the synchronizer would try to delete them. Since they've been
    // changed, they'll all be marked as conflicts.
    //
    // So the simplest thing to do is to leave the folder, which is most likely
    // what the user wants. And if not, it's always possible to ask the sender
    // to share again.
    //
    // NOTE: DOESN'T WORK. Because Folder.updateAllShareIds() would still run
    // and change the notes share_id property, thus creating conflicts again.
    // Leaving it as it is for now, as it's an unlikely scenario and it won't
    // cause any data loss.
    if (!accept) {
        const existingFolder = await Folder_1.default.load(folderId);
        if (existingFolder) {
            logger.warn('Rejected an invitation, but the folder was already there. Conflicts are likely to happen. ShareUserId:', shareUserId, 'Folder ID:', folderId);
            // await ShareService.instance().leaveSharedFolder(folderId);
        }
    }
    try {
        await ShareService_1.default.instance().refreshShareInvitations();
    }
    finally {
        ShareService_1.default.instance().setProcessingShareInvitationResponse(false);
    }
    void registry_1.reg.scheduleSync(1000);
}
//# sourceMappingURL=invitationRespond.js.map