"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasCredentialFile = void 0;
exports.credentialDir = credentialDir;
exports.credentialFile = credentialFile;
exports.readCredentialFile = readCredentialFile;
exports.readCredentialFileJson = readCredentialFileJson;
const fs_extra_1 = require("fs-extra");
// All these calls used to be async but certain scripts need to load config
// files early, so they've been converted to sync calls. Do not convert them
// back to async.
function credentialDir() {
    const username = require('os').userInfo().username;
    const toTry = [
        `c:/Users/${username}/joplin-credentials`,
        `/mnt/c/Users/${username}/joplin-credentials`,
        `/home/${username}/joplin-credentials`,
        `/Users/${username}/joplin-credentials`,
    ];
    for (const dirPath of toTry) {
        if ((0, fs_extra_1.pathExistsSync)(dirPath))
            return dirPath;
    }
    throw new Error(`Could not find credential directory in any of these paths: ${JSON.stringify(toTry)}`);
}
const hasCredentialFile = (filename) => {
    let d = '';
    try {
        d = credentialDir();
    }
    catch (error) {
        return false;
    }
    return (0, fs_extra_1.pathExistsSync)(`${d}/${filename}`);
};
exports.hasCredentialFile = hasCredentialFile;
function credentialFile(filename) {
    const rootDir = credentialDir();
    const output = `${rootDir}/${filename}`;
    if (!((0, fs_extra_1.pathExistsSync)(output)))
        throw new Error(`No such file: ${output}`);
    return output;
}
function readCredentialFile(filename, defaultValue = '') {
    try {
        const filePath = credentialFile(filename);
        const r = (0, fs_extra_1.readFileSync)(filePath);
        // There's normally no reason to keep the last new line character and it
        // can cause problems in certain scripts, so trim it. Any other white
        // space should also not be relevant.
        return r.toString().trim();
    }
    catch (error) {
        return defaultValue;
    }
}
function readCredentialFileJson(filename, defaultValue = null) {
    const v = readCredentialFile(filename);
    if (!v)
        return defaultValue;
    try {
        const o = JSON.parse(v);
        return o;
    }
    catch (error) {
        error.message = `Could not parse JSON file ${filename}: ${error.message}`;
        throw error;
    }
}
//# sourceMappingURL=credentialFiles.js.map