"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const isTransferableObject_1 = require("./isTransferableObject");
// eslint-disable-next-line no-redeclare
function mergeCallbacksAndSerializable(serializable, callbacks, callMethodWithId, afterCallbackCreated) {
    const mergeCallbackAndSerializable = (serializableObj, callbackObj) => {
        if (typeof callbackObj === 'string') {
            const callbackId = callbackObj;
            const callback = (...args) => {
                return callMethodWithId(callbackId, args);
            };
            afterCallbackCreated(callbackId, callback);
            return callback;
        }
        else if (typeof serializableObj === 'object' && serializableObj !== null) { // typeof(null) is object
            if (typeof callbackObj !== 'object') {
                throw new Error('Callback arguments should be an object (and thus match the type of serializableArgs)');
            }
            if (Array.isArray(serializableObj)) {
                if (!Array.isArray(callbackObj)) {
                    throw new Error(`Callbacks not separated correctly (mismatched structure). ${callbackObj} should be an array`);
                }
                if (callbackObj.length !== serializableObj.length) {
                    throw new Error(`Callbacks not separated correctly (mismatched array length, ${callbackObj.length} != ${serializableObj.length})`);
                }
                const result = [];
                for (let i = 0; i < serializableObj.length; i++) {
                    result.push(mergeCallbackAndSerializable(serializableObj[i], callbackObj[i]));
                }
                return result;
            }
            else if ((0, isTransferableObject_1.default)(serializableObj)) {
                return serializableObj;
            }
            else {
                if (Array.isArray(callbackObj)) {
                    throw new Error('callbackArgs should not be an array');
                }
                const result = Object.create(null);
                for (const key in serializableObj) {
                    result[key] = mergeCallbackAndSerializable(serializableObj[key], callbackObj[key]);
                }
                return result;
            }
        }
        else {
            return serializableObj;
        }
    };
    return mergeCallbackAndSerializable(serializable, callbacks);
}
exports.default = mergeCallbacksAndSerializable;
//# sourceMappingURL=mergeCallbacksAndSerializable.js.map