"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const htmlUtils_1 = require("../../htmlUtils");
const utils = require("../../utils");
const createEventHandlingAttrs_1 = require("../createEventHandlingAttrs");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function plugin(markdownIt, ruleOptions) {
    const defaultRender = markdownIt.renderer.rules.image;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    markdownIt.renderer.rules.image = (tokens, idx, options, env, self) => {
        var _a, _b, _c, _d, _e, _f;
        const Resource = ruleOptions.ResourceModel;
        const token = tokens[idx];
        const src = utils.getAttr(token.attrs, 'src');
        const title = utils.getAttr(token.attrs, 'title');
        if (!Resource.isResourceUrl(src) || ruleOptions.plainResourceRendering)
            return defaultRender(tokens, idx, options, env, self);
        const alt = token.content;
        const r = utils.imageReplacement(ruleOptions.ResourceModel, { src, alt, title }, ruleOptions.resources, ruleOptions.resourceBaseUrl, ruleOptions.itemIdToUrl);
        if (typeof r === 'string')
            return r;
        if (r) {
            const id = r['data-resource-id'];
            // Show the edit popup if any MIME type matches that in editPopupFiletypes
            const mimeType = (_c = (_b = (_a = ruleOptions.resources[id]) === null || _a === void 0 ? void 0 : _a.item) === null || _b === void 0 ? void 0 : _b.mime) === null || _c === void 0 ? void 0 : _c.toLowerCase();
            const enableEditPopup = (_d = ruleOptions.editPopupFiletypes) === null || _d === void 0 ? void 0 : _d.some(showForMime => mimeType === showForMime);
            const js = (0, createEventHandlingAttrs_1.default)(id, {
                enableLongPress: (_e = ruleOptions.enableLongPress) !== null && _e !== void 0 ? _e : false,
                postMessageSyntax: (_f = ruleOptions.postMessageSyntax) !== null && _f !== void 0 ? _f : 'void',
                enableEditPopup,
                createEditPopupSyntax: ruleOptions.createEditPopupSyntax,
                destroyEditPopupSyntax: ruleOptions.destroyEditPopupSyntax,
            }, null);
            return `<img data-from-md ${(0, htmlUtils_1.attributesHtml)(Object.assign(Object.assign({}, r), { title: title, alt }))} ${js}/>`;
        }
        return defaultRender(tokens, idx, options, env, self);
    };
}
exports.default = { plugin };
//# sourceMappingURL=image.js.map