"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function default_1(markdownIt) {
    // Add `file:` protocol in linkify to allow text in the format of "file://..." to translate into
    // file-URL links in html view
    markdownIt.linkify.add('file:', {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        validate: function (text, pos, self) {
            const tail = text.slice(pos);
            if (!self.re.file) {
                // matches all local file URI on Win/Unix/MacOS systems including reserved characters in some OS (i.e. no OS specific sanity check)
                // eslint-disable-next-line prefer-regex-literals -- Old code before rule was applied
                self.re.file = new RegExp('^[\\/]{2,3}[\\S]+');
            }
            if (self.re.file.test(tail)) {
                return tail.match(self.re.file)[0].length;
            }
            return 0;
        },
    });
    markdownIt.linkify.set({
        'fuzzyLink': false,
        'fuzzyIP': false,
        'fuzzyEmail': false,
    });
}
//# sourceMappingURL=setupLinkify.js.map