"use strict";
/* eslint-disable import/prefer-default-export */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTempDir = void 0;
const fs_extra_1 = require("fs-extra");
const fs_1 = require("./fs");
const time_1 = require("./time");
const baseTempDir = `${__dirname}/../app-cli/tests/tmp`;
const createTempDir = async () => {
    const p = `${baseTempDir}/${Date.now()}`;
    await (0, fs_extra_1.mkdirp)(p);
    return p;
};
exports.createTempDir = createTempDir;
describe('fs', () => {
    it('should lock files', async () => {
        const dirPath = await (0, exports.createTempDir)();
        const filePath = `${dirPath}/test.lock`;
        const locker1 = new fs_1.FileLocker(filePath, {
            interval: 10 * time_1.Second,
        });
        expect(await locker1.lock()).toBe(true);
        expect(await locker1.lock()).toBe(false);
        locker1.unlockSync();
        const locker2 = new fs_1.FileLocker(filePath, {
            interval: 1.5 * time_1.Second,
        });
        expect(await locker2.lock()).toBe(true);
        locker2.stopMonitoring_();
        const locker3 = new fs_1.FileLocker(filePath, {
            interval: 1.5 * time_1.Second,
        });
        await (0, time_1.msleep)(2 * time_1.Second);
        expect(await locker3.lock()).toBe(true);
        locker3.unlockSync();
    });
});
//# sourceMappingURL=fs.test.js.map