/*
	String Kit

	Copyright (c) 2014 - 2019 Cédric Ronvel

	The MIT License (MIT)

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.
*/

"use strict" ;



/* All polyfill borrowed from MDN: developer.mozilla.org */



var polyfill = {} ;
module.exports = polyfill ;



// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/repeat
polyfill.repeat = function( count ) {
	if ( this === null ) {
		throw new TypeError( 'can\'t convert ' + this + ' to object' ) ;
	}
	var str = '' + this ;
	count = + count ;
	if ( count !== count ) {
		count = 0 ;
	}
	if ( count < 0 ) {
		throw new RangeError( 'repeat count must be non-negative' ) ;
	}
	if ( count === Infinity ) {
		throw new RangeError( 'repeat count must be less than infinity' ) ;
	}
	count = Math.floor( count ) ;
	if ( str.length === 0 || count === 0 ) {
		return '' ;
	}
	// Ensuring count is a 31-bit integer allows us to heavily optimize the
	// main part. But anyway, most current (August 2014) browsers can't handle
	// strings 1 << 28 chars or longer, so:
	if ( str.length * count >= 1 << 28 ) {
		throw new RangeError( 'repeat count must not overflow maximum string size' ) ;
	}
	var rpt = '' ;
	for ( ;; ) {
		if ( ( count & 1 ) === 1 ) {
			rpt += str ;
		}
		count >>>= 1 ;
		if ( count === 0 ) {
			break ;
		}
		str += str ;
	}
	return rpt ;
} ;


