function printftests(T)
    @test DecFP.max_integer_part_width(T) == ceil(Int, log10(floatmax(T)))
    @test typeof(Printf.tofloat(T("1"))) == T

    # printf %a
    @test_throws ArgumentError @sprintf("%a", T("1"))

    # printf %g
    @test @sprintf("%.6g", T("12345670")) == "1.23457e+07"
    @test @sprintf("%.6g", T("1234567.0")) == "1.23457e+06"
    @test @sprintf("%.6g", T("123456.70")) == "123457"
    @test @sprintf("%.6g", T("12345.670")) == "12345.7"
    @test @sprintf("%10.5g", T("123.4")) == "     123.4"
    @test @sprintf("%+10.5g", T("123.4")) == "    +123.4"
    @test @sprintf("% 10.5g", T("123.4")) == "     123.4"
    @test @sprintf("%#10.5g", T("123.4")) == "    123.40"
    @test @sprintf("%-10.5g", T("123.4")) == "123.4     "
    @test @sprintf("%-+10.5g", T("123.4")) == "+123.4    "
    @test @sprintf("%010.5g", T("123.4")) == "00000123.4"
    @test @sprintf("%10.5g", T("-123.4")) == "    -123.4"
    @test @sprintf("%010.5g", T("-123.4")) == "-0000123.4"
    @test @sprintf("%.6g", T("12340000.0")) == "1.234e+07"
    @test @sprintf("%#.6g", T("12340000.0")) == "1.23400e+07"

    @test @sprintf("%.5g", T("42")) == "42"
    @test @sprintf("%#.2g", T("42")) == "42."
    @test @sprintf("%#.5g", T("42")) == "42.000"

    @test @sprintf("%g", T("0.00012")) == "0.00012"
    @test @sprintf("%g", T("0.000012")) == "1.2e-05"
    @test @sprintf("%g", T("123456.7")) == "123457"
    @test @sprintf("%g", T("1234567.0")) == "1.23457e+06"

    @test @sprintf("%g", T("Inf")) == "Inf"
    @test @sprintf("%g", T("-Inf")) == "-Inf"
    @test @sprintf("%g", T("NaN")) == "NaN"
    @test @sprintf("%g", T("-NaN")) == "NaN"
    @test @sprintf("%G", T("Inf")) == "Inf"
    @test @sprintf("%G", T("-Inf")) == "-Inf"
    @test @sprintf("%G", T("NaN")) == "NaN"
    @test @sprintf("%G", T("-NaN")) == "NaN"

    @test @sprintf("%.0g", T("0")) == "0"
    @test @sprintf("%#.0g", T("0")) == "0."
    @test @sprintf("%.15g", T("0")) == "0"
    @test @sprintf("%#.15g", T("0")) == "0.00000000000000"

    # printf %f
    @test @sprintf("%f", T("Inf")) == "Inf"
    @test @sprintf("%+f", T("Inf")) == "+Inf"
    @test @sprintf("% f", T("Inf")) == " Inf"
    @test @sprintf("% #f", T("Inf")) == " Inf"
    @test @sprintf("%07f", T("Inf")) == "    Inf"
    @test @sprintf("%f", T("-Inf")) == "-Inf"
    @test @sprintf("%+f", T("-Inf")) == "-Inf"
    @test @sprintf("%07f", T("-Inf")) == "   -Inf"
    @test @sprintf("%f", T("NaN")) == "NaN"
    @test @sprintf("%+f", T("NaN")) == "+NaN"
    @test @sprintf("% f", T("NaN")) == " NaN"
    @test @sprintf("% #f", T("NaN")) == " NaN"
    @test @sprintf("%07f", T("NaN")) == "    NaN"

    @test @sprintf("%f", T("1.234")) == "1.234000"
    @test @sprintf("%F", T("1.234")) == "1.234000"
    @test @sprintf("%+f", T("1.234")) == "+1.234000"
    @test @sprintf("% f", T("1.234")) == " 1.234000"
    @test @sprintf("%f", T("-1.234")) == "-1.234000"
    @test @sprintf("%+f", T("-1.234")) == "-1.234000"
    @test @sprintf("% f", T("-1.234")) == "-1.234000"
    @test @sprintf("%#f", T("1.234")) == "1.234000"
    @test @sprintf("%.1f", T("1.234567")) == "1.2"
    @test @sprintf("%.2f", T("1.234")) == "1.23"
    @test @sprintf("%.2f", T("1.235")) == "1.24"
    @test @sprintf("%.2f", T("1.245")) == "1.24"
    @test @sprintf("%.2f", T("1.255")) == "1.26"
    @test @sprintf("%.2f", T("0.235")) == "0.24"
    @test @sprintf("%4.1f", T("1.234")) == " 1.2"
    @test @sprintf("%8.1f", T("1.234")) == "     1.2"
    @test @sprintf("%+8.1f", T("1.234")) == "    +1.2"
    @test @sprintf("% 8.1f", T("1.234")) == "     1.2"
    @test @sprintf("% 7.1f", T("1.234")) == "    1.2"
    @test @sprintf("% 08.1f", T("1.234")) == " 00001.2"
    @test @sprintf("%08.1f", T("1.234")) == "000001.2"
    @test @sprintf("%-08.1f", T("1.234")) == "1.2     "
    @test @sprintf("%-8.1f", T("1.234")) == "1.2     "
    @test @sprintf("%08.1f", T("-1.234")) == "-00001.2"
    @test @sprintf("%09.1f", T("-1.234")) == "-000001.2"
    @test @sprintf("%09.1f", T("1.234")) == "0000001.2"
    @test @sprintf("%+09.1f", T("1.234")) == "+000001.2"
    @test @sprintf("% 09.1f", T("1.234")) == " 000001.2"
    @test @sprintf("%+ 09.1f", T("1.234")) == "+000001.2"
    @test @sprintf("%+ 09.0f", T("1.234")) == "+00000001"
    @test @sprintf("%+ #09.0f", T("1.234")) == "+0000001."
    @test @sprintf("%.1f", T("0.0001")) == "0.0"
    @test @sprintf("%#.0f", T("0.0001")) == "0."

    @test @sprintf("%+7.1f", T("9.96")) == "  +10.0"
    @test @sprintf("% 7.1f", T("9.96")) == "   10.0"

    # issue #178
    @test @sprintf("%.36f", T("0.1")) == "0.100000000000000000000000000000000000"
    # for Dec32 this is "+9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.00"
    @test @sprintf("%+.2f", floatmax(T)) == "+" * "9"^precision(T, base=10) * "0"^(ceil(Int, log10(floatmax(T))) - precision(T, base=10)) * ".00"

    # printf %e
    @test @sprintf("%e", T("Inf")) == "Inf"
    @test @sprintf("%+e", T("Inf")) == "+Inf"
    @test @sprintf("% e", T("Inf")) == " Inf"
    @test @sprintf("% #e", T("Inf")) == " Inf"
    @test @sprintf("%07e", T("Inf")) == "    Inf"
    @test @sprintf("%e", T("-Inf")) == "-Inf"
    @test @sprintf("%+e", T("-Inf")) == "-Inf"
    @test @sprintf("%07e", T("-Inf")) == "   -Inf"
    @test @sprintf("%e", T("NaN")) == "NaN"
    @test @sprintf("%+e", T("NaN")) == "+NaN"
    @test @sprintf("% e", T("NaN")) == " NaN"
    @test @sprintf("% #e", T("NaN")) == " NaN"
    @test @sprintf("%07e", T("NaN")) == "    NaN"

    @test @sprintf("%#.0e", T("0")) == "0.e+00"
    @test @sprintf("%.2e", T("0")) == "0.00e+00"

    @test @sprintf("%8.0e", T("3e1")) == "   3e+01"
    @test @sprintf("%#8.0e", T("3e1")) == "  3.e+01"
    @test @sprintf("%8.0e", T("3e14")) == "   3e+14"
    T != Dec32 && @test @sprintf("%8.0e", T("3e142")) == "  3e+142"
    T == Dec128 && @test @sprintf("%8.0e", T("3e1042")) == " 3e+1042"

    @test @sprintf("%e", T("3e42")) == "3.000000e+42"
    @test @sprintf("%E", T("3e42")) == "3.000000E+42"
    @test @sprintf("%e", T("3e-42")) == "3.000000e-42"
    @test @sprintf("%E", T("3e-42")) == "3.000000E-42"

    @test @sprintf("%e", T("1.234")) == "1.234000e+00"
    @test @sprintf("%E", T("1.234")) == "1.234000E+00"
    @test @sprintf("%+e", T("1.234")) == "+1.234000e+00"
    @test @sprintf("% e", T("1.234")) == " 1.234000e+00"
    @test @sprintf("%e", T("-1.234")) == "-1.234000e+00"
    @test @sprintf("%+e", T("-1.234")) == "-1.234000e+00"
    @test @sprintf("% e", T("-1.234")) == "-1.234000e+00"
    @test @sprintf("%#e", T("1.234")) == "1.234000e+00"
    @test @sprintf("%.2e", T("1.234")) == "1.23e+00"
    @test @sprintf("%.2e", T("1.235")) == "1.24e+00"
    @test @sprintf("%.2e", T("0.235")) == "2.35e-01"
    @test @sprintf("%4.1e", T("1.234")) == "1.2e+00"
    @test @sprintf("%8.1e", T("1.234")) == " 1.2e+00"
    @test @sprintf("%+8.1e", T("1.234")) == "+1.2e+00"
    @test @sprintf("% 8.1e", T("1.234")) == " 1.2e+00"
    @test @sprintf("% 7.1e", T("1.234")) == " 1.2e+00"
    @test @sprintf("% 08.1e", T("1.234")) == " 1.2e+00"
    @test @sprintf("%08.1e", T("1.234")) == "01.2e+00"
    @test @sprintf("%-08.1e", T("1.234")) == "1.2e+00 "
    @test @sprintf("%-8.1e", T("1.234")) == "1.2e+00 "
    @test @sprintf("%08.1e", T("-1.234")) == "-1.2e+00"
    @test @sprintf("%09.1e", T("-1.234")) == "-01.2e+00"
    @test @sprintf("%09.1e", T("1.234")) == "001.2e+00"
    @test @sprintf("%+09.1e", T("1.234")) == "+01.2e+00"
    @test @sprintf("% 09.1e", T("1.234")) == " 01.2e+00"
    @test @sprintf("%+ 09.1e", T("1.234")) == "+01.2e+00"
    @test @sprintf("%+ 09.0e", T("1.234")) == "+0001e+00"
    @test @sprintf("%+ #09.0e", T("1.234")) == "+001.e+00"

    @test @sprintf("%+9.1e", T("9.96")) == " +1.0e+01"
    @test @sprintf("% 9.1e", T("9.96")) == "  1.0e+01"
    @test @sprintf("%+9.1e", T("-9.96e-7")) == " -1.0e-06"

    # issue #178
    @test @sprintf("%.36e", T("0.1")) == "1.000000000000000000000000000000000000e-01"
    @test @sprintf("%.36e", floatmax(Dec32)) == "9.999999000000000000000000000000000000e+96"
    @test @sprintf("%.36e", floatmax(Dec64)) == "9.999999999999999000000000000000000000e+384"
    @test @sprintf("%.36e", floatmax(Dec128)) == "9.999999999999999999999999999999999000e+6144"

    @test @sprintf("%.2f %.4f", T("12.34567"), 9.87) == "12.35 9.8700"
end
