# Gaussian Quadrature


## Gauss-Legendre quadrature
Gauss quadrature for the weight function ``w(x) = 1``.

* For ``n ≤ 5``: Use an analytic expression.
* For ``n ≤ 60``: Use Newton's method to solve ``P_n(x)=0``. Evaluate Legendre polynomials ``P_n`` and their derivatives ``P_n'`` by 3-term recurrence. Weights are related to ``P_n'``.
* For ``n > 60``: Use asymptotic expansions for the Legendre nodes and weights [[1]](http://epubs.siam.org/doi/abs/10.1137/140954969).

```@docs
gausslegendre(n::Integer)
```


## Gauss-Hermite quadrature
Gauss quadrature for the weight function ``w(x) = \exp(-x^2)`` on the real line.

* For ``n < 200``: Use Newton's method to solve ``H_n(x)=0``. Evaluate Hermite polynomials ``H_n`` and their derivatives ``H_n'`` by three-term recurrence.
* For ``n ≥ 200``: Use Newton's method to solve ``H_n(x)=0``. Evaluate ``H_n`` and ``H_n'`` by a uniform asymptotic expansion, see [[7]](http://arxiv.org/abs/1410.5286).

The paper [[7]](http://arxiv.org/abs/1410.5286) also derives an ``O(n)`` algorithm for generalized Gauss-Hermite nodes and weights associated to weight functions of the form ``\exp(-V(x))``, where ``V(x)`` is a real polynomial.

```@docs
gausshermite(n::Integer)
```


## Gauss-Laguerre quadrature
Gauss quadrature for the weight function ``w(x) = \exp(-x)`` on ``[0,+\infty)``

* For ``n < 128``: Use the Golub-Welsch algorithm.
* For `method=GLR`: Use the Glaser-Lui-Rohklin algorithm. Evaluate Laguerre polynomials ``L_n`` and their derivatives ``L_n'`` by using Taylor series expansions near roots generated by solving the second-order differential equation that ``L_n`` satisfies, see [[2]](http://epubs.siam.org/doi/pdf/10.1137/06067016X).
* For ``n ≥ 128``: Use a Newton procedure on Riemann-Hilbert asymptotics of Laguerre polynomials, see [5], based on [8]. There are some heuristics to decide which expression to use, it allows a general weight ``w(x) = x^\alpha \exp(-q_m x^m)`` and this is ``O(\sqrt{n})`` when allowed to stop when the weights are below the smallest positive floating point number.

```@docs
gausslaguerre(n::Integer)
```

```@docs
gausslaguerre(n::Integer, α::Real)
```


## Gauss-Chebyshev quadrature
There are four kinds of Gauss-Chebyshev quadrature rules, corresponding to four weight functions:

* 1st kind, weight function ``w(x) = 1/\sqrt{1-x^2}``
* 2nd kind, weight function ``w(x) = \sqrt{1-x^2}``
* 3rd kind, weight function ``w(x) = \sqrt{(1+x)/(1-x)}``
* 4th kind, weight function ``w(x) = \sqrt{(1-x)/(1+x)}``

They are all have explicit simple formulas for the nodes and weights [[4]](https://books.google.co.jp/books?id=8FHf0P3to0UC).

```@docs
gausschebyshevt(n::Integer)
gausschebyshevu(n::Integer)
gausschebyshevv(n::Integer)
gausschebyshevw(n::Integer)
```


## Gauss-Jacobi quadrature
Gauss quadrature for the weight functions ``w(x) = (1-x)^\alpha(1+x)^\beta``, ``\alpha,\beta > -1``.

* For ``n ≤ 100``: Use Newton's method to solve ``P_n(x)=0``. Evaluate ``P_n`` and ``P_n'`` by three-term recurrence.
* For ``n > 100``: Use Newton's method to solve ``P_n(x)=0``. Evaluate ``P_n`` and ``P_n'`` by an asymptotic expansion (in the interior of ``[-1,1]``) and the three-term recurrence ``O(n^{-2})`` close to the endpoints. (This is a small modification to the algorithm described in [[3]](http://epubs.siam.org/doi/abs/10.1137/120889873).)
* For ``\max(\alpha,\beta) > 5``: Use the Golub-Welsch algorithm requiring ``O(n^2)`` operations.

```@docs
gaussjacobi(n::Integer, α::Real, β::Real)
```


## Gauss-Radau quadrature
Gauss quadrature for the weight function ``w(x)=1``, except the endpoint ``-1`` is included as a quadrature node.

The Gauss-Radau nodes and weights can be computed via the ``(0,1)`` Gauss-Jacobi nodes and weights[[3]](http://epubs.siam.org/doi/abs/10.1137/120889873).

```@docs
gaussradau(n::Integer)
```


## Gauss-Lobatto quadrature
Gauss quadrature for the weight function ``w(x)=1``, except the endpoints ``-1`` and ``1`` are included as nodes.

The Gauss-Lobatto nodes and weights can be computed via the ``(1,1)`` Gauss-Jacobi nodes and weights[[3]](http://epubs.siam.org/doi/abs/10.1137/120889873).

```@docs
gausslobatto(n::Integer)
```

