# JuMP community standards

Welcome. JuMP is part of the Julia community, and we uphold its [community
standards](https://julialang.org/community/standards/). We repeat the key points
below with some minor specializations for JuMP.

The JuMP community is committed to maintaining a welcoming, civil, and
constructive environment. We expect the following standards to be observed and
upheld by all participants in any community forum (Discourse, GitHub, etc.).

## Be respectful and inclusive

Please do not use overtly sexual language or imagery, and do not attack anyone
based on any aspect of personal identity, including gender, sexuality, religion,
ethnicity, race, age, or ability. Keep in mind that what you write in public
forums is read by many people who don't know you personally, so please refrain
from making prejudiced or sexual jokes and comments—even ones that you might
consider acceptable in private. Ask yourself if a comment or statement might
make someone feel unwelcomed or like an outsider.

## Give credit

All participants in the JuMP community are expected to respect copyright laws
and ethical attribution standards. This applies to both code and written
materials, such as documentation or blog posts. Materials that violate the law,
are plagiaristic, or ethically dubious in some way will be removed from
officially maintained lists of resources.

## Get involved

The JuMP community is built on a foundation of reciprocity and collaboration. Be
aware that most community members contribute on a voluntary basis, so ideas and
bug reports are ok, but demands are not. Along these lines, it's important to
keep in mind that, unless stated otherwise, JuMP's interfaces to commercial
solvers are maintained by volunteers who find them useful. Pull requests are
always welcomed. Please check out our [contributing guide](https://github.com/jump-dev/JuMP.jl/blob/master/CONTRIBUTING.md).
You can also reach out in the [developer chatroom](https://jump.dev/chatroom)
with questions about how to get started.

## Any concerns?

If you have a conflict or concern that requires resolution, please contact the
[Julia Community Stewards](https://julialang.org/community/stewards/).
