_latex_to_computer_modern = Dict(
    # NOTE there are 4 different size for sqrt from 0x70 to 0x73
    # Maybe we should use them
    raw"√"                         => ("cmex10", 0x70),
    raw"⎷"                         => ("cmex10", 0x73),
    raw"\bigcap"                   => ("cmex10", 0x5c),
    raw"\bigcup"                   => ("cmex10", 0x5b),
    raw"\bigodot"                  => ("cmex10", 0x4b),
    raw"\bigoplus"                 => ("cmex10", 0x4d),
    raw"\bigotimes"                => ("cmex10", 0x4f),
    raw"\biguplus"                 => ("cmex10", 0x5d),
    raw"\bigvee"                   => ("cmex10", 0x5f),
    raw"\bigwedge"                 => ("cmex10", 0x5e),
    raw"\coprod"                   => ("cmex10", 0x61),
    raw"\int"                      => ("cmex10", 0x5a),
    raw"\oint"                     => ("cmex10", 0x49),
    raw"\prod"                     => ("cmex10", 0x59),
    raw"\sum"                      => ("cmex10", 0x58),

    raw","                         => ("cmmi10", 0x3b),
    raw"."                         => ("cmmi10", 0x3a),
    raw"/"                         => ("cmmi10", 0x3d),
    raw"<"                         => ("cmmi10", 0x3c),
    raw">"                         => ("cmmi10", 0x3e),
    raw"\alpha"                    => ("cmmi10", 0xae),
    raw"\beta"                     => ("cmmi10", 0xaf),
    raw"\chi"                      => ("cmmi10", 0xc2),
    raw"\delta"                    => ("cmmi10", 0xb1),
    raw"\ell"                      => ("cmmi10", 0x60),
    raw"\epsilon"                  => ("cmmi10", 0xb2),
    raw"\eta"                      => ("cmmi10", 0xb4),
    raw"\flat"                     => ("cmmi10", 0x5b),
    raw"\frown"                    => ("cmmi10", 0x5f),
    raw"\gamma"                    => ("cmmi10", 0xb0),
    raw"\imath"                    => ("cmmi10", 0x7b),
    raw"\iota"                     => ("cmmi10", 0xb6),
    raw"\jmath"                    => ("cmmi10", 0x7c),
    raw"\kappa"                    => ("cmmi10", 0x2219),
    raw"\lambda"                   => ("cmmi10", 0xb8),
    raw"\leftharpoondown"          => ("cmmi10", 0x29),
    raw"\leftharpoonup"            => ("cmmi10", 0x28),
    raw"\mu"                       => ("cmmi10", 0xb9),
    raw"\natural"                  => ("cmmi10", 0x5c),
    raw"\nu"                       => ("cmmi10", 0xba),
    raw"\omega"                    => ("cmmi10", 0x21),
    raw"\phi"                      => ("cmmi10", 0xc1),
    raw"\pi"                       => ("cmmi10", 0xbc),
    raw"\psi"                      => ("cmmi10", 0xc3),
    raw"\rho"                      => ("cmmi10", 0xbd),
    raw"\rightharpoondown"         => ("cmmi10", 0x2b),
    raw"\rightharpoonup"           => ("cmmi10", 0x2a),
    raw"\sharp"                    => ("cmmi10", 0x5d),
    raw"\sigma"                    => ("cmmi10", 0xbe),
    raw"\smile"                    => ("cmmi10", 0x5e),
    raw"\tau"                      => ("cmmi10", 0xbf),
    raw"\theta"                    => ("cmmi10", 0xb5),
    raw"\triangleleft"             => ("cmmi10", 0x2f),
    raw"\triangleright"            => ("cmmi10", 0x2e),
    raw"\upsilon"                  => ("cmmi10", 0xc0),
    raw"\varepsilon"               => ("cmmi10", 0x22),
    raw"\varphi"                   => ("cmmi10", 0x27),
    raw"\varrho"                   => ("cmmi10", 0x25),
    raw"\varsigma"                 => ("cmmi10", 0x26),
    raw"\vartheta"                 => ("cmmi10", 0x23),
    raw"\wp"                       => ("cmmi10", 0x7d),
    raw"\xi"                       => ("cmmi10", 0xbb),
    raw"\zeta"                     => ("cmmi10", 0xb3),

       "\\"                        => ("cmsy10", 0x6e),

    raw"!"                         => ("cmr10", 0x21),
    raw"%"                         => ("cmr10", 0x25),
    raw"&"                         => ("cmr10", 0x26),
    raw"("                         => ("cmr10", 0x28),
    raw")"                         => ("cmr10", 0x29),
    raw"+"                         => ("cmr10", 0x2b),
    raw"0"                         => ("cmr10", 0x30),
    raw"1"                         => ("cmr10", 0x31),
    raw"2"                         => ("cmr10", 0x32),
    raw"3"                         => ("cmr10", 0x33),
    raw"4"                         => ("cmr10", 0x34),
    raw"5"                         => ("cmr10", 0x35),
    raw"6"                         => ("cmr10", 0x36),
    raw"7"                         => ("cmr10", 0x37),
    raw"8"                         => ("cmr10", 0x38),
    raw"9"                         => ("cmr10", 0x39),
    raw":"                         => ("cmr10", 0x3a),
    raw";"                         => ("cmr10", 0x3b),
    raw"="                         => ("cmr10", 0x3d),
    raw"?"                         => ("cmr10", 0x3f),
    raw"@"                         => ("cmr10", 0x40),
    raw"#"                         => ("cmr10", 0x23),
    raw"$"                         => ("cmr10", 0x24),
    raw"%"                         => ("cmr10", 0x25),
    raw"\Delta"                    => ("cmr10", 0xa2),
    raw"\Gamma"                    => ("cmr10", 0xa1),
    raw"\Lambda"                   => ("cmr10", 0xa4),
    raw"\Omega"                    => ("cmr10", 0xad),
    raw"\Phi"                      => ("cmr10", 0xa9),
    raw"\Pi"                       => ("cmr10", 0xa6),
    raw"\Psi"                      => ("cmr10", 0xaa),
    raw"\Sigma"                    => ("cmr10", 0xa7),
    raw"\Theta"                    => ("cmr10", 0xa3),
    raw"\Upsilon"                  => ("cmr10", 0xa8),
    raw"\Xi"                       => ("cmr10", 0xa5),

    raw"\bar"                      => ("cmr10", 0xb9),
    raw"\hat"                      => ("cmr10", 0x5e),
    raw"\tilde"                    => ("cmr10", 0x7e),
    raw"\vec"                      => ("cmmi10", 0x7e),
    # raw"\combiningacuteaccent"     => ("cmr10", 0xb6),
    # raw"\combiningbreve"           => ("cmr10", 0xb8),
    # raw"\combiningdiaeresis"       => ("cmr10", 0xc4),
    # raw"\combiningdotabove"        => ("cmr10", 0x5f),
    # raw"\combininggraveaccent"     => ("cmr10", 0xb5),
    # raw"\widebar"                  => ("cmr10", 0xb9),
    # raw"\widehat"                  => ("cmex10", 0x62),
    # raw"\widetilde"                => ("cmex10", 0x65),

    raw"["                         => ("cmr10", 0x5b),
    raw"]"                         => ("cmr10", 0x5d),
    raw"("                         => ("cmr10", 0x28),
    raw")"                         => ("cmr10", 0x29),
    raw"{"                         => ("cmex10", 0xa9),
    raw"}"                         => ("cmex10", 0xaa),
    raw"\rceil"                    => ("cmsy10", 0x65),
    raw"\rfloor"                   => ("cmsy10", 0x63),
    raw"\langle"                   => ("cmex10", 0xad),
    raw"\rangle"                   => ("cmex10", 0xae),

    raw"*"                         => ("cmsy10", 0xa4),
    # This is the math minus and not the dash
    raw"−"                         => ("cmsy10", 0xa1),
    raw"\Downarrow"                => ("cmsy10", 0x2b),
    raw"\Im"                       => ("cmsy10", 0x3d),
    raw"\Leftarrow"                => ("cmsy10", 0x28),
    raw"\Leftrightarrow"           => ("cmsy10", 0x2c),
    raw"\P"                        => ("cmsy10", 0x7b),
    raw"\Re"                       => ("cmsy10", 0x3c),
    raw"\Rightarrow"               => ("cmsy10", 0x29),
    raw"\S"                        => ("cmsy10", 0x78),
    raw"\Uparrow"                  => ("cmsy10", 0x2a),
    raw"\Updownarrow"              => ("cmsy10", 0x6d),
    raw"\Vert"                     => ("cmsy10", 0x6b),
    raw"\aleph"                    => ("cmsy10", 0x40),
    raw"\approx"                   => ("cmsy10", 0xbc),
    raw"\ast"                      => ("cmsy10", 0xa4),
    raw"\asymp"                    => ("cmsy10", 0xb3),
    raw"\bigcirc"                  => ("cmsy10", 0xb0),
    raw"\bigtriangledown"          => ("cmsy10", 0x35),
    raw"\bigtriangleup"            => ("cmsy10", 0x34),
    raw"\bot"                      => ("cmsy10", 0x3f),
    raw"\bullet"                   => ("cmsy10", 0xb2),
    raw"\cap"                      => ("cmsy10", 0x5c),
    raw"\cdot"                     => ("cmsy10", 0xa2),
    raw"\circ"                     => ("cmsy10", 0xb1),
    raw"\clubsuit"                 => ("cmsy10", 0x7c),
    raw"\cup"                      => ("cmsy10", 0x5b),
    # raw"\dag"                      => ("cmsy10", 0x79),
    # raw"\ddag"                     => ("cmsy10", 0x7a),
    raw"\dashv"                    => ("cmsy10", 0x61),
    raw"\degree"                   => ("cmr10", 0xba),
    raw"\diamond"                  => ("cmsy10", 0xa6),
    raw"\diamondsuit"              => ("cmsy10", 0x7d),
    raw"\div"                      => ("cmsy10", 0xa5),
    raw"\downarrow"                => ("cmsy10", 0x23),
    raw"\emptyset"                 => ("cmsy10", 0x3b),
    raw"\equiv"                    => ("cmsy10", 0xb4),
    raw"\exists"                   => ("cmsy10", 0x39),
    raw"\forall"                   => ("cmsy10", 0x38),
    raw"\geq"                      => ("cmsy10", 0xb8),
    raw"\gg"                       => ("cmsy10", 0xc0),
    raw"\heartsuit"                => ("cmsy10", 0x7e),
    raw"\in"                       => ("cmsy10", 0x32),
    raw"\infty"                    => ("cmsy10", 0x31),
    raw"\lceil"                    => ("cmsy10", 0x64),
    raw"\leftarrow"                => ("cmsy10", 0xc3),
    raw"\leftrightarrow"           => ("cmsy10", 0x24),
    raw"\leq"                      => ("cmsy10", 0x2219),
    raw"\lfloor"                   => ("cmsy10", 0x62),
    raw"\ll"                       => ("cmsy10", 0xbf),
    raw"\mid"                      => ("cmsy10", 0x6a),
    raw"\mp"                       => ("cmsy10", 0xa8),
    raw"\nabla"                    => ("cmsy10", 0x72),
    raw"\nearrow"                  => ("cmsy10", 0x25),
    raw"\neg"                      => ("cmsy10", 0x3a),
    raw"\ni"                       => ("cmsy10", 0x33),
    raw"\nwarrow"                  => ("cmsy10", 0x2d),
    raw"\odot"                     => ("cmsy10", 0xaf),
    raw"\ominus"                   => ("cmsy10", 0xaa),
    raw"\oplus"                    => ("cmsy10", 0xa9),
    raw"\oslash"                   => ("cmsy10", 0xae),
    raw"\otimes"                   => ("cmsy10", 0xad),
    raw"\pm"                       => ("cmsy10", 0xa7),
    raw"\partial"                  => ("cmmi10", 0x40),
    raw"\prec"                     => ("cmsy10", 0xc1),
    raw"\preceq"                   => ("cmsy10", 0xb9),
    raw"\prime"                    => ("cmsy10", 0x30),
    raw"\propto"                   => ("cmsy10", 0x2f),
    raw"\rightarrow"               => ("cmsy10", 0x21),
    raw"\searrow"                  => ("cmsy10", 0x26),
    raw"\sim"                      => ("cmsy10", 0xbb),
    raw"\simeq"                    => ("cmsy10", 0x27),
    raw"\spadesuit"                => ("cmsy10", 0xc4),
    raw"\sqcap"                    => ("cmsy10", 0x75),
    raw"\sqcup"                    => ("cmsy10", 0x74),
    raw"\sqsubseteq"               => ("cmsy10", 0x76),
    raw"\sqsupseteq"               => ("cmsy10", 0x77),
    raw"\subset"                   => ("cmsy10", 0xbd),
    raw"\subseteq"                 => ("cmsy10", 0xb5),
    raw"\succ"                     => ("cmsy10", 0xc2),
    raw"\succeq"                   => ("cmsy10", 0xba),
    raw"\supset"                   => ("cmsy10", 0xbe),
    raw"\supseteq"                 => ("cmsy10", 0xb6),
    raw"\swarrow"                  => ("cmsy10", 0x2e),
    raw"\times"                    => ("cmsy10", 0xa3),
    raw"\to"                       => ("cmsy10", 0x21),
    raw"\top"                      => ("cmsy10", 0x3e),
    raw"\uparrow"                  => ("cmsy10", 0x22),
    raw"\updownarrow"              => ("cmsy10", 0x6c),
    raw"\uplus"                    => ("cmsy10", 0x5d),
    raw"\vdash"                    => ("cmsy10", 0x60),
    raw"\vee"                      => ("cmsy10", 0x5f),
    raw"\wedge"                    => ("cmsy10", 0x5e),
    raw"\wr"                       => ("cmsy10", 0x6f),
    raw"|"                         => ("cmsy10", 0x6a),
    raw"_"                         => ("cmtt10", 0x5f)
)


_symbol_to_computer_modern = Dict{Char, Tuple{String, Int}}()

for (symbol, (fontname, glyph_id)) in _latex_to_computer_modern
    if haskey(latex_symbols, symbol)
        symbol = latex_symbols[symbol][1]
    else
        symbol = symbol[1]
    end
    
    fontpath = joinpath("ComputerModern", "$fontname.ttf")
    _symbol_to_computer_modern[symbol] = (fontpath, glyph_id)
end
