# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_kanidm_unix_global_optspecs
	string join \n h/help
end

function __fish_kanidm_unix_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_kanidm_unix_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_kanidm_unix_using_subcommand
	set -l cmd (__fish_kanidm_unix_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -s h -l help -d 'Print help'
complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -f -a "auth-test" -d 'Test authentication of a user via the unixd resolver "pam" channel. This does not test that your pam configuration is correct - only that unixd is correctly processing and validating authentications'
complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -f -a "cache-clear" -d 'Erase the content of the unixd resolver cache. You should probably use `invalidate` instead'
complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -f -a "cache-invalidate" -d 'Invalidate, but don\'t erase the content of the unixd resolver cache. This will force the unixd daemon to refresh all user and group content immediately. If the connection is offline, entries will still be available and will be refreshed as soon as the daemon is online again'
complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -f -a "status" -d 'Check that the unixd daemon is online and able to connect correctly to the kanidmd server'
complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -f -a "version" -d 'Show the version of this tool'
complete -c kanidm_unix -n "__fish_kanidm_unix_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand auth-test" -s D -l name -r
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand auth-test" -s d -l debug
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand auth-test" -s h -l help -d 'Print help'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand cache-clear" -s d -l debug
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand cache-clear" -l really
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand cache-clear" -s h -l help -d 'Print help'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand cache-invalidate" -s d -l debug
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand cache-invalidate" -s h -l help -d 'Print help'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand status" -s d -l debug
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand status" -s h -l help -d 'Print help'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand version" -s d -l debug
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand version" -s h -l help -d 'Print help'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand help; and not __fish_seen_subcommand_from auth-test cache-clear cache-invalidate status version help" -f -a "auth-test" -d 'Test authentication of a user via the unixd resolver "pam" channel. This does not test that your pam configuration is correct - only that unixd is correctly processing and validating authentications'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand help; and not __fish_seen_subcommand_from auth-test cache-clear cache-invalidate status version help" -f -a "cache-clear" -d 'Erase the content of the unixd resolver cache. You should probably use `invalidate` instead'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand help; and not __fish_seen_subcommand_from auth-test cache-clear cache-invalidate status version help" -f -a "cache-invalidate" -d 'Invalidate, but don\'t erase the content of the unixd resolver cache. This will force the unixd daemon to refresh all user and group content immediately. If the connection is offline, entries will still be available and will be refreshed as soon as the daemon is online again'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand help; and not __fish_seen_subcommand_from auth-test cache-clear cache-invalidate status version help" -f -a "status" -d 'Check that the unixd daemon is online and able to connect correctly to the kanidmd server'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand help; and not __fish_seen_subcommand_from auth-test cache-clear cache-invalidate status version help" -f -a "version" -d 'Show the version of this tool'
complete -c kanidm_unix -n "__fish_kanidm_unix_using_subcommand help; and not __fish_seen_subcommand_from auth-test cache-clear cache-invalidate status version help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
