// clang-format off
// NOLINTBEGIN
#include <QRegularExpression>
#include <QString>
struct Completion {
    const char16_t *completion;
    const char16_t *codepoint;
    const char16_t *chars;
    const char16_t *name;
    const uint16_t completion_strlen;
};

static constexpr uint16_t n_completions = 3329;

static constexpr Completion completiontable[] = {
    {u"\\0/3", u"U+02189", u"↉", u"Vulgar Fraction Zero Thirds", 4},
    {u"\\1/", u"U+0215F", u"⅟", u"Fraction Numerator One", 3},
    {u"\\1/10", u"U+02152", u"⅒", u"Vulgar Fraction One Tenth", 5},
    {u"\\1/2", u"U+000BD", u"½", u"Vulgar Fraction One Half / Fraction One Half", 4},
    {u"\\1/3", u"U+02153", u"⅓", u"Vulgar Fraction One Third / Fraction One Third", 4},
    {u"\\1/4", u"U+000BC", u"¼", u"Vulgar Fraction One Quarter / Fraction One Quarter", 4},
    {u"\\1/5", u"U+02155", u"⅕", u"Vulgar Fraction One Fifth / Fraction One Fifth", 4},
    {u"\\1/6", u"U+02159", u"⅙", u"Vulgar Fraction One Sixth / Fraction One Sixth", 4},
    {u"\\1/7", u"U+02150", u"⅐", u"Vulgar Fraction One Seventh", 4},
    {u"\\1/8", u"U+0215B", u"⅛", u"Vulgar Fraction One Eighth / Fraction One Eighth", 4},
    {u"\\1/9", u"U+02151", u"⅑", u"Vulgar Fraction One Ninth", 4},
    {u"\\2/3", u"U+02154", u"⅔", u"Vulgar Fraction Two Thirds / Fraction Two Thirds", 4},
    {u"\\2/5", u"U+02156", u"⅖", u"Vulgar Fraction Two Fifths / Fraction Two Fifths", 4},
    {u"\\3/4", u"U+000BE", u"¾", u"Vulgar Fraction Three Quarters / Fraction Three Quarters", 4},
    {u"\\3/5", u"U+02157", u"⅗", u"Vulgar Fraction Three Fifths / Fraction Three Fifths", 4},
    {u"\\3/8", u"U+0215C", u"⅜", u"Vulgar Fraction Three Eighths / Fraction Three Eighths", 4},
    {u"\\4/5", u"U+02158", u"⅘", u"Vulgar Fraction Four Fifths / Fraction Four Fifths", 4},
    {u"\\5/6", u"U+0215A", u"⅚", u"Vulgar Fraction Five Sixths / Fraction Five Sixths", 4},
    {u"\\5/8", u"U+0215D", u"⅝", u"Vulgar Fraction Five Eighths / Fraction Five Eighths", 4},
    {u"\\7/8", u"U+0215E", u"⅞", u"Vulgar Fraction Seven Eighths / Fraction Seven Eighths", 4},
    {u"\\:+1:", u"U+1F44D", u"👍", u"Thumbs Up Sign", 5},
    {u"\\:-1:", u"U+1F44E", u"👎", u"Thumbs Down Sign", 5},
    {u"\\:100:", u"U+1F4AF", u"💯", u"Hundred Points Symbol", 6},
    {u"\\:1234:", u"U+1F522", u"🔢", u"Input Symbol For Numbers", 7},
    {u"\\:8ball:", u"U+1F3B1", u"🎱", u"Billiards", 8},
    {u"\\:a:", u"U+1F170", u"🅰", u"Negative Squared Latin Capital Letter A", 4},
    {u"\\:ab:", u"U+1F18E", u"🆎", u"Negative Squared Ab", 5},
    {u"\\:abc:", u"U+1F524", u"🔤", u"Input Symbol For Latin Letters", 6},
    {u"\\:abcd:", u"U+1F521", u"🔡", u"Input Symbol For Latin Small Letters", 7},
    {u"\\:accept:", u"U+1F251", u"🉑", u"Circled Ideograph Accept", 9},
    {u"\\:aerial_tramway:", u"U+1F6A1", u"🚡", u"Aerial Tramway", 17},
    {u"\\:airplane:", u"U+02708", u"✈", u"Airplane", 11},
    {u"\\:alarm_clock:", u"U+023F0", u"⏰", u"Alarm Clock", 14},
    {u"\\:alien:", u"U+1F47D", u"👽", u"Extraterrestrial Alien", 8},
    {u"\\:ambulance:", u"U+1F691", u"🚑", u"Ambulance", 12},
    {u"\\:anchor:", u"U+02693", u"⚓", u"Anchor", 9},
    {u"\\:angel:", u"U+1F47C", u"👼", u"Baby Angel", 8},
    {u"\\:anger:", u"U+1F4A2", u"💢", u"Anger Symbol", 8},
    {u"\\:angry:", u"U+1F620", u"😠", u"Angry Face", 8},
    {u"\\:anguished:", u"U+1F627", u"😧", u"Anguished Face", 12},
    {u"\\:ant:", u"U+1F41C", u"🐜", u"Ant", 6},
    {u"\\:apple:", u"U+1F34E", u"🍎", u"Red Apple", 8},
    {u"\\:aquarius:", u"U+02652", u"♒", u"Aquarius", 11},
    {u"\\:aries:", u"U+02648", u"♈", u"Aries", 8},
    {u"\\:arrow_backward:", u"U+025C0", u"◀", u"Black Left-Pointing Triangle / Black Left Pointing Triangle", 17},
    {u"\\:arrow_double_down:", u"U+023EC", u"⏬", u"Black Down-Pointing Double Triangle", 20},
    {u"\\:arrow_double_up:", u"U+023EB", u"⏫", u"Black Up-Pointing Double Triangle", 18},
    {u"\\:arrow_down:", u"U+02B07", u"⬇", u"Downwards Black Arrow", 13},
    {u"\\:arrow_down_small:", u"U+1F53D", u"🔽", u"Down-Pointing Small Red Triangle", 19},
    {u"\\:arrow_forward:", u"U+025B6", u"▶", u"Black Right-Pointing Triangle / Black Right Pointing Triangle", 16},
    {u"\\:arrow_heading_down:", u"U+02935", u"⤵", u"Arrow Pointing Rightwards Then Curving Downwards", 21},
    {u"\\:arrow_heading_up:", u"U+02934", u"⤴", u"Arrow Pointing Rightwards Then Curving Upwards", 19},
    {u"\\:arrow_left:", u"U+02B05", u"⬅", u"Leftwards Black Arrow", 13},
    {u"\\:arrow_lower_left:", u"U+02199", u"↙", u"South West Arrow / Lower Left Arrow", 19},
    {u"\\:arrow_lower_right:", u"U+02198", u"↘", u"South East Arrow / Lower Right Arrow", 20},
    {u"\\:arrow_right:", u"U+027A1", u"➡", u"Black Rightwards Arrow / Black Right Arrow", 14},
    {u"\\:arrow_right_hook:", u"U+021AA", u"↪", u"Rightwards Arrow With Hook / Right Arrow With Hook", 19},
    {u"\\:arrow_up:", u"U+02B06", u"⬆", u"Upwards Black Arrow", 11},
    {u"\\:arrow_up_down:", u"U+02195", u"↕", u"Up Down Arrow", 16},
    {u"\\:arrow_up_small:", u"U+1F53C", u"🔼", u"Up-Pointing Small Red Triangle", 17},
    {u"\\:arrow_upper_left:", u"U+02196", u"↖", u"North West Arrow / Upper Left Arrow", 19},
    {u"\\:arrow_upper_right:", u"U+02197", u"↗", u"North East Arrow / Upper Right Arrow", 20},
    {u"\\:arrows_clockwise:", u"U+1F503", u"🔃", u"Clockwise Downwards And Upwards Open Circle Arrows", 19},
    {u"\\:arrows_counterclockwise:", u"U+1F504", u"🔄", u"Anticlockwise Downwards And Upwards Open Circle Arrows", 26},
    {u"\\:art:", u"U+1F3A8", u"🎨", u"Artist Palette", 6},
    {u"\\:articulated_lorry:", u"U+1F69B", u"🚛", u"Articulated Lorry", 20},
    {u"\\:astonished:", u"U+1F632", u"😲", u"Astonished Face", 13},
    {u"\\:athletic_shoe:", u"U+1F45F", u"👟", u"Athletic Shoe", 16},
    {u"\\:atm:", u"U+1F3E7", u"🏧", u"Automated Teller Machine", 6},
    {u"\\:b:", u"U+1F171", u"🅱", u"Negative Squared Latin Capital Letter B", 4},
    {u"\\:baby:", u"U+1F476", u"👶", u"Baby", 7},
    {u"\\:baby_bottle:", u"U+1F37C", u"🍼", u"Baby Bottle", 14},
    {u"\\:baby_chick:", u"U+1F424", u"🐤", u"Baby Chick", 13},
    {u"\\:baby_symbol:", u"U+1F6BC", u"🚼", u"Baby Symbol", 14},
    {u"\\:back:", u"U+1F519", u"🔙", u"Back With Leftwards Arrow Above", 7},
    {u"\\:baggage_claim:", u"U+1F6C4", u"🛄", u"Baggage Claim", 16},
    {u"\\:balloon:", u"U+1F388", u"🎈", u"Balloon", 10},
    {u"\\:ballot_box_with_check:", u"U+02611", u"☑", u"Ballot Box With Check", 24},
    {u"\\:bamboo:", u"U+1F38D", u"🎍", u"Pine Decoration", 9},
    {u"\\:banana:", u"U+1F34C", u"🍌", u"Banana", 9},
    {u"\\:bangbang:", u"U+0203C", u"‼", u"Double Exclamation Mark", 11},
    {u"\\:bank:", u"U+1F3E6", u"🏦", u"Bank", 7},
    {u"\\:bar_chart:", u"U+1F4CA", u"📊", u"Bar Chart", 12},
    {u"\\:barber:", u"U+1F488", u"💈", u"Barber Pole", 9},
    {u"\\:baseball:", u"U+026BE", u"⚾", u"Baseball", 11},
    {u"\\:basketball:", u"U+1F3C0", u"🏀", u"Basketball And Hoop", 13},
    {u"\\:bath:", u"U+1F6C0", u"🛀", u"Bath", 7},
    {u"\\:bathtub:", u"U+1F6C1", u"🛁", u"Bathtub", 10},
    {u"\\:battery:", u"U+1F50B", u"🔋", u"Battery", 10},
    {u"\\:bear:", u"U+1F43B", u"🐻", u"Bear Face", 7},
    {u"\\:bee:", u"U+1F41D", u"🐝", u"Honeybee", 6},
    {u"\\:beer:", u"U+1F37A", u"🍺", u"Beer Mug", 7},
    {u"\\:beers:", u"U+1F37B", u"🍻", u"Clinking Beer Mugs", 8},
    {u"\\:beetle:", u"U+1F41E", u"🐞", u"Lady Beetle", 9},
    {u"\\:beginner:", u"U+1F530", u"🔰", u"Japanese Symbol For Beginner", 11},
    {u"\\:bell:", u"U+1F514", u"🔔", u"Bell", 7},
    {u"\\:bento:", u"U+1F371", u"🍱", u"Bento Box", 8},
    {u"\\:bicyclist:", u"U+1F6B4", u"🚴", u"Bicyclist", 12},
    {u"\\:bike:", u"U+1F6B2", u"🚲", u"Bicycle", 7},
    {u"\\:bikini:", u"U+1F459", u"👙", u"Bikini", 9},
    {u"\\:bird:", u"U+1F426", u"🐦", u"Bird", 7},
    {u"\\:birthday:", u"U+1F382", u"🎂", u"Birthday Cake", 11},
    {u"\\:black_circle:", u"U+026AB", u"⚫", u"Medium Black Circle", 15},
    {u"\\:black_joker:", u"U+1F0CF", u"🃏", u"Playing Card Black Joker", 14},
    {u"\\:black_large_square:", u"U+02B1B", u"⬛", u"Black Large Square", 21},
    {u"\\:black_medium_small_square:", u"U+025FE", u"◾", u"Black Medium Small Square", 28},
    {u"\\:black_medium_square:", u"U+025FC", u"◼", u"Black Medium Square", 22},
    {u"\\:black_nib:", u"U+02712", u"✒", u"Black Nib", 12},
    {u"\\:black_small_square:", u"U+025AA", u"▪", u"Black Small Square", 21},
    {u"\\:black_square_button:", u"U+1F532", u"🔲", u"Black Square Button", 22},
    {u"\\:blossom:", u"U+1F33C", u"🌼", u"Blossom", 10},
    {u"\\:blowfish:", u"U+1F421", u"🐡", u"Blowfish", 11},
    {u"\\:blue_book:", u"U+1F4D8", u"📘", u"Blue Book", 12},
    {u"\\:blue_car:", u"U+1F699", u"🚙", u"Recreational Vehicle", 11},
    {u"\\:blue_heart:", u"U+1F499", u"💙", u"Blue Heart", 13},
    {u"\\:blush:", u"U+1F60A", u"😊", u"Smiling Face With Smiling Eyes", 8},
    {u"\\:boar:", u"U+1F417", u"🐗", u"Boar", 7},
    {u"\\:boat:", u"U+026F5", u"⛵", u"Sailboat", 7},
    {u"\\:bomb:", u"U+1F4A3", u"💣", u"Bomb", 7},
    {u"\\:book:", u"U+1F4D6", u"📖", u"Open Book", 7},
    {u"\\:bookmark:", u"U+1F516", u"🔖", u"Bookmark", 11},
    {u"\\:bookmark_tabs:", u"U+1F4D1", u"📑", u"Bookmark Tabs", 16},
    {u"\\:books:", u"U+1F4DA", u"📚", u"Books", 8},
    {u"\\:boom:", u"U+1F4A5", u"💥", u"Collision Symbol", 7},
    {u"\\:boot:", u"U+1F462", u"👢", u"Womans Boots", 7},
    {u"\\:bouquet:", u"U+1F490", u"💐", u"Bouquet", 10},
    {u"\\:bow:", u"U+1F647", u"🙇", u"Person Bowing Deeply", 6},
    {u"\\:bowling:", u"U+1F3B3", u"🎳", u"Bowling", 10},
    {u"\\:boy:", u"U+1F466", u"👦", u"Boy", 6},
    {u"\\:bread:", u"U+1F35E", u"🍞", u"Bread", 8},
    {u"\\:bride_with_veil:", u"U+1F470", u"👰", u"Bride With Veil", 18},
    {u"\\:bridge_at_night:", u"U+1F309", u"🌉", u"Bridge At Night", 18},
    {u"\\:briefcase:", u"U+1F4BC", u"💼", u"Briefcase", 12},
    {u"\\:broken_heart:", u"U+1F494", u"💔", u"Broken Heart", 15},
    {u"\\:bug:", u"U+1F41B", u"🐛", u"Bug", 6},
    {u"\\:bulb:", u"U+1F4A1", u"💡", u"Electric Light Bulb", 7},
    {u"\\:bullettrain_front:", u"U+1F685", u"🚅", u"High-Speed Train With Bullet Nose", 20},
    {u"\\:bullettrain_side:", u"U+1F684", u"🚄", u"High-Speed Train", 19},
    {u"\\:bus:", u"U+1F68C", u"🚌", u"Bus", 6},
    {u"\\:busstop:", u"U+1F68F", u"🚏", u"Bus Stop", 10},
    {u"\\:bust_in_silhouette:", u"U+1F464", u"👤", u"Bust In Silhouette", 21},
    {u"\\:busts_in_silhouette:", u"U+1F465", u"👥", u"Busts In Silhouette", 22},
    {u"\\:cactus:", u"U+1F335", u"🌵", u"Cactus", 9},
    {u"\\:cake:", u"U+1F370", u"🍰", u"Shortcake", 7},
    {u"\\:calendar:", u"U+1F4C6", u"📆", u"Tear-Off Calendar", 11},
    {u"\\:calling:", u"U+1F4F2", u"📲", u"Mobile Phone With Rightwards Arrow At Left", 10},
    {u"\\:camel:", u"U+1F42B", u"🐫", u"Bactrian Camel", 8},
    {u"\\:camera:", u"U+1F4F7", u"📷", u"Camera", 9},
    {u"\\:cancer:", u"U+0264B", u"♋", u"Cancer", 9},
    {u"\\:candy:", u"U+1F36C", u"🍬", u"Candy", 8},
    {u"\\:capital_abcd:", u"U+1F520", u"🔠", u"Input Symbol For Latin Capital Letters", 15},
    {u"\\:capricorn:", u"U+02651", u"♑", u"Capricorn", 12},
    {u"\\:car:", u"U+1F697", u"🚗", u"Automobile", 6},
    {u"\\:card_index:", u"U+1F4C7", u"📇", u"Card Index", 13},
    {u"\\:carousel_horse:", u"U+1F3A0", u"🎠", u"Carousel Horse", 17},
    {u"\\:cat2:", u"U+1F408", u"🐈", u"Cat", 7},
    {u"\\:cat:", u"U+1F431", u"🐱", u"Cat Face", 6},
    {u"\\:cd:", u"U+1F4BF", u"💿", u"Optical Disc", 5},
    {u"\\:chart:", u"U+1F4B9", u"💹", u"Chart With Upwards Trend And Yen Sign", 8},
    {u"\\:chart_with_downwards_trend:", u"U+1F4C9", u"📉", u"Chart With Downwards Trend", 29},
    {u"\\:chart_with_upwards_trend:", u"U+1F4C8", u"📈", u"Chart With Upwards Trend", 27},
    {u"\\:checkered_flag:", u"U+1F3C1", u"🏁", u"Chequered Flag", 17},
    {u"\\:cherries:", u"U+1F352", u"🍒", u"Cherries", 11},
    {u"\\:cherry_blossom:", u"U+1F338", u"🌸", u"Cherry Blossom", 17},
    {u"\\:chestnut:", u"U+1F330", u"🌰", u"Chestnut", 11},
    {u"\\:chicken:", u"U+1F414", u"🐔", u"Chicken", 10},
    {u"\\:children_crossing:", u"U+1F6B8", u"🚸", u"Children Crossing", 20},
    {u"\\:chocolate_bar:", u"U+1F36B", u"🍫", u"Chocolate Bar", 16},
    {u"\\:christmas_tree:", u"U+1F384", u"🎄", u"Christmas Tree", 17},
    {u"\\:church:", u"U+026EA", u"⛪", u"Church", 9},
    {u"\\:cinema:", u"U+1F3A6", u"🎦", u"Cinema", 9},
    {u"\\:circus_tent:", u"U+1F3AA", u"🎪", u"Circus Tent", 14},
    {u"\\:city_sunrise:", u"U+1F307", u"🌇", u"Sunset Over Buildings", 15},
    {u"\\:city_sunset:", u"U+1F306", u"🌆", u"Cityscape At Dusk", 14},
    {u"\\:cl:", u"U+1F191", u"🆑", u"Squared Cl", 5},
    {u"\\:clap:", u"U+1F44F", u"👏", u"Clapping Hands Sign", 7},
    {u"\\:clapper:", u"U+1F3AC", u"🎬", u"Clapper Board", 10},
    {u"\\:clipboard:", u"U+1F4CB", u"📋", u"Clipboard", 12},
    {u"\\:clock1030:", u"U+1F565", u"🕥", u"Clock Face Ten-Thirty", 12},
    {u"\\:clock10:", u"U+1F559", u"🕙", u"Clock Face Ten Oclock", 10},
    {u"\\:clock1130:", u"U+1F566", u"🕦", u"Clock Face Eleven-Thirty", 12},
    {u"\\:clock11:", u"U+1F55A", u"🕚", u"Clock Face Eleven Oclock", 10},
    {u"\\:clock1230:", u"U+1F567", u"🕧", u"Clock Face Twelve-Thirty", 12},
    {u"\\:clock12:", u"U+1F55B", u"🕛", u"Clock Face Twelve Oclock", 10},
    {u"\\:clock130:", u"U+1F55C", u"🕜", u"Clock Face One-Thirty", 11},
    {u"\\:clock1:", u"U+1F550", u"🕐", u"Clock Face One Oclock", 9},
    {u"\\:clock230:", u"U+1F55D", u"🕝", u"Clock Face Two-Thirty", 11},
    {u"\\:clock2:", u"U+1F551", u"🕑", u"Clock Face Two Oclock", 9},
    {u"\\:clock330:", u"U+1F55E", u"🕞", u"Clock Face Three-Thirty", 11},
    {u"\\:clock3:", u"U+1F552", u"🕒", u"Clock Face Three Oclock", 9},
    {u"\\:clock430:", u"U+1F55F", u"🕟", u"Clock Face Four-Thirty", 11},
    {u"\\:clock4:", u"U+1F553", u"🕓", u"Clock Face Four Oclock", 9},
    {u"\\:clock530:", u"U+1F560", u"🕠", u"Clock Face Five-Thirty", 11},
    {u"\\:clock5:", u"U+1F554", u"🕔", u"Clock Face Five Oclock", 9},
    {u"\\:clock630:", u"U+1F561", u"🕡", u"Clock Face Six-Thirty", 11},
    {u"\\:clock6:", u"U+1F555", u"🕕", u"Clock Face Six Oclock", 9},
    {u"\\:clock730:", u"U+1F562", u"🕢", u"Clock Face Seven-Thirty", 11},
    {u"\\:clock7:", u"U+1F556", u"🕖", u"Clock Face Seven Oclock", 9},
    {u"\\:clock830:", u"U+1F563", u"🕣", u"Clock Face Eight-Thirty", 11},
    {u"\\:clock8:", u"U+1F557", u"🕗", u"Clock Face Eight Oclock", 9},
    {u"\\:clock930:", u"U+1F564", u"🕤", u"Clock Face Nine-Thirty", 11},
    {u"\\:clock9:", u"U+1F558", u"🕘", u"Clock Face Nine Oclock", 9},
    {u"\\:closed_book:", u"U+1F4D5", u"📕", u"Closed Book", 14},
    {u"\\:closed_lock_with_key:", u"U+1F510", u"🔐", u"Closed Lock With Key", 23},
    {u"\\:closed_umbrella:", u"U+1F302", u"🌂", u"Closed Umbrella", 18},
    {u"\\:cloud:", u"U+02601", u"☁", u"Cloud", 8},
    {u"\\:clubs:", u"U+02663", u"♣", u"Black Club Suit", 8},
    {u"\\:cocktail:", u"U+1F378", u"🍸", u"Cocktail Glass", 11},
    {u"\\:coffee:", u"U+02615", u"☕", u"Hot Beverage", 9},
    {u"\\:cold_sweat:", u"U+1F630", u"😰", u"Face With Open Mouth And Cold Sweat", 13},
    {u"\\:computer:", u"U+1F4BB", u"💻", u"Personal Computer", 11},
    {u"\\:confetti_ball:", u"U+1F38A", u"🎊", u"Confetti Ball", 16},
    {u"\\:confounded:", u"U+1F616", u"😖", u"Confounded Face", 13},
    {u"\\:confused:", u"U+1F615", u"😕", u"Confused Face", 11},
    {u"\\:congratulations:", u"U+03297", u"㊗", u"Circled Ideograph Congratulation", 18},
    {u"\\:construction:", u"U+1F6A7", u"🚧", u"Construction Sign", 15},
    {u"\\:construction_worker:", u"U+1F477", u"👷", u"Construction Worker", 22},
    {u"\\:convenience_store:", u"U+1F3EA", u"🏪", u"Convenience Store", 20},
    {u"\\:cookie:", u"U+1F36A", u"🍪", u"Cookie", 9},
    {u"\\:cool:", u"U+1F192", u"🆒", u"Squared Cool", 7},
    {u"\\:cop:", u"U+1F46E", u"👮", u"Police Officer", 6},
    {u"\\:copyright:", u"U+000A9", u"©", u"Copyright Sign", 12},
    {u"\\:corn:", u"U+1F33D", u"🌽", u"Ear Of Maize", 7},
    {u"\\:couple:", u"U+1F46B", u"👫", u"Man And Woman Holding Hands", 9},
    {u"\\:couple_with_heart:", u"U+1F491", u"💑", u"Couple With Heart", 20},
    {u"\\:couplekiss:", u"U+1F48F", u"💏", u"Kiss", 13},
    {u"\\:cow2:", u"U+1F404", u"🐄", u"Cow", 7},
    {u"\\:cow:", u"U+1F42E", u"🐮", u"Cow Face", 6},
    {u"\\:credit_card:", u"U+1F4B3", u"💳", u"Credit Card", 14},
    {u"\\:crescent_moon:", u"U+1F319", u"🌙", u"Crescent Moon", 16},
    {u"\\:crocodile:", u"U+1F40A", u"🐊", u"Crocodile", 12},
    {u"\\:crossed_flags:", u"U+1F38C", u"🎌", u"Crossed Flags", 16},
    {u"\\:crown:", u"U+1F451", u"👑", u"Crown", 8},
    {u"\\:cry:", u"U+1F622", u"😢", u"Crying Face", 6},
    {u"\\:crying_cat_face:", u"U+1F63F", u"😿", u"Crying Cat Face", 18},
    {u"\\:crystal_ball:", u"U+1F52E", u"🔮", u"Crystal Ball", 15},
    {u"\\:cupid:", u"U+1F498", u"💘", u"Heart With Arrow", 8},
    {u"\\:curly_loop:", u"U+027B0", u"➰", u"Curly Loop", 13},
    {u"\\:currency_exchange:", u"U+1F4B1", u"💱", u"Currency Exchange", 20},
    {u"\\:curry:", u"U+1F35B", u"🍛", u"Curry And Rice", 8},
    {u"\\:custard:", u"U+1F36E", u"🍮", u"Custard", 10},
    {u"\\:customs:", u"U+1F6C3", u"🛃", u"Customs", 10},
    {u"\\:cyclone:", u"U+1F300", u"🌀", u"Cyclone", 10},
    {u"\\:dancer:", u"U+1F483", u"💃", u"Dancer", 9},
    {u"\\:dancers:", u"U+1F46F", u"👯", u"Woman With Bunny Ears", 10},
    {u"\\:dango:", u"U+1F361", u"🍡", u"Dango", 8},
    {u"\\:dart:", u"U+1F3AF", u"🎯", u"Direct Hit", 7},
    {u"\\:dash:", u"U+1F4A8", u"💨", u"Dash Symbol", 7},
    {u"\\:date:", u"U+1F4C5", u"📅", u"Calendar", 7},
    {u"\\:deciduous_tree:", u"U+1F333", u"🌳", u"Deciduous Tree", 17},
    {u"\\:department_store:", u"U+1F3EC", u"🏬", u"Department Store", 19},
    {u"\\:diamond_shape_with_a_dot_inside:", u"U+1F4A0", u"💠", u"Diamond Shape With A Dot Inside", 34},
    {u"\\:diamonds:", u"U+02666", u"♦", u"Black Diamond Suit", 11},
    {u"\\:disappointed:", u"U+1F61E", u"😞", u"Disappointed Face", 15},
    {u"\\:disappointed_relieved:", u"U+1F625", u"😥", u"Disappointed But Relieved Face", 24},
    {u"\\:dizzy:", u"U+1F4AB", u"💫", u"Dizzy Symbol", 8},
    {u"\\:dizzy_face:", u"U+1F635", u"😵", u"Dizzy Face", 13},
    {u"\\:do_not_litter:", u"U+1F6AF", u"🚯", u"Do Not Litter Symbol", 16},
    {u"\\:dog2:", u"U+1F415", u"🐕", u"Dog", 7},
    {u"\\:dog:", u"U+1F436", u"🐶", u"Dog Face", 6},
    {u"\\:dollar:", u"U+1F4B5", u"💵", u"Banknote With Dollar Sign", 9},
    {u"\\:dolls:", u"U+1F38E", u"🎎", u"Japanese Dolls", 8},
    {u"\\:dolphin:", u"U+1F42C", u"🐬", u"Dolphin", 10},
    {u"\\:door:", u"U+1F6AA", u"🚪", u"Door", 7},
    {u"\\:doughnut:", u"U+1F369", u"🍩", u"Doughnut", 11},
    {u"\\:dragon:", u"U+1F409", u"🐉", u"Dragon", 9},
    {u"\\:dragon_face:", u"U+1F432", u"🐲", u"Dragon Face", 14},
    {u"\\:dress:", u"U+1F457", u"👗", u"Dress", 8},
    {u"\\:dromedary_camel:", u"U+1F42A", u"🐪", u"Dromedary Camel", 18},
    {u"\\:droplet:", u"U+1F4A7", u"💧", u"Droplet", 10},
    {u"\\:dvd:", u"U+1F4C0", u"📀", u"Dvd", 6},
    {u"\\:e-mail:", u"U+1F4E7", u"📧", u"E-Mail Symbol", 9},
    {u"\\:ear:", u"U+1F442", u"👂", u"Ear", 6},
    {u"\\:ear_of_rice:", u"U+1F33E", u"🌾", u"Ear Of Rice", 14},
    {u"\\:earth_africa:", u"U+1F30D", u"🌍", u"Earth Globe Europe-Africa", 15},
    {u"\\:earth_americas:", u"U+1F30E", u"🌎", u"Earth Globe Americas", 17},
    {u"\\:earth_asia:", u"U+1F30F", u"🌏", u"Earth Globe Asia-Australia", 13},
    {u"\\:egg:", u"U+1F373", u"🍳", u"Cooking", 6},
    {u"\\:eggplant:", u"U+1F346", u"🍆", u"Aubergine", 11},
    {u"\\:eight_pointed_black_star:", u"U+02734", u"✴", u"Eight Pointed Black Star", 27},
    {u"\\:eight_spoked_asterisk:", u"U+02733", u"✳", u"Eight Spoked Asterisk", 24},
    {u"\\:electric_plug:", u"U+1F50C", u"🔌", u"Electric Plug", 16},
    {u"\\:elephant:", u"U+1F418", u"🐘", u"Elephant", 11},
    {u"\\:email:", u"U+02709", u"✉", u"Envelope", 8},
    {u"\\:end:", u"U+1F51A", u"🔚", u"End With Leftwards Arrow Above", 6},
    {u"\\:envelope_with_arrow:", u"U+1F4E9", u"📩", u"Envelope With Downwards Arrow Above", 22},
    {u"\\:euro:", u"U+1F4B6", u"💶", u"Banknote With Euro Sign", 7},
    {u"\\:european_castle:", u"U+1F3F0", u"🏰", u"European Castle", 18},
    {u"\\:european_post_office:", u"U+1F3E4", u"🏤", u"European Post Office", 23},
    {u"\\:evergreen_tree:", u"U+1F332", u"🌲", u"Evergreen Tree", 17},
    {u"\\:exclamation:", u"U+02757", u"❗", u"Heavy Exclamation Mark Symbol", 14},
    {u"\\:expressionless:", u"U+1F611", u"😑", u"Expressionless Face", 17},
    {u"\\:eyeglasses:", u"U+1F453", u"👓", u"Eyeglasses", 13},
    {u"\\:eyes:", u"U+1F440", u"👀", u"Eyes", 7},
    {u"\\:facepunch:", u"U+1F44A", u"👊", u"Fisted Hand Sign", 12},
    {u"\\:factory:", u"U+1F3ED", u"🏭", u"Factory", 10},
    {u"\\:fallen_leaf:", u"U+1F342", u"🍂", u"Fallen Leaf", 14},
    {u"\\:family:", u"U+1F46A", u"👪", u"Family", 9},
    {u"\\:fast_forward:", u"U+023E9", u"⏩", u"Black Right-Pointing Double Triangle", 15},
    {u"\\:fax:", u"U+1F4E0", u"📠", u"Fax Machine", 6},
    {u"\\:fearful:", u"U+1F628", u"😨", u"Fearful Face", 10},
    {u"\\:feet:", u"U+1F43E", u"🐾", u"Paw Prints", 7},
    {u"\\:ferris_wheel:", u"U+1F3A1", u"🎡", u"Ferris Wheel", 15},
    {u"\\:file_folder:", u"U+1F4C1", u"📁", u"File Folder", 14},
    {u"\\:fire:", u"U+1F525", u"🔥", u"Fire", 7},
    {u"\\:fire_engine:", u"U+1F692", u"🚒", u"Fire Engine", 14},
    {u"\\:fireworks:", u"U+1F386", u"🎆", u"Fireworks", 12},
    {u"\\:first_quarter_moon:", u"U+1F313", u"🌓", u"First Quarter Moon Symbol", 21},
    {u"\\:first_quarter_moon_with_face:", u"U+1F31B", u"🌛", u"First Quarter Moon With Face", 31},
    {u"\\:fish:", u"U+1F41F", u"🐟", u"Fish", 7},
    {u"\\:fish_cake:", u"U+1F365", u"🍥", u"Fish Cake With Swirl Design", 12},
    {u"\\:fishing_pole_and_fish:", u"U+1F3A3", u"🎣", u"Fishing Pole And Fish", 24},
    {u"\\:fist:", u"U+0270A", u"✊", u"Raised Fist", 7},
    {u"\\:flags:", u"U+1F38F", u"🎏", u"Carp Streamer", 8},
    {u"\\:flashlight:", u"U+1F526", u"🔦", u"Electric Torch", 13},
    {u"\\:floppy_disk:", u"U+1F4BE", u"💾", u"Floppy Disk", 14},
    {u"\\:flower_playing_cards:", u"U+1F3B4", u"🎴", u"Flower Playing Cards", 23},
    {u"\\:flushed:", u"U+1F633", u"😳", u"Flushed Face", 10},
    {u"\\:foggy:", u"U+1F301", u"🌁", u"Foggy", 8},
    {u"\\:football:", u"U+1F3C8", u"🏈", u"American Football", 11},
    {u"\\:footprints:", u"U+1F463", u"👣", u"Footprints", 13},
    {u"\\:fork_and_knife:", u"U+1F374", u"🍴", u"Fork And Knife", 17},
    {u"\\:fountain:", u"U+026F2", u"⛲", u"Fountain", 11},
    {u"\\:four_leaf_clover:", u"U+1F340", u"🍀", u"Four Leaf Clover", 19},
    {u"\\:free:", u"U+1F193", u"🆓", u"Squared Free", 7},
    {u"\\:fried_shrimp:", u"U+1F364", u"🍤", u"Fried Shrimp", 15},
    {u"\\:fries:", u"U+1F35F", u"🍟", u"French Fries", 8},
    {u"\\:frog:", u"U+1F438", u"🐸", u"Frog Face", 7},
    {u"\\:frowning:", u"U+1F626", u"😦", u"Frowning Face With Open Mouth", 11},
    {u"\\:fuelpump:", u"U+026FD", u"⛽", u"Fuel Pump", 11},
    {u"\\:full_moon:", u"U+1F315", u"🌕", u"Full Moon Symbol", 12},
    {u"\\:full_moon_with_face:", u"U+1F31D", u"🌝", u"Full Moon With Face", 22},
    {u"\\:game_die:", u"U+1F3B2", u"🎲", u"Game Die", 11},
    {u"\\:gem:", u"U+1F48E", u"💎", u"Gem Stone", 6},
    {u"\\:gemini:", u"U+0264A", u"♊", u"Gemini", 9},
    {u"\\:ghost:", u"U+1F47B", u"👻", u"Ghost", 8},
    {u"\\:gift:", u"U+1F381", u"🎁", u"Wrapped Present", 7},
    {u"\\:gift_heart:", u"U+1F49D", u"💝", u"Heart With Ribbon", 13},
    {u"\\:girl:", u"U+1F467", u"👧", u"Girl", 7},
    {u"\\:globe_with_meridians:", u"U+1F310", u"🌐", u"Globe With Meridians", 23},
    {u"\\:goat:", u"U+1F410", u"🐐", u"Goat", 7},
    {u"\\:golf:", u"U+026F3", u"⛳", u"Flag In Hole", 7},
    {u"\\:grapes:", u"U+1F347", u"🍇", u"Grapes", 9},
    {u"\\:green_apple:", u"U+1F34F", u"🍏", u"Green Apple", 14},
    {u"\\:green_book:", u"U+1F4D7", u"📗", u"Green Book", 13},
    {u"\\:green_heart:", u"U+1F49A", u"💚", u"Green Heart", 14},
    {u"\\:grey_exclamation:", u"U+02755", u"❕", u"White Exclamation Mark Ornament", 19},
    {u"\\:grey_question:", u"U+02754", u"❔", u"White Question Mark Ornament", 16},
    {u"\\:grimacing:", u"U+1F62C", u"😬", u"Grimacing Face", 12},
    {u"\\:grin:", u"U+1F601", u"😁", u"Grinning Face With Smiling Eyes", 7},
    {u"\\:grinning:", u"U+1F600", u"😀", u"Grinning Face", 11},
    {u"\\:guardsman:", u"U+1F482", u"💂", u"Guardsman", 12},
    {u"\\:guitar:", u"U+1F3B8", u"🎸", u"Guitar", 9},
    {u"\\:gun:", u"U+1F52B", u"🔫", u"Pistol", 6},
    {u"\\:haircut:", u"U+1F487", u"💇", u"Haircut", 10},
    {u"\\:hamburger:", u"U+1F354", u"🍔", u"Hamburger", 12},
    {u"\\:hammer:", u"U+1F528", u"🔨", u"Hammer", 9},
    {u"\\:hamster:", u"U+1F439", u"🐹", u"Hamster Face", 10},
    {u"\\:hand:", u"U+0270B", u"✋", u"Raised Hand", 7},
    {u"\\:handbag:", u"U+1F45C", u"👜", u"Handbag", 10},
    {u"\\:hankey:", u"U+1F4A9", u"💩", u"Pile Of Poo", 9},
    {u"\\:hatched_chick:", u"U+1F425", u"🐥", u"Front-Facing Baby Chick", 16},
    {u"\\:hatching_chick:", u"U+1F423", u"🐣", u"Hatching Chick", 17},
    {u"\\:headphones:", u"U+1F3A7", u"🎧", u"Headphone", 13},
    {u"\\:hear_no_evil:", u"U+1F649", u"🙉", u"Hear-No-Evil Monkey", 15},
    {u"\\:heart:", u"U+02764", u"❤", u"Heavy Black Heart", 8},
    {u"\\:heart_decoration:", u"U+1F49F", u"💟", u"Heart Decoration", 19},
    {u"\\:heart_eyes:", u"U+1F60D", u"😍", u"Smiling Face With Heart-Shaped Eyes", 13},
    {u"\\:heart_eyes_cat:", u"U+1F63B", u"😻", u"Smiling Cat Face With Heart-Shaped Eyes", 17},
    {u"\\:heartbeat:", u"U+1F493", u"💓", u"Beating Heart", 12},
    {u"\\:heartpulse:", u"U+1F497", u"💗", u"Growing Heart", 13},
    {u"\\:hearts:", u"U+02665", u"♥", u"Black Heart Suit", 9},
    {u"\\:heavy_check_mark:", u"U+02714", u"✔", u"Heavy Check Mark", 19},
    {u"\\:heavy_division_sign:", u"U+02797", u"➗", u"Heavy Division Sign", 22},
    {u"\\:heavy_dollar_sign:", u"U+1F4B2", u"💲", u"Heavy Dollar Sign", 20},
    {u"\\:heavy_minus_sign:", u"U+02796", u"➖", u"Heavy Minus Sign", 19},
    {u"\\:heavy_multiplication_x:", u"U+02716", u"✖", u"Heavy Multiplication X", 25},
    {u"\\:heavy_plus_sign:", u"U+02795", u"➕", u"Heavy Plus Sign", 18},
    {u"\\:helicopter:", u"U+1F681", u"🚁", u"Helicopter", 13},
    {u"\\:herb:", u"U+1F33F", u"🌿", u"Herb", 7},
    {u"\\:hibiscus:", u"U+1F33A", u"🌺", u"Hibiscus", 11},
    {u"\\:high_brightness:", u"U+1F506", u"🔆", u"High Brightness Symbol", 18},
    {u"\\:high_heel:", u"U+1F460", u"👠", u"High-Heeled Shoe", 12},
    {u"\\:hocho:", u"U+1F52A", u"🔪", u"Hocho", 8},
    {u"\\:honey_pot:", u"U+1F36F", u"🍯", u"Honey Pot", 12},
    {u"\\:horse:", u"U+1F434", u"🐴", u"Horse Face", 8},
    {u"\\:horse_racing:", u"U+1F3C7", u"🏇", u"Horse Racing", 15},
    {u"\\:hospital:", u"U+1F3E5", u"🏥", u"Hospital", 11},
    {u"\\:hotel:", u"U+1F3E8", u"🏨", u"Hotel", 8},
    {u"\\:hotsprings:", u"U+02668", u"♨", u"Hot Springs", 13},
    {u"\\:hourglass:", u"U+0231B", u"⌛", u"Hourglass", 12},
    {u"\\:hourglass_flowing_sand:", u"U+023F3", u"⏳", u"Hourglass With Flowing Sand", 25},
    {u"\\:house:", u"U+1F3E0", u"🏠", u"House Building", 8},
    {u"\\:house_with_garden:", u"U+1F3E1", u"🏡", u"House With Garden", 20},
    {u"\\:hushed:", u"U+1F62F", u"😯", u"Hushed Face", 9},
    {u"\\:ice_cream:", u"U+1F368", u"🍨", u"Ice Cream", 12},
    {u"\\:icecream:", u"U+1F366", u"🍦", u"Soft Ice Cream", 11},
    {u"\\:id:", u"U+1F194", u"🆔", u"Squared Id", 5},
    {u"\\:ideograph_advantage:", u"U+1F250", u"🉐", u"Circled Ideograph Advantage", 22},
    {u"\\:imp:", u"U+1F47F", u"👿", u"Imp", 6},
    {u"\\:inbox_tray:", u"U+1F4E5", u"📥", u"Inbox Tray", 13},
    {u"\\:incoming_envelope:", u"U+1F4E8", u"📨", u"Incoming Envelope", 20},
    {u"\\:information_desk_person:", u"U+1F481", u"💁", u"Information Desk Person", 26},
    {u"\\:information_source:", u"U+02139", u"ℹ", u"Information Source", 21},
    {u"\\:innocent:", u"U+1F607", u"😇", u"Smiling Face With Halo", 11},
    {u"\\:interrobang:", u"U+02049", u"⁉", u"Exclamation Question Mark", 14},
    {u"\\:iphone:", u"U+1F4F1", u"📱", u"Mobile Phone", 9},
    {u"\\:izakaya_lantern:", u"U+1F3EE", u"🏮", u"Izakaya Lantern", 18},
    {u"\\:jack_o_lantern:", u"U+1F383", u"🎃", u"Jack-O-Lantern", 17},
    {u"\\:japan:", u"U+1F5FE", u"🗾", u"Silhouette Of Japan", 8},
    {u"\\:japanese_castle:", u"U+1F3EF", u"🏯", u"Japanese Castle", 18},
    {u"\\:japanese_goblin:", u"U+1F47A", u"👺", u"Japanese Goblin", 18},
    {u"\\:japanese_ogre:", u"U+1F479", u"👹", u"Japanese Ogre", 16},
    {u"\\:jeans:", u"U+1F456", u"👖", u"Jeans", 8},
    {u"\\:joy:", u"U+1F602", u"😂", u"Face With Tears Of Joy", 6},
    {u"\\:joy_cat:", u"U+1F639", u"😹", u"Cat Face With Tears Of Joy", 10},
    {u"\\:key:", u"U+1F511", u"🔑", u"Key", 6},
    {u"\\:keycap_ten:", u"U+1F51F", u"🔟", u"Keycap Ten", 13},
    {u"\\:kimono:", u"U+1F458", u"👘", u"Kimono", 9},
    {u"\\:kiss:", u"U+1F48B", u"💋", u"Kiss Mark", 7},
    {u"\\:kissing:", u"U+1F617", u"😗", u"Kissing Face", 10},
    {u"\\:kissing_cat:", u"U+1F63D", u"😽", u"Kissing Cat Face With Closed Eyes", 14},
    {u"\\:kissing_closed_eyes:", u"U+1F61A", u"😚", u"Kissing Face With Closed Eyes", 22},
    {u"\\:kissing_heart:", u"U+1F618", u"😘", u"Face Throwing A Kiss", 16},
    {u"\\:kissing_smiling_eyes:", u"U+1F619", u"😙", u"Kissing Face With Smiling Eyes", 23},
    {u"\\:koala:", u"U+1F428", u"🐨", u"Koala", 8},
    {u"\\:koko:", u"U+1F201", u"🈁", u"Squared Katakana Koko", 7},
    {u"\\:large_blue_circle:", u"U+1F535", u"🔵", u"Large Blue Circle", 20},
    {u"\\:large_blue_diamond:", u"U+1F537", u"🔷", u"Large Blue Diamond", 21},
    {u"\\:large_orange_diamond:", u"U+1F536", u"🔶", u"Large Orange Diamond", 23},
    {u"\\:last_quarter_moon:", u"U+1F317", u"🌗", u"Last Quarter Moon Symbol", 20},
    {u"\\:last_quarter_moon_with_face:", u"U+1F31C", u"🌜", u"Last Quarter Moon With Face", 30},
    {u"\\:laughing:", u"U+1F606", u"😆", u"Smiling Face With Open Mouth And Tightly-Closed Eyes", 11},
    {u"\\:leaves:", u"U+1F343", u"🍃", u"Leaf Fluttering In Wind", 9},
    {u"\\:ledger:", u"U+1F4D2", u"📒", u"Ledger", 9},
    {u"\\:left_luggage:", u"U+1F6C5", u"🛅", u"Left Luggage", 15},
    {u"\\:left_right_arrow:", u"U+02194", u"↔", u"Left Right Arrow", 19},
    {u"\\:leftwards_arrow_with_hook:", u"U+021A9", u"↩", u"Leftwards Arrow With Hook / Left Arrow With Hook", 28},
    {u"\\:lemon:", u"U+1F34B", u"🍋", u"Lemon", 8},
    {u"\\:leo:", u"U+0264C", u"♌", u"Leo", 6},
    {u"\\:leopard:", u"U+1F406", u"🐆", u"Leopard", 10},
    {u"\\:libra:", u"U+0264E", u"♎", u"Libra", 8},
    {u"\\:light_rail:", u"U+1F688", u"🚈", u"Light Rail", 13},
    {u"\\:link:", u"U+1F517", u"🔗", u"Link Symbol", 7},
    {u"\\:lips:", u"U+1F444", u"👄", u"Mouth", 7},
    {u"\\:lipstick:", u"U+1F484", u"💄", u"Lipstick", 11},
    {u"\\:lock:", u"U+1F512", u"🔒", u"Lock", 7},
    {u"\\:lock_with_ink_pen:", u"U+1F50F", u"🔏", u"Lock With Ink Pen", 20},
    {u"\\:lollipop:", u"U+1F36D", u"🍭", u"Lollipop", 11},
    {u"\\:loop:", u"U+027BF", u"➿", u"Double Curly Loop", 7},
    {u"\\:loud_sound:", u"U+1F50A", u"🔊", u"Speaker With Three Sound Waves", 13},
    {u"\\:loudspeaker:", u"U+1F4E2", u"📢", u"Public Address Loudspeaker", 14},
    {u"\\:love_hotel:", u"U+1F3E9", u"🏩", u"Love Hotel", 13},
    {u"\\:love_letter:", u"U+1F48C", u"💌", u"Love Letter", 14},
    {u"\\:low_brightness:", u"U+1F505", u"🔅", u"Low Brightness Symbol", 17},
    {u"\\:m:", u"U+024C2", u"Ⓜ", u"Circled Latin Capital Letter M", 4},
    {u"\\:mag:", u"U+1F50D", u"🔍", u"Left-Pointing Magnifying Glass", 6},
    {u"\\:mag_right:", u"U+1F50E", u"🔎", u"Right-Pointing Magnifying Glass", 12},
    {u"\\:mahjong:", u"U+1F004", u"🀄", u"Mahjong Tile Red Dragon", 10},
    {u"\\:mailbox:", u"U+1F4EB", u"📫", u"Closed Mailbox With Raised Flag", 10},
    {u"\\:mailbox_closed:", u"U+1F4EA", u"📪", u"Closed Mailbox With Lowered Flag", 17},
    {u"\\:mailbox_with_mail:", u"U+1F4EC", u"📬", u"Open Mailbox With Raised Flag", 20},
    {u"\\:mailbox_with_no_mail:", u"U+1F4ED", u"📭", u"Open Mailbox With Lowered Flag", 23},
    {u"\\:man:", u"U+1F468", u"👨", u"Man", 6},
    {u"\\:man_with_gua_pi_mao:", u"U+1F472", u"👲", u"Man With Gua Pi Mao", 22},
    {u"\\:man_with_turban:", u"U+1F473", u"👳", u"Man With Turban", 18},
    {u"\\:mans_shoe:", u"U+1F45E", u"👞", u"Mans Shoe", 12},
    {u"\\:maple_leaf:", u"U+1F341", u"🍁", u"Maple Leaf", 13},
    {u"\\:mask:", u"U+1F637", u"😷", u"Face With Medical Mask", 7},
    {u"\\:massage:", u"U+1F486", u"💆", u"Face Massage", 10},
    {u"\\:meat_on_bone:", u"U+1F356", u"🍖", u"Meat On Bone", 15},
    {u"\\:mega:", u"U+1F4E3", u"📣", u"Cheering Megaphone", 7},
    {u"\\:melon:", u"U+1F348", u"🍈", u"Melon", 8},
    {u"\\:memo:", u"U+1F4DD", u"📝", u"Memo", 7},
    {u"\\:mens:", u"U+1F6B9", u"🚹", u"Mens Symbol", 7},
    {u"\\:metro:", u"U+1F687", u"🚇", u"Metro", 8},
    {u"\\:microphone:", u"U+1F3A4", u"🎤", u"Microphone", 13},
    {u"\\:microscope:", u"U+1F52C", u"🔬", u"Microscope", 13},
    {u"\\:milky_way:", u"U+1F30C", u"🌌", u"Milky Way", 12},
    {u"\\:minibus:", u"U+1F690", u"🚐", u"Minibus", 10},
    {u"\\:minidisc:", u"U+1F4BD", u"💽", u"Minidisc", 11},
    {u"\\:mobile_phone_off:", u"U+1F4F4", u"📴", u"Mobile Phone Off", 19},
    {u"\\:money_with_wings:", u"U+1F4B8", u"💸", u"Money With Wings", 19},
    {u"\\:moneybag:", u"U+1F4B0", u"💰", u"Money Bag", 11},
    {u"\\:monkey:", u"U+1F412", u"🐒", u"Monkey", 9},
    {u"\\:monkey_face:", u"U+1F435", u"🐵", u"Monkey Face", 14},
    {u"\\:monorail:", u"U+1F69D", u"🚝", u"Monorail", 11},
    {u"\\:moon:", u"U+1F314", u"🌔", u"Waxing Gibbous Moon Symbol", 7},
    {u"\\:mortar_board:", u"U+1F393", u"🎓", u"Graduation Cap", 15},
    {u"\\:mount_fuji:", u"U+1F5FB", u"🗻", u"Mount Fuji", 13},
    {u"\\:mountain_bicyclist:", u"U+1F6B5", u"🚵", u"Mountain Bicyclist", 21},
    {u"\\:mountain_cableway:", u"U+1F6A0", u"🚠", u"Mountain Cableway", 20},
    {u"\\:mountain_railway:", u"U+1F69E", u"🚞", u"Mountain Railway", 19},
    {u"\\:mouse2:", u"U+1F401", u"🐁", u"Mouse", 9},
    {u"\\:mouse:", u"U+1F42D", u"🐭", u"Mouse Face", 8},
    {u"\\:movie_camera:", u"U+1F3A5", u"🎥", u"Movie Camera", 15},
    {u"\\:moyai:", u"U+1F5FF", u"🗿", u"Moyai", 8},
    {u"\\:muscle:", u"U+1F4AA", u"💪", u"Flexed Biceps", 9},
    {u"\\:mushroom:", u"U+1F344", u"🍄", u"Mushroom", 11},
    {u"\\:musical_keyboard:", u"U+1F3B9", u"🎹", u"Musical Keyboard", 19},
    {u"\\:musical_note:", u"U+1F3B5", u"🎵", u"Musical Note", 15},
    {u"\\:musical_score:", u"U+1F3BC", u"🎼", u"Musical Score", 16},
    {u"\\:mute:", u"U+1F507", u"🔇", u"Speaker With Cancellation Stroke", 7},
    {u"\\:nail_care:", u"U+1F485", u"💅", u"Nail Polish", 12},
    {u"\\:name_badge:", u"U+1F4DB", u"📛", u"Name Badge", 13},
    {u"\\:necktie:", u"U+1F454", u"👔", u"Necktie", 10},
    {u"\\:negative_squared_cross_mark:", u"U+0274E", u"❎", u"Negative Squared Cross Mark", 30},
    {u"\\:neutral_face:", u"U+1F610", u"😐", u"Neutral Face", 15},
    {u"\\:new:", u"U+1F195", u"🆕", u"Squared New", 6},
    {u"\\:new_moon:", u"U+1F311", u"🌑", u"New Moon Symbol", 11},
    {u"\\:new_moon_with_face:", u"U+1F31A", u"🌚", u"New Moon With Face", 21},
    {u"\\:newspaper:", u"U+1F4F0", u"📰", u"Newspaper", 12},
    {u"\\:ng:", u"U+1F196", u"🆖", u"Squared Ng", 5},
    {u"\\:night_with_stars:", u"U+1F303", u"🌃", u"Night With Stars", 19},
    {u"\\:no_bell:", u"U+1F515", u"🔕", u"Bell With Cancellation Stroke", 10},
    {u"\\:no_bicycles:", u"U+1F6B3", u"🚳", u"No Bicycles", 14},
    {u"\\:no_entry:", u"U+026D4", u"⛔", u"No Entry", 11},
    {u"\\:no_entry_sign:", u"U+1F6AB", u"🚫", u"No Entry Sign", 16},
    {u"\\:no_good:", u"U+1F645", u"🙅", u"Face With No Good Gesture", 10},
    {u"\\:no_mobile_phones:", u"U+1F4F5", u"📵", u"No Mobile Phones", 19},
    {u"\\:no_mouth:", u"U+1F636", u"😶", u"Face Without Mouth", 11},
    {u"\\:no_pedestrians:", u"U+1F6B7", u"🚷", u"No Pedestrians", 17},
    {u"\\:no_smoking:", u"U+1F6AD", u"🚭", u"No Smoking Symbol", 13},
    {u"\\:non-potable_water:", u"U+1F6B1", u"🚱", u"Non-Potable Water Symbol", 20},
    {u"\\:nose:", u"U+1F443", u"👃", u"Nose", 7},
    {u"\\:notebook:", u"U+1F4D3", u"📓", u"Notebook", 11},
    {u"\\:notebook_with_decorative_cover:", u"U+1F4D4", u"📔", u"Notebook With Decorative Cover", 33},
    {u"\\:notes:", u"U+1F3B6", u"🎶", u"Multiple Musical Notes", 8},
    {u"\\:nut_and_bolt:", u"U+1F529", u"🔩", u"Nut And Bolt", 15},
    {u"\\:o2:", u"U+1F17E", u"🅾", u"Negative Squared Latin Capital Letter O", 5},
    {u"\\:o:", u"U+02B55", u"⭕", u"Heavy Large Circle", 4},
    {u"\\:ocean:", u"U+1F30A", u"🌊", u"Water Wave", 8},
    {u"\\:octopus:", u"U+1F419", u"🐙", u"Octopus", 10},
    {u"\\:oden:", u"U+1F362", u"🍢", u"Oden", 7},
    {u"\\:office:", u"U+1F3E2", u"🏢", u"Office Building", 9},
    {u"\\:ok:", u"U+1F197", u"🆗", u"Squared Ok", 5},
    {u"\\:ok_hand:", u"U+1F44C", u"👌", u"Ok Hand Sign", 10},
    {u"\\:ok_woman:", u"U+1F646", u"🙆", u"Face With Ok Gesture", 11},
    {u"\\:older_man:", u"U+1F474", u"👴", u"Older Man", 12},
    {u"\\:older_woman:", u"U+1F475", u"👵", u"Older Woman", 14},
    {u"\\:on:", u"U+1F51B", u"🔛", u"On With Exclamation Mark With Left Right Arrow Above", 5},
    {u"\\:oncoming_automobile:", u"U+1F698", u"🚘", u"Oncoming Automobile", 22},
    {u"\\:oncoming_bus:", u"U+1F68D", u"🚍", u"Oncoming Bus", 15},
    {u"\\:oncoming_police_car:", u"U+1F694", u"🚔", u"Oncoming Police Car", 22},
    {u"\\:oncoming_taxi:", u"U+1F696", u"🚖", u"Oncoming Taxi", 16},
    {u"\\:open_file_folder:", u"U+1F4C2", u"📂", u"Open File Folder", 19},
    {u"\\:open_hands:", u"U+1F450", u"👐", u"Open Hands Sign", 13},
    {u"\\:open_mouth:", u"U+1F62E", u"😮", u"Face With Open Mouth", 13},
    {u"\\:ophiuchus:", u"U+026CE", u"⛎", u"Ophiuchus", 12},
    {u"\\:orange_book:", u"U+1F4D9", u"📙", u"Orange Book", 14},
    {u"\\:outbox_tray:", u"U+1F4E4", u"📤", u"Outbox Tray", 14},
    {u"\\:ox:", u"U+1F402", u"🐂", u"Ox", 5},
    {u"\\:package:", u"U+1F4E6", u"📦", u"Package", 10},
    {u"\\:page_facing_up:", u"U+1F4C4", u"📄", u"Page Facing Up", 17},
    {u"\\:page_with_curl:", u"U+1F4C3", u"📃", u"Page With Curl", 17},
    {u"\\:pager:", u"U+1F4DF", u"📟", u"Pager", 8},
    {u"\\:palm_tree:", u"U+1F334", u"🌴", u"Palm Tree", 12},
    {u"\\:panda_face:", u"U+1F43C", u"🐼", u"Panda Face", 13},
    {u"\\:paperclip:", u"U+1F4CE", u"📎", u"Paperclip", 12},
    {u"\\:parking:", u"U+1F17F", u"🅿", u"Negative Squared Latin Capital Letter P", 10},
    {u"\\:part_alternation_mark:", u"U+0303D", u"〽", u"Part Alternation Mark", 24},
    {u"\\:partly_sunny:", u"U+026C5", u"⛅", u"Sun Behind Cloud", 15},
    {u"\\:passport_control:", u"U+1F6C2", u"🛂", u"Passport Control", 19},
    {u"\\:peach:", u"U+1F351", u"🍑", u"Peach", 8},
    {u"\\:pear:", u"U+1F350", u"🍐", u"Pear", 7},
    {u"\\:pencil2:", u"U+0270F", u"✏", u"Pencil", 10},
    {u"\\:penguin:", u"U+1F427", u"🐧", u"Penguin", 10},
    {u"\\:pensive:", u"U+1F614", u"😔", u"Pensive Face", 10},
    {u"\\:performing_arts:", u"U+1F3AD", u"🎭", u"Performing Arts", 18},
    {u"\\:persevere:", u"U+1F623", u"😣", u"Persevering Face", 12},
    {u"\\:person_frowning:", u"U+1F64D", u"🙍", u"Person Frowning", 18},
    {u"\\:person_with_blond_hair:", u"U+1F471", u"👱", u"Person With Blond Hair", 25},
    {u"\\:person_with_pouting_face:", u"U+1F64E", u"🙎", u"Person With Pouting Face", 27},
    {u"\\:phone:", u"U+0260E", u"☎", u"Black Telephone", 8},
    {u"\\:pig2:", u"U+1F416", u"🐖", u"Pig", 7},
    {u"\\:pig:", u"U+1F437", u"🐷", u"Pig Face", 6},
    {u"\\:pig_nose:", u"U+1F43D", u"🐽", u"Pig Nose", 11},
    {u"\\:pill:", u"U+1F48A", u"💊", u"Pill", 7},
    {u"\\:pineapple:", u"U+1F34D", u"🍍", u"Pineapple", 12},
    {u"\\:pisces:", u"U+02653", u"♓", u"Pisces", 9},
    {u"\\:pizza:", u"U+1F355", u"🍕", u"Slice Of Pizza", 8},
    {u"\\:point_down:", u"U+1F447", u"👇", u"White Down Pointing Backhand Index", 13},
    {u"\\:point_left:", u"U+1F448", u"👈", u"White Left Pointing Backhand Index", 13},
    {u"\\:point_right:", u"U+1F449", u"👉", u"White Right Pointing Backhand Index", 14},
    {u"\\:point_up:", u"U+0261D", u"☝", u"White Up Pointing Index", 11},
    {u"\\:point_up_2:", u"U+1F446", u"👆", u"White Up Pointing Backhand Index", 13},
    {u"\\:police_car:", u"U+1F693", u"🚓", u"Police Car", 13},
    {u"\\:poodle:", u"U+1F429", u"🐩", u"Poodle", 9},
    {u"\\:post_office:", u"U+1F3E3", u"🏣", u"Japanese Post Office", 14},
    {u"\\:postal_horn:", u"U+1F4EF", u"📯", u"Postal Horn", 14},
    {u"\\:postbox:", u"U+1F4EE", u"📮", u"Postbox", 10},
    {u"\\:potable_water:", u"U+1F6B0", u"🚰", u"Potable Water Symbol", 16},
    {u"\\:pouch:", u"U+1F45D", u"👝", u"Pouch", 8},
    {u"\\:poultry_leg:", u"U+1F357", u"🍗", u"Poultry Leg", 14},
    {u"\\:pound:", u"U+1F4B7", u"💷", u"Banknote With Pound Sign", 8},
    {u"\\:pouting_cat:", u"U+1F63E", u"😾", u"Pouting Cat Face", 14},
    {u"\\:pray:", u"U+1F64F", u"🙏", u"Person With Folded Hands", 7},
    {u"\\:princess:", u"U+1F478", u"👸", u"Princess", 11},
    {u"\\:purple_heart:", u"U+1F49C", u"💜", u"Purple Heart", 15},
    {u"\\:purse:", u"U+1F45B", u"👛", u"Purse", 8},
    {u"\\:pushpin:", u"U+1F4CC", u"📌", u"Pushpin", 10},
    {u"\\:put_litter_in_its_place:", u"U+1F6AE", u"🚮", u"Put Litter In Its Place Symbol", 26},
    {u"\\:question:", u"U+02753", u"❓", u"Black Question Mark Ornament", 11},
    {u"\\:rabbit2:", u"U+1F407", u"🐇", u"Rabbit", 10},
    {u"\\:rabbit:", u"U+1F430", u"🐰", u"Rabbit Face", 9},
    {u"\\:racehorse:", u"U+1F40E", u"🐎", u"Horse", 12},
    {u"\\:radio:", u"U+1F4FB", u"📻", u"Radio", 8},
    {u"\\:radio_button:", u"U+1F518", u"🔘", u"Radio Button", 15},
    {u"\\:rage:", u"U+1F621", u"😡", u"Pouting Face", 7},
    {u"\\:railway_car:", u"U+1F683", u"🚃", u"Railway Car", 14},
    {u"\\:rainbow:", u"U+1F308", u"🌈", u"Rainbow", 10},
    {u"\\:raised_hands:", u"U+1F64C", u"🙌", u"Person Raising Both Hands In Celebration", 15},
    {u"\\:raising_hand:", u"U+1F64B", u"🙋", u"Happy Person Raising One Hand", 15},
    {u"\\:ram:", u"U+1F40F", u"🐏", u"Ram", 6},
    {u"\\:ramen:", u"U+1F35C", u"🍜", u"Steaming Bowl", 8},
    {u"\\:rat:", u"U+1F400", u"🐀", u"Rat", 6},
    {u"\\:recycle:", u"U+0267B", u"♻", u"Black Universal Recycling Symbol", 10},
    {u"\\:red_circle:", u"U+1F534", u"🔴", u"Large Red Circle", 13},
    {u"\\:registered:", u"U+000AE", u"®", u"Registered Sign / Registered Trade Mark Sign", 13},
    {u"\\:relaxed:", u"U+0263A", u"☺", u"White Smiling Face", 10},
    {u"\\:relieved:", u"U+1F60C", u"😌", u"Relieved Face", 11},
    {u"\\:repeat:", u"U+1F501", u"🔁", u"Clockwise Rightwards And Leftwards Open Circle Arrows", 9},
    {u"\\:repeat_one:", u"U+1F502", u"🔂", u"Clockwise Rightwards And Leftwards Open Circle Arrows With Circled One Overlay", 13},
    {u"\\:restroom:", u"U+1F6BB", u"🚻", u"Restroom", 11},
    {u"\\:revolving_hearts:", u"U+1F49E", u"💞", u"Revolving Hearts", 19},
    {u"\\:rewind:", u"U+023EA", u"⏪", u"Black Left-Pointing Double Triangle", 9},
    {u"\\:ribbon:", u"U+1F380", u"🎀", u"Ribbon", 9},
    {u"\\:rice:", u"U+1F35A", u"🍚", u"Cooked Rice", 7},
    {u"\\:rice_ball:", u"U+1F359", u"🍙", u"Rice Ball", 12},
    {u"\\:rice_cracker:", u"U+1F358", u"🍘", u"Rice Cracker", 15},
    {u"\\:rice_scene:", u"U+1F391", u"🎑", u"Moon Viewing Ceremony", 13},
    {u"\\:ring:", u"U+1F48D", u"💍", u"Ring", 7},
    {u"\\:rocket:", u"U+1F680", u"🚀", u"Rocket", 9},
    {u"\\:roller_coaster:", u"U+1F3A2", u"🎢", u"Roller Coaster", 17},
    {u"\\:rooster:", u"U+1F413", u"🐓", u"Rooster", 10},
    {u"\\:rose:", u"U+1F339", u"🌹", u"Rose", 7},
    {u"\\:rotating_light:", u"U+1F6A8", u"🚨", u"Police Cars Revolving Light", 17},
    {u"\\:round_pushpin:", u"U+1F4CD", u"📍", u"Round Pushpin", 16},
    {u"\\:rowboat:", u"U+1F6A3", u"🚣", u"Rowboat", 10},
    {u"\\:rugby_football:", u"U+1F3C9", u"🏉", u"Rugby Football", 17},
    {u"\\:runner:", u"U+1F3C3", u"🏃", u"Runner", 9},
    {u"\\:running_shirt_with_sash:", u"U+1F3BD", u"🎽", u"Running Shirt With Sash", 26},
    {u"\\:sa:", u"U+1F202", u"🈂", u"Squared Katakana Sa", 5},
    {u"\\:sagittarius:", u"U+02650", u"♐", u"Sagittarius", 14},
    {u"\\:sake:", u"U+1F376", u"🍶", u"Sake Bottle And Cup", 7},
    {u"\\:sandal:", u"U+1F461", u"👡", u"Womans Sandal", 9},
    {u"\\:santa:", u"U+1F385", u"🎅", u"Father Christmas", 8},
    {u"\\:satellite:", u"U+1F4E1", u"📡", u"Satellite Antenna", 12},
    {u"\\:saxophone:", u"U+1F3B7", u"🎷", u"Saxophone", 12},
    {u"\\:school:", u"U+1F3EB", u"🏫", u"School", 9},
    {u"\\:school_satchel:", u"U+1F392", u"🎒", u"School Satchel", 17},
    {u"\\:scissors:", u"U+02702", u"✂", u"Black Scissors", 11},
    {u"\\:scorpius:", u"U+0264F", u"♏", u"Scorpius", 11},
    {u"\\:scream:", u"U+1F631", u"😱", u"Face Screaming In Fear", 9},
    {u"\\:scream_cat:", u"U+1F640", u"🙀", u"Weary Cat Face", 13},
    {u"\\:scroll:", u"U+1F4DC", u"📜", u"Scroll", 9},
    {u"\\:seat:", u"U+1F4BA", u"💺", u"Seat", 7},
    {u"\\:secret:", u"U+03299", u"㊙", u"Circled Ideograph Secret", 9},
    {u"\\:see_no_evil:", u"U+1F648", u"🙈", u"See-No-Evil Monkey", 14},
    {u"\\:seedling:", u"U+1F331", u"🌱", u"Seedling", 11},
    {u"\\:shaved_ice:", u"U+1F367", u"🍧", u"Shaved Ice", 13},
    {u"\\:sheep:", u"U+1F411", u"🐑", u"Sheep", 8},
    {u"\\:shell:", u"U+1F41A", u"🐚", u"Spiral Shell", 8},
    {u"\\:ship:", u"U+1F6A2", u"🚢", u"Ship", 7},
    {u"\\:shirt:", u"U+1F455", u"👕", u"T-Shirt", 8},
    {u"\\:shower:", u"U+1F6BF", u"🚿", u"Shower", 9},
    {u"\\:signal_strength:", u"U+1F4F6", u"📶", u"Antenna With Bars", 18},
    {u"\\:six_pointed_star:", u"U+1F52F", u"🔯", u"Six Pointed Star With Middle Dot", 19},
    {u"\\:ski:", u"U+1F3BF", u"🎿", u"Ski And Ski Boot", 6},
    {u"\\:skin-tone-2:", u"U+1F3FB", u"🏻", u"Emoji Modifier Fitzpatrick Type-1-2", 14},
    {u"\\:skin-tone-3:", u"U+1F3FC", u"🏼", u"Emoji Modifier Fitzpatrick Type-3", 14},
    {u"\\:skin-tone-4:", u"U+1F3FD", u"🏽", u"Emoji Modifier Fitzpatrick Type-4", 14},
    {u"\\:skin-tone-5:", u"U+1F3FE", u"🏾", u"Emoji Modifier Fitzpatrick Type-5", 14},
    {u"\\:skin-tone-6:", u"U+1F3FF", u"🏿", u"Emoji Modifier Fitzpatrick Type-6", 14},
    {u"\\:skull:", u"U+1F480", u"💀", u"Skull", 8},
    {u"\\:sleeping:", u"U+1F634", u"😴", u"Sleeping Face", 11},
    {u"\\:sleepy:", u"U+1F62A", u"😪", u"Sleepy Face", 9},
    {u"\\:slot_machine:", u"U+1F3B0", u"🎰", u"Slot Machine", 15},
    {u"\\:small_blue_diamond:", u"U+1F539", u"🔹", u"Small Blue Diamond", 21},
    {u"\\:small_orange_diamond:", u"U+1F538", u"🔸", u"Small Orange Diamond", 23},
    {u"\\:small_red_triangle:", u"U+1F53A", u"🔺", u"Up-Pointing Red Triangle", 21},
    {u"\\:small_red_triangle_down:", u"U+1F53B", u"🔻", u"Down-Pointing Red Triangle", 26},
    {u"\\:smile:", u"U+1F604", u"😄", u"Smiling Face With Open Mouth And Smiling Eyes", 8},
    {u"\\:smile_cat:", u"U+1F638", u"😸", u"Grinning Cat Face With Smiling Eyes", 12},
    {u"\\:smiley:", u"U+1F603", u"😃", u"Smiling Face With Open Mouth", 9},
    {u"\\:smiley_cat:", u"U+1F63A", u"😺", u"Smiling Cat Face With Open Mouth", 13},
    {u"\\:smiling_imp:", u"U+1F608", u"😈", u"Smiling Face With Horns", 14},
    {u"\\:smirk:", u"U+1F60F", u"😏", u"Smirking Face", 8},
    {u"\\:smirk_cat:", u"U+1F63C", u"😼", u"Cat Face With Wry Smile", 12},
    {u"\\:smoking:", u"U+1F6AC", u"🚬", u"Smoking Symbol", 10},
    {u"\\:snail:", u"U+1F40C", u"🐌", u"Snail", 8},
    {u"\\:snake:", u"U+1F40D", u"🐍", u"Snake", 8},
    {u"\\:snowboarder:", u"U+1F3C2", u"🏂", u"Snowboarder", 14},
    {u"\\:snowflake:", u"U+02744", u"❄", u"Snowflake", 12},
    {u"\\:snowman:", u"U+026C4", u"⛄", u"Snowman Without Snow", 10},
    {u"\\:sob:", u"U+1F62D", u"😭", u"Loudly Crying Face", 6},
    {u"\\:soccer:", u"U+026BD", u"⚽", u"Soccer Ball", 9},
    {u"\\:soon:", u"U+1F51C", u"🔜", u"Soon With Rightwards Arrow Above", 7},
    {u"\\:sos:", u"U+1F198", u"🆘", u"Squared Sos", 6},
    {u"\\:sound:", u"U+1F509", u"🔉", u"Speaker With One Sound Wave", 8},
    {u"\\:space_invader:", u"U+1F47E", u"👾", u"Alien Monster", 16},
    {u"\\:spades:", u"U+02660", u"♠", u"Black Spade Suit", 9},
    {u"\\:spaghetti:", u"U+1F35D", u"🍝", u"Spaghetti", 12},
    {u"\\:sparkle:", u"U+02747", u"❇", u"Sparkle", 10},
    {u"\\:sparkler:", u"U+1F387", u"🎇", u"Firework Sparkler", 11},
    {u"\\:sparkles:", u"U+02728", u"✨", u"Sparkles", 11},
    {u"\\:sparkling_heart:", u"U+1F496", u"💖", u"Sparkling Heart", 18},
    {u"\\:speak_no_evil:", u"U+1F64A", u"🙊", u"Speak-No-Evil Monkey", 16},
    {u"\\:speaker:", u"U+1F508", u"🔈", u"Speaker", 10},
    {u"\\:speech_balloon:", u"U+1F4AC", u"💬", u"Speech Balloon", 17},
    {u"\\:speedboat:", u"U+1F6A4", u"🚤", u"Speedboat", 12},
    {u"\\:star2:", u"U+1F31F", u"🌟", u"Glowing Star", 8},
    {u"\\:star:", u"U+02B50", u"⭐", u"White Medium Star", 7},
    {u"\\:stars:", u"U+1F320", u"🌠", u"Shooting Star", 8},
    {u"\\:station:", u"U+1F689", u"🚉", u"Station", 10},
    {u"\\:statue_of_liberty:", u"U+1F5FD", u"🗽", u"Statue Of Liberty", 20},
    {u"\\:steam_locomotive:", u"U+1F682", u"🚂", u"Steam Locomotive", 19},
    {u"\\:stew:", u"U+1F372", u"🍲", u"Pot Of Food", 7},
    {u"\\:straight_ruler:", u"U+1F4CF", u"📏", u"Straight Ruler", 17},
    {u"\\:strawberry:", u"U+1F353", u"🍓", u"Strawberry", 13},
    {u"\\:stuck_out_tongue:", u"U+1F61B", u"😛", u"Face With Stuck-Out Tongue", 19},
    {u"\\:stuck_out_tongue_closed_eyes:", u"U+1F61D", u"😝", u"Face With Stuck-Out Tongue And Tightly-Closed Eyes", 31},
    {u"\\:stuck_out_tongue_winking_eye:", u"U+1F61C", u"😜", u"Face With Stuck-Out Tongue And Winking Eye", 31},
    {u"\\:sun_with_face:", u"U+1F31E", u"🌞", u"Sun With Face", 16},
    {u"\\:sunflower:", u"U+1F33B", u"🌻", u"Sunflower", 12},
    {u"\\:sunglasses:", u"U+1F60E", u"😎", u"Smiling Face With Sunglasses", 13},
    {u"\\:sunny:", u"U+02600", u"☀", u"Black Sun With Rays", 8},
    {u"\\:sunrise:", u"U+1F305", u"🌅", u"Sunrise", 10},
    {u"\\:sunrise_over_mountains:", u"U+1F304", u"🌄", u"Sunrise Over Mountains", 25},
    {u"\\:surfer:", u"U+1F3C4", u"🏄", u"Surfer", 9},
    {u"\\:sushi:", u"U+1F363", u"🍣", u"Sushi", 8},
    {u"\\:suspension_railway:", u"U+1F69F", u"🚟", u"Suspension Railway", 21},
    {u"\\:sweat:", u"U+1F613", u"😓", u"Face With Cold Sweat", 8},
    {u"\\:sweat_drops:", u"U+1F4A6", u"💦", u"Splashing Sweat Symbol", 14},
    {u"\\:sweat_smile:", u"U+1F605", u"😅", u"Smiling Face With Open Mouth And Cold Sweat", 14},
    {u"\\:sweet_potato:", u"U+1F360", u"🍠", u"Roasted Sweet Potato", 15},
    {u"\\:swimmer:", u"U+1F3CA", u"🏊", u"Swimmer", 10},
    {u"\\:symbols:", u"U+1F523", u"🔣", u"Input Symbol For Symbols", 10},
    {u"\\:syringe:", u"U+1F489", u"💉", u"Syringe", 10},
    {u"\\:tada:", u"U+1F389", u"🎉", u"Party Popper", 7},
    {u"\\:tanabata_tree:", u"U+1F38B", u"🎋", u"Tanabata Tree", 16},
    {u"\\:tangerine:", u"U+1F34A", u"🍊", u"Tangerine", 12},
    {u"\\:taurus:", u"U+02649", u"♉", u"Taurus", 9},
    {u"\\:taxi:", u"U+1F695", u"🚕", u"Taxi", 7},
    {u"\\:tea:", u"U+1F375", u"🍵", u"Teacup Without Handle", 6},
    {u"\\:telephone_receiver:", u"U+1F4DE", u"📞", u"Telephone Receiver", 21},
    {u"\\:telescope:", u"U+1F52D", u"🔭", u"Telescope", 12},
    {u"\\:tennis:", u"U+1F3BE", u"🎾", u"Tennis Racquet And Ball", 9},
    {u"\\:tent:", u"U+026FA", u"⛺", u"Tent", 7},
    {u"\\:thought_balloon:", u"U+1F4AD", u"💭", u"Thought Balloon", 18},
    {u"\\:ticket:", u"U+1F3AB", u"🎫", u"Ticket", 9},
    {u"\\:tiger2:", u"U+1F405", u"🐅", u"Tiger", 9},
    {u"\\:tiger:", u"U+1F42F", u"🐯", u"Tiger Face", 8},
    {u"\\:tired_face:", u"U+1F62B", u"😫", u"Tired Face", 13},
    {u"\\:tm:", u"U+02122", u"™", u"Trade Mark Sign / Trademark", 5},
    {u"\\:toilet:", u"U+1F6BD", u"🚽", u"Toilet", 9},
    {u"\\:tokyo_tower:", u"U+1F5FC", u"🗼", u"Tokyo Tower", 14},
    {u"\\:tomato:", u"U+1F345", u"🍅", u"Tomato", 9},
    {u"\\:tongue:", u"U+1F445", u"👅", u"Tongue", 9},
    {u"\\:top:", u"U+1F51D", u"🔝", u"Top With Upwards Arrow Above", 6},
    {u"\\:tophat:", u"U+1F3A9", u"🎩", u"Top Hat", 9},
    {u"\\:tractor:", u"U+1F69C", u"🚜", u"Tractor", 10},
    {u"\\:traffic_light:", u"U+1F6A5", u"🚥", u"Horizontal Traffic Light", 16},
    {u"\\:train2:", u"U+1F686", u"🚆", u"Train", 9},
    {u"\\:train:", u"U+1F68B", u"🚋", u"Tram Car", 8},
    {u"\\:tram:", u"U+1F68A", u"🚊", u"Tram", 7},
    {u"\\:triangular_flag_on_post:", u"U+1F6A9", u"🚩", u"Triangular Flag On Post", 26},
    {u"\\:triangular_ruler:", u"U+1F4D0", u"📐", u"Triangular Ruler", 19},
    {u"\\:trident:", u"U+1F531", u"🔱", u"Trident Emblem", 10},
    {u"\\:triumph:", u"U+1F624", u"😤", u"Face With Look Of Triumph", 10},
    {u"\\:trolleybus:", u"U+1F68E", u"🚎", u"Trolleybus", 13},
    {u"\\:trophy:", u"U+1F3C6", u"🏆", u"Trophy", 9},
    {u"\\:tropical_drink:", u"U+1F379", u"🍹", u"Tropical Drink", 17},
    {u"\\:tropical_fish:", u"U+1F420", u"🐠", u"Tropical Fish", 16},
    {u"\\:truck:", u"U+1F69A", u"🚚", u"Delivery Truck", 8},
    {u"\\:trumpet:", u"U+1F3BA", u"🎺", u"Trumpet", 10},
    {u"\\:tulip:", u"U+1F337", u"🌷", u"Tulip", 8},
    {u"\\:turtle:", u"U+1F422", u"🐢", u"Turtle", 9},
    {u"\\:tv:", u"U+1F4FA", u"📺", u"Television", 5},
    {u"\\:twisted_rightwards_arrows:", u"U+1F500", u"🔀", u"Twisted Rightwards Arrows", 28},
    {u"\\:two_hearts:", u"U+1F495", u"💕", u"Two Hearts", 13},
    {u"\\:two_men_holding_hands:", u"U+1F46C", u"👬", u"Two Men Holding Hands", 24},
    {u"\\:two_women_holding_hands:", u"U+1F46D", u"👭", u"Two Women Holding Hands", 26},
    {u"\\:u5272:", u"U+1F239", u"🈹", u"Squared Cjk Unified Ideograph-5272", 8},
    {u"\\:u5408:", u"U+1F234", u"🈴", u"Squared Cjk Unified Ideograph-5408", 8},
    {u"\\:u55b6:", u"U+1F23A", u"🈺", u"Squared Cjk Unified Ideograph-55B6", 8},
    {u"\\:u6307:", u"U+1F22F", u"🈯", u"Squared Cjk Unified Ideograph-6307", 8},
    {u"\\:u6708:", u"U+1F237", u"🈷", u"Squared Cjk Unified Ideograph-6708", 8},
    {u"\\:u6709:", u"U+1F236", u"🈶", u"Squared Cjk Unified Ideograph-6709", 8},
    {u"\\:u6e80:", u"U+1F235", u"🈵", u"Squared Cjk Unified Ideograph-6E80", 8},
    {u"\\:u7121:", u"U+1F21A", u"🈚", u"Squared Cjk Unified Ideograph-7121", 8},
    {u"\\:u7533:", u"U+1F238", u"🈸", u"Squared Cjk Unified Ideograph-7533", 8},
    {u"\\:u7981:", u"U+1F232", u"🈲", u"Squared Cjk Unified Ideograph-7981", 8},
    {u"\\:u7a7a:", u"U+1F233", u"🈳", u"Squared Cjk Unified Ideograph-7A7A", 8},
    {u"\\:umbrella:", u"U+02614", u"☔", u"Umbrella With Rain Drops", 11},
    {u"\\:unamused:", u"U+1F612", u"😒", u"Unamused Face", 11},
    {u"\\:underage:", u"U+1F51E", u"🔞", u"No One Under Eighteen Symbol", 11},
    {u"\\:unlock:", u"U+1F513", u"🔓", u"Open Lock", 9},
    {u"\\:up:", u"U+1F199", u"🆙", u"Squared Up With Exclamation Mark", 5},
    {u"\\:v:", u"U+0270C", u"✌", u"Victory Hand", 4},
    {u"\\:vertical_traffic_light:", u"U+1F6A6", u"🚦", u"Vertical Traffic Light", 25},
    {u"\\:vhs:", u"U+1F4FC", u"📼", u"Videocassette", 6},
    {u"\\:vibration_mode:", u"U+1F4F3", u"📳", u"Vibration Mode", 17},
    {u"\\:video_camera:", u"U+1F4F9", u"📹", u"Video Camera", 15},
    {u"\\:video_game:", u"U+1F3AE", u"🎮", u"Video Game", 13},
    {u"\\:violin:", u"U+1F3BB", u"🎻", u"Violin", 9},
    {u"\\:virgo:", u"U+0264D", u"♍", u"Virgo", 8},
    {u"\\:volcano:", u"U+1F30B", u"🌋", u"Volcano", 10},
    {u"\\:vs:", u"U+1F19A", u"🆚", u"Squared Vs", 5},
    {u"\\:walking:", u"U+1F6B6", u"🚶", u"Pedestrian", 10},
    {u"\\:waning_crescent_moon:", u"U+1F318", u"🌘", u"Waning Crescent Moon Symbol", 23},
    {u"\\:waning_gibbous_moon:", u"U+1F316", u"🌖", u"Waning Gibbous Moon Symbol", 22},
    {u"\\:warning:", u"U+026A0", u"⚠", u"Warning Sign", 10},
    {u"\\:watch:", u"U+0231A", u"⌚", u"Watch", 8},
    {u"\\:water_buffalo:", u"U+1F403", u"🐃", u"Water Buffalo", 16},
    {u"\\:watermelon:", u"U+1F349", u"🍉", u"Watermelon", 13},
    {u"\\:wave:", u"U+1F44B", u"👋", u"Waving Hand Sign", 7},
    {u"\\:wavy_dash:", u"U+03030", u"〰", u"Wavy Dash", 12},
    {u"\\:waxing_crescent_moon:", u"U+1F312", u"🌒", u"Waxing Crescent Moon Symbol", 23},
    {u"\\:wc:", u"U+1F6BE", u"🚾", u"Water Closet", 5},
    {u"\\:weary:", u"U+1F629", u"😩", u"Weary Face", 8},
    {u"\\:wedding:", u"U+1F492", u"💒", u"Wedding", 10},
    {u"\\:whale2:", u"U+1F40B", u"🐋", u"Whale", 9},
    {u"\\:whale:", u"U+1F433", u"🐳", u"Spouting Whale", 8},
    {u"\\:wheelchair:", u"U+0267F", u"♿", u"Wheelchair Symbol", 13},
    {u"\\:white_check_mark:", u"U+02705", u"✅", u"White Heavy Check Mark", 19},
    {u"\\:white_circle:", u"U+026AA", u"⚪", u"Medium White Circle", 15},
    {u"\\:white_flower:", u"U+1F4AE", u"💮", u"White Flower", 15},
    {u"\\:white_large_square:", u"U+02B1C", u"⬜", u"White Large Square", 21},
    {u"\\:white_medium_small_square:", u"U+025FD", u"◽", u"White Medium Small Square", 28},
    {u"\\:white_medium_square:", u"U+025FB", u"◻", u"White Medium Square", 22},
    {u"\\:white_small_square:", u"U+025AB", u"▫", u"White Small Square", 21},
    {u"\\:white_square_button:", u"U+1F533", u"🔳", u"White Square Button", 22},
    {u"\\:wind_chime:", u"U+1F390", u"🎐", u"Wind Chime", 13},
    {u"\\:wine_glass:", u"U+1F377", u"🍷", u"Wine Glass", 13},
    {u"\\:wink:", u"U+1F609", u"😉", u"Winking Face", 7},
    {u"\\:wolf:", u"U+1F43A", u"🐺", u"Wolf Face", 7},
    {u"\\:woman:", u"U+1F469", u"👩", u"Woman", 8},
    {u"\\:womans_clothes:", u"U+1F45A", u"👚", u"Womans Clothes", 17},
    {u"\\:womans_hat:", u"U+1F452", u"👒", u"Womans Hat", 13},
    {u"\\:womens:", u"U+1F6BA", u"🚺", u"Womens Symbol", 9},
    {u"\\:worried:", u"U+1F61F", u"😟", u"Worried Face", 10},
    {u"\\:wrench:", u"U+1F527", u"🔧", u"Wrench", 9},
    {u"\\:x:", u"U+0274C", u"❌", u"Cross Mark", 4},
    {u"\\:yellow_heart:", u"U+1F49B", u"💛", u"Yellow Heart", 15},
    {u"\\:yen:", u"U+1F4B4", u"💴", u"Banknote With Yen Sign", 6},
    {u"\\:yum:", u"U+1F60B", u"😋", u"Face Savouring Delicious Food", 6},
    {u"\\:zap:", u"U+026A1", u"⚡", u"High Voltage Sign", 6},
    {u"\\:zzz:", u"U+1F4A4", u"💤", u"Sleeping Symbol", 6},
    {u"\\AA", u"U+000C5", u"Å", u"Latin Capital Letter A With Ring Above / Latin Capital Letter A Ring", 3},
    {u"\\AE", u"U+000C6", u"Æ", u"Latin Capital Letter Ae / Latin Capital Letter A E", 3},
    {u"\\Alpha", u"U+00391", u"Α", u"Greek Capital Letter Alpha", 6},
    {u"\\And", u"U+02A53", u"⩓", u"Double Logical And", 4},
    {u"\\Angle", u"U+0299C", u"⦜", u"Right Angle Variant With Square", 6},
    {u"\\Angstrom", u"U+0212B", u"Å", u"Angstrom Sign / Angstrom Unit", 9},
    {u"\\Beta", u"U+00392", u"Β", u"Greek Capital Letter Beta", 5},
    {u"\\Bumpeq", u"U+0224E", u"≎", u"Geometrically Equivalent To", 7},
    {u"\\Cap", u"U+022D2", u"⋒", u"Double Intersection", 4},
    {u"\\Chi", u"U+003A7", u"Χ", u"Greek Capital Letter Chi", 4},
    {u"\\Colon", u"U+02237", u"∷", u"Proportion", 6},
    {u"\\Coloneq", u"U+02A74", u"⩴", u"Double Colon Equal", 8},
    {u"\\Cup", u"U+022D3", u"⋓", u"Double Union", 4},
    {u"\\DDownarrow", u"U+027F1", u"⟱", u"Downwards Quadruple Arrow", 11},
    {u"\\DH", u"U+000D0", u"Ð", u"Latin Capital Letter Eth", 3},
    {u"\\DJ", u"U+00110", u"Đ", u"Latin Capital Letter D With Stroke / Latin Capital Letter D Bar", 3},
    {u"\\Dashv", u"U+02AE4", u"⫤", u"Vertical Bar Double Left Turnstile", 6},
    {u"\\Ddownarrow", u"U+0290B", u"⤋", u"Downwards Triple Arrow", 11},
    {u"\\Delta", u"U+00394", u"Δ", u"Greek Capital Letter Delta", 6},
    {u"\\Digamma", u"U+003DC", u"Ϝ", u"Greek Letter Digamma / Greek Capital Letter Digamma", 8},
    {u"\\Doteq", u"U+02251", u"≑", u"Geometrically Equal To", 6},
    {u"\\DownArrowBar", u"U+02913", u"⤓", u"Downwards Arrow To Bar", 13},
    {u"\\DownArrowUpArrow", u"U+021F5", u"⇵", u"Downwards Arrow Leftwards Of Upwards Arrow", 17},
    {u"\\DownLeftRightVector", u"U+02950", u"⥐", u"Left Barb Down Right Barb Down Harpoon", 20},
    {u"\\DownLeftTeeVector", u"U+0295E", u"⥞", u"Leftwards Harpoon With Barb Down From Bar", 18},
    {u"\\DownLeftVectorBar", u"U+02956", u"⥖", u"Leftwards Harpoon With Barb Down To Bar", 18},
    {u"\\DownRightTeeVector", u"U+0295F", u"⥟", u"Rightwards Harpoon With Barb Down From Bar", 19},
    {u"\\DownRightVectorBar", u"U+02957", u"⥗", u"Rightwards Harpoon With Barb Down To Bar", 19},
    {u"\\Downarrow", u"U+021D3", u"⇓", u"Downwards Double Arrow / Down Double Arrow", 10},
    {u"\\ElOr", u"U+02A56", u"⩖", u"Two Intersecting Logical Or", 5},
    {u"\\Elroang", u"U+02986", u"⦆", u"Right White Parenthesis", 8},
    {u"\\Epsilon", u"U+00395", u"Ε", u"Greek Capital Letter Epsilon", 8},
    {u"\\Equal", u"U+02A75", u"⩵", u"Two Consecutive Equals Signs", 6},
    {u"\\Equiv", u"U+02263", u"≣", u"Strictly Equivalent To", 6},
    {u"\\Eta", u"U+00397", u"Η", u"Greek Capital Letter Eta", 4},
    {u"\\Finv", u"U+02132", u"Ⅎ", u"Turned Capital F / Turned F", 5},
    {u"\\Game", u"U+02141", u"⅁", u"Turned Sans-Serif Capital G", 5},
    {u"\\Gamma", u"U+00393", u"Γ", u"Greek Capital Letter Gamma", 6},
    {u"\\H", u"U+0030B", u" ̋ ", u"Combining Double Acute Accent / Non-Spacing Double Acute", 2},
    {u"\\Im", u"U+02111", u"ℑ", u"Black-Letter Capital I / Black-Letter I", 3},
    {u"\\Iota", u"U+00399", u"Ι", u"Greek Capital Letter Iota", 5},
    {u"\\Join", u"U+02A1D", u"⨝", u"Join", 5},
    {u"\\Kappa", u"U+0039A", u"Κ", u"Greek Capital Letter Kappa", 6},
    {u"\\Koppa", u"U+003DE", u"Ϟ", u"Greek Letter Koppa / Greek Capital Letter Koppa", 6},
    {u"\\L", u"U+00141", u"Ł", u"Latin Capital Letter L With Stroke / Latin Capital Letter L Slash", 2},
    {u"\\LLeftarrow", u"U+02B45", u"⭅", u"Leftwards Quadruple Arrow", 11},
    {u"\\Lambda", u"U+0039B", u"Λ", u"Greek Capital Letter Lamda / Greek Capital Letter Lambda", 7},
    {u"\\Lap", u"U+029CA", u"⧊", u"Triangle With Dot Above", 4},
    {u"\\Ldsh", u"U+021B2", u"↲", u"Downwards Arrow With Tip Leftwards / Down Arrow With Tip Left", 5},
    {u"\\LeftDownTeeVector", u"U+02961", u"⥡", u"Downwards Harpoon With Barb Left From Bar", 18},
    {u"\\LeftDownVectorBar", u"U+02959", u"⥙", u"Downwards Harpoon With Barb Left To Bar", 18},
    {u"\\LeftRightVector", u"U+0294E", u"⥎", u"Left Barb Up Right Barb Up Harpoon", 16},
    {u"\\LeftTeeVector", u"U+0295A", u"⥚", u"Leftwards Harpoon With Barb Up From Bar", 14},
    {u"\\LeftTriangleBar", u"U+029CF", u"⧏", u"Left Triangle Beside Vertical Bar", 16},
    {u"\\LeftUpDownVector", u"U+02951", u"⥑", u"Up Barb Left Down Barb Left Harpoon", 17},
    {u"\\LeftUpTeeVector", u"U+02960", u"⥠", u"Upwards Harpoon With Barb Left From Bar", 16},
    {u"\\LeftUpVectorBar", u"U+02958", u"⥘", u"Upwards Harpoon With Barb Left To Bar", 16},
    {u"\\LeftVectorBar", u"U+02952", u"⥒", u"Leftwards Harpoon With Barb Up To Bar", 14},
    {u"\\Leftarrow", u"U+021D0", u"⇐", u"Leftwards Double Arrow / Left Double Arrow", 10},
    {u"\\Leftrightarrow", u"U+021D4", u"⇔", u"Left Right Double Arrow", 15},
    {u"\\Lleftarrow", u"U+021DA", u"⇚", u"Leftwards Triple Arrow / Left Triple Arrow", 11},
    {u"\\Longleftarrow", u"U+027F8", u"⟸", u"Long Leftwards Double Arrow", 14},
    {u"\\Longleftrightarrow", u"U+027FA", u"⟺", u"Long Left Right Double Arrow", 19},
    {u"\\Longmapsfrom", u"U+027FD", u"⟽", u"Long Leftwards Double Arrow From Bar", 13},
    {u"\\Longmapsto", u"U+027FE", u"⟾", u"Long Rightwards Double Arrow From Bar", 11},
    {u"\\Longrightarrow", u"U+027F9", u"⟹", u"Long Rightwards Double Arrow", 15},
    {u"\\Lsh", u"U+021B0", u"↰", u"Upwards Arrow With Tip Leftwards / Up Arrow With Tip Left", 4},
    {u"\\Mapsfrom", u"U+02906", u"⤆", u"Leftwards Double Arrow From Bar", 9},
    {u"\\Mapsto", u"U+02907", u"⤇", u"Rightwards Double Arrow From Bar", 7},
    {u"\\NG", u"U+0014A", u"Ŋ", u"Latin Capital Letter Eng", 3},
    {u"\\Nearrow", u"U+021D7", u"⇗", u"North East Double Arrow / Upper Right Double Arrow", 8},
    {u"\\NestedGreaterGreater", u"U+02AA2", u"⪢", u"Double Nested Greater-Than", 21},
    {u"\\NestedLessLess", u"U+02AA1", u"⪡", u"Double Nested Less-Than", 15},
    {u"\\NotGreaterGreater",
     u"U+0226B + U+00338",
     u"≫̸",
     u"Much Greater-Than / Much Greater Than + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay",
     18},
    {u"\\NotLeftTriangleBar",
     u"U+029CF + U+00338",
     u"⧏̸",
     u"Left Triangle Beside Vertical Bar + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay",
     19},
    {u"\\NotLessLess", u"U+0226A + U+00338", u"≪̸", u"Much Less-Than / Much Less Than + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 12},
    {u"\\NotNestedGreaterGreater",
     u"U+02AA2 + U+00338",
     u"⪢̸",
     u"Double Nested Greater-Than + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay",
     24},
    {u"\\NotNestedLessLess", u"U+02AA1 + U+00338", u"⪡̸", u"Double Nested Less-Than + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 18},
    {u"\\NotRightTriangleBar",
     u"U+029D0 + U+00338",
     u"⧐̸",
     u"Vertical Bar Beside Right Triangle + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay",
     20},
    {u"\\NotSquareSubset", u"U+0228F + U+00338", u"⊏̸", u"Square Image Of + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 16},
    {u"\\NotSquareSuperset", u"U+02290 + U+00338", u"⊐̸", u"Square Original Of + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 18},
    {u"\\Nwarrow", u"U+021D6", u"⇖", u"North West Double Arrow / Upper Left Double Arrow", 8},
    {u"\\O", u"U+000D8", u"Ø", u"Latin Capital Letter O With Stroke / Latin Capital Letter O Slash", 2},
    {u"\\OE", u"U+00152", u"Œ", u"Latin Capital Ligature Oe / Latin Capital Letter O E", 3},
    {u"\\Omega", u"U+003A9", u"Ω", u"Greek Capital Letter Omega", 6},
    {u"\\Or", u"U+02A54", u"⩔", u"Double Logical Or", 3},
    {u"\\Otimes", u"U+02A37", u"⨷", u"Multiplication Sign In Double Circle", 7},
    {u"\\P", u"U+000B6", u"¶", u"Pilcrow Sign / Paragraph Sign", 2},
    {u"\\Phi", u"U+003A6", u"Φ", u"Greek Capital Letter Phi", 4},
    {u"\\Pi", u"U+003A0", u"Π", u"Greek Capital Letter Pi", 3},
    {u"\\Prec", u"U+02ABB", u"⪻", u"Double Precedes", 5},
    {u"\\PropertyLine", u"U+0214A", u"⅊", u"Property Line", 13},
    {u"\\Psi", u"U+003A8", u"Ψ", u"Greek Capital Letter Psi", 4},
    {u"\\QED", u"U+0220E", u"∎", u"End Of Proof", 4},
    {u"\\RRightarrow", u"U+02B46", u"⭆", u"Rightwards Quadruple Arrow", 12},
    {u"\\Rdsh", u"U+021B3", u"↳", u"Downwards Arrow With Tip Rightwards / Down Arrow With Tip Right", 5},
    {u"\\Re", u"U+0211C", u"ℜ", u"Black-Letter Capital R / Black-Letter R", 3},
    {u"\\ReverseUpEquilibrium", u"U+0296F", u"⥯", u"Downwards Harpoon With Barb Left Beside Upwards Harpoon With Barb Right", 21},
    {u"\\Rho", u"U+003A1", u"Ρ", u"Greek Capital Letter Rho", 4},
    {u"\\RightDownTeeVector", u"U+0295D", u"⥝", u"Downwards Harpoon With Barb Right From Bar", 19},
    {u"\\RightDownVectorBar", u"U+02955", u"⥕", u"Downwards Harpoon With Barb Right To Bar", 19},
    {u"\\RightTeeVector", u"U+0295B", u"⥛", u"Rightwards Harpoon With Barb Up From Bar", 15},
    {u"\\RightTriangleBar", u"U+029D0", u"⧐", u"Vertical Bar Beside Right Triangle", 17},
    {u"\\RightUpDownVector", u"U+0294F", u"⥏", u"Up Barb Right Down Barb Right Harpoon", 18},
    {u"\\RightUpTeeVector", u"U+0295C", u"⥜", u"Upwards Harpoon With Barb Right From Bar", 17},
    {u"\\RightUpVectorBar", u"U+02954", u"⥔", u"Upwards Harpoon With Barb Right To Bar", 17},
    {u"\\RightVectorBar", u"U+02953", u"⥓", u"Rightwards Harpoon With Barb Up To Bar", 15},
    {u"\\Rightarrow", u"U+021D2", u"⇒", u"Rightwards Double Arrow / Right Double Arrow", 11},
    {u"\\Rlarr", u"U+02942", u"⥂", u"Rightwards Arrow Above Short Leftwards Arrow", 6},
    {u"\\RoundImplies", u"U+02970", u"⥰", u"Right Double Arrow With Rounded Head", 13},
    {u"\\Rrightarrow", u"U+021DB", u"⇛", u"Rightwards Triple Arrow / Right Triple Arrow", 12},
    {u"\\Rsh", u"U+021B1", u"↱", u"Upwards Arrow With Tip Rightwards / Up Arrow With Tip Right", 4},
    {u"\\RuleDelayed", u"U+029F4", u"⧴", u"Rule-Delayed", 12},
    {u"\\S", u"U+000A7", u"§", u"Section Sign", 2},
    {u"\\Sampi", u"U+003E0", u"Ϡ", u"Greek Letter Sampi / Greek Capital Letter Sampi", 6},
    {u"\\Searrow", u"U+021D8", u"⇘", u"South East Double Arrow / Lower Right Double Arrow", 8},
    {u"\\Sigma", u"U+003A3", u"Σ", u"Greek Capital Letter Sigma", 6},
    {u"\\Sqcap", u"U+02A4E", u"⩎", u"Double Square Intersection", 6},
    {u"\\Sqcup", u"U+02A4F", u"⩏", u"Double Square Union", 6},
    {u"\\Stigma", u"U+003DA", u"Ϛ", u"Greek Letter Stigma / Greek Capital Letter Stigma", 7},
    {u"\\Subset", u"U+022D0", u"⋐", u"Double Subset", 7},
    {u"\\Succ", u"U+02ABC", u"⪼", u"Double Succeeds", 5},
    {u"\\Supset", u"U+022D1", u"⋑", u"Double Superset", 7},
    {u"\\Swarrow", u"U+021D9", u"⇙", u"South West Double Arrow / Lower Left Double Arrow", 8},
    {u"\\TH", u"U+000DE", u"Þ", u"Latin Capital Letter Thorn", 3},
    {u"\\Tau", u"U+003A4", u"Τ", u"Greek Capital Letter Tau", 4},
    {u"\\Theta", u"U+00398", u"Θ", u"Greek Capital Letter Theta", 6},
    {u"\\Times", u"U+02A2F", u"⨯", u"Vector Or Cross Product", 6},
    {u"\\UUparrow", u"U+027F0", u"⟰", u"Upwards Quadruple Arrow", 9},
    {u"\\UpArrowBar", u"U+02912", u"⤒", u"Upwards Arrow To Bar", 11},
    {u"\\UpEquilibrium", u"U+0296E", u"⥮", u"Upwards Harpoon With Barb Left Beside Downwards Harpoon With Barb Right", 14},
    {u"\\Uparrow", u"U+021D1", u"⇑", u"Upwards Double Arrow / Up Double Arrow", 8},
    {u"\\Updownarrow", u"U+021D5", u"⇕", u"Up Down Double Arrow", 12},
    {u"\\Upsilon", u"U+003A5", u"Υ", u"Greek Capital Letter Upsilon", 8},
    {u"\\Uuparrow", u"U+0290A", u"⤊", u"Upwards Triple Arrow", 9},
    {u"\\VDash", u"U+022AB", u"⊫", u"Double Vertical Bar Double Right Turnstile", 6},
    {u"\\Vdash", u"U+022A9", u"⊩", u"Forces", 6},
    {u"\\Vert", u"U+02016", u"‖", u"Double Vertical Line / Double Vertical Bar", 5},
    {u"\\Vvdash", u"U+022AA", u"⊪", u"Triple Vertical Bar Right Turnstile", 7},
    {u"\\Vvert", u"U+02980", u"⦀", u"Triple Vertical Bar Delimiter", 6},
    {u"\\Xi", u"U+0039E", u"Ξ", u"Greek Capital Letter Xi", 3},
    {u"\\Yup", u"U+02144", u"⅄", u"Turned Sans-Serif Capital Y", 4},
    {u"\\Zbar", u"U+001B5", u"Ƶ", u"Latin Capital Letter Z With Stroke / Latin Capital Letter Z Bar", 5},
    {u"\\Zeta", u"U+00396", u"Ζ", u"Greek Capital Letter Zeta", 5},
    {u"\\^!", u"U+0A71D", u"ꜝ", u"Modifier Letter Raised Exclamation Mark", 3},
    {u"\\^(", u"U+0207D", u"⁽", u"Superscript Left Parenthesis / Superscript Opening Parenthesis", 3},
    {u"\\^)", u"U+0207E", u"⁾", u"Superscript Right Parenthesis / Superscript Closing Parenthesis", 3},
    {u"\\^+", u"U+0207A", u"⁺", u"Superscript Plus Sign", 3},
    {u"\\^-", u"U+0207B", u"⁻", u"Superscript Minus / Superscript Hyphen-Minus", 3},
    {u"\\^0", u"U+02070", u"⁰", u"Superscript Zero / Superscript Digit Zero", 3},
    {u"\\^1", u"U+000B9", u"¹", u"Superscript One / Superscript Digit One", 3},
    {u"\\^2", u"U+000B2", u"²", u"Superscript Two / Superscript Digit Two", 3},
    {u"\\^3", u"U+000B3", u"³", u"Superscript Three / Superscript Digit Three", 3},
    {u"\\^4", u"U+02074", u"⁴", u"Superscript Four / Superscript Digit Four", 3},
    {u"\\^5", u"U+02075", u"⁵", u"Superscript Five / Superscript Digit Five", 3},
    {u"\\^6", u"U+02076", u"⁶", u"Superscript Six / Superscript Digit Six", 3},
    {u"\\^7", u"U+02077", u"⁷", u"Superscript Seven / Superscript Digit Seven", 3},
    {u"\\^8", u"U+02078", u"⁸", u"Superscript Eight / Superscript Digit Eight", 3},
    {u"\\^9", u"U+02079", u"⁹", u"Superscript Nine / Superscript Digit Nine", 3},
    {u"\\^=", u"U+0207C", u"⁼", u"Superscript Equals Sign", 3},
    {u"\\^A", u"U+01D2C", u"ᴬ", u"Modifier Letter Capital A", 3},
    {u"\\^B", u"U+01D2E", u"ᴮ", u"Modifier Letter Capital B", 3},
    {u"\\^D", u"U+01D30", u"ᴰ", u"Modifier Letter Capital D", 3},
    {u"\\^E", u"U+01D31", u"ᴱ", u"Modifier Letter Capital E", 3},
    {u"\\^G", u"U+01D33", u"ᴳ", u"Modifier Letter Capital G", 3},
    {u"\\^H", u"U+01D34", u"ᴴ", u"Modifier Letter Capital H", 3},
    {u"\\^I", u"U+01D35", u"ᴵ", u"Modifier Letter Capital I", 3},
    {u"\\^J", u"U+01D36", u"ᴶ", u"Modifier Letter Capital J", 3},
    {u"\\^K", u"U+01D37", u"ᴷ", u"Modifier Letter Capital K", 3},
    {u"\\^L", u"U+01D38", u"ᴸ", u"Modifier Letter Capital L", 3},
    {u"\\^M", u"U+01D39", u"ᴹ", u"Modifier Letter Capital M", 3},
    {u"\\^N", u"U+01D3A", u"ᴺ", u"Modifier Letter Capital N", 3},
    {u"\\^O", u"U+01D3C", u"ᴼ", u"Modifier Letter Capital O", 3},
    {u"\\^P", u"U+01D3E", u"ᴾ", u"Modifier Letter Capital P", 3},
    {u"\\^Phi", u"U+01DB2", u"ᶲ", u"Modifier Letter Small Phi", 5},
    {u"\\^R", u"U+01D3F", u"ᴿ", u"Modifier Letter Capital R", 3},
    {u"\\^T", u"U+01D40", u"ᵀ", u"Modifier Letter Capital T", 3},
    {u"\\^U", u"U+01D41", u"ᵁ", u"Modifier Letter Capital U", 3},
    {u"\\^V", u"U+02C7D", u"ⱽ", u"Modifier Letter Capital V", 3},
    {u"\\^W", u"U+01D42", u"ᵂ", u"Modifier Letter Capital W", 3},
    {u"\\^a", u"U+01D43", u"ᵃ", u"Modifier Letter Small A", 3},
    {u"\\^alpha", u"U+01D45", u"ᵅ", u"Modifier Letter Small Alpha", 7},
    {u"\\^b", u"U+01D47", u"ᵇ", u"Modifier Letter Small B", 3},
    {u"\\^beta", u"U+01D5D", u"ᵝ", u"Modifier Letter Small Beta", 6},
    {u"\\^c", u"U+01D9C", u"ᶜ", u"Modifier Letter Small C", 3},
    {u"\\^chi", u"U+01D61", u"ᵡ", u"Modifier Letter Small Chi", 5},
    {u"\\^d", u"U+01D48", u"ᵈ", u"Modifier Letter Small D", 3},
    {u"\\^delta", u"U+01D5F", u"ᵟ", u"Modifier Letter Small Delta", 7},
    {u"\\^downarrow", u"U+0A71C", u"ꜜ", u"Modifier Letter Raised Down Arrow", 11},
    {u"\\^e", u"U+01D49", u"ᵉ", u"Modifier Letter Small E", 3},
    {u"\\^epsilon", u"U+01D4B", u"ᵋ", u"Modifier Letter Small Open E", 9},
    {u"\\^f", u"U+01DA0", u"ᶠ", u"Modifier Letter Small F", 3},
    {u"\\^g", u"U+01D4D", u"ᵍ", u"Modifier Letter Small G", 3},
    {u"\\^gamma", u"U+01D5E", u"ᵞ", u"Modifier Letter Small Greek Gamma", 7},
    {u"\\^h", u"U+002B0", u"ʰ", u"Modifier Letter Small H", 3},
    {u"\\^i", u"U+02071", u"ⁱ", u"Superscript Latin Small Letter I", 3},
    {u"\\^iota", u"U+01DA5", u"ᶥ", u"Modifier Letter Small Iota", 6},
    {u"\\^j", u"U+002B2", u"ʲ", u"Modifier Letter Small J", 3},
    {u"\\^k", u"U+01D4F", u"ᵏ", u"Modifier Letter Small K", 3},
    {u"\\^l", u"U+002E1", u"ˡ", u"Modifier Letter Small L", 3},
    {u"\\^m", u"U+01D50", u"ᵐ", u"Modifier Letter Small M", 3},
    {u"\\^n", u"U+0207F", u"ⁿ", u"Superscript Latin Small Letter N", 3},
    {u"\\^o", u"U+01D52", u"ᵒ", u"Modifier Letter Small O", 3},
    {u"\\^p", u"U+01D56", u"ᵖ", u"Modifier Letter Small P", 3},
    {u"\\^phi", u"U+01D60", u"ᵠ", u"Modifier Letter Small Greek Phi", 5},
    {u"\\^r", u"U+002B3", u"ʳ", u"Modifier Letter Small R", 3},
    {u"\\^s", u"U+002E2", u"ˢ", u"Modifier Letter Small S", 3},
    {u"\\^t", u"U+01D57", u"ᵗ", u"Modifier Letter Small T", 3},
    {u"\\^theta", u"U+01DBF", u"ᶿ", u"Modifier Letter Small Theta", 7},
    {u"\\^u", u"U+01D58", u"ᵘ", u"Modifier Letter Small U", 3},
    {u"\\^uparrow", u"U+0A71B", u"ꜛ", u"Modifier Letter Raised Up Arrow", 9},
    {u"\\^v", u"U+01D5B", u"ᵛ", u"Modifier Letter Small V", 3},
    {u"\\^w", u"U+002B7", u"ʷ", u"Modifier Letter Small W", 3},
    {u"\\^x", u"U+002E3", u"ˣ", u"Modifier Letter Small X", 3},
    {u"\\^y", u"U+002B8", u"ʸ", u"Modifier Letter Small Y", 3},
    {u"\\^z", u"U+01DBB", u"ᶻ", u"Modifier Letter Small Z", 3},
    {u"\\_(", u"U+0208D", u"₍", u"Subscript Left Parenthesis / Subscript Opening Parenthesis", 3},
    {u"\\_)", u"U+0208E", u"₎", u"Subscript Right Parenthesis / Subscript Closing Parenthesis", 3},
    {u"\\_+", u"U+0208A", u"₊", u"Subscript Plus Sign", 3},
    {u"\\_-", u"U+0208B", u"₋", u"Subscript Minus / Subscript Hyphen-Minus", 3},
    {u"\\_0", u"U+02080", u"₀", u"Subscript Zero / Subscript Digit Zero", 3},
    {u"\\_1", u"U+02081", u"₁", u"Subscript One / Subscript Digit One", 3},
    {u"\\_2", u"U+02082", u"₂", u"Subscript Two / Subscript Digit Two", 3},
    {u"\\_3", u"U+02083", u"₃", u"Subscript Three / Subscript Digit Three", 3},
    {u"\\_4", u"U+02084", u"₄", u"Subscript Four / Subscript Digit Four", 3},
    {u"\\_5", u"U+02085", u"₅", u"Subscript Five / Subscript Digit Five", 3},
    {u"\\_6", u"U+02086", u"₆", u"Subscript Six / Subscript Digit Six", 3},
    {u"\\_7", u"U+02087", u"₇", u"Subscript Seven / Subscript Digit Seven", 3},
    {u"\\_8", u"U+02088", u"₈", u"Subscript Eight / Subscript Digit Eight", 3},
    {u"\\_9", u"U+02089", u"₉", u"Subscript Nine / Subscript Digit Nine", 3},
    {u"\\_=", u"U+0208C", u"₌", u"Subscript Equals Sign", 3},
    {u"\\_a", u"U+02090", u"ₐ", u"Latin Subscript Small Letter A", 3},
    {u"\\_beta", u"U+01D66", u"ᵦ", u"Greek Subscript Small Letter Beta", 6},
    {u"\\_chi", u"U+01D6A", u"ᵪ", u"Greek Subscript Small Letter Chi", 5},
    {u"\\_e", u"U+02091", u"ₑ", u"Latin Subscript Small Letter E", 3},
    {u"\\_gamma", u"U+01D67", u"ᵧ", u"Greek Subscript Small Letter Gamma", 7},
    {u"\\_h", u"U+02095", u"ₕ", u"Latin Subscript Small Letter H", 3},
    {u"\\_i", u"U+01D62", u"ᵢ", u"Latin Subscript Small Letter I", 3},
    {u"\\_j", u"U+02C7C", u"ⱼ", u"Latin Subscript Small Letter J", 3},
    {u"\\_k", u"U+02096", u"ₖ", u"Latin Subscript Small Letter K", 3},
    {u"\\_l", u"U+02097", u"ₗ", u"Latin Subscript Small Letter L", 3},
    {u"\\_m", u"U+02098", u"ₘ", u"Latin Subscript Small Letter M", 3},
    {u"\\_n", u"U+02099", u"ₙ", u"Latin Subscript Small Letter N", 3},
    {u"\\_o", u"U+02092", u"ₒ", u"Latin Subscript Small Letter O", 3},
    {u"\\_p", u"U+0209A", u"ₚ", u"Latin Subscript Small Letter P", 3},
    {u"\\_phi", u"U+01D69", u"ᵩ", u"Greek Subscript Small Letter Phi", 5},
    {u"\\_r", u"U+01D63", u"ᵣ", u"Latin Subscript Small Letter R", 3},
    {u"\\_rho", u"U+01D68", u"ᵨ", u"Greek Subscript Small Letter Rho", 5},
    {u"\\_s", u"U+0209B", u"ₛ", u"Latin Subscript Small Letter S", 3},
    {u"\\_schwa", u"U+02094", u"ₔ", u"Latin Subscript Small Letter Schwa", 7},
    {u"\\_t", u"U+0209C", u"ₜ", u"Latin Subscript Small Letter T", 3},
    {u"\\_u", u"U+01D64", u"ᵤ", u"Latin Subscript Small Letter U", 3},
    {u"\\_v", u"U+01D65", u"ᵥ", u"Latin Subscript Small Letter V", 3},
    {u"\\_x", u"U+02093", u"ₓ", u"Latin Subscript Small Letter X", 3},
    {u"\\aa", u"U+000E5", u"å", u"Latin Small Letter A With Ring Above / Latin Small Letter A Ring", 3},
    {u"\\accurrent", u"U+023E6", u"⏦", u"Ac Current", 10},
    {u"\\acidfree", u"U+0267E", u"♾", u"Permanent Paper Sign", 9},
    {u"\\acute", u"U+00301", u" ́ ", u"Combining Acute Accent / Non-Spacing Acute", 6},
    {u"\\adots", u"U+022F0", u"⋰", u"Up Right Diagonal Ellipsis", 6},
    {u"\\ae", u"U+000E6", u"æ", u"Latin Small Letter Ae / Latin Small Letter A E", 3},
    {u"\\aleph", u"U+02135", u"ℵ", u"Alef Symbol / First Transfinite Cardinal", 6},
    {u"\\allequal", u"U+0224C", u"≌", u"All Equal To", 9},
    {u"\\alpha", u"U+003B1", u"α", u"Greek Small Letter Alpha", 6},
    {u"\\amalg", u"U+02A3F", u"⨿", u"Amalgamation Or Coproduct", 6},
    {u"\\angdnr", u"U+0299F", u"⦟", u"Acute Angle", 7},
    {u"\\angle", u"U+02220", u"∠", u"Angle", 6},
    {u"\\angles", u"U+0299E", u"⦞", u"Angle With S Inside", 7},
    {u"\\angleubar", u"U+029A4", u"⦤", u"Angle With Underbar", 10},
    {u"\\annuity", u"U+020E7", u" ⃧ ", u"Combining Annuity Symbol", 8},
    {u"\\approx", u"U+02248", u"≈", u"Almost Equal To", 7},
    {u"\\approxeq", u"U+0224A", u"≊", u"Almost Equal Or Equal To", 9},
    {u"\\approxeqq", u"U+02A70", u"⩰", u"Approximately Equal Or Equal To", 10},
    {u"\\approxnotequal", u"U+02246", u"≆", u"Approximately But Not Actually Equal To", 15},
    {u"\\aquarius", u"U+02652", u"♒", u"Aquarius", 9},
    {u"\\arceq", u"U+02258", u"≘", u"Corresponds To", 6},
    {u"\\aries", u"U+02648", u"♈", u"Aries", 6},
    {u"\\ast", u"U+02217", u"∗", u"Asterisk Operator", 4},
    {u"\\asteq", u"U+02A6E", u"⩮", u"Equals With Asterisk", 6},
    {u"\\asteraccent", u"U+020F0", u" ⃰ ", u"Combining Asterisk Above", 12},
    {u"\\astrosun", u"U+02609", u"☉", u"Sun", 9},
    {u"\\asymp", u"U+0224D", u"≍", u"Equivalent To", 6},
    {u"\\awint", u"U+02A11", u"⨑", u"Anticlockwise Integration", 6},
    {u"\\backepsilon", u"U+003F6", u"϶", u"Greek Reversed Lunate Epsilon Symbol", 12},
    {u"\\backppprime", u"U+02037", u"‷", u"Reversed Triple Prime", 12},
    {u"\\backpprime", u"U+02036", u"‶", u"Reversed Double Prime", 11},
    {u"\\backprime", u"U+02035", u"‵", u"Reversed Prime", 10},
    {u"\\backsim", u"U+0223D", u"∽", u"Reversed Tilde", 8},
    {u"\\backsimeq", u"U+022CD", u"⋍", u"Reversed Tilde Equals", 10},
    {u"\\bagmember", u"U+022FF", u"⋿", u"Z Notation Bag Membership", 10},
    {u"\\bar", u"U+00304", u" ̄ ", u"Combining Macron / Non-Spacing Macron", 4},
    {u"\\barcap", u"U+02A43", u"⩃", u"Intersection With Overbar", 7},
    {u"\\barcup", u"U+02A42", u"⩂", u"Union With Overbar", 7},
    {u"\\barleftarrow", u"U+021E4", u"⇤", u"Leftwards Arrow To Bar / Left Arrow To Bar", 13},
    {u"\\barleftarrowrightarrowbar", u"U+021B9", u"↹", u"Leftwards Arrow To Bar Over Rightwards Arrow To Bar / Left Arrow To Bar Over Right Arrow To Bar", 26},
    {u"\\barovernorthwestarrow", u"U+021B8", u"↸", u"North West Arrow To Long Bar / Upper Left Arrow To Long Bar", 22},
    {u"\\barrightarrowdiamond", u"U+02920", u"⤠", u"Rightwards Arrow From Bar To Black Diamond", 21},
    {u"\\barvee", u"U+022BD", u"⊽", u"Nor", 7},
    {u"\\barwedge", u"U+022BC", u"⊼", u"Nand", 9},
    {u"\\bbA", u"U+1D538", u"𝔸", u"Mathematical Double-Struck Capital A", 4},
    {u"\\bbB", u"U+1D539", u"𝔹", u"Mathematical Double-Struck Capital B", 4},
    {u"\\bbC", u"U+02102", u"ℂ", u"Double-Struck Capital C / Double-Struck C", 4},
    {u"\\bbD", u"U+1D53B", u"𝔻", u"Mathematical Double-Struck Capital D", 4},
    {u"\\bbE", u"U+1D53C", u"𝔼", u"Mathematical Double-Struck Capital E", 4},
    {u"\\bbF", u"U+1D53D", u"𝔽", u"Mathematical Double-Struck Capital F", 4},
    {u"\\bbG", u"U+1D53E", u"𝔾", u"Mathematical Double-Struck Capital G", 4},
    {u"\\bbGamma", u"U+0213E", u"ℾ", u"Double-Struck Capital Gamma", 8},
    {u"\\bbH", u"U+0210D", u"ℍ", u"Double-Struck Capital H / Double-Struck H", 4},
    {u"\\bbI", u"U+1D540", u"𝕀", u"Mathematical Double-Struck Capital I", 4},
    {u"\\bbJ", u"U+1D541", u"𝕁", u"Mathematical Double-Struck Capital J", 4},
    {u"\\bbK", u"U+1D542", u"𝕂", u"Mathematical Double-Struck Capital K", 4},
    {u"\\bbL", u"U+1D543", u"𝕃", u"Mathematical Double-Struck Capital L", 4},
    {u"\\bbM", u"U+1D544", u"𝕄", u"Mathematical Double-Struck Capital M", 4},
    {u"\\bbN", u"U+02115", u"ℕ", u"Double-Struck Capital N / Double-Struck N", 4},
    {u"\\bbO", u"U+1D546", u"𝕆", u"Mathematical Double-Struck Capital O", 4},
    {u"\\bbP", u"U+02119", u"ℙ", u"Double-Struck Capital P / Double-Struck P", 4},
    {u"\\bbPi", u"U+0213F", u"ℿ", u"Double-Struck Capital Pi", 5},
    {u"\\bbQ", u"U+0211A", u"ℚ", u"Double-Struck Capital Q / Double-Struck Q", 4},
    {u"\\bbR", u"U+0211D", u"ℝ", u"Double-Struck Capital R / Double-Struck R", 4},
    {u"\\bbS", u"U+1D54A", u"𝕊", u"Mathematical Double-Struck Capital S", 4},
    {u"\\bbT", u"U+1D54B", u"𝕋", u"Mathematical Double-Struck Capital T", 4},
    {u"\\bbU", u"U+1D54C", u"𝕌", u"Mathematical Double-Struck Capital U", 4},
    {u"\\bbV", u"U+1D54D", u"𝕍", u"Mathematical Double-Struck Capital V", 4},
    {u"\\bbW", u"U+1D54E", u"𝕎", u"Mathematical Double-Struck Capital W", 4},
    {u"\\bbX", u"U+1D54F", u"𝕏", u"Mathematical Double-Struck Capital X", 4},
    {u"\\bbY", u"U+1D550", u"𝕐", u"Mathematical Double-Struck Capital Y", 4},
    {u"\\bbZ", u"U+02124", u"ℤ", u"Double-Struck Capital Z / Double-Struck Z", 4},
    {u"\\bba", u"U+1D552", u"𝕒", u"Mathematical Double-Struck Small A", 4},
    {u"\\bbb", u"U+1D553", u"𝕓", u"Mathematical Double-Struck Small B", 4},
    {u"\\bbc", u"U+1D554", u"𝕔", u"Mathematical Double-Struck Small C", 4},
    {u"\\bbd", u"U+1D555", u"𝕕", u"Mathematical Double-Struck Small D", 4},
    {u"\\bbe", u"U+1D556", u"𝕖", u"Mathematical Double-Struck Small E", 4},
    {u"\\bbeight", u"U+1D7E0", u"𝟠", u"Mathematical Double-Struck Digit Eight", 8},
    {u"\\bbf", u"U+1D557", u"𝕗", u"Mathematical Double-Struck Small F", 4},
    {u"\\bbfive", u"U+1D7DD", u"𝟝", u"Mathematical Double-Struck Digit Five", 7},
    {u"\\bbfour", u"U+1D7DC", u"𝟜", u"Mathematical Double-Struck Digit Four", 7},
    {u"\\bbg", u"U+1D558", u"𝕘", u"Mathematical Double-Struck Small G", 4},
    {u"\\bbgamma", u"U+0213D", u"ℽ", u"Double-Struck Small Gamma", 8},
    {u"\\bbh", u"U+1D559", u"𝕙", u"Mathematical Double-Struck Small H", 4},
    {u"\\bbi", u"U+1D55A", u"𝕚", u"Mathematical Double-Struck Small I", 4},
    {u"\\bbiD", u"U+02145", u"ⅅ", u"Double-Struck Italic Capital D", 5},
    {u"\\bbid", u"U+02146", u"ⅆ", u"Double-Struck Italic Small D", 5},
    {u"\\bbie", u"U+02147", u"ⅇ", u"Double-Struck Italic Small E", 5},
    {u"\\bbii", u"U+02148", u"ⅈ", u"Double-Struck Italic Small I", 5},
    {u"\\bbij", u"U+02149", u"ⅉ", u"Double-Struck Italic Small J", 5},
    {u"\\bbj", u"U+1D55B", u"𝕛", u"Mathematical Double-Struck Small J", 4},
    {u"\\bbk", u"U+1D55C", u"𝕜", u"Mathematical Double-Struck Small K", 4},
    {u"\\bbl", u"U+1D55D", u"𝕝", u"Mathematical Double-Struck Small L", 4},
    {u"\\bbm", u"U+1D55E", u"𝕞", u"Mathematical Double-Struck Small M", 4},
    {u"\\bbn", u"U+1D55F", u"𝕟", u"Mathematical Double-Struck Small N", 4},
    {u"\\bbnine", u"U+1D7E1", u"𝟡", u"Mathematical Double-Struck Digit Nine", 7},
    {u"\\bbo", u"U+1D560", u"𝕠", u"Mathematical Double-Struck Small O", 4},
    {u"\\bbone", u"U+1D7D9", u"𝟙", u"Mathematical Double-Struck Digit One", 6},
    {u"\\bbp", u"U+1D561", u"𝕡", u"Mathematical Double-Struck Small P", 4},
    {u"\\bbpi", u"U+0213C", u"ℼ", u"Double-Struck Small Pi", 5},
    {u"\\bbq", u"U+1D562", u"𝕢", u"Mathematical Double-Struck Small Q", 4},
    {u"\\bbr", u"U+1D563", u"𝕣", u"Mathematical Double-Struck Small R", 4},
    {u"\\bbrktbrk", u"U+023B6", u"⎶", u"Bottom Square Bracket Over Top Square Bracket", 9},
    {u"\\bbs", u"U+1D564", u"𝕤", u"Mathematical Double-Struck Small S", 4},
    {u"\\bbsemi", u"U+02A1F", u"⨟", u"Z Notation Schema Composition", 7},
    {u"\\bbseven", u"U+1D7DF", u"𝟟", u"Mathematical Double-Struck Digit Seven", 8},
    {u"\\bbsix", u"U+1D7DE", u"𝟞", u"Mathematical Double-Struck Digit Six", 6},
    {u"\\bbsum", u"U+02140", u"⅀", u"Double-Struck N-Ary Summation", 6},
    {u"\\bbt", u"U+1D565", u"𝕥", u"Mathematical Double-Struck Small T", 4},
    {u"\\bbthree", u"U+1D7DB", u"𝟛", u"Mathematical Double-Struck Digit Three", 8},
    {u"\\bbtwo", u"U+1D7DA", u"𝟚", u"Mathematical Double-Struck Digit Two", 6},
    {u"\\bbu", u"U+1D566", u"𝕦", u"Mathematical Double-Struck Small U", 4},
    {u"\\bbv", u"U+1D567", u"𝕧", u"Mathematical Double-Struck Small V", 4},
    {u"\\bbw", u"U+1D568", u"𝕨", u"Mathematical Double-Struck Small W", 4},
    {u"\\bbx", u"U+1D569", u"𝕩", u"Mathematical Double-Struck Small X", 4},
    {u"\\bby", u"U+1D56A", u"𝕪", u"Mathematical Double-Struck Small Y", 4},
    {u"\\bbz", u"U+1D56B", u"𝕫", u"Mathematical Double-Struck Small Z", 4},
    {u"\\bbzero", u"U+1D7D8", u"𝟘", u"Mathematical Double-Struck Digit Zero", 7},
    {u"\\because", u"U+02235", u"∵", u"Because", 8},
    {u"\\benzenr", u"U+023E3", u"⏣", u"Benzene Ring With Circle", 8},
    {u"\\beta", u"U+003B2", u"β", u"Greek Small Letter Beta", 5},
    {u"\\beth", u"U+02136", u"ℶ", u"Bet Symbol / Second Transfinite Cardinal", 5},
    {u"\\between", u"U+0226C", u"≬", u"Between", 8},
    {u"\\bfA", u"U+1D400", u"𝐀", u"Mathematical Bold Capital A", 4},
    {u"\\bfAlpha", u"U+1D6A8", u"𝚨", u"Mathematical Bold Capital Alpha", 8},
    {u"\\bfB", u"U+1D401", u"𝐁", u"Mathematical Bold Capital B", 4},
    {u"\\bfBeta", u"U+1D6A9", u"𝚩", u"Mathematical Bold Capital Beta", 7},
    {u"\\bfC", u"U+1D402", u"𝐂", u"Mathematical Bold Capital C", 4},
    {u"\\bfChi", u"U+1D6BE", u"𝚾", u"Mathematical Bold Capital Chi", 6},
    {u"\\bfD", u"U+1D403", u"𝐃", u"Mathematical Bold Capital D", 4},
    {u"\\bfDelta", u"U+1D6AB", u"𝚫", u"Mathematical Bold Capital Delta", 8},
    {u"\\bfDigamma", u"U+1D7CA", u"𝟊", u"Mathematical Bold Capital Digamma", 10},
    {u"\\bfE", u"U+1D404", u"𝐄", u"Mathematical Bold Capital E", 4},
    {u"\\bfEpsilon", u"U+1D6AC", u"𝚬", u"Mathematical Bold Capital Epsilon", 10},
    {u"\\bfEta", u"U+1D6AE", u"𝚮", u"Mathematical Bold Capital Eta", 6},
    {u"\\bfF", u"U+1D405", u"𝐅", u"Mathematical Bold Capital F", 4},
    {u"\\bfG", u"U+1D406", u"𝐆", u"Mathematical Bold Capital G", 4},
    {u"\\bfGamma", u"U+1D6AA", u"𝚪", u"Mathematical Bold Capital Gamma", 8},
    {u"\\bfH", u"U+1D407", u"𝐇", u"Mathematical Bold Capital H", 4},
    {u"\\bfI", u"U+1D408", u"𝐈", u"Mathematical Bold Capital I", 4},
    {u"\\bfIota", u"U+1D6B0", u"𝚰", u"Mathematical Bold Capital Iota", 7},
    {u"\\bfJ", u"U+1D409", u"𝐉", u"Mathematical Bold Capital J", 4},
    {u"\\bfK", u"U+1D40A", u"𝐊", u"Mathematical Bold Capital K", 4},
    {u"\\bfKappa", u"U+1D6B1", u"𝚱", u"Mathematical Bold Capital Kappa", 8},
    {u"\\bfL", u"U+1D40B", u"𝐋", u"Mathematical Bold Capital L", 4},
    {u"\\bfLambda", u"U+1D6B2", u"𝚲", u"Mathematical Bold Capital Lamda", 9},
    {u"\\bfM", u"U+1D40C", u"𝐌", u"Mathematical Bold Capital M", 4},
    {u"\\bfMu", u"U+1D6B3", u"𝚳", u"Mathematical Bold Capital Mu", 5},
    {u"\\bfN", u"U+1D40D", u"𝐍", u"Mathematical Bold Capital N", 4},
    {u"\\bfNu", u"U+1D6B4", u"𝚴", u"Mathematical Bold Capital Nu", 5},
    {u"\\bfO", u"U+1D40E", u"𝐎", u"Mathematical Bold Capital O", 4},
    {u"\\bfOmega", u"U+1D6C0", u"𝛀", u"Mathematical Bold Capital Omega", 8},
    {u"\\bfOmicron", u"U+1D6B6", u"𝚶", u"Mathematical Bold Capital Omicron", 10},
    {u"\\bfP", u"U+1D40F", u"𝐏", u"Mathematical Bold Capital P", 4},
    {u"\\bfPhi", u"U+1D6BD", u"𝚽", u"Mathematical Bold Capital Phi", 6},
    {u"\\bfPi", u"U+1D6B7", u"𝚷", u"Mathematical Bold Capital Pi", 5},
    {u"\\bfPsi", u"U+1D6BF", u"𝚿", u"Mathematical Bold Capital Psi", 6},
    {u"\\bfQ", u"U+1D410", u"𝐐", u"Mathematical Bold Capital Q", 4},
    {u"\\bfR", u"U+1D411", u"𝐑", u"Mathematical Bold Capital R", 4},
    {u"\\bfRho", u"U+1D6B8", u"𝚸", u"Mathematical Bold Capital Rho", 6},
    {u"\\bfS", u"U+1D412", u"𝐒", u"Mathematical Bold Capital S", 4},
    {u"\\bfSigma", u"U+1D6BA", u"𝚺", u"Mathematical Bold Capital Sigma", 8},
    {u"\\bfT", u"U+1D413", u"𝐓", u"Mathematical Bold Capital T", 4},
    {u"\\bfTau", u"U+1D6BB", u"𝚻", u"Mathematical Bold Capital Tau", 6},
    {u"\\bfTheta", u"U+1D6AF", u"𝚯", u"Mathematical Bold Capital Theta", 8},
    {u"\\bfU", u"U+1D414", u"𝐔", u"Mathematical Bold Capital U", 4},
    {u"\\bfUpsilon", u"U+1D6BC", u"𝚼", u"Mathematical Bold Capital Upsilon", 10},
    {u"\\bfV", u"U+1D415", u"𝐕", u"Mathematical Bold Capital V", 4},
    {u"\\bfW", u"U+1D416", u"𝐖", u"Mathematical Bold Capital W", 4},
    {u"\\bfX", u"U+1D417", u"𝐗", u"Mathematical Bold Capital X", 4},
    {u"\\bfXi", u"U+1D6B5", u"𝚵", u"Mathematical Bold Capital Xi", 5},
    {u"\\bfY", u"U+1D418", u"𝐘", u"Mathematical Bold Capital Y", 4},
    {u"\\bfZ", u"U+1D419", u"𝐙", u"Mathematical Bold Capital Z", 4},
    {u"\\bfZeta", u"U+1D6AD", u"𝚭", u"Mathematical Bold Capital Zeta", 7},
    {u"\\bfa", u"U+1D41A", u"𝐚", u"Mathematical Bold Small A", 4},
    {u"\\bfalpha", u"U+1D6C2", u"𝛂", u"Mathematical Bold Small Alpha", 8},
    {u"\\bfb", u"U+1D41B", u"𝐛", u"Mathematical Bold Small B", 4},
    {u"\\bfbeta", u"U+1D6C3", u"𝛃", u"Mathematical Bold Small Beta", 7},
    {u"\\bfc", u"U+1D41C", u"𝐜", u"Mathematical Bold Small C", 4},
    {u"\\bfchi", u"U+1D6D8", u"𝛘", u"Mathematical Bold Small Chi", 6},
    {u"\\bfd", u"U+1D41D", u"𝐝", u"Mathematical Bold Small D", 4},
    {u"\\bfdelta", u"U+1D6C5", u"𝛅", u"Mathematical Bold Small Delta", 8},
    {u"\\bfdigamma", u"U+1D7CB", u"𝟋", u"Mathematical Bold Small Digamma", 10},
    {u"\\bfe", u"U+1D41E", u"𝐞", u"Mathematical Bold Small E", 4},
    {u"\\bfeight", u"U+1D7D6", u"𝟖", u"Mathematical Bold Digit Eight", 8},
    {u"\\bfepsilon", u"U+1D6C6", u"𝛆", u"Mathematical Bold Small Epsilon", 10},
    {u"\\bfeta", u"U+1D6C8", u"𝛈", u"Mathematical Bold Small Eta", 6},
    {u"\\bff", u"U+1D41F", u"𝐟", u"Mathematical Bold Small F", 4},
    {u"\\bffive", u"U+1D7D3", u"𝟓", u"Mathematical Bold Digit Five", 7},
    {u"\\bffour", u"U+1D7D2", u"𝟒", u"Mathematical Bold Digit Four", 7},
    {u"\\bfg", u"U+1D420", u"𝐠", u"Mathematical Bold Small G", 4},
    {u"\\bfgamma", u"U+1D6C4", u"𝛄", u"Mathematical Bold Small Gamma", 8},
    {u"\\bfh", u"U+1D421", u"𝐡", u"Mathematical Bold Small H", 4},
    {u"\\bfi", u"U+1D422", u"𝐢", u"Mathematical Bold Small I", 4},
    {u"\\bfiota", u"U+1D6CA", u"𝛊", u"Mathematical Bold Small Iota", 7},
    {u"\\bfj", u"U+1D423", u"𝐣", u"Mathematical Bold Small J", 4},
    {u"\\bfk", u"U+1D424", u"𝐤", u"Mathematical Bold Small K", 4},
    {u"\\bfkappa", u"U+1D6CB", u"𝛋", u"Mathematical Bold Small Kappa", 8},
    {u"\\bfl", u"U+1D425", u"𝐥", u"Mathematical Bold Small L", 4},
    {u"\\bflambda", u"U+1D6CC", u"𝛌", u"Mathematical Bold Small Lamda", 9},
    {u"\\bfm", u"U+1D426", u"𝐦", u"Mathematical Bold Small M", 4},
    {u"\\bfmu", u"U+1D6CD", u"𝛍", u"Mathematical Bold Small Mu", 5},
    {u"\\bfn", u"U+1D427", u"𝐧", u"Mathematical Bold Small N", 4},
    {u"\\bfnabla", u"U+1D6C1", u"𝛁", u"Mathematical Bold Nabla", 8},
    {u"\\bfnine", u"U+1D7D7", u"𝟗", u"Mathematical Bold Digit Nine", 7},
    {u"\\bfnu", u"U+1D6CE", u"𝛎", u"Mathematical Bold Small Nu", 5},
    {u"\\bfo", u"U+1D428", u"𝐨", u"Mathematical Bold Small O", 4},
    {u"\\bfomega", u"U+1D6DA", u"𝛚", u"Mathematical Bold Small Omega", 8},
    {u"\\bfomicron", u"U+1D6D0", u"𝛐", u"Mathematical Bold Small Omicron", 10},
    {u"\\bfone", u"U+1D7CF", u"𝟏", u"Mathematical Bold Digit One", 6},
    {u"\\bfp", u"U+1D429", u"𝐩", u"Mathematical Bold Small P", 4},
    {u"\\bfpartial", u"U+1D6DB", u"𝛛", u"Mathematical Bold Partial Differential", 10},
    {u"\\bfphi", u"U+1D6DF", u"𝛟", u"Mathematical Bold Phi Symbol", 6},
    {u"\\bfpi", u"U+1D6D1", u"𝛑", u"Mathematical Bold Small Pi", 5},
    {u"\\bfpsi", u"U+1D6D9", u"𝛙", u"Mathematical Bold Small Psi", 6},
    {u"\\bfq", u"U+1D42A", u"𝐪", u"Mathematical Bold Small Q", 4},
    {u"\\bfr", u"U+1D42B", u"𝐫", u"Mathematical Bold Small R", 4},
    {u"\\bfrakA", u"U+1D56C", u"𝕬", u"Mathematical Bold Fraktur Capital A", 7},
    {u"\\bfrakB", u"U+1D56D", u"𝕭", u"Mathematical Bold Fraktur Capital B", 7},
    {u"\\bfrakC", u"U+1D56E", u"𝕮", u"Mathematical Bold Fraktur Capital C", 7},
    {u"\\bfrakD", u"U+1D56F", u"𝕯", u"Mathematical Bold Fraktur Capital D", 7},
    {u"\\bfrakE", u"U+1D570", u"𝕰", u"Mathematical Bold Fraktur Capital E", 7},
    {u"\\bfrakF", u"U+1D571", u"𝕱", u"Mathematical Bold Fraktur Capital F", 7},
    {u"\\bfrakG", u"U+1D572", u"𝕲", u"Mathematical Bold Fraktur Capital G", 7},
    {u"\\bfrakH", u"U+1D573", u"𝕳", u"Mathematical Bold Fraktur Capital H", 7},
    {u"\\bfrakI", u"U+1D574", u"𝕴", u"Mathematical Bold Fraktur Capital I", 7},
    {u"\\bfrakJ", u"U+1D575", u"𝕵", u"Mathematical Bold Fraktur Capital J", 7},
    {u"\\bfrakK", u"U+1D576", u"𝕶", u"Mathematical Bold Fraktur Capital K", 7},
    {u"\\bfrakL", u"U+1D577", u"𝕷", u"Mathematical Bold Fraktur Capital L", 7},
    {u"\\bfrakM", u"U+1D578", u"𝕸", u"Mathematical Bold Fraktur Capital M", 7},
    {u"\\bfrakN", u"U+1D579", u"𝕹", u"Mathematical Bold Fraktur Capital N", 7},
    {u"\\bfrakO", u"U+1D57A", u"𝕺", u"Mathematical Bold Fraktur Capital O", 7},
    {u"\\bfrakP", u"U+1D57B", u"𝕻", u"Mathematical Bold Fraktur Capital P", 7},
    {u"\\bfrakQ", u"U+1D57C", u"𝕼", u"Mathematical Bold Fraktur Capital Q", 7},
    {u"\\bfrakR", u"U+1D57D", u"𝕽", u"Mathematical Bold Fraktur Capital R", 7},
    {u"\\bfrakS", u"U+1D57E", u"𝕾", u"Mathematical Bold Fraktur Capital S", 7},
    {u"\\bfrakT", u"U+1D57F", u"𝕿", u"Mathematical Bold Fraktur Capital T", 7},
    {u"\\bfrakU", u"U+1D580", u"𝖀", u"Mathematical Bold Fraktur Capital U", 7},
    {u"\\bfrakV", u"U+1D581", u"𝖁", u"Mathematical Bold Fraktur Capital V", 7},
    {u"\\bfrakW", u"U+1D582", u"𝖂", u"Mathematical Bold Fraktur Capital W", 7},
    {u"\\bfrakX", u"U+1D583", u"𝖃", u"Mathematical Bold Fraktur Capital X", 7},
    {u"\\bfrakY", u"U+1D584", u"𝖄", u"Mathematical Bold Fraktur Capital Y", 7},
    {u"\\bfrakZ", u"U+1D585", u"𝖅", u"Mathematical Bold Fraktur Capital Z", 7},
    {u"\\bfraka", u"U+1D586", u"𝖆", u"Mathematical Bold Fraktur Small A", 7},
    {u"\\bfrakb", u"U+1D587", u"𝖇", u"Mathematical Bold Fraktur Small B", 7},
    {u"\\bfrakc", u"U+1D588", u"𝖈", u"Mathematical Bold Fraktur Small C", 7},
    {u"\\bfrakd", u"U+1D589", u"𝖉", u"Mathematical Bold Fraktur Small D", 7},
    {u"\\bfrake", u"U+1D58A", u"𝖊", u"Mathematical Bold Fraktur Small E", 7},
    {u"\\bfrakf", u"U+1D58B", u"𝖋", u"Mathematical Bold Fraktur Small F", 7},
    {u"\\bfrakg", u"U+1D58C", u"𝖌", u"Mathematical Bold Fraktur Small G", 7},
    {u"\\bfrakh", u"U+1D58D", u"𝖍", u"Mathematical Bold Fraktur Small H", 7},
    {u"\\bfraki", u"U+1D58E", u"𝖎", u"Mathematical Bold Fraktur Small I", 7},
    {u"\\bfrakj", u"U+1D58F", u"𝖏", u"Mathematical Bold Fraktur Small J", 7},
    {u"\\bfrakk", u"U+1D590", u"𝖐", u"Mathematical Bold Fraktur Small K", 7},
    {u"\\bfrakl", u"U+1D591", u"𝖑", u"Mathematical Bold Fraktur Small L", 7},
    {u"\\bfrakm", u"U+1D592", u"𝖒", u"Mathematical Bold Fraktur Small M", 7},
    {u"\\bfrakn", u"U+1D593", u"𝖓", u"Mathematical Bold Fraktur Small N", 7},
    {u"\\bfrako", u"U+1D594", u"𝖔", u"Mathematical Bold Fraktur Small O", 7},
    {u"\\bfrakp", u"U+1D595", u"𝖕", u"Mathematical Bold Fraktur Small P", 7},
    {u"\\bfrakq", u"U+1D596", u"𝖖", u"Mathematical Bold Fraktur Small Q", 7},
    {u"\\bfrakr", u"U+1D597", u"𝖗", u"Mathematical Bold Fraktur Small R", 7},
    {u"\\bfraks", u"U+1D598", u"𝖘", u"Mathematical Bold Fraktur Small S", 7},
    {u"\\bfrakt", u"U+1D599", u"𝖙", u"Mathematical Bold Fraktur Small T", 7},
    {u"\\bfraku", u"U+1D59A", u"𝖚", u"Mathematical Bold Fraktur Small U", 7},
    {u"\\bfrakv", u"U+1D59B", u"𝖛", u"Mathematical Bold Fraktur Small V", 7},
    {u"\\bfrakw", u"U+1D59C", u"𝖜", u"Mathematical Bold Fraktur Small W", 7},
    {u"\\bfrakx", u"U+1D59D", u"𝖝", u"Mathematical Bold Fraktur Small X", 7},
    {u"\\bfraky", u"U+1D59E", u"𝖞", u"Mathematical Bold Fraktur Small Y", 7},
    {u"\\bfrakz", u"U+1D59F", u"𝖟", u"Mathematical Bold Fraktur Small Z", 7},
    {u"\\bfrho", u"U+1D6D2", u"𝛒", u"Mathematical Bold Small Rho", 6},
    {u"\\bfs", u"U+1D42C", u"𝐬", u"Mathematical Bold Small S", 4},
    {u"\\bfseven", u"U+1D7D5", u"𝟕", u"Mathematical Bold Digit Seven", 8},
    {u"\\bfsigma", u"U+1D6D4", u"𝛔", u"Mathematical Bold Small Sigma", 8},
    {u"\\bfsix", u"U+1D7D4", u"𝟔", u"Mathematical Bold Digit Six", 6},
    {u"\\bft", u"U+1D42D", u"𝐭", u"Mathematical Bold Small T", 4},
    {u"\\bftau", u"U+1D6D5", u"𝛕", u"Mathematical Bold Small Tau", 6},
    {u"\\bftheta", u"U+1D6C9", u"𝛉", u"Mathematical Bold Small Theta", 8},
    {u"\\bfthree", u"U+1D7D1", u"𝟑", u"Mathematical Bold Digit Three", 8},
    {u"\\bftwo", u"U+1D7D0", u"𝟐", u"Mathematical Bold Digit Two", 6},
    {u"\\bfu", u"U+1D42E", u"𝐮", u"Mathematical Bold Small U", 4},
    {u"\\bfupsilon", u"U+1D6D6", u"𝛖", u"Mathematical Bold Small Upsilon", 10},
    {u"\\bfv", u"U+1D42F", u"𝐯", u"Mathematical Bold Small V", 4},
    {u"\\bfvarTheta", u"U+1D6B9", u"𝚹", u"Mathematical Bold Capital Theta Symbol", 11},
    {u"\\bfvarepsilon", u"U+1D6DC", u"𝛜", u"Mathematical Bold Epsilon Symbol", 13},
    {u"\\bfvarkappa", u"U+1D6DE", u"𝛞", u"Mathematical Bold Kappa Symbol", 11},
    {u"\\bfvarphi", u"U+1D6D7", u"𝛗", u"Mathematical Bold Small Phi", 9},
    {u"\\bfvarpi", u"U+1D6E1", u"𝛡", u"Mathematical Bold Pi Symbol", 8},
    {u"\\bfvarrho", u"U+1D6E0", u"𝛠", u"Mathematical Bold Rho Symbol", 9},
    {u"\\bfvarsigma", u"U+1D6D3", u"𝛓", u"Mathematical Bold Small Final Sigma", 11},
    {u"\\bfvartheta", u"U+1D6DD", u"𝛝", u"Mathematical Bold Theta Symbol", 11},
    {u"\\bfw", u"U+1D430", u"𝐰", u"Mathematical Bold Small W", 4},
    {u"\\bfx", u"U+1D431", u"𝐱", u"Mathematical Bold Small X", 4},
    {u"\\bfxi", u"U+1D6CF", u"𝛏", u"Mathematical Bold Small Xi", 5},
    {u"\\bfy", u"U+1D432", u"𝐲", u"Mathematical Bold Small Y", 4},
    {u"\\bfz", u"U+1D433", u"𝐳", u"Mathematical Bold Small Z", 4},
    {u"\\bfzero", u"U+1D7CE", u"𝟎", u"Mathematical Bold Digit Zero", 7},
    {u"\\bfzeta", u"U+1D6C7", u"𝛇", u"Mathematical Bold Small Zeta", 7},
    {u"\\biA", u"U+1D468", u"𝑨", u"Mathematical Bold Italic Capital A", 4},
    {u"\\biAlpha", u"U+1D71C", u"𝜜", u"Mathematical Bold Italic Capital Alpha", 8},
    {u"\\biB", u"U+1D469", u"𝑩", u"Mathematical Bold Italic Capital B", 4},
    {u"\\biBeta", u"U+1D71D", u"𝜝", u"Mathematical Bold Italic Capital Beta", 7},
    {u"\\biC", u"U+1D46A", u"𝑪", u"Mathematical Bold Italic Capital C", 4},
    {u"\\biChi", u"U+1D732", u"𝜲", u"Mathematical Bold Italic Capital Chi", 6},
    {u"\\biD", u"U+1D46B", u"𝑫", u"Mathematical Bold Italic Capital D", 4},
    {u"\\biDelta", u"U+1D71F", u"𝜟", u"Mathematical Bold Italic Capital Delta", 8},
    {u"\\biE", u"U+1D46C", u"𝑬", u"Mathematical Bold Italic Capital E", 4},
    {u"\\biEpsilon", u"U+1D720", u"𝜠", u"Mathematical Bold Italic Capital Epsilon", 10},
    {u"\\biEta", u"U+1D722", u"𝜢", u"Mathematical Bold Italic Capital Eta", 6},
    {u"\\biF", u"U+1D46D", u"𝑭", u"Mathematical Bold Italic Capital F", 4},
    {u"\\biG", u"U+1D46E", u"𝑮", u"Mathematical Bold Italic Capital G", 4},
    {u"\\biGamma", u"U+1D71E", u"𝜞", u"Mathematical Bold Italic Capital Gamma", 8},
    {u"\\biH", u"U+1D46F", u"𝑯", u"Mathematical Bold Italic Capital H", 4},
    {u"\\biI", u"U+1D470", u"𝑰", u"Mathematical Bold Italic Capital I", 4},
    {u"\\biIota", u"U+1D724", u"𝜤", u"Mathematical Bold Italic Capital Iota", 7},
    {u"\\biJ", u"U+1D471", u"𝑱", u"Mathematical Bold Italic Capital J", 4},
    {u"\\biK", u"U+1D472", u"𝑲", u"Mathematical Bold Italic Capital K", 4},
    {u"\\biKappa", u"U+1D725", u"𝜥", u"Mathematical Bold Italic Capital Kappa", 8},
    {u"\\biL", u"U+1D473", u"𝑳", u"Mathematical Bold Italic Capital L", 4},
    {u"\\biLambda", u"U+1D726", u"𝜦", u"Mathematical Bold Italic Capital Lamda", 9},
    {u"\\biM", u"U+1D474", u"𝑴", u"Mathematical Bold Italic Capital M", 4},
    {u"\\biMu", u"U+1D727", u"𝜧", u"Mathematical Bold Italic Capital Mu", 5},
    {u"\\biN", u"U+1D475", u"𝑵", u"Mathematical Bold Italic Capital N", 4},
    {u"\\biNu", u"U+1D728", u"𝜨", u"Mathematical Bold Italic Capital Nu", 5},
    {u"\\biO", u"U+1D476", u"𝑶", u"Mathematical Bold Italic Capital O", 4},
    {u"\\biOmega", u"U+1D734", u"𝜴", u"Mathematical Bold Italic Capital Omega", 8},
    {u"\\biOmicron", u"U+1D72A", u"𝜪", u"Mathematical Bold Italic Capital Omicron", 10},
    {u"\\biP", u"U+1D477", u"𝑷", u"Mathematical Bold Italic Capital P", 4},
    {u"\\biPhi", u"U+1D731", u"𝜱", u"Mathematical Bold Italic Capital Phi", 6},
    {u"\\biPi", u"U+1D72B", u"𝜫", u"Mathematical Bold Italic Capital Pi", 5},
    {u"\\biPsi", u"U+1D733", u"𝜳", u"Mathematical Bold Italic Capital Psi", 6},
    {u"\\biQ", u"U+1D478", u"𝑸", u"Mathematical Bold Italic Capital Q", 4},
    {u"\\biR", u"U+1D479", u"𝑹", u"Mathematical Bold Italic Capital R", 4},
    {u"\\biRho", u"U+1D72C", u"𝜬", u"Mathematical Bold Italic Capital Rho", 6},
    {u"\\biS", u"U+1D47A", u"𝑺", u"Mathematical Bold Italic Capital S", 4},
    {u"\\biSigma", u"U+1D72E", u"𝜮", u"Mathematical Bold Italic Capital Sigma", 8},
    {u"\\biT", u"U+1D47B", u"𝑻", u"Mathematical Bold Italic Capital T", 4},
    {u"\\biTau", u"U+1D72F", u"𝜯", u"Mathematical Bold Italic Capital Tau", 6},
    {u"\\biTheta", u"U+1D723", u"𝜣", u"Mathematical Bold Italic Capital Theta", 8},
    {u"\\biU", u"U+1D47C", u"𝑼", u"Mathematical Bold Italic Capital U", 4},
    {u"\\biUpsilon", u"U+1D730", u"𝜰", u"Mathematical Bold Italic Capital Upsilon", 10},
    {u"\\biV", u"U+1D47D", u"𝑽", u"Mathematical Bold Italic Capital V", 4},
    {u"\\biW", u"U+1D47E", u"𝑾", u"Mathematical Bold Italic Capital W", 4},
    {u"\\biX", u"U+1D47F", u"𝑿", u"Mathematical Bold Italic Capital X", 4},
    {u"\\biXi", u"U+1D729", u"𝜩", u"Mathematical Bold Italic Capital Xi", 5},
    {u"\\biY", u"U+1D480", u"𝒀", u"Mathematical Bold Italic Capital Y", 4},
    {u"\\biZ", u"U+1D481", u"𝒁", u"Mathematical Bold Italic Capital Z", 4},
    {u"\\biZeta", u"U+1D721", u"𝜡", u"Mathematical Bold Italic Capital Zeta", 7},
    {u"\\bia", u"U+1D482", u"𝒂", u"Mathematical Bold Italic Small A", 4},
    {u"\\bialpha", u"U+1D736", u"𝜶", u"Mathematical Bold Italic Small Alpha", 8},
    {u"\\bib", u"U+1D483", u"𝒃", u"Mathematical Bold Italic Small B", 4},
    {u"\\bibeta", u"U+1D737", u"𝜷", u"Mathematical Bold Italic Small Beta", 7},
    {u"\\bic", u"U+1D484", u"𝒄", u"Mathematical Bold Italic Small C", 4},
    {u"\\bichi", u"U+1D74C", u"𝝌", u"Mathematical Bold Italic Small Chi", 6},
    {u"\\bid", u"U+1D485", u"𝒅", u"Mathematical Bold Italic Small D", 4},
    {u"\\bidelta", u"U+1D739", u"𝜹", u"Mathematical Bold Italic Small Delta", 8},
    {u"\\bie", u"U+1D486", u"𝒆", u"Mathematical Bold Italic Small E", 4},
    {u"\\biepsilon", u"U+1D73A", u"𝜺", u"Mathematical Bold Italic Small Epsilon", 10},
    {u"\\bieta", u"U+1D73C", u"𝜼", u"Mathematical Bold Italic Small Eta", 6},
    {u"\\bif", u"U+1D487", u"𝒇", u"Mathematical Bold Italic Small F", 4},
    {u"\\big", u"U+1D488", u"𝒈", u"Mathematical Bold Italic Small G", 4},
    {u"\\bigamma", u"U+1D738", u"𝜸", u"Mathematical Bold Italic Small Gamma", 8},
    {u"\\bigblacktriangledown", u"U+025BC", u"▼", u"Black Down-Pointing Triangle / Black Down Pointing Triangle", 21},
    {u"\\bigblacktriangleup", u"U+025B2", u"▲", u"Black Up-Pointing Triangle / Black Up Pointing Triangle", 19},
    {u"\\bigbot", u"U+027D8", u"⟘", u"Large Up Tack", 7},
    {u"\\bigcap", u"U+022C2", u"⋂", u"N-Ary Intersection", 7},
    {u"\\bigcirc", u"U+025CB", u"○", u"White Circle", 8},
    {u"\\bigcup", u"U+022C3", u"⋃", u"N-Ary Union", 7},
    {u"\\bigcupdot", u"U+02A03", u"⨃", u"N-Ary Union Operator With Dot", 10},
    {u"\\bigodot", u"U+02A00", u"⨀", u"N-Ary Circled Dot Operator", 8},
    {u"\\bigoplus", u"U+02A01", u"⨁", u"N-Ary Circled Plus Operator", 9},
    {u"\\bigotimes", u"U+02A02", u"⨂", u"N-Ary Circled Times Operator", 10},
    {u"\\bigslopedvee", u"U+02A57", u"⩗", u"Sloping Large Or", 13},
    {u"\\bigslopedwedge", u"U+02A58", u"⩘", u"Sloping Large And", 15},
    {u"\\bigsqcap", u"U+02A05", u"⨅", u"N-Ary Square Intersection Operator", 9},
    {u"\\bigsqcup", u"U+02A06", u"⨆", u"N-Ary Square Union Operator", 9},
    {u"\\bigstar", u"U+02605", u"★", u"Black Star", 8},
    {u"\\bigtimes", u"U+02A09", u"⨉", u"N-Ary Times Operator", 9},
    {u"\\bigtop", u"U+027D9", u"⟙", u"Large Down Tack", 7},
    {u"\\bigtriangledown", u"U+025BD", u"▽", u"White Down-Pointing Triangle / White Down Pointing Triangle", 16},
    {u"\\bigtriangleup", u"U+025B3", u"△", u"White Up-Pointing Triangle / White Up Pointing Triangle", 14},
    {u"\\biguplus", u"U+02A04", u"⨄", u"N-Ary Union Operator With Plus", 9},
    {u"\\bigvee", u"U+022C1", u"⋁", u"N-Ary Logical Or", 7},
    {u"\\bigwedge", u"U+022C0", u"⋀", u"N-Ary Logical And", 9},
    {u"\\bigwhitestar", u"U+02606", u"☆", u"White Star", 13},
    {u"\\bih", u"U+1D489", u"𝒉", u"Mathematical Bold Italic Small H", 4},
    {u"\\bii", u"U+1D48A", u"𝒊", u"Mathematical Bold Italic Small I", 4},
    {u"\\biiota", u"U+1D73E", u"𝜾", u"Mathematical Bold Italic Small Iota", 7},
    {u"\\bij", u"U+1D48B", u"𝒋", u"Mathematical Bold Italic Small J", 4},
    {u"\\bik", u"U+1D48C", u"𝒌", u"Mathematical Bold Italic Small K", 4},
    {u"\\bikappa", u"U+1D73F", u"𝜿", u"Mathematical Bold Italic Small Kappa", 8},
    {u"\\bil", u"U+1D48D", u"𝒍", u"Mathematical Bold Italic Small L", 4},
    {u"\\bilambda", u"U+1D740", u"𝝀", u"Mathematical Bold Italic Small Lamda", 9},
    {u"\\bim", u"U+1D48E", u"𝒎", u"Mathematical Bold Italic Small M", 4},
    {u"\\bimu", u"U+1D741", u"𝝁", u"Mathematical Bold Italic Small Mu", 5},
    {u"\\bin", u"U+1D48F", u"𝒏", u"Mathematical Bold Italic Small N", 4},
    {u"\\binabla", u"U+1D735", u"𝜵", u"Mathematical Bold Italic Nabla", 8},
    {u"\\binu", u"U+1D742", u"𝝂", u"Mathematical Bold Italic Small Nu", 5},
    {u"\\bio", u"U+1D490", u"𝒐", u"Mathematical Bold Italic Small O", 4},
    {u"\\biomega", u"U+1D74E", u"𝝎", u"Mathematical Bold Italic Small Omega", 8},
    {u"\\biomicron", u"U+1D744", u"𝝄", u"Mathematical Bold Italic Small Omicron", 10},
    {u"\\bip", u"U+1D491", u"𝒑", u"Mathematical Bold Italic Small P", 4},
    {u"\\bipartial", u"U+1D74F", u"𝝏", u"Mathematical Bold Italic Partial Differential", 10},
    {u"\\biphi", u"U+1D74B", u"𝝋", u"Mathematical Bold Italic Small Phi", 6},
    {u"\\bipi", u"U+1D745", u"𝝅", u"Mathematical Bold Italic Small Pi", 5},
    {u"\\bipsi", u"U+1D74D", u"𝝍", u"Mathematical Bold Italic Small Psi", 6},
    {u"\\biq", u"U+1D492", u"𝒒", u"Mathematical Bold Italic Small Q", 4},
    {u"\\bir", u"U+1D493", u"𝒓", u"Mathematical Bold Italic Small R", 4},
    {u"\\birho", u"U+1D746", u"𝝆", u"Mathematical Bold Italic Small Rho", 6},
    {u"\\bis", u"U+1D494", u"𝒔", u"Mathematical Bold Italic Small S", 4},
    {u"\\bisansA", u"U+1D63C", u"𝘼", u"Mathematical Sans-Serif Bold Italic Capital A", 8},
    {u"\\bisansAlpha", u"U+1D790", u"𝞐", u"Mathematical Sans-Serif Bold Italic Capital Alpha", 12},
    {u"\\bisansB", u"U+1D63D", u"𝘽", u"Mathematical Sans-Serif Bold Italic Capital B", 8},
    {u"\\bisansBeta", u"U+1D791", u"𝞑", u"Mathematical Sans-Serif Bold Italic Capital Beta", 11},
    {u"\\bisansC", u"U+1D63E", u"𝘾", u"Mathematical Sans-Serif Bold Italic Capital C", 8},
    {u"\\bisansChi", u"U+1D7A6", u"𝞦", u"Mathematical Sans-Serif Bold Italic Capital Chi", 10},
    {u"\\bisansD", u"U+1D63F", u"𝘿", u"Mathematical Sans-Serif Bold Italic Capital D", 8},
    {u"\\bisansDelta", u"U+1D793", u"𝞓", u"Mathematical Sans-Serif Bold Italic Capital Delta", 12},
    {u"\\bisansE", u"U+1D640", u"𝙀", u"Mathematical Sans-Serif Bold Italic Capital E", 8},
    {u"\\bisansEpsilon", u"U+1D794", u"𝞔", u"Mathematical Sans-Serif Bold Italic Capital Epsilon", 14},
    {u"\\bisansEta", u"U+1D796", u"𝞖", u"Mathematical Sans-Serif Bold Italic Capital Eta", 10},
    {u"\\bisansF", u"U+1D641", u"𝙁", u"Mathematical Sans-Serif Bold Italic Capital F", 8},
    {u"\\bisansG", u"U+1D642", u"𝙂", u"Mathematical Sans-Serif Bold Italic Capital G", 8},
    {u"\\bisansGamma", u"U+1D792", u"𝞒", u"Mathematical Sans-Serif Bold Italic Capital Gamma", 12},
    {u"\\bisansH", u"U+1D643", u"𝙃", u"Mathematical Sans-Serif Bold Italic Capital H", 8},
    {u"\\bisansI", u"U+1D644", u"𝙄", u"Mathematical Sans-Serif Bold Italic Capital I", 8},
    {u"\\bisansIota", u"U+1D798", u"𝞘", u"Mathematical Sans-Serif Bold Italic Capital Iota", 11},
    {u"\\bisansJ", u"U+1D645", u"𝙅", u"Mathematical Sans-Serif Bold Italic Capital J", 8},
    {u"\\bisansK", u"U+1D646", u"𝙆", u"Mathematical Sans-Serif Bold Italic Capital K", 8},
    {u"\\bisansKappa", u"U+1D799", u"𝞙", u"Mathematical Sans-Serif Bold Italic Capital Kappa", 12},
    {u"\\bisansL", u"U+1D647", u"𝙇", u"Mathematical Sans-Serif Bold Italic Capital L", 8},
    {u"\\bisansLambda", u"U+1D79A", u"𝞚", u"Mathematical Sans-Serif Bold Italic Capital Lamda", 13},
    {u"\\bisansM", u"U+1D648", u"𝙈", u"Mathematical Sans-Serif Bold Italic Capital M", 8},
    {u"\\bisansMu", u"U+1D79B", u"𝞛", u"Mathematical Sans-Serif Bold Italic Capital Mu", 9},
    {u"\\bisansN", u"U+1D649", u"𝙉", u"Mathematical Sans-Serif Bold Italic Capital N", 8},
    {u"\\bisansNu", u"U+1D79C", u"𝞜", u"Mathematical Sans-Serif Bold Italic Capital Nu", 9},
    {u"\\bisansO", u"U+1D64A", u"𝙊", u"Mathematical Sans-Serif Bold Italic Capital O", 8},
    {u"\\bisansOmega", u"U+1D7A8", u"𝞨", u"Mathematical Sans-Serif Bold Italic Capital Omega", 12},
    {u"\\bisansOmicron", u"U+1D79E", u"𝞞", u"Mathematical Sans-Serif Bold Italic Capital Omicron", 14},
    {u"\\bisansP", u"U+1D64B", u"𝙋", u"Mathematical Sans-Serif Bold Italic Capital P", 8},
    {u"\\bisansPhi", u"U+1D7A5", u"𝞥", u"Mathematical Sans-Serif Bold Italic Capital Phi", 10},
    {u"\\bisansPi", u"U+1D79F", u"𝞟", u"Mathematical Sans-Serif Bold Italic Capital Pi", 9},
    {u"\\bisansPsi", u"U+1D7A7", u"𝞧", u"Mathematical Sans-Serif Bold Italic Capital Psi", 10},
    {u"\\bisansQ", u"U+1D64C", u"𝙌", u"Mathematical Sans-Serif Bold Italic Capital Q", 8},
    {u"\\bisansR", u"U+1D64D", u"𝙍", u"Mathematical Sans-Serif Bold Italic Capital R", 8},
    {u"\\bisansRho", u"U+1D7A0", u"𝞠", u"Mathematical Sans-Serif Bold Italic Capital Rho", 10},
    {u"\\bisansS", u"U+1D64E", u"𝙎", u"Mathematical Sans-Serif Bold Italic Capital S", 8},
    {u"\\bisansSigma", u"U+1D7A2", u"𝞢", u"Mathematical Sans-Serif Bold Italic Capital Sigma", 12},
    {u"\\bisansT", u"U+1D64F", u"𝙏", u"Mathematical Sans-Serif Bold Italic Capital T", 8},
    {u"\\bisansTau", u"U+1D7A3", u"𝞣", u"Mathematical Sans-Serif Bold Italic Capital Tau", 10},
    {u"\\bisansTheta", u"U+1D797", u"𝞗", u"Mathematical Sans-Serif Bold Italic Capital Theta", 12},
    {u"\\bisansU", u"U+1D650", u"𝙐", u"Mathematical Sans-Serif Bold Italic Capital U", 8},
    {u"\\bisansUpsilon", u"U+1D7A4", u"𝞤", u"Mathematical Sans-Serif Bold Italic Capital Upsilon", 14},
    {u"\\bisansV", u"U+1D651", u"𝙑", u"Mathematical Sans-Serif Bold Italic Capital V", 8},
    {u"\\bisansW", u"U+1D652", u"𝙒", u"Mathematical Sans-Serif Bold Italic Capital W", 8},
    {u"\\bisansX", u"U+1D653", u"𝙓", u"Mathematical Sans-Serif Bold Italic Capital X", 8},
    {u"\\bisansXi", u"U+1D79D", u"𝞝", u"Mathematical Sans-Serif Bold Italic Capital Xi", 9},
    {u"\\bisansY", u"U+1D654", u"𝙔", u"Mathematical Sans-Serif Bold Italic Capital Y", 8},
    {u"\\bisansZ", u"U+1D655", u"𝙕", u"Mathematical Sans-Serif Bold Italic Capital Z", 8},
    {u"\\bisansZeta", u"U+1D795", u"𝞕", u"Mathematical Sans-Serif Bold Italic Capital Zeta", 11},
    {u"\\bisansa", u"U+1D656", u"𝙖", u"Mathematical Sans-Serif Bold Italic Small A", 8},
    {u"\\bisansalpha", u"U+1D7AA", u"𝞪", u"Mathematical Sans-Serif Bold Italic Small Alpha", 12},
    {u"\\bisansb", u"U+1D657", u"𝙗", u"Mathematical Sans-Serif Bold Italic Small B", 8},
    {u"\\bisansbeta", u"U+1D7AB", u"𝞫", u"Mathematical Sans-Serif Bold Italic Small Beta", 11},
    {u"\\bisansc", u"U+1D658", u"𝙘", u"Mathematical Sans-Serif Bold Italic Small C", 8},
    {u"\\bisanschi", u"U+1D7C0", u"𝟀", u"Mathematical Sans-Serif Bold Italic Small Chi", 10},
    {u"\\bisansd", u"U+1D659", u"𝙙", u"Mathematical Sans-Serif Bold Italic Small D", 8},
    {u"\\bisansdelta", u"U+1D7AD", u"𝞭", u"Mathematical Sans-Serif Bold Italic Small Delta", 12},
    {u"\\bisanse", u"U+1D65A", u"𝙚", u"Mathematical Sans-Serif Bold Italic Small E", 8},
    {u"\\bisansepsilon", u"U+1D7AE", u"𝞮", u"Mathematical Sans-Serif Bold Italic Small Epsilon", 14},
    {u"\\bisanseta", u"U+1D7B0", u"𝞰", u"Mathematical Sans-Serif Bold Italic Small Eta", 10},
    {u"\\bisansf", u"U+1D65B", u"𝙛", u"Mathematical Sans-Serif Bold Italic Small F", 8},
    {u"\\bisansg", u"U+1D65C", u"𝙜", u"Mathematical Sans-Serif Bold Italic Small G", 8},
    {u"\\bisansgamma", u"U+1D7AC", u"𝞬", u"Mathematical Sans-Serif Bold Italic Small Gamma", 12},
    {u"\\bisansh", u"U+1D65D", u"𝙝", u"Mathematical Sans-Serif Bold Italic Small H", 8},
    {u"\\bisansi", u"U+1D65E", u"𝙞", u"Mathematical Sans-Serif Bold Italic Small I", 8},
    {u"\\bisansiota", u"U+1D7B2", u"𝞲", u"Mathematical Sans-Serif Bold Italic Small Iota", 11},
    {u"\\bisansj", u"U+1D65F", u"𝙟", u"Mathematical Sans-Serif Bold Italic Small J", 8},
    {u"\\bisansk", u"U+1D660", u"𝙠", u"Mathematical Sans-Serif Bold Italic Small K", 8},
    {u"\\bisanskappa", u"U+1D7B3", u"𝞳", u"Mathematical Sans-Serif Bold Italic Small Kappa", 12},
    {u"\\bisansl", u"U+1D661", u"𝙡", u"Mathematical Sans-Serif Bold Italic Small L", 8},
    {u"\\bisanslambda", u"U+1D7B4", u"𝞴", u"Mathematical Sans-Serif Bold Italic Small Lamda", 13},
    {u"\\bisansm", u"U+1D662", u"𝙢", u"Mathematical Sans-Serif Bold Italic Small M", 8},
    {u"\\bisansmu", u"U+1D7B5", u"𝞵", u"Mathematical Sans-Serif Bold Italic Small Mu", 9},
    {u"\\bisansn", u"U+1D663", u"𝙣", u"Mathematical Sans-Serif Bold Italic Small N", 8},
    {u"\\bisansnabla", u"U+1D7A9", u"𝞩", u"Mathematical Sans-Serif Bold Italic Nabla", 12},
    {u"\\bisansnu", u"U+1D7B6", u"𝞶", u"Mathematical Sans-Serif Bold Italic Small Nu", 9},
    {u"\\bisanso", u"U+1D664", u"𝙤", u"Mathematical Sans-Serif Bold Italic Small O", 8},
    {u"\\bisansomega", u"U+1D7C2", u"𝟂", u"Mathematical Sans-Serif Bold Italic Small Omega", 12},
    {u"\\bisansomicron", u"U+1D7B8", u"𝞸", u"Mathematical Sans-Serif Bold Italic Small Omicron", 14},
    {u"\\bisansp", u"U+1D665", u"𝙥", u"Mathematical Sans-Serif Bold Italic Small P", 8},
    {u"\\bisanspartial", u"U+1D7C3", u"𝟃", u"Mathematical Sans-Serif Bold Italic Partial Differential", 14},
    {u"\\bisansphi", u"U+1D7BF", u"𝞿", u"Mathematical Sans-Serif Bold Italic Small Phi", 10},
    {u"\\bisanspi", u"U+1D7B9", u"𝞹", u"Mathematical Sans-Serif Bold Italic Small Pi", 9},
    {u"\\bisanspsi", u"U+1D7C1", u"𝟁", u"Mathematical Sans-Serif Bold Italic Small Psi", 10},
    {u"\\bisansq", u"U+1D666", u"𝙦", u"Mathematical Sans-Serif Bold Italic Small Q", 8},
    {u"\\bisansr", u"U+1D667", u"𝙧", u"Mathematical Sans-Serif Bold Italic Small R", 8},
    {u"\\bisansrho", u"U+1D7BA", u"𝞺", u"Mathematical Sans-Serif Bold Italic Small Rho", 10},
    {u"\\bisanss", u"U+1D668", u"𝙨", u"Mathematical Sans-Serif Bold Italic Small S", 8},
    {u"\\bisanssigma", u"U+1D7BC", u"𝞼", u"Mathematical Sans-Serif Bold Italic Small Sigma", 12},
    {u"\\bisanst", u"U+1D669", u"𝙩", u"Mathematical Sans-Serif Bold Italic Small T", 8},
    {u"\\bisanstau", u"U+1D7BD", u"𝞽", u"Mathematical Sans-Serif Bold Italic Small Tau", 10},
    {u"\\bisanstheta", u"U+1D7B1", u"𝞱", u"Mathematical Sans-Serif Bold Italic Small Theta", 12},
    {u"\\bisansu", u"U+1D66A", u"𝙪", u"Mathematical Sans-Serif Bold Italic Small U", 8},
    {u"\\bisansupsilon", u"U+1D7BE", u"𝞾", u"Mathematical Sans-Serif Bold Italic Small Upsilon", 14},
    {u"\\bisansv", u"U+1D66B", u"𝙫", u"Mathematical Sans-Serif Bold Italic Small V", 8},
    {u"\\bisansvarTheta", u"U+1D7A1", u"𝞡", u"Mathematical Sans-Serif Bold Italic Capital Theta Symbol", 15},
    {u"\\bisansvarepsilon", u"U+1D7C4", u"𝟄", u"Mathematical Sans-Serif Bold Italic Epsilon Symbol", 17},
    {u"\\bisansvarkappa", u"U+1D7C6", u"𝟆", u"Mathematical Sans-Serif Bold Italic Kappa Symbol", 15},
    {u"\\bisansvarphi", u"U+1D7C7", u"𝟇", u"Mathematical Sans-Serif Bold Italic Phi Symbol", 13},
    {u"\\bisansvarpi", u"U+1D7C9", u"𝟉", u"Mathematical Sans-Serif Bold Italic Pi Symbol", 12},
    {u"\\bisansvarrho", u"U+1D7C8", u"𝟈", u"Mathematical Sans-Serif Bold Italic Rho Symbol", 13},
    {u"\\bisansvarsigma", u"U+1D7BB", u"𝞻", u"Mathematical Sans-Serif Bold Italic Small Final Sigma", 15},
    {u"\\bisansvartheta", u"U+1D7C5", u"𝟅", u"Mathematical Sans-Serif Bold Italic Theta Symbol", 15},
    {u"\\bisansw", u"U+1D66C", u"𝙬", u"Mathematical Sans-Serif Bold Italic Small W", 8},
    {u"\\bisansx", u"U+1D66D", u"𝙭", u"Mathematical Sans-Serif Bold Italic Small X", 8},
    {u"\\bisansxi", u"U+1D7B7", u"𝞷", u"Mathematical Sans-Serif Bold Italic Small Xi", 9},
    {u"\\bisansy", u"U+1D66E", u"𝙮", u"Mathematical Sans-Serif Bold Italic Small Y", 8},
    {u"\\bisansz", u"U+1D66F", u"𝙯", u"Mathematical Sans-Serif Bold Italic Small Z", 8},
    {u"\\bisanszeta", u"U+1D7AF", u"𝞯", u"Mathematical Sans-Serif Bold Italic Small Zeta", 11},
    {u"\\bisigma", u"U+1D748", u"𝝈", u"Mathematical Bold Italic Small Sigma", 8},
    {u"\\bit", u"U+1D495", u"𝒕", u"Mathematical Bold Italic Small T", 4},
    {u"\\bitau", u"U+1D749", u"𝝉", u"Mathematical Bold Italic Small Tau", 6},
    {u"\\bitheta", u"U+1D73D", u"𝜽", u"Mathematical Bold Italic Small Theta", 8},
    {u"\\biu", u"U+1D496", u"𝒖", u"Mathematical Bold Italic Small U", 4},
    {u"\\biupsilon", u"U+1D74A", u"𝝊", u"Mathematical Bold Italic Small Upsilon", 10},
    {u"\\biv", u"U+1D497", u"𝒗", u"Mathematical Bold Italic Small V", 4},
    {u"\\bivarTheta", u"U+1D72D", u"𝜭", u"Mathematical Bold Italic Capital Theta Symbol", 11},
    {u"\\bivarepsilon", u"U+1D750", u"𝝐", u"Mathematical Bold Italic Epsilon Symbol", 13},
    {u"\\bivarkappa", u"U+1D752", u"𝝒", u"Mathematical Bold Italic Kappa Symbol", 11},
    {u"\\bivarphi", u"U+1D753", u"𝝓", u"Mathematical Bold Italic Phi Symbol", 9},
    {u"\\bivarpi", u"U+1D755", u"𝝕", u"Mathematical Bold Italic Pi Symbol", 8},
    {u"\\bivarrho", u"U+1D754", u"𝝔", u"Mathematical Bold Italic Rho Symbol", 9},
    {u"\\bivarsigma", u"U+1D747", u"𝝇", u"Mathematical Bold Italic Small Final Sigma", 11},
    {u"\\bivartheta", u"U+1D751", u"𝝑", u"Mathematical Bold Italic Theta Symbol", 11},
    {u"\\biw", u"U+1D498", u"𝒘", u"Mathematical Bold Italic Small W", 4},
    {u"\\bix", u"U+1D499", u"𝒙", u"Mathematical Bold Italic Small X", 4},
    {u"\\bixi", u"U+1D743", u"𝝃", u"Mathematical Bold Italic Small Xi", 5},
    {u"\\biy", u"U+1D49A", u"𝒚", u"Mathematical Bold Italic Small Y", 4},
    {u"\\biz", u"U+1D49B", u"𝒛", u"Mathematical Bold Italic Small Z", 4},
    {u"\\bizeta", u"U+1D73B", u"𝜻", u"Mathematical Bold Italic Small Zeta", 7},
    {u"\\bkarow", u"U+0290D", u"⤍", u"Rightwards Double Dash Arrow", 7},
    {u"\\blackcircledrightdot", u"U+02688", u"⚈", u"Black Circle With White Dot Right", 21},
    {u"\\blackcircledtwodots", u"U+02689", u"⚉", u"Black Circle With Two White Dots", 20},
    {u"\\blackcircleulquadwhite", u"U+025D5", u"◕", u"Circle With All But Upper Left Quadrant Black", 23},
    {u"\\blackinwhitediamond", u"U+025C8", u"◈", u"White Diamond Containing Black Small Diamond", 20},
    {u"\\blackinwhitesquare", u"U+025A3", u"▣", u"White Square Containing Black Small Square", 19},
    {u"\\blacklefthalfcircle", u"U+025D6", u"◖", u"Left Half Black Circle", 20},
    {u"\\blacklozenge", u"U+029EB", u"⧫", u"Black Lozenge", 13},
    {u"\\blackpointerleft", u"U+025C4", u"◄", u"Black Left-Pointing Pointer / Black Left Pointing Pointer", 17},
    {u"\\blackpointerright", u"U+025BA", u"►", u"Black Right-Pointing Pointer / Black Right Pointing Pointer", 18},
    {u"\\blackrighthalfcircle", u"U+025D7", u"◗", u"Right Half Black Circle", 21},
    {u"\\blacksmiley", u"U+0263B", u"☻", u"Black Smiling Face", 12},
    {u"\\blacksquare", u"U+025A0", u"■", u"Black Square", 12},
    {u"\\blacktriangle", u"U+025B4", u"▴", u"Black Up-Pointing Small Triangle / Black Up Pointing Small Triangle", 14},
    {u"\\blacktriangledown", u"U+025BE", u"▾", u"Black Down-Pointing Small Triangle / Black Down Pointing Small Triangle", 18},
    {u"\\blacktriangleleft", u"U+025C0", u"◀", u"Black Left-Pointing Triangle / Black Left Pointing Triangle", 18},
    {u"\\blacktriangleright", u"U+025B6", u"▶", u"Black Right-Pointing Triangle / Black Right Pointing Triangle", 19},
    {u"\\blanksymbol", u"U+02422", u"␢", u"Blank Symbol / Blank", 12},
    {u"\\blkhorzoval", u"U+02B2C", u"⬬", u"Black Horizontal Ellipse", 12},
    {u"\\blkvertoval", u"U+02B2E", u"⬮", u"Black Vertical Ellipse", 12},
    {u"\\blockfull", u"U+02588", u"█", u"Full Block", 10},
    {u"\\blockhalfshaded", u"U+02592", u"▒", u"Medium Shade", 16},
    {u"\\blocklefthalf", u"U+0258C", u"▌", u"Left Half Block", 14},
    {u"\\blocklowhalf", u"U+02584", u"▄", u"Lower Half Block", 13},
    {u"\\blockqtrshaded", u"U+02591", u"░", u"Light Shade", 15},
    {u"\\blockrighthalf", u"U+02590", u"▐", u"Right Half Block", 15},
    {u"\\blockthreeqtrshaded", u"U+02593", u"▓", u"Dark Shade", 20},
    {u"\\blockuphalf", u"U+02580", u"▀", u"Upper Half Block", 12},
    {u"\\bot", u"U+022A5", u"⊥", u"Up Tack", 4},
    {u"\\botsemicircle", u"U+025E1", u"◡", u"Lower Half Circle", 14},
    {u"\\bowtie", u"U+022C8", u"⋈", u"Bowtie", 7},
    {u"\\boxast", u"U+029C6", u"⧆", u"Squared Asterisk", 7},
    {u"\\boxbar", u"U+025EB", u"◫", u"White Square With Vertical Bisecting Line", 7},
    {u"\\boxbslash", u"U+029C5", u"⧅", u"Squared Falling Diagonal Slash", 10},
    {u"\\boxcircle", u"U+029C7", u"⧇", u"Squared Small Circle", 10},
    {u"\\boxdiag", u"U+029C4", u"⧄", u"Squared Rising Diagonal Slash", 8},
    {u"\\boxdot", u"U+022A1", u"⊡", u"Squared Dot Operator", 7},
    {u"\\boxminus", u"U+0229F", u"⊟", u"Squared Minus", 9},
    {u"\\boxplus", u"U+0229E", u"⊞", u"Squared Plus", 8},
    {u"\\boxquestion", u"U+02370", u"⍰", u"Apl Functional Symbol Quad Question", 12},
    {u"\\boxtimes", u"U+022A0", u"⊠", u"Squared Times", 9},
    {u"\\boxupcaret", u"U+02353", u"⍓", u"Apl Functional Symbol Quad Up Caret", 11},
    {u"\\breve", u"U+00306", u" ̆ ", u"Combining Breve / Non-Spacing Breve", 6},
    {u"\\brokenbar", u"U+000A6", u"¦", u"Broken Bar / Broken Vertical Bar", 10},
    {u"\\bsansA", u"U+1D5D4", u"𝗔", u"Mathematical Sans-Serif Bold Capital A", 7},
    {u"\\bsansAlpha", u"U+1D756", u"𝝖", u"Mathematical Sans-Serif Bold Capital Alpha", 11},
    {u"\\bsansB", u"U+1D5D5", u"𝗕", u"Mathematical Sans-Serif Bold Capital B", 7},
    {u"\\bsansBeta", u"U+1D757", u"𝝗", u"Mathematical Sans-Serif Bold Capital Beta", 10},
    {u"\\bsansC", u"U+1D5D6", u"𝗖", u"Mathematical Sans-Serif Bold Capital C", 7},
    {u"\\bsansChi", u"U+1D76C", u"𝝬", u"Mathematical Sans-Serif Bold Capital Chi", 9},
    {u"\\bsansD", u"U+1D5D7", u"𝗗", u"Mathematical Sans-Serif Bold Capital D", 7},
    {u"\\bsansDelta", u"U+1D759", u"𝝙", u"Mathematical Sans-Serif Bold Capital Delta", 11},
    {u"\\bsansE", u"U+1D5D8", u"𝗘", u"Mathematical Sans-Serif Bold Capital E", 7},
    {u"\\bsansEpsilon", u"U+1D75A", u"𝝚", u"Mathematical Sans-Serif Bold Capital Epsilon", 13},
    {u"\\bsansEta", u"U+1D75C", u"𝝜", u"Mathematical Sans-Serif Bold Capital Eta", 9},
    {u"\\bsansF", u"U+1D5D9", u"𝗙", u"Mathematical Sans-Serif Bold Capital F", 7},
    {u"\\bsansG", u"U+1D5DA", u"𝗚", u"Mathematical Sans-Serif Bold Capital G", 7},
    {u"\\bsansGamma", u"U+1D758", u"𝝘", u"Mathematical Sans-Serif Bold Capital Gamma", 11},
    {u"\\bsansH", u"U+1D5DB", u"𝗛", u"Mathematical Sans-Serif Bold Capital H", 7},
    {u"\\bsansI", u"U+1D5DC", u"𝗜", u"Mathematical Sans-Serif Bold Capital I", 7},
    {u"\\bsansIota", u"U+1D75E", u"𝝞", u"Mathematical Sans-Serif Bold Capital Iota", 10},
    {u"\\bsansJ", u"U+1D5DD", u"𝗝", u"Mathematical Sans-Serif Bold Capital J", 7},
    {u"\\bsansK", u"U+1D5DE", u"𝗞", u"Mathematical Sans-Serif Bold Capital K", 7},
    {u"\\bsansKappa", u"U+1D75F", u"𝝟", u"Mathematical Sans-Serif Bold Capital Kappa", 11},
    {u"\\bsansL", u"U+1D5DF", u"𝗟", u"Mathematical Sans-Serif Bold Capital L", 7},
    {u"\\bsansLambda", u"U+1D760", u"𝝠", u"Mathematical Sans-Serif Bold Capital Lamda", 12},
    {u"\\bsansM", u"U+1D5E0", u"𝗠", u"Mathematical Sans-Serif Bold Capital M", 7},
    {u"\\bsansMu", u"U+1D761", u"𝝡", u"Mathematical Sans-Serif Bold Capital Mu", 8},
    {u"\\bsansN", u"U+1D5E1", u"𝗡", u"Mathematical Sans-Serif Bold Capital N", 7},
    {u"\\bsansNu", u"U+1D762", u"𝝢", u"Mathematical Sans-Serif Bold Capital Nu", 8},
    {u"\\bsansO", u"U+1D5E2", u"𝗢", u"Mathematical Sans-Serif Bold Capital O", 7},
    {u"\\bsansOmega", u"U+1D76E", u"𝝮", u"Mathematical Sans-Serif Bold Capital Omega", 11},
    {u"\\bsansOmicron", u"U+1D764", u"𝝤", u"Mathematical Sans-Serif Bold Capital Omicron", 13},
    {u"\\bsansP", u"U+1D5E3", u"𝗣", u"Mathematical Sans-Serif Bold Capital P", 7},
    {u"\\bsansPhi", u"U+1D76B", u"𝝫", u"Mathematical Sans-Serif Bold Capital Phi", 9},
    {u"\\bsansPi", u"U+1D765", u"𝝥", u"Mathematical Sans-Serif Bold Capital Pi", 8},
    {u"\\bsansPsi", u"U+1D76D", u"𝝭", u"Mathematical Sans-Serif Bold Capital Psi", 9},
    {u"\\bsansQ", u"U+1D5E4", u"𝗤", u"Mathematical Sans-Serif Bold Capital Q", 7},
    {u"\\bsansR", u"U+1D5E5", u"𝗥", u"Mathematical Sans-Serif Bold Capital R", 7},
    {u"\\bsansRho", u"U+1D766", u"𝝦", u"Mathematical Sans-Serif Bold Capital Rho", 9},
    {u"\\bsansS", u"U+1D5E6", u"𝗦", u"Mathematical Sans-Serif Bold Capital S", 7},
    {u"\\bsansSigma", u"U+1D768", u"𝝨", u"Mathematical Sans-Serif Bold Capital Sigma", 11},
    {u"\\bsansT", u"U+1D5E7", u"𝗧", u"Mathematical Sans-Serif Bold Capital T", 7},
    {u"\\bsansTau", u"U+1D769", u"𝝩", u"Mathematical Sans-Serif Bold Capital Tau", 9},
    {u"\\bsansTheta", u"U+1D75D", u"𝝝", u"Mathematical Sans-Serif Bold Capital Theta", 11},
    {u"\\bsansU", u"U+1D5E8", u"𝗨", u"Mathematical Sans-Serif Bold Capital U", 7},
    {u"\\bsansUpsilon", u"U+1D76A", u"𝝪", u"Mathematical Sans-Serif Bold Capital Upsilon", 13},
    {u"\\bsansV", u"U+1D5E9", u"𝗩", u"Mathematical Sans-Serif Bold Capital V", 7},
    {u"\\bsansW", u"U+1D5EA", u"𝗪", u"Mathematical Sans-Serif Bold Capital W", 7},
    {u"\\bsansX", u"U+1D5EB", u"𝗫", u"Mathematical Sans-Serif Bold Capital X", 7},
    {u"\\bsansXi", u"U+1D763", u"𝝣", u"Mathematical Sans-Serif Bold Capital Xi", 8},
    {u"\\bsansY", u"U+1D5EC", u"𝗬", u"Mathematical Sans-Serif Bold Capital Y", 7},
    {u"\\bsansZ", u"U+1D5ED", u"𝗭", u"Mathematical Sans-Serif Bold Capital Z", 7},
    {u"\\bsansZeta", u"U+1D75B", u"𝝛", u"Mathematical Sans-Serif Bold Capital Zeta", 10},
    {u"\\bsansa", u"U+1D5EE", u"𝗮", u"Mathematical Sans-Serif Bold Small A", 7},
    {u"\\bsansalpha", u"U+1D770", u"𝝰", u"Mathematical Sans-Serif Bold Small Alpha", 11},
    {u"\\bsansb", u"U+1D5EF", u"𝗯", u"Mathematical Sans-Serif Bold Small B", 7},
    {u"\\bsansbeta", u"U+1D771", u"𝝱", u"Mathematical Sans-Serif Bold Small Beta", 10},
    {u"\\bsansc", u"U+1D5F0", u"𝗰", u"Mathematical Sans-Serif Bold Small C", 7},
    {u"\\bsanschi", u"U+1D786", u"𝞆", u"Mathematical Sans-Serif Bold Small Chi", 9},
    {u"\\bsansd", u"U+1D5F1", u"𝗱", u"Mathematical Sans-Serif Bold Small D", 7},
    {u"\\bsansdelta", u"U+1D773", u"𝝳", u"Mathematical Sans-Serif Bold Small Delta", 11},
    {u"\\bsanse", u"U+1D5F2", u"𝗲", u"Mathematical Sans-Serif Bold Small E", 7},
    {u"\\bsanseight", u"U+1D7F4", u"𝟴", u"Mathematical Sans-Serif Bold Digit Eight", 11},
    {u"\\bsansepsilon", u"U+1D774", u"𝝴", u"Mathematical Sans-Serif Bold Small Epsilon", 13},
    {u"\\bsanseta", u"U+1D776", u"𝝶", u"Mathematical Sans-Serif Bold Small Eta", 9},
    {u"\\bsansf", u"U+1D5F3", u"𝗳", u"Mathematical Sans-Serif Bold Small F", 7},
    {u"\\bsansfive", u"U+1D7F1", u"𝟱", u"Mathematical Sans-Serif Bold Digit Five", 10},
    {u"\\bsansfour", u"U+1D7F0", u"𝟰", u"Mathematical Sans-Serif Bold Digit Four", 10},
    {u"\\bsansg", u"U+1D5F4", u"𝗴", u"Mathematical Sans-Serif Bold Small G", 7},
    {u"\\bsansgamma", u"U+1D772", u"𝝲", u"Mathematical Sans-Serif Bold Small Gamma", 11},
    {u"\\bsansh", u"U+1D5F5", u"𝗵", u"Mathematical Sans-Serif Bold Small H", 7},
    {u"\\bsansi", u"U+1D5F6", u"𝗶", u"Mathematical Sans-Serif Bold Small I", 7},
    {u"\\bsansiota", u"U+1D778", u"𝝸", u"Mathematical Sans-Serif Bold Small Iota", 10},
    {u"\\bsansj", u"U+1D5F7", u"𝗷", u"Mathematical Sans-Serif Bold Small J", 7},
    {u"\\bsansk", u"U+1D5F8", u"𝗸", u"Mathematical Sans-Serif Bold Small K", 7},
    {u"\\bsanskappa", u"U+1D779", u"𝝹", u"Mathematical Sans-Serif Bold Small Kappa", 11},
    {u"\\bsansl", u"U+1D5F9", u"𝗹", u"Mathematical Sans-Serif Bold Small L", 7},
    {u"\\bsanslambda", u"U+1D77A", u"𝝺", u"Mathematical Sans-Serif Bold Small Lamda", 12},
    {u"\\bsansm", u"U+1D5FA", u"𝗺", u"Mathematical Sans-Serif Bold Small M", 7},
    {u"\\bsansmu", u"U+1D77B", u"𝝻", u"Mathematical Sans-Serif Bold Small Mu", 8},
    {u"\\bsansn", u"U+1D5FB", u"𝗻", u"Mathematical Sans-Serif Bold Small N", 7},
    {u"\\bsansnabla", u"U+1D76F", u"𝝯", u"Mathematical Sans-Serif Bold Nabla", 11},
    {u"\\bsansnine", u"U+1D7F5", u"𝟵", u"Mathematical Sans-Serif Bold Digit Nine", 10},
    {u"\\bsansnu", u"U+1D77C", u"𝝼", u"Mathematical Sans-Serif Bold Small Nu", 8},
    {u"\\bsanso", u"U+1D5FC", u"𝗼", u"Mathematical Sans-Serif Bold Small O", 7},
    {u"\\bsansomega", u"U+1D788", u"𝞈", u"Mathematical Sans-Serif Bold Small Omega", 11},
    {u"\\bsansomicron", u"U+1D77E", u"𝝾", u"Mathematical Sans-Serif Bold Small Omicron", 13},
    {u"\\bsansone", u"U+1D7ED", u"𝟭", u"Mathematical Sans-Serif Bold Digit One", 9},
    {u"\\bsansp", u"U+1D5FD", u"𝗽", u"Mathematical Sans-Serif Bold Small P", 7},
    {u"\\bsanspartial", u"U+1D789", u"𝞉", u"Mathematical Sans-Serif Bold Partial Differential", 13},
    {u"\\bsansphi", u"U+1D785", u"𝞅", u"Mathematical Sans-Serif Bold Small Phi", 9},
    {u"\\bsanspi", u"U+1D77F", u"𝝿", u"Mathematical Sans-Serif Bold Small Pi", 8},
    {u"\\bsanspsi", u"U+1D787", u"𝞇", u"Mathematical Sans-Serif Bold Small Psi", 9},
    {u"\\bsansq", u"U+1D5FE", u"𝗾", u"Mathematical Sans-Serif Bold Small Q", 7},
    {u"\\bsansr", u"U+1D5FF", u"𝗿", u"Mathematical Sans-Serif Bold Small R", 7},
    {u"\\bsansrho", u"U+1D780", u"𝞀", u"Mathematical Sans-Serif Bold Small Rho", 9},
    {u"\\bsanss", u"U+1D600", u"𝘀", u"Mathematical Sans-Serif Bold Small S", 7},
    {u"\\bsansseven", u"U+1D7F3", u"𝟳", u"Mathematical Sans-Serif Bold Digit Seven", 11},
    {u"\\bsanssigma", u"U+1D782", u"𝞂", u"Mathematical Sans-Serif Bold Small Sigma", 11},
    {u"\\bsanssix", u"U+1D7F2", u"𝟲", u"Mathematical Sans-Serif Bold Digit Six", 9},
    {u"\\bsanst", u"U+1D601", u"𝘁", u"Mathematical Sans-Serif Bold Small T", 7},
    {u"\\bsanstau", u"U+1D783", u"𝞃", u"Mathematical Sans-Serif Bold Small Tau", 9},
    {u"\\bsanstheta", u"U+1D777", u"𝝷", u"Mathematical Sans-Serif Bold Small Theta", 11},
    {u"\\bsansthree", u"U+1D7EF", u"𝟯", u"Mathematical Sans-Serif Bold Digit Three", 11},
    {u"\\bsanstwo", u"U+1D7EE", u"𝟮", u"Mathematical Sans-Serif Bold Digit Two", 9},
    {u"\\bsansu", u"U+1D602", u"𝘂", u"Mathematical Sans-Serif Bold Small U", 7},
    {u"\\bsansupsilon", u"U+1D784", u"𝞄", u"Mathematical Sans-Serif Bold Small Upsilon", 13},
    {u"\\bsansv", u"U+1D603", u"𝘃", u"Mathematical Sans-Serif Bold Small V", 7},
    {u"\\bsansvarTheta", u"U+1D767", u"𝝧", u"Mathematical Sans-Serif Bold Capital Theta Symbol", 14},
    {u"\\bsansvarepsilon", u"U+1D78A", u"𝞊", u"Mathematical Sans-Serif Bold Epsilon Symbol", 16},
    {u"\\bsansvarkappa", u"U+1D78C", u"𝞌", u"Mathematical Sans-Serif Bold Kappa Symbol", 14},
    {u"\\bsansvarphi", u"U+1D78D", u"𝞍", u"Mathematical Sans-Serif Bold Phi Symbol", 12},
    {u"\\bsansvarpi", u"U+1D78F", u"𝞏", u"Mathematical Sans-Serif Bold Pi Symbol", 11},
    {u"\\bsansvarrho", u"U+1D78E", u"𝞎", u"Mathematical Sans-Serif Bold Rho Symbol", 12},
    {u"\\bsansvarsigma", u"U+1D781", u"𝞁", u"Mathematical Sans-Serif Bold Small Final Sigma", 14},
    {u"\\bsansvartheta", u"U+1D78B", u"𝞋", u"Mathematical Sans-Serif Bold Theta Symbol", 14},
    {u"\\bsansw", u"U+1D604", u"𝘄", u"Mathematical Sans-Serif Bold Small W", 7},
    {u"\\bsansx", u"U+1D605", u"𝘅", u"Mathematical Sans-Serif Bold Small X", 7},
    {u"\\bsansxi", u"U+1D77D", u"𝝽", u"Mathematical Sans-Serif Bold Small Xi", 8},
    {u"\\bsansy", u"U+1D606", u"𝘆", u"Mathematical Sans-Serif Bold Small Y", 7},
    {u"\\bsansz", u"U+1D607", u"𝘇", u"Mathematical Sans-Serif Bold Small Z", 7},
    {u"\\bsanszero", u"U+1D7EC", u"𝟬", u"Mathematical Sans-Serif Bold Digit Zero", 10},
    {u"\\bsanszeta", u"U+1D775", u"𝝵", u"Mathematical Sans-Serif Bold Small Zeta", 10},
    {u"\\bscrA", u"U+1D4D0", u"𝓐", u"Mathematical Bold Script Capital A", 6},
    {u"\\bscrB", u"U+1D4D1", u"𝓑", u"Mathematical Bold Script Capital B", 6},
    {u"\\bscrC", u"U+1D4D2", u"𝓒", u"Mathematical Bold Script Capital C", 6},
    {u"\\bscrD", u"U+1D4D3", u"𝓓", u"Mathematical Bold Script Capital D", 6},
    {u"\\bscrE", u"U+1D4D4", u"𝓔", u"Mathematical Bold Script Capital E", 6},
    {u"\\bscrF", u"U+1D4D5", u"𝓕", u"Mathematical Bold Script Capital F", 6},
    {u"\\bscrG", u"U+1D4D6", u"𝓖", u"Mathematical Bold Script Capital G", 6},
    {u"\\bscrH", u"U+1D4D7", u"𝓗", u"Mathematical Bold Script Capital H", 6},
    {u"\\bscrI", u"U+1D4D8", u"𝓘", u"Mathematical Bold Script Capital I", 6},
    {u"\\bscrJ", u"U+1D4D9", u"𝓙", u"Mathematical Bold Script Capital J", 6},
    {u"\\bscrK", u"U+1D4DA", u"𝓚", u"Mathematical Bold Script Capital K", 6},
    {u"\\bscrL", u"U+1D4DB", u"𝓛", u"Mathematical Bold Script Capital L", 6},
    {u"\\bscrM", u"U+1D4DC", u"𝓜", u"Mathematical Bold Script Capital M", 6},
    {u"\\bscrN", u"U+1D4DD", u"𝓝", u"Mathematical Bold Script Capital N", 6},
    {u"\\bscrO", u"U+1D4DE", u"𝓞", u"Mathematical Bold Script Capital O", 6},
    {u"\\bscrP", u"U+1D4DF", u"𝓟", u"Mathematical Bold Script Capital P", 6},
    {u"\\bscrQ", u"U+1D4E0", u"𝓠", u"Mathematical Bold Script Capital Q", 6},
    {u"\\bscrR", u"U+1D4E1", u"𝓡", u"Mathematical Bold Script Capital R", 6},
    {u"\\bscrS", u"U+1D4E2", u"𝓢", u"Mathematical Bold Script Capital S", 6},
    {u"\\bscrT", u"U+1D4E3", u"𝓣", u"Mathematical Bold Script Capital T", 6},
    {u"\\bscrU", u"U+1D4E4", u"𝓤", u"Mathematical Bold Script Capital U", 6},
    {u"\\bscrV", u"U+1D4E5", u"𝓥", u"Mathematical Bold Script Capital V", 6},
    {u"\\bscrW", u"U+1D4E6", u"𝓦", u"Mathematical Bold Script Capital W", 6},
    {u"\\bscrX", u"U+1D4E7", u"𝓧", u"Mathematical Bold Script Capital X", 6},
    {u"\\bscrY", u"U+1D4E8", u"𝓨", u"Mathematical Bold Script Capital Y", 6},
    {u"\\bscrZ", u"U+1D4E9", u"𝓩", u"Mathematical Bold Script Capital Z", 6},
    {u"\\bscra", u"U+1D4EA", u"𝓪", u"Mathematical Bold Script Small A", 6},
    {u"\\bscrb", u"U+1D4EB", u"𝓫", u"Mathematical Bold Script Small B", 6},
    {u"\\bscrc", u"U+1D4EC", u"𝓬", u"Mathematical Bold Script Small C", 6},
    {u"\\bscrd", u"U+1D4ED", u"𝓭", u"Mathematical Bold Script Small D", 6},
    {u"\\bscre", u"U+1D4EE", u"𝓮", u"Mathematical Bold Script Small E", 6},
    {u"\\bscrf", u"U+1D4EF", u"𝓯", u"Mathematical Bold Script Small F", 6},
    {u"\\bscrg", u"U+1D4F0", u"𝓰", u"Mathematical Bold Script Small G", 6},
    {u"\\bscrh", u"U+1D4F1", u"𝓱", u"Mathematical Bold Script Small H", 6},
    {u"\\bscri", u"U+1D4F2", u"𝓲", u"Mathematical Bold Script Small I", 6},
    {u"\\bscrj", u"U+1D4F3", u"𝓳", u"Mathematical Bold Script Small J", 6},
    {u"\\bscrk", u"U+1D4F4", u"𝓴", u"Mathematical Bold Script Small K", 6},
    {u"\\bscrl", u"U+1D4F5", u"𝓵", u"Mathematical Bold Script Small L", 6},
    {u"\\bscrm", u"U+1D4F6", u"𝓶", u"Mathematical Bold Script Small M", 6},
    {u"\\bscrn", u"U+1D4F7", u"𝓷", u"Mathematical Bold Script Small N", 6},
    {u"\\bscro", u"U+1D4F8", u"𝓸", u"Mathematical Bold Script Small O", 6},
    {u"\\bscrp", u"U+1D4F9", u"𝓹", u"Mathematical Bold Script Small P", 6},
    {u"\\bscrq", u"U+1D4FA", u"𝓺", u"Mathematical Bold Script Small Q", 6},
    {u"\\bscrr", u"U+1D4FB", u"𝓻", u"Mathematical Bold Script Small R", 6},
    {u"\\bscrs", u"U+1D4FC", u"𝓼", u"Mathematical Bold Script Small S", 6},
    {u"\\bscrt", u"U+1D4FD", u"𝓽", u"Mathematical Bold Script Small T", 6},
    {u"\\bscru", u"U+1D4FE", u"𝓾", u"Mathematical Bold Script Small U", 6},
    {u"\\bscrv", u"U+1D4FF", u"𝓿", u"Mathematical Bold Script Small V", 6},
    {u"\\bscrw", u"U+1D500", u"𝔀", u"Mathematical Bold Script Small W", 6},
    {u"\\bscrx", u"U+1D501", u"𝔁", u"Mathematical Bold Script Small X", 6},
    {u"\\bscry", u"U+1D502", u"𝔂", u"Mathematical Bold Script Small Y", 6},
    {u"\\bscrz", u"U+1D503", u"𝔃", u"Mathematical Bold Script Small Z", 6},
    {u"\\bsimilarleftarrow", u"U+02B41", u"⭁", u"Reverse Tilde Operator Above Leftwards Arrow", 18},
    {u"\\bsimilarrightarrow", u"U+02B47", u"⭇", u"Reverse Tilde Operator Above Rightwards Arrow", 19},
    {u"\\bsolhsub", u"U+027C8", u"⟈", u"Reverse Solidus Preceding Subset", 9},
    {u"\\btdl", u"U+0026C", u"ɬ", u"Latin Small Letter L With Belt / Latin Small Letter L Belt", 5},
    {u"\\btimes", u"U+02A32", u"⨲", u"Semidirect Product With Bottom Closed", 7},
    {u"\\bullet", u"U+02022", u"•", u"Bullet", 7},
    {u"\\bullseye", u"U+025CE", u"◎", u"Bullseye", 9},
    {u"\\bumpeq", u"U+0224F", u"≏", u"Difference Between", 7},
    {u"\\bumpeqq", u"U+02AAE", u"⪮", u"Equals Sign With Bumpy Above", 8},
    {u"\\c", u"U+00327", u" ̧ ", u"Combining Cedilla / Non-Spacing Cedilla", 2},
    {u"\\cancer", u"U+0264B", u"♋", u"Cancer", 7},
    {u"\\candra", u"U+00310", u" ̐ ", u"Combining Candrabindu / Non-Spacing Candrabindu", 7},
    {u"\\cap", u"U+02229", u"∩", u"Intersection", 4},
    {u"\\capdot", u"U+02A40", u"⩀", u"Intersection With Dot", 7},
    {u"\\capricornus", u"U+02651", u"♑", u"Capricorn", 12},
    {u"\\capwedge", u"U+02A44", u"⩄", u"Intersection With Logical And", 9},
    {u"\\carriagereturn", u"U+021B5", u"↵", u"Downwards Arrow With Corner Leftwards / Down Arrow With Corner Left", 15},
    {u"\\cbrt", u"U+0221B", u"∛", u"Cube Root", 5},
    {u"\\cdot", u"U+022C5", u"⋅", u"Dot Operator", 5},
    {u"\\cdotp", u"U+000B7", u"·", u"Middle Dot", 6},
    {u"\\cdots", u"U+022EF", u"⋯", u"Midline Horizontal Ellipsis", 6},
    {u"\\check", u"U+0030C", u" ̌ ", u"Combining Caron / Non-Spacing Hacek", 6},
    {u"\\checkmark", u"U+02713", u"✓", u"Check Mark", 10},
    {u"\\chi", u"U+003C7", u"χ", u"Greek Small Letter Chi", 4},
    {u"\\circ", u"U+02218", u"∘", u"Ring Operator", 5},
    {u"\\circeq", u"U+02257", u"≗", u"Ring Equal To", 7},
    {u"\\circlearrowleft", u"U+021BA", u"↺", u"Anticlockwise Open Circle Arrow", 16},
    {u"\\circlearrowright", u"U+021BB", u"↻", u"Clockwise Open Circle Arrow", 17},
    {u"\\circledR", u"U+000AE", u"®", u"Registered Sign / Registered Trade Mark Sign", 9},
    {u"\\circledS", u"U+024C8", u"Ⓢ", u"Circled Latin Capital Letter S", 9},
    {u"\\circledast", u"U+0229B", u"⊛", u"Circled Asterisk Operator", 11},
    {u"\\circledbullet", u"U+029BF", u"⦿", u"Circled Bullet", 14},
    {u"\\circledcirc", u"U+0229A", u"⊚", u"Circled Ring Operator", 12},
    {u"\\circleddash", u"U+0229D", u"⊝", u"Circled Dash", 12},
    {u"\\circledequal", u"U+0229C", u"⊜", u"Circled Equals", 13},
    {u"\\circledparallel", u"U+029B7", u"⦷", u"Circled Parallel", 16},
    {u"\\circledrightdot", u"U+02686", u"⚆", u"White Circle With Dot Right", 16},
    {u"\\circledstar", u"U+0272A", u"✪", u"Circled White Star", 12},
    {u"\\circledtwodots", u"U+02687", u"⚇", u"White Circle With Two Dots", 15},
    {u"\\circledwhitebullet", u"U+029BE", u"⦾", u"Circled White Bullet", 19},
    {u"\\circlellquad", u"U+025F5", u"◵", u"White Circle With Lower Left Quadrant", 13},
    {u"\\circlelrquad", u"U+025F6", u"◶", u"White Circle With Lower Right Quadrant", 13},
    {u"\\circleonleftarrow", u"U+02B30", u"⬰", u"Left Arrow With Small Circle", 18},
    {u"\\circleonrightarrow", u"U+021F4", u"⇴", u"Right Arrow With Small Circle", 19},
    {u"\\circletophalfblack", u"U+025D3", u"◓", u"Circle With Upper Half Black", 19},
    {u"\\circleulquad", u"U+025F4", u"◴", u"White Circle With Upper Left Quadrant", 13},
    {u"\\circleurquad", u"U+025F7", u"◷", u"White Circle With Upper Right Quadrant", 13},
    {u"\\circleurquadblack", u"U+025D4", u"◔", u"Circle With Upper Right Quadrant Black", 18},
    {u"\\circlevertfill", u"U+025CD", u"◍", u"Circle With Vertical Fill", 15},
    {u"\\cirfb", u"U+025D2", u"◒", u"Circle With Lower Half Black", 6},
    {u"\\cirfl", u"U+025D0", u"◐", u"Circle With Left Half Black", 6},
    {u"\\cirfnint", u"U+02A10", u"⨐", u"Circulation Function", 9},
    {u"\\cirfr", u"U+025D1", u"◑", u"Circle With Right Half Black", 6},
    {u"\\clockoint", u"U+02A0F", u"⨏", u"Integral Average With Slash", 10},
    {u"\\clomeg", u"U+00277", u"ɷ", u"Latin Small Letter Closed Omega", 7},
    {u"\\closedvarcap", u"U+02A4D", u"⩍", u"Closed Intersection With Serifs", 13},
    {u"\\closedvarcup", u"U+02A4C", u"⩌", u"Closed Union With Serifs", 13},
    {u"\\closedvarcupsmashprod", u"U+02A50", u"⩐", u"Closed Union With Serifs And Smash Product", 22},
    {u"\\clubsuit", u"U+02663", u"♣", u"Black Club Suit", 9},
    {u"\\clwintegral", u"U+02231", u"∱", u"Clockwise Integral", 12},
    {u"\\coloneq", u"U+02254", u"≔", u"Colon Equals / Colon Equal", 8},
    {u"\\commaminus", u"U+02A29", u"⨩", u"Minus Sign With Comma Above", 11},
    {u"\\complement", u"U+02201", u"∁", u"Complement", 11},
    {u"\\cong", u"U+02245", u"≅", u"Approximately Equal To", 5},
    {u"\\congdot", u"U+02A6D", u"⩭", u"Congruent With Dot Above", 8},
    {u"\\conictaper", u"U+02332", u"⌲", u"Conical Taper", 11},
    {u"\\conjquant", u"U+02A07", u"⨇", u"Two Logical And Operator", 10},
    {u"\\coprod", u"U+02210", u"∐", u"N-Ary Coproduct", 7},
    {u"\\copyright", u"U+000A9", u"©", u"Copyright Sign", 10},
    {u"\\csub", u"U+02ACF", u"⫏", u"Closed Subset", 5},
    {u"\\csube", u"U+02AD1", u"⫑", u"Closed Subset Or Equal To", 6},
    {u"\\csup", u"U+02AD0", u"⫐", u"Closed Superset", 5},
    {u"\\csupe", u"U+02AD2", u"⫒", u"Closed Superset Or Equal To", 6},
    {u"\\cup", u"U+0222A", u"∪", u"Union", 4},
    {u"\\cupdot", u"U+0228D", u"⊍", u"Multiset Multiplication", 7},
    {u"\\cupvee", u"U+02A45", u"⩅", u"Union With Logical Or", 7},
    {u"\\curlyeqprec", u"U+022DE", u"⋞", u"Equal To Or Precedes", 12},
    {u"\\curlyeqsucc", u"U+022DF", u"⋟", u"Equal To Or Succeeds", 12},
    {u"\\curlyvee", u"U+022CE", u"⋎", u"Curly Logical Or", 9},
    {u"\\curlywedge", u"U+022CF", u"⋏", u"Curly Logical And", 11},
    {u"\\curvearrowleft", u"U+021B6", u"↶", u"Anticlockwise Top Semicircle Arrow", 15},
    {u"\\curvearrowright", u"U+021B7", u"↷", u"Clockwise Top Semicircle Arrow", 16},
    {u"\\dagger", u"U+02020", u"†", u"Dagger", 7},
    {u"\\daleth", u"U+02138", u"ℸ", u"Dalet Symbol / Fourth Transfinite Cardinal", 7},
    {u"\\danger", u"U+02621", u"☡", u"Caution Sign", 7},
    {u"\\dashV", u"U+02AE3", u"⫣", u"Double Vertical Bar Left Turnstile", 6},
    {u"\\dashleftharpoondown", u"U+0296B", u"⥫", u"Leftwards Harpoon With Barb Down Below Long Dash", 20},
    {u"\\dashrightharpoondown", u"U+0296D", u"⥭", u"Rightwards Harpoon With Barb Down Below Long Dash", 21},
    {u"\\dashv", u"U+022A3", u"⊣", u"Left Tack", 6},
    {u"\\dbkarow", u"U+0290F", u"⤏", u"Rightwards Triple Dash Arrow", 8},
    {u"\\dblarrowupdown", u"U+021C5", u"⇅", u"Upwards Arrow Leftwards Of Downwards Arrow / Up Arrow Left Of Down Arrow", 15},
    {u"\\ddagger", u"U+02021", u"‡", u"Double Dagger", 8},
    {u"\\ddddot", u"U+020DC", u" ⃜ ", u"Combining Four Dots Above / Non-Spacing Four Dots Above", 7},
    {u"\\dddot", u"U+020DB", u" ⃛ ", u"Combining Three Dots Above / Non-Spacing Three Dots Above", 6},
    {u"\\ddfnc", u"U+02999", u"⦙", u"Dotted Fence", 6},
    {u"\\ddot", u"U+00308", u" ̈ ", u"Combining Diaeresis / Non-Spacing Diaeresis", 5},
    {u"\\ddots", u"U+022F1", u"⋱", u"Down Right Diagonal Ellipsis", 6},
    {u"\\ddotseq", u"U+02A77", u"⩷", u"Equals Sign With Two Dots Above And Two Dots Below", 8},
    {u"\\defas", u"U+029CB", u"⧋", u"Triangle With Underbar", 6},
    {u"\\degree", u"U+000B0", u"°", u"Degree Sign", 7},
    {u"\\del", u"U+02207", u"∇", u"Nabla", 4},
    {u"\\delta", u"U+003B4", u"δ", u"Greek Small Letter Delta", 6},
    {u"\\dh", u"U+000F0", u"ð", u"Latin Small Letter Eth", 3},
    {u"\\diagdown", u"U+02572", u"╲", u"Box Drawings Light Diagonal Upper Left To Lower Right / Forms Light Diagonal Upper Left To Lower Right", 9},
    {u"\\diagup", u"U+02571", u"╱", u"Box Drawings Light Diagonal Upper Right To Lower Left / Forms Light Diagonal Upper Right To Lower Left", 7},
    {u"\\diameter", u"U+02300", u"⌀", u"Diameter Sign", 9},
    {u"\\diamond", u"U+022C4", u"⋄", u"Diamond Operator", 8},
    {u"\\diamondbotblack", u"U+02B19", u"⬙", u"Diamond With Bottom Half Black", 16},
    {u"\\diamondleftarrow", u"U+0291D", u"⤝", u"Leftwards Arrow To Black Diamond", 17},
    {u"\\diamondleftarrowbar", u"U+0291F", u"⤟", u"Leftwards Arrow From Bar To Black Diamond", 20},
    {u"\\diamondleftblack", u"U+02B16", u"⬖", u"Diamond With Left Half Black", 17},
    {u"\\diamondrightblack", u"U+02B17", u"⬗", u"Diamond With Right Half Black", 18},
    {u"\\diamondsuit", u"U+02662", u"♢", u"White Diamond Suit", 12},
    {u"\\diamondtopblack", u"U+02B18", u"⬘", u"Diamond With Top Half Black", 16},
    {u"\\dicei", u"U+02680", u"⚀", u"Die Face-1", 6},
    {u"\\diceii", u"U+02681", u"⚁", u"Die Face-2", 7},
    {u"\\diceiii", u"U+02682", u"⚂", u"Die Face-3", 8},
    {u"\\diceiv", u"U+02683", u"⚃", u"Die Face-4", 7},
    {u"\\dicev", u"U+02684", u"⚄", u"Die Face-5", 6},
    {u"\\dicevi", u"U+02685", u"⚅", u"Die Face-6", 7},
    {u"\\digamma", u"U+003DD", u"ϝ", u"Greek Small Letter Digamma", 8},
    {u"\\dingasterisk", u"U+0273D", u"✽", u"Heavy Teardrop-Spoked Asterisk", 13},
    {u"\\disin", u"U+022F2", u"⋲", u"Element Of With Long Horizontal Stroke", 6},
    {u"\\disjquant", u"U+02A08", u"⨈", u"Two Logical Or Operator", 10},
    {u"\\div", u"U+000F7", u"÷", u"Division Sign", 4},
    {u"\\divideontimes", u"U+022C7", u"⋇", u"Division Times", 14},
    {u"\\dj", u"U+00111", u"đ", u"Latin Small Letter D With Stroke / Latin Small Letter D Bar", 3},
    {u"\\dlcorn", u"U+023A3", u"⎣", u"Left Square Bracket Lower Corner", 7},
    {u"\\dot", u"U+00307", u" ̇ ", u"Combining Dot Above / Non-Spacing Dot Above", 4},
    {u"\\doteq", u"U+02250", u"≐", u"Approaches The Limit", 6},
    {u"\\dotequiv", u"U+02A67", u"⩧", u"Identical With Dot Above", 9},
    {u"\\dotminus", u"U+02238", u"∸", u"Dot Minus", 9},
    {u"\\dotplus", u"U+02214", u"∔", u"Dot Plus", 8},
    {u"\\dots", u"U+02026", u"…", u"Horizontal Ellipsis", 5},
    {u"\\dotsim", u"U+02A6A", u"⩪", u"Tilde Operator With Dot Above", 7},
    {u"\\dotsminusdots", u"U+0223A", u"∺", u"Geometric Proportion", 14},
    {u"\\dottedcircle", u"U+025CC", u"◌", u"Dotted Circle", 13},
    {u"\\dottedsquare", u"U+02B1A", u"⬚", u"Dotted Square", 13},
    {u"\\dottimes", u"U+02A30", u"⨰", u"Multiplication Sign With Dot Above", 9},
    {u"\\doublebarvee", u"U+02A62", u"⩢", u"Logical Or With Double Overbar", 13},
    {u"\\doublepipe", u"U+001C2", u"ǂ", u"Latin Letter Alveolar Click / Latin Letter Pipe Double Bar", 11},
    {u"\\doubleplus", u"U+029FA", u"⧺", u"Double Plus", 11},
    {u"\\downarrow", u"U+02193", u"↓", u"Downwards Arrow / Down Arrow", 10},
    {u"\\downarrowbarred", u"U+02908", u"⤈", u"Downwards Arrow With Horizontal Stroke", 16},
    {u"\\downdasharrow", u"U+021E3", u"⇣", u"Downwards Dashed Arrow / Down Dashed Arrow", 14},
    {u"\\downdownarrows", u"U+021CA", u"⇊", u"Downwards Paired Arrows / Down Paired Arrows", 15},
    {u"\\downharpoonleft", u"U+021C3", u"⇃", u"Downwards Harpoon With Barb Leftwards / Down Harpoon With Barb Left", 16},
    {u"\\downharpoonright", u"U+021C2", u"⇂", u"Downwards Harpoon With Barb Rightwards / Down Harpoon With Barb Right", 17},
    {u"\\downharpoonsleftright", u"U+02965", u"⥥", u"Downwards Harpoon With Barb Left Beside Downwards Harpoon With Barb Right", 22},
    {u"\\downwhitearrow", u"U+021E9", u"⇩", u"Downwards White Arrow / White Down Arrow", 15},
    {u"\\downzigzagarrow", u"U+021AF", u"↯", u"Downwards Zigzag Arrow / Down Zigzag Arrow", 16},
    {u"\\draftingarrow", u"U+0279B", u"➛", u"Drafting Point Rightwards Arrow / Drafting Point Right Arrow", 14},
    {u"\\drbkarrow", u"U+02910", u"⤐", u"Rightwards Two-Headed Triple Dash Arrow", 10},
    {u"\\droang", u"U+0031A", u" ̚ ", u"Combining Left Angle Above / Non-Spacing Left Angle Above", 7},
    {u"\\dshfnc", u"U+02506", u"┆", u"Box Drawings Light Triple Dash Vertical / Forms Light Triple Dash Vertical", 7},
    {u"\\dsol", u"U+029F6", u"⧶", u"Solidus With Overbar", 5},
    {u"\\dualmap", u"U+029DF", u"⧟", u"Double-Ended Multimap", 8},
    {u"\\dyogh", u"U+002A4", u"ʤ", u"Latin Small Letter Dezh Digraph / Latin Small Letter D Yogh", 6},
    {u"\\egsdot", u"U+02A98", u"⪘", u"Slanted Equal To Or Greater-Than With Dot Inside", 7},
    {u"\\eighthnote", u"U+0266A", u"♪", u"Eighth Note", 11},
    {u"\\elinters", u"U+023E7", u"⏧", u"Electrical Intersection", 9},
    {u"\\ell", u"U+02113", u"ℓ", u"Script Small L", 4},
    {u"\\elsdot", u"U+02A97", u"⪗", u"Slanted Equal To Or Less-Than With Dot Inside", 7},
    {u"\\emdash", u"U+02014", u"—", u"Em Dash", 7},
    {u"\\emptyset", u"U+02205", u"∅", u"Empty Set", 9},
    {u"\\emptysetoarr", u"U+029B3", u"⦳", u"Empty Set With Right Arrow Above", 13},
    {u"\\emptysetoarrl", u"U+029B4", u"⦴", u"Empty Set With Left Arrow Above", 14},
    {u"\\emptysetobar", u"U+029B1", u"⦱", u"Empty Set With Overbar", 13},
    {u"\\emptysetocirc", u"U+029B2", u"⦲", u"Empty Set With Small Circle Above", 14},
    {u"\\enclosecircle", u"U+020DD", u" ⃝ ", u"Combining Enclosing Circle / Enclosing Circle", 14},
    {u"\\enclosediamond", u"U+020DF", u" ⃟ ", u"Combining Enclosing Diamond / Enclosing Diamond", 15},
    {u"\\enclosesquare", u"U+020DE", u" ⃞ ", u"Combining Enclosing Square / Enclosing Square", 14},
    {u"\\enclosetriangle", u"U+020E4", u" ⃤ ", u"Combining Enclosing Upward Pointing Triangle", 16},
    {u"\\endash", u"U+02013", u"–", u"En Dash", 7},
    {u"\\enspace", u"U+02002", u" ", u"En Space", 8},
    {u"\\eparsl", u"U+029E3", u"⧣", u"Equals Sign And Slanted Parallel", 7},
    {u"\\epsilon", u"U+003F5", u"ϵ", u"Greek Lunate Epsilon Symbol", 8},
    {u"\\eqcirc", u"U+02256", u"≖", u"Ring In Equal To", 7},
    {u"\\eqcolon", u"U+02255", u"≕", u"Equals Colon / Equal Colon", 8},
    {u"\\eqdef", u"U+0225D", u"≝", u"Equal To By Definition", 6},
    {u"\\eqdot", u"U+02A66", u"⩦", u"Equals Sign With Dot Below", 6},
    {u"\\eqeqeq", u"U+02A76", u"⩶", u"Three Consecutive Equals Signs", 7},
    {u"\\eqgtr", u"U+022DD", u"⋝", u"Equal To Or Greater-Than / Equal To Or Greater Than", 6},
    {u"\\eqless", u"U+022DC", u"⋜", u"Equal To Or Less-Than / Equal To Or Less Than", 7},
    {u"\\eqqgtr", u"U+02A9A", u"⪚", u"Double-Line Equal To Or Greater-Than", 7},
    {u"\\eqqless", u"U+02A99", u"⪙", u"Double-Line Equal To Or Less-Than", 8},
    {u"\\eqqplus", u"U+02A71", u"⩱", u"Equals Sign Above Plus Sign", 8},
    {u"\\eqqsim", u"U+02A73", u"⩳", u"Equals Sign Above Tilde Operator", 7},
    {u"\\eqqslantgtr", u"U+02A9C", u"⪜", u"Double-Line Slanted Equal To Or Greater-Than", 12},
    {u"\\eqqslantless", u"U+02A9B", u"⪛", u"Double-Line Slanted Equal To Or Less-Than", 13},
    {u"\\eqsim", u"U+02242", u"≂", u"Minus Tilde", 6},
    {u"\\eqslantgtr", u"U+02A96", u"⪖", u"Slanted Equal To Or Greater-Than", 11},
    {u"\\eqslantless", u"U+02A95", u"⪕", u"Slanted Equal To Or Less-Than", 12},
    {u"\\equalleftarrow", u"U+02B40", u"⭀", u"Equals Sign Above Leftwards Arrow", 15},
    {u"\\equalparallel", u"U+022D5", u"⋕", u"Equal And Parallel To", 14},
    {u"\\equiv", u"U+02261", u"≡", u"Identical To", 6},
    {u"\\equivDD", u"U+02A78", u"⩸", u"Equivalent With Four Dots Above", 8},
    {u"\\eqvparsl", u"U+029E5", u"⧥", u"Identical To And Slanted Parallel", 9},
    {u"\\esh", u"U+00283", u"ʃ", u"Latin Small Letter Esh", 4},
    {u"\\eta", u"U+003B7", u"η", u"Greek Small Letter Eta", 4},
    {u"\\eth", u"U+000F0", u"ð", u"Latin Small Letter Eth", 4},
    {u"\\euler", u"U+0212F", u"ℯ", u"Script Small E", 6},
    {u"\\eulermascheroni", u"U+02107", u"ℇ", u"Euler Constant / Eulers", 16},
    {u"\\euro", u"U+020AC", u"€", u"Euro Sign", 5},
    {u"\\exclamdown", u"U+000A1", u"¡", u"Inverted Exclamation Mark", 11},
    {u"\\exists", u"U+02203", u"∃", u"There Exists", 7},
    {u"\\fallingdotseq", u"U+02252", u"≒", u"Approximately Equal To Or The Image Of", 14},
    {u"\\fdiagovnearrow", u"U+0292F", u"⤯", u"Falling Diagonal Crossing North East Arrow", 15},
    {u"\\fdiagovrdiag", u"U+0292C", u"⤬", u"Falling Diagonal Crossing Rising Diagonal", 13},
    {u"\\female", u"U+02640", u"♀", u"Female Sign", 7},
    {u"\\fhr", u"U+0027E", u"ɾ", u"Latin Small Letter R With Fishhook / Latin Small Letter Fishhook R", 4},
    {u"\\fisheye", u"U+025C9", u"◉", u"Fisheye", 8},
    {u"\\flat", u"U+0266D", u"♭", u"Music Flat Sign / Flat", 5},
    {u"\\fltns", u"U+023E5", u"⏥", u"Flatness", 6},
    {u"\\forall", u"U+02200", u"∀", u"For All", 7},
    {u"\\forks", u"U+02ADC", u"⫝̸", u"Forking", 6},
    {u"\\forksnot", u"U+02ADD", u"⫝", u"Nonforking", 9},
    {u"\\forkv", u"U+02AD9", u"⫙", u"Element Of Opening Downwards", 6},
    {u"\\fourthroot", u"U+0221C", u"∜", u"Fourth Root", 11},
    {u"\\frakA", u"U+1D504", u"𝔄", u"Mathematical Fraktur Capital A", 6},
    {u"\\frakB", u"U+1D505", u"𝔅", u"Mathematical Fraktur Capital B", 6},
    {u"\\frakC", u"U+0212D", u"ℭ", u"Black-Letter Capital C / Black-Letter C", 6},
    {u"\\frakD", u"U+1D507", u"𝔇", u"Mathematical Fraktur Capital D", 6},
    {u"\\frakE", u"U+1D508", u"𝔈", u"Mathematical Fraktur Capital E", 6},
    {u"\\frakF", u"U+1D509", u"𝔉", u"Mathematical Fraktur Capital F", 6},
    {u"\\frakG", u"U+1D50A", u"𝔊", u"Mathematical Fraktur Capital G", 6},
    {u"\\frakH", u"U+0210C", u"ℌ", u"Black-Letter Capital H / Black-Letter H", 6},
    {u"\\frakJ", u"U+1D50D", u"𝔍", u"Mathematical Fraktur Capital J", 6},
    {u"\\frakK", u"U+1D50E", u"𝔎", u"Mathematical Fraktur Capital K", 6},
    {u"\\frakL", u"U+1D50F", u"𝔏", u"Mathematical Fraktur Capital L", 6},
    {u"\\frakM", u"U+1D510", u"𝔐", u"Mathematical Fraktur Capital M", 6},
    {u"\\frakN", u"U+1D511", u"𝔑", u"Mathematical Fraktur Capital N", 6},
    {u"\\frakO", u"U+1D512", u"𝔒", u"Mathematical Fraktur Capital O", 6},
    {u"\\frakP", u"U+1D513", u"𝔓", u"Mathematical Fraktur Capital P", 6},
    {u"\\frakQ", u"U+1D514", u"𝔔", u"Mathematical Fraktur Capital Q", 6},
    {u"\\frakS", u"U+1D516", u"𝔖", u"Mathematical Fraktur Capital S", 6},
    {u"\\frakT", u"U+1D517", u"𝔗", u"Mathematical Fraktur Capital T", 6},
    {u"\\frakU", u"U+1D518", u"𝔘", u"Mathematical Fraktur Capital U", 6},
    {u"\\frakV", u"U+1D519", u"𝔙", u"Mathematical Fraktur Capital V", 6},
    {u"\\frakW", u"U+1D51A", u"𝔚", u"Mathematical Fraktur Capital W", 6},
    {u"\\frakX", u"U+1D51B", u"𝔛", u"Mathematical Fraktur Capital X", 6},
    {u"\\frakY", u"U+1D51C", u"𝔜", u"Mathematical Fraktur Capital Y", 6},
    {u"\\frakZ", u"U+02128", u"ℨ", u"Black-Letter Capital Z / Black-Letter Z", 6},
    {u"\\fraka", u"U+1D51E", u"𝔞", u"Mathematical Fraktur Small A", 6},
    {u"\\frakb", u"U+1D51F", u"𝔟", u"Mathematical Fraktur Small B", 6},
    {u"\\frakc", u"U+1D520", u"𝔠", u"Mathematical Fraktur Small C", 6},
    {u"\\frakd", u"U+1D521", u"𝔡", u"Mathematical Fraktur Small D", 6},
    {u"\\frake", u"U+1D522", u"𝔢", u"Mathematical Fraktur Small E", 6},
    {u"\\frakf", u"U+1D523", u"𝔣", u"Mathematical Fraktur Small F", 6},
    {u"\\frakg", u"U+1D524", u"𝔤", u"Mathematical Fraktur Small G", 6},
    {u"\\frakh", u"U+1D525", u"𝔥", u"Mathematical Fraktur Small H", 6},
    {u"\\fraki", u"U+1D526", u"𝔦", u"Mathematical Fraktur Small I", 6},
    {u"\\frakj", u"U+1D527", u"𝔧", u"Mathematical Fraktur Small J", 6},
    {u"\\frakk", u"U+1D528", u"𝔨", u"Mathematical Fraktur Small K", 6},
    {u"\\frakl", u"U+1D529", u"𝔩", u"Mathematical Fraktur Small L", 6},
    {u"\\frakm", u"U+1D52A", u"𝔪", u"Mathematical Fraktur Small M", 6},
    {u"\\frakn", u"U+1D52B", u"𝔫", u"Mathematical Fraktur Small N", 6},
    {u"\\frako", u"U+1D52C", u"𝔬", u"Mathematical Fraktur Small O", 6},
    {u"\\frakp", u"U+1D52D", u"𝔭", u"Mathematical Fraktur Small P", 6},
    {u"\\frakq", u"U+1D52E", u"𝔮", u"Mathematical Fraktur Small Q", 6},
    {u"\\frakr", u"U+1D52F", u"𝔯", u"Mathematical Fraktur Small R", 6},
    {u"\\fraks", u"U+1D530", u"𝔰", u"Mathematical Fraktur Small S", 6},
    {u"\\frakt", u"U+1D531", u"𝔱", u"Mathematical Fraktur Small T", 6},
    {u"\\fraku", u"U+1D532", u"𝔲", u"Mathematical Fraktur Small U", 6},
    {u"\\frakv", u"U+1D533", u"𝔳", u"Mathematical Fraktur Small V", 6},
    {u"\\frakw", u"U+1D534", u"𝔴", u"Mathematical Fraktur Small W", 6},
    {u"\\frakx", u"U+1D535", u"𝔵", u"Mathematical Fraktur Small X", 6},
    {u"\\fraky", u"U+1D536", u"𝔶", u"Mathematical Fraktur Small Y", 6},
    {u"\\frakz", u"U+1D537", u"𝔷", u"Mathematical Fraktur Small Z", 6},
    {u"\\frown", u"U+02322", u"⌢", u"Frown", 6},
    {u"\\fullouterjoin", u"U+027D7", u"⟗", u"Full Outer Join", 14},
    {u"\\gamma", u"U+003B3", u"γ", u"Greek Small Letter Gamma", 6},
    {u"\\ge", u"U+02265", u"≥", u"Greater-Than Or Equal To / Greater Than Or Equal To", 3},
    {u"\\gemini", u"U+0264A", u"♊", u"Gemini", 7},
    {u"\\geq", u"U+02265", u"≥", u"Greater-Than Or Equal To / Greater Than Or Equal To", 4},
    {u"\\geqq", u"U+02267", u"≧", u"Greater-Than Over Equal To / Greater Than Over Equal To", 5},
    {u"\\geqqslant", u"U+02AFA", u"⫺", u"Double-Line Slanted Greater-Than Or Equal To", 10},
    {u"\\geqslant", u"U+02A7E", u"⩾", u"Greater-Than Or Slanted Equal To", 9},
    {u"\\gescc", u"U+02AA9", u"⪩", u"Greater-Than Closed By Curve Above Slanted Equal", 6},
    {u"\\gesdot", u"U+02A80", u"⪀", u"Greater-Than Or Slanted Equal To With Dot Inside", 7},
    {u"\\gesdoto", u"U+02A82", u"⪂", u"Greater-Than Or Slanted Equal To With Dot Above", 8},
    {u"\\gesdotol", u"U+02A84", u"⪄", u"Greater-Than Or Slanted Equal To With Dot Above Left", 9},
    {u"\\gesles", u"U+02A94", u"⪔", u"Greater-Than Above Slanted Equal Above Less-Than Above Slanted Equal", 7},
    {u"\\gg", u"U+0226B", u"≫", u"Much Greater-Than / Much Greater Than", 3},
    {u"\\ggg", u"U+022D9", u"⋙", u"Very Much Greater-Than / Very Much Greater Than", 4},
    {u"\\gggnest", u"U+02AF8", u"⫸", u"Triple Nested Greater-Than", 8},
    {u"\\gimel", u"U+02137", u"ℷ", u"Gimel Symbol / Third Transfinite Cardinal", 6},
    {u"\\glE", u"U+02A92", u"⪒", u"Greater-Than Above Less-Than Above Double-Line Equal", 4},
    {u"\\gla", u"U+02AA5", u"⪥", u"Greater-Than Beside Less-Than", 4},
    {u"\\glj", u"U+02AA4", u"⪤", u"Greater-Than Overlapping Less-Than", 4},
    {u"\\glst", u"U+00294", u"ʔ", u"Latin Letter Glottal Stop", 5},
    {u"\\gnapprox", u"U+02A8A", u"⪊", u"Greater-Than And Not Approximate", 9},
    {u"\\gneq", u"U+02A88", u"⪈", u"Greater-Than And Single-Line Not Equal To", 5},
    {u"\\gneqq", u"U+02269", u"≩", u"Greater-Than But Not Equal To / Greater Than But Not Equal To", 6},
    {u"\\gnsim", u"U+022E7", u"⋧", u"Greater-Than But Not Equivalent To / Greater Than But Not Equivalent To", 6},
    {u"\\grave", u"U+00300", u" ̀ ", u"Combining Grave Accent / Non-Spacing Grave", 6},
    {u"\\gsime", u"U+02A8E", u"⪎", u"Greater-Than Above Similar Or Equal", 6},
    {u"\\gsiml", u"U+02A90", u"⪐", u"Greater-Than Above Similar Above Less-Than", 6},
    {u"\\gtcc", u"U+02AA7", u"⪧", u"Greater-Than Closed By Curve", 5},
    {u"\\gtcir", u"U+02A7A", u"⩺", u"Greater-Than With Circle Inside", 6},
    {u"\\gtquest", u"U+02A7C", u"⩼", u"Greater-Than With Question Mark Above", 8},
    {u"\\gtrapprox", u"U+02A86", u"⪆", u"Greater-Than Or Approximate", 10},
    {u"\\gtrdot", u"U+022D7", u"⋗", u"Greater-Than With Dot / Greater Than With Dot", 7},
    {u"\\gtreqless", u"U+022DB", u"⋛", u"Greater-Than Equal To Or Less-Than / Greater Than Equal To Or Less Than", 10},
    {u"\\gtreqqless", u"U+02A8C", u"⪌", u"Greater-Than Above Double-Line Equal Above Less-Than", 11},
    {u"\\gtrless", u"U+02277", u"≷", u"Greater-Than Or Less-Than / Greater Than Or Less Than", 8},
    {u"\\gtrsim", u"U+02273", u"≳", u"Greater-Than Or Equivalent To / Greater Than Or Equivalent To", 7},
    {u"\\guilsinglleft", u"U+02039", u"‹", u"Single Left-Pointing Angle Quotation Mark / Left Pointing Single Guillemet", 14},
    {u"\\guilsinglright", u"U+0203A", u"›", u"Single Right-Pointing Angle Quotation Mark / Right Pointing Single Guillemet", 15},
    {u"\\gvertneqq", u"U+02269 + U+0FE00", u"≩︀", u"Greater-Than But Not Equal To / Greater Than But Not Equal To + Variation Selector-1", 10},
    {u"\\hat", u"U+00302", u" ̂ ", u"Combining Circumflex Accent / Non-Spacing Circumflex", 4},
    {u"\\hatapprox", u"U+02A6F", u"⩯", u"Almost Equal To With Circumflex Accent", 10},
    {u"\\hbar", u"U+00127", u"ħ", u"Latin Small Letter H With Stroke / Latin Small Letter H Bar", 5},
    {u"\\heartsuit", u"U+02661", u"♡", u"White Heart Suit", 10},
    {u"\\hermaphrodite", u"U+026A5", u"⚥", u"Male And Female Sign", 14},
    {u"\\hermitconjmatrix", u"U+022B9", u"⊹", u"Hermitian Conjugate Matrix", 17},
    {u"\\hexagon", u"U+02394", u"⎔", u"Software-Function Symbol", 8},
    {u"\\hexagonblack", u"U+02B23", u"⬣", u"Horizontal Black Hexagon", 13},
    {u"\\highminus", u"U+000AF", u"¯", u"Macron / Spacing Macron", 10},
    {u"\\hksearow", u"U+02925", u"⤥", u"South East Arrow With Hook", 9},
    {u"\\hkswarow", u"U+02926", u"⤦", u"South West Arrow With Hook", 9},
    {u"\\hlmrk", u"U+002D1", u"ˑ", u"Modifier Letter Half Triangular Colon", 6},
    {u"\\hookleftarrow", u"U+021A9", u"↩", u"Leftwards Arrow With Hook / Left Arrow With Hook", 14},
    {u"\\hookrightarrow", u"U+021AA", u"↪", u"Rightwards Arrow With Hook / Right Arrow With Hook", 15},
    {u"\\house", u"U+02302", u"⌂", u"House", 6},
    {u"\\hrectangle", u"U+025AD", u"▭", u"White Rectangle", 11},
    {u"\\hrectangleblack", u"U+025AC", u"▬", u"Black Rectangle", 16},
    {u"\\hslash", u"U+0210F", u"ℏ", u"Planck Constant Over Two Pi / Planck Constant Over 2 Pi", 7},
    {u"\\hspace", u"U+0200A", u" ", u"Hair Space", 7},
    {u"\\hvlig", u"U+00195", u"ƕ", u"Latin Small Letter Hv / Latin Small Letter H V", 6},
    {u"\\iff", u"U+027FA", u"⟺", u"Long Left Right Double Arrow", 4},
    {u"\\iiiint", u"U+02A0C", u"⨌", u"Quadruple Integral Operator", 7},
    {u"\\iiint", u"U+0222D", u"∭", u"Triple Integral", 6},
    {u"\\iint", u"U+0222C", u"∬", u"Double Integral", 5},
    {u"\\image", u"U+022B7", u"⊷", u"Image Of", 6},
    {u"\\imath", u"U+00131", u"ı", u"Latin Small Letter Dotless I", 6},
    {u"\\impliedby", u"U+027F8", u"⟸", u"Long Leftwards Double Arrow", 10},
    {u"\\implies", u"U+027F9", u"⟹", u"Long Rightwards Double Arrow", 8},
    {u"\\in", u"U+02208", u"∈", u"Element Of", 3},
    {u"\\increment", u"U+02206", u"∆", u"Increment", 10},
    {u"\\infty", u"U+0221E", u"∞", u"Infinity", 6},
    {u"\\inglst", u"U+00296", u"ʖ", u"Latin Letter Inverted Glottal Stop", 7},
    {u"\\int", u"U+0222B", u"∫", u"Integral", 4},
    {u"\\intBar", u"U+02A0E", u"⨎", u"Integral With Double Stroke", 7},
    {u"\\intbar", u"U+02A0D", u"⨍", u"Finite Part Integral", 7},
    {u"\\intcap", u"U+02A19", u"⨙", u"Integral With Intersection", 7},
    {u"\\intcup", u"U+02A1A", u"⨚", u"Integral With Union", 7},
    {u"\\intercal", u"U+022BA", u"⊺", u"Intercalate", 9},
    {u"\\interleave", u"U+02AF4", u"⫴", u"Triple Vertical Bar Binary Relation", 11},
    {u"\\intprod", u"U+02A3C", u"⨼", u"Interior Product", 8},
    {u"\\intprodr", u"U+02A3D", u"⨽", u"Righthand Interior Product", 9},
    {u"\\intx", u"U+02A18", u"⨘", u"Integral With Times Sign", 5},
    {u"\\inversewhitecircle", u"U+025D9", u"◙", u"Inverse White Circle", 19},
    {u"\\invnot", u"U+02310", u"⌐", u"Reversed Not Sign", 7},
    {u"\\invv", u"U+0028C", u"ʌ", u"Latin Small Letter Turned V", 5},
    {u"\\invw", u"U+0028D", u"ʍ", u"Latin Small Letter Turned W", 5},
    {u"\\invwhitelowerhalfcircle", u"U+025DB", u"◛", u"Lower Half Inverse White Circle", 24},
    {u"\\invwhiteupperhalfcircle", u"U+025DA", u"◚", u"Upper Half Inverse White Circle", 24},
    {u"\\iota", u"U+003B9", u"ι", u"Greek Small Letter Iota", 5},
    {u"\\isansA", u"U+1D608", u"𝘈", u"Mathematical Sans-Serif Italic Capital A", 7},
    {u"\\isansB", u"U+1D609", u"𝘉", u"Mathematical Sans-Serif Italic Capital B", 7},
    {u"\\isansC", u"U+1D60A", u"𝘊", u"Mathematical Sans-Serif Italic Capital C", 7},
    {u"\\isansD", u"U+1D60B", u"𝘋", u"Mathematical Sans-Serif Italic Capital D", 7},
    {u"\\isansE", u"U+1D60C", u"𝘌", u"Mathematical Sans-Serif Italic Capital E", 7},
    {u"\\isansF", u"U+1D60D", u"𝘍", u"Mathematical Sans-Serif Italic Capital F", 7},
    {u"\\isansG", u"U+1D60E", u"𝘎", u"Mathematical Sans-Serif Italic Capital G", 7},
    {u"\\isansH", u"U+1D60F", u"𝘏", u"Mathematical Sans-Serif Italic Capital H", 7},
    {u"\\isansI", u"U+1D610", u"𝘐", u"Mathematical Sans-Serif Italic Capital I", 7},
    {u"\\isansJ", u"U+1D611", u"𝘑", u"Mathematical Sans-Serif Italic Capital J", 7},
    {u"\\isansK", u"U+1D612", u"𝘒", u"Mathematical Sans-Serif Italic Capital K", 7},
    {u"\\isansL", u"U+1D613", u"𝘓", u"Mathematical Sans-Serif Italic Capital L", 7},
    {u"\\isansM", u"U+1D614", u"𝘔", u"Mathematical Sans-Serif Italic Capital M", 7},
    {u"\\isansN", u"U+1D615", u"𝘕", u"Mathematical Sans-Serif Italic Capital N", 7},
    {u"\\isansO", u"U+1D616", u"𝘖", u"Mathematical Sans-Serif Italic Capital O", 7},
    {u"\\isansP", u"U+1D617", u"𝘗", u"Mathematical Sans-Serif Italic Capital P", 7},
    {u"\\isansQ", u"U+1D618", u"𝘘", u"Mathematical Sans-Serif Italic Capital Q", 7},
    {u"\\isansR", u"U+1D619", u"𝘙", u"Mathematical Sans-Serif Italic Capital R", 7},
    {u"\\isansS", u"U+1D61A", u"𝘚", u"Mathematical Sans-Serif Italic Capital S", 7},
    {u"\\isansT", u"U+1D61B", u"𝘛", u"Mathematical Sans-Serif Italic Capital T", 7},
    {u"\\isansU", u"U+1D61C", u"𝘜", u"Mathematical Sans-Serif Italic Capital U", 7},
    {u"\\isansV", u"U+1D61D", u"𝘝", u"Mathematical Sans-Serif Italic Capital V", 7},
    {u"\\isansW", u"U+1D61E", u"𝘞", u"Mathematical Sans-Serif Italic Capital W", 7},
    {u"\\isansX", u"U+1D61F", u"𝘟", u"Mathematical Sans-Serif Italic Capital X", 7},
    {u"\\isansY", u"U+1D620", u"𝘠", u"Mathematical Sans-Serif Italic Capital Y", 7},
    {u"\\isansZ", u"U+1D621", u"𝘡", u"Mathematical Sans-Serif Italic Capital Z", 7},
    {u"\\isansa", u"U+1D622", u"𝘢", u"Mathematical Sans-Serif Italic Small A", 7},
    {u"\\isansb", u"U+1D623", u"𝘣", u"Mathematical Sans-Serif Italic Small B", 7},
    {u"\\isansc", u"U+1D624", u"𝘤", u"Mathematical Sans-Serif Italic Small C", 7},
    {u"\\isansd", u"U+1D625", u"𝘥", u"Mathematical Sans-Serif Italic Small D", 7},
    {u"\\isanse", u"U+1D626", u"𝘦", u"Mathematical Sans-Serif Italic Small E", 7},
    {u"\\isansf", u"U+1D627", u"𝘧", u"Mathematical Sans-Serif Italic Small F", 7},
    {u"\\isansg", u"U+1D628", u"𝘨", u"Mathematical Sans-Serif Italic Small G", 7},
    {u"\\isansh", u"U+1D629", u"𝘩", u"Mathematical Sans-Serif Italic Small H", 7},
    {u"\\isansi", u"U+1D62A", u"𝘪", u"Mathematical Sans-Serif Italic Small I", 7},
    {u"\\isansj", u"U+1D62B", u"𝘫", u"Mathematical Sans-Serif Italic Small J", 7},
    {u"\\isansk", u"U+1D62C", u"𝘬", u"Mathematical Sans-Serif Italic Small K", 7},
    {u"\\isansl", u"U+1D62D", u"𝘭", u"Mathematical Sans-Serif Italic Small L", 7},
    {u"\\isansm", u"U+1D62E", u"𝘮", u"Mathematical Sans-Serif Italic Small M", 7},
    {u"\\isansn", u"U+1D62F", u"𝘯", u"Mathematical Sans-Serif Italic Small N", 7},
    {u"\\isanso", u"U+1D630", u"𝘰", u"Mathematical Sans-Serif Italic Small O", 7},
    {u"\\isansp", u"U+1D631", u"𝘱", u"Mathematical Sans-Serif Italic Small P", 7},
    {u"\\isansq", u"U+1D632", u"𝘲", u"Mathematical Sans-Serif Italic Small Q", 7},
    {u"\\isansr", u"U+1D633", u"𝘳", u"Mathematical Sans-Serif Italic Small R", 7},
    {u"\\isanss", u"U+1D634", u"𝘴", u"Mathematical Sans-Serif Italic Small S", 7},
    {u"\\isanst", u"U+1D635", u"𝘵", u"Mathematical Sans-Serif Italic Small T", 7},
    {u"\\isansu", u"U+1D636", u"𝘶", u"Mathematical Sans-Serif Italic Small U", 7},
    {u"\\isansv", u"U+1D637", u"𝘷", u"Mathematical Sans-Serif Italic Small V", 7},
    {u"\\isansw", u"U+1D638", u"𝘸", u"Mathematical Sans-Serif Italic Small W", 7},
    {u"\\isansx", u"U+1D639", u"𝘹", u"Mathematical Sans-Serif Italic Small X", 7},
    {u"\\isansy", u"U+1D63A", u"𝘺", u"Mathematical Sans-Serif Italic Small Y", 7},
    {u"\\isansz", u"U+1D63B", u"𝘻", u"Mathematical Sans-Serif Italic Small Z", 7},
    {u"\\isinE", u"U+022F9", u"⋹", u"Element Of With Two Horizontal Strokes", 6},
    {u"\\isindot", u"U+022F5", u"⋵", u"Element Of With Dot Above", 8},
    {u"\\isinobar", u"U+022F7", u"⋷", u"Small Element Of With Overbar", 9},
    {u"\\isins", u"U+022F4", u"⋴", u"Small Element Of With Vertical Bar At End Of Horizontal Stroke", 6},
    {u"\\isinvb", u"U+022F8", u"⋸", u"Element Of With Underbar", 7},
    {u"\\itA", u"U+1D434", u"𝐴", u"Mathematical Italic Capital A", 4},
    {u"\\itAlpha", u"U+1D6E2", u"𝛢", u"Mathematical Italic Capital Alpha", 8},
    {u"\\itB", u"U+1D435", u"𝐵", u"Mathematical Italic Capital B", 4},
    {u"\\itBeta", u"U+1D6E3", u"𝛣", u"Mathematical Italic Capital Beta", 7},
    {u"\\itC", u"U+1D436", u"𝐶", u"Mathematical Italic Capital C", 4},
    {u"\\itChi", u"U+1D6F8", u"𝛸", u"Mathematical Italic Capital Chi", 6},
    {u"\\itD", u"U+1D437", u"𝐷", u"Mathematical Italic Capital D", 4},
    {u"\\itDelta", u"U+1D6E5", u"𝛥", u"Mathematical Italic Capital Delta", 8},
    {u"\\itE", u"U+1D438", u"𝐸", u"Mathematical Italic Capital E", 4},
    {u"\\itEpsilon", u"U+1D6E6", u"𝛦", u"Mathematical Italic Capital Epsilon", 10},
    {u"\\itEta", u"U+1D6E8", u"𝛨", u"Mathematical Italic Capital Eta", 6},
    {u"\\itF", u"U+1D439", u"𝐹", u"Mathematical Italic Capital F", 4},
    {u"\\itG", u"U+1D43A", u"𝐺", u"Mathematical Italic Capital G", 4},
    {u"\\itGamma", u"U+1D6E4", u"𝛤", u"Mathematical Italic Capital Gamma", 8},
    {u"\\itH", u"U+1D43B", u"𝐻", u"Mathematical Italic Capital H", 4},
    {u"\\itI", u"U+1D43C", u"𝐼", u"Mathematical Italic Capital I", 4},
    {u"\\itIota", u"U+1D6EA", u"𝛪", u"Mathematical Italic Capital Iota", 7},
    {u"\\itJ", u"U+1D43D", u"𝐽", u"Mathematical Italic Capital J", 4},
    {u"\\itK", u"U+1D43E", u"𝐾", u"Mathematical Italic Capital K", 4},
    {u"\\itKappa", u"U+1D6EB", u"𝛫", u"Mathematical Italic Capital Kappa", 8},
    {u"\\itL", u"U+1D43F", u"𝐿", u"Mathematical Italic Capital L", 4},
    {u"\\itLambda", u"U+1D6EC", u"𝛬", u"Mathematical Italic Capital Lamda", 9},
    {u"\\itM", u"U+1D440", u"𝑀", u"Mathematical Italic Capital M", 4},
    {u"\\itMu", u"U+1D6ED", u"𝛭", u"Mathematical Italic Capital Mu", 5},
    {u"\\itN", u"U+1D441", u"𝑁", u"Mathematical Italic Capital N", 4},
    {u"\\itNu", u"U+1D6EE", u"𝛮", u"Mathematical Italic Capital Nu", 5},
    {u"\\itO", u"U+1D442", u"𝑂", u"Mathematical Italic Capital O", 4},
    {u"\\itOmega", u"U+1D6FA", u"𝛺", u"Mathematical Italic Capital Omega", 8},
    {u"\\itOmicron", u"U+1D6F0", u"𝛰", u"Mathematical Italic Capital Omicron", 10},
    {u"\\itP", u"U+1D443", u"𝑃", u"Mathematical Italic Capital P", 4},
    {u"\\itPhi", u"U+1D6F7", u"𝛷", u"Mathematical Italic Capital Phi", 6},
    {u"\\itPi", u"U+1D6F1", u"𝛱", u"Mathematical Italic Capital Pi", 5},
    {u"\\itPsi", u"U+1D6F9", u"𝛹", u"Mathematical Italic Capital Psi", 6},
    {u"\\itQ", u"U+1D444", u"𝑄", u"Mathematical Italic Capital Q", 4},
    {u"\\itR", u"U+1D445", u"𝑅", u"Mathematical Italic Capital R", 4},
    {u"\\itRho", u"U+1D6F2", u"𝛲", u"Mathematical Italic Capital Rho", 6},
    {u"\\itS", u"U+1D446", u"𝑆", u"Mathematical Italic Capital S", 4},
    {u"\\itSigma", u"U+1D6F4", u"𝛴", u"Mathematical Italic Capital Sigma", 8},
    {u"\\itT", u"U+1D447", u"𝑇", u"Mathematical Italic Capital T", 4},
    {u"\\itTau", u"U+1D6F5", u"𝛵", u"Mathematical Italic Capital Tau", 6},
    {u"\\itTheta", u"U+1D6E9", u"𝛩", u"Mathematical Italic Capital Theta", 8},
    {u"\\itU", u"U+1D448", u"𝑈", u"Mathematical Italic Capital U", 4},
    {u"\\itUpsilon", u"U+1D6F6", u"𝛶", u"Mathematical Italic Capital Upsilon", 10},
    {u"\\itV", u"U+1D449", u"𝑉", u"Mathematical Italic Capital V", 4},
    {u"\\itW", u"U+1D44A", u"𝑊", u"Mathematical Italic Capital W", 4},
    {u"\\itX", u"U+1D44B", u"𝑋", u"Mathematical Italic Capital X", 4},
    {u"\\itXi", u"U+1D6EF", u"𝛯", u"Mathematical Italic Capital Xi", 5},
    {u"\\itY", u"U+1D44C", u"𝑌", u"Mathematical Italic Capital Y", 4},
    {u"\\itZ", u"U+1D44D", u"𝑍", u"Mathematical Italic Capital Z", 4},
    {u"\\itZeta", u"U+1D6E7", u"𝛧", u"Mathematical Italic Capital Zeta", 7},
    {u"\\ita", u"U+1D44E", u"𝑎", u"Mathematical Italic Small A", 4},
    {u"\\italpha", u"U+1D6FC", u"𝛼", u"Mathematical Italic Small Alpha", 8},
    {u"\\itb", u"U+1D44F", u"𝑏", u"Mathematical Italic Small B", 4},
    {u"\\itbeta", u"U+1D6FD", u"𝛽", u"Mathematical Italic Small Beta", 7},
    {u"\\itc", u"U+1D450", u"𝑐", u"Mathematical Italic Small C", 4},
    {u"\\itchi", u"U+1D712", u"𝜒", u"Mathematical Italic Small Chi", 6},
    {u"\\itd", u"U+1D451", u"𝑑", u"Mathematical Italic Small D", 4},
    {u"\\itdelta", u"U+1D6FF", u"𝛿", u"Mathematical Italic Small Delta", 8},
    {u"\\ite", u"U+1D452", u"𝑒", u"Mathematical Italic Small E", 4},
    {u"\\itepsilon", u"U+1D700", u"𝜀", u"Mathematical Italic Small Epsilon", 10},
    {u"\\iteta", u"U+1D702", u"𝜂", u"Mathematical Italic Small Eta", 6},
    {u"\\itf", u"U+1D453", u"𝑓", u"Mathematical Italic Small F", 4},
    {u"\\itg", u"U+1D454", u"𝑔", u"Mathematical Italic Small G", 4},
    {u"\\itgamma", u"U+1D6FE", u"𝛾", u"Mathematical Italic Small Gamma", 8},
    {u"\\ith", u"U+0210E", u"ℎ", u"Planck Constant", 4},
    {u"\\iti", u"U+1D456", u"𝑖", u"Mathematical Italic Small I", 4},
    {u"\\itimath", u"U+1D6A4", u"𝚤", u"Mathematical Italic Small Dotless I", 8},
    {u"\\itiota", u"U+1D704", u"𝜄", u"Mathematical Italic Small Iota", 7},
    {u"\\itj", u"U+1D457", u"𝑗", u"Mathematical Italic Small J", 4},
    {u"\\itjmath", u"U+1D6A5", u"𝚥", u"Mathematical Italic Small Dotless J", 8},
    {u"\\itk", u"U+1D458", u"𝑘", u"Mathematical Italic Small K", 4},
    {u"\\itkappa", u"U+1D705", u"𝜅", u"Mathematical Italic Small Kappa", 8},
    {u"\\itl", u"U+1D459", u"𝑙", u"Mathematical Italic Small L", 4},
    {u"\\itlambda", u"U+1D706", u"𝜆", u"Mathematical Italic Small Lamda", 9},
    {u"\\itm", u"U+1D45A", u"𝑚", u"Mathematical Italic Small M", 4},
    {u"\\itmu", u"U+1D707", u"𝜇", u"Mathematical Italic Small Mu", 5},
    {u"\\itn", u"U+1D45B", u"𝑛", u"Mathematical Italic Small N", 4},
    {u"\\itnabla", u"U+1D6FB", u"𝛻", u"Mathematical Italic Nabla", 8},
    {u"\\itnu", u"U+1D708", u"𝜈", u"Mathematical Italic Small Nu", 5},
    {u"\\ito", u"U+1D45C", u"𝑜", u"Mathematical Italic Small O", 4},
    {u"\\itomega", u"U+1D714", u"𝜔", u"Mathematical Italic Small Omega", 8},
    {u"\\itomicron", u"U+1D70A", u"𝜊", u"Mathematical Italic Small Omicron", 10},
    {u"\\itp", u"U+1D45D", u"𝑝", u"Mathematical Italic Small P", 4},
    {u"\\itpartial", u"U+1D715", u"𝜕", u"Mathematical Italic Partial Differential", 10},
    {u"\\itphi", u"U+1D711", u"𝜑", u"Mathematical Italic Small Phi", 6},
    {u"\\itpi", u"U+1D70B", u"𝜋", u"Mathematical Italic Small Pi", 5},
    {u"\\itpsi", u"U+1D713", u"𝜓", u"Mathematical Italic Small Psi", 6},
    {u"\\itq", u"U+1D45E", u"𝑞", u"Mathematical Italic Small Q", 4},
    {u"\\itr", u"U+1D45F", u"𝑟", u"Mathematical Italic Small R", 4},
    {u"\\itrho", u"U+1D70C", u"𝜌", u"Mathematical Italic Small Rho", 6},
    {u"\\its", u"U+1D460", u"𝑠", u"Mathematical Italic Small S", 4},
    {u"\\itsigma", u"U+1D70E", u"𝜎", u"Mathematical Italic Small Sigma", 8},
    {u"\\itt", u"U+1D461", u"𝑡", u"Mathematical Italic Small T", 4},
    {u"\\ittau", u"U+1D70F", u"𝜏", u"Mathematical Italic Small Tau", 6},
    {u"\\ittheta", u"U+1D703", u"𝜃", u"Mathematical Italic Small Theta", 8},
    {u"\\itu", u"U+1D462", u"𝑢", u"Mathematical Italic Small U", 4},
    {u"\\itupsilon", u"U+1D710", u"𝜐", u"Mathematical Italic Small Upsilon", 10},
    {u"\\itv", u"U+1D463", u"𝑣", u"Mathematical Italic Small V", 4},
    {u"\\itvarTheta", u"U+1D6F3", u"𝛳", u"Mathematical Italic Capital Theta Symbol", 11},
    {u"\\itvarepsilon", u"U+1D716", u"𝜖", u"Mathematical Italic Epsilon Symbol", 13},
    {u"\\itvarkappa", u"U+1D718", u"𝜘", u"Mathematical Italic Kappa Symbol", 11},
    {u"\\itvarphi", u"U+1D719", u"𝜙", u"Mathematical Italic Phi Symbol", 9},
    {u"\\itvarpi", u"U+1D71B", u"𝜛", u"Mathematical Italic Pi Symbol", 8},
    {u"\\itvarrho", u"U+1D71A", u"𝜚", u"Mathematical Italic Rho Symbol", 9},
    {u"\\itvarsigma", u"U+1D70D", u"𝜍", u"Mathematical Italic Small Final Sigma", 11},
    {u"\\itvartheta", u"U+1D717", u"𝜗", u"Mathematical Italic Theta Symbol", 11},
    {u"\\itw", u"U+1D464", u"𝑤", u"Mathematical Italic Small W", 4},
    {u"\\itx", u"U+1D465", u"𝑥", u"Mathematical Italic Small X", 4},
    {u"\\itxi", u"U+1D709", u"𝜉", u"Mathematical Italic Small Xi", 5},
    {u"\\ity", u"U+1D466", u"𝑦", u"Mathematical Italic Small Y", 4},
    {u"\\itz", u"U+1D467", u"𝑧", u"Mathematical Italic Small Z", 4},
    {u"\\itzeta", u"U+1D701", u"𝜁", u"Mathematical Italic Small Zeta", 7},
    {u"\\jmath", u"U+00237", u"ȷ", u"Latin Small Letter Dotless J", 6},
    {u"\\join", u"U+02A1D", u"⨝", u"Join", 5},
    {u"\\jupiter", u"U+02643", u"♃", u"Jupiter", 8},
    {u"\\k", u"U+00328", u" ̨ ", u"Combining Ogonek / Non-Spacing Ogonek", 2},
    {u"\\kappa", u"U+003BA", u"κ", u"Greek Small Letter Kappa", 6},
    {u"\\kernelcontraction", u"U+0223B", u"∻", u"Homothetic", 18},
    {u"\\l", u"U+00142", u"ł", u"Latin Small Letter L With Stroke / Latin Small Letter L Slash", 2},
    {u"\\lambda", u"U+003BB", u"λ", u"Greek Small Letter Lamda / Greek Small Letter Lambda", 7},
    {u"\\langle", u"U+027E8", u"⟨", u"Mathematical Left Angle Bracket", 7},
    {u"\\lat", u"U+02AAB", u"⪫", u"Larger Than", 4},
    {u"\\late", u"U+02AAD", u"⪭", u"Larger Than Or Equal To", 5},
    {u"\\lazysinv", u"U+0223E", u"∾", u"Inverted Lazy S", 9},
    {u"\\lceil", u"U+02308", u"⌈", u"Left Ceiling", 6},
    {u"\\ldots", u"U+02026", u"…", u"Horizontal Ellipsis", 6},
    {u"\\le", u"U+02264", u"≤", u"Less-Than Or Equal To / Less Than Or Equal To", 3},
    {u"\\leftarrow", u"U+02190", u"←", u"Leftwards Arrow / Left Arrow", 10},
    {u"\\leftarrowapprox", u"U+02B4A", u"⭊", u"Leftwards Arrow Above Almost Equal To", 16},
    {u"\\leftarrowbackapprox", u"U+02B42", u"⭂", u"Leftwards Arrow Above Reverse Almost Equal To", 20},
    {u"\\leftarrowbsimilar", u"U+02B4B", u"⭋", u"Leftwards Arrow Above Reverse Tilde Operator", 18},
    {u"\\leftarrowonoplus", u"U+02B32", u"⬲", u"Left Arrow With Circled Plus", 17},
    {u"\\leftarrowplus", u"U+02946", u"⥆", u"Leftwards Arrow With Plus Below", 14},
    {u"\\leftarrowtail", u"U+021A2", u"↢", u"Leftwards Arrow With Tail / Left Arrow With Tail", 14},
    {u"\\leftarrowtriangle", u"U+021FD", u"⇽", u"Leftwards Open-Headed Arrow", 18},
    {u"\\leftarrowx", u"U+02B3E", u"⬾", u"Leftwards Arrow Through X", 11},
    {u"\\leftbkarrow", u"U+0290C", u"⤌", u"Leftwards Double Dash Arrow", 12},
    {u"\\leftcurvedarrow", u"U+02B3F", u"⬿", u"Wave Arrow Pointing Directly Left", 16},
    {u"\\leftdasharrow", u"U+021E0", u"⇠", u"Leftwards Dashed Arrow / Left Dashed Arrow", 14},
    {u"\\leftdbkarrow", u"U+0290E", u"⤎", u"Leftwards Triple Dash Arrow", 13},
    {u"\\leftdotarrow", u"U+02B38", u"⬸", u"Leftwards Arrow With Dotted Stem", 13},
    {u"\\leftharpoonaccent", u"U+020D0", u" ⃐ ", u"Combining Left Harpoon Above / Non-Spacing Left Harpoon Above", 18},
    {u"\\leftharpoondown", u"U+021BD", u"↽", u"Leftwards Harpoon With Barb Downwards / Left Harpoon With Barb Down", 16},
    {u"\\leftharpoonsupdown", u"U+02962", u"⥢", u"Leftwards Harpoon With Barb Up Above Leftwards Harpoon With Barb Down", 19},
    {u"\\leftharpoonup", u"U+021BC", u"↼", u"Leftwards Harpoon With Barb Upwards / Left Harpoon With Barb Up", 14},
    {u"\\leftharpoonupdash", u"U+0296A", u"⥪", u"Leftwards Harpoon With Barb Up Above Long Dash", 18},
    {u"\\leftleftarrows", u"U+021C7", u"⇇", u"Leftwards Paired Arrows / Left Paired Arrows", 15},
    {u"\\leftmoon", u"U+0263E", u"☾", u"Last Quarter Moon", 9},
    {u"\\leftouterjoin", u"U+027D5", u"⟕", u"Left Outer Join", 14},
    {u"\\leftrightarrow", u"U+02194", u"↔", u"Left Right Arrow", 15},
    {u"\\leftrightarrowcircle", u"U+02948", u"⥈", u"Left Right Arrow Through Small Circle", 21},
    {u"\\leftrightarrows", u"U+021C6", u"⇆", u"Leftwards Arrow Over Rightwards Arrow / Left Arrow Over Right Arrow", 16},
    {u"\\leftrightarrowtriangle", u"U+021FF", u"⇿", u"Left Right Open-Headed Arrow", 23},
    {u"\\leftrightharpoondownup", u"U+0294B", u"⥋", u"Left Barb Down Right Barb Up Harpoon", 23},
    {u"\\leftrightharpoons", u"U+021CB", u"⇋", u"Leftwards Harpoon Over Rightwards Harpoon / Left Harpoon Over Right Harpoon", 18},
    {u"\\leftrightharpoonsdown", u"U+02967", u"⥧", u"Leftwards Harpoon With Barb Down Above Rightwards Harpoon With Barb Down", 22},
    {u"\\leftrightharpoonsup", u"U+02966", u"⥦", u"Leftwards Harpoon With Barb Up Above Rightwards Harpoon With Barb Up", 20},
    {u"\\leftrightharpoonupdown", u"U+0294A", u"⥊", u"Left Barb Up Right Barb Down Harpoon", 23},
    {u"\\leftrightsquigarrow", u"U+021AD", u"↭", u"Left Right Wave Arrow", 20},
    {u"\\leftsquigarrow", u"U+021DC", u"⇜", u"Leftwards Squiggle Arrow / Left Squiggle Arrow", 15},
    {u"\\leftthreearrows", u"U+02B31", u"⬱", u"Three Leftwards Arrows", 16},
    {u"\\leftthreetimes", u"U+022CB", u"⋋", u"Left Semidirect Product", 15},
    {u"\\leftwavearrow", u"U+0219C", u"↜", u"Leftwards Wave Arrow / Left Wave Arrow", 14},
    {u"\\leftwhitearrow", u"U+021E6", u"⇦", u"Leftwards White Arrow / White Left Arrow", 15},
    {u"\\leo", u"U+0264C", u"♌", u"Leo", 4},
    {u"\\leq", u"U+02264", u"≤", u"Less-Than Or Equal To / Less Than Or Equal To", 4},
    {u"\\leqq", u"U+02266", u"≦", u"Less-Than Over Equal To / Less Than Over Equal To", 5},
    {u"\\leqqslant", u"U+02AF9", u"⫹", u"Double-Line Slanted Less-Than Or Equal To", 10},
    {u"\\leqslant", u"U+02A7D", u"⩽", u"Less-Than Or Slanted Equal To", 9},
    {u"\\lescc", u"U+02AA8", u"⪨", u"Less-Than Closed By Curve Above Slanted Equal", 6},
    {u"\\lesdot", u"U+02A7F", u"⩿", u"Less-Than Or Slanted Equal To With Dot Inside", 7},
    {u"\\lesdoto", u"U+02A81", u"⪁", u"Less-Than Or Slanted Equal To With Dot Above", 8},
    {u"\\lesdotor", u"U+02A83", u"⪃", u"Less-Than Or Slanted Equal To With Dot Above Right", 9},
    {u"\\lesges", u"U+02A93", u"⪓", u"Less-Than Above Slanted Equal Above Greater-Than Above Slanted Equal", 7},
    {u"\\lessapprox", u"U+02A85", u"⪅", u"Less-Than Or Approximate", 11},
    {u"\\lessdot", u"U+022D6", u"⋖", u"Less-Than With Dot / Less Than With Dot", 8},
    {u"\\lesseqgtr", u"U+022DA", u"⋚", u"Less-Than Equal To Or Greater-Than / Less Than Equal To Or Greater Than", 10},
    {u"\\lesseqqgtr", u"U+02A8B", u"⪋", u"Less-Than Above Double-Line Equal Above Greater-Than", 11},
    {u"\\lessgtr", u"U+02276", u"≶", u"Less-Than Or Greater-Than / Less Than Or Greater Than", 8},
    {u"\\lesssim", u"U+02272", u"≲", u"Less-Than Or Equivalent To / Less Than Or Equivalent To", 8},
    {u"\\lfloor", u"U+0230A", u"⌊", u"Left Floor", 7},
    {u"\\lgE", u"U+02A91", u"⪑", u"Less-Than Above Greater-Than Above Double-Line Equal", 4},
    {u"\\lgblkcircle", u"U+02B24", u"⬤", u"Black Large Circle", 12},
    {u"\\lgblksquare", u"U+02B1B", u"⬛", u"Black Large Square", 12},
    {u"\\lgwhtcircle", u"U+025EF", u"◯", u"Large Circle", 12},
    {u"\\lgwhtsquare", u"U+02B1C", u"⬜", u"White Large Square", 12},
    {u"\\libra", u"U+0264E", u"♎", u"Libra", 6},
    {u"\\linefeed", u"U+021B4", u"↴", u"Rightwards Arrow With Corner Downwards / Right Arrow With Corner Down", 9},
    {u"\\ll", u"U+0226A", u"≪", u"Much Less-Than / Much Less Than", 3},
    {u"\\llarc", u"U+025DF", u"◟", u"Lower Left Quadrant Circular Arc", 6},
    {u"\\llblacktriangle", u"U+025E3", u"◣", u"Black Lower Left Triangle", 16},
    {u"\\llbracket", u"U+027E6", u"⟦", u"Mathematical Left White Square Bracket", 10},
    {u"\\llcorner", u"U+0231E", u"⌞", u"Bottom Left Corner", 9},
    {u"\\lllnest", u"U+02AF7", u"⫷", u"Triple Nested Less-Than", 8},
    {u"\\lltriangle", u"U+025FA", u"◺", u"Lower Left Triangle", 11},
    {u"\\lmoustache", u"U+023B0", u"⎰", u"Upper Left Or Lower Right Curly Bracket Section", 11},
    {u"\\lmrk", u"U+002D0", u"ː", u"Modifier Letter Triangular Colon", 5},
    {u"\\lnapprox", u"U+02A89", u"⪉", u"Less-Than And Not Approximate", 9},
    {u"\\lneq", u"U+02A87", u"⪇", u"Less-Than And Single-Line Not Equal To", 5},
    {u"\\lneqq", u"U+02268", u"≨", u"Less-Than But Not Equal To / Less Than But Not Equal To", 6},
    {u"\\lnsim", u"U+022E6", u"⋦", u"Less-Than But Not Equivalent To / Less Than But Not Equivalent To", 6},
    {u"\\longleftarrow", u"U+027F5", u"⟵", u"Long Leftwards Arrow", 14},
    {u"\\longleftrightarrow", u"U+027F7", u"⟷", u"Long Left Right Arrow", 19},
    {u"\\longleftsquigarrow", u"U+02B33", u"⬳", u"Long Leftwards Squiggle Arrow", 19},
    {u"\\longmapsfrom", u"U+027FB", u"⟻", u"Long Leftwards Arrow From Bar", 13},
    {u"\\longmapsto", u"U+027FC", u"⟼", u"Long Rightwards Arrow From Bar", 11},
    {u"\\longrightarrow", u"U+027F6", u"⟶", u"Long Rightwards Arrow", 15},
    {u"\\longrightsquigarrow", u"U+027FF", u"⟿", u"Long Rightwards Squiggle Arrow", 20},
    {u"\\looparrowleft", u"U+021AB", u"↫", u"Leftwards Arrow With Loop / Left Arrow With Loop", 14},
    {u"\\looparrowright", u"U+021AC", u"↬", u"Rightwards Arrow With Loop / Right Arrow With Loop", 15},
    {u"\\low", u"U+002D5", u"˕", u"Modifier Letter Down Tack", 4},
    {u"\\lowint", u"U+02A1C", u"⨜", u"Integral With Underbar", 7},
    {u"\\lozenge", u"U+025CA", u"◊", u"Lozenge", 8},
    {u"\\lpargt", u"U+029A0", u"⦠", u"Spherical Angle Opening Left", 7},
    {u"\\lq", u"U+02018", u"‘", u"Left Single Quotation Mark / Single Turned Comma Quotation Mark", 3},
    {u"\\lrarc", u"U+025DE", u"◞", u"Lower Right Quadrant Circular Arc", 6},
    {u"\\lrblacktriangle", u"U+025E2", u"◢", u"Black Lower Right Triangle", 16},
    {u"\\lrcorner", u"U+0231F", u"⌟", u"Bottom Right Corner", 9},
    {u"\\lrtriangle", u"U+025FF", u"◿", u"Lower Right Triangle", 11},
    {u"\\lrtriangleeq", u"U+029E1", u"⧡", u"Increases As", 13},
    {u"\\lsime", u"U+02A8D", u"⪍", u"Less-Than Above Similar Or Equal", 6},
    {u"\\lsimg", u"U+02A8F", u"⪏", u"Less-Than Above Similar Above Greater-Than", 6},
    {u"\\lsqhook", u"U+02ACD", u"⫍", u"Square Left Open Box Operator", 8},
    {u"\\ltcc", u"U+02AA6", u"⪦", u"Less-Than Closed By Curve", 5},
    {u"\\ltcir", u"U+02A79", u"⩹", u"Less-Than With Circle Inside", 6},
    {u"\\ltimes", u"U+022C9", u"⋉", u"Left Normal Factor Semidirect Product", 7},
    {u"\\ltlmr", u"U+00271", u"ɱ", u"Latin Small Letter M With Hook / Latin Small Letter M Hook", 6},
    {u"\\ltln", u"U+00272", u"ɲ", u"Latin Small Letter N With Left Hook / Latin Small Letter N Hook", 5},
    {u"\\ltphi", u"U+00278", u"ɸ", u"Latin Small Letter Phi", 6},
    {u"\\ltquest", u"U+02A7B", u"⩻", u"Less-Than With Question Mark Above", 8},
    {u"\\lvboxline", u"U+023B8", u"⎸", u"Left Vertical Box Line", 10},
    {u"\\lvertneqq", u"U+02268 + U+0FE00", u"≨︀", u"Less-Than But Not Equal To / Less Than But Not Equal To + Variation Selector-1", 10},
    {u"\\male", u"U+02642", u"♂", u"Male Sign", 5},
    {u"\\maltese", u"U+02720", u"✠", u"Maltese Cross", 8},
    {u"\\mapsdown", u"U+021A7", u"↧", u"Downwards Arrow From Bar / Down Arrow From Bar", 9},
    {u"\\mapsfrom", u"U+021A4", u"↤", u"Leftwards Arrow From Bar / Left Arrow From Bar", 9},
    {u"\\mapsto", u"U+021A6", u"↦", u"Rightwards Arrow From Bar / Right Arrow From Bar", 7},
    {u"\\mapsup", u"U+021A5", u"↥", u"Upwards Arrow From Bar / Up Arrow From Bar", 7},
    {u"\\mars", u"U+02642", u"♂", u"Male Sign", 5},
    {u"\\mdblkcircle", u"U+026AB", u"⚫", u"Medium Black Circle", 12},
    {u"\\mdblkdiamond", u"U+02B25", u"⬥", u"Black Medium Diamond", 13},
    {u"\\mdblklozenge", u"U+02B27", u"⬧", u"Black Medium Lozenge", 13},
    {u"\\mdblksquare", u"U+025FC", u"◼", u"Black Medium Square", 12},
    {u"\\mdlgblkcircle", u"U+025CF", u"●", u"Black Circle", 14},
    {u"\\mdlgblkdiamond", u"U+025C6", u"◆", u"Black Diamond", 15},
    {u"\\mdlgwhtdiamond", u"U+025C7", u"◇", u"White Diamond", 15},
    {u"\\mdsmblksquare", u"U+025FE", u"◾", u"Black Medium Small Square", 14},
    {u"\\mdsmwhtcircle", u"U+026AC", u"⚬", u"Medium Small White Circle", 14},
    {u"\\mdsmwhtsquare", u"U+025FD", u"◽", u"White Medium Small Square", 14},
    {u"\\mdwhtcircle", u"U+026AA", u"⚪", u"Medium White Circle", 12},
    {u"\\mdwhtdiamond", u"U+02B26", u"⬦", u"White Medium Diamond", 13},
    {u"\\mdwhtlozenge", u"U+02B28", u"⬨", u"White Medium Lozenge", 13},
    {u"\\mdwhtsquare", u"U+025FB", u"◻", u"White Medium Square", 12},
    {u"\\measangledltosw", u"U+029AF", u"⦯", u"Measured Angle With Open Arm Ending In Arrow Pointing Left And Down", 16},
    {u"\\measangledrtose", u"U+029AE", u"⦮", u"Measured Angle With Open Arm Ending In Arrow Pointing Right And Down", 16},
    {u"\\measangleldtosw", u"U+029AB", u"⦫", u"Measured Angle With Open Arm Ending In Arrow Pointing Down And Left", 16},
    {u"\\measanglelutonw", u"U+029A9", u"⦩", u"Measured Angle With Open Arm Ending In Arrow Pointing Up And Left", 16},
    {u"\\measanglerdtose", u"U+029AA", u"⦪", u"Measured Angle With Open Arm Ending In Arrow Pointing Down And Right", 16},
    {u"\\measanglerutone", u"U+029A8", u"⦨", u"Measured Angle With Open Arm Ending In Arrow Pointing Up And Right", 16},
    {u"\\measangleultonw", u"U+029AD", u"⦭", u"Measured Angle With Open Arm Ending In Arrow Pointing Left And Up", 16},
    {u"\\measangleurtone", u"U+029AC", u"⦬", u"Measured Angle With Open Arm Ending In Arrow Pointing Right And Up", 16},
    {u"\\measeq", u"U+0225E", u"≞", u"Measured By", 7},
    {u"\\measuredangle", u"U+02221", u"∡", u"Measured Angle", 14},
    {u"\\measuredangleleft", u"U+0299B", u"⦛", u"Measured Angle Opening Left", 18},
    {u"\\medblackstar", u"U+02B51", u"⭑", u"Black Small Star", 13},
    {u"\\medwhitestar", u"U+02B50", u"⭐", u"White Medium Star", 13},
    {u"\\mercury", u"U+0263F", u"☿", u"Mercury", 8},
    {u"\\mho", u"U+02127", u"℧", u"Inverted Ohm Sign / Mho", 4},
    {u"\\mid", u"U+02223", u"∣", u"Divides", 4},
    {u"\\midbarvee", u"U+02A5D", u"⩝", u"Logical Or With Horizontal Dash", 10},
    {u"\\midbarwedge", u"U+02A5C", u"⩜", u"Logical And With Horizontal Dash", 12},
    {u"\\minhat", u"U+02A5F", u"⩟", u"Logical And With Underbar", 7},
    {u"\\minus", u"U+02212", u"−", u"Minus Sign", 6},
    {u"\\minusdot", u"U+02A2A", u"⨪", u"Minus Sign With Dot Below", 9},
    {u"\\minusfdots", u"U+02A2B", u"⨫", u"Minus Sign With Falling Dots", 11},
    {u"\\minusrdots", u"U+02A2C", u"⨬", u"Minus Sign With Rising Dots", 11},
    {u"\\mlcp", u"U+02ADB", u"⫛", u"Transversal Intersection", 5},
    {u"\\models", u"U+022A7", u"⊧", u"Models", 7},
    {u"\\modtwosum", u"U+02A0A", u"⨊", u"Modulo Two Sum", 10},
    {u"\\mp", u"U+02213", u"∓", u"Minus-Or-Plus Sign", 3},
    {u"\\mu", u"U+003BC", u"μ", u"Greek Small Letter Mu", 3},
    {u"\\multimap", u"U+022B8", u"⊸", u"Multimap", 9},
    {u"\\nBumpeq", u"U+0224E + U+00338", u"≎̸", u"Geometrically Equivalent To + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 8},
    {u"\\nHdownarrow", u"U+021DF", u"⇟", u"Downwards Arrow With Double Stroke / Down Arrow With Double Stroke", 12},
    {u"\\nHuparrow", u"U+021DE", u"⇞", u"Upwards Arrow With Double Stroke / Up Arrow With Double Stroke", 10},
    {u"\\nLeftarrow", u"U+021CD", u"⇍", u"Leftwards Double Arrow With Stroke / Left Double Arrow With Stroke", 11},
    {u"\\nLeftrightarrow", u"U+021CE", u"⇎", u"Left Right Double Arrow With Stroke", 16},
    {u"\\nRightarrow", u"U+021CF", u"⇏", u"Rightwards Double Arrow With Stroke / Right Double Arrow With Stroke", 12},
    {u"\\nVDash", u"U+022AF", u"⊯", u"Negated Double Vertical Bar Double Right Turnstile", 7},
    {u"\\nVdash", u"U+022AE", u"⊮", u"Does Not Force", 7},
    {u"\\nVleftarrow", u"U+021FA", u"⇺", u"Leftwards Arrow With Double Vertical Stroke", 12},
    {u"\\nVleftarrowtail", u"U+02B3A", u"⬺", u"Leftwards Arrow With Tail With Double Vertical Stroke", 16},
    {u"\\nVleftrightarrow", u"U+021FC", u"⇼", u"Left Right Arrow With Double Vertical Stroke", 17},
    {u"\\nVrightarrow", u"U+021FB", u"⇻", u"Rightwards Arrow With Double Vertical Stroke", 13},
    {u"\\nVrightarrowtail", u"U+02915", u"⤕", u"Rightwards Arrow With Tail With Double Vertical Stroke", 17},
    {u"\\nVtwoheadleftarrow", u"U+02B35", u"⬵", u"Leftwards Two-Headed Arrow With Double Vertical Stroke", 19},
    {u"\\nVtwoheadleftarrowtail", u"U+02B3D", u"⬽", u"Leftwards Two-Headed Arrow With Tail With Double Vertical Stroke", 23},
    {u"\\nVtwoheadrightarrow", u"U+02901", u"⤁", u"Rightwards Two-Headed Arrow With Double Vertical Stroke", 20},
    {u"\\nVtwoheadrightarrowtail", u"U+02918", u"⤘", u"Rightwards Two-Headed Arrow With Tail With Double Vertical Stroke", 24},
    {u"\\nabla", u"U+02207", u"∇", u"Nabla", 6},
    {u"\\napprox", u"U+02249", u"≉", u"Not Almost Equal To", 8},
    {u"\\nasymp", u"U+0226D", u"≭", u"Not Equivalent To", 7},
    {u"\\natural", u"U+0266E", u"♮", u"Music Natural Sign / Natural", 8},
    {u"\\nbumpeq", u"U+0224F + U+00338", u"≏̸", u"Difference Between + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 8},
    {u"\\ncong", u"U+02247", u"≇", u"Neither Approximately Nor Actually Equal To", 6},
    {u"\\ne", u"U+02260", u"≠", u"Not Equal To", 3},
    {u"\\nearrow", u"U+02197", u"↗", u"North East Arrow / Upper Right Arrow", 8},
    {u"\\neg", u"U+000AC", u"¬", u"Not Sign", 4},
    {u"\\neovnwarrow", u"U+02931", u"⤱", u"North East Arrow Crossing North West Arrow", 12},
    {u"\\neovsearrow", u"U+0292E", u"⤮", u"North East Arrow Crossing South East Arrow", 12},
    {u"\\neptune", u"U+02646", u"♆", u"Neptune", 8},
    {u"\\neqsim", u"U+02242 + U+00338", u"≂̸", u"Minus Tilde + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 7},
    {u"\\nequiv", u"U+02262", u"≢", u"Not Identical To", 7},
    {u"\\neuter", u"U+026B2", u"⚲", u"Neuter", 7},
    {u"\\nexists", u"U+02204", u"∄", u"There Does Not Exist", 8},
    {u"\\ng", u"U+0014B", u"ŋ", u"Latin Small Letter Eng", 3},
    {u"\\ngeq", u"U+02271", u"≱", u"Neither Greater-Than Nor Equal To / Neither Greater Than Nor Equal To", 5},
    {u"\\ngeqslant", u"U+02A7E + U+00338", u"⩾̸", u"Greater-Than Or Slanted Equal To + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 10},
    {u"\\ngtr", u"U+0226F", u"≯", u"Not Greater-Than / Not Greater Than", 5},
    {u"\\ngtrsim", u"U+02275", u"≵", u"Neither Greater-Than Nor Equivalent To / Neither Greater Than Nor Equivalent To", 8},
    {u"\\ni", u"U+0220B", u"∋", u"Contains As Member", 3},
    {u"\\niobar", u"U+022FE", u"⋾", u"Small Contains With Overbar", 7},
    {u"\\nis", u"U+022FC", u"⋼", u"Small Contains With Vertical Bar At End Of Horizontal Stroke", 4},
    {u"\\nisd", u"U+022FA", u"⋺", u"Contains With Long Horizontal Stroke", 5},
    {u"\\nleftarrow", u"U+0219A", u"↚", u"Leftwards Arrow With Stroke / Left Arrow With Stroke", 11},
    {u"\\nleftrightarrow", u"U+021AE", u"↮", u"Left Right Arrow With Stroke", 16},
    {u"\\nleq", u"U+02270", u"≰", u"Neither Less-Than Nor Equal To / Neither Less Than Nor Equal To", 5},
    {u"\\nleqslant", u"U+02A7D + U+00338", u"⩽̸", u"Less-Than Or Slanted Equal To + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 10},
    {u"\\nless", u"U+0226E", u"≮", u"Not Less-Than / Not Less Than", 6},
    {u"\\nlesssim", u"U+02274", u"≴", u"Neither Less-Than Nor Equivalent To / Neither Less Than Nor Equivalent To", 9},
    {u"\\nmid", u"U+02224", u"∤", u"Does Not Divide", 5},
    {u"\\nni", u"U+0220C", u"∌", u"Does Not Contain As Member", 4},
    {u"\\nolinebreak", u"U+02060", u"⁠", u"Word Joiner", 12},
    {u"\\not", u"U+00338", u" ̸ ", u"Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 4},
    {u"\\notbackslash", u"U+02340", u"⍀", u"Apl Functional Symbol Backslash Bar", 13},
    {u"\\notgreaterless", u"U+02279", u"≹", u"Neither Greater-Than Nor Less-Than / Neither Greater Than Nor Less Than", 15},
    {u"\\notin", u"U+02209", u"∉", u"Not An Element Of", 6},
    {u"\\notlessgreater", u"U+02278", u"≸", u"Neither Less-Than Nor Greater-Than / Neither Less Than Nor Greater Than", 15},
    {u"\\notslash", u"U+0233F", u"⌿", u"Apl Functional Symbol Slash Bar", 9},
    {u"\\nparallel", u"U+02226", u"∦", u"Not Parallel To", 10},
    {u"\\npolint", u"U+02A14", u"⨔", u"Line Integration Not Including The Pole", 8},
    {u"\\nprec", u"U+02280", u"⊀", u"Does Not Precede", 6},
    {u"\\npreccurlyeq", u"U+022E0", u"⋠", u"Does Not Precede Or Equal", 13},
    {u"\\npreceq", u"U+02AAF + U+00338", u"⪯̸", u"Precedes Above Single-Line Equals Sign + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 8},
    {u"\\nprecsim", u"U+0227E + U+00338", u"≾̸", u"Precedes Or Equivalent To + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 9},
    {u"\\nrightarrow", u"U+0219B", u"↛", u"Rightwards Arrow With Stroke / Right Arrow With Stroke", 12},
    {u"\\nrleg", u"U+0019E", u"ƞ", u"Latin Small Letter N With Long Right Leg", 6},
    {u"\\nsim", u"U+02241", u"≁", u"Not Tilde", 5},
    {u"\\nsime", u"U+02244", u"≄", u"Not Asymptotically Equal To", 6},
    {u"\\nsqsubseteq", u"U+022E2", u"⋢", u"Not Square Image Of Or Equal To", 12},
    {u"\\nsqsupseteq", u"U+022E3", u"⋣", u"Not Square Original Of Or Equal To", 12},
    {u"\\nsubset", u"U+02284", u"⊄", u"Not A Subset Of", 8},
    {u"\\nsubseteq", u"U+02288", u"⊈", u"Neither A Subset Of Nor Equal To", 10},
    {u"\\nsubseteqq", u"U+02AC5 + U+00338", u"⫅̸", u"Subset Of Above Equals Sign + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 11},
    {u"\\nsucc", u"U+02281", u"⊁", u"Does Not Succeed", 6},
    {u"\\nsucccurlyeq", u"U+022E1", u"⋡", u"Does Not Succeed Or Equal", 13},
    {u"\\nsucceq", u"U+02AB0 + U+00338", u"⪰̸", u"Succeeds Above Single-Line Equals Sign + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 8},
    {u"\\nsuccsim", u"U+0227F + U+00338", u"≿̸", u"Succeeds Or Equivalent To + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 9},
    {u"\\nsupset", u"U+02285", u"⊅", u"Not A Superset Of", 8},
    {u"\\nsupseteq", u"U+02289", u"⊉", u"Neither A Superset Of Nor Equal To", 10},
    {u"\\nsupseteqq", u"U+02AC6 + U+00338", u"⫆̸", u"Superset Of Above Equals Sign + Combining Long Solidus Overlay / Non-Spacing Long Slash Overlay", 11},
    {u"\\ntriangleleft", u"U+022EA", u"⋪", u"Not Normal Subgroup Of", 14},
    {u"\\ntrianglelefteq", u"U+022EC", u"⋬", u"Not Normal Subgroup Of Or Equal To", 16},
    {u"\\ntriangleright", u"U+022EB", u"⋫", u"Does Not Contain As Normal Subgroup", 15},
    {u"\\ntrianglerighteq", u"U+022ED", u"⋭", u"Does Not Contain As Normal Subgroup Or Equal", 17},
    {u"\\nu", u"U+003BD", u"ν", u"Greek Small Letter Nu", 3},
    {u"\\numero", u"U+02116", u"№", u"Numero Sign / Numero", 7},
    {u"\\nvDash", u"U+022AD", u"⊭", u"Not True", 7},
    {u"\\nvLeftarrow", u"U+02902", u"⤂", u"Leftwards Double Arrow With Vertical Stroke", 12},
    {u"\\nvLeftrightarrow", u"U+02904", u"⤄", u"Left Right Double Arrow With Vertical Stroke", 17},
    {u"\\nvRightarrow", u"U+02903", u"⤃", u"Rightwards Double Arrow With Vertical Stroke", 13},
    {u"\\nvdash", u"U+022AC", u"⊬", u"Does Not Prove", 7},
    {u"\\nvleftarrow", u"U+021F7", u"⇷", u"Leftwards Arrow With Vertical Stroke", 12},
    {u"\\nvleftarrowtail", u"U+02B39", u"⬹", u"Leftwards Arrow With Tail With Vertical Stroke", 16},
    {u"\\nvleftrightarrow", u"U+021F9", u"⇹", u"Left Right Arrow With Vertical Stroke", 17},
    {u"\\nvrightarrow", u"U+021F8", u"⇸", u"Rightwards Arrow With Vertical Stroke", 13},
    {u"\\nvrightarrowtail", u"U+02914", u"⤔", u"Rightwards Arrow With Tail With Vertical Stroke", 17},
    {u"\\nvtwoheadleftarrow", u"U+02B34", u"⬴", u"Leftwards Two-Headed Arrow With Vertical Stroke", 19},
    {u"\\nvtwoheadleftarrowtail", u"U+02B3C", u"⬼", u"Leftwards Two-Headed Arrow With Tail With Vertical Stroke", 23},
    {u"\\nvtwoheadrightarrow", u"U+02900", u"⤀", u"Rightwards Two-Headed Arrow With Vertical Stroke", 20},
    {u"\\nvtwoheadrightarrowtail", u"U+02917", u"⤗", u"Rightwards Two-Headed Arrow With Tail With Vertical Stroke", 24},
    {u"\\nwarrow", u"U+02196", u"↖", u"North West Arrow / Upper Left Arrow", 8},
    {u"\\nwovnearrow", u"U+02932", u"⤲", u"North West Arrow Crossing North East Arrow", 12},
    {u"\\o", u"U+000F8", u"ø", u"Latin Small Letter O With Stroke / Latin Small Letter O Slash", 2},
    {u"\\obar", u"U+0233D", u"⌽", u"Apl Functional Symbol Circle Stile", 5},
    {u"\\obslash", u"U+029B8", u"⦸", u"Circled Reverse Solidus", 8},
    {u"\\ocirc", u"U+0030A", u" ̊ ", u"Combining Ring Above / Non-Spacing Ring Above", 6},
    {u"\\ocommatopright", u"U+00315", u" ̕ ", u"Combining Comma Above Right / Non-Spacing Comma Above Right", 15},
    {u"\\odiv", u"U+02A38", u"⨸", u"Circled Division Sign", 5},
    {u"\\odot", u"U+02299", u"⊙", u"Circled Dot Operator", 5},
    {u"\\odotslashdot", u"U+029BC", u"⦼", u"Circled Anticlockwise-Rotated Division Sign", 13},
    {u"\\oe", u"U+00153", u"œ", u"Latin Small Ligature Oe / Latin Small Letter O E", 3},
    {u"\\ogreaterthan", u"U+029C1", u"⧁", u"Circled Greater-Than", 13},
    {u"\\ohm", u"U+02126", u"Ω", u"Ohm Sign / Ohm", 4},
    {u"\\oiiint", u"U+02230", u"∰", u"Volume Integral", 7},
    {u"\\oiint", u"U+0222F", u"∯", u"Surface Integral", 6},
    {u"\\oint", u"U+0222E", u"∮", u"Contour Integral", 5},
    {u"\\ointctrclockwise", u"U+02233", u"∳", u"Anticlockwise Contour Integral", 17},
    {u"\\olessthan", u"U+029C0", u"⧀", u"Circled Less-Than", 10},
    {u"\\omega", u"U+003C9", u"ω", u"Greek Small Letter Omega", 6},
    {u"\\ominus", u"U+02296", u"⊖", u"Circled Minus", 7},
    {u"\\openbracketleft", u"U+027E6", u"⟦", u"Mathematical Left White Square Bracket", 16},
    {u"\\openbracketright", u"U+027E7", u"⟧", u"Mathematical Right White Square Bracket", 17},
    {u"\\openo", u"U+00254", u"ɔ", u"Latin Small Letter Open O", 6},
    {u"\\oplus", u"U+02295", u"⊕", u"Circled Plus", 6},
    {u"\\opluslhrim", u"U+02A2D", u"⨭", u"Plus Sign In Left Half Circle", 11},
    {u"\\oplusrhrim", u"U+02A2E", u"⨮", u"Plus Sign In Right Half Circle", 11},
    {u"\\ordfeminine", u"U+000AA", u"ª", u"Feminine Ordinal Indicator", 12},
    {u"\\ordmasculine", u"U+000BA", u"º", u"Masculine Ordinal Indicator", 13},
    {u"\\original", u"U+022B6", u"⊶", u"Original Of", 9},
    {u"\\oslash", u"U+02298", u"⊘", u"Circled Division Slash", 7},
    {u"\\otimes", u"U+02297", u"⊗", u"Circled Times", 7},
    {u"\\otimeshat", u"U+02A36", u"⨶", u"Circled Multiplication Sign With Circumflex Accent", 10},
    {u"\\otimeslhrim", u"U+02A34", u"⨴", u"Multiplication Sign In Left Half Circle", 12},
    {u"\\otimesrhrim", u"U+02A35", u"⨵", u"Multiplication Sign In Right Half Circle", 12},
    {u"\\oturnedcomma", u"U+00312", u" ̒ ", u"Combining Turned Comma Above / Non-Spacing Turned Comma Above", 13},
    {u"\\overbar", u"U+00305", u" ̅ ", u"Combining Overline / Non-Spacing Overscore", 8},
    {u"\\overbrace", u"U+023DE", u"⏞", u"Top Curly Bracket", 10},
    {u"\\overbracket", u"U+023B4", u"⎴", u"Top Square Bracket", 12},
    {u"\\overleftarrow", u"U+020D6", u" ⃖ ", u"Combining Left Arrow Above / Non-Spacing Left Arrow Above", 14},
    {u"\\overleftrightarrow", u"U+020E1", u" ⃡ ", u"Combining Left Right Arrow Above / Non-Spacing Left Right Arrow Above", 19},
    {u"\\ovhook", u"U+00309", u" ̉ ", u"Combining Hook Above / Non-Spacing Hook Above", 7},
    {u"\\palh", u"U+00321", u" ̡ ", u"Combining Palatalized Hook Below / Non-Spacing Palatalized Hook Below", 5},
    {u"\\parallel", u"U+02225", u"∥", u"Parallel To", 9},
    {u"\\parallelogram", u"U+025B1", u"▱", u"White Parallelogram", 14},
    {u"\\parallelogramblack", u"U+025B0", u"▰", u"Black Parallelogram", 19},
    {u"\\partial", u"U+02202", u"∂", u"Partial Differential", 8},
    {u"\\partialmeetcontraction", u"U+02AA3", u"⪣", u"Double Nested Less-Than With Underbar", 23},
    {u"\\pbgam", u"U+00264", u"ɤ", u"Latin Small Letter Rams Horn / Latin Small Letter Baby Gamma", 6},
    {u"\\pentagon", u"U+02B20", u"⬠", u"White Pentagon", 9},
    {u"\\pentagonblack", u"U+02B1F", u"⬟", u"Black Pentagon", 14},
    {u"\\perp", u"U+027C2", u"⟂", u"Perpendicular", 5},
    {u"\\perspcorrespond", u"U+02A5E", u"⩞", u"Logical And With Double Overbar", 16},
    {u"\\pertenthousand", u"U+02031", u"‱", u"Per Ten Thousand Sign", 15},
    {u"\\perthousand", u"U+02030", u"‰", u"Per Mille Sign", 12},
    {u"\\pes", u"U+020A7", u"₧", u"Peseta Sign", 4},
    {u"\\pgamma", u"U+00263", u"ɣ", u"Latin Small Letter Gamma", 7},
    {u"\\phi", u"U+003D5", u"ϕ", u"Greek Phi Symbol / Greek Small Letter Script Phi", 4},
    {u"\\pi", u"U+003C0", u"π", u"Greek Small Letter Pi", 3},
    {u"\\pisces", u"U+02653", u"♓", u"Pisces", 7},
    {u"\\pitchfork", u"U+022D4", u"⋔", u"Pitchfork", 10},
    {u"\\planck", u"U+0210E", u"ℎ", u"Planck Constant", 7},
    {u"\\plusdot", u"U+02A25", u"⨥", u"Plus Sign With Dot Below", 8},
    {u"\\pluseqq", u"U+02A72", u"⩲", u"Plus Sign Above Equals Sign", 8},
    {u"\\plushat", u"U+02A23", u"⨣", u"Plus Sign With Circumflex Accent Above", 8},
    {u"\\plussim", u"U+02A26", u"⨦", u"Plus Sign With Tilde Below", 8},
    {u"\\plussubtwo", u"U+02A27", u"⨧", u"Plus Sign With Subscript Two", 11},
    {u"\\plustrif", u"U+02A28", u"⨨", u"Plus Sign With Black Triangle", 9},
    {u"\\pluto", u"U+02647", u"♇", u"Pluto", 6},
    {u"\\pm", u"U+000B1", u"±", u"Plus-Minus Sign / Plus-Or-Minus Sign", 3},
    {u"\\pointint", u"U+02A15", u"⨕", u"Integral Around A Point Operator", 9},
    {u"\\postalmark", u"U+03012", u"〒", u"Postal Mark", 11},
    {u"\\pppprime", u"U+02057", u"⁗", u"Quadruple Prime", 9},
    {u"\\ppprime", u"U+02034", u"‴", u"Triple Prime", 8},
    {u"\\pprime", u"U+02033", u"″", u"Double Prime", 7},
    {u"\\prec", u"U+0227A", u"≺", u"Precedes", 5},
    {u"\\precapprox", u"U+02AB7", u"⪷", u"Precedes Above Almost Equal To", 11},
    {u"\\preccurlyeq", u"U+0227C", u"≼", u"Precedes Or Equal To", 12},
    {u"\\preceq", u"U+02AAF", u"⪯", u"Precedes Above Single-Line Equals Sign", 7},
    {u"\\preceqq", u"U+02AB3", u"⪳", u"Precedes Above Equals Sign", 8},
    {u"\\precnapprox", u"U+02AB9", u"⪹", u"Precedes Above Not Almost Equal To", 12},
    {u"\\precneq", u"U+02AB1", u"⪱", u"Precedes Above Single-Line Not Equal To", 8},
    {u"\\precneqq", u"U+02AB5", u"⪵", u"Precedes Above Not Equal To", 9},
    {u"\\precnsim", u"U+022E8", u"⋨", u"Precedes But Not Equivalent To", 9},
    {u"\\precsim", u"U+0227E", u"≾", u"Precedes Or Equivalent To", 8},
    {u"\\prime", u"U+02032", u"′", u"Prime", 6},
    {u"\\prod", u"U+0220F", u"∏", u"N-Ary Product", 5},
    {u"\\profline", u"U+02312", u"⌒", u"Arc", 9},
    {u"\\profsurf", u"U+02313", u"⌓", u"Segment", 9},
    {u"\\propto", u"U+0221D", u"∝", u"Proportional To", 7},
    {u"\\prurel", u"U+022B0", u"⊰", u"Precedes Under Relation", 7},
    {u"\\pscrv", u"U+0028B", u"ʋ", u"Latin Small Letter V With Hook / Latin Small Letter Script V", 6},
    {u"\\psi", u"U+003C8", u"ψ", u"Greek Small Letter Psi", 4},
    {u"\\pupsil", u"U+0028A", u"ʊ", u"Latin Small Letter Upsilon", 7},
    {u"\\quad", u"U+02003", u" ", u"Em Space", 5},
    {u"\\quarternote", u"U+02669", u"♩", u"Quarter Note", 12},
    {u"\\questeq", u"U+0225F", u"≟", u"Questioned Equal To", 8},
    {u"\\questiondown", u"U+000BF", u"¿", u"Inverted Question Mark", 13},
    {u"\\quotedblleft", u"U+0201C", u"“", u"Left Double Quotation Mark / Double Turned Comma Quotation Mark", 13},
    {u"\\quotedblright", u"U+0201D", u"”", u"Right Double Quotation Mark / Double Comma Quotation Mark", 14},
    {u"\\rLarr", u"U+02944", u"⥄", u"Short Rightwards Arrow Above Leftwards Arrow", 6},
    {u"\\rais", u"U+002D4", u"˔", u"Modifier Letter Up Tack", 5},
    {u"\\rangle", u"U+027E9", u"⟩", u"Mathematical Right Angle Bracket", 7},
    {u"\\rarrx", u"U+02947", u"⥇", u"Rightwards Arrow Through X", 6},
    {u"\\rasp", u"U+002BC", u"ʼ", u"Modifier Letter Apostrophe", 5},
    {u"\\rceil", u"U+02309", u"⌉", u"Right Ceiling", 6},
    {u"\\rdiagovfdiag", u"U+0292B", u"⤫", u"Rising Diagonal Crossing Falling Diagonal", 13},
    {u"\\rdiagovsearrow", u"U+02930", u"⤰", u"Rising Diagonal Crossing South East Arrow", 15},
    {u"\\reapos", u"U+0201B", u"‛", u"Single High-Reversed-9 Quotation Mark / Single Reversed Comma Quotation Mark", 7},
    {u"\\recorder", u"U+02315", u"⌕", u"Telephone Recorder", 9},
    {u"\\reglst", u"U+00295", u"ʕ", u"Latin Letter Pharyngeal Voiced Fricative / Latin Letter Reversed Glottal Stop", 7},
    {u"\\revangle", u"U+029A3", u"⦣", u"Reversed Angle", 9},
    {u"\\revangleubar", u"U+029A5", u"⦥", u"Reversed Angle With Underbar", 13},
    {u"\\revemptyset", u"U+029B0", u"⦰", u"Reversed Empty Set", 12},
    {u"\\rfloor", u"U+0230B", u"⌋", u"Right Floor", 7},
    {u"\\rh", u"U+00322", u" ̢ ", u"Combining Retroflex Hook Below / Non-Spacing Retroflex Hook Below", 3},
    {u"\\rho", u"U+003C1", u"ρ", u"Greek Small Letter Rho", 4},
    {u"\\rightangle", u"U+0221F", u"∟", u"Right Angle", 11},
    {u"\\rightanglearc", u"U+022BE", u"⊾", u"Right Angle With Arc", 14},
    {u"\\rightanglemdot", u"U+0299D", u"⦝", u"Measured Right Angle With Dot", 15},
    {u"\\rightarrow", u"U+02192", u"→", u"Rightwards Arrow / Right Arrow", 11},
    {u"\\rightarrowbackapprox", u"U+02B48", u"⭈", u"Rightwards Arrow Above Reverse Almost Equal To", 21},
    {u"\\rightarrowbar", u"U+021E5", u"⇥", u"Rightwards Arrow To Bar / Right Arrow To Bar", 14},
    {u"\\rightarrowbsimilar", u"U+02B4C", u"⭌", u"Rightwards Arrow Above Reverse Tilde Operator", 19},
    {u"\\rightarrowdiamond", u"U+0291E", u"⤞", u"Rightwards Arrow To Black Diamond", 18},
    {u"\\rightarrowgtr", u"U+02B43", u"⭃", u"Rightwards Arrow Through Greater-Than", 14},
    {u"\\rightarrowplus", u"U+02945", u"⥅", u"Rightwards Arrow With Plus Below", 15},
    {u"\\rightarrowsupset", u"U+02B44", u"⭄", u"Rightwards Arrow Through Superset", 17},
    {u"\\rightarrowtail", u"U+021A3", u"↣", u"Rightwards Arrow With Tail / Right Arrow With Tail", 15},
    {u"\\rightarrowtriangle", u"U+021FE", u"⇾", u"Rightwards Open-Headed Arrow", 19},
    {u"\\rightdasharrow", u"U+021E2", u"⇢", u"Rightwards Dashed Arrow / Right Dashed Arrow", 15},
    {u"\\rightdotarrow", u"U+02911", u"⤑", u"Rightwards Arrow With Dotted Stem", 14},
    {u"\\rightharpoonaccent", u"U+020D1", u" ⃑ ", u"Combining Right Harpoon Above / Non-Spacing Right Harpoon Above", 19},
    {u"\\rightharpoondown", u"U+021C1", u"⇁", u"Rightwards Harpoon With Barb Downwards / Right Harpoon With Barb Down", 17},
    {u"\\rightharpoonsupdown", u"U+02964", u"⥤", u"Rightwards Harpoon With Barb Up Above Rightwards Harpoon With Barb Down", 20},
    {u"\\rightharpoonup", u"U+021C0", u"⇀", u"Rightwards Harpoon With Barb Upwards / Right Harpoon With Barb Up", 15},
    {u"\\rightharpoonupdash", u"U+0296C", u"⥬", u"Rightwards Harpoon With Barb Up Above Long Dash", 19},
    {u"\\rightleftarrows", u"U+021C4", u"⇄", u"Rightwards Arrow Over Leftwards Arrow / Right Arrow Over Left Arrow", 16},
    {u"\\rightleftharpoons", u"U+021CC", u"⇌", u"Rightwards Harpoon Over Leftwards Harpoon / Right Harpoon Over Left Harpoon", 18},
    {u"\\rightleftharpoonsdown", u"U+02969", u"⥩", u"Rightwards Harpoon With Barb Down Above Leftwards Harpoon With Barb Down", 22},
    {u"\\rightleftharpoonsup", u"U+02968", u"⥨", u"Rightwards Harpoon With Barb Up Above Leftwards Harpoon With Barb Up", 20},
    {u"\\rightmoon", u"U+0263D", u"☽", u"First Quarter Moon", 10},
    {u"\\rightouterjoin", u"U+027D6", u"⟖", u"Right Outer Join", 15},
    {u"\\rightpentagon", u"U+02B54", u"⭔", u"White Right-Pointing Pentagon", 14},
    {u"\\rightpentagonblack", u"U+02B53", u"⭓", u"Black Right-Pointing Pentagon", 19},
    {u"\\rightrightarrows", u"U+021C9", u"⇉", u"Rightwards Paired Arrows / Right Paired Arrows", 17},
    {u"\\rightsquigarrow", u"U+021DD", u"⇝", u"Rightwards Squiggle Arrow / Right Squiggle Arrow", 16},
    {u"\\rightthreearrows", u"U+021F6", u"⇶", u"Three Rightwards Arrows", 17},
    {u"\\rightthreetimes", u"U+022CC", u"⋌", u"Right Semidirect Product", 16},
    {u"\\rightwavearrow", u"U+0219D", u"↝", u"Rightwards Wave Arrow / Right Wave Arrow", 15},
    {u"\\rightwhitearrow", u"U+021E8", u"⇨", u"Rightwards White Arrow / White Right Arrow", 16},
    {u"\\ringplus", u"U+02A22", u"⨢", u"Plus Sign With Small Circle Above", 9},
    {u"\\risingdotseq", u"U+02253", u"≓", u"Image Of Or Approximately Equal To", 13},
    {u"\\rl", u"U+0027C", u"ɼ", u"Latin Small Letter R With Long Leg", 3},
    {u"\\rmoustache", u"U+023B1", u"⎱", u"Upper Right Or Lower Left Curly Bracket Section", 11},
    {u"\\rppolint", u"U+02A12", u"⨒", u"Line Integration With Rectangular Path Around Pole", 9},
    {u"\\rq", u"U+02019", u"’", u"Right Single Quotation Mark / Single Comma Quotation Mark", 3},
    {u"\\rrbracket", u"U+027E7", u"⟧", u"Mathematical Right White Square Bracket", 10},
    {u"\\rsolbar", u"U+029F7", u"⧷", u"Reverse Solidus With Horizontal Stroke", 8},
    {u"\\rsqhook", u"U+02ACE", u"⫎", u"Square Right Open Box Operator", 8},
    {u"\\rtimes", u"U+022CA", u"⋊", u"Right Normal Factor Semidirect Product", 7},
    {u"\\rtld", u"U+00256", u"ɖ", u"Latin Small Letter D With Tail / Latin Small Letter D Retroflex Hook", 5},
    {u"\\rtll", u"U+0026D", u"ɭ", u"Latin Small Letter L With Retroflex Hook / Latin Small Letter L Retroflex Hook", 5},
    {u"\\rtln", u"U+00273", u"ɳ", u"Latin Small Letter N With Retroflex Hook / Latin Small Letter N Retroflex Hook", 5},
    {u"\\rtlr", u"U+0027D", u"ɽ", u"Latin Small Letter R With Tail / Latin Small Letter R Hook", 5},
    {u"\\rtls", u"U+00282", u"ʂ", u"Latin Small Letter S With Hook / Latin Small Letter S Hook", 5},
    {u"\\rtlt", u"U+00288", u"ʈ", u"Latin Small Letter T With Retroflex Hook / Latin Small Letter T Retroflex Hook", 5},
    {u"\\rtlz", u"U+00290", u"ʐ", u"Latin Small Letter Z With Retroflex Hook / Latin Small Letter Z Retroflex Hook", 5},
    {u"\\rttrnr", u"U+0027B", u"ɻ", u"Latin Small Letter Turned R With Hook / Latin Small Letter Turned R Hook", 7},
    {u"\\rvboxline", u"U+023B9", u"⎹", u"Right Vertical Box Line", 10},
    {u"\\rvbull", u"U+025D8", u"◘", u"Inverse Bullet", 7},
    {u"\\sagittarius", u"U+02650", u"♐", u"Sagittarius", 12},
    {u"\\sansA", u"U+1D5A0", u"𝖠", u"Mathematical Sans-Serif Capital A", 6},
    {u"\\sansB", u"U+1D5A1", u"𝖡", u"Mathematical Sans-Serif Capital B", 6},
    {u"\\sansC", u"U+1D5A2", u"𝖢", u"Mathematical Sans-Serif Capital C", 6},
    {u"\\sansD", u"U+1D5A3", u"𝖣", u"Mathematical Sans-Serif Capital D", 6},
    {u"\\sansE", u"U+1D5A4", u"𝖤", u"Mathematical Sans-Serif Capital E", 6},
    {u"\\sansF", u"U+1D5A5", u"𝖥", u"Mathematical Sans-Serif Capital F", 6},
    {u"\\sansG", u"U+1D5A6", u"𝖦", u"Mathematical Sans-Serif Capital G", 6},
    {u"\\sansH", u"U+1D5A7", u"𝖧", u"Mathematical Sans-Serif Capital H", 6},
    {u"\\sansI", u"U+1D5A8", u"𝖨", u"Mathematical Sans-Serif Capital I", 6},
    {u"\\sansJ", u"U+1D5A9", u"𝖩", u"Mathematical Sans-Serif Capital J", 6},
    {u"\\sansK", u"U+1D5AA", u"𝖪", u"Mathematical Sans-Serif Capital K", 6},
    {u"\\sansL", u"U+1D5AB", u"𝖫", u"Mathematical Sans-Serif Capital L", 6},
    {u"\\sansLmirrored", u"U+02143", u"⅃", u"Reversed Sans-Serif Capital L", 14},
    {u"\\sansLturned", u"U+02142", u"⅂", u"Turned Sans-Serif Capital L", 12},
    {u"\\sansM", u"U+1D5AC", u"𝖬", u"Mathematical Sans-Serif Capital M", 6},
    {u"\\sansN", u"U+1D5AD", u"𝖭", u"Mathematical Sans-Serif Capital N", 6},
    {u"\\sansO", u"U+1D5AE", u"𝖮", u"Mathematical Sans-Serif Capital O", 6},
    {u"\\sansP", u"U+1D5AF", u"𝖯", u"Mathematical Sans-Serif Capital P", 6},
    {u"\\sansQ", u"U+1D5B0", u"𝖰", u"Mathematical Sans-Serif Capital Q", 6},
    {u"\\sansR", u"U+1D5B1", u"𝖱", u"Mathematical Sans-Serif Capital R", 6},
    {u"\\sansS", u"U+1D5B2", u"𝖲", u"Mathematical Sans-Serif Capital S", 6},
    {u"\\sansT", u"U+1D5B3", u"𝖳", u"Mathematical Sans-Serif Capital T", 6},
    {u"\\sansU", u"U+1D5B4", u"𝖴", u"Mathematical Sans-Serif Capital U", 6},
    {u"\\sansV", u"U+1D5B5", u"𝖵", u"Mathematical Sans-Serif Capital V", 6},
    {u"\\sansW", u"U+1D5B6", u"𝖶", u"Mathematical Sans-Serif Capital W", 6},
    {u"\\sansX", u"U+1D5B7", u"𝖷", u"Mathematical Sans-Serif Capital X", 6},
    {u"\\sansY", u"U+1D5B8", u"𝖸", u"Mathematical Sans-Serif Capital Y", 6},
    {u"\\sansZ", u"U+1D5B9", u"𝖹", u"Mathematical Sans-Serif Capital Z", 6},
    {u"\\sansa", u"U+1D5BA", u"𝖺", u"Mathematical Sans-Serif Small A", 6},
    {u"\\sansb", u"U+1D5BB", u"𝖻", u"Mathematical Sans-Serif Small B", 6},
    {u"\\sansc", u"U+1D5BC", u"𝖼", u"Mathematical Sans-Serif Small C", 6},
    {u"\\sansd", u"U+1D5BD", u"𝖽", u"Mathematical Sans-Serif Small D", 6},
    {u"\\sanse", u"U+1D5BE", u"𝖾", u"Mathematical Sans-Serif Small E", 6},
    {u"\\sanseight", u"U+1D7EA", u"𝟪", u"Mathematical Sans-Serif Digit Eight", 10},
    {u"\\sansf", u"U+1D5BF", u"𝖿", u"Mathematical Sans-Serif Small F", 6},
    {u"\\sansfive", u"U+1D7E7", u"𝟧", u"Mathematical Sans-Serif Digit Five", 9},
    {u"\\sansfour", u"U+1D7E6", u"𝟦", u"Mathematical Sans-Serif Digit Four", 9},
    {u"\\sansg", u"U+1D5C0", u"𝗀", u"Mathematical Sans-Serif Small G", 6},
    {u"\\sansh", u"U+1D5C1", u"𝗁", u"Mathematical Sans-Serif Small H", 6},
    {u"\\sansi", u"U+1D5C2", u"𝗂", u"Mathematical Sans-Serif Small I", 6},
    {u"\\sansj", u"U+1D5C3", u"𝗃", u"Mathematical Sans-Serif Small J", 6},
    {u"\\sansk", u"U+1D5C4", u"𝗄", u"Mathematical Sans-Serif Small K", 6},
    {u"\\sansl", u"U+1D5C5", u"𝗅", u"Mathematical Sans-Serif Small L", 6},
    {u"\\sansm", u"U+1D5C6", u"𝗆", u"Mathematical Sans-Serif Small M", 6},
    {u"\\sansn", u"U+1D5C7", u"𝗇", u"Mathematical Sans-Serif Small N", 6},
    {u"\\sansnine", u"U+1D7EB", u"𝟫", u"Mathematical Sans-Serif Digit Nine", 9},
    {u"\\sanso", u"U+1D5C8", u"𝗈", u"Mathematical Sans-Serif Small O", 6},
    {u"\\sansone", u"U+1D7E3", u"𝟣", u"Mathematical Sans-Serif Digit One", 8},
    {u"\\sansp", u"U+1D5C9", u"𝗉", u"Mathematical Sans-Serif Small P", 6},
    {u"\\sansq", u"U+1D5CA", u"𝗊", u"Mathematical Sans-Serif Small Q", 6},
    {u"\\sansr", u"U+1D5CB", u"𝗋", u"Mathematical Sans-Serif Small R", 6},
    {u"\\sanss", u"U+1D5CC", u"𝗌", u"Mathematical Sans-Serif Small S", 6},
    {u"\\sansseven", u"U+1D7E9", u"𝟩", u"Mathematical Sans-Serif Digit Seven", 10},
    {u"\\sanssix", u"U+1D7E8", u"𝟨", u"Mathematical Sans-Serif Digit Six", 8},
    {u"\\sanst", u"U+1D5CD", u"𝗍", u"Mathematical Sans-Serif Small T", 6},
    {u"\\sansthree", u"U+1D7E5", u"𝟥", u"Mathematical Sans-Serif Digit Three", 10},
    {u"\\sanstwo", u"U+1D7E4", u"𝟤", u"Mathematical Sans-Serif Digit Two", 8},
    {u"\\sansu", u"U+1D5CE", u"𝗎", u"Mathematical Sans-Serif Small U", 6},
    {u"\\sansv", u"U+1D5CF", u"𝗏", u"Mathematical Sans-Serif Small V", 6},
    {u"\\sansw", u"U+1D5D0", u"𝗐", u"Mathematical Sans-Serif Small W", 6},
    {u"\\sansx", u"U+1D5D1", u"𝗑", u"Mathematical Sans-Serif Small X", 6},
    {u"\\sansy", u"U+1D5D2", u"𝗒", u"Mathematical Sans-Serif Small Y", 6},
    {u"\\sansz", u"U+1D5D3", u"𝗓", u"Mathematical Sans-Serif Small Z", 6},
    {u"\\sanszero", u"U+1D7E2", u"𝟢", u"Mathematical Sans-Serif Digit Zero", 9},
    {u"\\saturn", u"U+02644", u"♄", u"Saturn", 7},
    {u"\\sbbrg", u"U+0032A", u" ̪ ", u"Combining Bridge Below / Non-Spacing Bridge Below", 6},
    {u"\\sblhr", u"U+002D3", u"˓", u"Modifier Letter Centred Left Half Ring / Modifier Letter Centered Left Half Ring", 6},
    {u"\\sbrhr", u"U+002D2", u"˒", u"Modifier Letter Centred Right Half Ring / Modifier Letter Centered Right Half Ring", 6},
    {u"\\schwa", u"U+00259", u"ə", u"Latin Small Letter Schwa", 6},
    {u"\\scorpio", u"U+0264F", u"♏", u"Scorpius", 8},
    {u"\\scpolint", u"U+02A13", u"⨓", u"Line Integration With Semicircular Path Around Pole", 9},
    {u"\\scrA", u"U+1D49C", u"𝒜", u"Mathematical Script Capital A", 5},
    {u"\\scrB", u"U+0212C", u"ℬ", u"Script Capital B / Script B", 5},
    {u"\\scrC", u"U+1D49E", u"𝒞", u"Mathematical Script Capital C", 5},
    {u"\\scrD", u"U+1D49F", u"𝒟", u"Mathematical Script Capital D", 5},
    {u"\\scrE", u"U+02130", u"ℰ", u"Script Capital E / Script E", 5},
    {u"\\scrF", u"U+02131", u"ℱ", u"Script Capital F / Script F", 5},
    {u"\\scrG", u"U+1D4A2", u"𝒢", u"Mathematical Script Capital G", 5},
    {u"\\scrH", u"U+0210B", u"ℋ", u"Script Capital H / Script H", 5},
    {u"\\scrI", u"U+02110", u"ℐ", u"Script Capital I / Script I", 5},
    {u"\\scrJ", u"U+1D4A5", u"𝒥", u"Mathematical Script Capital J", 5},
    {u"\\scrK", u"U+1D4A6", u"𝒦", u"Mathematical Script Capital K", 5},
    {u"\\scrL", u"U+02112", u"ℒ", u"Script Capital L / Script L", 5},
    {u"\\scrM", u"U+02133", u"ℳ", u"Script Capital M / Script M", 5},
    {u"\\scrN", u"U+1D4A9", u"𝒩", u"Mathematical Script Capital N", 5},
    {u"\\scrO", u"U+1D4AA", u"𝒪", u"Mathematical Script Capital O", 5},
    {u"\\scrP", u"U+1D4AB", u"𝒫", u"Mathematical Script Capital P", 5},
    {u"\\scrQ", u"U+1D4AC", u"𝒬", u"Mathematical Script Capital Q", 5},
    {u"\\scrR", u"U+0211B", u"ℛ", u"Script Capital R / Script R", 5},
    {u"\\scrS", u"U+1D4AE", u"𝒮", u"Mathematical Script Capital S", 5},
    {u"\\scrT", u"U+1D4AF", u"𝒯", u"Mathematical Script Capital T", 5},
    {u"\\scrU", u"U+1D4B0", u"𝒰", u"Mathematical Script Capital U", 5},
    {u"\\scrV", u"U+1D4B1", u"𝒱", u"Mathematical Script Capital V", 5},
    {u"\\scrW", u"U+1D4B2", u"𝒲", u"Mathematical Script Capital W", 5},
    {u"\\scrX", u"U+1D4B3", u"𝒳", u"Mathematical Script Capital X", 5},
    {u"\\scrY", u"U+1D4B4", u"𝒴", u"Mathematical Script Capital Y", 5},
    {u"\\scrZ", u"U+1D4B5", u"𝒵", u"Mathematical Script Capital Z", 5},
    {u"\\scra", u"U+1D4B6", u"𝒶", u"Mathematical Script Small A", 5},
    {u"\\scrb", u"U+1D4B7", u"𝒷", u"Mathematical Script Small B", 5},
    {u"\\scrc", u"U+1D4B8", u"𝒸", u"Mathematical Script Small C", 5},
    {u"\\scrd", u"U+1D4B9", u"𝒹", u"Mathematical Script Small D", 5},
    {u"\\scre", u"U+0212F", u"ℯ", u"Script Small E", 5},
    {u"\\scrf", u"U+1D4BB", u"𝒻", u"Mathematical Script Small F", 5},
    {u"\\scrg", u"U+0210A", u"ℊ", u"Script Small G", 5},
    {u"\\scrh", u"U+1D4BD", u"𝒽", u"Mathematical Script Small H", 5},
    {u"\\scri", u"U+1D4BE", u"𝒾", u"Mathematical Script Small I", 5},
    {u"\\scrj", u"U+1D4BF", u"𝒿", u"Mathematical Script Small J", 5},
    {u"\\scrk", u"U+1D4C0", u"𝓀", u"Mathematical Script Small K", 5},
    {u"\\scrl", u"U+1D4C1", u"𝓁", u"Mathematical Script Small L", 5},
    {u"\\scrm", u"U+1D4C2", u"𝓂", u"Mathematical Script Small M", 5},
    {u"\\scrn", u"U+1D4C3", u"𝓃", u"Mathematical Script Small N", 5},
    {u"\\scro", u"U+02134", u"ℴ", u"Script Small O", 5},
    {u"\\scrp", u"U+1D4C5", u"𝓅", u"Mathematical Script Small P", 5},
    {u"\\scrq", u"U+1D4C6", u"𝓆", u"Mathematical Script Small Q", 5},
    {u"\\scrr", u"U+1D4C7", u"𝓇", u"Mathematical Script Small R", 5},
    {u"\\scrs", u"U+1D4C8", u"𝓈", u"Mathematical Script Small S", 5},
    {u"\\scrt", u"U+1D4C9", u"𝓉", u"Mathematical Script Small T", 5},
    {u"\\scru", u"U+1D4CA", u"𝓊", u"Mathematical Script Small U", 5},
    {u"\\scrv", u"U+1D4CB", u"𝓋", u"Mathematical Script Small V", 5},
    {u"\\scrw", u"U+1D4CC", u"𝓌", u"Mathematical Script Small W", 5},
    {u"\\scrx", u"U+1D4CD", u"𝓍", u"Mathematical Script Small X", 5},
    {u"\\scry", u"U+1D4CE", u"𝓎", u"Mathematical Script Small Y", 5},
    {u"\\scrz", u"U+1D4CF", u"𝓏", u"Mathematical Script Small Z", 5},
    {u"\\scurel", u"U+022B1", u"⊱", u"Succeeds Under Relation", 7},
    {u"\\searrow", u"U+02198", u"↘", u"South East Arrow / Lower Right Arrow", 8},
    {u"\\seovnearrow", u"U+0292D", u"⤭", u"South East Arrow Crossing North East Arrow", 12},
    {u"\\setminus", u"U+02216", u"∖", u"Set Minus", 9},
    {u"\\sharp", u"U+0266F", u"♯", u"Music Sharp Sign / Sharp", 6},
    {u"\\shuffle", u"U+029E2", u"⧢", u"Shuffle Product", 8},
    {u"\\sigma", u"U+003C3", u"σ", u"Greek Small Letter Sigma", 6},
    {u"\\sim", u"U+0223C", u"∼", u"Tilde Operator", 4},
    {u"\\simeq", u"U+02243", u"≃", u"Asymptotically Equal To", 6},
    {u"\\simgE", u"U+02AA0", u"⪠", u"Similar Above Greater-Than Above Equals Sign", 6},
    {u"\\simgtr", u"U+02A9E", u"⪞", u"Similar Or Greater-Than", 7},
    {u"\\similarleftarrow", u"U+02B49", u"⭉", u"Tilde Operator Above Leftwards Arrow", 17},
    {u"\\simlE", u"U+02A9F", u"⪟", u"Similar Above Less-Than Above Equals Sign", 6},
    {u"\\simless", u"U+02A9D", u"⪝", u"Similar Or Less-Than", 8},
    {u"\\simminussim", u"U+02A6C", u"⩬", u"Similar Minus Similar", 12},
    {u"\\simplus", u"U+02A24", u"⨤", u"Plus Sign With Tilde Above", 8},
    {u"\\simrdots", u"U+02A6B", u"⩫", u"Tilde Operator With Rising Dots", 9},
    {u"\\sinewave", u"U+0223F", u"∿", u"Sine Wave", 9},
    {u"\\smallblacktriangleleft", u"U+025C2", u"◂", u"Black Left-Pointing Small Triangle / Black Left Pointing Small Triangle", 23},
    {u"\\smallblacktriangleright", u"U+025B8", u"▸", u"Black Right-Pointing Small Triangle / Black Right Pointing Small Triangle", 24},
    {u"\\smallin", u"U+0220A", u"∊", u"Small Element Of", 8},
    {u"\\smallni", u"U+0220D", u"∍", u"Small Contains As Member", 8},
    {u"\\smalltriangleleft", u"U+025C3", u"◃", u"White Left-Pointing Small Triangle / White Left Pointing Small Triangle", 18},
    {u"\\smalltriangleright", u"U+025B9", u"▹", u"White Right-Pointing Small Triangle / White Right Pointing Small Triangle", 19},
    {u"\\smashtimes", u"U+02A33", u"⨳", u"Smash Product", 11},
    {u"\\smblkdiamond", u"U+02B29", u"⬩", u"Black Small Diamond", 13},
    {u"\\smblklozenge", u"U+02B2A", u"⬪", u"Black Small Lozenge", 13},
    {u"\\smblksquare", u"U+025AA", u"▪", u"Black Small Square", 12},
    {u"\\smeparsl", u"U+029E4", u"⧤", u"Equals Sign And Slanted Parallel With Tilde Above", 9},
    {u"\\smile", u"U+02323", u"⌣", u"Smile", 6},
    {u"\\smt", u"U+02AAA", u"⪪", u"Smaller Than", 4},
    {u"\\smte", u"U+02AAC", u"⪬", u"Smaller Than Or Equal To", 5},
    {u"\\smwhitestar", u"U+02B52", u"⭒", u"White Small Star", 12},
    {u"\\smwhtcircle", u"U+025E6", u"◦", u"White Bullet", 12},
    {u"\\smwhtlozenge", u"U+02B2B", u"⬫", u"White Small Lozenge", 13},
    {u"\\smwhtsquare", u"U+025AB", u"▫", u"White Small Square", 12},
    {u"\\sout", u"U+00336", u" ̶ ", u"Combining Long Stroke Overlay / Non-Spacing Long Bar Overlay", 5},
    {u"\\spadesuit", u"U+02660", u"♠", u"Black Spade Suit", 10},
    {u"\\sphericalangle", u"U+02222", u"∢", u"Spherical Angle", 15},
    {u"\\sphericalangleup", u"U+029A1", u"⦡", u"Spherical Angle Opening Up", 17},
    {u"\\sqcap", u"U+02293", u"⊓", u"Square Cap", 6},
    {u"\\sqcup", u"U+02294", u"⊔", u"Square Cup", 6},
    {u"\\sqfl", u"U+025E7", u"◧", u"Square With Left Half Black", 5},
    {u"\\sqfnw", u"U+02519", u"┙", u"Box Drawings Up Light And Left Heavy / Forms Up Light And Left Heavy", 6},
    {u"\\sqfr", u"U+025E8", u"◨", u"Square With Right Half Black", 5},
    {u"\\sqfse", u"U+025EA", u"◪", u"Square With Lower Right Diagonal Half Black", 6},
    {u"\\sqlozenge", u"U+02311", u"⌑", u"Square Lozenge", 10},
    {u"\\sqrint", u"U+02A16", u"⨖", u"Quaternion Integral Operator", 7},
    {u"\\sqrt", u"U+0221A", u"√", u"Square Root", 5},
    {u"\\sqrtbottom", u"U+023B7", u"⎷", u"Radical Symbol Bottom", 11},
    {u"\\sqspne", u"U+022E5", u"⋥", u"Square Original Of Or Not Equal To", 7},
    {u"\\sqsubset", u"U+0228F", u"⊏", u"Square Image Of", 9},
    {u"\\sqsubseteq", u"U+02291", u"⊑", u"Square Image Of Or Equal To", 11},
    {u"\\sqsubsetneq", u"U+022E4", u"⋤", u"Square Image Of Or Not Equal To", 12},
    {u"\\sqsupset", u"U+02290", u"⊐", u"Square Original Of", 9},
    {u"\\sqsupseteq", u"U+02292", u"⊒", u"Square Original Of Or Equal To", 11},
    {u"\\square", u"U+025A1", u"□", u"White Square", 7},
    {u"\\squarebotblack", u"U+02B13", u"⬓", u"Square With Bottom Half Black", 15},
    {u"\\squarecrossfill", u"U+025A9", u"▩", u"Square With Diagonal Crosshatch Fill", 16},
    {u"\\squarehfill", u"U+025A4", u"▤", u"Square With Horizontal Fill", 12},
    {u"\\squarehvfill", u"U+025A6", u"▦", u"Square With Orthogonal Crosshatch Fill", 13},
    {u"\\squarellblack", u"U+02B15", u"⬕", u"Square With Lower Left Diagonal Half Black", 14},
    {u"\\squarellquad", u"U+025F1", u"◱", u"White Square With Lower Left Quadrant", 13},
    {u"\\squarelrquad", u"U+025F2", u"◲", u"White Square With Lower Right Quadrant", 13},
    {u"\\squareneswfill", u"U+025A8", u"▨", u"Square With Upper Right To Lower Left Fill", 15},
    {u"\\squarenwsefill", u"U+025A7", u"▧", u"Square With Upper Left To Lower Right Fill", 15},
    {u"\\squaretopblack", u"U+02B12", u"⬒", u"Square With Top Half Black", 15},
    {u"\\squareulblack", u"U+025E9", u"◩", u"Square With Upper Left Diagonal Half Black", 14},
    {u"\\squareulquad", u"U+025F0", u"◰", u"White Square With Upper Left Quadrant", 13},
    {u"\\squareurblack", u"U+02B14", u"⬔", u"Square With Upper Right Diagonal Half Black", 14},
    {u"\\squareurquad", u"U+025F3", u"◳", u"White Square With Upper Right Quadrant", 13},
    {u"\\squarevfill", u"U+025A5", u"▥", u"Square With Vertical Fill", 12},
    {u"\\squoval", u"U+025A2", u"▢", u"White Square With Rounded Corners", 8},
    {u"\\ss", u"U+000DF", u"ß", u"Latin Small Letter Sharp S", 3},
    {u"\\star", u"U+022C6", u"⋆", u"Star Operator", 5},
    {u"\\starequal", u"U+0225B", u"≛", u"Star Equals", 10},
    {u"\\sterling", u"U+000A3", u"£", u"Pound Sign", 9},
    {u"\\strike", u"U+00336", u" ̶ ", u"Combining Long Stroke Overlay / Non-Spacing Long Bar Overlay", 7},
    {u"\\strns", u"U+023E4", u"⏤", u"Straightness", 6},
    {u"\\subedot", u"U+02AC3", u"⫃", u"Subset Of Or Equal To With Dot Above", 8},
    {u"\\submult", u"U+02AC1", u"⫁", u"Subset With Multiplication Sign Below", 8},
    {u"\\subset", u"U+02282", u"⊂", u"Subset Of", 7},
    {u"\\subsetapprox", u"U+02AC9", u"⫉", u"Subset Of Above Almost Equal To", 13},
    {u"\\subsetdot", u"U+02ABD", u"⪽", u"Subset With Dot", 10},
    {u"\\subseteq", u"U+02286", u"⊆", u"Subset Of Or Equal To", 9},
    {u"\\subseteqq", u"U+02AC5", u"⫅", u"Subset Of Above Equals Sign", 10},
    {u"\\subsetneq", u"U+0228A", u"⊊", u"Subset Of With Not Equal To / Subset Of Or Not Equal To", 10},
    {u"\\subsetneqq", u"U+02ACB", u"⫋", u"Subset Of Above Not Equal To", 11},
    {u"\\subsetplus", u"U+02ABF", u"⪿", u"Subset With Plus Sign Below", 11},
    {u"\\subsim", u"U+02AC7", u"⫇", u"Subset Of Above Tilde Operator", 7},
    {u"\\subsub", u"U+02AD5", u"⫕", u"Subset Above Subset", 7},
    {u"\\subsup", u"U+02AD3", u"⫓", u"Subset Above Superset", 7},
    {u"\\succ", u"U+0227B", u"≻", u"Succeeds", 5},
    {u"\\succapprox", u"U+02AB8", u"⪸", u"Succeeds Above Almost Equal To", 11},
    {u"\\succcurlyeq", u"U+0227D", u"≽", u"Succeeds Or Equal To", 12},
    {u"\\succeq", u"U+02AB0", u"⪰", u"Succeeds Above Single-Line Equals Sign", 7},
    {u"\\succeqq", u"U+02AB4", u"⪴", u"Succeeds Above Equals Sign", 8},
    {u"\\succnapprox", u"U+02ABA", u"⪺", u"Succeeds Above Not Almost Equal To", 12},
    {u"\\succneq", u"U+02AB2", u"⪲", u"Succeeds Above Single-Line Not Equal To", 8},
    {u"\\succneqq", u"U+02AB6", u"⪶", u"Succeeds Above Not Equal To", 9},
    {u"\\succnsim", u"U+022E9", u"⋩", u"Succeeds But Not Equivalent To", 9},
    {u"\\succsim", u"U+0227F", u"≿", u"Succeeds Or Equivalent To", 8},
    {u"\\sum", u"U+02211", u"∑", u"N-Ary Summation", 4},
    {u"\\sumint", u"U+02A0B", u"⨋", u"Summation With Integral", 7},
    {u"\\sun", u"U+0263C", u"☼", u"White Sun With Rays", 4},
    {u"\\supdsub", u"U+02AD8", u"⫘", u"Superset Beside And Joined By Dash With Subset", 8},
    {u"\\supedot", u"U+02AC4", u"⫄", u"Superset Of Or Equal To With Dot Above", 8},
    {u"\\suphsol", u"U+027C9", u"⟉", u"Superset Preceding Solidus", 8},
    {u"\\suphsub", u"U+02AD7", u"⫗", u"Superset Beside Subset", 8},
    {u"\\supmult", u"U+02AC2", u"⫂", u"Superset With Multiplication Sign Below", 8},
    {u"\\supset", u"U+02283", u"⊃", u"Superset Of", 7},
    {u"\\supsetapprox", u"U+02ACA", u"⫊", u"Superset Of Above Almost Equal To", 13},
    {u"\\supsetdot", u"U+02ABE", u"⪾", u"Superset With Dot", 10},
    {u"\\supseteq", u"U+02287", u"⊇", u"Superset Of Or Equal To", 9},
    {u"\\supseteqq", u"U+02AC6", u"⫆", u"Superset Of Above Equals Sign", 10},
    {u"\\supsetneq", u"U+0228B", u"⊋", u"Superset Of With Not Equal To / Superset Of Or Not Equal To", 10},
    {u"\\supsetneqq", u"U+02ACC", u"⫌", u"Superset Of Above Not Equal To", 11},
    {u"\\supsetplus", u"U+02AC0", u"⫀", u"Superset With Plus Sign Below", 11},
    {u"\\supsim", u"U+02AC8", u"⫈", u"Superset Of Above Tilde Operator", 7},
    {u"\\supsub", u"U+02AD4", u"⫔", u"Superset Above Subset", 7},
    {u"\\supsup", u"U+02AD6", u"⫖", u"Superset Above Superset", 7},
    {u"\\surd", u"U+0221A", u"√", u"Square Root", 5},
    {u"\\swarrow", u"U+02199", u"↙", u"South West Arrow / Lower Left Arrow", 8},
    {u"\\tau", u"U+003C4", u"τ", u"Greek Small Letter Tau", 4},
    {u"\\taurus", u"U+02649", u"♉", u"Taurus", 7},
    {u"\\tdcol", u"U+02AF6", u"⫶", u"Triple Colon Operator", 6},
    {u"\\tesh", u"U+002A7", u"ʧ", u"Latin Small Letter Tesh Digraph / Latin Small Letter T Esh", 5},
    {u"\\th", u"U+000FE", u"þ", u"Latin Small Letter Thorn", 3},
    {u"\\therefore", u"U+02234", u"∴", u"Therefore", 10},
    {u"\\theta", u"U+003B8", u"θ", u"Greek Small Letter Theta", 6},
    {u"\\thickspace", u"U+02005", u" ", u"Four-Per-Em Space", 11},
    {u"\\thinspace", u"U+02009", u" ", u"Thin Space", 10},
    {u"\\threedangle", u"U+027C0", u"⟀", u"Three Dimensional Angle", 12},
    {u"\\threeunderdot", u"U+020E8", u" ⃨ ", u"Combining Triple Underdot", 14},
    {u"\\tieconcat", u"U+02040", u"⁀", u"Character Tie", 10},
    {u"\\tilde", u"U+00303", u" ̃ ", u"Combining Tilde / Non-Spacing Tilde", 6},
    {u"\\tildelow", u"U+002DC", u"˜", u"Small Tilde / Spacing Tilde", 9},
    {u"\\tildetrpl", u"U+0224B", u"≋", u"Triple Tilde", 10},
    {u"\\times", u"U+000D7", u"×", u"Multiplication Sign", 6},
    {u"\\timesbar", u"U+02A31", u"⨱", u"Multiplication Sign With Underbar", 9},
    {u"\\to", u"U+02192", u"→", u"Rightwards Arrow / Right Arrow", 3},
    {u"\\toea", u"U+02928", u"⤨", u"North East Arrow And South East Arrow", 5},
    {u"\\tona", u"U+02927", u"⤧", u"North West Arrow And North East Arrow", 5},
    {u"\\top", u"U+022A4", u"⊤", u"Down Tack", 4},
    {u"\\topbot", u"U+02336", u"⌶", u"Apl Functional Symbol I-Beam", 7},
    {u"\\topsemicircle", u"U+025E0", u"◠", u"Upper Half Circle", 14},
    {u"\\tosa", u"U+02929", u"⤩", u"South East Arrow And South West Arrow", 5},
    {u"\\towa", u"U+0292A", u"⤪", u"South West Arrow And North West Arrow", 5},
    {u"\\trademark", u"U+02122", u"™", u"Trade Mark Sign / Trademark", 10},
    {u"\\trapezium", u"U+023E2", u"⏢", u"White Trapezium", 10},
    {u"\\trianglecdot", u"U+025EC", u"◬", u"White Up-Pointing Triangle With Dot / White Up Pointing Triangle With Dot", 13},
    {u"\\triangledown", u"U+025BF", u"▿", u"White Down-Pointing Small Triangle / White Down Pointing Small Triangle", 13},
    {u"\\triangleleft", u"U+025C1", u"◁", u"White Left-Pointing Triangle / White Left Pointing Triangle", 13},
    {u"\\triangleleftblack", u"U+025ED", u"◭", u"Up-Pointing Triangle With Left Half Black / Up Pointing Triangle With Left Half Black", 18},
    {u"\\trianglelefteq", u"U+022B4", u"⊴", u"Normal Subgroup Of Or Equal To", 15},
    {u"\\triangleminus", u"U+02A3A", u"⨺", u"Minus Sign In Triangle", 14},
    {u"\\triangleplus", u"U+02A39", u"⨹", u"Plus Sign In Triangle", 13},
    {u"\\triangleq", u"U+0225C", u"≜", u"Delta Equal To", 10},
    {u"\\triangleright", u"U+025B7", u"▷", u"White Right-Pointing Triangle / White Right Pointing Triangle", 14},
    {u"\\trianglerightblack", u"U+025EE", u"◮", u"Up-Pointing Triangle With Right Half Black / Up Pointing Triangle With Right Half Black", 19},
    {u"\\trianglerighteq", u"U+022B5", u"⊵", u"Contains As Normal Subgroup Or Equal To", 16},
    {u"\\triangletimes", u"U+02A3B", u"⨻", u"Multiplication Sign In Triangle", 14},
    {u"\\tricolon", u"U+0205D", u"⁝", u"Tricolon", 9},
    {u"\\tripleplus", u"U+029FB", u"⧻", u"Triple Plus", 11},
    {u"\\trna", u"U+00250", u"ɐ", u"Latin Small Letter Turned A", 5},
    {u"\\trnh", u"U+00265", u"ɥ", u"Latin Small Letter Turned H", 5},
    {u"\\trnm", u"U+0026F", u"ɯ", u"Latin Small Letter Turned M", 5},
    {u"\\trnmlr", u"U+00270", u"ɰ", u"Latin Small Letter Turned M With Long Leg", 7},
    {u"\\trnr", u"U+00279", u"ɹ", u"Latin Small Letter Turned R", 5},
    {u"\\trnrl", u"U+0027A", u"ɺ", u"Latin Small Letter Turned R With Long Leg", 6},
    {u"\\trnsa", u"U+00252", u"ɒ", u"Latin Small Letter Turned Alpha / Latin Small Letter Turned Script A", 6},
    {u"\\trnt", u"U+00287", u"ʇ", u"Latin Small Letter Turned T", 5},
    {u"\\trny", u"U+0028E", u"ʎ", u"Latin Small Letter Turned Y", 5},
    {u"\\ttA", u"U+1D670", u"𝙰", u"Mathematical Monospace Capital A", 4},
    {u"\\ttB", u"U+1D671", u"𝙱", u"Mathematical Monospace Capital B", 4},
    {u"\\ttC", u"U+1D672", u"𝙲", u"Mathematical Monospace Capital C", 4},
    {u"\\ttD", u"U+1D673", u"𝙳", u"Mathematical Monospace Capital D", 4},
    {u"\\ttE", u"U+1D674", u"𝙴", u"Mathematical Monospace Capital E", 4},
    {u"\\ttF", u"U+1D675", u"𝙵", u"Mathematical Monospace Capital F", 4},
    {u"\\ttG", u"U+1D676", u"𝙶", u"Mathematical Monospace Capital G", 4},
    {u"\\ttH", u"U+1D677", u"𝙷", u"Mathematical Monospace Capital H", 4},
    {u"\\ttI", u"U+1D678", u"𝙸", u"Mathematical Monospace Capital I", 4},
    {u"\\ttJ", u"U+1D679", u"𝙹", u"Mathematical Monospace Capital J", 4},
    {u"\\ttK", u"U+1D67A", u"𝙺", u"Mathematical Monospace Capital K", 4},
    {u"\\ttL", u"U+1D67B", u"𝙻", u"Mathematical Monospace Capital L", 4},
    {u"\\ttM", u"U+1D67C", u"𝙼", u"Mathematical Monospace Capital M", 4},
    {u"\\ttN", u"U+1D67D", u"𝙽", u"Mathematical Monospace Capital N", 4},
    {u"\\ttO", u"U+1D67E", u"𝙾", u"Mathematical Monospace Capital O", 4},
    {u"\\ttP", u"U+1D67F", u"𝙿", u"Mathematical Monospace Capital P", 4},
    {u"\\ttQ", u"U+1D680", u"𝚀", u"Mathematical Monospace Capital Q", 4},
    {u"\\ttR", u"U+1D681", u"𝚁", u"Mathematical Monospace Capital R", 4},
    {u"\\ttS", u"U+1D682", u"𝚂", u"Mathematical Monospace Capital S", 4},
    {u"\\ttT", u"U+1D683", u"𝚃", u"Mathematical Monospace Capital T", 4},
    {u"\\ttU", u"U+1D684", u"𝚄", u"Mathematical Monospace Capital U", 4},
    {u"\\ttV", u"U+1D685", u"𝚅", u"Mathematical Monospace Capital V", 4},
    {u"\\ttW", u"U+1D686", u"𝚆", u"Mathematical Monospace Capital W", 4},
    {u"\\ttX", u"U+1D687", u"𝚇", u"Mathematical Monospace Capital X", 4},
    {u"\\ttY", u"U+1D688", u"𝚈", u"Mathematical Monospace Capital Y", 4},
    {u"\\ttZ", u"U+1D689", u"𝚉", u"Mathematical Monospace Capital Z", 4},
    {u"\\tta", u"U+1D68A", u"𝚊", u"Mathematical Monospace Small A", 4},
    {u"\\ttb", u"U+1D68B", u"𝚋", u"Mathematical Monospace Small B", 4},
    {u"\\ttc", u"U+1D68C", u"𝚌", u"Mathematical Monospace Small C", 4},
    {u"\\ttd", u"U+1D68D", u"𝚍", u"Mathematical Monospace Small D", 4},
    {u"\\tte", u"U+1D68E", u"𝚎", u"Mathematical Monospace Small E", 4},
    {u"\\tteight", u"U+1D7FE", u"𝟾", u"Mathematical Monospace Digit Eight", 8},
    {u"\\ttf", u"U+1D68F", u"𝚏", u"Mathematical Monospace Small F", 4},
    {u"\\ttfive", u"U+1D7FB", u"𝟻", u"Mathematical Monospace Digit Five", 7},
    {u"\\ttfour", u"U+1D7FA", u"𝟺", u"Mathematical Monospace Digit Four", 7},
    {u"\\ttg", u"U+1D690", u"𝚐", u"Mathematical Monospace Small G", 4},
    {u"\\tth", u"U+1D691", u"𝚑", u"Mathematical Monospace Small H", 4},
    {u"\\tti", u"U+1D692", u"𝚒", u"Mathematical Monospace Small I", 4},
    {u"\\ttj", u"U+1D693", u"𝚓", u"Mathematical Monospace Small J", 4},
    {u"\\ttk", u"U+1D694", u"𝚔", u"Mathematical Monospace Small K", 4},
    {u"\\ttl", u"U+1D695", u"𝚕", u"Mathematical Monospace Small L", 4},
    {u"\\ttm", u"U+1D696", u"𝚖", u"Mathematical Monospace Small M", 4},
    {u"\\ttn", u"U+1D697", u"𝚗", u"Mathematical Monospace Small N", 4},
    {u"\\ttnine", u"U+1D7FF", u"𝟿", u"Mathematical Monospace Digit Nine", 7},
    {u"\\tto", u"U+1D698", u"𝚘", u"Mathematical Monospace Small O", 4},
    {u"\\ttone", u"U+1D7F7", u"𝟷", u"Mathematical Monospace Digit One", 6},
    {u"\\ttp", u"U+1D699", u"𝚙", u"Mathematical Monospace Small P", 4},
    {u"\\ttq", u"U+1D69A", u"𝚚", u"Mathematical Monospace Small Q", 4},
    {u"\\ttr", u"U+1D69B", u"𝚛", u"Mathematical Monospace Small R", 4},
    {u"\\tts", u"U+1D69C", u"𝚜", u"Mathematical Monospace Small S", 4},
    {u"\\ttseven", u"U+1D7FD", u"𝟽", u"Mathematical Monospace Digit Seven", 8},
    {u"\\ttsix", u"U+1D7FC", u"𝟼", u"Mathematical Monospace Digit Six", 6},
    {u"\\ttt", u"U+1D69D", u"𝚝", u"Mathematical Monospace Small T", 4},
    {u"\\ttthree", u"U+1D7F9", u"𝟹", u"Mathematical Monospace Digit Three", 8},
    {u"\\tttwo", u"U+1D7F8", u"𝟸", u"Mathematical Monospace Digit Two", 6},
    {u"\\ttu", u"U+1D69E", u"𝚞", u"Mathematical Monospace Small U", 4},
    {u"\\ttv", u"U+1D69F", u"𝚟", u"Mathematical Monospace Small V", 4},
    {u"\\ttw", u"U+1D6A0", u"𝚠", u"Mathematical Monospace Small W", 4},
    {u"\\ttx", u"U+1D6A1", u"𝚡", u"Mathematical Monospace Small X", 4},
    {u"\\tty", u"U+1D6A2", u"𝚢", u"Mathematical Monospace Small Y", 4},
    {u"\\ttz", u"U+1D6A3", u"𝚣", u"Mathematical Monospace Small Z", 4},
    {u"\\ttzero", u"U+1D7F6", u"𝟶", u"Mathematical Monospace Digit Zero", 7},
    {u"\\turnangle", u"U+029A2", u"⦢", u"Turned Angle", 10},
    {u"\\turnediota", u"U+02129", u"℩", u"Turned Greek Small Letter Iota", 11},
    {u"\\turnednot", u"U+02319", u"⌙", u"Turned Not Sign", 10},
    {u"\\turnk", u"U+0029E", u"ʞ", u"Latin Small Letter Turned K", 6},
    {u"\\twocaps", u"U+02A4B", u"⩋", u"Intersection Beside And Joined With Intersection", 8},
    {u"\\twocups", u"U+02A4A", u"⩊", u"Union Beside And Joined With Union", 8},
    {u"\\twoheaddownarrow", u"U+021A1", u"↡", u"Downwards Two Headed Arrow / Down Two Headed Arrow", 17},
    {u"\\twoheadleftarrow", u"U+0219E", u"↞", u"Leftwards Two Headed Arrow / Left Two Headed Arrow", 17},
    {u"\\twoheadleftarrowtail", u"U+02B3B", u"⬻", u"Leftwards Two-Headed Arrow With Tail", 21},
    {u"\\twoheadleftdbkarrow", u"U+02B37", u"⬷", u"Leftwards Two-Headed Triple Dash Arrow", 20},
    {u"\\twoheadmapsfrom", u"U+02B36", u"⬶", u"Leftwards Two-Headed Arrow From Bar", 16},
    {u"\\twoheadmapsto", u"U+02905", u"⤅", u"Rightwards Two-Headed Arrow From Bar", 14},
    {u"\\twoheadrightarrow", u"U+021A0", u"↠", u"Rightwards Two Headed Arrow / Right Two Headed Arrow", 18},
    {u"\\twoheadrightarrowtail", u"U+02916", u"⤖", u"Rightwards Two-Headed Arrow With Tail", 22},
    {u"\\twoheaduparrow", u"U+0219F", u"↟", u"Upwards Two Headed Arrow / Up Two Headed Arrow", 15},
    {u"\\twoheaduparrowcircle", u"U+02949", u"⥉", u"Upwards Two-Headed Arrow From Small Circle", 21},
    {u"\\twonotes", u"U+0266B", u"♫", u"Beamed Eighth Notes / Barred Eighth Notes", 9},
    {u"\\u", u"U+002D8", u"˘", u"Breve / Spacing Breve", 2},
    {u"\\ularc", u"U+025DC", u"◜", u"Upper Left Quadrant Circular Arc", 6},
    {u"\\ulblacktriangle", u"U+025E4", u"◤", u"Black Upper Left Triangle", 16},
    {u"\\ulcorner", u"U+0231C", u"⌜", u"Top Left Corner", 9},
    {u"\\ultriangle", u"U+025F8", u"◸", u"Upper Left Triangle", 11},
    {u"\\uminus", u"U+02A41", u"⩁", u"Union With Minus Sign", 7},
    {u"\\underbar", u"U+00332", u" ̲ ", u"Combining Low Line / Non-Spacing Underscore", 9},
    {u"\\underbrace", u"U+023DF", u"⏟", u"Bottom Curly Bracket", 11},
    {u"\\underbracket", u"U+023B5", u"⎵", u"Bottom Square Bracket", 13},
    {u"\\underleftarrow", u"U+020EE", u" ⃮ ", u"Combining Left Arrow Below", 15},
    {u"\\underleftharpoondown", u"U+020ED", u" ⃭ ", u"Combining Leftwards Harpoon With Barb Downwards", 21},
    {u"\\underleftrightarrow", u"U+0034D", u" ͍ ", u"Combining Left Right Arrow Below", 20},
    {u"\\underrightarrow", u"U+020EF", u" ⃯ ", u"Combining Right Arrow Below", 16},
    {u"\\underrightharpoondown", u"U+020EC", u" ⃬ ", u"Combining Rightwards Harpoon With Barb Downwards", 22},
    {u"\\upMu", u"U+0039C", u"Μ", u"Greek Capital Letter Mu", 5},
    {u"\\upNu", u"U+0039D", u"Ν", u"Greek Capital Letter Nu", 5},
    {u"\\upOmicron", u"U+0039F", u"Ο", u"Greek Capital Letter Omicron", 10},
    {u"\\upand", u"U+0214B", u"⅋", u"Turned Ampersand", 6},
    {u"\\uparrow", u"U+02191", u"↑", u"Upwards Arrow / Up Arrow", 8},
    {u"\\uparrowbarred", u"U+02909", u"⤉", u"Upwards Arrow With Horizontal Stroke", 14},
    {u"\\updasharrow", u"U+021E1", u"⇡", u"Upwards Dashed Arrow / Up Dashed Arrow", 12},
    {u"\\updownarrow", u"U+02195", u"↕", u"Up Down Arrow", 12},
    {u"\\updownarrowbar", u"U+021A8", u"↨", u"Up Down Arrow With Base", 15},
    {u"\\updownharpoonleftright", u"U+0294D", u"⥍", u"Up Barb Left Down Barb Right Harpoon", 23},
    {u"\\updownharpoonrightleft", u"U+0294C", u"⥌", u"Up Barb Right Down Barb Left Harpoon", 23},
    {u"\\upepsilon", u"U+003B5", u"ε", u"Greek Small Letter Epsilon", 10},
    {u"\\upharpoonleft", u"U+021BF", u"↿", u"Upwards Harpoon With Barb Leftwards / Up Harpoon With Barb Left", 14},
    {u"\\upharpoonright", u"U+021BE", u"↾", u"Upwards Harpoon With Barb Rightwards / Up Harpoon With Barb Right", 15},
    {u"\\upharpoonsleftright", u"U+02963", u"⥣", u"Upwards Harpoon With Barb Left Beside Upwards Harpoon With Barb Right", 20},
    {u"\\upin", u"U+027D2", u"⟒", u"Element Of Opening Upwards", 5},
    {u"\\upint", u"U+02A1B", u"⨛", u"Integral With Overbar", 6},
    {u"\\upkoppa", u"U+003DF", u"ϟ", u"Greek Small Letter Koppa", 8},
    {u"\\uplus", u"U+0228E", u"⊎", u"Multiset Union", 6},
    {u"\\upoldKoppa", u"U+003D8", u"Ϙ", u"Greek Letter Archaic Koppa", 11},
    {u"\\upoldkoppa", u"U+003D9", u"ϙ", u"Greek Small Letter Archaic Koppa", 11},
    {u"\\upomicron", u"U+003BF", u"ο", u"Greek Small Letter Omicron", 10},
    {u"\\upsampi", u"U+003E1", u"ϡ", u"Greek Small Letter Sampi", 8},
    {u"\\upsilon", u"U+003C5", u"υ", u"Greek Small Letter Upsilon", 8},
    {u"\\upstigma", u"U+003DB", u"ϛ", u"Greek Small Letter Stigma", 9},
    {u"\\upuparrows", u"U+021C8", u"⇈", u"Upwards Paired Arrows / Up Paired Arrows", 11},
    {u"\\upvarbeta", u"U+003D0", u"ϐ", u"Greek Beta Symbol / Greek Small Letter Curled Beta", 10},
    {u"\\upwhitearrow", u"U+021E7", u"⇧", u"Upwards White Arrow / White Up Arrow", 13},
    {u"\\uranus", u"U+02645", u"♅", u"Uranus", 7},
    {u"\\urarc", u"U+025DD", u"◝", u"Upper Right Quadrant Circular Arc", 6},
    {u"\\urblacktriangle", u"U+025E5", u"◥", u"Black Upper Right Triangle", 16},
    {u"\\urcorner", u"U+0231D", u"⌝", u"Top Right Corner", 9},
    {u"\\urtriangle", u"U+025F9", u"◹", u"Upper Right Triangle", 11},
    {u"\\vDash", u"U+022A8", u"⊨", u"True", 6},
    {u"\\varTheta", u"U+003F4", u"ϴ", u"Greek Capital Theta Symbol", 9},
    {u"\\varbarwedge", u"U+02305", u"⌅", u"Projective", 12},
    {u"\\varcarriagereturn", u"U+023CE", u"⏎", u"Return Symbol", 18},
    {u"\\varclubsuit", u"U+02667", u"♧", u"White Club Suit", 12},
    {u"\\vardiamondsuit", u"U+02666", u"♦", u"Black Diamond Suit", 15},
    {u"\\vardoublebarwedge", u"U+02306", u"⌆", u"Perspective", 18},
    {u"\\varepsilon", u"U+003B5", u"ε", u"Greek Small Letter Epsilon", 11},
    {u"\\varheartsuit", u"U+02665", u"♥", u"Black Heart Suit", 13},
    {u"\\varhexagon", u"U+02B21", u"⬡", u"White Hexagon", 11},
    {u"\\varhexagonblack", u"U+02B22", u"⬢", u"Black Hexagon", 16},
    {u"\\varhexagonlrbonds", u"U+0232C", u"⌬", u"Benzene Ring", 18},
    {u"\\varisinobar", u"U+022F6", u"⋶", u"Element Of With Overbar", 12},
    {u"\\varisins", u"U+022F3", u"⋳", u"Element Of With Vertical Bar At End Of Horizontal Stroke", 9},
    {u"\\varkappa", u"U+003F0", u"ϰ", u"Greek Kappa Symbol / Greek Small Letter Script Kappa", 9},
    {u"\\varlrtriangle", u"U+022BF", u"⊿", u"Right Triangle", 14},
    {u"\\varniobar", u"U+022FD", u"⋽", u"Contains With Overbar", 10},
    {u"\\varnis", u"U+022FB", u"⋻", u"Contains With Vertical Bar At End Of Horizontal Stroke", 7},
    {u"\\varnothing", u"U+02205", u"∅", u"Empty Set", 11},
    {u"\\varointclockwise", u"U+02232", u"∲", u"Clockwise Contour Integral", 17},
    {u"\\varphi", u"U+003C6", u"φ", u"Greek Small Letter Phi", 7},
    {u"\\varpi", u"U+003D6", u"ϖ", u"Greek Pi Symbol / Greek Small Letter Omega Pi", 6},
    {u"\\varrho", u"U+003F1", u"ϱ", u"Greek Rho Symbol / Greek Small Letter Tailed Rho", 7},
    {u"\\varsigma", u"U+003C2", u"ς", u"Greek Small Letter Final Sigma", 9},
    {u"\\varspadesuit", u"U+02664", u"♤", u"White Spade Suit", 13},
    {u"\\varstar", u"U+02736", u"✶", u"Six Pointed Black Star", 8},
    {u"\\varsubsetneqq", u"U+0228A + U+0FE00", u"⊊︀", u"Subset Of With Not Equal To / Subset Of Or Not Equal To + Variation Selector-1", 14},
    {u"\\varsupsetneq", u"U+0228B + U+0FE00", u"⊋︀", u"Superset Of With Not Equal To / Superset Of Or Not Equal To + Variation Selector-1", 13},
    {u"\\vartheta", u"U+003D1", u"ϑ", u"Greek Theta Symbol / Greek Small Letter Script Theta", 9},
    {u"\\vartriangle", u"U+025B5", u"▵", u"White Up-Pointing Small Triangle / White Up Pointing Small Triangle", 12},
    {u"\\vartriangleleft", u"U+022B2", u"⊲", u"Normal Subgroup Of", 16},
    {u"\\vartriangleright", u"U+022B3", u"⊳", u"Contains As Normal Subgroup", 17},
    {u"\\varveebar", u"U+02A61", u"⩡", u"Small Vee With Underbar", 10},
    {u"\\vdash", u"U+022A2", u"⊢", u"Right Tack", 6},
    {u"\\vdots", u"U+022EE", u"⋮", u"Vertical Ellipsis", 6},
    {u"\\vec", u"U+020D7", u" ⃗ ", u"Combining Right Arrow Above / Non-Spacing Right Arrow Above", 4},
    {u"\\vee", u"U+02228", u"∨", u"Logical Or", 4},
    {u"\\veebar", u"U+022BB", u"⊻", u"Xor", 7},
    {u"\\veedoublebar", u"U+02A63", u"⩣", u"Logical Or With Double Underbar", 13},
    {u"\\veeeq", u"U+0225A", u"≚", u"Equiangular To", 6},
    {u"\\veemidvert", u"U+02A5B", u"⩛", u"Logical Or With Middle Stem", 11},
    {u"\\veeodot", u"U+02A52", u"⩒", u"Logical Or With Dot Above", 8},
    {u"\\venus", u"U+02640", u"♀", u"Female Sign", 6},
    {u"\\verti", u"U+002CC", u"ˌ", u"Modifier Letter Low Vertical Line", 6},
    {u"\\vertoverlay", u"U+020D2", u" ⃒ ", u"Combining Long Vertical Line Overlay / Non-Spacing Long Vertical Bar Overlay", 12},
    {u"\\verts", u"U+002C8", u"ˈ", u"Modifier Letter Vertical Line", 6},
    {u"\\verymuchless", u"U+022D8", u"⋘", u"Very Much Less-Than / Very Much Less Than", 13},
    {u"\\viewdata", u"U+02317", u"⌗", u"Viewdata Square", 9},
    {u"\\virgo", u"U+0264D", u"♍", u"Virgo", 6},
    {u"\\visiblespace", u"U+02423", u"␣", u"Open Box", 13},
    {u"\\vrectangleblack", u"U+025AE", u"▮", u"Black Vertical Rectangle", 16},
    {u"\\vrecto", u"U+025AF", u"▯", u"White Vertical Rectangle", 7},
    {u"\\vysmblkcircle", u"U+02219", u"∙", u"Bullet Operator", 14},
    {u"\\vysmblksquare", u"U+02B1D", u"⬝", u"Black Very Small Square", 14},
    {u"\\vysmwhtsquare", u"U+02B1E", u"⬞", u"White Very Small Square", 14},
    {u"\\wedge", u"U+02227", u"∧", u"Logical And", 6},
    {u"\\wedgedot", u"U+027D1", u"⟑", u"And With Dot", 9},
    {u"\\wedgedoublebar", u"U+02A60", u"⩠", u"Logical And With Double Underbar", 15},
    {u"\\wedgemidvert", u"U+02A5A", u"⩚", u"Logical And With Middle Stem", 13},
    {u"\\wedgeodot", u"U+02A51", u"⩑", u"Logical And With Dot Above", 10},
    {u"\\wedgeonwedge", u"U+02A55", u"⩕", u"Two Intersecting Logical And", 13},
    {u"\\wedgeq", u"U+02259", u"≙", u"Estimates", 7},
    {u"\\whitearrowupfrombar", u"U+021EA", u"⇪", u"Upwards White Arrow From Bar / White Up Arrow From Bar", 20},
    {u"\\whiteinwhitetriangle", u"U+027C1", u"⟁", u"White Triangle Containing Small White Triangle", 21},
    {u"\\whitepointerleft", u"U+025C5", u"◅", u"White Left-Pointing Pointer / White Left Pointing Pointer", 17},
    {u"\\whitepointerright", u"U+025BB", u"▻", u"White Right-Pointing Pointer / White Right Pointing Pointer", 18},
    {u"\\whthorzoval", u"U+02B2D", u"⬭", u"White Horizontal Ellipse", 12},
    {u"\\whtvertoval", u"U+02B2F", u"⬯", u"White Vertical Ellipse", 12},
    {u"\\wideangledown", u"U+029A6", u"⦦", u"Oblique Angle Opening Up", 14},
    {u"\\wideangleup", u"U+029A7", u"⦧", u"Oblique Angle Opening Down", 12},
    {u"\\widebridgeabove", u"U+020E9", u" ⃩ ", u"Combining Wide Bridge Above", 16},
    {u"\\wideutilde", u"U+00330", u" ̰ ", u"Combining Tilde Below / Non-Spacing Tilde Below", 11},
    {u"\\wp", u"U+02118", u"℘", u"Script Capital P / Script P", 3},
    {u"\\wr", u"U+02240", u"≀", u"Wreath Product", 3},
    {u"\\xi", u"U+003BE", u"ξ", u"Greek Small Letter Xi", 3},
    {u"\\xor", u"U+022BB", u"⊻", u"Xor", 4},
    {u"\\xrat", u"U+0211E", u"℞", u"Prescription Take", 5},
    {u"\\yen", u"U+000A5", u"¥", u"Yen Sign", 4},
    {u"\\yogh", u"U+00292", u"ʒ", u"Latin Small Letter Ezh / Latin Small Letter Yogh", 5},
    {u"\\zeta", u"U+003B6", u"ζ", u"Greek Small Letter Zeta", 5}};
static const QRegularExpression latexexpr(QStringLiteral("\\\\:?[\\w)^!/:(+=-]+:?$"), QRegularExpression::DontCaptureOption);  // clazy:exclude=non-pod-global-static

// NOLINTEND
// clang-format off
