/*
 * SPDX-FileCopyrightText: 2014 Hugo Pereira Da Costa <hugo.pereira@free.fr>
 *
 * SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 */

#pragma once

#include "breeze.h"
#include "breezedecoration.h"
#include "breezesettings.h"

#include <KSharedConfig>

#include <QObject>

namespace Breeze
{

class SettingsProvider : public QObject
{
    Q_OBJECT

public:
    //* destructor
    ~SettingsProvider();

    //* singleton
    static SettingsProvider *self();

    //* internal settings for given decoration
    InternalSettingsPtr internalSettings(Decoration *);

public Q_SLOTS:

    //* reconfigure
    void reconfigure();

private:
    //* constructor
    SettingsProvider();

    void refreshConfig();

    //* default configuration
    InternalSettingsPtr m_defaultSettings;

    //* exceptions
    InternalSettingsList m_exceptions;

    //* config object
    KSharedConfigPtr m_config;

    //* presets config object
    KSharedConfigPtr m_presetsConfig;

    //* singleton
    static SettingsProvider *s_self;
};
}
