/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;

final class ReflectClassStructure {
    @NotNull
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue(annotationArray, "klass.declaredAnnotations");
        for (Annotation annotation : annotationArray) {
            Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
            this.processAnnotation(visitor2, annotation);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(memberVisitor, "memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "klass.declaredMethods");
        Method[] methodArray2 = methodArray;
        int n2 = 0;
        int n3 = methodArray2.length;
        while (n2 < n3) {
            Method method = methodArray2[n2];
            ++n2;
            Annotation[] annotationArray = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue(annotationArray, "identifier(method.name)");
            Intrinsics.checkNotNullExpressionValue(method, "method");
            Annotation[] annotationArray2 = memberVisitor.visitMethod((Name)annotationArray, SignatureSerializer.INSTANCE.methodDesc(method));
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "method.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray3 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray3, "method.parameterAnnotations");
            annotationArray2 = annotationArray3;
            int n4 = 0;
            int n5 = ((Object[])annotationArray2).length;
            while (n4 < n5) {
                int parameterIndex = n4;
                Annotation annotations2 = annotationArray2[n4];
                ++n4;
                Intrinsics.checkNotNullExpressionValue(annotations2, "annotations");
                for (Annotation annotation : annotations2) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation));
                    if (annotationArgumentVisitor2 == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
                    boolean bl = false;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, "klass.declaredConstructors");
        Constructor<?>[] constructorArray2 = constructorArray;
        int n2 = 0;
        int n3 = constructorArray2.length;
        while (n2 < n3) {
            Constructor<?> constructor = constructorArray2[n2];
            ++n2;
            Intrinsics.checkNotNullExpressionValue(constructor, "constructor");
            Annotation[] annotationArray = memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor));
            if (annotationArray == null) continue;
            Annotation[] visitor2 = annotationArray;
            Annotation[] annotationArray2 = constructor.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray2, "constructor.declaredAnnotations");
            for (Annotation annotation : annotationArray2) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue(parameterAnnotations, "parameterAnnotations");
            if (!(((Object[])parameterAnnotations).length == 0)) {
                int shift = constructor.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                Annotation[][] annotationArray3 = parameterAnnotations;
                int n4 = 0;
                int n5 = ((Object[])annotationArray3).length;
                while (n4 < n5) {
                    int parameterIndex = n4;
                    Annotation[] annotations2 = annotationArray3[n4];
                    ++n4;
                    Intrinsics.checkNotNullExpressionValue(annotations2, "annotations");
                    for (Annotation annotation : annotations2) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                        Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor2 == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
                        boolean bl = false;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue(fieldArray, "klass.declaredFields");
        Field[] fieldArray2 = fieldArray;
        int n2 = 0;
        int n3 = fieldArray2.length;
        while (n2 < n3) {
            Field field = fieldArray2[n2];
            ++n2;
            Annotation[] annotationArray = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue(annotationArray, "identifier(field.name)");
            Intrinsics.checkNotNullExpressionValue(field, "field");
            Annotation[] annotationArray2 = memberVisitor.visitField((Name)annotationArray, SignatureSerializer.INSTANCE.fieldDesc(field), null);
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = field.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "field.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNullExpressionValue(annotation, "annotation");
                this.processAnnotation((KotlinJvmBinaryClass.AnnotationVisitor)visitor2, annotation);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
        if (annotationArgumentVisitor != null) {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2 = annotationArgumentVisitor;
            boolean bl = false;
            INSTANCE.processAnnotationArguments(it, annotation, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "annotationType.declaredMethods");
        for (Method method : methodArray) {
            Object object;
            try {
                Object object2 = method.invoke((Object)annotation, new Object[0]);
                Intrinsics.checkNotNull(object2);
                object = object2;
            }
            catch (IllegalAccessException e2) {
                continue;
            }
            Object value2 = object;
            object = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue(object, "identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, (Name)object, value2);
        }
        visitor2.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        Object object;
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            int n2 = dimensions;
            dimensions = n2 + 1;
            object = currentClass.getComponentType();
            Intrinsics.checkNotNullExpressionValue(object, "currentClass.componentType");
            currentClass = object;
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                object = ClassId.topLevel(StandardNames.FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue(object, "topLevel(StandardNames.FqNames.unit.toSafe())");
                return new ClassLiteralValue((ClassId)object, dimensions);
            }
            Object object2 = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue(object2, "get(currentClass.name).primitiveType");
            PrimitiveType primitiveType = object2;
            if (dimensions > 0) {
                object2 = ClassId.topLevel(primitiveType.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue(object2, "topLevel(primitiveType.arrayTypeFqName)");
                return new ClassLiteralValue((ClassId)object2, dimensions - 1);
            }
            object2 = ClassId.topLevel(primitiveType.getTypeFqName());
            Intrinsics.checkNotNullExpressionValue(object2, "topLevel(primitiveType.typeFqName)");
            return new ClassLiteralValue((ClassId)object2, dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(currentClass);
        FqName fqName2 = javaClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "javaClassId.asSingleFqName()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        ClassId kotlinClassId = classId == null ? javaClassId : classId;
        return new ClassLiteralValue(kotlinClassId, dimensions);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name2, Object value2) {
        Class<?> clazz = value2.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            visitor2.visitClassLiteral(name2, this.classLiteralValue((Class)value2));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name2, value2);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Object object = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNullExpressionValue(object, "if (clazz.isEnum) clazz else clazz.enclosingClass");
            ClassId classId = ReflectClassUtilKt.getClassId(object);
            object = Name.identifier(((Enum)value2).name());
            Intrinsics.checkNotNullExpressionValue(object, "identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name2, classId, (Name)object);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, "clazz.interfaces");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNullExpressionValue(annotationClass, "annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name2, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v2 = annotationArgumentVisitor;
            this.processAnnotationArguments(v2, (Annotation)value2, annotationClass);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v2 = visitor2.visitArray(name2);
            if (v2 == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v3 = v2;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNullExpressionValue(componentType, "componentType");
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                for (Object element : (Object[])value2) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name3 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue(name3, "identifier((element as Enum<*>).name)");
                    v3.visitEnum(enumClassId, name3);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                for (Object element : (Object[])value2) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    v3.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else if (Annotation.class.isAssignableFrom(componentType)) {
                for (Object element : (Object[])value2) {
                    Intrinsics.checkNotNullExpressionValue(componentType, "componentType");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = v3.visitAnnotation(ReflectClassUtilKt.getClassId(componentType));
                    if (annotationArgumentVisitor == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor vv = annotationArgumentVisitor;
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Annotation");
                    }
                    this.processAnnotationArguments(vv, (Annotation)element, componentType);
                }
            } else {
                for (Object element : (Object[])value2) {
                    v3.visit(element);
                }
            }
            v3.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value2);
        }
    }
}

