/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import org.ec4j.core.PropertyTypeRegistry;
import org.ec4j.core.model.Comments;
import org.ec4j.core.model.Version;
import org.ec4j.core.parser.EditorConfigModelHandler;
import org.ec4j.core.parser.ErrorHandler;
import org.ec4j.core.parser.Location;
import org.ec4j.core.parser.ParseContext;
import org.ec4j.core.parser.Span;

public class LocationAwareModelHandler
extends EditorConfigModelHandler {
    private Comments.CommentBlock.Builder commentBlockBuilder;
    private Comments.CommentBlocks.Builder commentBlocksBuilder;
    private Span.Builder commentSpan;
    private Span.Builder globSpan;
    private Span.Builder propertySpan;
    private Span.Builder propertyNameSpan;
    private Span.Builder propertyValueSpan;
    private Span.Builder sectionSpan;

    public LocationAwareModelHandler(PropertyTypeRegistry registry, Version version2, ErrorHandler errorHandler) {
        super(registry, version2);
    }

    @Override
    public void blankLine(ParseContext context2) {
        super.blankLine(context2);
        this.closeCommentBlockIfNeeded();
    }

    private void closeCommentBlockIfNeeded() {
        if (this.commentBlockBuilder != null) {
            this.commentBlockBuilder.closeCommentBlock();
            this.commentBlockBuilder = null;
        }
    }

    @Override
    public void endComment(ParseContext context2, String comment) {
        if (this.commentBlocksBuilder == null) {
            this.commentBlocksBuilder = Comments.CommentBlocks.builder();
        }
        if (this.commentBlockBuilder == null) {
            this.commentBlockBuilder = this.commentBlocksBuilder.openCommentBlock();
        }
        ((Comments.CommentLine.Builder)this.commentBlockBuilder.openCommentLine().adapter(this.commentSpan.end(context2.getLocation()).buildSpan())).text(comment).closeComment();
        this.commentSpan = null;
        super.endComment(context2, comment);
    }

    @Override
    public void endDocument(ParseContext context2) {
        if (this.commentBlocksBuilder != null) {
            this.closeCommentBlockIfNeeded();
            this.editorConfigBuilder.adapter(this.commentBlocksBuilder.build());
            this.commentBlocksBuilder = null;
        }
        super.endDocument(context2);
    }

    @Override
    public void endGlob(ParseContext context2, String glob) {
        Location loc = context2.getLocation();
        this.sectionBuilder.adapter(this.globSpan.end(loc).buildGlobSpan());
        this.globSpan = null;
        this.sectionSpan.end(loc);
        super.endGlob(context2, glob);
    }

    @Override
    public void endPropertyName(ParseContext context2, String name2) {
        this.propertyBuilder.adapter(this.propertyNameSpan.end(context2.getLocation()).buildNameSpan());
        this.propertyNameSpan = null;
        super.endPropertyName(context2, name2);
    }

    @Override
    public void endProperty(ParseContext context2) {
        this.propertyBuilder.adapter(this.propertySpan.end(context2.getLocation()).buildSpan());
        this.propertySpan = null;
        super.endProperty(context2);
    }

    @Override
    public void endPropertyValue(ParseContext context2, String value2) {
        Location loc = context2.getLocation();
        this.propertyBuilder.adapter(this.propertyValueSpan.end(loc).buildValueSpan());
        this.propertyValueSpan = null;
        this.sectionSpan.end(loc);
        super.endPropertyValue(context2, value2);
    }

    @Override
    public void endSection(ParseContext context2) {
        this.sectionBuilder.adapter(this.sectionSpan.endIfNeeded(context2.getLocation()).buildSpan());
        this.sectionSpan = null;
        super.endSection(context2);
    }

    @Override
    public void startComment(ParseContext context2) {
        super.startComment(context2);
        this.commentSpan = Span.builder().start(context2.getLocation());
    }

    @Override
    public void startDocument(ParseContext context2) {
        super.startDocument(context2);
        this.editorConfigBuilder.parentAware(true);
    }

    @Override
    public void startGlob(ParseContext context2) {
        super.startGlob(context2);
        this.globSpan = Span.builder().start(context2.getLocation());
    }

    @Override
    public void startProperty(ParseContext context2) {
        this.closeCommentBlockIfNeeded();
        super.startProperty(context2);
        this.propertySpan = Span.builder().start(context2.getLocation());
    }

    @Override
    public void startPropertyName(ParseContext context2) {
        super.startPropertyName(context2);
        this.propertyNameSpan = Span.builder().start(context2.getLocation());
    }

    @Override
    public void startPropertyValue(ParseContext context2) {
        super.startPropertyValue(context2);
        this.propertyValueSpan = Span.builder().start(context2.getLocation());
    }

    @Override
    public void startSection(ParseContext context2) {
        this.closeCommentBlockIfNeeded();
        super.startSection(context2);
        this.sectionSpan = Span.builder().start(context2.getLocation());
    }
}

