/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.WebCallableReferenceLowering;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullExternrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\f\u001a.\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0019\u001a\u00020\u001a*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"TYPE_INFO_FLAG_ANONYMOUS_CLASS", "", "TYPE_INFO_FLAG_LOCAL_CLASS", "generateDefaultInitializerForType", "", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "g", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getEffectiveValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isExported", "", "generateConstExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "body", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "locationTarget", "Lorg/jetbrains/kotlin/ir/IrElement;", "getLocationTarget", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/IrElement;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGeneratorKt\n+ 2 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n1#1,672:1\n315#2,4:673\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGeneratorKt\n*L\n653#1:673,4\n*E\n"})
public final class DeclarationGeneratorKt {
    public static final void generateDefaultInitializerForType(@NotNull WasmType type2, @NotNull WasmExpressionBuilder g2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(g2, "g");
        SourceLocation location = SourceLocation.Companion.NoLocation("Default initializer, usually don't require location");
        boolean bl = false;
        WasmType wasmType = type2;
        if (Intrinsics.areEqual(wasmType, WasmI32.INSTANCE)) {
            g2.buildConstI32(0, location);
        } else if (Intrinsics.areEqual(wasmType, WasmI64.INSTANCE)) {
            g2.buildConstI64(0L, location);
        } else if (Intrinsics.areEqual(wasmType, WasmF32.INSTANCE)) {
            g2.buildConstF32(0.0f, location);
        } else if (Intrinsics.areEqual(wasmType, WasmF64.INSTANCE)) {
            g2.buildConstF64(0.0, location);
        } else if (wasmType instanceof WasmRefNullType) {
            g2.buildRefNull(((WasmRefNullType)type2).getHeapType(), location);
        } else if (wasmType instanceof WasmRefNullrefType) {
            g2.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
        } else if (wasmType instanceof WasmRefNullExternrefType) {
            g2.buildRefNull(WasmHeapType.Simple.NoExtern.INSTANCE, location);
        } else if (wasmType instanceof WasmAnyRef) {
            g2.buildRefNull(WasmHeapType.Simple.Any.INSTANCE, location);
        } else if (wasmType instanceof WasmExternRef) {
            g2.buildRefNull(WasmHeapType.Simple.Extern.INSTANCE, location);
        } else {
            if (Intrinsics.areEqual(wasmType, WasmUnreachableType.INSTANCE)) {
                throw new IllegalStateException("Unreachable type can't be initialized".toString());
            }
            throw new IllegalStateException(("Unknown value type " + type2.getName()).toString());
        }
    }

    @NotNull
    public static final List<IrValueParameter> getEffectiveValueParameters(@NotNull IrFunction $this$getEffectiveValueParameters) {
        Intrinsics.checkNotNullParameter($this$getEffectiveValueParameters, "<this>");
        List result2 = new ArrayList();
        if ($this$getEffectiveValueParameters instanceof IrConstructor) {
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass($this$getEffectiveValueParameters).getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter);
            result2.add(irValueParameter);
        }
        result2.addAll((Collection)$this$getEffectiveValueParameters.getParameters());
        return result2;
    }

    public static final boolean isExported(@NotNull IrFunction $this$isExported) {
        Intrinsics.checkNotNullParameter($this$isExported, "<this>");
        return AnnotationUtilsKt.isJsExport($this$isExported) || AnnotationsKt.getWasmExportNameIfWasmExport($this$isExported) != null;
    }

    public static final void generateConstExpression(@NotNull IrConst expression2, @NotNull WasmExpressionBuilder body, @NotNull WasmFileCodegenContext context2, @NotNull WasmBackendContext backendContext, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(body, "body");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(location, "location");
        IrConstKind kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            IrClass irClass = IrTypesKt.getClass(expression2.getType());
            boolean isExternal = irClass != null ? irClass.isExternal() : IrTypeErasureUtilsKt.getErasedUpperBound(expression2.getType()).isExternal();
            WasmType bottomType = isExternal ? (WasmType)WasmRefNullExternrefType.INSTANCE : (WasmType)WasmRefNullrefType.INSTANCE;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(bottomType)};
            body.buildInstr(WasmOp.REF_NULL, location, wasmImmediateArray);
        } else if (kind instanceof IrConstKind.Boolean) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
            body.buildConstI32((Boolean)object != false ? 1 : 0, location);
        } else if (kind instanceof IrConstKind.Byte) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Byte");
            body.buildConstI32(((Byte)object).byteValue(), location);
        } else if (kind instanceof IrConstKind.Short) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Short");
            body.buildConstI32(((Short)object).shortValue(), location);
        } else if (kind instanceof IrConstKind.Int) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
            body.buildConstI32((Integer)object, location);
        } else if (kind instanceof IrConstKind.Long) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
            body.buildConstI64((Long)object, location);
        } else if (kind instanceof IrConstKind.Char) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
            body.buildConstI32(((Character)object).charValue(), location);
        } else if (kind instanceof IrConstKind.Float) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Float");
            body.buildConstF32(((Float)object).floatValue(), location);
        } else if (kind instanceof IrConstKind.Double) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Double");
            body.buildConstF64((Double)object, location);
        } else if (kind instanceof IrConstKind.String) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
            String stringValue = (String)object;
            Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair = context2.referenceStringLiteralAddressAndId(stringValue);
            WasmSymbol<Integer> literalAddress = pair.component1();
            WasmSymbol<Integer> literalPoolId = pair.component2();
            WasmExpressionBuilder this_$iv = body;
            boolean $i$f$commentGroupStart = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n2 = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string2 = string = "const string: \"" + stringValue + '\"';
                wasmImmediateArray2[n2] = new WasmImmediate.ConstString(string2);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            }
            body.buildConstI32Symbol(literalPoolId, location);
            body.buildConstI32Symbol(literalAddress, location);
            body.buildConstI32(stringValue.length(), location);
            body.buildCall(context2.referenceFunction(backendContext.getWasmSymbols().getStringGetLiteral()), location);
            body.commentGroupEnd();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public static final IrElement getLocationTarget(@NotNull IrFunction $this$locationTarget) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter($this$locationTarget, "<this>");
        IrDeclarationOrigin irDeclarationOrigin = $this$locationTarget.getOrigin();
        if (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
            irElement = $this$locationTarget;
        } else if (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA())) {
            irElement = $this$locationTarget;
        } else {
            IrElementBase irElementBase;
            IrDeclarationOrigin irDeclarationOrigin2;
            IrClass irClass = IrUtilsKt.getParentClassOrNull($this$locationTarget);
            IrDeclarationOrigin irDeclarationOrigin3 = irDeclarationOrigin2 = irClass != null ? irClass.getOrigin() : null;
            if (Intrinsics.areEqual(irDeclarationOrigin2, WebCallableReferenceLowering.Companion.getFUNCTION_REFERENCE_IMPL()) || Intrinsics.areEqual(irDeclarationOrigin2, IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA())) {
                irElementBase = $this$locationTarget;
            } else {
                IrBody irBody = $this$locationTarget.getBody();
                irElementBase = irBody != null ? (IrElementBase)irBody : (IrElementBase)$this$locationTarget;
            }
            irElement = irElementBase;
        }
        return irElement;
    }
}

