/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapperBase;
import org.jetbrains.kotlin.codegen.state.StaticTypeMapperForOldBackend;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import shadow.org.jetbrains.org.objectweb.asm.Label;
import shadow.org.jetbrains.org.objectweb.asm.Type;
import shadow.org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    @NotNull
    public final Type type;
    @Nullable
    public final KotlinType kotlinType;

    protected StackValue(@NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(0);
        }
        this.type = type2;
        this.kotlinType = kotlinType;
    }

    public abstract void put(@NotNull Type var1, @Nullable KotlinType var2, @NotNull InstructionAdapter var3);

    public void store(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(1);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    public static StackValue createDefaultValue(@NotNull Type type2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(3);
        }
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                return new Constant(null, type2);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new Constant(0, type2);
            }
            case 1: {
                return new Constant(false, type2);
            }
            case 7: {
                return new Constant(0L, type2);
            }
            case 6: {
                return new Constant(Float.valueOf(0.0f), type2);
            }
            case 8: {
                return new Constant(0.0, type2);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + type2));
    }

    private static void box(Type type2, Type toType, InstructionAdapter v2) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v2.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v2.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v2);
    }

    private static void unbox(Type methodOwner, Type type2, InstructionAdapter v2) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v2.invokevirtual(methodOwner.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    private static void boxInlineClass(@NotNull KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v2, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(4);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(5);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(6);
        }
        Type boxed = typeMapper2.mapTypeCommon(kotlinType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(kotlinType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.boxInlineClass(unboxed, boxed, isNullable, v2);
    }

    public static void boxInlineClass(@NotNull Type unboxed, @NotNull Type boxed, boolean isNullable, @NotNull InstructionAdapter v2) {
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(7);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(8);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(9);
        }
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v2, vv -> StackValue.invokeBoxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeBoxMethod(v2, boxed, unboxed);
        }
    }

    private static void invokeBoxMethod(@NotNull InstructionAdapter v2, @NotNull Type boxedType, @NotNull Type underlyingType) {
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(10);
        }
        if (boxedType == null) {
            StackValue.$$$reportNull$$$0(11);
        }
        if (underlyingType == null) {
            StackValue.$$$reportNull$$$0(12);
        }
        v2.invokestatic(boxedType.getInternalName(), KotlinTypeMapper.BOX_JVM_METHOD_NAME, Type.getMethodDescriptor(boxedType, underlyingType), false);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull KotlinTypeMarker targetInlineClassType, @NotNull InstructionAdapter v2, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(13);
        }
        if (targetInlineClassType == null) {
            StackValue.$$$reportNull$$$0(14);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(15);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(16);
        }
        Type boxed = typeMapper2.mapTypeCommon(targetInlineClassType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(targetInlineClassType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(targetInlineClassType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.unboxInlineClass(type2, boxed, unboxed, isNullable, v2);
    }

    public static void unboxInlineClass(@NotNull Type type2, @NotNull Type boxed, @NotNull Type unboxed, boolean isNullable, @NotNull InstructionAdapter v2) {
        if (type2 == null) {
            StackValue.$$$reportNull$$$0(17);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(18);
        }
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(19);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(20);
        }
        StackValue.coerce(type2, boxed, v2);
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v2, vv -> StackValue.invokeUnboxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeUnboxMethod(v2, boxed, unboxed);
        }
    }

    private static void invokeUnboxMethod(@NotNull InstructionAdapter v2, @NotNull Type owner, @NotNull Type resultType) {
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(21);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(22);
        }
        if (resultType == null) {
            StackValue.$$$reportNull$$$0(23);
        }
        v2.invokevirtual(owner.getInternalName(), KotlinTypeMapper.UNBOX_JVM_METHOD_NAME, "()" + resultType.getDescriptor(), false);
    }

    private static void boxOrUnboxWithNullCheck(@NotNull InstructionAdapter v2, @NotNull Consumer<InstructionAdapter> body) {
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(24);
        }
        if (body == null) {
            StackValue.$$$reportNull$$$0(25);
        }
        Label lNull = new Label();
        Label lDone = new Label();
        v2.dup();
        v2.ifnull(lNull);
        body.accept(v2);
        v2.goTo(lDone);
        v2.mark(lNull);
        v2.pop();
        v2.aconst(null);
        v2.mark(lDone);
    }

    protected void coerceTo(@NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v2) {
        if (toType == null) {
            StackValue.$$$reportNull$$$0(26);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(27);
        }
        StackValue.coerce(this.type, this.kotlinType, toType, toKotlinType, v2);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
        if (topOfStackType == null) {
            StackValue.$$$reportNull$$$0(28);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(29);
        }
        StackValue.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v2);
    }

    public static void coerce(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(30);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(31);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(32);
        }
        if (StackValue.coerceInlineClasses(fromType, fromKotlinType, toType, toKotlinType, v2, StaticTypeMapperForOldBackend.INSTANCE)) {
            return;
        }
        StackValue.coerce(fromType, toType, v2);
    }

    public static boolean requiresInlineClassBoxingOrUnboxing(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType) {
        boolean isToTypeUnboxed;
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(33);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(34);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        boolean isFromTypeUnboxed = isFromTypeInlineClass && StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
        boolean bl = isToTypeUnboxed = isToTypeInlineClass && StackValue.isUnboxedInlineClass(toKotlinType, toType);
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            return isFromTypeUnboxed != isToTypeUnboxed;
        }
        return isFromTypeInlineClass && isFromTypeUnboxed || isToTypeInlineClass && isToTypeUnboxed;
    }

    private static boolean coerceInlineClasses(@NotNull Type fromType, @Nullable KotlinType fromKotlinType, @NotNull Type toType, @Nullable KotlinType toKotlinType, @NotNull InstructionAdapter v2, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(35);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(36);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(37);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(38);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        boolean isFromTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(fromKotlinType);
        boolean isToTypeInlineClass = InlineClassesUtilsKt.isInlineClassType(toKotlinType);
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        if (fromKotlinType.equals(toKotlinType) && fromType.equals(toType)) {
            return true;
        }
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            boolean isFromTypeUnboxed = StackValue.isUnboxedInlineClass(fromKotlinType, fromType);
            boolean isToTypeUnboxed = StackValue.isUnboxedInlineClass(toKotlinType, toType);
            if (isFromTypeUnboxed && !isToTypeUnboxed) {
                StackValue.boxInlineClass(fromKotlinType, v2, typeMapper2);
                return true;
            }
            if (!isFromTypeUnboxed && isToTypeUnboxed) {
                StackValue.unboxInlineClass(fromType, toKotlinType, v2, typeMapper2);
                return true;
            }
        } else if (isFromTypeInlineClass) {
            if (StackValue.isUnboxedInlineClass(fromKotlinType, fromType)) {
                StackValue.boxInlineClass(fromKotlinType, v2, typeMapper2);
                return true;
            }
        } else if (StackValue.isUnboxedInlineClass(toKotlinType, toType)) {
            StackValue.unboxInlineClass(fromType, toKotlinType, v2, typeMapper2);
            return true;
        }
        return false;
    }

    private static boolean isUnboxedInlineClass(@NotNull KotlinType kotlinType, @NotNull Type actualType) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(39);
        }
        if (actualType == null) {
            StackValue.$$$reportNull$$$0(40);
        }
        return KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, StaticTypeMapperForOldBackend.INSTANCE).equals(actualType);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(41);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(42);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(43);
        }
        StackValue.coerce(fromType, toType, v2, false);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v2, boolean forceSelfCast) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(44);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(45);
        }
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(46);
        }
        if (toType.equals(fromType) && !forceSelfCast) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v2, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v2);
            } else {
                AsmUtil.pushDefaultValueOnStack(toType, v2);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v2.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v2, fromType);
                StackValue.putUnitInstance(v2);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() != 9) {
                v2.checkcast(toType);
            } else if (toType.getDimensions() != fromType.getDimensions()) {
                v2.checkcast(toType);
            } else if (!toType.getElementType().equals(AsmTypes.OBJECT_TYPE)) {
                v2.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v2.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v2);
            }
        } else if (fromType.getSort() == 10 || fromType.getSort() == 9) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v2);
                StackValue.coerce(unboxedType, toType, v2);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v2);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v2);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v2);
                    v2.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v2);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v2);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v2);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v2);
            }
        } else {
            v2.cast(fromType, toType);
        }
    }

    private static void putUnitInstance(@NotNull InstructionAdapter v2) {
        if (v2 == null) {
            StackValue.$$$reportNull$$$0(47);
        }
        v2.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 43: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 4: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 6: 
            case 16: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxed";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxed";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInlineClassType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 26: 
            case 31: 
            case 34: 
            case 36: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStackType";
                break;
            }
            case 30: 
            case 33: 
            case 35: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "store";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "boxInlineClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeBoxMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "unboxInlineClass";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeUnboxMethod";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "boxOrUnboxWithNullCheck";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "coerceTo";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "coerceFrom";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "coerce";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "requiresInlineClassBoxingOrUnboxing";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "coerceInlineClasses";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnboxedInlineClass";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "putUnitInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Field
    extends StackValue {
        public final Type owner;
        public final String name;
        @NotNull
        public final StackValue receiver;

        public Field(@NotNull Type type2, @NotNull Type owner, @NotNull String name2, @NotNull StackValue receiver) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                Field.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                Field.$$$reportNull$$$0(3);
            }
            super(type2, null);
            this.owner = owner;
            this.name = name2;
            this.receiver = receiver;
        }

        @Override
        public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (type2 == null) {
                Field.$$$reportNull$$$0(4);
            }
            if (v2 == null) {
                Field.$$$reportNull$$$0(5);
            }
            this.receiver.put(this.receiver.type, this.receiver.kotlinType, v2);
            v2.visitFieldInsn(180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void store(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            if (topOfStackType == null) {
                Field.$$$reportNull$$$0(6);
            }
            if (v2 == null) {
                Field.$$$reportNull$$$0(7);
            }
            this.receiver.put(this.receiver.type, this.receiver.kotlinType, v2);
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.visitFieldInsn(181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Field";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value2, Type type2) {
            super(type2, null);
            this.value = value2;
        }

        @Override
        public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (type2 == null) {
                Constant.$$$reportNull$$$0(0);
            }
            if (v2 == null) {
                Constant.$$$reportNull$$$0(1);
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v2.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v2.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v2.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v2.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v2.dconst((Double)this.value);
            } else {
                v2.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, kotlinType, v2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Constant";
            objectArray[2] = "put";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2, KotlinType kotlinType) {
            super(type2, kotlinType);
            if (type2 == Type.VOID_TYPE) {
                throw new IllegalArgumentException("Cannot create OnStack with void type");
            }
        }

        @Override
        public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (type2 == null) {
                OnStack.$$$reportNull$$$0(0);
            }
            if (v2 == null) {
                OnStack.$$$reportNull$$$0(1);
            }
            this.coerceTo(type2, kotlinType, v2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$OnStack";
            objectArray[2] = "put";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        public Local(int index, Type type2, KotlinType kotlinType) {
            super(type2, kotlinType);
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            this.index = index;
        }

        @Override
        public void put(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
            if (type2 == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (v2 == null) {
                Local.$$$reportNull$$$0(1);
            }
            v2.load(this.index, this.type);
            this.coerceTo(type2, kotlinType, v2);
        }

        @Override
        public void store(@NotNull Type topOfStackType, @Nullable KotlinType topOfStackKotlinType, @NotNull InstructionAdapter v2) {
            if (topOfStackType == null) {
                Local.$$$reportNull$$$0(2);
            }
            if (v2 == null) {
                Local.$$$reportNull$$$0(3);
            }
            this.coerceFrom(topOfStackType, topOfStackKotlinType, v2);
            v2.store(this.index, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Local";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

