/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.ConstraintType;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.ThreadLocalTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypesDistinctProver;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.MathUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.kotlin.one.util.streamex.AbstractStreamEx;
import org.jetbrains.kotlin.one.util.streamex.StreamEx;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance(InferenceSession.class);
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = pair -> GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
    static final Key<PsiCapturedWildcardType> ORIGINAL_CAPTURE = Key.create("ORIGINAL_CAPTURE");
    protected final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private final InferenceSessionContainer myInferenceSessionContainer;
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx;
    private List<@Nls String> myErrorMessages;
    private boolean myErased;
    public final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private final ParameterTypeInferencePolicy myPolicy;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myRestoreNameSubstitution = PsiSubstitutor.EMPTY;
    private MethodCandidateInfo myCurrentMethod;
    private ThreadLocalTypes myTempTypes;

    public InferenceSession(InitialInferenceState initialState, ParameterTypeInferencePolicy policy) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<InferenceVariable[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((InferenceVariable[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
        this.myErased = initialState.isErased();
        this.myPolicy = policy;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context2) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context2;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i2 = 0; i2 < leftTypes.length; ++i2) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i2]);
            PsiType t2 = this.substituteWithInferenceVariables(leftTypes[i2]);
            PsiType s2 = this.substituteWithInferenceVariables(rightType);
            if (t2 == null || s2 == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(t2, s2));
        }
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
        this.myInferenceSessionContainer = new InferenceSessionContainer();
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context2) {
        this(typeParams, siteSubstitutor, manager, context2, DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context2, ParameterTypeInferencePolicy policy) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context2;
        this.myPolicy = policy;
        this.initBounds(typeParams);
        this.myInferenceSessionContainer = new InferenceSessionContainer();
    }

    public MethodCandidateInfo getCurrentMethod(PsiExpressionList argumentList) {
        return this.myCurrentMethod != null && this.myCurrentMethod.isOnArgumentList(argumentList) ? this.myCurrentMethod : null;
    }

    public void setCurrentMethod(MethodCandidateInfo currentMethod) {
        this.myCurrentMethod = currentMethod;
    }

    @NotNull
    public ParameterTypeInferencePolicy getInferencePolicy() {
        ParameterTypeInferencePolicy parameterTypeInferencePolicy = this.myPolicy;
        if (parameterTypeInferencePolicy == null) {
            InferenceSession.$$$reportNull$$$0(0);
        }
        return parameterTypeInferencePolicy;
    }

    public static PsiType createTypeParameterTypeWithUpperBound(@NotNull PsiType upperBound, @NotNull PsiElement place) {
        if (upperBound == null) {
            InferenceSession.$$$reportNull$$$0(1);
        }
        if (place == null) {
            InferenceSession.$$$reportNull$$$0(2);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(place.getProject());
        PsiTypeParameter parameter = elementFactory.createTypeParameterFromText("T", place);
        TypeConversionUtil.setInferredBoundsForSynthetic(parameter, null, upperBound);
        return elementFactory.createType(parameter);
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod method, boolean varargs) {
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters2.length > 0) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!varargs && i2 >= parameters2.length || args[i2] == null || !InferenceSession.isPertinentToApplicability(args[i2], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters2, i2, this.mySiteSubstitutor, varargs);
                if (method != null && PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor)) {
                    parameterType = TypeConversionUtil.erasure(parameterType);
                }
                LOG.assertTrue(parameterType != null);
                if (InferenceSession.ignoreLambdaConstraintTree(args[i2])) continue;
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i2], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables(thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    static PsiExpressionList getArgumentList(PsiElement parent2) {
        if (parent2 instanceof PsiCall) {
            return ((PsiCall)parent2).getArgumentList();
        }
        if (parent2 instanceof PsiAnonymousClass) {
            return InferenceSession.getArgumentList(parent2.getParent());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expr.getParent());
            PsiType paramType = null;
            if (parent2 instanceof PsiExpressionList) {
                PsiElement gParent = parent2.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters2;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent2, expr);
                    if (idx > (parameters2 = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters2[parameters2.length - 1].getType();
                        paramType = parameters2[parameters2.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters2[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class) != null)) {
                if (InferenceSession.isTypeParameterType(method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression2 : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (InferenceSession.isPertinentToApplicability(expression2, method, LambdaUtil.getFunctionalInterfaceReturnType(paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        if (method == null) {
            InferenceSession.$$$reportNull$$$0(3);
        }
        PsiNameIdentifierOwner owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondType.hasDiamond((PsiNewExpression)gParent)) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        if (paramType instanceof PsiWildcardType) {
            return InferenceSession.isTypeParameterType(method, ((PsiWildcardType)paramType).getBound());
        }
        PsiClass psiClass = PsiUtil.resolveClassInType(paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters2, int i2, @Nullable PsiSubstitutor substitutor2, boolean varargs) {
        if (substitutor2 == null || !varargs && i2 >= parameters2.length) {
            return null;
        }
        return substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i2, varargs));
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null, null);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(4);
        }
        return psiSubstitutor;
    }

    PsiSubstitutor collectAdditionalAndInfer(PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] args, @NotNull MethodCandidateInfo properties2, @NotNull PsiSubstitutor psiSubstitutor) {
        if (properties2 == null) {
            InferenceSession.$$$reportNull$$$0(5);
        }
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(6);
        }
        if (parameters2 == null) {
            InferenceSession.$$$reportNull$$$0(7);
        }
        if (args == null) {
            InferenceSession.$$$reportNull$$$0(8);
        }
        return this.performGuardedInference(parameters2, args, this.myContext, properties2, psiSubstitutor, false);
    }

    @NotNull
    public PsiSubstitutor infer(PsiParameter @Nullable [] parameters2, PsiExpression @Nullable [] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo currentMethod) {
        PsiSubstitutor psiSubstitutor = this.performGuardedInference(parameters2, args, parent2, currentMethod, PsiSubstitutor.EMPTY, false);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(9);
        }
        return psiSubstitutor;
    }

    @NotNull
    PsiSubstitutor performGuardedInference(PsiParameter @Nullable [] parameters2, PsiExpression @Nullable [] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo currentMethod, @NotNull PsiSubstitutor initialSubstitutor, boolean prohibitCaching) {
        if (initialSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(10);
        }
        if (!prohibitCaching) {
            prohibitCaching = MethodCandidateInfo.isOverloadCheck() || !(parent2 instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)parent2).getMethodExpression().multiResolve(false).length != 1;
        }
        PsiSubstitutor psiSubstitutor = ThreadLocalTypes.performWithTypes(types2 -> {
            this.myTempTypes = types2;
            try {
                this.doInfer(parameters2, args, parent2, currentMethod, initialSubstitutor);
                PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                return psiSubstitutor;
            }
            finally {
                if (currentMethod != null) {
                    if (this.myErrorMessages != null) {
                        currentMethod.setApplicabilityError(StringUtil.join(this.myErrorMessages, "\n"));
                    }
                    if (this.myErased) {
                        currentMethod.setErased();
                    }
                }
                this.myTempTypes = null;
            }
        }, prohibitCaching);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(11);
        }
        return psiSubstitutor;
    }

    private void doInfer(PsiParameter @Nullable [] parameters2, PsiExpression @Nullable [] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo properties2, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(12);
        }
        if (!this.repeatInferencePhases()) {
            return;
        }
        PsiExpressionList argumentList = InferenceSession.getArgumentList(parent2);
        if (properties2 != null && argumentList != null && !MethodCandidateInfo.isOverloadCheck(argumentList)) {
            PsiMethod method = properties2.getElement();
            if (parent2 instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)parent2, method)) {
                PsiType returnType = method.getReturnType();
                if (!PsiTypes.voidType().equals(returnType) && returnType != null) {
                    Ref<String> errorMessage2 = new Ref<String>();
                    PsiType targetType = InferenceSession.getTargetTypeFromParent(parent2, errorMessage2, false);
                    if (targetType == null && errorMessage2.get() != null) {
                        return;
                    }
                    if (targetType != null && !PsiTypes.voidType().equals(targetType)) {
                        PsiType actualType = PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType);
                        this.registerReturnTypeConstraints(actualType, targetType, this.myContext);
                    }
                }
            }
            if (!this.repeatInferencePhases()) {
                if (InferenceSession.isPertinentToApplicabilityCheckOnContainingCall(parent2)) {
                    return;
                }
            } else if (parameters2 != null && parameters2.length > 0 && args != null && !InferenceSession.isPertinentToApplicabilityCheckOnContainingCall(parent2)) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                HashSet<ConstraintFormula> ignoredConstraints = new HashSet<ConstraintFormula>();
                this.collectAdditionalConstraints(parameters2, args, method, this.mySiteSubstitutor, additionalConstraints, ignoredConstraints, properties2.isVarargs(), initialSubstitutor);
                this.proceedWithAdditionalConstraints(additionalConstraints, ignoredConstraints);
            }
        }
        this.resolveBounds(this.myInferenceVariables, initialSubstitutor);
    }

    private static boolean isPertinentToApplicabilityCheckOnContainingCall(@NotNull PsiElement parent2) {
        if (parent2 == null) {
            InferenceSession.$$$reportNull$$$0(13);
        }
        return ThreadLocalTypes.hasBindingFor(parent2);
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiSubstitutor nestedSubstitutor;
            PsiType parameterType;
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown(args[i2]);
            if (arg == null || (parameterType = (nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor(arg, this.myInferenceSubstitution)).substitute(InferenceSession.getParameterType(parameters2, i2, siteSubstitutor, varargs))) == null) continue;
            ExpressionCompatibilityConstraint compatibilityConstraint = new ExpressionCompatibilityConstraint(arg, parameterType);
            if (arg instanceof PsiFunctionalExpression && InferenceSession.ignoreLambdaConstraintTree(arg) || this.dependsOnIgnoredConstraint(ignoredConstraints, compatibilityConstraint)) {
                ignoredConstraints.add(compatibilityConstraint);
                continue;
            }
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                additionalConstraints.add(compatibilityConstraint);
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCallExpression) {
                PsiMethod calledMethod;
                JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult((PsiCallExpression)arg);
                PsiMethod psiMethod = calledMethod = resolveResult instanceof MethodCandidateInfo ? (PsiMethod)resolveResult.getElement() : null;
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCallExpression)arg, initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)arg, ((PsiLambdaExpression)arg).getGroundTargetType(parameterType), !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    private boolean dependsOnIgnoredConstraint(Set<ConstraintFormula> ignoredConstraints, ExpressionCompatibilityConstraint compatibilityConstraint) {
        Set<InferenceVariable> inputVariables;
        if (!ignoredConstraints.isEmpty() && (inputVariables = compatibilityConstraint.getInputVariables(this)) != null) {
            for (ConstraintFormula ignoredConstraint : ignoredConstraints) {
                Set<InferenceVariable> inputsOfIgnored;
                Set<InferenceVariable> outputVariables;
                if (!(ignoredConstraint instanceof InputOutputConstraintFormula) || (outputVariables = ((InputOutputConstraintFormula)ignoredConstraint).getOutputVariables(inputsOfIgnored = ((InputOutputConstraintFormula)ignoredConstraint).getInputVariables(this), this)) == null || !ContainerUtil.intersects(outputVariables, inputVariables)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean ignoreLambdaConstraintTree(PsiExpression arg) {
        for (PsiElement expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
            if (PsiTreeUtil.getParentOfType(expr, PsiFunctionalExpression.class, false) != arg) continue;
            return true;
        }
        return false;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint2, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(parameterType);
        if (!(interfaceReturnType == null || PsiTypes.voidType().equals(interfaceReturnType) && addConstraint2)) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, returnExpression, interfaceReturnType, addConstraint2, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiExpression returnExpression, @NotNull PsiType functionalType, boolean addConstraint2, PsiSubstitutor initialSubstitutor) {
        if (functionalType == null) {
            InferenceSession.$$$reportNull$$$0(14);
        }
        if (returnExpression instanceof PsiCallExpression) {
            if (addConstraint2) {
                JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult((PsiCallExpression)returnExpression);
                if (resolveResult instanceof MethodCandidateInfo && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, ((MethodCandidateInfo)resolveResult).getElement())) {
                    this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCallExpression)returnExpression, initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType, addConstraint2, initialSubstitutor);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType, addConstraint2, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType, addConstraint2, initialSubstitutor);
        } else if (returnExpression instanceof PsiSwitchExpression) {
            for (PsiExpression resultExpression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)returnExpression)) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, resultExpression, functionalType, addConstraint2, initialSubstitutor);
            }
        } else if (returnExpression instanceof PsiLambdaExpression && !InferenceSession.ignoreLambdaConstraintTree(returnExpression)) {
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)returnExpression, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(callExpression);
            PsiMethod psiMethod = method = result2 instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result2).getElement() : null;
            if (method != null) {
                PsiExpression[] newArgs2 = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs2, method, InferenceSession.chooseSiteSubstitutor(null, result2, method), additionalConstraints, ignoredConstraints, InferenceSession.chooseVarargsMode(null, result2), initialSubstitutor);
                }
            }
        }
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo currentMethod, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (currentMethod != null ? currentMethod.getSiteSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo currentMethod, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || currentMethod != null && currentMethod.isVarargs();
    }

    PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables2) {
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables2) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor2);
            if (equalsBound == null || PsiTypes.nullType().equals(equalsBound)) continue;
            substitutor2 = substitutor2.put(variable.getParameter(), equalsBound);
        }
        return substitutor2;
    }

    protected PsiSubstitutor prepareSubstitution() {
        boolean foundErrorMessage = false;
        Iterator<List<InferenceVariable>> iterator2 = InferenceVariablesOrder.resolveOrderIterator(this.myInferenceVariables, this);
        while (iterator2.hasNext()) {
            List<InferenceVariable> variables2 = iterator2.next();
            for (InferenceVariable inferenceVariable : variables2) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiTypes.nullType()) continue;
                if (!foundErrorMessage) {
                    foundErrorMessage = this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable) == PsiTypes.nullType();
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getElementFactory(this.myManager.getProject()).createType(typeParameter));
            }
        }
        return this.mySiteSubstitutor;
    }

    InitialInferenceState createInitialState(InferenceSessionContainer container, Collection<InitialInferenceState.VariableInfo> variables2, PsiSubstitutor topInferenceSubstitutor) {
        return new InitialInferenceState(variables2, topInferenceSubstitutor, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myErased, container);
    }

    private void initBounds(PsiTypeParameter ... typeParameters2) {
        this.initBounds(this.myContext, typeParameters2);
    }

    public InferenceVariable[] initBounds(PsiElement context2, PsiTypeParameter ... typeParameters2) {
        return this.initBounds(context2, this.mySiteSubstitutor, typeParameters2);
    }

    public InferenceVariable[] initOrReuseVariables(PsiElement context2, PsiTypeParameter ... typeParameters2) {
        if (typeParameters2 == null) {
            InferenceSession.$$$reportNull$$$0(15);
        }
        if (typeParameters2.length == 0) {
            return new InferenceVariable[0];
        }
        Map<PsiTypeParameter, PsiType> map2 = this.myInferenceSubstitution.getSubstitutionMap();
        InferenceVariable[] variables2 = ((StreamEx)((AbstractStreamEx)StreamEx.of(typeParameters2).map(map2::get)).map(PsiUtil::resolveClassInClassTypeOnly)).select(InferenceVariable.class).toArray(new InferenceVariable[0]);
        if (variables2.length != 0) {
            if (variables2.length != typeParameters2.length) {
                LOG.error("Unexpected: either all vars or no vars should be present");
            }
            return variables2;
        }
        return this.initBounds(context2, this.mySiteSubstitutor, typeParameters2);
    }

    public InferenceVariable[] initBounds(PsiElement context2, PsiSubstitutor siteSubstitutor, PsiTypeParameter ... typeParameters2) {
        if (typeParameters2 == null) {
            InferenceSession.$$$reportNull$$$0(16);
        }
        ArrayList<InferenceVariable> result2 = new ArrayList<InferenceVariable>(typeParameters2.length);
        for (PsiTypeParameter parameter : typeParameters2) {
            String name2 = parameter.getName();
            if (this.myContext != null) {
                name2 = name2 + MathUtil.nonNegativeAbs(this.myContext.hashCode());
            }
            InferenceVariable variable = new InferenceVariable(context2, parameter, name2);
            result2.add(variable);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.myManager.getProject());
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, elementFactory.createType(variable));
            this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.put(variable, elementFactory.createType(parameter));
            this.myInferenceVariables.add(variable);
        }
        for (InferenceVariable variable : result2) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.substituteWithInferenceVariables(siteSubstitutor.substitute(classType)))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER, null);
            }
            if (added) continue;
            variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER, null);
        }
        return result2.toArray(new InferenceVariable[0]);
    }

    public void registerReturnTypeConstraints(PsiType returnType, @NotNull PsiType targetType, PsiElement context2) {
        if (targetType == null) {
            InferenceSession.$$$reportNull$$$0(17);
        }
        returnType = this.substituteWithInferenceVariables(returnType);
        if (this.myErased) {
            PsiSubstitutor currentSubstitutor = this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(targetType, TypeConversionUtil.erasure(currentSubstitutor.substitute(returnType))));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards(returnType, context2);
                PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
                PsiType[] parameters2 = substitutedCapture.getParameters();
                InferenceVariable[] copy2 = this.initFreshVariablesForCapturedBounds(typeParameters2, parameters2);
                PsiType[] newParameters = new PsiType[parameters2.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.myManager.getProject());
                int idx = 0;
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    newParameters[i2] = parameters2[i2];
                    if (!(parameters2[i2] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i2] = elementFactory.createType(copy2[idx++]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy2, (PsiClassType)returnType);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
            if (inferenceVariable != null) {
                PsiSubstitutor substitutor2 = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
                PsiType substitutedReturnType = substitutor2.substitute(inferenceVariable);
                if (substitutedReturnType != null) {
                    this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards(substitutedReturnType, context2)));
                }
            } else {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, returnType));
            }
        }
    }

    private InferenceVariable[] initFreshVariablesForCapturedBounds(PsiTypeParameter[] typeParameters2, PsiType[] parameters2) {
        if (Registry.is("javac.fresh.variables.for.captured.wildcards.only")) {
            ArrayList<PsiTypeParameter> capturedParams = new ArrayList<PsiTypeParameter>();
            PsiSubstitutor restParamSubstitution = PsiSubstitutor.EMPTY;
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiType parameter = parameters2[i2];
                if (parameter instanceof PsiCapturedWildcardType) {
                    capturedParams.add(typeParameters2[i2]);
                    continue;
                }
                restParamSubstitution = restParamSubstitution.put(typeParameters2[i2], parameter);
            }
            InferenceVariable[] variables2 = this.initBounds(null, restParamSubstitution, capturedParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
            int idx = 0;
            for (PsiType parameter : parameters2) {
                if (!(parameter instanceof PsiCapturedWildcardType)) continue;
                InferenceVariable variable = variables2[idx++];
                if (!this.isProperType(((PsiCapturedWildcardType)parameter).getWildcard())) continue;
                variable.putUserData(ORIGINAL_CAPTURE, (PsiCapturedWildcardType)parameter);
            }
            return variables2;
        }
        return this.initBounds((PsiElement)null, typeParameters2);
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType, this) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType, InferenceSession session) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound, session)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = pair -> pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)pair.first, (PsiType)pair.second)) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context2) {
        PsiType targetType = InferenceSession.getTargetTypeFromParent(context2, new Ref<String>(), true);
        if (targetType instanceof PsiClassType) {
            return ((PsiClassType)targetType).setLanguageLevel(PsiUtil.getLanguageLevel(context2));
        }
        return targetType;
    }

    public static PsiType getTargetTypeByParent(PsiElement context2) {
        PsiType targetType = InferenceSession.getTargetTypeFromParent(context2, new Ref<String>(), false);
        if (targetType instanceof PsiClassType) {
            return ((PsiClassType)targetType).setLanguageLevel(PsiUtil.getLanguageLevel(context2));
        }
        return targetType;
    }

    private static PsiType getTargetTypeFromParent(PsiElement context2, Ref<String> errorMessage2, boolean inferParent) {
        PsiSwitchExpression switchExpression;
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context2);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(context2.getParent());
        if (parent2 instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent2.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList = ((PsiCall)gParent).getArgumentList()) != null) {
                if (MethodCandidateInfo.isOverloadCheck(argumentList)) {
                    return ThreadLocalTypes.getElementType(context2);
                }
                JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)gParent);
                PsiElement element = result2.getElement();
                if (element == null) {
                    errorMessage2.set("Overload resolution failed");
                    return null;
                }
                if (element instanceof PsiMethod && (inferParent || !((PsiMethod)element).hasTypeParameters())) {
                    boolean varargs = result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isVarargs();
                    return PsiTypesUtil.getTypeByMethod(context2, argumentList, result2.getElement(), varargs, result2.getSubstitutor(), inferParent);
                }
            }
        } else {
            if (parent2 instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent2, errorMessage2, inferParent);
            }
            if (parent2 instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent2, errorMessage2, inferParent);
            }
            if (parent2 instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda(PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class), errorMessage2, inferParent);
            }
        }
        if ((switchExpression = PsiTreeUtil.getParentOfType(parent2, PsiSwitchExpression.class)) != null && PsiUtil.getSwitchResultExpressions(switchExpression).contains(context2)) {
            return InferenceSession.getTargetTypeFromParent(switchExpression, errorMessage2, inferParent);
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, Ref<String> errorMessage2, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent(lambdaExpression, errorMessage2, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getGroundTargetType(typeTypeByParentCall));
            }
            PsiType cachedLambdaType = ThreadLocalTypes.getElementType(lambdaExpression);
            if (cachedLambdaType != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getGroundTargetType(cachedLambdaType));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        return psiClass instanceof InferenceVariable ? this.getInferenceVariable((PsiTypeParameter)psiClass) : null;
    }

    public boolean isProperType(@Nullable PsiType type2) {
        return this.collectDependencies(type2, null);
    }

    public boolean collectDependencies(@Nullable PsiType type2, @Nullable Set<? super InferenceVariable> dependencies) {
        return InferenceSession.collectDependencies(type2, dependencies, this::getInferenceVariable);
    }

    public static boolean collectDependencies(@Nullable PsiType type2, final @Nullable Set<? super InferenceVariable> dependencies, final Function<? super PsiClassType, ? extends InferenceVariable> fun) {
        if (type2 == null) {
            return true;
        }
        Boolean isProper = type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public Boolean visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                if (capturedWildcardType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            @Override
            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return arrayType.getComponentType().accept(this);
            }

            @Override
            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound;
                if (wildcardType == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((bound = wildcardType.getBound()) == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            public Boolean visitClassType(@NotNull PsiClassType classType) {
                InferenceVariable inferenceVariable;
                if (classType == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((inferenceVariable = (InferenceVariable)fun.fun(classType)) != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
                PsiClass aClass = result2.getElement();
                if (aClass != null) {
                    PsiSubstitutor substitutor2 = result2.getSubstitutor();
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                        PsiType psiType = substitutor2.substitute(typeParameter);
                        if (psiType == null || psiType.accept(this).booleanValue()) continue;
                        return false;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "capturedWildcardType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCapturedWildcardType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList newConstraints = new ArrayList();
        for (int i2 = this.myConstraintIdx; i2 < this.myConstraints.size(); ++i2) {
            ConstraintFormula constraint = this.myConstraints.get(i2);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds2) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds2) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor2) {
        LinkedHashSet dependencies = new LinkedHashSet();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiTypes.nullType()) continue;
            substitutor2 = substitutor2.put(dependency, instantiation);
        }
        return substitutor2.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor2) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            PsiClass aClass;
            PsiType type2;
            if (typeParameter.getInstantiation() != PsiTypes.nullType() || typeParameter.getUserData(ORIGINAL_CAPTURE) != null || (type2 = substitutor2.substitute(typeParameter)) instanceof PsiClassType && (aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass) || GenericsUtil.findTypeParameterBoundError(typeParameter, bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(PsiType.EMPTY_ARRAY), substitutor2, this.myContext, true) == null) continue;
            return true;
        }
        return false;
    }

    protected void resolveBounds(Collection<InferenceVariable> inferenceVariables, @NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            InferenceSession.$$$reportNull$$$0(18);
        }
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        Map<InferenceVariable, Set<InferenceVariable>> dependencies = InferenceVariablesOrder.getDependencies(allVars, this);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, dependencies);
            List<InferenceVariable> unresolved = new ArrayList<InferenceVariable>();
            for (InferenceVariable var : vars) {
                PsiType eqBound = this.getEqualsBound(var, substitutor2);
                if (eqBound != PsiTypes.nullType()) continue;
                unresolved.add(var);
            }
            if (!unresolved.isEmpty() && vars.size() > unresolved.size()) {
                vars.removeAll(unresolved);
                vars.addAll(unresolved);
            }
            if (!this.myIncorporationPhase.hasCaptureConstraints(unresolved)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor2);
                if (this.myErrorMessages == null && this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                    unresolved = vars;
                }
                if (firstSubstitutor != null) {
                    substitutor2 = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor2, unresolved, uniqueNameGenerator)) {
                return;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases()) continue;
            return;
        }
        Map<PsiTypeParameter, PsiType> map2 = substitutor2.getSubstitutionMap();
        for (PsiTypeParameter parameter : map2.keySet()) {
            PsiTypeParameter param;
            PsiType mapping = map2.get(parameter);
            if (parameter instanceof InferenceVariable) {
                ((InferenceVariable)parameter).setInstantiation(mapping);
                if (((InferenceVariable)parameter).getCallContext() != this.myContext) continue;
                param = ((InferenceVariable)parameter).getParameter();
            } else {
                param = parameter;
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping);
        }
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor2, List<InferenceVariable> vars, UniqueNameGenerator nameGenerator2) {
        int i2;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (i2 = 0; i2 < vars.size(); ++i2) {
            InferenceVariable var = vars.get(i2);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i2] = elementFactory.createTypeParameterFromText(nameGenerator2.generateUniqueName(parameter.getName()), parameter);
            ySubstitutor = ySubstitutor.put(var, elementFactory.createType(yVars[i2]));
        }
        for (i2 = 0; i2 < yVars.length; ++i2) {
            PsiType lowerBound;
            PsiTypeParameter parameter = yVars[i2];
            InferenceVariable var = vars.get(i2);
            PsiType upperBound = this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor2), true);
            PsiType lub = this.getLowerBound(var, substitutor2);
            if (lub != PsiTypes.nullType()) {
                for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable(upperBoundType, lub)) continue;
                    return false;
                }
                lowerBound = lub;
            } else {
                lowerBound = this.myPolicy.inferLowerBoundForFreshVariables() ? upperBound : null;
            }
            TypeConversionUtil.setInferredBoundsForSynthetic(parameter, lowerBound, upperBound);
            TypeConversionUtil.markAsFreshVariable(parameter, this.myContext);
            if (var.addBound(elementFactory.createType(parameter), InferenceBound.EQ, this.myIncorporationPhase)) continue;
            return false;
        }
        return true;
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor2 = siteSubstitutor;
        Iterator<List<InferenceVariable>> varsIterator = InferenceVariablesOrder.resolveOrderIterator(varsToResolve, this);
        while (varsIterator.hasNext()) {
            List<InferenceVariable> vars = varsIterator.next();
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor2);
            substitutor2 = substitutor2.putAll(resolveSubset);
        }
        return substitutor2;
    }

    @NotNull
    protected final PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor2) {
        if (this.myErased) {
            for (InferenceVariable var : vars) {
                substitutor2 = substitutor2.put(var, null);
            }
        }
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type2 = instantiation == PsiTypes.nullType() ? this.checkBoundsConsistency(substitutor2, var) : instantiation;
            if (type2 == PsiTypes.nullType()) continue;
            substitutor2 = substitutor2.put(var, type2);
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(19);
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor2, InferenceVariable var) {
        PsiType type2;
        PsiType eqBound = this.getEqualsBound(var, substitutor2);
        if (eqBound != PsiTypes.nullType() && eqBound instanceof PsiPrimitiveType) {
            return PsiTypes.nullType();
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor2);
        if (eqBound == PsiTypes.nullType()) {
            lowerBound = this.myPolicy.adjustInferredType(this.myManager, lowerBound, ConstraintType.SUBTYPE);
        }
        PsiType upperBound = this.getUpperBound(var, substitutor2);
        if (eqBound != PsiTypes.nullType() && (this.myErased || eqBound != null)) {
            PsiCapturedWildcardType capturedWildcard;
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(eqBound);
            if (aClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass) && (capturedWildcard = var.getUserData(ORIGINAL_CAPTURE)) != null && capturedWildcard.getUpperBound().equals(TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)aClass))) {
                eqBound = capturedWildcard;
            }
            if (this.isLowerBoundNotAssignable(var, eqBound, true)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.EQ, "equality constraints", InferenceBound.LOWER, "lower bounds");
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiTypes.nullType();
            }
            type2 = eqBound;
            if (this.isLowerBoundNotAssignable(var, eqBound, false)) {
                this.setErased();
            }
        } else {
            type2 = lowerBound;
        }
        if (type2 == PsiTypes.nullType()) {
            if (var.isThrownBound() && this.myPolicy.inferRuntimeExceptionForThrownBoundWithNoConstraints() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type2 = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
            } else {
                PsiType psiType = type2 = var.getBounds(InferenceBound.UPPER).size() == 1 ? (PsiType)this.myPolicy.getInferredTypeWithNoConstraint((PsiManager)this.myManager, (PsiType)upperBound).first : upperBound;
            }
            if (this.myErrorMessages == null && type2 instanceof PsiIntersectionType) {
                String conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage();
                if (conflictingConjunctsMessage == null) {
                    conflictingConjunctsMessage = InferenceSession.findParameterizationOfTheSameGenericClass(var.getBounds(InferenceBound.UPPER), pair -> pair.first == null || pair.second == null || Comparing.equal(this.substituteNonProperBound((PsiType)pair.first, substitutor2), this.substituteNonProperBound((PsiType)pair.second, substitutor2))) != null ? type2.getPresentableText(false) : InferenceSession.getConjunctsConflict((PsiIntersectionType)type2);
                }
                if (conflictingConjunctsMessage != null) {
                    this.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.type.parameter.has.incompatible.upper.bounds", var.getParameter().getName(), conflictingConjunctsMessage));
                    return PsiTypes.nullType();
                }
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (this.myErrorMessages != null || !this.isProperType(upperType)) continue;
                if (type2 != lowerBound && !TypeConversionUtil.isAssignable(upperType, type2)) {
                    this.registerIncompatibleErrorMessage(this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.EQ, "equality constraints", InferenceBound.UPPER, "upper bounds"));
                    return PsiTypes.nullType();
                }
                if (type2 != lowerBound) continue;
                for (PsiType lowerBoundConjunct : var.getBounds(InferenceBound.LOWER)) {
                    if (!this.isProperType(lowerBoundConjunct) || TypeConversionUtil.isAssignable(upperType, lowerBoundConjunct)) continue;
                    this.registerIncompatibleErrorMessage(this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.LOWER, "lower bounds", InferenceBound.UPPER, "upper bounds"));
                    return PsiTypes.nullType();
                }
            }
        }
        if (type2 == PsiTypes.nullType()) {
            this.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.upper.bounds", StringUtil.join(var.getBounds(InferenceBound.UPPER), bound -> {
                PsiType substituted = this.substituteNonProperBound((PsiType)bound, substitutor2);
                return this.getPresentableText(substituted != null ? substituted : bound);
            }, ", ")));
        }
        return type2;
    }

    private boolean isLowerBoundNotAssignable(InferenceVariable var, PsiType eqBound, boolean allowUncheckedConversion) {
        return var.getBounds(InferenceBound.LOWER).stream().anyMatch(lBound -> this.isProperType((PsiType)lBound) && !TypeConversionUtil.isAssignable(eqBound, lBound, allowUncheckedConversion));
    }

    @Nls
    private static String getConjunctsConflict(PsiIntersectionType type2) {
        PsiType[] conjuncts = type2.getConjuncts();
        for (int i2 = 0; i2 < conjuncts.length; ++i2) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i2]);
            for (int i1 = 0; i1 < conjuncts.length; ++i1) {
                if (i2 == i1) continue;
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i1]);
                if (conjunct != null && oppositeConjunct != null || (!(conjuncts[i2] instanceof PsiArrayType) || !TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)conjuncts[i2], conjuncts[i1])) && (!(conjuncts[i2] instanceof PsiCapturedWildcardType) || oppositeConjunct == null || oppositeConjunct.isInterface() || oppositeConjunct instanceof PsiTypeParameter || ((PsiCapturedWildcardType)conjuncts[i2]).getWildcard().isSuper() && TypeConversionUtil.isAssignable(conjuncts[i1], ((PsiCapturedWildcardType)conjuncts[i2]).getLowerBound()))) continue;
                return JavaPsiBundle.message("conflicting.conjuncts", conjuncts[i2].getPresentableText(), conjuncts[i1].getPresentableText());
            }
        }
        return null;
    }

    public String getPresentableText(PsiType psiType) {
        PsiType substituted = this.myRestoreNameSubstitution.substitute(psiType);
        return substituted != null ? substituted.getPresentableText() : null;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables2, @Nls String incompatibleTypesMessage) {
        variables2 = new ArrayList<InferenceVariable>(variables2);
        ((ArrayList)variables2).sort((v1, v2) -> Comparing.compare(v1.getName(), v2.getName()));
        String variablesEnumeration = StringUtil.join(variables2, variable -> variable.getParameter().getName(), ", ");
        if (variablesEnumeration.isEmpty()) {
            this.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.type.variable", incompatibleTypesMessage));
        } else {
            this.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.type.variable.0", variablesEnumeration, incompatibleTypesMessage));
        }
    }

    public void registerIncompatibleErrorMessage(@NotNull @Nls String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            InferenceSession.$$$reportNull$$$0(20);
        }
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    @Nls
    private String incompatibleBoundsMessage(InferenceVariable var, PsiSubstitutor substitutor2, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = type2 -> {
            PsiType substituted = this.substituteNonProperBound((PsiType)type2, substitutor2);
            return this.getPresentableText(substituted != null ? substituted : type2);
        };
        return JavaPsiBundle.message("error.inference.variable.has.incompatible.bounds", var.getParameter().getName(), lowBoundName, StringUtil.join(var.getBounds(lowBound), typePresentation, ", "), upperBoundName, StringUtil.join(var.getBounds(upperBound), typePresentation, ", "));
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.LOWER, pair -> GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, this.myManager), substitutor2);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor2);
    }

    private PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.EQ, pair -> !Comparing.equal((PsiType)pair.first, (PsiType)pair.second) ? null : (PsiType)pair.first, substitutor2);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<? super Pair<PsiType, PsiType>, ? extends PsiType> fun, PsiSubstitutor substitutor2) {
        return this.composeBound(variable, boundType, fun, substitutor2, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<? super Pair<PsiType, PsiType>, ? extends PsiType> fun, PsiSubstitutor substitutor2, boolean includeNonProperBounds) {
        List<PsiType> bounds = variable.getBounds(boundType);
        PsiType lub = PsiTypes.nullType();
        for (PsiType bound : bounds) {
            bound = this.substituteNonProperBound(bound, substitutor2);
            if (!includeNonProperBounds && !this.isProperType(bound)) continue;
            if (lub == PsiTypes.nullType()) {
                lub = bound;
                continue;
            }
            Pair<PsiType, PsiType> pair = Pair.create(lub, bound);
            if ((lub = fun.fun(pair)) != null) continue;
            return PsiTypes.nullType();
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        if (this.myContext != null) {
            return this.myContext.getResolveScope();
        }
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            if (constraint instanceof ExpressionCompatibilityConstraint && InferenceSession.ignoreLambdaConstraintTree(((ExpressionCompatibilityConstraint)constraint).getExpression())) {
                LOG.error("Should have been stopped at lambda under overload guard");
            }
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, ignoredConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            PsiSubstitutor substitutor2 = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, additionalConstraints, substitutor2, ignoredConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<? super InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, Set<ConstraintFormula> additionalConstraints, PsiSubstitutor substitutor2, Set<ConstraintFormula> ignoredConstraints) {
        PsiExpression expression2;
        formula.apply(substitutor2, true);
        if (formula instanceof InputOutputConstraintFormula) {
            this.myTempTypes.forceType(((InputOutputConstraintFormula)formula).getExpression(), ((InputOutputConstraintFormula)formula).getCurrentType());
        }
        this.addConstraint(formula);
        if (!this.repeatInferencePhases()) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression2 = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = ((PsiLambdaExpression)expression2).getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getCurrentType());
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)expression2, parameterType, !this.isProperType(parameterType), substitutor2);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        Set<InferenceVariable> outputVariables = this.getOutputVariables(additionalConstraints);
        Set<InferenceVariable> ignoredOutputVariables = this.getOutputVariables(ignoredConstraints);
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            if (this.dependsOnOutput(ignoredOutputVariables, dependencies)) {
                                dependsOnOutput = true;
                                ignoredConstraints.add(constraint);
                                break;
                            }
                            dependsOnOutput = this.dependsOnOutput(outputVariables, dependencies);
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            additionalConstraints.removeAll(ignoredConstraints);
            if (!additionalConstraints.isEmpty()) {
                subset.add(additionalConstraints.iterator().next());
            }
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    private boolean dependsOnOutput(Set<InferenceVariable> outputVariables, Set<InferenceVariable> dependencies) {
        for (InferenceVariable outputVariable : outputVariables) {
            if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<InferenceVariable> getOutputVariables(Set<ConstraintFormula> constraintFormulas) {
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : constraintFormulas) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        HashSet<InferenceVariable> hashSet = outputVariables;
        if (hashSet == null) {
            InferenceSession.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference2, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block12: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters2;
            PsiParameter[] functionalMethodParameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature2;
            block11: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                LOG.assertTrue(interfaceMethod != null, this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                signature2 = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference2);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters2 = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters2.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block11;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null && (psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference2.getResolveScope(), psiSubstitutor)) == null) {
                    LOG.error("derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference2.getText() + "; containingFile: " + reference2.getContainingFile().getName());
                }
                for (int i2 = 0; i2 < functionalMethodParameters.length; ++i2) {
                    PsiType pType = signature2.getParameterTypes()[i2];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i2, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(pType, functionalMethodParameters[i2])));
                }
                break block12;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch(reference2, signature2, varargs, isStatic, parameters2.length)) break block12;
            PsiType pType = signature2.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                PsiSubstitutor receiverSubstitutor;
                PsiClassType subclassType = StrictSubtypingConstraint.getSubclassType(containingClass, pType, true);
                PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = subclassType != null ? TypeConversionUtil.getSuperClassSubstitutor(containingClass, (PsiClassType)PsiUtil.captureToplevelWildcards(subclassType, this.myContext)) : null;
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature2.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor(containingClass, receiverSubstitutor))) {
                        return methodContainingClass != null ? JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference2.getResolveScope(), receiverSubstitutor) : receiverSubstitutor;
                    }
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                    if (methodContainingClass != null) {
                        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference2.getResolveScope(), receiverSubstitutor);
                        LOG.assertTrue(superSubstitutor != null, "mContainingClass: " + methodContainingClass.getName() + "; containingClass: " + containingClass.getName());
                        this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(superSubstitutor);
                    }
                    psiSubstitutor = receiverSubstitutor;
                }
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.myManager.getProject());
            if (PsiUtil.isArrayClass(containingClass)) {
                return null;
            }
            PsiClassType qType = factory.createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(qType), PsiUtil.captureToplevelWildcards(pType, reference2)));
            if (methodContainingClass != null) {
                psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference2.getResolveScope(), psiSubstitutor);
                LOG.assertTrue(psiSubstitutor != null, "derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference2.getText() + "; containingFile: " + reference2.getContainingFile().getName());
            }
            for (int i3 = 0; i3 < signature2.getParameterTypes().length - 1; ++i3) {
                PsiType interfaceParamType = signature2.getParameterTypes()[i3 + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i3, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(interfaceParamType, functionalMethodParameters[i3])));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    private InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context2, boolean varargs) {
        return LambdaUtil.performWithSubstitutedParameterBounds(m1.getTypeParameters(), siteSubstitutor1, () -> InferenceSession.isMoreSpecificInternal(m1, m2, siteSubstitutor1, args, context2, varargs));
    }

    private static boolean isMoreSpecificInternal(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context2, boolean varargs) {
        InferenceSession session = new InferenceSession(m2.getTypeParameters(), siteSubstitutor1, m2.getManager(), context2);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i2 = 0; i2 < paramsLength; ++i2) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i2, siteSubstitutor1, varargs);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i2, siteSubstitutor1, varargs));
            if (PsiUtil.isRawSubstitutor(m2, siteSubstitutor1)) {
                tType = TypeConversionUtil.erasure(tType);
            }
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i2])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable(tType, sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases();
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    private static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiTypes.voidType().equals(tReturnType)) {
                return true;
            }
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(PsiExpression.EMPTY_ARRAY))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            if (sParameters.length != (tParameters = tInterfaceMethod.getParameterList().getParameters()).length) {
                LOG.error("s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText());
            }
            for (int i2 = 0; i2 < tParameters.length; ++i2) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i2].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i2].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal(tSubstituted, sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiTypes.voidType().equals(tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiSwitchExpression) {
            return PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)arg).stream().allMatch(resultExpression -> InferenceSession.argConstraints(resultExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor));
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<? super InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public final void propagateVariables(@NotNull InferenceSession from2) {
        if (from2 == null) {
            InferenceSession.$$$reportNull$$$0(22);
        }
        this.myInferenceVariables.addAll(from2.getInferenceVariables());
        this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.putAll(from2.getRestoreNameSubstitution());
    }

    public PsiType substituteWithInferenceVariables(@Nullable PsiType type2) {
        return this.myInferenceSubstitution.substitute(type2);
    }

    public PsiSubstitutor getInferenceSubstitution() {
        return this.myInferenceSubstitution;
    }

    public PsiSubstitutor getRestoreNameSubstitution() {
        return this.myRestoreNameSubstitution;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type2) {
        PsiSubstitutor s2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s2 = s2.put(variable, JavaPsiFacade.getElementFactory(this.myManager.getProject()).createType(variable.getParameter()));
        }
        return s2.substitute(type2);
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<? extends PsiType> upperBounds2, Processor<? super Pair<PsiType, PsiType>> processor) {
        for (int i2 = 0; i2 < upperBounds2.size(); ++i2) {
            PsiType sBound = upperBounds2.get(i2);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly(sBound);
            if (sClass == null) continue;
            LinkedHashSet<PsiClass> superClasses = InheritanceUtil.getSuperClasses(sClass);
            superClasses.add(sClass);
            for (int j2 = i2 + 1; j2 < upperBounds2.size(); ++j2) {
                PsiType tBound = upperBounds2.get(j2);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly(tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = new LinkedHashSet<PsiClass>();
                tSupers.add(tClass);
                tSupers.addAll(InheritanceUtil.getSuperClasses(tClass));
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)sBound);
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)tBound);
                    boolean found = false;
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substituteWithBoundsPromotion(typeParameter);
                        Pair<PsiType, PsiType> typePair = Pair.create(sType, tType = tSubstitutor.substituteWithBoundsPromotion(typeParameter));
                        if (processor.process(typePair)) continue;
                        found = true;
                    }
                    if (!found) continue;
                    return gClass;
                }
            }
        }
        return null;
    }

    public List<@Nls String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }

    public boolean isErased() {
        return this.myErased;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSubstitutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSubstitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalType";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibleBoundsMessage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferencePolicy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "infer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performGuardedInference";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSubset";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTypeParameterTypeWithUpperBound";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterOwner";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalAndInfer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performGuardedInference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doInfer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPertinentToApplicabilityCheckOnContainingCall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processReturnExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initOrReuseVariables";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initBounds";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerReturnTypeConstraints";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveBounds";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerIncompatibleErrorMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "propagateVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

