/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.AbstractIntToIntBtree;
import org.jetbrains.kotlin.com.intellij.util.io.CorruptedException;
import org.jetbrains.kotlin.com.intellij.util.io.DirectBufferWrapper;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.stats.BTreeStatistics;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public final class IntToIntBtree
extends AbstractIntToIntBtree {
    private static final boolean CACHE_ROOT_NODE_BUFFER = SystemProperties.getBooleanProperty("idea.btree.cache.root.node.buffer", true);
    final int pageSize;
    private final short maxInteriorNodes;
    private final short maxLeafNodes;
    private final short maxLeafNodesInHash;
    final BtreeRootNode root;
    private int height;
    private int maxStepsSearchedInHash;
    private int totalHashStepsSearched;
    private int hashSearchRequests;
    private int pagesCount;
    private int hashedPagesCount;
    private int count;
    private int movedMembersCount;
    private boolean hasZeroKey;
    private int zeroKeyValue;
    private final ResizeableMappedFile storage;
    private final int metaDataLeafPageLength;
    private final int hashPageCapacity;
    private BtreeIndexNodeView myAccessNodeView;
    private int myLastGetKey;
    private int myOptimizedInserts;
    private boolean myCanUseLastKey;

    public IntToIntBtree(int pageSize, @NotNull Path file, @NotNull StorageLockContext storageLockContext, boolean initial) throws IOException {
        if (file == null) {
            IntToIntBtree.$$$reportNull$$$0(0);
        }
        if (storageLockContext == null) {
            IntToIntBtree.$$$reportNull$$$0(1);
        }
        this.pageSize = pageSize;
        if (initial) {
            Files.deleteIfExists(file);
        }
        this.storage = new ResizeableMappedFile(file, pageSize, storageLockContext, SystemProperties.getIntProperty("idea.IntToIntBtree.page.size", 0x100000), true, IOUtil.useNativeByteOrderForByteBuffers());
        this.storage.setRoundFactor(pageSize);
        this.root = new BtreeRootNode();
        if (initial) {
            this.root.setAddress(-1);
        }
        int i2 = (this.pageSize - 8) / 8 - 1;
        assert (i2 < Short.MAX_VALUE && i2 % 2 == 0);
        this.maxInteriorNodes = (short)i2;
        this.maxLeafNodes = (short)i2;
        ++i2;
        while (!IntToIntBtree.isPrime(i2)) {
            i2 -= 2;
        }
        this.hashPageCapacity = i2;
        int metaPageLen = 8;
        i2 = (int)((double)this.hashPageCapacity * 0.9);
        if ((i2 & 1) == 1) {
            ++i2;
        }
        this.metaDataLeafPageLength = metaPageLen;
        assert (i2 > 0 && i2 % 2 == 0);
        this.maxLeafNodesInHash = (short)i2;
    }

    private void doAllocateRoot() throws IOException {
        this.nextPage();
        this.root.setAddress(0);
        this.root.getNodeView().setIndexLeaf(true);
    }

    public void persistVars(@NotNull AbstractIntToIntBtree.BtreeDataStorage storage2, boolean toDisk) throws IOException {
        if (storage2 == null) {
            IntToIntBtree.$$$reportNull$$$0(2);
        }
        int i2 = storage2.persistInt(0, this.height | (this.hasZeroKey ? -16777216 : 0), toDisk);
        this.hasZeroKey = (i2 & 0xFF000000) != 0;
        this.height = i2 & 0xFFFFFF;
        this.pagesCount = storage2.persistInt(4, this.pagesCount, toDisk);
        this.movedMembersCount = storage2.persistInt(8, this.movedMembersCount, toDisk);
        this.maxStepsSearchedInHash = storage2.persistInt(12, this.maxStepsSearchedInHash, toDisk);
        this.count = storage2.persistInt(16, this.count, toDisk);
        this.hashSearchRequests = storage2.persistInt(20, this.hashSearchRequests, toDisk);
        this.totalHashStepsSearched = storage2.persistInt(24, this.totalHashStepsSearched, toDisk);
        this.hashedPagesCount = storage2.persistInt(28, this.hashedPagesCount, toDisk);
        this.root.setAddress(storage2.persistInt(32, this.root.address, toDisk));
        this.zeroKeyValue = storage2.persistInt(36, this.zeroKeyValue, toDisk);
    }

    private static boolean isPrime(int val) {
        if (val % 2 == 0) {
            return false;
        }
        int maxDivisor = (int)Math.sqrt(val);
        for (int i2 = 3; i2 <= maxDivisor; i2 += 2) {
            if (val % i2 != 0) continue;
            return false;
        }
        return true;
    }

    private int nextPage() throws IOException {
        int pageStart = (int)this.storage.length();
        this.storage.putInt(pageStart + this.pageSize - 4, 0);
        ++this.pagesCount;
        return pageStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(int key, int @NotNull [] result2) throws IOException {
        if (result2 == null) {
            IntToIntBtree.$$$reportNull$$$0(3);
        }
        assert (result2.length > 0) : "result.length must be >0";
        if (key == 0) {
            if (this.hasZeroKey) {
                result2[0] = this.zeroKeyValue;
                return true;
            }
            return false;
        }
        if (this.root.address == -1) {
            return false;
        }
        DirectBufferWrapper root = this.initAccessNodeView();
        try {
            int index = this.myAccessNodeView.locate(key, false);
            if (index < 0) {
                this.myCanUseLastKey = true;
                this.myLastGetKey = key;
                boolean bl = false;
                return bl;
            }
            this.myCanUseLastKey = false;
            result2[0] = this.myAccessNodeView.addressAt(index);
        }
        finally {
            this.myAccessNodeView.disposeBuffer();
            if (root != null) {
                root.unlock();
            }
        }
        return true;
    }

    private DirectBufferWrapper initAccessNodeView() throws IOException {
        DirectBufferWrapper wrapper;
        int rootAddress = this.root.address;
        if (CACHE_ROOT_NODE_BUFFER) {
            BtreeIndexNodeView node = this.root.getNodeView();
            node.lockBuffer();
            wrapper = node.bufferWrapper;
        } else {
            wrapper = null;
        }
        if (this.myAccessNodeView == null) {
            this.myAccessNodeView = new BtreeIndexNodeView(rootAddress, true, wrapper);
        } else {
            this.myAccessNodeView.initTraversal(rootAddress, wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int key, int value2) throws IOException {
        if (key == 0) {
            this.hasZeroKey = true;
            this.zeroKeyValue = value2;
            return;
        }
        boolean canUseLastKey = this.myCanUseLastKey;
        if (canUseLastKey) {
            this.myCanUseLastKey = false;
            if (key == this.myLastGetKey && !this.myAccessNodeView.myHasFullPagesAlongPath) {
                ++this.myOptimizedInserts;
                ++this.count;
                try {
                    this.myAccessNodeView.insert(key, value2);
                }
                finally {
                    this.myAccessNodeView.disposeBuffer();
                }
                return;
            }
        }
        this.doPut(key, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(int key, int value2) throws IOException {
        if (this.root.address == -1) {
            this.doAllocateRoot();
        }
        DirectBufferWrapper root = this.initAccessNodeView();
        try {
            int index = this.myAccessNodeView.locate(key, true);
            if (index < 0) {
                ++this.count;
                this.myAccessNodeView.insert(key, value2);
            } else {
                this.myAccessNodeView.setAddressAt(index, value2);
            }
        }
        finally {
            this.myAccessNodeView.disposeBuffer();
            if (root != null) {
                root.unlock();
            }
        }
    }

    @NotNull
    public BTreeStatistics getStatistics() throws IOException {
        int leafPages = this.height == 3 ? this.pagesCount - (1 + this.root.getNodeView().getChildrenCount() + 1) : (this.height == 2 ? this.pagesCount - 1 : 1);
        return new BTreeStatistics(this.pagesCount, this.count, this.height, this.movedMembersCount, leafPages, this.maxStepsSearchedInHash, this.hashSearchRequests, this.totalHashStepsSearched, this.pageSize, this.storage.length());
    }

    public void doClose() throws IOException {
        this.storage.close();
    }

    public void doFlush() throws IOException {
        this.storage.force();
    }

    public boolean processMappings(@NotNull AbstractIntToIntBtree.KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtree.$$$reportNull$$$0(4);
        }
        this.doFlush();
        if (this.hasZeroKey && !processor.process(0, this.zeroKeyValue)) {
            return false;
        }
        if (this.root.address == -1) {
            return true;
        }
        this.root.syncWithStore();
        return this.processLeafPages(this.root.getNodeView(), processor);
    }

    private boolean processLeafPages(@NotNull BtreeIndexNodeView node, @NotNull AbstractIntToIntBtree.KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtree.$$$reportNull$$$0(5);
        }
        if (node == null) {
            IntToIntBtree.$$$reportNull$$$0(6);
        }
        if (node.isIndexLeaf()) {
            return node.processMappings(processor);
        }
        int[] childrenAddresses = new int[node.getChildrenCount() + 1];
        for (int i2 = 0; i2 < childrenAddresses.length; ++i2) {
            childrenAddresses[i2] = -node.addressAt(i2);
        }
        if (childrenAddresses.length > 0) {
            try (BtreeIndexNodeView child = new BtreeIndexNodeView(true);){
                for (int childrenAddress : childrenAddresses) {
                    child.setAddress(childrenAddress);
                    if (this.processLeafPages(child, processor)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/IntToIntBtree";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "persistVars";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processMappings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processLeafPages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class BtreeRootNode {
        int address;
        final BtreeIndexNodeView nodeView;
        boolean initialized;

        private BtreeRootNode() {
            this.nodeView = new BtreeIndexNodeView(false);
        }

        void setAddress(int _address) {
            this.address = _address;
            this.initialized = false;
        }

        void syncWithStore() throws IOException {
            this.nodeView.setAddress(this.address);
            this.initialized = true;
        }

        BtreeIndexNodeView getNodeView() throws IOException {
            if (!this.initialized) {
                this.syncWithStore();
            }
            return this.nodeView;
        }
    }

    private final class BtreeIndexNodeView
    implements Closeable {
        private boolean isIndexLeaf;
        private boolean isHashedLeaf;
        private int address = -1;
        private int addressInBuffer;
        private short myChildrenCount = (short)-1;
        private DirectBufferWrapper bufferWrapper;
        private boolean isSharedBuffer;
        private boolean myHasFullPagesAlongPath;
        private final boolean cacheBuffer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFlag(int mask, boolean flag) throws IOException {
            mask <<= 24;
            this.lockBuffer();
            try {
                int anInt = this.bufferWrapper.getInt(this.addressInBuffer);
                anInt = flag ? (anInt |= mask) : (anInt &= ~mask);
                this.bufferWrapper.putInt(this.addressInBuffer, anInt);
            }
            finally {
                this.unlockBuffer();
            }
        }

        BtreeIndexNodeView(boolean cacheBuffer) {
            this.cacheBuffer = cacheBuffer;
        }

        BtreeIndexNodeView(int address, boolean cacheBuffer, DirectBufferWrapper sharedBuffer) throws IOException {
            this.cacheBuffer = cacheBuffer;
            this.initTraversal(address, sharedBuffer);
        }

        private short getChildrenCount() {
            return this.myChildrenCount;
        }

        private void setChildrenCount(short value2) throws IOException {
            this.myChildrenCount = value2;
            this.lockBuffer();
            try {
                int myValue = this.bufferWrapper.getInt(this.addressInBuffer);
                myValue &= 0xFF000000;
                this.bufferWrapper.putInt(this.addressInBuffer, myValue |= value2 << 8);
            }
            finally {
                this.unlockBuffer();
            }
        }

        private void setNextPage(int nextPage) throws IOException {
            this.putInt(4, nextPage);
        }

        private int getNextPage() throws IOException {
            this.lockBuffer();
            try {
                int n2 = this.getInt(4);
                return n2;
            }
            finally {
                this.unlockBuffer();
            }
        }

        private int getInt(int address) throws IOException {
            this.lockBuffer();
            try {
                int n2 = this.bufferWrapper.getInt(this.addressInBuffer + address);
                return n2;
            }
            finally {
                this.unlockBuffer();
            }
        }

        private void putInt(int offset, int value2) throws IOException {
            this.lockBuffer();
            try {
                this.bufferWrapper.putInt(this.addressInBuffer + offset, value2);
            }
            finally {
                this.unlockBuffer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer getBytes(int address, int length) throws IOException {
            this.lockBuffer();
            try {
                ByteBuffer duplicate = this.bufferWrapper.copy();
                int newPosition = address + this.addressInBuffer;
                duplicate.position(newPosition);
                duplicate.limit(newPosition + length);
                ByteBuffer byteBuffer = duplicate;
                return byteBuffer;
            }
            finally {
                this.unlockBuffer();
            }
        }

        private void putBytes(int address, ByteBuffer buffer) throws IOException {
            this.lockBuffer();
            try {
                this.bufferWrapper.position(address + this.addressInBuffer);
                this.bufferWrapper.put(buffer);
            }
            finally {
                this.unlockBuffer();
            }
        }

        void setAddress(int _address) throws IOException {
            this.setAddress(_address, null);
        }

        void setAddress(int _address, DirectBufferWrapper sharedBuffer) throws IOException {
            this.address = _address;
            this.addressInBuffer = this.getStorage().getOffsetInPage(this.address);
            this.disposeBuffer();
            if (sharedBuffer != null) {
                this.bufferWrapper = sharedBuffer;
                this.isSharedBuffer = true;
            }
            this.syncWithStore();
        }

        private void syncWithStore() throws IOException {
            this.lockBuffer();
            try {
                this.doInitFlags(this.bufferWrapper.getInt(this.addressInBuffer));
            }
            finally {
                this.unlockBuffer();
            }
        }

        private void lockBuffer() throws IOException {
            if (this.isSharedBuffer) {
                return;
            }
            if (this.bufferWrapper == null) {
                this.bufferWrapper = this.getStorage().getByteBuffer(this.address, false);
            } else if (!this.cacheBuffer && !this.bufferWrapper.tryLock()) {
                this.bufferWrapper = this.getStorage().getByteBuffer(this.address, false);
            }
        }

        private void unlockBuffer() {
            if (this.isSharedBuffer) {
                return;
            }
            if (!this.cacheBuffer) {
                this.bufferWrapper.unlock();
            }
        }

        private void disposeBuffer() {
            if (this.bufferWrapper != null && this.cacheBuffer) {
                if (this.isSharedBuffer) {
                    this.isSharedBuffer = false;
                } else {
                    this.bufferWrapper.unlock();
                }
            }
            this.bufferWrapper = null;
        }

        @NotNull
        private PagedFileStorage getStorage() {
            PagedFileStorage pagedFileStorage = IntToIntBtree.this.storage.getPagedFileStorage();
            if (pagedFileStorage == null) {
                BtreeIndexNodeView.$$$reportNull$$$0(0);
            }
            return pagedFileStorage;
        }

        private int search(int value2) throws IOException {
            if (this.isIndexLeaf() && this.isHashedLeaf()) {
                return this.hashIndex(value2);
            }
            return ObjectUtils.binarySearch(0, this.getChildrenCount(), mid -> Integer.compare(this.keyAt(mid), value2));
        }

        int addressAt(int i2) throws IOException {
            return this.getInt(this.indexToOffset(i2));
        }

        private void setAddressAt(int i2, int value2) throws IOException {
            int offset = this.indexToOffset(i2);
            this.putInt(offset, value2);
        }

        private int indexToOffset(int i2) {
            return i2 * 8 + (this.isHashedLeaf() ? IntToIntBtree.this.metaDataLeafPageLength : 8);
        }

        private int keyAt(int i2) {
            try {
                return this.getInt(this.indexToOffset(i2) + 4);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        private void setKeyAt(int i2, int value2) throws IOException {
            int offset = this.indexToOffset(i2) + 4;
            this.putInt(offset, value2);
        }

        boolean isIndexLeaf() {
            return this.isIndexLeaf;
        }

        private void doInitFlags(int flags) {
            this.myChildrenCount = (short)(flags >>> 8 & 0xFFFF);
            flags = flags >> 24 & 0xFF;
            this.isHashedLeaf = BitUtil.isSet(flags, 2);
            this.isIndexLeaf = BitUtil.isSet(flags, 1);
        }

        void setIndexLeaf(boolean value2) throws IOException {
            this.isIndexLeaf = value2;
            this.setFlag(1, value2);
        }

        private boolean isHashedLeaf() {
            return this.isHashedLeaf;
        }

        void setHashedLeaf() throws IOException {
            this.isHashedLeaf = true;
            this.setFlag(2, true);
        }

        short getMaxChildrenCount() {
            return this.isIndexLeaf() ? (this.isHashedLeaf() ? IntToIntBtree.this.maxLeafNodesInHash : IntToIntBtree.this.maxLeafNodes) : IntToIntBtree.this.maxInteriorNodes;
        }

        boolean isFull() {
            short childrenCount = this.getChildrenCount();
            if (!this.isIndexLeaf()) {
                childrenCount = (short)(childrenCount + 1);
            }
            return childrenCount == this.getMaxChildrenCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processMappings(AbstractIntToIntBtree.KeyValueProcessor processor) throws IOException {
            assert (this.isIndexLeaf());
            if (this.isHashedLeaf()) {
                int offset = this.addressInBuffer + this.indexToOffset(0);
                for (int i2 = 0; i2 < IntToIntBtree.this.hashPageCapacity; ++i2) {
                    Boolean result2;
                    int finalOffset = offset;
                    this.lockBuffer();
                    try {
                        result2 = ((NodeOp<Boolean>)b2 -> {
                            int key = b2.getInt(finalOffset + 4);
                            if (key != 0 && !processor.process(key, b2.getInt(finalOffset))) {
                                return false;
                            }
                            return true;
                        }).operate(this.bufferWrapper);
                    }
                    finally {
                        this.unlockBuffer();
                    }
                    if (!result2.booleanValue()) {
                        return false;
                    }
                    offset += 8;
                }
            } else {
                int childrenCount = this.getChildrenCount();
                for (int i3 = 0; i3 < childrenCount; ++i3) {
                    if (processor.process(this.keyAt(i3), this.addressAt(i3))) continue;
                    return false;
                }
            }
            return true;
        }

        public void initTraversal(int address, DirectBufferWrapper sharedBuffer) throws IOException {
            this.myHasFullPagesAlongPath = false;
            this.setAddress(address, sharedBuffer);
        }

        @Override
        public void close() {
            this.disposeBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int splitNode(int parentAddress) throws IOException {
            boolean indexLeaf = this.isIndexLeaf();
            boolean hashedLeaf = this.isHashedLeaf();
            short recordCount = this.getChildrenCount();
            try (BtreeIndexNodeView parent2 = null;){
                if (parentAddress != 0) {
                    parent2 = new BtreeIndexNodeView(parentAddress, true, null);
                }
                short maxIndex = (short)(this.getMaxChildrenCount() / 2);
                try (BtreeIndexNodeView newIndexNode = new BtreeIndexNodeView(IntToIntBtree.this.nextPage(), true, null);){
                    int medianKey;
                    this.syncWithStore();
                    if (parent2 != null) {
                        parent2.syncWithStore();
                    }
                    IntToIntBtree.this.root.syncWithStore();
                    newIndexNode.setIndexLeaf(indexLeaf);
                    int nextPage = this.getNextPage();
                    this.setNextPage(newIndexNode.address);
                    newIndexNode.setNextPage(nextPage);
                    if (indexLeaf && hashedLeaf) {
                        HashLeafData hashLeafData = new HashLeafData(this, recordCount);
                        int[] keys2 = hashLeafData.keys;
                        hashLeafData.clean();
                        Int2IntMap map2 = hashLeafData.values;
                        int avg = keys2.length / 2;
                        medianKey = keys2[avg];
                        --IntToIntBtree.this.hashedPagesCount;
                        this.setChildrenCount((short)0);
                        newIndexNode.setChildrenCount((short)0);
                        for (int i2 = 0; i2 < avg; ++i2) {
                            int key = keys2[i2];
                            this.insert(key, map2.get(key));
                            key = keys2[avg + i2];
                            newIndexNode.insert(key, map2.get(key));
                        }
                    } else {
                        short recordCountInNewNode = (short)(recordCount - maxIndex);
                        newIndexNode.setChildrenCount(recordCountInNewNode);
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(maxIndex), recordCountInNewNode * 8);
                        newIndexNode.putBytes(newIndexNode.indexToOffset(0), buffer);
                        if (indexLeaf) {
                            medianKey = newIndexNode.keyAt(0);
                        } else {
                            newIndexNode.setAddressAt(recordCountInNewNode, this.addressAt(recordCount));
                            maxIndex = (short)(maxIndex - 1);
                            medianKey = this.keyAt(maxIndex);
                        }
                        this.setChildrenCount(maxIndex);
                    }
                    if (parent2 != null) {
                        parent2.insert(medianKey, -newIndexNode.address);
                    } else {
                        int newRootAddress = IntToIntBtree.this.nextPage();
                        newIndexNode.syncWithStore();
                        this.syncWithStore();
                        IntToIntBtree.this.root.setAddress(newRootAddress);
                        parentAddress = newRootAddress;
                        BtreeIndexNodeView rootNodeView = IntToIntBtree.this.root.getNodeView();
                        rootNodeView.setChildrenCount((short)1);
                        rootNodeView.setKeyAt(0, medianKey);
                        rootNodeView.setAddressAt(0, -this.address);
                        rootNodeView.setAddressAt(1, -newIndexNode.address);
                    }
                }
            }
            return parentAddress;
        }

        private int locate(int valueHC, boolean split) throws IOException {
            int searched = 0;
            int parentAddress = 0;
            int maxHeight = IntToIntBtree.this.height + 1;
            while (true) {
                if (this.isFull()) {
                    if (split) {
                        if ((parentAddress = this.splitNode(parentAddress)) != 0) {
                            this.setAddress(parentAddress);
                        }
                        --searched;
                    } else {
                        this.myHasFullPagesAlongPath = true;
                    }
                }
                int i2 = this.search(valueHC);
                if (++searched > maxHeight) {
                    throw new CorruptedException(IntToIntBtree.this.storage.getPagedFileStorage().getFile());
                }
                if (this.isIndexLeaf()) {
                    IntToIntBtree.this.height = Math.max(IntToIntBtree.this.height, searched);
                    return i2;
                }
                int address = i2 < 0 ? this.addressAt(-i2 - 1) : this.addressAt(i2 + 1);
                parentAddress = this.address;
                this.setAddress(-address);
            }
        }

        private void insert(int valueHC, int newValueId) throws IOException {
            short recordCount = this.getChildrenCount();
            boolean indexLeaf = this.isIndexLeaf();
            if (indexLeaf) {
                if (recordCount == 0) {
                    this.setHashedLeaf();
                    ++IntToIntBtree.this.hashedPagesCount;
                }
                if (this.isHashedLeaf()) {
                    int index = this.hashIndex(valueHC);
                    if (index < 0) {
                        index = -index - 1;
                    }
                    this.setKeyAt(index, valueHC);
                    this.setAddressAt(index, newValueId);
                    this.setChildrenCount((short)(recordCount + 1));
                    return;
                }
            }
            int medianKeyInParent = this.search(valueHC);
            int index = -medianKeyInParent - 1;
            this.setChildrenCount((short)(recordCount + 1));
            int itemsToMove = recordCount - index;
            IntToIntBtree.this.movedMembersCount += itemsToMove;
            if (indexLeaf) {
                if (itemsToMove > 5) {
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(index), itemsToMove * 8);
                    this.putBytes(this.indexToOffset(index + 1), buffer);
                } else {
                    for (int i2 = recordCount - 1; i2 >= index; --i2) {
                        this.setKeyAt(i2 + 1, this.keyAt(i2));
                        this.setAddressAt(i2 + 1, this.addressAt(i2));
                    }
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index, newValueId);
            } else {
                this.setAddressAt(recordCount + 1, this.addressAt(recordCount));
                if (itemsToMove > 5) {
                    int elementsAfterIndex = recordCount - index - 1;
                    if (elementsAfterIndex > 0) {
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(index + 1), elementsAfterIndex * 8);
                        this.putBytes(this.indexToOffset(index + 2), buffer);
                    }
                } else {
                    for (int i3 = recordCount - 1; i3 > index; --i3) {
                        this.setKeyAt(i3 + 1, this.keyAt(i3));
                        this.setAddressAt(i3 + 1, this.addressAt(i3));
                    }
                }
                if (index < recordCount) {
                    this.setKeyAt(index + 1, this.keyAt(index));
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index + 1, newValueId);
            }
        }

        private int hashIndex(int value2) throws IOException {
            int length = IntToIntBtree.this.hashPageCapacity;
            int hash = value2 & Integer.MAX_VALUE;
            int index = hash % length;
            int keyAtIndex = this.keyAt(index);
            IntToIntBtree.this.hashSearchRequests++;
            int total = 0;
            if (keyAtIndex != value2 && keyAtIndex != 0) {
                int probe = 1 + hash % (length - 2);
                do {
                    if ((index -= probe) < 0) {
                        index += length;
                    }
                    keyAtIndex = this.keyAt(index);
                    if (++total <= length) continue;
                    throw new CorruptedException(IntToIntBtree.this.storage.getPagedFileStorage().getFile());
                } while (keyAtIndex != value2 && keyAtIndex != 0);
            }
            IntToIntBtree.this.maxStepsSearchedInHash = Math.max(IntToIntBtree.this.maxStepsSearchedInHash, total);
            IntToIntBtree.this.totalHashStepsSearched += total;
            return keyAtIndex == 0 ? -index - 1 : index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/IntToIntBtree$BtreeIndexNodeView", "getStorage"));
        }

        private final class HashLeafData {
            final BtreeIndexNodeView nodeView;
            final int[] keys;
            final Int2IntMap values;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            HashLeafData(BtreeIndexNodeView _nodeView, int recordCount) throws IOException {
                this.nodeView = _nodeView;
                int offset = this.nodeView.addressInBuffer + this.nodeView.indexToOffset(0);
                this.keys = new int[recordCount];
                this.values = new Int2IntOpenHashMap(recordCount);
                int[] keyNumber = new int[]{0};
                for (int i2 = 0; i2 < IntToIntBtree.this.hashPageCapacity; ++i2) {
                    this.nodeView.lockBuffer();
                    try {
                        int key = this.nodeView.bufferWrapper.getInt(offset + 4);
                        if (key != 0) {
                            int value2 = this.nodeView.bufferWrapper.getInt(offset);
                            if (keyNumber[0] == this.keys.length) {
                                throw new CorruptedException(IntToIntBtree.this.storage.getPagedFileStorage().getFile());
                            }
                            int n2 = keyNumber[0];
                            keyNumber[0] = n2 + 1;
                            this.keys[n2] = key;
                            this.values.put(key, value2);
                        }
                    }
                    finally {
                        this.nodeView.unlockBuffer();
                    }
                    offset += 8;
                }
                Arrays.sort(this.keys);
            }

            private void clean() throws IOException {
                for (int i2 = 0; i2 < IntToIntBtree.this.hashPageCapacity; ++i2) {
                    this.nodeView.setKeyAt(i2, 0);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface NodeOp<T> {
        public T operate(@NotNull DirectBufferWrapper var1) throws IOException;
    }
}

