/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.util.function.IntFunction;
import java.util.function.LongFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.lang.Hash;

final class StrippedLongToObjectMap<V>
implements LongFunction<V> {
    private long[] keys;
    private V[] values;
    private int mask;
    private boolean containsNullKey;
    private int tableSize;
    private int maxFill;
    private int size;
    private final IntFunction<V[]> valueArrayFactory;

    StrippedLongToObjectMap(IntFunction<V[]> valueArrayFactory, int expectedCapacity) {
        this.valueArrayFactory = valueArrayFactory;
        this.tableSize = Hash.arraySize((int)expectedCapacity, (float)0.5f);
        this.mask = this.tableSize - 1;
        this.maxFill = Hash.maxFill((int)this.tableSize, (float)0.5f);
        this.keys = new long[this.tableSize + 1];
        this.values = valueArrayFactory.apply(this.tableSize + 1);
    }

    StrippedLongToObjectMap(StrippedLongToObjectMap<V> original) {
        this.valueArrayFactory = original.valueArrayFactory;
        this.tableSize = original.tableSize;
        this.mask = original.mask;
        this.maxFill = original.maxFill;
        this.size = original.size;
        this.keys = (long[])original.keys.clone();
        this.values = (Object[])original.values.clone();
        this.containsNullKey = original.containsNullKey;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public int index(long key) {
        if (key == 0L) {
            return this.containsNullKey ? this.tableSize : -(this.tableSize + 1);
        }
        long[] keys2 = this.keys;
        int index = (int)key & this.mask;
        long current = keys2[index];
        if (current == 0L) {
            return -(index + 1);
        }
        if (key == current) {
            return index;
        }
        do {
            if ((current = keys2[index = index + 1 & this.mask]) != 0L) continue;
            return -(index + 1);
        } while (key != current);
        return index;
    }

    public void addByIndex(int index, long key, V value2) {
        this.replaceByIndex(-index - 1, key, value2);
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize((int)(this.size + 1), (float)0.5f));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void replaceByIndex(int index, long key, @NotNull V v2) {
        void value2;
        if (v2 == null) {
            StrippedLongToObjectMap.$$$reportNull$$$0(0);
        }
        if (index == this.tableSize) {
            this.containsNullKey = true;
        }
        this.keys[index] = key;
        this.values[index] = value2;
    }

    public V getByIndex(int index) {
        return this.values[index];
    }

    @Override
    public V apply(long k2) {
        if (k2 == 0L) {
            return this.containsNullKey ? (V)this.values[this.tableSize] : null;
        }
        long[] key = this.keys;
        int pos = (int)k2 & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return null;
        }
        if (k2 == curr) {
            return this.values[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return null;
        } while (k2 != curr);
        return this.values[pos];
    }

    private void rehash(int newN) {
        long[] keys2 = this.keys;
        V[] values2 = this.values;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        V[] newValue = this.valueArrayFactory.apply(newN + 1);
        int i2 = this.tableSize;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (keys2[--i2] == 0L) {
            }
            int pos = (int)keys2[i2] & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = keys2[i2];
            newValue[pos] = values2[i2];
        }
        newValue[newN] = values2[this.tableSize];
        this.tableSize = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill((int)this.tableSize, (float)0.5f);
        this.keys = newKey;
        this.values = newValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/lang/StrippedLongToObjectMap", "replaceByIndex"));
    }
}

