/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ThreadMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a3\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\r\u0010\b\u001a\u00020\t*\u00020\nH\u0086\b\u001a\r\u0010\u000b\u001a\u00020\t*\u00020\nH\u0086\b\u001a\u0011\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0086\b\u001a\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0086\b\u001a\u001f\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0086\b\u001a\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0017\u001a\u00020\nH\u0086\b\u001a'\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0086\b\u001a!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\nH\u0086\b\u001a1\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0086\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"withMeasure", "R", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "obj", "", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/daemon/common/Profiler;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "threadCpuTime", "", "Ljava/lang/management/ThreadMXBean;", "threadUserTime", "usedMemory", "withGC", "", "beginMeasureWallTime", "", "endMeasureWallTime", "", "perfCounters", "Lorg/jetbrains/kotlin/daemon/common/PerfCounters;", "startState", "beginMeasureWallAndThreadTimes", "threadMXBean", "endMeasureWallAndThreadTimes", "beginMeasureWallAndThreadTimesAndMemory", "endMeasureWallAndThreadTimesAndMemory", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nPerfUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n1#1,196:1\n83#1:197\n86#1:198\n83#1:199\n86#1:200\n90#1,5:201\n83#1:206\n86#1:207\n90#1,5:208\n83#1:213\n86#1:214\n83#1:215\n86#1:216\n90#1,5:217\n83#1:222\n86#1:223\n90#1,5:224\n*S KotlinDebug\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n108#1:197\n109#1:198\n118#1:199\n119#1:200\n123#1:201,5\n125#1:206\n126#1:207\n123#1:208,5\n125#1:213\n126#1:214\n136#1:215\n137#1:216\n138#1:217,5\n136#1:222\n137#1:223\n138#1:224,5\n*E\n"})
public final class PerfUtilsKt {
    public static final <R> R withMeasure(@NotNull Profiler $this$withMeasure, @Nullable Object obj, @NotNull Function0<? extends R> body) {
        Intrinsics.checkNotNullParameter($this$withMeasure, "<this>");
        Intrinsics.checkNotNullParameter(body, "body");
        boolean $i$f$withMeasure = false;
        List<Long> startState = $this$withMeasure.beginMeasure(obj);
        R res2 = body.invoke();
        $this$withMeasure.endMeasure(obj, startState);
        return res2;
    }

    public static final long threadCpuTime(@NotNull ThreadMXBean $this$threadCpuTime) {
        Intrinsics.checkNotNullParameter($this$threadCpuTime, "<this>");
        boolean $i$f$threadCpuTime = false;
        return $this$threadCpuTime.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime.getCurrentThreadCpuTime() : 0L;
    }

    public static final long threadUserTime(@NotNull ThreadMXBean $this$threadUserTime) {
        Intrinsics.checkNotNullParameter($this$threadUserTime, "<this>");
        boolean $i$f$threadUserTime = false;
        return $this$threadUserTime.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime.getCurrentThreadUserTime() : 0L;
    }

    public static final long usedMemory(boolean withGC) {
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    @NotNull
    public static final List<Long> beginMeasureWallTime() {
        boolean $i$f$beginMeasureWallTime = false;
        return CollectionsKt.listOf(System.nanoTime());
    }

    public static final void endMeasureWallTime(@NotNull PerfCounters perfCounters, @NotNull List<Long> startState) {
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallTime = false;
        long startTime = ((Number)startState.get(0)).longValue();
        PerfCounters.addMeasurement$default(perfCounters, System.nanoTime() - startTime, 0L, 0L, 0L, 14, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimes(@NotNull ThreadMXBean threadMXBean) {
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        boolean $i$f$beginMeasureWallAndThreadTimes = false;
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        Long[] longArray = new Long[]{startTime, startThreadTime, startThreadUserTime};
        return CollectionsKt.listOf(longArray);
    }

    public static final void endMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull ThreadMXBean threadMXBean, @NotNull List<Long> startState) {
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallAndThreadTimes = false;
        long startTime = ((Number)startState.get(0)).longValue();
        long startThreadTime = ((Number)startState.get(1)).longValue();
        long startThreadUserTime = ((Number)startState.get(2)).longValue();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        PerfCounters.addMeasurement$default(perfCounters, System.nanoTime() - startTime, ($this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime, ($this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime, 0L, 8, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimesAndMemory(boolean withGC, @NotNull ThreadMXBean threadMXBean) {
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory = false;
        boolean withGC$iv = withGC;
        boolean $i$f$usedMemory = false;
        if (withGC$iv) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        Long[] longArray = new Long[]{startMem, startTime, startThreadTime, startThreadUserTime};
        return CollectionsKt.listOf(longArray);
    }

    public static /* synthetic */ List beginMeasureWallAndThreadTimesAndMemory$default(boolean withGC, ThreadMXBean threadMXBean, int n2, Object object) {
        if ((n2 & 1) != 0) {
            withGC = false;
        }
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory = false;
        boolean withGC$iv = withGC;
        boolean $i$f$usedMemory = false;
        if (withGC$iv) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        Long[] longArray = new Long[]{startMem, startTime, startThreadTime, startThreadUserTime};
        return CollectionsKt.listOf(longArray);
    }

    public static final void endMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull ThreadMXBean threadMXBean, @NotNull List<Long> startState) {
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory = false;
        long startMem = ((Number)startState.get(0)).longValue();
        long startTime = ((Number)startState.get(1)).longValue();
        long startThreadTime = ((Number)startState.get(2)).longValue();
        long startThreadUserTime = ((Number)startState.get(3)).longValue();
        long l2 = System.nanoTime() - startTime;
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long l3 = ($this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long l4 = ($this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime;
        boolean withGC$iv = withGC;
        boolean $i$f$usedMemory = false;
        if (withGC$iv) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        perfCounters.addMeasurement(l2, l3, l4, rt$iv.totalMemory() - rt$iv.freeMemory() - startMem);
    }

    public static /* synthetic */ void endMeasureWallAndThreadTimesAndMemory$default(PerfCounters perfCounters, boolean withGC, ThreadMXBean threadMXBean, List startState, int n2, Object object) {
        if ((n2 & 2) != 0) {
            withGC = false;
        }
        Intrinsics.checkNotNullParameter(perfCounters, "perfCounters");
        Intrinsics.checkNotNullParameter(threadMXBean, "threadMXBean");
        Intrinsics.checkNotNullParameter(startState, "startState");
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory = false;
        long startMem = ((Number)startState.get(0)).longValue();
        long startTime = ((Number)startState.get(1)).longValue();
        long startThreadTime = ((Number)startState.get(2)).longValue();
        long startThreadUserTime = ((Number)startState.get(3)).longValue();
        long l2 = System.nanoTime() - startTime;
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long l3 = ($this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long l4 = ($this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime;
        boolean withGC$iv = withGC;
        boolean $i$f$usedMemory = false;
        if (withGC$iv) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        perfCounters.addMeasurement(l2, l3, l4, rt$iv.totalMemory() - rt$iv.freeMemory() - startMem);
    }
}

