/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrTypeAbbreviationImpl;
import org.jetbrains.kotlin.ir.util.AbstractTypeRemapper;
import org.jetbrains.kotlin.ir.util.RemapTypesKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0014J\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002J\f\u0010\n\u001a\u00020\f*\u00020\fH\u0002J\f\u0010\n\u001a\u00020\r*\u00020\u000eH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper;", "Lorg/jetbrains/kotlin/ir/util/AbstractTypeRemapper;", "typeParameterMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "<init>", "(Ljava/util/Map;)V", "remapTypeOrNull", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "remap", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/ir/types/impl/IrTypeAbbreviationImpl;", "Lorg/jetbrains/kotlin/ir/types/IrTypeAbbreviation;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeParameterRemapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeParameterRemapper.kt\norg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,63:1\n1869#2,2:64\n1634#2,3:68\n1869#2,2:71\n1#3:66\n16#4:67\n*S KotlinDebug\n*F\n+ 1 IrTypeParameterRemapper.kt\norg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper\n*L\n39#1:64,2\n57#1:68,3\n60#1:71,2\n57#1:67\n*E\n"})
public class IrTypeParameterRemapper
extends AbstractTypeRemapper {
    @NotNull
    private final Map<IrTypeParameter, IrTypeParameter> typeParameterMap;

    public IrTypeParameterRemapper(@NotNull Map<IrTypeParameter, ? extends IrTypeParameter> typeParameterMap) {
        Intrinsics.checkNotNullParameter(typeParameterMap, "typeParameterMap");
        this.typeParameterMap = typeParameterMap;
    }

    @Override
    @Nullable
    protected IrType remapTypeOrNull(@NotNull IrType type2) {
        IrSimpleType irSimpleType;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof IrSimpleType)) {
            return null;
        }
        IrClassifierSymbol classifier2 = this.remap(((IrSimpleType)type2).getClassifier());
        List<IrTypeArgument> arguments2 = this.remapTypeArguments(((IrSimpleType)type2).getArguments());
        if (classifier2 == ((IrSimpleType)type2).getClassifier() && arguments2 == null && type2.getAnnotations().isEmpty() && ((IrSimpleType)type2).getAbbreviation() == null) {
            return null;
        }
        SimpleTypeNullability simpleTypeNullability = ((IrSimpleType)type2).getNullability();
        List<IrTypeArgument> list = arguments2;
        if (list == null) {
            list = ((IrSimpleType)type2).getArguments();
        }
        IrTypeAbbreviation irTypeAbbreviation = ((IrSimpleType)type2).getAbbreviation();
        IrSimpleType $this$remapTypeOrNull_u24lambda_u240 = irSimpleType = IrSimpleTypeImplKt.IrSimpleTypeImpl$default(classifier2, simpleTypeNullability, list, type2.getAnnotations(), irTypeAbbreviation != null ? this.remap(irTypeAbbreviation) : null, null, 32, null);
        boolean bl = false;
        Iterable $this$forEach$iv = $this$remapTypeOrNull_u24lambda_u240.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall it = (IrConstructorCall)element$iv;
            boolean bl2 = false;
            RemapTypesKt.remapTypes(it, this);
        }
        return irSimpleType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrClassifierSymbol remap(IrClassifierSymbol $this$remap) {
        IrClassifierSymbol irClassifierSymbol;
        IrSymbolOwner irSymbolOwner = $this$remap.getOwner();
        Object object = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        if (object != null) {
            IrTypeParameter it = object;
            boolean bl = false;
            IrTypeParameter irTypeParameter = this.typeParameterMap.get(it);
            IrTypeParameterSymbol irTypeParameterSymbol = irTypeParameter != null ? irTypeParameter.getSymbol() : null;
            object = irTypeParameterSymbol;
            if (irTypeParameterSymbol != null) {
                irClassifierSymbol = (IrClassifierSymbol)object;
                return irClassifierSymbol;
            }
        }
        irClassifierSymbol = $this$remap;
        return irClassifierSymbol;
    }

    private final IrTypeArgument remap(IrTypeArgument $this$remap) {
        IrTypeArgument irTypeArgument;
        IrTypeArgument irTypeArgument2 = $this$remap;
        if (irTypeArgument2 instanceof IrTypeProjection) {
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(this.remapType(((IrTypeProjection)$this$remap).getType()), ((IrTypeProjection)$this$remap).getVariance());
        } else if (irTypeArgument2 instanceof IrStarProjection) {
            irTypeArgument = $this$remap;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irTypeArgument;
    }

    /*
     * WARNING - void declaration
     */
    private final IrTypeAbbreviationImpl remap(IrTypeAbbreviation $this$remap) {
        IrConstructorCall it;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$memoryOptimizedMap$iv;
        Object object = $this$remap.getArguments();
        boolean bl = $this$remap.getHasQuestionMark();
        IrTypeAliasSymbol irTypeAliasSymbol = $this$remap.getTypeAlias();
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.remap((IrTypeArgument)((Object)it)));
        }
        collection = CollectionsKt.compactIfPossible((List)destination$iv$iv);
        List<IrConstructorCall> list = $this$remap.getAnnotations();
        List list2 = collection;
        boolean bl3 = bl;
        IrTypeAliasSymbol irTypeAliasSymbol2 = irTypeAliasSymbol;
        Object $this$remap_u24lambda_u242 = object = new IrTypeAbbreviationImpl(irTypeAliasSymbol2, bl3, list2, list);
        boolean bl4 = false;
        Iterable $this$forEach$iv = ((IrTypeAbbreviationImpl)$this$remap_u24lambda_u242).getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrConstructorCall)element$iv;
            boolean bl5 = false;
            RemapTypesKt.remapTypes(it, this);
        }
        return object;
    }
}

