/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PublishedApiUsageChecker;", "", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class PublishedApiUsageChecker {
    @NotNull
    public static final PublishedApiUsageChecker INSTANCE = new PublishedApiUsageChecker();

    private PublishedApiUsageChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility) || Intrinsics.areEqual(((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), DescriptorVisibilities.INTERNAL)) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        for (KtAnnotationEntry entry : declaration.getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry) == null || !Intrinsics.areEqual(annotationDescriptor.getFqName(), StandardNames.FqNames.publishedApi)) continue;
            trace.report(Errors.NON_INTERNAL_PUBLISHED_API.on((KtAnnotationEntry)((PsiElement)entry)));
        }
    }
}

