import { Component, InfernoNode } from 'inferno';
import type { History, Location } from 'history';
import { Match } from './Route';
export type TLoaderProps<P extends Record<string, string>> = {
    params?: P;
    request: Request;
    onProgress?(perc: number): void;
};
/**
 * Loader returns Response and throws error
 */
export type TLoader<P extends Record<string, string>, R extends Response> = ({ params, request }: TLoaderProps<P>) => Promise<R>;
export type TLoaderData<Res = any, Err = any> = {
    res?: Res;
    err?: Err;
};
type TInitialData = Record<string, TLoaderData>;
export interface IRouterProps {
    history: History;
    children: InfernoNode;
    initialData?: TInitialData;
}
export type TContextRouter = {
    history: History;
    route: {
        location: Pick<Location, 'pathname'>;
        match: Match<any> | null;
    };
    initialData?: TInitialData;
    staticContext?: object;
};
export type RouterContext = {
    router: TContextRouter;
};
/**
 * The public API for putting history on context.
 */
export declare class Router extends Component<IRouterProps, any> {
    unlisten: any;
    private _loaderFetchControllers;
    private _loaderIteration;
    constructor(props: IRouterProps, context: {
        router: TContextRouter;
    });
    getChildContext(): RouterContext;
    computeMatch(pathname: any): Match<{}>;
    componentWillMount(): void;
    private _matchAndResolveLoaders;
    componentWillUnmount(): void;
    render(props: IRouterProps): InfernoNode;
}
export {};
