"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("schema-utils");
const webpack_1 = __importDefault(require("webpack"));
const schema = {
    type: "object",
    properties: {
        entry: {
            type: "string",
        },
        filepath: {
            type: "string",
        },
        additionalProperties: false,
    },
};
function injectEntryWebpack5(options, entryName, injectFilepath) {
    const originalEntry = options.entry;
    options.entry = async () => {
        const entries = typeof originalEntry === "function"
            ? await originalEntry()
            : originalEntry;
        const injectEntry = entries[entryName];
        if (!injectEntry.import) {
            throw new Error(`Could not find an entry named '${entryName}'. See https://webpack.js.org/concepts/entry-points/ for an overview of webpack entries.`);
        }
        if (!injectEntry.import.includes(injectFilepath)) {
            injectEntry.import.unshift(injectFilepath);
        }
        return entries;
    };
}
function injectEntryWebpack4(options, entryName, injectFilepath) {
    function injectEntry(entry) {
        switch (typeof entry) {
            case "undefined": {
                throw new Error(`Could not find an entry named '${entryName}'. See https://webpack.js.org/concepts/entry-points/ for an overview of webpack entries.`);
            }
            case "string": {
                return [injectFilepath, entry];
            }
            case "object": {
                if (Array.isArray(entry)) {
                    if (!entry.includes(injectFilepath)) {
                        return [injectFilepath, ...entry];
                    }
                    return entry;
                }
                else {
                    return {
                        ...entry,
                        // @ts-expect-error webpack4
                        [entryName]: injectEntry(entry[entryName]),
                    };
                }
            }
            case "function": {
                throw new Error("Invariant: Recieved unexpected value for entry: function");
            }
            default: {
                const _exhaust = entry;
                console.error(Error(`Invariant: Recieved unexpected value for entry: ${typeof entry}`));
                return _exhaust;
            }
        }
    }
    const entry = options.entry;
    typeof entry === "function"
        ? // @ts-expect-error webpack4
            (options.entry = () => Promise.resolve(entry()).then(injectEntry))
        : // @ts-expect-error webpack4
            (options.entry = () => injectEntry(entry));
}
class InjectEntryPlugin {
    config;
    constructor(options) {
        (0, schema_utils_1.validate)(schema, options, {
            name: "Inject Entry Webpack Plugin",
            baseDataPath: "options",
        });
        this.config = options;
    }
    apply(compiler) {
        const { entry, filepath } = this.config;
        if (!webpack_1.default.version || webpack_1.default.version.startsWith("4")) {
            injectEntryWebpack4(compiler.options, entry, filepath);
        }
        else {
            injectEntryWebpack5(compiler.options, entry, filepath);
        }
    }
}
exports.default = InjectEntryPlugin;
