const std = @import("std");
const ly_core = @import("ly-core");
const enums = @import("enums.zig");
const Lang = @import("bigclock/Lang.zig");
const en = @import("bigclock/en.zig");
const fa = @import("bigclock/fa.zig");
const Cell = @import("tui/Cell.zig");

const interop = ly_core.interop;
const Bigclock = enums.Bigclock;
pub const WIDTH = Lang.WIDTH;
pub const HEIGHT = Lang.HEIGHT;
pub const SIZE = Lang.SIZE;

pub fn clockCell(animate: bool, char: u8, fg: u32, bg: u32, bigclock: Bigclock) ![SIZE]Cell {
    var cells: [SIZE]Cell = undefined;

    const time = try interop.getTimeOfDay();
    const clock_chars = toBigNumber(if (animate and char == ':' and @divTrunc(time.microseconds, 500000) != 0) ' ' else char, bigclock);
    for (0..cells.len) |i| cells[i] = Cell.init(clock_chars[i], fg, bg);

    return cells;
}

pub fn alphaBlit(x: usize, y: usize, tb_width: usize, tb_height: usize, cells: [SIZE]Cell) void {
    if (x + WIDTH >= tb_width or y + HEIGHT >= tb_height) return;

    for (0..HEIGHT) |yy| {
        for (0..WIDTH) |xx| {
            const cell = cells[yy * WIDTH + xx];
            cell.put(x + xx, y + yy);
        }
    }
}

fn toBigNumber(char: u8, bigclock: Bigclock) [SIZE]u21 {
    const locale_chars = switch (bigclock) {
        .fa => fa.locale_chars,
        .en => en.locale_chars,
        .none => unreachable,
    };
    return switch (char) {
        '0' => locale_chars.ZERO,
        '1' => locale_chars.ONE,
        '2' => locale_chars.TWO,
        '3' => locale_chars.THREE,
        '4' => locale_chars.FOUR,
        '5' => locale_chars.FIVE,
        '6' => locale_chars.SIX,
        '7' => locale_chars.SEVEN,
        '8' => locale_chars.EIGHT,
        '9' => locale_chars.NINE,
        'p', 'P' => locale_chars.P,
        'a', 'A' => locale_chars.A,
        'm', 'M' => locale_chars.M,
        ':' => locale_chars.S,
        else => locale_chars.E,
    };
}
