#ifndef CHANGE_PASSWORD_COMPONENT_H
#define CHANGE_PASSWORD_COMPONENT_H

#include "ChangePasswordController.h"
#include "QmlDialogWrapper.h"

class ChangePasswordComponent: public QMLComponent
{
    Q_OBJECT

public:
    explicit ChangePasswordComponent(QObject* parent = nullptr);

    QUrl getQmlUrl() override;

    static void registerQmlModules();

    Q_INVOKABLE void changePassword(QString password, QString confirmationPassword);
    Q_INVOKABLE void check2FA(QString pin);

signals:
    void show2FA();
    void passwordChangeFailed(QString errorMessage);
    void passwordCheckFailed(QString errorMessage);
    void passwordChangeSucceed();
    void twoFAVerificationFailed();

private:
    std::unique_ptr<ChangePasswordController> mChangePasswordController;

    void onPasswordChangeSucceed(QString title, QString description);
};

#endif
