#ifndef TRANSFER_MANAGER_STATUS_HEADER_WIDGET_H
#define TRANSFER_MANAGER_STATUS_HEADER_WIDGET_H

#include <QTimer>
#include <QWidget>

namespace Ui
{
class TransferManagerStatusHeaderWidget;
}

class TransferManagerStatusHeaderWidget: public QWidget
{
    Q_OBJECT

public:
    explicit TransferManagerStatusHeaderWidget(QWidget* parent = nullptr);
    ~TransferManagerStatusHeaderWidget();

    void showAllPausedBanner();
    void hideAllPausedBanner();
    void showTransferBanner(bool show);
    void updateStorageBannerText();
    void setStorageQuotaState(int newStorageQuotaState);

protected:
    bool event(QEvent* event) override;

private slots:
    void setTransferQuotaBannerText();
    void onUpgradeClicked();

private:
    Ui::TransferManagerStatusHeaderWidget* mUi;
    int mStorageQuotaState;
    QTimer mTransferQuotaTimer;

    void showAlmostFullStorageBanner();
    void showFullStorageBanner();

    void setAlmostFullStorageBannerText();
    void setFullStorageBannerText();
    void setAllPausedBannerText();
};

#endif // TRANSFER_MANAGER_STATUS_HEADER_WIDGET_H
