use std::fmt;
pub const GENERATED_BY: &str = "crates/sml-syntax/build.rs";
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[repr(u16)]
pub enum SyntaxKind {
    Whitespace,
    BlockComment,
    Invalid,
    EsimportKw,
    ExceptionKw,
    SignatureKw,
    StructureKw,
    DatatypeKw,
    WithtypeKw,
    AbstypeKw,
    AndalsoKw,
    FunctorKw,
    IncludeKw,
    SharingKw,
    EqtypeKw,
    HandleKw,
    InfixrKw,
    NonfixKw,
    OrelseKw,
    StructKw,
    InfixKw,
    LocalKw,
    RaiseKw,
    WhereKw,
    WhileKw,
    CaseKw,
    ElseKw,
    OpenKw,
    ThenKw,
    TypeKw,
    WithKw,
    AndKw,
    EndKw,
    FunKw,
    LetKw,
    RecKw,
    SigKw,
    ValKw,
    AsKw,
    DoKw,
    FnKw,
    IfKw,
    InKw,
    OfKw,
    OpKw,
    DotDotDot,
    MinusGt,
    ColonGt,
    EqGt,
    Hash,
    LRound,
    RRound,
    Star,
    Comma,
    Dot,
    Colon,
    Semicolon,
    Eq,
    LSquare,
    RSquare,
    Underscore,
    LCurly,
    Bar,
    RCurly,
    CharLit,
    IntLit,
    Name,
    RealLit,
    StringLit,
    TyVar,
    WordLit,
    Root,
    Dec,
    DecWithTail,
    DecInSeq,
    SharingTail,
    HoleDec,
    ValDec,
    FunDec,
    TyDec,
    DatDec,
    DatCopyDec,
    AbstypeDec,
    ExDec,
    OpenDec,
    InfixDec,
    InfixrDec,
    NonfixDec,
    DoDec,
    LocalDec,
    StructureDec,
    SignatureDec,
    FunctorDec,
    ExpDec,
    IncludeDec,
    EsImportDec,
    TyVarSeq,
    ValBind,
    FunBind,
    TyBind,
    DatBind,
    WithType,
    Path,
    ExBind,
    LocalDecHd,
    LocalDecTl,
    StrBind,
    SigBind,
    FunctorBind,
    EsImportAttrs,
    EsImportSpecs,
    EqExp,
    EqTy,
    FunBindCase,
    TyAnnotation,
    EqConBinds,
    ConBind,
    OfTy,
    AscriptionTail,
    EqStrExp,
    EsImportSpecArg,
    EsImportSpec,
    AsPatTail,
    PrefixFunBindCaseHead,
    InfixFunBindCaseHead,
    FunctorArgNameSigExp,
    StructStrExp,
    PathStrExp,
    AscriptionStrExp,
    AppStrExp,
    LetStrExp,
    AppStrExpArgStrExp,
    SigSigExp,
    NameSigExp,
    WhereTypeSigExp,
    WhereSigExp,
    PathEq,
    HoleExp,
    WildcardExp,
    OpAndalsoExp,
    OpOrelseExp,
    SConExp,
    PathExp,
    RecordExp,
    SelectorExp,
    ParenExp,
    TupleExp,
    ListExp,
    VectorExp,
    SeqExp,
    LetExp,
    AppExp,
    InfixExp,
    TypedExp,
    AndalsoExp,
    OrelseExp,
    HandleExp,
    RaiseExp,
    IfExp,
    WhileExp,
    CaseExp,
    FnExp,
    ExpRow,
    ExpArg,
    ExpInSeq,
    Matcher,
    Arm,
    WildcardPat,
    SConPat,
    ConPat,
    RecordPat,
    ParenPat,
    TuplePat,
    ListPat,
    VectorPat,
    InfixPat,
    TypedPat,
    AsPat,
    OrPat,
    PatRow,
    PatArg,
    RestPatRow,
    LabAndPatPatRow,
    LabPatRow,
    HoleTy,
    WildcardTy,
    TyVarTy,
    RecordTy,
    ConTy,
    OneArgConTy,
    TupleTy,
    FnTy,
    ParenTy,
    TyRow,
    TySeq,
    StarTy,
    NameStarEqDot,
    TyArg,
    TyVarArg,
}
impl SyntaxKind {
    pub const PUNCTUATION: [(&'static [u8], Self); 19usize] = [
        (b"...", Self::DotDotDot),
        (b"->", Self::MinusGt),
        (b":>", Self::ColonGt),
        (b"=>", Self::EqGt),
        (b"#", Self::Hash),
        (b"(", Self::LRound),
        (b")", Self::RRound),
        (b"*", Self::Star),
        (b",", Self::Comma),
        (b".", Self::Dot),
        (b":", Self::Colon),
        (b";", Self::Semicolon),
        (b"=", Self::Eq),
        (b"[", Self::LSquare),
        (b"]", Self::RSquare),
        (b"_", Self::Underscore),
        (b"{", Self::LCurly),
        (b"|", Self::Bar),
        (b"}", Self::RCurly),
    ];
    pub fn keyword(bs: &[u8]) -> Option<Self> {
        let ret = match bs {
            b"_esImport" => Self::EsimportKw,
            b"exception" => Self::ExceptionKw,
            b"signature" => Self::SignatureKw,
            b"structure" => Self::StructureKw,
            b"datatype" => Self::DatatypeKw,
            b"withtype" => Self::WithtypeKw,
            b"abstype" => Self::AbstypeKw,
            b"andalso" => Self::AndalsoKw,
            b"functor" => Self::FunctorKw,
            b"include" => Self::IncludeKw,
            b"sharing" => Self::SharingKw,
            b"eqtype" => Self::EqtypeKw,
            b"handle" => Self::HandleKw,
            b"infixr" => Self::InfixrKw,
            b"nonfix" => Self::NonfixKw,
            b"orelse" => Self::OrelseKw,
            b"struct" => Self::StructKw,
            b"infix" => Self::InfixKw,
            b"local" => Self::LocalKw,
            b"raise" => Self::RaiseKw,
            b"where" => Self::WhereKw,
            b"while" => Self::WhileKw,
            b"case" => Self::CaseKw,
            b"else" => Self::ElseKw,
            b"open" => Self::OpenKw,
            b"then" => Self::ThenKw,
            b"type" => Self::TypeKw,
            b"with" => Self::WithKw,
            b"and" => Self::AndKw,
            b"end" => Self::EndKw,
            b"fun" => Self::FunKw,
            b"let" => Self::LetKw,
            b"rec" => Self::RecKw,
            b"sig" => Self::SigKw,
            b"val" => Self::ValKw,
            b"as" => Self::AsKw,
            b"do" => Self::DoKw,
            b"fn" => Self::FnKw,
            b"if" => Self::IfKw,
            b"in" => Self::InKw,
            b"of" => Self::OfKw,
            b"op" => Self::OpKw,
            _ => return None,
        };
        Some(ret)
    }
    pub fn token_desc(&self) -> Option<&'static str> {
        let ret = match *self {
            Self::DotDotDot => "`...`",
            Self::MinusGt => "`->`",
            Self::ColonGt => "`:>`",
            Self::EqGt => "`=>`",
            Self::Hash => "`#`",
            Self::LRound => "`(`",
            Self::RRound => "`)`",
            Self::Star => "`*`",
            Self::Comma => "`,`",
            Self::Dot => "`.`",
            Self::Colon => "`:`",
            Self::Semicolon => "`;`",
            Self::Eq => "`=`",
            Self::LSquare => "`[`",
            Self::RSquare => "`]`",
            Self::Underscore => "`_`",
            Self::LCurly => "`{`",
            Self::Bar => "`|`",
            Self::RCurly => "`}`",
            Self::EsimportKw => "`_esImport`",
            Self::ExceptionKw => "`exception`",
            Self::SignatureKw => "`signature`",
            Self::StructureKw => "`structure`",
            Self::DatatypeKw => "`datatype`",
            Self::WithtypeKw => "`withtype`",
            Self::AbstypeKw => "`abstype`",
            Self::AndalsoKw => "`andalso`",
            Self::FunctorKw => "`functor`",
            Self::IncludeKw => "`include`",
            Self::SharingKw => "`sharing`",
            Self::EqtypeKw => "`eqtype`",
            Self::HandleKw => "`handle`",
            Self::InfixrKw => "`infixr`",
            Self::NonfixKw => "`nonfix`",
            Self::OrelseKw => "`orelse`",
            Self::StructKw => "`struct`",
            Self::InfixKw => "`infix`",
            Self::LocalKw => "`local`",
            Self::RaiseKw => "`raise`",
            Self::WhereKw => "`where`",
            Self::WhileKw => "`while`",
            Self::CaseKw => "`case`",
            Self::ElseKw => "`else`",
            Self::OpenKw => "`open`",
            Self::ThenKw => "`then`",
            Self::TypeKw => "`type`",
            Self::WithKw => "`with`",
            Self::AndKw => "`and`",
            Self::EndKw => "`end`",
            Self::FunKw => "`fun`",
            Self::LetKw => "`let`",
            Self::RecKw => "`rec`",
            Self::SigKw => "`sig`",
            Self::ValKw => "`val`",
            Self::AsKw => "`as`",
            Self::DoKw => "`do`",
            Self::FnKw => "`fn`",
            Self::IfKw => "`if`",
            Self::InKw => "`in`",
            Self::OfKw => "`of`",
            Self::OpKw => "`op`",
            Self::CharLit => "a character literal",
            Self::IntLit => "an integer literal",
            Self::Name => "a name",
            Self::RealLit => "a real literal",
            Self::StringLit => "a string literal",
            Self::TyVar => "a type variable",
            Self::WordLit => "a word literal",
            _ => return None,
        };
        Some(ret)
    }
    pub fn token_doc(&self) -> Option<&'static str> {
        let ret = match *self {
            Self::DotDotDot => {
                "Token: `...`\n\n\nIgnore the rest of the rows in a record pattern.\n\n```sml\nval {b, ...} = {a = 1, b = 4}\n```\n\nAlso used as a expression/type/declaration \"hole\", though this is not valid SML.\n"
            }
            Self::MinusGt => {
                "Token: `->`\n\n\nSeparate the parameter type from the result type in a function type.\n\n```sml\ntype realToInt = real -> int\n```\n\nIn this example, `real -> int` is the type of functions that take a `real` and return an `int`.\n\nThe arrow is right associative. This means `t1` and `t2` are the same type, and both are distinct from `t3`:\n\n```sml\ntype t1 = int -> string -> bool\ntype t2 = int -> (string -> bool)\ntype t3 = (int -> string) -> bool\n```\n\n- `t1` and `t2` can be read as: take an `int`, then return a function. That function takes an `string` and returns a `bool`.\n- `t3` can be read as: take a function (which takes an `int` and returns an `string`), and return a `bool`.\n\nThis matches up with the fact that function application is left associative. This means that expressions 1 and 2 are equivalent, which are both distinct from expression 3:\n\n1. `f x y`\n2. `(f x) y`\n3. `f (x y)`\n\nCompare with `=>`, which separates a pattern from an expression in a matcher.\n"
            }
            Self::ColonGt => {
                "Token: `:>`\n\n\nOpaquely ascribe a structure to a signature.\n\n```sml\nstructure Stack :> sig\n  type 'a t\n  val empty : 'a t\n  val push : 'a t -> 'a -> 'a t\n  val pop : 'a t -> 'a option * 'a t\nend = struct\n  type 'a t = 'a list\n  val empty = []\n  fun push xs x = x :: xs\n  fun pop xs =\n    case xs of\n      [] => (NONE, xs)\n    | x :: xs' => (SOME x, xs')\nend\n```\n\nCompare with `:`, which performs transparent ascription in the context of signatures.\n"
            }
            Self::EqGt => {
                "Token: `=>`\n\n\nSeparate a pattern from its expression in a matcher arm.\n\n```sml\nfun describe x =\n  case x of\n    0 => \"nothing\"\n  | 1 => \"single\"\n  | 2 => \"pair\"\n  | _ => \"other\"\n```\n\nCompare with `->`, which denotes a function type.\n"
            }
            Self::Hash => {
                "Token: `#`\n\n\nSelect a field from a record.\n\nTuples are record whose labels are numbers starting at 1, so these work with tuples too.\n\n```sml\nval movie = { name = \"Castle in the Sky\", year = 1986 }\nval s : string = #name movie\nval tup = (false, 5)\nval n : int = #2 tup\n```\n\nOften, pattern matching is preferred.\n\n```sml\nfun fst (x, _) = x\nval three = fst (1 + 2, \"hi\")\n\nval tvShow = { name = \"The Good Place\", year = 2016 }\nval { year, ... } = tvShow\n```\n"
            }
            Self::LRound => {
                "Token: `(`\n\n\n1. Group things together. Can be used to override precedence.\n\n   ```sml\n   fun doMath a b c = a * (b + c)\n   ```\n\n2. Begin a tuple expression or pattern.\n\n   ```sml\n   val tup = (123, \"hi\")\n   val (n, s) = tup\n   ```\n\n3. Begin a list of type arguments or parameters.\n\n   ```sml\n   datatype ('t, 'e) result =\n     Ok of 't\n   | Err of 'e\n\n   fun ('t, 'e, 'u) map\n     (f : 't -> 'u)\n     (res : ('t, 'e) result)\n     : ('u, 'e) result =\n     case res of\n       Ok x => Ok (f x)\n     | Err e => Err e\n\n   val x : (int, string) result = Ok 3\n   ```\n"
            }
            Self::RRound => "Token: `)`\n\n\nThe companion of `(`.\n",
            Self::Star => {
                "Token: `*`\n\n\n1. Separate types in a tuple type.\n\n   ```sml\n   type pair = int * string\n   ```\n\n2. Multiply numbers.\n\n   ```sml\n   val _ = 3 * 6\n   ```\n"
            }
            Self::Comma => {
                "Token: `,`\n\n\nSeparate things, like tuple/record elements, list elements, and type arguments.\n\n```sml\nval tup = (false, 5)\nval record = { name = \"綿谷新\", height = 173 }\nval lst = [1, 4, 3]\ntype ('a, 'b) parser = 'a -> ('a * 'b) option\n```\n\nCompare with `;`, which can also separate expressions, but discards the value of all but the last one.\n"
            }
            Self::Dot => {
                "Token: `.`\n\n\nSeparate components in a path.\n\n```sml\nval _ = Int.max (1, 5)\n```\n"
            }
            Self::Colon => {
                "Token: `:`\n\n\n1. Annotate an expression or pattern with a type.\n\n   ```sml\n   val a : int = 1 + 4\n   val b = \"hi\" : string\n   ```\n\n2. Transparently ascribe a structure to a signature.\n\n   ```sml\n   structure S : sig\n     type t\n     val x : t\n   end = struct\n     type t = int\n     val x = 5\n   end\n\n   val n : int = S.x + 3\n   ```\n\n   Compare with `:>`, which opaquely ascribes.\n"
            }
            Self::Semicolon => {
                "Token: `;`\n\n\nSeparate elements in a sequence, like expressions.\n\n```sml\nval n : int = (\n  print \"about to give you an int\";\n  5\n)\n```\n\nCan also be used to separate declarations, but this is unnecessary.\n\nAlso indicates the end of input when in a REPL.\n\nCompare with `,`, which can also separate expressions, but constructs tuples or lists (when used with `()` and `[]` respectively).\n"
            }
            Self::Eq => {
                "Token: `=`\n\n\n1. Assign things.\n\n   ```sml\n   val a = 5\n   fun f x = x + 4\n   ```\n\n2. Check for equality.\n\n   ```sml\n   fun isZero n = n = 0\n   fun f s = if \"foo\" = s then 1 else 2\n   ```\n"
            }
            Self::LSquare => {
                "Token: `[`\n\n\nBegin a list expression or pattern.\n\n```sml\nval xs = [1, 4, 9]\n```\n"
            }
            Self::RSquare => "Token: `]`\n\n\nThe companion of `[`.\n",
            Self::Underscore => {
                "Token: `_`\n\n\nDiscard whatever matches the pattern.\n\n```sml\nval (_, a) = (4, \"hi\")\n```\n\nAlso used as a expression/type \"hole\", though this is not valid SML.\n"
            }
            Self::LCurly => {
                "Token: `{`\n\n\nBegin a record expression, pattern, or type.\n\n```sml\nval r = {a = 5, b = \"yep\"}\nval {a, b} = r\ntype user = { name: string, age: int }\n```\n"
            }
            Self::Bar => {
                "Token: `|`\n\n\nSeparate arms in a matcher, constructors in a datatype, or cases in a `fun`.\n\nNote that a leading `|` before the first item is not allowed.\n\n```sml\nfun describe x =\n  case x of\n    0 => \"nothing\"\n  | 1 => \"single\"\n  | 2 => \"pair\"\n  | _ => \"other\"\n\ndatatype ans = Yes | No\n\nfun toBool Yes = true\n  | toBool No = false\n```\n"
            }
            Self::RCurly => "Token: `}`\n\n\nThe companion of `{`.",
            Self::ExceptionKw => {
                "Token: `exception`\n\n\nBegin an exception declaration or specification.\n\nException declarations define new exception constructors, or define an alias for existing exception constructors.\n\n```sml\nexception Foo\nexception Bar of string\nexception Quz = Foo\n```\n\nIn this example:\n\n- `Foo` and `Quz` have type `exn`.\n- `Bar` has type `string -> exn`.\n- `Foo` and `Quz` are the same exception.\n- For some string `s`, `Foo` and `Bar s` are different exceptions.\n- For two strings `s1` and `s2`, iff `s1` and `s2` are the same, then `Bar s1` and `Bar s2` are the same.\n\n`exception` can also be used in signatures as a specification.\n\n```sml\nsignature SIG = sig\n  exception A\n  exception B of int\nend\n```\n\nIn specification context, exception aliases are not allowed.\n"
            }
            Self::SignatureKw => {
                "Token: `signature`\n\n\nBegin a signature declaration.\n\nSignatures describe the interface to structures.\n\n```sml\nsignature SIG = sig\n  type t\n  val x : t\n  exception E\n  datatype foo = Bar | Quz\nend\n```\n\nCompare with `sig`, which begins a signature expression.\n"
            }
            Self::StructureKw => {
                "Token: `structure`\n\n\nBegin a structure declaration or specification.\n\nStructures are collections of declarations.\n\n```sml\nstructure S = struct\n  val num = 3\n  val msg = \"hi\"\nend\n\nval _ = S.num + 5\nval _ = print S.msg\n```\n\n`structure` can also be used in signatures.\n\n```sml\nsignature SIG = sig\n  structure S : LIST\nend\n```\n\nCompare with `struct`, which begins a structure expression.\n"
            }
            Self::DatatypeKw => {
                "Token: `datatype`\n\n\nBegin a datatype declaration, datatype copy declaration, or datatype specification.\n\nA datatype declaration defines a new type and its constructors.\n\n```sml\ndatatype debug =\n  On\n| Off\n| Level of int\n```\n\nIn this example:\n\n- `On` and `Off` have type `debug`.\n- `Level` has type `int -> debug`.\n\n`datatype` can also be used to both create a type alias with all type variables automatically filled in, and bring all constructors into scope. For instance:\n\n```sml\nstructure Tree = struct\n  datatype 'a t =\n    Empty\n  | Node of 'a t * 'a * 'a t\nend\n\ndatatype tree = datatype Tree.t\n\nfun treeSize (t : 'a tree) : int =\n  case t of\n    Empty => 0\n  | Node (l, _, r) => treeSize l + 1 + treeSize r\n```\n\nThe datatype copy declaration has the effect of:\n\n- Defining a type alias (in this case `tree`), with all the right type variables in the right order.\n- Bringing all of the constructors from the right-hand side declaration (if any) into scope.\n\n`datatype` can also be used in signatures. The syntax is the same as the declaration form; datatype copy specifications are not allowed.\n\n```sml\nsignature SIG = sig\n  datatype 'a t =\n    Empty\n  | Node of 'a t * 'a * 'a t\nend\n```\n\nCompare with `type`, which defines a type alias.\n"
            }
            Self::WithtypeKw => {
                "Token: `withtype`\n\n\nUsed with `datatype` (and `abstype`) to add extra helper types into scope at the same time as the datatype. This allows the types to be used in the value constructors.\n\n```sml\ndatatype 'a stream = Nil | Cons of 'a * 'a front\nwithtype 'a front = unit -> 'a stream\n```\n"
            }
            Self::AbstypeKw => {
                "Token: `abstype`\n\n\nBegin an abstract type declaration.\n\nThis is not really used in modern SML. Prefer a mix of:\n\n- `datatype`, for creating new types\n- `structure`, for managing collections of declarations\n- `signature` and ascription, for hiding implementation details\n"
            }
            Self::AndalsoKw => {
                "Token: `andalso`\n\n\nCompute logical \"and\" with two `bool` expressions.\n\n```sml\nfun canRide height age =\n  height > 6 andalso age >= 18\n```\n\nIt short-circuits, so if the first expression evaluates to `false`, the second is not evaluated.\n\nBecause of this special short-circuiting behavior, it is not a regular infix operator, and thus does not work with `op`.\n\nCompare with `and`, which permits declaring multiple things at once.\n"
            }
            Self::FunctorKw => {
                "Token: `functor`\n\n\nBegin a functor declaration.\n\n```sml\nfunctor F (A : sig\n  val x : int\nend) = struct\n  val y = A.x + 123\nend\n```\n\nRegular, \"value-level\" functions (with `fun` or `fn`) take in values and return values.\n\nBy contrast, functors, aka \"structure-level\" functions, take in structures and return structures.\n\nCompare with `fun`, which is for value-level functions.\n"
            }
            Self::IncludeKw => {
                "Token: `include`\n\n\nInclude a signature in another signature, to merge the two signatures together.\n\n```sml\nsignature A = sig\n  val x : int\nend\n\nsignature B = sig\n  include A\n  val y : string\nend\n\nstructure S : B = struct\n  val x = 3\n  val y = \"hi\"\nend\n```\n\nCompare with `open`, which is like `include` but for structures.\n"
            }
            Self::SharingKw => {
                "Token: `sharing`\n\n\nShare types in a signature.\n\n```sml\nsignature FOO = sig\n  type t\n  val foo : t\nend\n\nsignature BAR = sig\n  type t\n  val bar : t\nend\n\nsignature QUZ = sig\n  structure Foo : FOO\n  structure Bar : BAR\n  sharing type Foo.t = Bar.t\nend\n```\n"
            }
            Self::EqtypeKw => {
                "Token: `eqtype`\n\n\nLike `type`, but can only be used in signature specifications. It indicates the type must be an equality type.\n\n```sml\nsignature SIG = sig\n  eqtype t\n  val x : t\nend\n```\n"
            }
            Self::HandleKw => {
                "Token: `handle`\n\n\nHandle exceptions.\n\n```sml\nval _ = (15 + 150) handle Overflow => 0\n```\n\n- If the head expression **does not** raise, the whole expression (i.e. the head expression plus the `handle` clause) evaluates to whatever the head expression did.\n- If the head expression **does** raise, and the exception raised **is** matched by the matcher, the whole expression evaluates to the expression in that corresponding matcher arm.\n- If the head expression **does** raise, and the exception raised **is not** matched, the whole expression raises.\n"
            }
            Self::InfixrKw => {
                "Token: `infixr`\n\n\nCause the given names to be infix operators with the given precedence (or 0 if none is provided), and right associativity.\n\n```sml\ninfixr foo\ninfixr 3 bar quz\n```\n\nCompare with `infix`, which has left associativity.\n"
            }
            Self::NonfixKw => {
                "Token: `nonfix`\n\n\nCause the given names to not be infix.\n\n```sml\nnonfix foo\nnonfix bar quz\n```\n"
            }
            Self::OrelseKw => {
                "Token: `orelse`\n\n\nCompute logical \"or\" with two `bool` expressions.\n\n```sml\nfun canAfford price persuasiveness =\n  price <= 3 orelse persuasiveness >= 75\n```\n\nIt short-circuits, so if the first expression evaluates to `true`, the second is not evaluated.\n\nBecause of this special short-circuiting behavior, it is not a regular infix operator, and thus does not work with `op`.\n"
            }
            Self::StructKw => {
                "Token: `struct`\n\n\nBegin a structure literal expression.\n\nStructure expressions are often used as:\n\n- The right-hand side to structure declarations.\n- The arguments to functors.\n\n```sml\nstructure S = struct\n  val x = 5\nend\n```\n\nCompare with `structure`, which begins a structure declaration.\n"
            }
            Self::InfixKw => {
                "Token: `infix`\n\n\nCause the given names to be infix operators with the given precedence (or 0 if none is provided), and left associativity. Similar to `infixr`.\n\n```sml\ninfix foo\ninfix 3 bar quz\n```\n\nCompare with `infixr`, which has right associativity.\n"
            }
            Self::LocalKw => {
                "Token: `local`\n\n\nLimit the scope of declarations.\n\n```sml\nlocal\n  val inner = 5\nin\n  val outerA = inner + 4\n  val outerB = inner + 9\nend\n\nval _ = outerA + outerB\n```\n\n- Declarations in the `local ... in` may be used by declarations in the `in ... end`.\n- However, only the declarations in the `in ... end` are in scope outside of the local.\n\nCompare with `let`, which is an expression.\n"
            }
            Self::RaiseKw => {
                "Token: `raise`\n\n\nRaise an exception.\n\n```sml\nexception Neg\n\nfun fact n =\n  if n < 0 then\n    raise Neg\n  else if n = 0 then\n    1\n  else\n    n * fact (n - 1)\n```\n\nA raised exception may be handled with `handle`.\n"
            }
            Self::WhereKw => {
                "Token: `where`\n\n\nRealize a type in a signature.\n\nThis allows a type to \"break through\" opaque ascription and be known to users of a structure that ascribes to a signature.\n\n```sml\nsignature SIG = sig\n  type t\n  val x : t\nend\n\nstructure S :> SIG\n  where type t = int =\nstruct\n  type t = int\n  val x = 3\nend\n\nval y = S.x : int\n```\n"
            }
            Self::WhileKw => {
                "Token: `while`\n\n\nRepeatedly evaluate an expression while a condition is upheld.\n\n```sml\nfun sayHi n =\n  let\n    val r = ref 0\n  in\n    while !r < n do (\n      r := !r + 1;\n      print \"hi\"\n    )\n  end\n```\n\nThis feature is \"imperative\", i.e. it essentially requires the use of `ref` or other side effects to be useful.\n"
            }
            Self::CaseKw => {
                "Token: `case`\n\n\nAttempt to match a \"head\" expression against a sequence of patterns, and choose the first expression whose pattern matched.\n\n```sml\nfun describe n =\n  case n of\n    0 => \"nothing\"\n  | 1 => \"solitary\"\n  | 2 => \"pair\"\n  | 3 => \"triple\"\n  | _ => \"something else\"\n```\n"
            }
            Self::ElseKw => {
                "Token: `else`\n\n\nUsed in conjunction with `if` and `then` to mark the expression that the `if` expression evaluates to if the condition was `false`. Comes after `then`.\n\n```sml\nfun choose x =\n  if x then \"yes\" else \"no\"\n```\n"
            }
            Self::OpenKw => {
                "Token: `open`\n\n\nBring a structure's members into scope.\n\n```sml\nstructure S = struct\n  val x = 5\nend\n\nval five = S.x\n\nval ten =\n  let\n    open S\n  in\n    x + x\n  end\n```\n\nCompare with `include`, which is kind of like `open` but for signatures.\n\nTop-level `open` is usually discouraged.\n"
            }
            Self::ThenKw => {
                "Token: `then`\n\n\nUsed in conjunction with `if` and `else` to mark the expression that the `if` expression evaluates to if the condition was `true`. Comes between `if` and `else`.\n\n```sml\nfun choose x =\n  if x then \"yes\" else \"no\"\n```\n"
            }
            Self::TypeKw => {
                "Token: `type`\n\n\nBegin a type alias declaration or type specification.\n\n```sml\ntype point = int * int\n```\n\nTypes defined with `type` are aliases, meaning no \"new\" types are defined. Rather, the new name is just an alternative name for the right-hand-side type, and aside from name, they are equivalent.\n\n`type` can also be used to define a type specification in a signature. In this context, the specification can have a right-hand side or not.\n\n```sml\nsignature S = sig\n  type t\n  type u = t * t\n  val x : t\n  val y : u\nend\n```\n\nCompare with `datatype`, which defines a new type and its constructors.\n"
            }
            Self::WithKw => {
                "Token: `with`\n\n\nUsed in abstype declarations, which is to say, not much.\n"
            }
            Self::AndKw => {
                "Token: `and`\n\n\nDefine many things simultaneously.\n\nMost useful for mutually recursive functions.\n\n```sml\nfun even 0 = true\n  | even n = odd (n - 1)\nand odd 0 = false\n  | odd n = even (n - 1)\n```\n\nCompare with `andalso`, which is for logical \"and\" of `bool` expressions.\n"
            }
            Self::EndKw => {
                "Token: `end`\n\n\nMark the end of various constructs, like:\n\n- `let ... in ... end`\n- `local ... in ... end`\n- `struct ... end`\n- `sig ... end`\n"
            }
            Self::FunKw => {
                "Token: `fun`\n\n\nBegin a function declaration, which may be recursive.\n\n```sml\nfun increment x = x + 1\n\nfun factorial n =\n  case n of\n    0 => 1\n  | _ => n * factorial (n - 1)\n```\n\nFunctions are the unit of abstraction.\n\nCompare with:\n\n- `fn`, which begins a function expression, aka a lambda.\n- `functor`, which defines a functor, aka a structure-level function.\n"
            }
            Self::LetKw => {
                "Token: `let`\n\n\nBegin a let expression.\n\n```sml\nval _ =\n  let\n    val x = 7\n    val y = 5\n  in\n    x + y\n  end\n```\n\nIn the `let ... in`, there is a sequence of declarations. Then, in the `in ... end`, there is an sequence of expressions, separated by `;`.\n\nThe sequence of declarations may be empty, but that's not very useful. The sequence of expressions may not be empty, but often there's just one.\n\nThe `let` expression first defines the declarations in the `let ... in` in sequence, then evaluates the expressions in the `in ... end`.\n\nEach successive declaration in the `let ... in` may use the bindings from the previous declaration. The expressions in the `in ... end` may use all of the bindings from all the declarations.\n\nCompare with `local`, which is a declaration.\n"
            }
            Self::RecKw => {
                "Token: `rec`\n\n\nAllow a `fn` to be recursive.\n\n```sml\nval rec factorial = fn\n  0 => 1\n| n => n * factorial (n - 1)\n```\n\nUsually, `fun` is preferred. (`fun` is syntax sugar for `val rec` and `fn`.)\n\n```sml\nfun factorial n =\n  case n of\n    0 => 1\n  | _ => n * factorial (n - 1)\n```\n"
            }
            Self::SigKw => {
                "Token: `sig`\n\n\nBegin a signature literal expression.\n\nSignature expressions are often used as:\n\n- The right-hand side to signature declarations.\n- The interfaces to functors.\n\n```sml\nsignature SIG = sig\n  type t\n  val x : t\nend\n```\n\nCompare with `signature`, which begins a signature declaration.\n"
            }
            Self::ValKw => {
                "Token: `val`\n\n\nBegin a val declaration or specification.\n\nA value declaration evaluates the expression on the right, then matches it with the pattern on the left, and introduces new bindings produced by the pattern.\n\n```sml\nval y = 6\nval (_, x) = (\"ignored\", \"bound to x\")\n```\n\nVal declarations may be made recursive with `rec`, but only if the expression is a `fn` literal. In this case, usually `fun` is preferred anyway.\n\n`val` can also be used in signature specifications.\n"
            }
            Self::AsKw => {
                "Token: `as`\n\n\nUsed with patterns to match the entire value to a variable.\n\n```sml\nfun f [] = []\n  | f (xs as (_ :: xs')) = xs @ f xs'\n```\n\nThe basic syntax is `<name> as <pat>`, though the `<name>` may also have an optional type annotation, `: <ty>`.\n\n```sml\nval a : int as b = 3\n```\n"
            }
            Self::DoKw => {
                "Token: `do`\n\n\n1. Separate a `while` loop condition from the loop body.\n\n   ```sml\n   val () =\n     while true do\n       print \"y\\n\"\n   ```\n\n2. Begin a `do` declaration, only allowed in Successor ML. `do e` is equivalent to `val () = e`.\n"
            }
            Self::FnKw => {
                "Token: `fn`\n\n\nBegin a function expression, aka a lambda.\n\n```sml\nval _ = List.map (fn x => x + 1) [1, 3, 8]\n```\n\nOften used to define arguments to higher-order functions, to avoid having to declare and name small helper functions.\n\nCompare with `fun`, which is used in function declarations.\n"
            }
            Self::IfKw => {
                "Token: `if`\n\n\nCase on a `bool`.\n\n```sml\nval s =\n  if 3 > 4 then\n    \"math is broken\"\n  else\n    \"this is fine\"\n```\n\nAn if expression cases on a condition of type `bool`, and selects either the `then` expression if the condition was `true`, or the `else` if it was `false`.\n"
            }
            Self::InKw => {
                "Token: `in`\n\n\nSeparate the first and second parts of a `local` declaration or `let` expression.\n\n```sml\nlocal\n  val x = 4\nin\n  val y = x + 6\nend\n\nval _ =\n  let\n    val z = 5\n  in\n    z + 8\n  end\n```\n"
            }
            Self::OfKw => {
                "Token: `of`\n\n\n1. Separate the head expression of a `case` from the arms.\n\n   ```sml\n   fun hm x =\n     case x of\n       1 => 2\n     | _ => 3\n   ```\n\n2. Denote that a value or exception constructor takes an argument.\n\n   ```sml\n   datatype answer =\n     No\n   | Yes\n   | Custom of string\n   ```\n"
            }
            Self::OpKw => {
                "Token: `op`\n\n\nCause an infix identifier to temporarily act as though it is not.\n\n```sml\nval five : int = op+ (2, 3)\n```\n\nIf the infix identifier is \"symbolic\" (`+`, `*`, `@`, etc), then no intervening whitespace between the `op` and the identifier is required.\n\n```sml\nval xs : int list = op@ ([1, 2], [5, 8])\n```\n\nIf not, then intervening whitespace is required.\n\n```sml\nval two = op div (8, 4)\n```\n\nOften used to pass infix operators to higher-order functions.\n\n```sml\nval xs : int list = List.map op* [(1, 4), (6, 8), (2, 3)]\n```\n"
            }
            _ => return None,
        };
        Some(ret)
    }
}
impl token::Triviable for SyntaxKind {
    fn is_trivia(&self) -> bool {
        matches!(* self, Self::Whitespace | Self::BlockComment | Self::Invalid)
    }
}
impl fmt::Display for SyntaxKind {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self.token_desc() {
            None => fmt::Debug::fmt(self, f),
            Some(s) => f.write_str(s),
        }
    }
}
impl From<SyntaxKind> for rowan::SyntaxKind {
    fn from(kind: SyntaxKind) -> Self {
        Self(kind as u16)
    }
}
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum SML {}
impl rowan::Language for SML {
    type Kind = SyntaxKind;
    fn kind_from_raw(raw: rowan::SyntaxKind) -> Self::Kind {
        assert!(raw.0 <= SyntaxKind::TyVarArg as u16);
        unsafe { std::mem::transmute::<u16, SyntaxKind>(raw.0) }
    }
    fn kind_to_raw(kind: Self::Kind) -> rowan::SyntaxKind {
        kind.into()
    }
}
pub type SyntaxNode = rowan::SyntaxNode<SML>;
pub type SyntaxToken = rowan::SyntaxToken<SML>;
pub type SyntaxElement = rowan::SyntaxElement<SML>;
