// This file is @generated by prost-build.
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct HistoryPoint {
    #[prost(float, required, tag = "1")]
    pub x: f32,
    #[prost(float, required, tag = "2")]
    pub y: f32,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Battery {
    #[prost(string, required, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "2")]
    pub vendor: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "3")]
    pub model: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "4")]
    pub serial: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(enumeration = "BatteryType", optional, tag = "5")]
    pub kind: ::core::option::Option<i32>,
    #[prost(enumeration = "BatteryTechnology", optional, tag = "6")]
    pub technology: ::core::option::Option<i32>,
    #[prost(bool, optional, tag = "7")]
    pub power_supply: ::core::option::Option<bool>,
    #[prost(uint32, optional, tag = "8")]
    pub energy_empty: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "9")]
    pub energy_full: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "10")]
    pub energy_full_design: ::core::option::Option<u32>,
    #[prost(float, optional, tag = "11")]
    pub capacity: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "12")]
    pub voltage_min_design: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "13")]
    pub voltage_max_design: ::core::option::Option<f32>,
    #[prost(uint32, optional, tag = "14")]
    pub charge_cycles: ::core::option::Option<u32>,
    #[prost(float, required, tag = "15")]
    pub percentage: f32,
    #[prost(uint32, optional, tag = "16")]
    pub energy: ::core::option::Option<u32>,
    #[prost(float, optional, tag = "17")]
    pub voltage: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "18")]
    pub power: ::core::option::Option<f32>,
    #[prost(uint32, optional, tag = "19")]
    pub time_to_full: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "20")]
    pub time_to_empty: ::core::option::Option<u32>,
    #[prost(string, optional, tag = "21")]
    pub icon_name: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(enumeration = "BatteryState", optional, tag = "22")]
    pub state: ::core::option::Option<i32>,
    #[prost(float, optional, tag = "23")]
    pub temp: ::core::option::Option<f32>,
    #[prost(bool, required, tag = "24")]
    pub charge_threshold_enabled: bool,
    #[prost(uint32, required, tag = "25")]
    pub charge_threshold_supported: u32,
    #[prost(uint32, optional, tag = "26")]
    pub charge_start_threshold: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "27")]
    pub charge_end_threshold: ::core::option::Option<u32>,
    #[prost(message, repeated, tag = "28")]
    pub history: ::prost::alloc::vec::Vec<HistoryPoint>,
    #[prost(bool, required, tag = "29")]
    pub history_changed: bool,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct BatteryRequest {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BatteryResponse {
    #[prost(oneof = "battery_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<battery_response::Response>,
}
/// Nested message and enum types in `BatteryResponse`.
pub mod battery_response {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BatteryList {
        #[prost(message, repeated, tag = "1")]
        pub batteries: ::prost::alloc::vec::Vec<super::Battery>,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Response {
        #[prost(message, tag = "1")]
        Batteries(BatteryList),
        #[prost(message, tag = "2")]
        Error(super::BatteryResponseError),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct BatteryResponseError {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum BatteryState {
    Charging = 1,
    Discharging = 2,
    Empty = 3,
    FullyCharged = 4,
    PendingCharge = 5,
    PendingDischarge = 6,
}
impl BatteryState {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Charging => "Charging",
            Self::Discharging => "Discharging",
            Self::Empty => "Empty",
            Self::FullyCharged => "FullyCharged",
            Self::PendingCharge => "PendingCharge",
            Self::PendingDischarge => "PendingDischarge",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Charging" => Some(Self::Charging),
            "Discharging" => Some(Self::Discharging),
            "Empty" => Some(Self::Empty),
            "FullyCharged" => Some(Self::FullyCharged),
            "PendingCharge" => Some(Self::PendingCharge),
            "PendingDischarge" => Some(Self::PendingDischarge),
            _ => None,
        }
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum BatteryType {
    LinePower = 1,
    Bat = 2,
    Ups = 3,
    Monitor = 4,
    Mouse = 5,
    Keyboard = 6,
    Pda = 7,
    Phone = 8,
    MediaPlayer = 9,
    Tablet = 10,
    Computer = 11,
    GamingInput = 12,
    Pen = 13,
    Touchpad = 14,
    Modem = 15,
    Network = 16,
    Headset = 17,
    Speakers = 18,
    Headphones = 19,
    Video = 20,
    OtherAudio = 21,
    RemoteControl = 22,
    Printer = 23,
    Scanner = 24,
    Camera = 25,
    Wearable = 26,
    Toy = 27,
    BluetoothGeneric = 28,
}
impl BatteryType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::LinePower => "LinePower",
            Self::Bat => "Bat",
            Self::Ups => "Ups",
            Self::Monitor => "Monitor",
            Self::Mouse => "Mouse",
            Self::Keyboard => "Keyboard",
            Self::Pda => "Pda",
            Self::Phone => "Phone",
            Self::MediaPlayer => "MediaPlayer",
            Self::Tablet => "Tablet",
            Self::Computer => "Computer",
            Self::GamingInput => "GamingInput",
            Self::Pen => "Pen",
            Self::Touchpad => "Touchpad",
            Self::Modem => "Modem",
            Self::Network => "Network",
            Self::Headset => "Headset",
            Self::Speakers => "Speakers",
            Self::Headphones => "Headphones",
            Self::Video => "Video",
            Self::OtherAudio => "OtherAudio",
            Self::RemoteControl => "RemoteControl",
            Self::Printer => "Printer",
            Self::Scanner => "Scanner",
            Self::Camera => "Camera",
            Self::Wearable => "Wearable",
            Self::Toy => "Toy",
            Self::BluetoothGeneric => "BluetoothGeneric",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "LinePower" => Some(Self::LinePower),
            "Bat" => Some(Self::Bat),
            "Ups" => Some(Self::Ups),
            "Monitor" => Some(Self::Monitor),
            "Mouse" => Some(Self::Mouse),
            "Keyboard" => Some(Self::Keyboard),
            "Pda" => Some(Self::Pda),
            "Phone" => Some(Self::Phone),
            "MediaPlayer" => Some(Self::MediaPlayer),
            "Tablet" => Some(Self::Tablet),
            "Computer" => Some(Self::Computer),
            "GamingInput" => Some(Self::GamingInput),
            "Pen" => Some(Self::Pen),
            "Touchpad" => Some(Self::Touchpad),
            "Modem" => Some(Self::Modem),
            "Network" => Some(Self::Network),
            "Headset" => Some(Self::Headset),
            "Speakers" => Some(Self::Speakers),
            "Headphones" => Some(Self::Headphones),
            "Video" => Some(Self::Video),
            "OtherAudio" => Some(Self::OtherAudio),
            "RemoteControl" => Some(Self::RemoteControl),
            "Printer" => Some(Self::Printer),
            "Scanner" => Some(Self::Scanner),
            "Camera" => Some(Self::Camera),
            "Wearable" => Some(Self::Wearable),
            "Toy" => Some(Self::Toy),
            "BluetoothGeneric" => Some(Self::BluetoothGeneric),
            _ => None,
        }
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum BatteryTechnology {
    Unknown = 0,
    LithiumIon = 1,
    LithiumPolymer = 2,
    LithiumIronPhosphate = 3,
    LeadAcid = 4,
    NickelCadmium = 5,
    NickelMetalHydride = 6,
}
impl BatteryTechnology {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unknown => "Unknown",
            Self::LithiumIon => "LithiumIon",
            Self::LithiumPolymer => "LithiumPolymer",
            Self::LithiumIronPhosphate => "LithiumIronPhosphate",
            Self::LeadAcid => "LeadAcid",
            Self::NickelCadmium => "NickelCadmium",
            Self::NickelMetalHydride => "NickelMetalHydride",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Unknown" => Some(Self::Unknown),
            "LithiumIon" => Some(Self::LithiumIon),
            "LithiumPolymer" => Some(Self::LithiumPolymer),
            "LithiumIronPhosphate" => Some(Self::LithiumIronPhosphate),
            "LeadAcid" => Some(Self::LeadAcid),
            "NickelCadmium" => Some(Self::NickelCadmium),
            "NickelMetalHydride" => Some(Self::NickelMetalHydride),
            _ => None,
        }
    }
}
