/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

#include "mpi_fortimpl.h"


#ifdef F77_NAME_UPPER
#define mpirinitc_ MPIRINITC
#elif defined(F77_NAME_LOWER_2USCORE) || defined(F77_NAME_LOWER_USCORE)
/* leave name alone */
#else
#define mpirinitc_ mpirinitc
#endif
/* These functions are called from Fortran so only need prototypes in
   this file.  Note that the second-to-last argument is a character array, so
   we need to include the elements of the Fortran character "dope vector".
*/
FORT_DLL_SPEC void FORT_CALL mpirinitc_(void *si, void *ssi,
                                        void *bt, void *ip, void *c_ba,
                                        void *uw, void *ecsi,
                                        void *an FORT_MIXED_LEN(d1),
                                        void *asn FORT_MIXED_LEN(d1),
                                        void *we FORT_END_LEN(d1) FORT_END_LEN(d2));

/*
    # MPI-2, section 4.12.5, on the declaration of MPI_F_STATUS_IGNORE
    # MPI_F_STATUSES_IGNORE as global variables in mpi.h (!)
*/
int MPIR_F_NeedInit = 1;
void *MPIR_F_MPI_BOTTOM = 0;
void *MPIR_F_MPI_IN_PLACE = 0;
void *MPIR_F_MPI_BUFFER_AUTOMATIC = 0;
void *MPIR_F_MPI_UNWEIGHTED = 0;
/* MPI_F_STATUS_IGNORE etc must be declared within mpi.h (MPI-2 standard
   requires this) */
/*
void *MPI_F_STATUS_IGNORE   = 0;
void *MPI_F_STATUSES_IGNORE = 0;
*/
MPI_Fint *MPI_F_ERRCODES_IGNORE = 0;
void *MPI_F_ARGV_NULL = 0;
void *MPI_F_ARGVS_NULL = 0;
void *MPIR_F_MPI_WEIGHTS_EMPTY = 0;

FORT_DLL_SPEC void FORT_CALL mpirinitc_(void *si, void *ssi,
                                        void *bt, void *ip, void *c_ba,
                                        void *uw, void *ecsi,
                                        void *an FORT_MIXED_LEN(d1),
                                        void *asn FORT_MIXED_LEN(d1),
                                        void *we FORT_END_LEN(d1) FORT_END_LEN(d2))
{
    MPI_F_STATUS_IGNORE = (MPI_Fint *) si;
    MPI_F_STATUSES_IGNORE = (MPI_Fint *) ssi;
    MPIR_F_MPI_BOTTOM = bt;
    MPIR_F_MPI_IN_PLACE = ip;
    MPIR_F_MPI_BUFFER_AUTOMATIC = c_ba;
    MPIR_F_MPI_UNWEIGHTED = uw;
    MPI_F_ERRCODES_IGNORE = (MPI_Fint *) ecsi;
    MPI_F_ARGV_NULL = an;
    MPI_F_ARGVS_NULL = asn;
    MPIR_F_MPI_WEIGHTS_EMPTY = we;
}

/*
   Enable all known common block symbols mangling to be alias to each other,
   i.e. [_C]mpifcmb*[_]to one symbol, mpifcmb*r.
   Each common block is defined for one MPI Fortran special constant.
   This is done to avoid alignment problem.
*/

#if defined(HAVE_C_MULTI_ATTR_ALIAS)

struct mpif_cmblk1_t_ {
    MPI_Fint MPIF_STATUS_IGNORE[MPI_F_STATUS_SIZE];
};
typedef struct mpif_cmblk1_t_ mpif_cmblk1_t;
/* *INDENT-OFF* */
/* The initializer is necessary for the alias to work -- cannot alias to a common symbol.
 * The ugly double braces are necessary to silence warnings (due to the first element in
 * the struct is of a compound type).
 */
mpif_cmblk1_t mpifcmb1r  = {{0}};
/* *INDENT-ON* */
extern mpif_cmblk1_t _CMPIFCMB1 __attribute__ ((alias("mpifcmb1r")));
extern mpif_cmblk1_t MPIFCMB1 __attribute__ ((alias("mpifcmb1r")));
extern mpif_cmblk1_t MPIFCMB1_ __attribute__ ((alias("mpifcmb1r")));
extern mpif_cmblk1_t _Cmpifcmb1 __attribute__ ((alias("mpifcmb1r")));
extern mpif_cmblk1_t mpifcmb1 __attribute__ ((alias("mpifcmb1r")));
extern mpif_cmblk1_t mpifcmb1_ __attribute__ ((alias("mpifcmb1r")));

struct mpif_cmblk2_t_ {
    MPI_Fint MPIF_STATUSES_IGNORE[1][MPI_F_STATUS_SIZE];
};
typedef struct mpif_cmblk2_t_ mpif_cmblk2_t;
/* *INDENT-OFF* */
mpif_cmblk2_t mpifcmb2r  = {{{0}}};
/* *INDENT-ON* */
extern mpif_cmblk2_t _CMPIFCMB2 __attribute__ ((alias("mpifcmb2r")));
extern mpif_cmblk2_t MPIFCMB2 __attribute__ ((alias("mpifcmb2r")));
extern mpif_cmblk2_t MPIFCMB2_ __attribute__ ((alias("mpifcmb2r")));
extern mpif_cmblk2_t _Cmpifcmb2 __attribute__ ((alias("mpifcmb2r")));
extern mpif_cmblk2_t mpifcmb2 __attribute__ ((alias("mpifcmb2r")));
extern mpif_cmblk2_t mpifcmb2_ __attribute__ ((alias("mpifcmb2r")));

struct mpif_cmblk3_t_ {
    MPI_Fint MPIF_BOTTOM;
};
typedef struct mpif_cmblk3_t_ mpif_cmblk3_t;
/* *INDENT-OFF* */
mpif_cmblk3_t mpifcmb3r  = {0};
/* *INDENT-ON* */
extern mpif_cmblk3_t _CMPIFCMB3 __attribute__ ((alias("mpifcmb3r")));
extern mpif_cmblk3_t MPIFCMB3 __attribute__ ((alias("mpifcmb3r")));
extern mpif_cmblk3_t MPIFCMB3_ __attribute__ ((alias("mpifcmb3r")));
extern mpif_cmblk3_t _Cmpifcmb3 __attribute__ ((alias("mpifcmb3r")));
extern mpif_cmblk3_t mpifcmb3 __attribute__ ((alias("mpifcmb3r")));
extern mpif_cmblk3_t mpifcmb3_ __attribute__ ((alias("mpifcmb3r")));

struct mpif_cmblk4_t_ {
    MPI_Fint MPIF_IN_PLACE;
};
typedef struct mpif_cmblk4_t_ mpif_cmblk4_t;
/* *INDENT-OFF* */
mpif_cmblk4_t mpifcmb4r  = {0};
/* *INDENT-ON* */
extern mpif_cmblk4_t _CMPIFCMB4 __attribute__ ((alias("mpifcmb4r")));
extern mpif_cmblk4_t MPIFCMB4 __attribute__ ((alias("mpifcmb4r")));
extern mpif_cmblk4_t MPIFCMB4_ __attribute__ ((alias("mpifcmb4r")));
extern mpif_cmblk4_t _Cmpifcmb4 __attribute__ ((alias("mpifcmb4r")));
extern mpif_cmblk4_t mpifcmb4 __attribute__ ((alias("mpifcmb4r")));
extern mpif_cmblk4_t mpifcmb4_ __attribute__ ((alias("mpifcmb4r")));

struct mpif_cmblk5_t_ {
    MPI_Fint MPIF_UNWEIGHTED;
};
typedef struct mpif_cmblk5_t_ mpif_cmblk5_t;
/* *INDENT-OFF* */
FORT_DLL_SPEC mpif_cmblk5_t mpifcmb5r  = {0};
/* *INDENT-ON* */
extern FORT_DLL_SPEC mpif_cmblk5_t _CMPIFCMB5 __attribute__ ((alias("mpifcmb5r")));
extern FORT_DLL_SPEC mpif_cmblk5_t MPIFCMB5 __attribute__ ((alias("mpifcmb5r")));
extern FORT_DLL_SPEC mpif_cmblk5_t MPIFCMB5_ __attribute__ ((alias("mpifcmb5r")));
extern FORT_DLL_SPEC mpif_cmblk5_t _Cmpifcmb5 __attribute__ ((alias("mpifcmb5r")));
extern FORT_DLL_SPEC mpif_cmblk5_t mpifcmb5 __attribute__ ((alias("mpifcmb5r")));
extern FORT_DLL_SPEC mpif_cmblk5_t mpifcmb5_ __attribute__ ((alias("mpifcmb5r")));

struct mpif_cmblk6_t_ {
    MPI_Fint MPIF_ERRCODES_IGNORE[1];
};
typedef struct mpif_cmblk6_t_ mpif_cmblk6_t;
/* *INDENT-OFF* */
mpif_cmblk6_t mpifcmb6r  = {{0}};
/* *INDENT-ON* */
extern mpif_cmblk6_t _CMPIFCMB6 __attribute__ ((alias("mpifcmb6r")));
extern mpif_cmblk6_t MPIFCMB6 __attribute__ ((alias("mpifcmb6r")));
extern mpif_cmblk6_t MPIFCMB6_ __attribute__ ((alias("mpifcmb6r")));
extern mpif_cmblk6_t _Cmpifcmb6 __attribute__ ((alias("mpifcmb6r")));
extern mpif_cmblk6_t mpifcmb6 __attribute__ ((alias("mpifcmb6r")));
extern mpif_cmblk6_t mpifcmb6_ __attribute__ ((alias("mpifcmb6r")));

struct mpif_cmblk7_t_ {
    char MPIF_ARGVS_NULL[1][1];
    char pads[3];
};
typedef struct mpif_cmblk7_t_ mpif_cmblk7_t;
/* *INDENT-OFF* */
mpif_cmblk7_t mpifcmb7r  = {{{0}},{0}};
/* *INDENT-ON* */
extern mpif_cmblk7_t _CMPIFCMB7 __attribute__ ((alias("mpifcmb7r")));
extern mpif_cmblk7_t MPIFCMB7 __attribute__ ((alias("mpifcmb7r")));
extern mpif_cmblk7_t MPIFCMB7_ __attribute__ ((alias("mpifcmb7r")));
extern mpif_cmblk7_t _Cmpifcmb7 __attribute__ ((alias("mpifcmb7r")));
extern mpif_cmblk7_t mpifcmb7 __attribute__ ((alias("mpifcmb7r")));
extern mpif_cmblk7_t mpifcmb7_ __attribute__ ((alias("mpifcmb7r")));

struct mpif_cmblk8_t_ {
    char MPIF_ARGV_NULL[1];
    char pads[3];
};
typedef struct mpif_cmblk8_t_ mpif_cmblk8_t;
/* *INDENT-OFF* */
mpif_cmblk8_t mpifcmb8r  = {{0},{0}};
/* *INDENT-ON* */
extern mpif_cmblk8_t _CMPIFCMB8 __attribute__ ((alias("mpifcmb8r")));
extern mpif_cmblk8_t MPIFCMB8 __attribute__ ((alias("mpifcmb8r")));
extern mpif_cmblk8_t MPIFCMB8_ __attribute__ ((alias("mpifcmb8r")));
extern mpif_cmblk8_t _Cmpifcmb8 __attribute__ ((alias("mpifcmb8r")));
extern mpif_cmblk8_t mpifcmb8 __attribute__ ((alias("mpifcmb8r")));
extern mpif_cmblk8_t mpifcmb8_ __attribute__ ((alias("mpifcmb8r")));

struct mpif_cmblk9_t_ {
    MPI_Fint MPIF_WEIGHTS_EMPTY;
};
typedef struct mpif_cmblk9_t_ mpif_cmblk9_t;
/* *INDENT-OFF* */
FORT_DLL_SPEC mpif_cmblk9_t mpifcmb9r  = {0};
/* *INDENT-ON* */
extern FORT_DLL_SPEC mpif_cmblk9_t _CMPIFCMB9 __attribute__ ((alias("mpifcmb9r")));
extern FORT_DLL_SPEC mpif_cmblk9_t MPIFCMB9 __attribute__ ((alias("mpifcmb9r")));
extern FORT_DLL_SPEC mpif_cmblk9_t MPIFCMB9_ __attribute__ ((alias("mpifcmb9r")));
extern FORT_DLL_SPEC mpif_cmblk9_t _Cmpifcmb9 __attribute__ ((alias("mpifcmb9r")));
extern FORT_DLL_SPEC mpif_cmblk9_t mpifcmb9 __attribute__ ((alias("mpifcmb9r")));
extern FORT_DLL_SPEC mpif_cmblk9_t mpifcmb9_ __attribute__ ((alias("mpifcmb9r")));

#endif
