static const struct { const char *name; OptIndex opt_idx; } option_hash_elems[] = {
  { .name = "pa", .opt_idx = kOptPath },
  { .name = "ma", .opt_idx = kOptModifiable },
  { .name = "wa", .opt_idx = kOptWriteany },
  { .name = "ea", .opt_idx = kOptEqualalways },
  { .name = "vb", .opt_idx = kOptVisualbell },
  { .name = "cb", .opt_idx = kOptClipboard },
  { .name = "wb", .opt_idx = kOptWritebackup },
  { .name = "pb", .opt_idx = kOptPumblend },
  { .name = "sb", .opt_idx = kOptSplitbelow },
  { .name = "eb", .opt_idx = kOptErrorbells },
  { .name = "sc", .opt_idx = kOptShowcmd },
  { .name = "uc", .opt_idx = kOptUpdatecount },
  { .name = "wc", .opt_idx = kOptWildchar },
  { .name = "ic", .opt_idx = kOptIgnorecase },
  { .name = "ac", .opt_idx = kOptAutocomplete },
  { .name = "tc", .opt_idx = kOptTagcase },
  { .name = "cc", .opt_idx = kOptColorcolumn },
  { .name = "wd", .opt_idx = kOptWritedelay },
  { .name = "cd", .opt_idx = kOptCdpath },
  { .name = "ed", .opt_idx = kOptEdcompatible },
  { .name = "sd", .opt_idx = kOptShada },
  { .name = "gd", .opt_idx = kOptGdefault },
  { .name = "ve", .opt_idx = kOptVirtualedit },
  { .name = "qe", .opt_idx = kOptQuoteescape },
  { .name = "re", .opt_idx = kOptRegexpengine },
  { .name = "tf", .opt_idx = kOptTtyfast },
  { .name = "hf", .opt_idx = kOptHelpfile },
  { .name = "nf", .opt_idx = kOptNrformats },
  { .name = "ef", .opt_idx = kOptErrorfile },
  { .name = "ff", .opt_idx = kOptFileformat },
  { .name = "cf", .opt_idx = kOptConfirm },
  { .name = "dg", .opt_idx = kOptDigraph },
  { .name = "bg", .opt_idx = kOptBackground },
  { .name = "hh", .opt_idx = kOptHelpheight },
  { .name = "mh", .opt_idx = kOptMousehide },
  { .name = "wh", .opt_idx = kOptWinheight },
  { .name = "ph", .opt_idx = kOptPumheight },
  { .name = "bh", .opt_idx = kOptBufhidden },
  { .name = "sh", .opt_idx = kOptShell },
  { .name = "ch", .opt_idx = kOptCmdheight },
  { .name = "ci", .opt_idx = kOptCopyindent },
  { .name = "si", .opt_idx = kOptSmartindent },
  { .name = "hi", .opt_idx = kOptHistory },
  { .name = "wi", .opt_idx = kOptWindow },
  { .name = "ri", .opt_idx = kOptRevins },
  { .name = "ei", .opt_idx = kOptEventignore },
  { .name = "vi", .opt_idx = kOptShada },
  { .name = "pi", .opt_idx = kOptPreserveindent },
  { .name = "ai", .opt_idx = kOptAutoindent },
  { .name = "sj", .opt_idx = kOptScrolljump },
  { .name = "bk", .opt_idx = kOptBackup },
  { .name = "hk", .opt_idx = kOptHkmap },
  { .name = "ul", .opt_idx = kOptUndolevels },
  { .name = "ml", .opt_idx = kOptModeline },
  { .name = "bl", .opt_idx = kOptBuflisted },
  { .name = "rl", .opt_idx = kOptRightleft },
  { .name = "al", .opt_idx = kOptAleph },
  { .name = "tl", .opt_idx = kOptTaglength },
  { .name = "hl", .opt_idx = kOptHighlight },
  { .name = "pm", .opt_idx = kOptPatchmode },
  { .name = "wm", .opt_idx = kOptWrapmargin },
  { .name = "tm", .opt_idx = kOptTimeoutlen },
  { .name = "sm", .opt_idx = kOptShowmatch },
  { .name = "im", .opt_idx = kOptInsertmode },
  { .name = "km", .opt_idx = kOptKeymodel },
  { .name = "lm", .opt_idx = kOptLangmenu },
  { .name = "to", .opt_idx = kOptTimeout },
  { .name = "ro", .opt_idx = kOptReadonly },
  { .name = "so", .opt_idx = kOptScrolloff },
  { .name = "bo", .opt_idx = kOptBelloff },
  { .name = "go", .opt_idx = kOptGuioptions },
  { .name = "fo", .opt_idx = kOptFormatoptions },
  { .name = "co", .opt_idx = kOptColumns },
  { .name = "pp", .opt_idx = kOptPackpath },
  { .name = "mp", .opt_idx = kOptMakeprg },
  { .name = "gp", .opt_idx = kOptGrepprg },
  { .name = "ep", .opt_idx = kOptEqualprg },
  { .name = "fp", .opt_idx = kOptFormatprg },
  { .name = "kp", .opt_idx = kOptKeywordprg },
  { .name = "cp", .opt_idx = kOptCompatible },
  { .name = "sp", .opt_idx = kOptShellpipe },
  { .name = "ur", .opt_idx = kOptUndoreload },
  { .name = "tr", .opt_idx = kOptTagrelative },
  { .name = "ar", .opt_idx = kOptAutoread },
  { .name = "sr", .opt_idx = kOptShiftround },
  { .name = "ss", .opt_idx = kOptSidescroll },
  { .name = "ws", .opt_idx = kOptWrapscan },
  { .name = "ts", .opt_idx = kOptTabstop },
  { .name = "bs", .opt_idx = kOptBackspace },
  { .name = "ls", .opt_idx = kOptLaststatus },
  { .name = "is", .opt_idx = kOptIncsearch },
  { .name = "js", .opt_idx = kOptJoinspaces },
  { .name = "fs", .opt_idx = kOptFsync },
  { .name = "pt", .opt_idx = kOptPastetoggle },
  { .name = "ut", .opt_idx = kOptUpdatetime },
  { .name = "bt", .opt_idx = kOptBuftype },
  { .name = "et", .opt_idx = kOptExpandtab },
  { .name = "ft", .opt_idx = kOptFiletype },
  { .name = "nu", .opt_idx = kOptNumber },
  { .name = "su", .opt_idx = kOptSuffixes },
  { .name = "ru", .opt_idx = kOptRuler },
  { .name = "lw", .opt_idx = kOptLispwords },
  { .name = "ww", .opt_idx = kOptWhichwrap },
  { .name = "tw", .opt_idx = kOptTextwidth },
  { .name = "pw", .opt_idx = kOptPumwidth },
  { .name = "sw", .opt_idx = kOptShiftwidth },
  { .name = "aw", .opt_idx = kOptAutowrite },
  { .name = "ex", .opt_idx = kOptExrc },
  { .name = "dy", .opt_idx = kOptDisplay },
  { .name = "lz", .opt_idx = kOptLazyredraw },
  { .name = "sta", .opt_idx = kOptSmarttab },
  { .name = "sua", .opt_idx = kOptSuffixesadd },
  { .name = "dia", .opt_idx = kOptDiffanchors },
  { .name = "cia", .opt_idx = kOptCompleteitemalign },
  { .name = "awa", .opt_idx = kOptAutowriteall },
  { .name = "crb", .opt_idx = kOptCursorbind },
  { .name = "wfb", .opt_idx = kOptWinfixbuf },
  { .name = "swb", .opt_idx = kOptSwitchbuf },
  { .name = "scb", .opt_idx = kOptScrollbind },
  { .name = "rdb", .opt_idx = kOptRedrawdebug },
  { .name = "cuc", .opt_idx = kOptCursorcolumn },
  { .name = "msc", .opt_idx = kOptMaxsearchcount },
  { .name = "wic", .opt_idx = kOptWildignorecase },
  { .name = "bkc", .opt_idx = kOptBackupcopy },
  { .name = "tgc", .opt_idx = kOptTermguicolors },
  { .name = "stc", .opt_idx = kOptStatuscolumn },
  { .name = "rlc", .opt_idx = kOptRightleftcmd },
  { .name = "spc", .opt_idx = kOptSpellcapcheck },
  { .name = "enc", .opt_idx = kOptEncoding },
  { .name = "fdc", .opt_idx = kOptFoldcolumn },
  { .name = "fic", .opt_idx = kOptFileignorecase },
  { .name = "inc", .opt_idx = kOptInclude },
  { .name = "smc", .opt_idx = kOptSynmaxcol },
  { .name = "imc", .opt_idx = kOptImcmdline },
  { .name = "smd", .opt_idx = kOptShowmode },
  { .name = "mfd", .opt_idx = kOptMaxfuncdepth },
  { .name = "mod", .opt_idx = kOptModified },
  { .name = "ead", .opt_idx = kOptEadirection },
  { .name = "hid", .opt_idx = kOptHidden },
  { .name = "imd", .opt_idx = kOptImdisable },
  { .name = "acd", .opt_idx = kOptAutochdir },
  { .name = "mmd", .opt_idx = kOptMaxmapdepth },
  { .name = "mle", .opt_idx = kOptModelineexpr },
  { .name = "sxe", .opt_idx = kOptShellxescape },
  { .name = "fde", .opt_idx = kOptFoldexpr },
  { .name = "udf", .opt_idx = kOptUndofile },
  { .name = "mef", .opt_idx = kOptMakeef },
  { .name = "tpf", .opt_idx = kOptTermpastefilter },
  { .name = "swf", .opt_idx = kOptSwapfile },
  { .name = "def", .opt_idx = kOptDefine },
  { .name = "ruf", .opt_idx = kOptRulerformat },
  { .name = "eof", .opt_idx = kOptEndoffile },
  { .name = "spf", .opt_idx = kOptSpellfile },
  { .name = "sdf", .opt_idx = kOptShadafile },
  { .name = "vif", .opt_idx = kOptShadafile },
  { .name = "inf", .opt_idx = kOptInfercase },
  { .name = "isf", .opt_idx = kOptIsfname },
  { .name = "hlg", .opt_idx = kOptHelplang },
  { .name = "wig", .opt_idx = kOptWildignore },
  { .name = "tag", .opt_idx = kOptTags },
  { .name = "wfh", .opt_idx = kOptWinfixheight },
  { .name = "wmh", .opt_idx = kOptWinminheight },
  { .name = "pvh", .opt_idx = kOptPreviewheight },
  { .name = "cdh", .opt_idx = kOptCdhome },
  { .name = "cwh", .opt_idx = kOptCmdwinheight },
  { .name = "isi", .opt_idx = kOptIsident },
  { .name = "bri", .opt_idx = kOptBreakindent },
  { .name = "chi", .opt_idx = kOptChistory },
  { .name = "fdi", .opt_idx = kOptFoldignore },
  { .name = "imi", .opt_idx = kOptIminsert },
  { .name = "ari", .opt_idx = kOptAllowrevins },
  { .name = "lhi", .opt_idx = kOptLhistory },
  { .name = "wak", .opt_idx = kOptWinaltkeys },
  { .name = "bsk", .opt_idx = kOptBackupskip },
  { .name = "brk", .opt_idx = kOptBreakat },
  { .name = "spk", .opt_idx = kOptSplitkeep },
  { .name = "isk", .opt_idx = kOptIskeyword },
  { .name = "fml", .opt_idx = kOptFoldminlines },
  { .name = "cul", .opt_idx = kOptCursorline },
  { .name = "scl", .opt_idx = kOptSigncolumn },
  { .name = "lpl", .opt_idx = kOptLoadplugins },
  { .name = "tal", .opt_idx = kOptTabline },
  { .name = "tcl", .opt_idx = kOptTabclose },
  { .name = "stl", .opt_idx = kOptStatusline },
  { .name = "sol", .opt_idx = kOptStartofline },
  { .name = "spl", .opt_idx = kOptSpelllang },
  { .name = "sel", .opt_idx = kOptSelection },
  { .name = "fcl", .opt_idx = kOptFoldclose },
  { .name = "acl", .opt_idx = kOptAutocompletedelay },
  { .name = "eol", .opt_idx = kOptEndofline },
  { .name = "ssl", .opt_idx = kOptShellslash },
  { .name = "gtl", .opt_idx = kOptGuitablabel },
  { .name = "csl", .opt_idx = kOptCompleteslash },
  { .name = "fdl", .opt_idx = kOptFoldlevel },
  { .name = "fdm", .opt_idx = kOptFoldmethod },
  { .name = "msm", .opt_idx = kOptMkspellmem },
  { .name = "wcm", .opt_idx = kOptWildcharm },
  { .name = "ttm", .opt_idx = kOptTtimeoutlen },
  { .name = "tpm", .opt_idx = kOptTabpagemax },
  { .name = "slm", .opt_idx = kOptSelectmode },
  { .name = "efm", .opt_idx = kOptErrorformat },
  { .name = "wim", .opt_idx = kOptWildmode },
  { .name = "gfm", .opt_idx = kOptGrepformat },
  { .name = "com", .opt_idx = kOptComments },
  { .name = "icm", .opt_idx = kOptInccommand },
  { .name = "lrm", .opt_idx = kOptLangremap },
  { .name = "shm", .opt_idx = kOptShortmess },
  { .name = "bin", .opt_idx = kOptBinary },
  { .name = "cin", .opt_idx = kOptCindent },
  { .name = "fen", .opt_idx = kOptFoldenable },
  { .name = "gfn", .opt_idx = kOptGuifont },
  { .name = "fdn", .opt_idx = kOptFoldnestmax },
  { .name = "syn", .opt_idx = kOptSyntax },
  { .name = "cpo", .opt_idx = kOptCpoptions },
  { .name = "mco", .opt_idx = kOptMaxcombine },
  { .name = "spo", .opt_idx = kOptSpelloptions },
  { .name = "sbo", .opt_idx = kOptScrollopt },
  { .name = "emo", .opt_idx = kOptEmoji },
  { .name = "fdo", .opt_idx = kOptFoldopen },
  { .name = "cto", .opt_idx = kOptCompletetimeout },
  { .name = "top", .opt_idx = kOptTildeop },
  { .name = "vop", .opt_idx = kOptViewoptions },
  { .name = "lop", .opt_idx = kOptLispoptions },
  { .name = "wop", .opt_idx = kOptWildoptions },
  { .name = "dip", .opt_idx = kOptDiffopt },
  { .name = "cmp", .opt_idx = kOptCasemap },
  { .name = "rtp", .opt_idx = kOptRuntimepath },
  { .name = "hkp", .opt_idx = kOptHkmapp },
  { .name = "isp", .opt_idx = kOptIsprint },
  { .name = "jop", .opt_idx = kOptJumpoptions },
  { .name = "flp", .opt_idx = kOptFormatlistpat },
  { .name = "kmp", .opt_idx = kOptKeymap },
  { .name = "mmp", .opt_idx = kOptMaxmempattern },
  { .name = "lsp", .opt_idx = kOptLinespace },
  { .name = "shq", .opt_idx = kOptShellquote },
  { .name = "sxq", .opt_idx = kOptShellxquote },
  { .name = "fmr", .opt_idx = kOptFoldmarker },
  { .name = "wbr", .opt_idx = kOptWinbar },
  { .name = "tsr", .opt_idx = kOptThesaurus },
  { .name = "sbr", .opt_idx = kOptShowbreak },
  { .name = "spr", .opt_idx = kOptSplitright },
  { .name = "scr", .opt_idx = kOptScroll },
  { .name = "gcr", .opt_idx = kOptGuicursor },
  { .name = "lnr", .opt_idx = kOptLangnoremap },
  { .name = "srr", .opt_idx = kOptShellredir },
  { .name = "lbr", .opt_idx = kOptLinebreak },
  { .name = "dir", .opt_idx = kOptDirectory },
  { .name = "scs", .opt_idx = kOptSmartcase },
  { .name = "vts", .opt_idx = kOptVartabstop },
  { .name = "vbs", .opt_idx = kOptVerbose },
  { .name = "lcs", .opt_idx = kOptListchars },
  { .name = "mps", .opt_idx = kOptMatchpairs },
  { .name = "mis", .opt_idx = kOptMenuitems },
  { .name = "mls", .opt_idx = kOptModelines },
  { .name = "tbs", .opt_idx = kOptTagbsearch },
  { .name = "cms", .opt_idx = kOptCommentstring },
  { .name = "sms", .opt_idx = kOptSmoothscroll },
  { .name = "sts", .opt_idx = kOptSofttabstop },
  { .name = "hls", .opt_idx = kOptHlsearch },
  { .name = "sps", .opt_idx = kOptSpellsuggest },
  { .name = "ffs", .opt_idx = kOptFileformats },
  { .name = "fcs", .opt_idx = kOptFillchars },
  { .name = "ims", .opt_idx = kOptImsearch },
  { .name = "mat", .opt_idx = kOptMatchtime },
  { .name = "gtt", .opt_idx = kOptGuitabtooltip },
  { .name = "sft", .opt_idx = kOptShowfulltag },
  { .name = "act", .opt_idx = kOptAutocompletetimeout },
  { .name = "fdt", .opt_idx = kOptFoldtext },
  { .name = "cpt", .opt_idx = kOptComplete },
  { .name = "cot", .opt_idx = kOptCompleteopt },
  { .name = "rdt", .opt_idx = kOptRedrawtime },
  { .name = "ofu", .opt_idx = kOptOmnifunc },
  { .name = "cfu", .opt_idx = kOptCompletefunc },
  { .name = "tfu", .opt_idx = kOptTagfunc },
  { .name = "rnu", .opt_idx = kOptRelativenumber },
  { .name = "ffu", .opt_idx = kOptFindfunc },
  { .name = "ccv", .opt_idx = kOptCharconvert },
  { .name = "nuw", .opt_idx = kOptNumberwidth },
  { .name = "wfw", .opt_idx = kOptWinfixwidth },
  { .name = "wmw", .opt_idx = kOptWinminwidth },
  { .name = "wiw", .opt_idx = kOptWinwidth },
  { .name = "pvw", .opt_idx = kOptPreviewwindow },
  { .name = "pmw", .opt_idx = kOptPummaxwidth },
  { .name = "eiw", .opt_idx = kOptEventignorewin },
  { .name = "gfw", .opt_idx = kOptGuifontwide },
  { .name = "pex", .opt_idx = kOptPatchexpr },
  { .name = "bex", .opt_idx = kOptBackupext },
  { .name = "pyx", .opt_idx = kOptPyxversion },
  { .name = "dex", .opt_idx = kOptDiffexpr },
  { .name = "fex", .opt_idx = kOptFormatexpr },
  { .name = "para", .opt_idx = kOptParagraphs },
  { .name = "bomb", .opt_idx = kOptBomb },
  { .name = "arab", .opt_idx = kOptArabic },
  { .name = "menc", .opt_idx = kOptMakeencoding },
  { .name = "tenc", .opt_idx = kOptTermencoding },
  { .name = "sloc", .opt_idx = kOptShowcmdloc },
  { .name = "exrc", .opt_idx = kOptExrc },
  { .name = "fenc", .opt_idx = kOptFileencoding },
  { .name = "more", .opt_idx = kOptMore },
  { .name = "inde", .opt_idx = kOptIndentexpr },
  { .name = "cole", .opt_idx = kOptConceallevel },
  { .name = "qftf", .opt_idx = kOptQuickfixtextfunc },
  { .name = "diff", .opt_idx = kOptDiff },
  { .name = "shcf", .opt_idx = kOptShellcmdflag },
  { .name = "path", .opt_idx = kOptPath },
  { .name = "scbk", .opt_idx = kOptScrollback },
  { .name = "indk", .opt_idx = kOptIndentkeys },
  { .name = "cink", .opt_idx = kOptCinkeys },
  { .name = "stal", .opt_idx = kOptShowtabline },
  { .name = "warn", .opt_idx = kOptWarn },
  { .name = "icon", .opt_idx = kOptIcon },
  { .name = "siso", .opt_idx = kOptSidescrolloff },
  { .name = "deco", .opt_idx = kOptDelcombine },
  { .name = "cino", .opt_idx = kOptCinoptions },
  { .name = "lisp", .opt_idx = kOptLisp },
  { .name = "wrap", .opt_idx = kOptWrap },
  { .name = "ssop", .opt_idx = kOptSessionoptions },
  { .name = "lmap", .opt_idx = kOptLangmap },
  { .name = "stmp", .opt_idx = kOptShelltemp },
  { .name = "vdir", .opt_idx = kOptViewdir },
  { .name = "udir", .opt_idx = kOptUndodir },
  { .name = "bdir", .opt_idx = kOptBackupdir },
  { .name = "fdls", .opt_idx = kOptFoldlevelstart },
  { .name = "vsts", .opt_idx = kOptVarsofttabstop },
  { .name = "tags", .opt_idx = kOptTags },
  { .name = "mopt", .opt_idx = kOptMessagesopt },
  { .name = "list", .opt_idx = kOptList },
  { .name = "tgst", .opt_idx = kOptTagstack },
  { .name = "dict", .opt_idx = kOptDictionary },
  { .name = "sect", .opt_idx = kOptSections },
  { .name = "wmnu", .opt_idx = kOptWildmenu },
  { .name = "cocu", .opt_idx = kOptConcealcursor },
  { .name = "odev", .opt_idx = kOptOpendevice },
  { .name = "ambw", .opt_idx = kOptAmbiwidth },
  { .name = "cinw", .opt_idx = kOptCinwords },
  { .name = "inex", .opt_idx = kOptIncludeexpr },
  { .name = "busy", .opt_idx = kOptBusy },
  { .name = "aleph", .opt_idx = kOptAleph },
  { .name = "bsdir", .opt_idx = kOptBrowsedir },
  { .name = "cinsd", .opt_idx = kOptCinscopedecls },
  { .name = "cedit", .opt_idx = kOptCedit },
  { .name = "debug", .opt_idx = kOptDebug },
  { .name = "emoji", .opt_idx = kOptEmoji },
  { .name = "fencs", .opt_idx = kOptFileencodings },
  { .name = "fsync", .opt_idx = kOptFsync },
  { .name = "hkmap", .opt_idx = kOptHkmap },
  { .name = "lines", .opt_idx = kOptLines },
  { .name = "magic", .opt_idx = kOptMagic },
  { .name = "mouse", .opt_idx = kOptMouse },
  { .name = "paste", .opt_idx = kOptPaste },
  { .name = "remap", .opt_idx = kOptRemap },
  { .name = "ruler", .opt_idx = kOptRuler },
  { .name = "shell", .opt_idx = kOptShell },
  { .name = "spell", .opt_idx = kOptSpell },
  { .name = "shada", .opt_idx = kOptShada },
  { .name = "title", .opt_idx = kOptTitle },
  { .name = "tsrfu", .opt_idx = kOptThesaurusfunc },
  { .name = "tbidi", .opt_idx = kOptTermbidi },
  { .name = "terse", .opt_idx = kOptTerse },
  { .name = "vfile", .opt_idx = kOptVerbosefile },
  { .name = "winbl", .opt_idx = kOptWinblend },
  { .name = "winhl", .opt_idx = kOptWinhighlight },
  { .name = "write", .opt_idx = kOptWrite },
  { .name = "arabic", .opt_idx = kOptArabic },
  { .name = "backup", .opt_idx = kOptBackup },
  { .name = "secure", .opt_idx = kOptSecure },
  { .name = "hidden", .opt_idx = kOptHidden },
  { .name = "opfunc", .opt_idx = kOptOperatorfunc },
  { .name = "define", .opt_idx = kOptDefine },
  { .name = "cdhome", .opt_idx = kOptCdhome },
  { .name = "briopt", .opt_idx = kOptBreakindentopt },
  { .name = "makeef", .opt_idx = kOptMakeef },
  { .name = "culopt", .opt_idx = kOptCursorlineopt },
  { .name = "hkmapp", .opt_idx = kOptHkmapp },
  { .name = "number", .opt_idx = kOptNumber },
  { .name = "syntax", .opt_idx = kOptSyntax },
  { .name = "winbar", .opt_idx = kOptWinbar },
  { .name = "window", .opt_idx = kOptWindow },
  { .name = "binary", .opt_idx = kOptBinary },
  { .name = "prompt", .opt_idx = kOptPrompt },
  { .name = "cdpath", .opt_idx = kOptCdpath },
  { .name = "report", .opt_idx = kOptReport },
  { .name = "scroll", .opt_idx = kOptScroll },
  { .name = "mousef", .opt_idx = kOptMousefocus },
  { .name = "mousem", .opt_idx = kOptMousemodel },
  { .name = "mouses", .opt_idx = kOptMouseshape },
  { .name = "mouset", .opt_idx = kOptMousetime },
  { .name = "revins", .opt_idx = kOptRevins },
  { .name = "fixeol", .opt_idx = kOptFixendofline },
  { .name = "keymap", .opt_idx = kOptKeymap },
  { .name = "channel", .opt_idx = kOptChannel },
  { .name = "tabstop", .opt_idx = kOptTabstop },
  { .name = "tabline", .opt_idx = kOptTabline },
  { .name = "include", .opt_idx = kOptInclude },
  { .name = "undodir", .opt_idx = kOptUndodir },
  { .name = "viewdir", .opt_idx = kOptViewdir },
  { .name = "breakat", .opt_idx = kOptBreakat },
  { .name = "grepprg", .opt_idx = kOptGrepprg },
  { .name = "diffopt", .opt_idx = kOptDiffopt },
  { .name = "buftype", .opt_idx = kOptBuftype },
  { .name = "isfname", .opt_idx = kOptIsfname },
  { .name = "tagfunc", .opt_idx = kOptTagfunc },
  { .name = "tagcase", .opt_idx = kOptTagcase },
  { .name = "digraph", .opt_idx = kOptDigraph },
  { .name = "isident", .opt_idx = kOptIsident },
  { .name = "guifont", .opt_idx = kOptGuifont },
  { .name = "makeprg", .opt_idx = kOptMakeprg },
  { .name = "tildeop", .opt_idx = kOptTildeop },
  { .name = "belloff", .opt_idx = kOptBelloff },
  { .name = "columns", .opt_idx = kOptColumns },
  { .name = "timeout", .opt_idx = kOptTimeout },
  { .name = "viminfo", .opt_idx = kOptShada },
  { .name = "cinkeys", .opt_idx = kOptCinkeys },
  { .name = "cindent", .opt_idx = kOptCindent },
  { .name = "langmap", .opt_idx = kOptLangmap },
  { .name = "confirm", .opt_idx = kOptConfirm },
  { .name = "showcmd", .opt_idx = kOptShowcmd },
  { .name = "isprint", .opt_idx = kOptIsprint },
  { .name = "verbose", .opt_idx = kOptVerbose },
  { .name = "history", .opt_idx = kOptHistory },
  { .name = "casemap", .opt_idx = kOptCasemap },
  { .name = "display", .opt_idx = kOptDisplay },
  { .name = "arshape", .opt_idx = kOptArabicshape },
  { .name = "ttyfast", .opt_idx = kOptTtyfast },
  { .name = "autoread", .opt_idx = kOptAutoread },
  { .name = "complete", .opt_idx = kOptComplete },
  { .name = "chistory", .opt_idx = kOptChistory },
  { .name = "cinwords", .opt_idx = kOptCinwords },
  { .name = "comments", .opt_idx = kOptComments },
  { .name = "diffexpr", .opt_idx = kOptDiffexpr },
  { .name = "encoding", .opt_idx = kOptEncoding },
  { .name = "equalprg", .opt_idx = kOptEqualprg },
  { .name = "findfunc", .opt_idx = kOptFindfunc },
  { .name = "filetype", .opt_idx = kOptFiletype },
  { .name = "foldopen", .opt_idx = kOptFoldopen },
  { .name = "foldtext", .opt_idx = kOptFoldtext },
  { .name = "foldexpr", .opt_idx = kOptFoldexpr },
  { .name = "gdefault", .opt_idx = kOptGdefault },
  { .name = "helpfile", .opt_idx = kOptHelpfile },
  { .name = "helplang", .opt_idx = kOptHelplang },
  { .name = "hlsearch", .opt_idx = kOptHlsearch },
  { .name = "imsearch", .opt_idx = kOptImsearch },
  { .name = "iminsert", .opt_idx = kOptIminsert },
  { .name = "keymodel", .opt_idx = kOptKeymodel },
  { .name = "lhistory", .opt_idx = kOptLhistory },
  { .name = "langmenu", .opt_idx = kOptLangmenu },
  { .name = "modeline", .opt_idx = kOptModeline },
  { .name = "modified", .opt_idx = kOptModified },
  { .name = "mousemev", .opt_idx = kOptMousemoveevent },
  { .name = "omnifunc", .opt_idx = kOptOmnifunc },
  { .name = "packpath", .opt_idx = kOptPackpath },
  { .name = "pumblend", .opt_idx = kOptPumblend },
  { .name = "pumwidth", .opt_idx = kOptPumwidth },
  { .name = "readonly", .opt_idx = kOptReadonly },
  { .name = "showmode", .opt_idx = kOptShowmode },
  { .name = "swapfile", .opt_idx = kOptSwapfile },
  { .name = "suffixes", .opt_idx = kOptSuffixes },
  { .name = "smarttab", .opt_idx = kOptSmarttab },
  { .name = "sections", .opt_idx = kOptSections },
  { .name = "titlelen", .opt_idx = kOptTitlelen },
  { .name = "ttimeout", .opt_idx = kOptTtimeout },
  { .name = "termsync", .opt_idx = kOptTermsync },
  { .name = "titleold", .opt_idx = kOptTitleold },
  { .name = "termbidi", .opt_idx = kOptTermbidi },
  { .name = "tagstack", .opt_idx = kOptTagstack },
  { .name = "tabclose", .opt_idx = kOptTabclose },
  { .name = "undofile", .opt_idx = kOptUndofile },
  { .name = "winblend", .opt_idx = kOptWinblend },
  { .name = "winwidth", .opt_idx = kOptWinwidth },
  { .name = "wildchar", .opt_idx = kOptWildchar },
  { .name = "wrapscan", .opt_idx = kOptWrapscan },
  { .name = "writeany", .opt_idx = kOptWriteany },
  { .name = "wildmode", .opt_idx = kOptWildmode },
  { .name = "wildmenu", .opt_idx = kOptWildmenu },
  { .name = "whichwrap", .opt_idx = kOptWhichwrap },
  { .name = "showbreak", .opt_idx = kOptShowbreak },
  { .name = "expandtab", .opt_idx = kOptExpandtab },
  { .name = "langremap", .opt_idx = kOptLangremap },
  { .name = "linebreak", .opt_idx = kOptLinebreak },
  { .name = "backspace", .opt_idx = kOptBackspace },
  { .name = "showmatch", .opt_idx = kOptShowmatch },
  { .name = "incsearch", .opt_idx = kOptIncsearch },
  { .name = "linespace", .opt_idx = kOptLinespace },
  { .name = "patchmode", .opt_idx = kOptPatchmode },
  { .name = "lispwords", .opt_idx = kOptLispwords },
  { .name = "mousehide", .opt_idx = kOptMousehide },
  { .name = "modelines", .opt_idx = kOptModelines },
  { .name = "winborder", .opt_idx = kOptWinborder },
  { .name = "pumborder", .opt_idx = kOptPumborder },
  { .name = "bufhidden", .opt_idx = kOptBufhidden },
  { .name = "buflisted", .opt_idx = kOptBuflisted },
  { .name = "splitkeep", .opt_idx = kOptSplitkeep },
  { .name = "foldlevel", .opt_idx = kOptFoldlevel },
  { .name = "rightleft", .opt_idx = kOptRightleft },
  { .name = "scrolloff", .opt_idx = kOptScrolloff },
  { .name = "winheight", .opt_idx = kOptWinheight },
  { .name = "pumheight", .opt_idx = kOptPumheight },
  { .name = "highlight", .opt_idx = kOptHighlight },
  { .name = "cmdheight", .opt_idx = kOptCmdheight },
  { .name = "backupdir", .opt_idx = kOptBackupdir },
  { .name = "browsedir", .opt_idx = kOptBrowsedir },
  { .name = "autochdir", .opt_idx = kOptAutochdir },
  { .name = "spellfile", .opt_idx = kOptSpellfile },
  { .name = "endoffile", .opt_idx = kOptEndoffile },
  { .name = "errorfile", .opt_idx = kOptErrorfile },
  { .name = "shadafile", .opt_idx = kOptShadafile },
  { .name = "imdisable", .opt_idx = kOptImdisable },
  { .name = "matchtime", .opt_idx = kOptMatchtime },
  { .name = "mousetime", .opt_idx = kOptMousetime },
  { .name = "menuitems", .opt_idx = kOptMenuitems },
  { .name = "shelltemp", .opt_idx = kOptShelltemp },
  { .name = "cpoptions", .opt_idx = kOptCpoptions },
  { .name = "spelllang", .opt_idx = kOptSpelllang },
  { .name = "endofline", .opt_idx = kOptEndofline },
  { .name = "imcmdline", .opt_idx = kOptImcmdline },
  { .name = "selection", .opt_idx = kOptSelection },
  { .name = "synmaxcol", .opt_idx = kOptSynmaxcol },
  { .name = "guicursor", .opt_idx = kOptGuicursor },
  { .name = "patchexpr", .opt_idx = kOptPatchexpr },
  { .name = "scrollopt", .opt_idx = kOptScrollopt },
  { .name = "shellpipe", .opt_idx = kOptShellpipe },
  { .name = "listchars", .opt_idx = kOptListchars },
  { .name = "wildcharm", .opt_idx = kOptWildcharm },
  { .name = "directory", .opt_idx = kOptDirectory },
  { .name = "fillchars", .opt_idx = kOptFillchars },
  { .name = "clipboard", .opt_idx = kOptClipboard },
  { .name = "iskeyword", .opt_idx = kOptIskeyword },
  { .name = "formatprg", .opt_idx = kOptFormatprg },
  { .name = "smartcase", .opt_idx = kOptSmartcase },
  { .name = "shortmess", .opt_idx = kOptShortmess },
  { .name = "foldclose", .opt_idx = kOptFoldclose },
  { .name = "infercase", .opt_idx = kOptInfercase },
  { .name = "nrformats", .opt_idx = kOptNrformats },
  { .name = "textwidth", .opt_idx = kOptTextwidth },
  { .name = "taglength", .opt_idx = kOptTaglength },
  { .name = "ambiwidth", .opt_idx = kOptAmbiwidth },
  { .name = "autowrite", .opt_idx = kOptAutowrite },
  { .name = "winfixbuf", .opt_idx = kOptWinfixbuf },
  { .name = "thesaurus", .opt_idx = kOptThesaurus },
  { .name = "switchbuf", .opt_idx = kOptSwitchbuf },
  { .name = "backupext", .opt_idx = kOptBackupext },
  { .name = "paragraphs", .opt_idx = kOptParagraphs },
  { .name = "matchpairs", .opt_idx = kOptMatchpairs },
  { .name = "modifiable", .opt_idx = kOptModifiable },
  { .name = "laststatus", .opt_idx = kOptLaststatus },
  { .name = "foldenable", .opt_idx = kOptFoldenable },
  { .name = "joinspaces", .opt_idx = kOptJoinspaces },
  { .name = "tagbsearch", .opt_idx = kOptTagbsearch },
  { .name = "cursorbind", .opt_idx = kOptCursorbind },
  { .name = "visualbell", .opt_idx = kOptVisualbell },
  { .name = "delcombine", .opt_idx = kOptDelcombine },
  { .name = "scrollback", .opt_idx = kOptScrollback },
  { .name = "scrollbind", .opt_idx = kOptScrollbind },
  { .name = "maxcombine", .opt_idx = kOptMaxcombine },
  { .name = "backupcopy", .opt_idx = kOptBackupcopy },
  { .name = "ignorecase", .opt_idx = kOptIgnorecase },
  { .name = "copyindent", .opt_idx = kOptCopyindent },
  { .name = "showcmdloc", .opt_idx = kOptShowcmdloc },
  { .name = "autoindent", .opt_idx = kOptAutoindent },
  { .name = "keywordprg", .opt_idx = kOptKeywordprg },
  { .name = "lazyredraw", .opt_idx = kOptLazyredraw },
  { .name = "tabpagemax", .opt_idx = kOptTabpagemax },
  { .name = "writedelay", .opt_idx = kOptWritedelay },
  { .name = "splitbelow", .opt_idx = kOptSplitbelow },
  { .name = "errorbells", .opt_idx = kOptErrorbells },
  { .name = "formatexpr", .opt_idx = kOptFormatexpr },
  { .name = "indentexpr", .opt_idx = kOptIndentexpr },
  { .name = "shellredir", .opt_idx = kOptShellredir },
  { .name = "mouseshape", .opt_idx = kOptMouseshape },
  { .name = "guioptions", .opt_idx = kOptGuioptions },
  { .name = "compatible", .opt_idx = kOptCompatible },
  { .name = "splitright", .opt_idx = kOptSplitright },
  { .name = "shiftwidth", .opt_idx = kOptShiftwidth },
  { .name = "helpheight", .opt_idx = kOptHelpheight },
  { .name = "cinoptions", .opt_idx = kOptCinoptions },
  { .name = "scrolljump", .opt_idx = kOptScrolljump },
  { .name = "winaltkeys", .opt_idx = kOptWinaltkeys },
  { .name = "indentkeys", .opt_idx = kOptIndentkeys },
  { .name = "cursorline", .opt_idx = kOptCursorline },
  { .name = "signcolumn", .opt_idx = kOptSigncolumn },
  { .name = "undoreload", .opt_idx = kOptUndoreload },
  { .name = "mkspellmem", .opt_idx = kOptMkspellmem },
  { .name = "statusline", .opt_idx = kOptStatusline },
  { .name = "foldcolumn", .opt_idx = kOptFoldcolumn },
  { .name = "shellslash", .opt_idx = kOptShellslash },
  { .name = "insertmode", .opt_idx = kOptInsertmode },
  { .name = "selectmode", .opt_idx = kOptSelectmode },
  { .name = "inccommand", .opt_idx = kOptInccommand },
  { .name = "wildignore", .opt_idx = kOptWildignore },
  { .name = "dictionary", .opt_idx = kOptDictionary },
  { .name = "foldignore", .opt_idx = kOptFoldignore },
  { .name = "mousefocus", .opt_idx = kOptMousefocus },
  { .name = "mousemodel", .opt_idx = kOptMousemodel },
  { .name = "background", .opt_idx = kOptBackground },
  { .name = "shiftround", .opt_idx = kOptShiftround },
  { .name = "foldmarker", .opt_idx = kOptFoldmarker },
  { .name = "sidescroll", .opt_idx = kOptSidescroll },
  { .name = "wrapmargin", .opt_idx = kOptWrapmargin },
  { .name = "iconstring", .opt_idx = kOptIconstring },
  { .name = "fileformat", .opt_idx = kOptFileformat },
  { .name = "grepformat", .opt_idx = kOptGrepformat },
  { .name = "vartabstop", .opt_idx = kOptVartabstop },
  { .name = "backupskip", .opt_idx = kOptBackupskip },
  { .name = "pyxversion", .opt_idx = kOptPyxversion },
  { .name = "foldmethod", .opt_idx = kOptFoldmethod },
  { .name = "updatetime", .opt_idx = kOptUpdatetime },
  { .name = "timeoutlen", .opt_idx = kOptTimeoutlen },
  { .name = "redrawtime", .opt_idx = kOptRedrawtime },
  { .name = "shellquote", .opt_idx = kOptShellquote },
  { .name = "opendevice", .opt_idx = kOptOpendevice },
  { .name = "undolevels", .opt_idx = kOptUndolevels },
  { .name = "showtabline", .opt_idx = kOptShowtabline },
  { .name = "virtualedit", .opt_idx = kOptVirtualedit },
  { .name = "softtabstop", .opt_idx = kOptSofttabstop },
  { .name = "equalalways", .opt_idx = kOptEqualalways },
  { .name = "guitablabel", .opt_idx = kOptGuitablabel },
  { .name = "writebackup", .opt_idx = kOptWritebackup },
  { .name = "colorcolumn", .opt_idx = kOptColorcolumn },
  { .name = "arabicshape", .opt_idx = kOptArabicshape },
  { .name = "includeexpr", .opt_idx = kOptIncludeexpr },
  { .name = "foldnestmax", .opt_idx = kOptFoldnestmax },
  { .name = "updatecount", .opt_idx = kOptUpdatecount },
  { .name = "quoteescape", .opt_idx = kOptQuoteescape },
  { .name = "completeopt", .opt_idx = kOptCompleteopt },
  { .name = "eadirection", .opt_idx = kOptEadirection },
  { .name = "errorformat", .opt_idx = kOptErrorformat },
  { .name = "rulerformat", .opt_idx = kOptRulerformat },
  { .name = "viminfofile", .opt_idx = kOptShadafile },
  { .name = "messagesopt", .opt_idx = kOptMessagesopt },
  { .name = "smartindent", .opt_idx = kOptSmartindent },
  { .name = "breakindent", .opt_idx = kOptBreakindent },
  { .name = "eventignore", .opt_idx = kOptEventignore },
  { .name = "loadplugins", .opt_idx = kOptLoadplugins },
  { .name = "tagrelative", .opt_idx = kOptTagrelative },
  { .name = "runtimepath", .opt_idx = kOptRuntimepath },
  { .name = "guifontwide", .opt_idx = kOptGuifontwide },
  { .name = "winminwidth", .opt_idx = kOptWinminwidth },
  { .name = "diffanchors", .opt_idx = kOptDiffanchors },
  { .name = "ttimeoutlen", .opt_idx = kOptTtimeoutlen },
  { .name = "startofline", .opt_idx = kOptStartofline },
  { .name = "fileformats", .opt_idx = kOptFileformats },
  { .name = "langnoremap", .opt_idx = kOptLangnoremap },
  { .name = "charconvert", .opt_idx = kOptCharconvert },
  { .name = "viewoptions", .opt_idx = kOptViewoptions },
  { .name = "lispoptions", .opt_idx = kOptLispoptions },
  { .name = "maxmapdepth", .opt_idx = kOptMaxmapdepth },
  { .name = "wildoptions", .opt_idx = kOptWildoptions },
  { .name = "jumpoptions", .opt_idx = kOptJumpoptions },
  { .name = "numberwidth", .opt_idx = kOptNumberwidth },
  { .name = "allowrevins", .opt_idx = kOptAllowrevins },
  { .name = "titlestring", .opt_idx = kOptTitlestring },
  { .name = "verbosefile", .opt_idx = kOptVerbosefile },
  { .name = "mousescroll", .opt_idx = kOptMousescroll },
  { .name = "pastetoggle", .opt_idx = kOptPastetoggle },
  { .name = "showfulltag", .opt_idx = kOptShowfulltag },
  { .name = "redrawdebug", .opt_idx = kOptRedrawdebug },
  { .name = "winfixwidth", .opt_idx = kOptWinfixwidth },
  { .name = "suffixesadd", .opt_idx = kOptSuffixesadd },
  { .name = "shellxquote", .opt_idx = kOptShellxquote },
  { .name = "pummaxwidth", .opt_idx = kOptPummaxwidth },
  { .name = "statuscolumn", .opt_idx = kOptStatuscolumn },
  { .name = "edcompatible", .opt_idx = kOptEdcompatible },
  { .name = "modelineexpr", .opt_idx = kOptModelineexpr },
  { .name = "cmdwinheight", .opt_idx = kOptCmdwinheight },
  { .name = "operatorfunc", .opt_idx = kOptOperatorfunc },
  { .name = "spelloptions", .opt_idx = kOptSpelloptions },
  { .name = "spellsuggest", .opt_idx = kOptSpellsuggest },
  { .name = "shellcmdflag", .opt_idx = kOptShellcmdflag },
  { .name = "shellxescape", .opt_idx = kOptShellxescape },
  { .name = "regexpengine", .opt_idx = kOptRegexpengine },
  { .name = "rightleftcmd", .opt_idx = kOptRightleftcmd },
  { .name = "makeencoding", .opt_idx = kOptMakeencoding },
  { .name = "fileencoding", .opt_idx = kOptFileencoding },
  { .name = "foldminlines", .opt_idx = kOptFoldminlines },
  { .name = "completefunc", .opt_idx = kOptCompletefunc },
  { .name = "winfixheight", .opt_idx = kOptWinfixheight },
  { .name = "winhighlight", .opt_idx = kOptWinhighlight },
  { .name = "winminheight", .opt_idx = kOptWinminheight },
  { .name = "conceallevel", .opt_idx = kOptConceallevel },
  { .name = "smoothscroll", .opt_idx = kOptSmoothscroll },
  { .name = "cursorcolumn", .opt_idx = kOptCursorcolumn },
  { .name = "termencoding", .opt_idx = kOptTermencoding },
  { .name = "autocomplete", .opt_idx = kOptAutocomplete },
  { .name = "autowriteall", .opt_idx = kOptAutowriteall },
  { .name = "maxfuncdepth", .opt_idx = kOptMaxfuncdepth },
  { .name = "fixendofline", .opt_idx = kOptFixendofline },
  { .name = "concealcursor", .opt_idx = kOptConcealcursor },
  { .name = "guitabtooltip", .opt_idx = kOptGuitabtooltip },
  { .name = "sidescrolloff", .opt_idx = kOptSidescrolloff },
  { .name = "spellcapcheck", .opt_idx = kOptSpellcapcheck },
  { .name = "previewheight", .opt_idx = kOptPreviewheight },
  { .name = "previewwindow", .opt_idx = kOptPreviewwindow },
  { .name = "completeslash", .opt_idx = kOptCompleteslash },
  { .name = "maxmempattern", .opt_idx = kOptMaxmempattern },
  { .name = "fileencodings", .opt_idx = kOptFileencodings },
  { .name = "commentstring", .opt_idx = kOptCommentstring },
  { .name = "cinscopedecls", .opt_idx = kOptCinscopedecls },
  { .name = "cursorlineopt", .opt_idx = kOptCursorlineopt },
  { .name = "formatlistpat", .opt_idx = kOptFormatlistpat },
  { .name = "formatoptions", .opt_idx = kOptFormatoptions },
  { .name = "thesaurusfunc", .opt_idx = kOptThesaurusfunc },
  { .name = "termguicolors", .opt_idx = kOptTermguicolors },
  { .name = "breakindentopt", .opt_idx = kOptBreakindentopt },
  { .name = "eventignorewin", .opt_idx = kOptEventignorewin },
  { .name = "foldlevelstart", .opt_idx = kOptFoldlevelstart },
  { .name = "fileignorecase", .opt_idx = kOptFileignorecase },
  { .name = "maxsearchcount", .opt_idx = kOptMaxsearchcount },
  { .name = "mousemoveevent", .opt_idx = kOptMousemoveevent },
  { .name = "preserveindent", .opt_idx = kOptPreserveindent },
  { .name = "relativenumber", .opt_idx = kOptRelativenumber },
  { .name = "sessionoptions", .opt_idx = kOptSessionoptions },
  { .name = "varsofttabstop", .opt_idx = kOptVarsofttabstop },
  { .name = "wildignorecase", .opt_idx = kOptWildignorecase },
  { .name = "completetimeout", .opt_idx = kOptCompletetimeout },
  { .name = "termpastefilter", .opt_idx = kOptTermpastefilter },
  { .name = "quickfixtextfunc", .opt_idx = kOptQuickfixtextfunc },
  { .name = "autocompletedelay", .opt_idx = kOptAutocompletedelay },
  { .name = "completeitemalign", .opt_idx = kOptCompleteitemalign },
  { .name = "autocompletetimeout", .opt_idx = kOptAutocompletetimeout },
};

static int find_option_hash(const char *str, size_t len)
{
  int low = 0, high = 0;
  switch (len) {
    case 2: switch (str[1]) {
      case 'a': low = 0; high = 4; break;
      case 'b': low = 4; high = 10; break;
      case 'c': low = 10; high = 17; break;
      case 'd': low = 17; high = 22; break;
      case 'e': low = 22; high = 25; break;
      case 'f': low = 25; high = 31; break;
      case 'g': low = 31; high = 33; break;
      case 'h': low = 33; high = 40; break;
      case 'i': low = 40; high = 49; break;
      case 'j': low = 49; high = 50; break;
      case 'k': low = 50; high = 52; break;
      case 'l': low = 52; high = 59; break;
      case 'm': low = 59; high = 66; break;
      case 'o': low = 66; high = 73; break;
      case 'p': low = 73; high = 81; break;
      case 'r': low = 81; high = 85; break;
      case 's': low = 85; high = 93; break;
      case 't': low = 93; high = 98; break;
      case 'u': low = 98; high = 101; break;
      case 'w': low = 101; high = 107; break;
      case 'x': low = 107; high = 108; break;
      case 'y': low = 108; high = 109; break;
      case 'z': low = 109; high = 110; break;
      default: break;
    }
    break;
    case 3: switch (str[2]) {
      case 'a': low = 110; high = 115; break;
      case 'b': low = 115; high = 120; break;
      case 'c': low = 120; high = 134; break;
      case 'd': low = 134; high = 142; break;
      case 'e': low = 142; high = 145; break;
      case 'f': low = 145; high = 157; break;
      case 'g': low = 157; high = 160; break;
      case 'h': low = 160; high = 165; break;
      case 'i': low = 165; high = 172; break;
      case 'k': low = 172; high = 177; break;
      case 'l': low = 177; high = 194; break;
      case 'm': low = 194; high = 207; break;
      case 'n': low = 207; high = 213; break;
      case 'o': low = 213; high = 220; break;
      case 'p': low = 220; high = 234; break;
      case 'q': low = 234; high = 236; break;
      case 'r': low = 236; high = 247; break;
      case 's': low = 247; high = 263; break;
      case 't': low = 263; high = 271; break;
      case 'u': low = 271; high = 276; break;
      case 'v': low = 276; high = 277; break;
      case 'w': low = 277; high = 285; break;
      case 'x': low = 285; high = 290; break;
      default: break;
    }
    break;
    case 4: switch (str[3]) {
      case 'a': low = 290; high = 291; break;
      case 'b': low = 291; high = 293; break;
      case 'c': low = 293; high = 298; break;
      case 'e': low = 298; high = 301; break;
      case 'f': low = 301; high = 304; break;
      case 'h': low = 304; high = 305; break;
      case 'k': low = 305; high = 308; break;
      case 'l': low = 308; high = 309; break;
      case 'n': low = 309; high = 311; break;
      case 'o': low = 311; high = 314; break;
      case 'p': low = 314; high = 319; break;
      case 'r': low = 319; high = 322; break;
      case 's': low = 322; high = 325; break;
      case 't': low = 325; high = 330; break;
      case 'u': low = 330; high = 332; break;
      case 'v': low = 332; high = 333; break;
      case 'w': low = 333; high = 335; break;
      case 'x': low = 335; high = 336; break;
      case 'y': low = 336; high = 337; break;
      default: break;
    }
    break;
    case 5: switch (str[0]) {
      case 'a': low = 337; high = 338; break;
      case 'b': low = 338; high = 339; break;
      case 'c': low = 339; high = 341; break;
      case 'd': low = 341; high = 342; break;
      case 'e': low = 342; high = 343; break;
      case 'f': low = 343; high = 345; break;
      case 'h': low = 345; high = 346; break;
      case 'l': low = 346; high = 347; break;
      case 'm': low = 347; high = 349; break;
      case 'p': low = 349; high = 350; break;
      case 'r': low = 350; high = 352; break;
      case 's': low = 352; high = 355; break;
      case 't': low = 355; high = 359; break;
      case 'v': low = 359; high = 360; break;
      case 'w': low = 360; high = 363; break;
      default: break;
    }
    break;
    case 6: switch (str[2]) {
      case 'a': low = 363; high = 364; break;
      case 'c': low = 364; high = 366; break;
      case 'd': low = 366; high = 367; break;
      case 'f': low = 367; high = 369; break;
      case 'h': low = 369; high = 370; break;
      case 'i': low = 370; high = 371; break;
      case 'k': low = 371; high = 372; break;
      case 'l': low = 372; high = 373; break;
      case 'm': low = 373; high = 375; break;
      case 'n': low = 375; high = 379; break;
      case 'o': low = 379; high = 380; break;
      case 'p': low = 380; high = 382; break;
      case 'r': low = 382; high = 383; break;
      case 'u': low = 383; high = 387; break;
      case 'v': low = 387; high = 388; break;
      case 'x': low = 388; high = 389; break;
      case 'y': low = 389; high = 390; break;
      default: break;
    }
    break;
    case 7: switch (str[2]) {
      case 'a': low = 390; high = 391; break;
      case 'b': low = 391; high = 393; break;
      case 'c': low = 393; high = 394; break;
      case 'd': low = 394; high = 395; break;
      case 'e': low = 395; high = 398; break;
      case 'f': low = 398; high = 401; break;
      case 'g': low = 401; high = 404; break;
      case 'i': low = 404; high = 406; break;
      case 'k': low = 406; high = 407; break;
      case 'l': low = 407; high = 410; break;
      case 'm': low = 410; high = 412; break;
      case 'n': low = 412; high = 416; break;
      case 'o': low = 416; high = 417; break;
      case 'p': low = 417; high = 418; break;
      case 'r': low = 418; high = 419; break;
      case 's': low = 419; high = 423; break;
      case 'y': low = 423; high = 424; break;
      default: break;
    }
    break;
    case 8: switch (str[0]) {
      case 'a': low = 424; high = 425; break;
      case 'c': low = 425; high = 429; break;
      case 'd': low = 429; high = 430; break;
      case 'e': low = 430; high = 432; break;
      case 'f': low = 432; high = 437; break;
      case 'g': low = 437; high = 438; break;
      case 'h': low = 438; high = 441; break;
      case 'i': low = 441; high = 443; break;
      case 'k': low = 443; high = 444; break;
      case 'l': low = 444; high = 446; break;
      case 'm': low = 446; high = 449; break;
      case 'o': low = 449; high = 450; break;
      case 'p': low = 450; high = 453; break;
      case 'r': low = 453; high = 454; break;
      case 's': low = 454; high = 459; break;
      case 't': low = 459; high = 466; break;
      case 'u': low = 466; high = 467; break;
      case 'w': low = 467; high = 474; break;
      default: break;
    }
    break;
    case 9: switch (str[7]) {
      case 'a': low = 474; high = 479; break;
      case 'c': low = 479; high = 483; break;
      case 'd': low = 483; high = 486; break;
      case 'e': low = 486; high = 493; break;
      case 'f': low = 493; high = 495; break;
      case 'h': low = 495; high = 499; break;
      case 'i': low = 499; high = 502; break;
      case 'l': low = 502; high = 507; break;
      case 'm': low = 507; high = 511; break;
      case 'n': low = 511; high = 515; break;
      case 'o': low = 515; high = 518; break;
      case 'p': low = 518; high = 521; break;
      case 'r': low = 521; high = 528; break;
      case 's': low = 528; high = 532; break;
      case 't': low = 532; high = 537; break;
      case 'u': low = 537; high = 540; break;
      case 'x': low = 540; high = 541; break;
      default: break;
    }
    break;
    case 10: switch (str[6]) {
      case 'a': low = 541; high = 548; break;
      case 'b': low = 548; high = 554; break;
      case 'c': low = 554; high = 556; break;
      case 'd': low = 556; high = 561; break;
      case 'e': low = 561; high = 568; break;
      case 'h': low = 568; high = 569; break;
      case 'i': low = 569; high = 575; break;
      case 'j': low = 575; high = 576; break;
      case 'k': low = 576; high = 578; break;
      case 'l': low = 578; high = 585; break;
      case 'm': low = 585; high = 588; break;
      case 'n': low = 588; high = 591; break;
      case 'o': low = 591; high = 595; break;
      case 'r': low = 595; high = 601; break;
      case 's': low = 601; high = 604; break;
      case 't': low = 604; high = 608; break;
      case 'u': low = 608; high = 609; break;
      case 'v': low = 609; high = 611; break;
      default: break;
    }
    break;
    case 11: switch (str[5]) {
      case 'a': low = 611; high = 615; break;
      case 'b': low = 615; high = 617; break;
      case 'c': low = 617; high = 619; break;
      case 'd': low = 619; high = 620; break;
      case 'e': low = 620; high = 625; break;
      case 'f': low = 625; high = 628; break;
      case 'g': low = 628; high = 629; break;
      case 'i': low = 629; high = 632; break;
      case 'l': low = 632; high = 634; break;
      case 'm': low = 634; high = 635; break;
      case 'n': low = 635; high = 638; break;
      case 'o': low = 638; high = 643; break;
      case 'p': low = 643; high = 648; break;
      case 'r': low = 648; high = 650; break;
      case 's': low = 650; high = 653; break;
      case 't': low = 653; high = 654; break;
      case 'u': low = 654; high = 655; break;
      case 'w': low = 655; high = 656; break;
      case 'x': low = 656; high = 660; break;
      default: break;
    }
    break;
    case 12: switch (str[2]) {
      case 'a': low = 660; high = 661; break;
      case 'c': low = 661; high = 662; break;
      case 'd': low = 662; high = 664; break;
      case 'e': low = 664; high = 669; break;
      case 'g': low = 669; high = 671; break;
      case 'k': low = 671; high = 672; break;
      case 'l': low = 672; high = 674; break;
      case 'm': low = 674; high = 675; break;
      case 'n': low = 675; high = 679; break;
      case 'o': low = 679; high = 680; break;
      case 'r': low = 680; high = 682; break;
      case 't': low = 682; high = 684; break;
      case 'x': low = 684; high = 686; break;
      default: break;
    }
    break;
    case 13: switch (str[5]) {
      case 'a': low = 686; high = 687; break;
      case 'b': low = 687; high = 688; break;
      case 'c': low = 688; high = 690; break;
      case 'e': low = 690; high = 693; break;
      case 'm': low = 693; high = 694; break;
      case 'n': low = 694; high = 696; break;
      case 'o': low = 696; high = 697; break;
      case 'r': low = 697; high = 698; break;
      case 't': low = 698; high = 700; break;
      case 'u': low = 700; high = 702; break;
      default: break;
    }
    break;
    case 14: switch (str[0]) {
      case 'b': low = 702; high = 703; break;
      case 'e': low = 703; high = 704; break;
      case 'f': low = 704; high = 706; break;
      case 'm': low = 706; high = 708; break;
      case 'p': low = 708; high = 709; break;
      case 'r': low = 709; high = 710; break;
      case 's': low = 710; high = 711; break;
      case 'v': low = 711; high = 712; break;
      case 'w': low = 712; high = 713; break;
      default: break;
    }
    break;
    case 15: switch (str[0]) {
      case 'c': low = 713; high = 714; break;
      case 't': low = 714; high = 715; break;
      default: break;
    }
    break;
    case 16: low = 715; high = 716; break;
    case 17: switch (str[0]) {
      case 'a': low = 716; high = 717; break;
      case 'c': low = 717; high = 718; break;
      default: break;
    }
    break;
    case 19: low = 718; high = 719; break;
    default: break;
  }
  for (int i = low; i < high; i++) {
    if (!memcmp(str, option_hash_elems[i].name, len)) {
      return i;
    }
  }
  return -1;
}


