// IWYU pragma: private, include "nvim/register.h"
#define DEFINE_FUNC_ATTRIBUTES
#include "nvim/func_attr.h"
#undef DEFINE_FUNC_ATTRIBUTES
#ifndef DLLEXPORT
#  ifdef MSWIN
#    define DLLEXPORT __declspec(dllexport)
#  else
#    define DLLEXPORT
#  endif
#endif
DLLEXPORT int get_unname_register(void);
DLLEXPORT yankreg_T *get_y_register(int reg);
DLLEXPORT yankreg_T *get_y_previous(void) FUNC_ATTR_PURE;
DLLEXPORT int get_expr_register(void);
DLLEXPORT void set_expr_line(char *new_line);
DLLEXPORT char *get_expr_line(void);
DLLEXPORT char *get_expr_line_src(void);
DLLEXPORT bool valid_yank_reg(int regname, bool writing);
DLLEXPORT int get_default_register_name(void);
DLLEXPORT const void *op_reg_iter(const void *const iter, const yankreg_T *const regs, char *const name, yankreg_T *const reg, bool *is_unnamed) FUNC_ATTR_NONNULL_ARG(3, 4, 5) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT const void *op_global_reg_iter(const void *const iter, char *const name, yankreg_T *const reg, bool *is_unnamed) FUNC_ATTR_NONNULL_ARG(2, 3, 4) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT size_t op_reg_amount(void) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool op_reg_set(const char name, const yankreg_T reg, bool is_unnamed);
DLLEXPORT const yankreg_T *op_reg_get(const char name);
DLLEXPORT bool op_reg_set_previous(const char name);
DLLEXPORT void update_yankreg_width(yankreg_T *reg);
DLLEXPORT yankreg_T *get_yank_register(int regname, int mode);
DLLEXPORT bool yank_register_mline(int regname, yankreg_T **reg);
DLLEXPORT yankreg_T *copy_register(int name) FUNC_ATTR_NONNULL_RET;
DLLEXPORT int do_record(int c);
DLLEXPORT int do_execreg(int regname, int colon, int addcr, int silent);
DLLEXPORT int insert_reg(int regname, yankreg_T *reg, bool literally_arg);
DLLEXPORT bool get_spec_reg(int regname, char **argp, bool *allocated, bool errmsg);
DLLEXPORT bool cmdline_paste_reg(int regname, bool literally_arg, bool remcr);
DLLEXPORT void shift_delete_registers(bool y_append);
DLLEXPORT void clear_registers(void);
DLLEXPORT void free_register(yankreg_T *reg) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void op_yank_reg(oparg_T *oap, bool message, yankreg_T *reg, bool append);
DLLEXPORT void format_reg_type(MotionType reg_type, colnr_T reg_width, char *buf, size_t buf_len) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void do_autocmd_textyankpost(oparg_T *oap, yankreg_T *reg) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool op_yank(oparg_T *oap, bool message) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void do_put(int regname, yankreg_T *reg, int dir, int count, int flags);
DLLEXPORT void ex_display(exarg_T *eap);
DLLEXPORT MotionType get_reg_type(int regname, colnr_T *reg_width);
DLLEXPORT void *get_reg_contents(int regname, int flags);
DLLEXPORT void write_reg_contents(int name, const char *str, ssize_t len, int must_append);
DLLEXPORT void write_reg_contents_lst(int name, char **strings, bool must_append, MotionType yank_type, colnr_T block_len);
DLLEXPORT void write_reg_contents_ex(int name, const char *str, ssize_t len, bool must_append, MotionType yank_type, colnr_T block_len);
DLLEXPORT bool prepare_yankreg_from_object(yankreg_T *reg, String regtype, size_t lines);
DLLEXPORT void finish_yankreg_from_object(yankreg_T *reg, bool clipboard_adjust);
#include "nvim/func_attr.h"
