
module MenhirBasics = struct
  
  exception Error of int
  
  let _eRR =
    fun _s ->
      raise (Error _s)
  
  type token = 
    | UNDERSCORE
    | UID of (
# 102 "src/stage2/parser.mly"
       (string Positions.located)
# 16 "src/stage2/parser.ml"
  )
    | TYPE
    | TOKEN
    | TILDE
    | START
    | STAR
    | SEMI
    | RPAREN
    | RIGHT
    | QUESTION
    | QID of (
# 102 "src/stage2/parser.mly"
       (string Positions.located)
# 30 "src/stage2/parser.ml"
  )
    | PUBLIC
    | PREC
    | PLUS
    | PERCENTPERCENT of (
# 113 "src/stage2/parser.mly"
       (Stretch.t Lazy.t)
# 38 "src/stage2/parser.ml"
  )
    | PERCENTATTRIBUTE
    | PARAMETER
    | ON_ERROR_REDUCE
    | OCAMLTYPE of (
# 110 "src/stage2/parser.mly"
       (Stretch.ocamltype)
# 46 "src/stage2/parser.ml"
  )
    | NONASSOC
    | LPAREN
    | LID of (
# 102 "src/stage2/parser.mly"
       (string Positions.located)
# 53 "src/stage2/parser.ml"
  )
    | LET
    | LEFT
    | INLINE
    | HEADER of (
# 107 "src/stage2/parser.mly"
       (Stretch.t)
# 61 "src/stage2/parser.ml"
  )
    | GRAMMARATTRIBUTE of (
# 119 "src/stage2/parser.mly"
       (Attribute.attribute)
# 66 "src/stage2/parser.ml"
  )
    | EQUALEQUAL
    | EQUAL
    | EOF
    | COMMA
    | COLONEQUAL
    | COLON
    | BAR
    | ATTRIBUTE of (
# 119 "src/stage2/parser.mly"
       (Attribute.attribute)
# 78 "src/stage2/parser.ml"
  )
    | ACTION of (
# 116 "src/stage2/parser.mly"
       (Syntax.raw_action)
# 83 "src/stage2/parser.ml"
  )
  
end

include MenhirBasics

# 21 "src/stage2/parser.mly"
  

open Stretch
open Syntax
open Positions

(* An injection of symbol expressions into choice expressions. *)

let inject (e : symbol_expression located) : expression =
  Positions.pmap (fun pos e ->
    let branch =
      Branch (
          Positions.with_pos pos (ESingleton e),
          ParserAux.new_production_level()
      )
    in
    EChoice [ branch ]
  ) e

(* When a stretch has been created by [Lexer.mk_stretch] with [parenthesize]
   set to [true], it includes parentheses. In some (rare) cases, this is
   undesirable. The following function removes the parentheses a posteriori.
   They are replaced with whitespace, so as to not alter column numbers. *)

let rec find s n i =
  assert (i < n);
  if s.[i] = '(' then i
  else begin
    assert (s.[i] = ' ');
    find s n (i+1)
  end

let unparenthesize (s : string) : string =
  let n = String.length s in
  (* The string [s] must end with a closing parenthesis. *)
  assert (n >= 2 && s.[n-1] = ')');
  (* The string [s] must begin with a certain amount of spaces
     followed with an opening parenthesis. Find its offset [i]. *)
  let i = find s n 0 in
  (* Create a copy without the parentheses. *)
  let b = Bytes.of_string s in
  Bytes.set b i ' ';
  Bytes.set b (n-1) ' ';
  Bytes.to_string b

let unparenthesize (s : Stretch.t) : Stretch.t =
  { s with stretch_content = unparenthesize s.stretch_content }

let unparenthesize (o : Stretch.t option) : Stretch.t option =
  Option.map unparenthesize o


# 143 "src/stage2/parser.ml"

type ('s, 'r) _menhir_state = 
  | MenhirState000 : ('s, _menhir_box_grammar) _menhir_state
    (** State 000.
        Stack shape : .
        Start symbol: grammar. *)

  | MenhirState002 : (('s, _menhir_box_grammar) _menhir_cell1_TYPE _menhir_cell0_OCAMLTYPE, _menhir_box_grammar) _menhir_state
    (** State 002.
        Stack shape : TYPE OCAMLTYPE.
        Start symbol: grammar. *)

  | MenhirState006 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 006.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState007 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 007.
        Stack shape : symbol LPAREN.
        Start symbol: grammar. *)

  | MenhirState011 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 011.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState012 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 012.
        Stack shape : symbol LPAREN.
        Start symbol: grammar. *)

  | MenhirState013 : (('s, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_state
    (** State 013.
        Stack shape : strict_actual.
        Start symbol: grammar. *)

  | MenhirState017 : ((('s, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_cell1_COMMA, _menhir_box_grammar) _menhir_state
    (** State 017.
        Stack shape : strict_actual COMMA.
        Start symbol: grammar. *)

  | MenhirState027 : (('s, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_state
    (** State 027.
        Stack shape : strict_actual.
        Start symbol: grammar. *)

  | MenhirState032 : ((('s, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_cell1_option_COMMA_, _menhir_box_grammar) _menhir_state
    (** State 032.
        Stack shape : strict_actual option(COMMA).
        Start symbol: grammar. *)

  | MenhirState037 : (('s, _menhir_box_grammar) _menhir_cell1_TOKEN, _menhir_box_grammar) _menhir_state
    (** State 037.
        Stack shape : TOKEN.
        Start symbol: grammar. *)

  | MenhirState039 : ((('s, _menhir_box_grammar) _menhir_cell1_TOKEN, _menhir_box_grammar) _menhir_cell1_option_OCAMLTYPE_, _menhir_box_grammar) _menhir_state
    (** State 039.
        Stack shape : TOKEN option(OCAMLTYPE).
        Start symbol: grammar. *)

  | MenhirState042 : (('s, _menhir_box_grammar) _menhir_cell1_UID _menhir_cell0_option_QID_, _menhir_box_grammar) _menhir_state
    (** State 042.
        Stack shape : UID option(QID).
        Start symbol: grammar. *)

  | MenhirState043 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 043.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState045 : ((('s, _menhir_box_grammar) _menhir_cell1_UID _menhir_cell0_option_QID_, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_state
    (** State 045.
        Stack shape : UID option(QID) list(ATTRIBUTE).
        Start symbol: grammar. *)

  | MenhirState046 : (((('s, _menhir_box_grammar) _menhir_cell1_UID _menhir_cell0_option_QID_, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_option_COMMA_, _menhir_box_grammar) _menhir_state
    (** State 046.
        Stack shape : UID option(QID) list(ATTRIBUTE) option(COMMA).
        Start symbol: grammar. *)

  | MenhirState049 : (('s, _menhir_box_grammar) _menhir_cell1_START, _menhir_box_grammar) _menhir_state
    (** State 049.
        Stack shape : START.
        Start symbol: grammar. *)

  | MenhirState051 : ((('s, _menhir_box_grammar) _menhir_cell1_START, _menhir_box_grammar) _menhir_cell1_option_OCAMLTYPE_, _menhir_box_grammar) _menhir_state
    (** State 051.
        Stack shape : START option(OCAMLTYPE).
        Start symbol: grammar. *)

  | MenhirState052 : (('s, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_state
    (** State 052.
        Stack shape : LID.
        Start symbol: grammar. *)

  | MenhirState053 : ((('s, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_cell1_option_COMMA_, _menhir_box_grammar) _menhir_state
    (** State 053.
        Stack shape : LID option(COMMA).
        Start symbol: grammar. *)

  | MenhirState059 : (('s, _menhir_box_grammar) _menhir_cell1_PERCENTATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 059.
        Stack shape : PERCENTATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState061 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 061.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState062 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 062.
        Stack shape : symbol LPAREN.
        Start symbol: grammar. *)

  | MenhirState066 : (('s, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_state
    (** State 066.
        Stack shape : strict_actual.
        Start symbol: grammar. *)

  | MenhirState067 : ((('s, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_cell1_option_COMMA_, _menhir_box_grammar) _menhir_state
    (** State 067.
        Stack shape : strict_actual option(COMMA).
        Start symbol: grammar. *)

  | MenhirState070 : ((('s, _menhir_box_grammar) _menhir_cell1_PERCENTATTRIBUTE, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_option_COMMA__strict_actual_, _menhir_box_grammar) _menhir_state
    (** State 070.
        Stack shape : PERCENTATTRIBUTE separated_nonempty_list(option(COMMA),strict_actual).
        Start symbol: grammar. *)

  | MenhirState071 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 071.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState076 : (('s, _menhir_box_grammar) _menhir_cell1_ON_ERROR_REDUCE, _menhir_box_grammar) _menhir_state
    (** State 076.
        Stack shape : ON_ERROR_REDUCE.
        Start symbol: grammar. *)

  | MenhirState086 : (('s, _menhir_box_grammar) _menhir_cell1_priority_keyword, _menhir_box_grammar) _menhir_state
    (** State 086.
        Stack shape : priority_keyword.
        Start symbol: grammar. *)

  | MenhirState087 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 087.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState088 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_option_COMMA_, _menhir_box_grammar) _menhir_state
    (** State 088.
        Stack shape : symbol option(COMMA).
        Start symbol: grammar. *)

  | MenhirState092 : (('s, _menhir_box_grammar) _menhir_cell1_list_declaration_ _menhir_cell0_PERCENTPERCENT, _menhir_box_grammar) _menhir_state
    (** State 092.
        Stack shape : list(declaration) PERCENTPERCENT.
        Start symbol: grammar. *)

  | MenhirState097 : (('s, _menhir_box_grammar) _menhir_cell1_old_rule, _menhir_box_grammar) _menhir_state
    (** State 097.
        Stack shape : old_rule.
        Start symbol: grammar. *)

  | MenhirState098 : (('s, _menhir_box_grammar) _menhir_cell1_new_rule, _menhir_box_grammar) _menhir_state
    (** State 098.
        Stack shape : new_rule.
        Start symbol: grammar. *)

  | MenhirState100 : (('s, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_state
    (** State 100.
        Stack shape : flags.
        Start symbol: grammar. *)

  | MenhirState104 : ((('s, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 104.
        Stack shape : flags symbol.
        Start symbol: grammar. *)

  | MenhirState105 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 105.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState107 : (((('s, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_state
    (** State 107.
        Stack shape : flags symbol list(ATTRIBUTE).
        Start symbol: grammar. *)

  | MenhirState108 : ((('s, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 108.
        Stack shape : list(ATTRIBUTE) LPAREN.
        Start symbol: grammar. *)

  | MenhirState110 : (('s, _menhir_box_grammar) _menhir_cell1_symbol _menhir_cell0_COMMA, _menhir_box_grammar) _menhir_state
    (** State 110.
        Stack shape : symbol COMMA.
        Start symbol: grammar. *)

  | MenhirState117 : ((((('s, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_COLON _menhir_cell0_optional_bar, _menhir_box_grammar) _menhir_state
    (** State 117.
        Stack shape : flags symbol list(ATTRIBUTE) loption(delimited(LPAREN,separated_nonempty_list(COMMA,symbol),RPAREN)) COLON optional_bar.
        Start symbol: grammar. *)

  | MenhirState119 : (('s, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_state
    (** State 119.
        Stack shape : LID.
        Start symbol: grammar. *)

  | MenhirState121 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 121.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState122 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 122.
        Stack shape : symbol LPAREN.
        Start symbol: grammar. *)

  | MenhirState123 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 123.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState129 : (('s, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION, _menhir_box_grammar) _menhir_state
    (** State 129.
        Stack shape : separated_nonempty_list(BAR,production) ACTION.
        Start symbol: grammar. *)

  | MenhirState130 : (('s, _menhir_box_grammar) _menhir_cell1_PREC, _menhir_box_grammar) _menhir_state
    (** State 130.
        Stack shape : PREC.
        Start symbol: grammar. *)

  | MenhirState133 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 133.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState135 : ((('s, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_state
    (** State 135.
        Stack shape : separated_nonempty_list(BAR,production) ACTION precedence.
        Start symbol: grammar. *)

  | MenhirState139 : (('s, _menhir_box_grammar) _menhir_cell1_production_group _menhir_cell0_BAR, _menhir_box_grammar) _menhir_state
    (** State 139.
        Stack shape : production_group BAR.
        Start symbol: grammar. *)

  | MenhirState142 : (('s, _menhir_box_grammar) _menhir_cell1_production _menhir_cell0_BAR, _menhir_box_grammar) _menhir_state
    (** State 142.
        Stack shape : production BAR.
        Start symbol: grammar. *)

  | MenhirState144 : (('s, _menhir_box_grammar) _menhir_cell1_producer, _menhir_box_grammar) _menhir_state
    (** State 144.
        Stack shape : producer.
        Start symbol: grammar. *)

  | MenhirState146 : (('s, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_state
    (** State 146.
        Stack shape : actual.
        Start symbol: grammar. *)

  | MenhirState147 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 147.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState150 : ((('s, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_state
    (** State 150.
        Stack shape : actual list(ATTRIBUTE).
        Start symbol: grammar. *)

  | MenhirState151 : (('s, _menhir_box_grammar) _menhir_cell1_SEMI, _menhir_box_grammar) _menhir_state
    (** State 151.
        Stack shape : SEMI.
        Start symbol: grammar. *)

  | MenhirState154 : (('s, _menhir_box_grammar) _menhir_cell1_list_producer_, _menhir_box_grammar) _menhir_state
    (** State 154.
        Stack shape : list(producer).
        Start symbol: grammar. *)

  | MenhirState155 : (('s, _menhir_box_grammar) _menhir_cell1_PREC, _menhir_box_grammar) _menhir_state
    (** State 155.
        Stack shape : PREC.
        Start symbol: grammar. *)

  | MenhirState160 : (('s, _menhir_box_grammar) _menhir_cell1_lax_actual _menhir_cell0_COMMA, _menhir_box_grammar) _menhir_state
    (** State 160.
        Stack shape : lax_actual COMMA.
        Start symbol: grammar. *)

  | MenhirState162 : (('s, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_state
    (** State 162.
        Stack shape : actual.
        Start symbol: grammar. *)

  | MenhirState165 : ((('s, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_state
    (** State 165.
        Stack shape : LID actual.
        Start symbol: grammar. *)

  | MenhirState166 : (((('s, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_state
    (** State 166.
        Stack shape : LID actual list(ATTRIBUTE).
        Start symbol: grammar. *)

  | MenhirState168 : (((((('s, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_COLON _menhir_cell0_optional_bar, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_group_, _menhir_box_grammar) _menhir_state
    (** State 168.
        Stack shape : flags symbol list(ATTRIBUTE) loption(delimited(LPAREN,separated_nonempty_list(COMMA,symbol),RPAREN)) COLON optional_bar separated_nonempty_list(BAR,production_group).
        Start symbol: grammar. *)

  | MenhirState169 : (('s, _menhir_box_grammar) _menhir_cell1_SEMI, _menhir_box_grammar) _menhir_state
    (** State 169.
        Stack shape : SEMI.
        Start symbol: grammar. *)

  | MenhirState173 : (('s, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION, _menhir_box_grammar) _menhir_state
    (** State 173.
        Stack shape : separated_nonempty_list(BAR,production) ACTION.
        Start symbol: grammar. *)

  | MenhirState174 : (('s, _menhir_box_grammar) _menhir_cell1_PREC, _menhir_box_grammar) _menhir_state
    (** State 174.
        Stack shape : PREC.
        Start symbol: grammar. *)

  | MenhirState179 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 179.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState181 : ((('s, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_state
    (** State 181.
        Stack shape : separated_nonempty_list(BAR,production) ACTION precedence.
        Start symbol: grammar. *)

  | MenhirState185 : (('s, _menhir_box_grammar) _menhir_cell1_production_group _menhir_cell0_BAR, _menhir_box_grammar) _menhir_state
    (** State 185.
        Stack shape : production_group BAR.
        Start symbol: grammar. *)

  | MenhirState189 : (('s, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID, _menhir_box_grammar) _menhir_state
    (** State 189.
        Stack shape : boption(PUBLIC) LET LID.
        Start symbol: grammar. *)

  | MenhirState190 : (('s, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE, _menhir_box_grammar) _menhir_state
    (** State 190.
        Stack shape : ATTRIBUTE.
        Start symbol: grammar. *)

  | MenhirState192 : ((('s, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_state
    (** State 192.
        Stack shape : boption(PUBLIC) LET LID list(ATTRIBUTE).
        Start symbol: grammar. *)

  | MenhirState193 : ((('s, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 193.
        Stack shape : list(ATTRIBUTE) LPAREN.
        Start symbol: grammar. *)

  | MenhirState199 : (((('s, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_equality_symbol, _menhir_box_grammar) _menhir_state
    (** State 199.
        Stack shape : boption(PUBLIC) LET LID list(ATTRIBUTE) loption(delimited(LPAREN,separated_nonempty_list(COMMA,symbol),RPAREN)) equality_symbol.
        Start symbol: grammar. *)

  | MenhirState202 : (('s, _menhir_box_grammar) _menhir_cell1_PREC, _menhir_box_grammar) _menhir_state
    (** State 202.
        Stack shape : PREC.
        Start symbol: grammar. *)

  | MenhirState208 : (('s, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 208.
        Stack shape : LPAREN.
        Start symbol: grammar. *)

  | MenhirState211 : (('s, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 211.
        Stack shape : LPAREN.
        Start symbol: grammar. *)

  | MenhirState215 : (('s, _menhir_box_grammar) _menhir_cell1_pattern _menhir_cell0_COMMA, _menhir_box_grammar) _menhir_state
    (** State 215.
        Stack shape : pattern COMMA.
        Start symbol: grammar. *)

  | MenhirState222 : (('s, _menhir_box_grammar) _menhir_cell1_BAR, _menhir_box_grammar) _menhir_state
    (** State 222.
        Stack shape : BAR.
        Start symbol: grammar. *)

  | MenhirState225 : (('s, _menhir_box_grammar) _menhir_cell1_symbol_expression, _menhir_box_grammar) _menhir_state
    (** State 225.
        Stack shape : symbol_expression.
        Start symbol: grammar. *)

  | MenhirState226 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 226.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState227 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 227.
        Stack shape : symbol LPAREN.
        Start symbol: grammar. *)

  | MenhirState230 : (('s, _menhir_box_grammar) _menhir_cell1_BAR, _menhir_box_grammar) _menhir_state
    (** State 230.
        Stack shape : BAR.
        Start symbol: grammar. *)

  | MenhirState233 : (('s, _menhir_box_grammar) _menhir_cell1_symbol_expression, _menhir_box_grammar) _menhir_state
    (** State 233.
        Stack shape : symbol_expression.
        Start symbol: grammar. *)

  | MenhirState234 : (('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_state
    (** State 234.
        Stack shape : symbol.
        Start symbol: grammar. *)

  | MenhirState235 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN, _menhir_box_grammar) _menhir_state
    (** State 235.
        Stack shape : symbol LPAREN.
        Start symbol: grammar. *)

  | MenhirState239 : (('s, _menhir_box_grammar) _menhir_cell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_cell0_BAR, _menhir_box_grammar) _menhir_state
    (** State 239.
        Stack shape : reversed_preceded_or_separated_nonempty_llist(BAR,branch) BAR.
        Start symbol: grammar. *)

  | MenhirState241 : (('s, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_state
    (** State 241.
        Stack shape : precedence.
        Start symbol: grammar. *)

  | MenhirState242 : ((('s, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_state
    (** State 242.
        Stack shape : precedence action.
        Start symbol: grammar. *)

  | MenhirState245 : (('s, _menhir_box_grammar) _menhir_cell1_pattern, _menhir_box_grammar) _menhir_state
    (** State 245.
        Stack shape : pattern.
        Start symbol: grammar. *)

  | MenhirState247 : ((('s, _menhir_box_grammar) _menhir_cell1_pattern, _menhir_box_grammar) _menhir_cell1_symbol_expression, _menhir_box_grammar) _menhir_state
    (** State 247.
        Stack shape : pattern symbol_expression.
        Start symbol: grammar. *)

  | MenhirState248 : (('s, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_, _menhir_box_grammar) _menhir_state
    (** State 248.
        Stack shape : located(symbol_expression).
        Start symbol: grammar. *)

  | MenhirState249 : ((('s, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_, _menhir_box_grammar) _menhir_cell1_located_modifier_, _menhir_box_grammar) _menhir_state
    (** State 249.
        Stack shape : located(symbol_expression) located(modifier).
        Start symbol: grammar. *)

  | MenhirState253 : (('s, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_state
    (** State 253.
        Stack shape : action.
        Start symbol: grammar. *)

  | MenhirState254 : ((('s, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_state
    (** State 254.
        Stack shape : action precedence.
        Start symbol: grammar. *)

  | MenhirState257 : (('s, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_, _menhir_box_grammar) _menhir_state
    (** State 257.
        Stack shape : located(symbol_expression).
        Start symbol: grammar. *)

  | MenhirState262 : ((('s, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_, _menhir_box_grammar) _menhir_cell1_located_modifier_, _menhir_box_grammar) _menhir_state
    (** State 262.
        Stack shape : located(symbol_expression) located(modifier).
        Start symbol: grammar. *)

  | MenhirState268 : (('s, _menhir_box_grammar) _menhir_cell1_expression _menhir_cell0_COMMA, _menhir_box_grammar) _menhir_state
    (** State 268.
        Stack shape : expression COMMA.
        Start symbol: grammar. *)

  | MenhirState270 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__, _menhir_box_grammar) _menhir_state
    (** State 270.
        Stack shape : symbol loption(delimited(LPAREN,separated_nonempty_list(COMMA,expression),RPAREN)).
        Start symbol: grammar. *)

  | MenhirState276 : ((('s, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__, _menhir_box_grammar) _menhir_state
    (** State 276.
        Stack shape : symbol loption(delimited(LPAREN,separated_nonempty_list(COMMA,expression),RPAREN)).
        Start symbol: grammar. *)

  | MenhirState279 : (('s, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_state
    (** State 279.
        Stack shape : precedence.
        Start symbol: grammar. *)

  | MenhirState280 : ((('s, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_state
    (** State 280.
        Stack shape : precedence action.
        Start symbol: grammar. *)

  | MenhirState283 : (('s, _menhir_box_grammar) _menhir_cell1_pattern, _menhir_box_grammar) _menhir_state
    (** State 283.
        Stack shape : pattern.
        Start symbol: grammar. *)

  | MenhirState285 : ((('s, _menhir_box_grammar) _menhir_cell1_pattern, _menhir_box_grammar) _menhir_cell1_symbol_expression, _menhir_box_grammar) _menhir_state
    (** State 285.
        Stack shape : pattern symbol_expression.
        Start symbol: grammar. *)

  | MenhirState288 : (('s, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_state
    (** State 288.
        Stack shape : action.
        Start symbol: grammar. *)

  | MenhirState289 : ((('s, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_state
    (** State 289.
        Stack shape : action precedence.
        Start symbol: grammar. *)

  | MenhirState295 : (('s, _menhir_box_grammar) _menhir_cell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_cell0_BAR, _menhir_box_grammar) _menhir_state
    (** State 295.
        Stack shape : reversed_preceded_or_separated_nonempty_llist(BAR,branch) BAR.
        Start symbol: grammar. *)

  | MenhirState306 : (('s, _menhir_box_grammar) _menhir_cell1_declaration, _menhir_box_grammar) _menhir_state
    (** State 306.
        Stack shape : declaration.
        Start symbol: grammar. *)


and ('s, 'r) _menhir_cell1_action = 
  | MenhirCell1_action of 's * ('s, 'r) _menhir_state * (Syntax.extended_action) * Lexing.position

and ('s, 'r) _menhir_cell1_actual = 
  | MenhirCell1_actual of 's * ('s, 'r) _menhir_state * (Syntax.parameter) * Lexing.position

and ('s, 'r) _menhir_cell1_boption_PUBLIC_ = 
  | MenhirCell1_boption_PUBLIC_ of 's * ('s, 'r) _menhir_state * (bool)

and ('s, 'r) _menhir_cell1_declaration = 
  | MenhirCell1_declaration of 's * ('s, 'r) _menhir_state * (Syntax.declaration Syntax.located list)

and 's _menhir_cell0_equality_symbol = 
  | MenhirCell0_equality_symbol of 's * (bool)

and ('s, 'r) _menhir_cell1_expression = 
  | MenhirCell1_expression of 's * ('s, 'r) _menhir_state * (Syntax.expression)

and ('s, 'r) _menhir_cell1_flags = 
  | MenhirCell1_flags of 's * ('s, 'r) _menhir_state * (bool * bool)

and ('s, 'r) _menhir_cell1_lax_actual = 
  | MenhirCell1_lax_actual of 's * ('s, 'r) _menhir_state * (Syntax.parameter)

and ('s, 'r) _menhir_cell1_list_ATTRIBUTE_ = 
  | MenhirCell1_list_ATTRIBUTE_ of 's * ('s, 'r) _menhir_state * (Attribute.attributes) * Lexing.position

and ('s, 'r) _menhir_cell1_list_declaration_ = 
  | MenhirCell1_list_declaration_ of 's * ('s, 'r) _menhir_state * (Syntax.declaration Syntax.located list list)

and ('s, 'r) _menhir_cell1_list_producer_ = 
  | MenhirCell1_list_producer_ of 's * ('s, 'r) _menhir_state * (ParserAux.early_producers) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_list_rule_ = 
  | MenhirCell1_list_rule_ of 's * ('s, 'r) _menhir_state * (Syntax.parameterized_rule list)

and ('s, 'r) _menhir_cell1_located_modifier_ = 
  | MenhirCell1_located_modifier_ of 's * ('s, 'r) _menhir_state * (string Syntax.located)

and ('s, 'r) _menhir_cell1_located_symbol_expression_ = 
  | MenhirCell1_located_symbol_expression_ of 's * ('s, 'r) _menhir_state * (Syntax.symbol_expression Syntax.located) * Lexing.position

and ('s, 'r) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ = 
  | MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ of 's * ('s, 'r) _menhir_state * (Syntax.expression list)

and ('s, 'r) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ = 
  | MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ of 's * ('s, 'r) _menhir_state * (string Syntax.located list)

and ('s, 'r) _menhir_cell1_new_rule = 
  | MenhirCell1_new_rule of 's * ('s, 'r) _menhir_state * (Syntax.rule)

and ('s, 'r) _menhir_cell1_old_rule = 
  | MenhirCell1_old_rule of 's * ('s, 'r) _menhir_state * (Syntax.parameterized_rule)

and ('s, 'r) _menhir_cell1_option_COMMA_ = 
  | MenhirCell1_option_COMMA_ of 's * ('s, 'r) _menhir_state * (unit option)

and ('s, 'r) _menhir_cell1_option_OCAMLTYPE_ = 
  | MenhirCell1_option_OCAMLTYPE_ of 's * ('s, 'r) _menhir_state * (Stretch.ocamltype option)

and 's _menhir_cell0_option_QID_ = 
  | MenhirCell0_option_QID_ of 's * (string Syntax.located option)

and 's _menhir_cell0_optional_bar = 
  | MenhirCell0_optional_bar of 's * (unit) * Lexing.position

and ('s, 'r) _menhir_cell1_pattern = 
  | MenhirCell1_pattern of 's * ('s, 'r) _menhir_state * (Syntax.pattern) * Lexing.position

and ('s, 'r) _menhir_cell1_precedence = 
  | MenhirCell1_precedence of 's * ('s, 'r) _menhir_state * (string Syntax.located) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_priority_keyword = 
  | MenhirCell1_priority_keyword of 's * ('s, 'r) _menhir_state * (Syntax.token_associativity) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_producer = 
  | MenhirCell1_producer of 's * ('s, 'r) _menhir_state * (ParserAux.early_producer) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_production = 
  | MenhirCell1_production of 's * ('s, 'r) _menhir_state * (ParserAux.early_production) * Lexing.position

and ('s, 'r) _menhir_cell1_production_group = 
  | MenhirCell1_production_group of 's * ('s, 'r) _menhir_state * (Syntax.parameterized_branch list) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ = 
  | MenhirCell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ of 's * ('s, 'r) _menhir_state * (Syntax.branch list) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_separated_nonempty_list_BAR_production_ = 
  | MenhirCell1_separated_nonempty_list_BAR_production_ of 's * ('s, 'r) _menhir_state * (ParserAux.early_productions) * Lexing.position

and ('s, 'r) _menhir_cell1_separated_nonempty_list_BAR_production_group_ = 
  | MenhirCell1_separated_nonempty_list_BAR_production_group_ of 's * ('s, 'r) _menhir_state * (Syntax.parameterized_branch list list) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_separated_nonempty_list_option_COMMA__strict_actual_ = 
  | MenhirCell1_separated_nonempty_list_option_COMMA__strict_actual_ of 's * ('s, 'r) _menhir_state * (Syntax.parameter list)

and ('s, 'r) _menhir_cell1_strict_actual = 
  | MenhirCell1_strict_actual of 's * ('s, 'r) _menhir_state * (Syntax.parameter)

and ('s, 'r) _menhir_cell1_symbol = 
  | MenhirCell1_symbol of 's * ('s, 'r) _menhir_state * (string Syntax.located) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_symbol_expression = 
  | MenhirCell1_symbol_expression of 's * ('s, 'r) _menhir_state * (Syntax.symbol_expression) * Lexing.position * Lexing.position

and 's _menhir_cell0_ACTION = 
  | MenhirCell0_ACTION of 's * (
# 116 "src/stage2/parser.mly"
       (Syntax.raw_action)
# 796 "src/stage2/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_ATTRIBUTE = 
  | MenhirCell1_ATTRIBUTE of 's * ('s, 'r) _menhir_state * (
# 119 "src/stage2/parser.mly"
       (Attribute.attribute)
# 803 "src/stage2/parser.ml"
) * Lexing.position

and ('s, 'r) _menhir_cell1_BAR = 
  | MenhirCell1_BAR of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and 's _menhir_cell0_BAR = 
  | MenhirCell0_BAR of 's * Lexing.position * Lexing.position

and 's _menhir_cell0_COLON = 
  | MenhirCell0_COLON of 's * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_COMMA = 
  | MenhirCell1_COMMA of 's * ('s, 'r) _menhir_state * Lexing.position

and 's _menhir_cell0_COMMA = 
  | MenhirCell0_COMMA of 's * Lexing.position

and 's _menhir_cell0_LET = 
  | MenhirCell0_LET of 's * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_LID = 
  | MenhirCell1_LID of 's * ('s, 'r) _menhir_state * (
# 102 "src/stage2/parser.mly"
       (string Positions.located)
# 828 "src/stage2/parser.ml"
) * Lexing.position * Lexing.position

and 's _menhir_cell0_LID = 
  | MenhirCell0_LID of 's * (
# 102 "src/stage2/parser.mly"
       (string Positions.located)
# 835 "src/stage2/parser.ml"
) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_LPAREN = 
  | MenhirCell1_LPAREN of 's * ('s, 'r) _menhir_state * Lexing.position * Lexing.position

and 's _menhir_cell0_OCAMLTYPE = 
  | MenhirCell0_OCAMLTYPE of 's * (
# 110 "src/stage2/parser.mly"
       (Stretch.ocamltype)
# 845 "src/stage2/parser.ml"
) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_ON_ERROR_REDUCE = 
  | MenhirCell1_ON_ERROR_REDUCE of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_PERCENTATTRIBUTE = 
  | MenhirCell1_PERCENTATTRIBUTE of 's * ('s, 'r) _menhir_state * Lexing.position

and 's _menhir_cell0_PERCENTPERCENT = 
  | MenhirCell0_PERCENTPERCENT of 's * (
# 113 "src/stage2/parser.mly"
       (Stretch.t Lazy.t)
# 858 "src/stage2/parser.ml"
)

and ('s, 'r) _menhir_cell1_PREC = 
  | MenhirCell1_PREC of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_SEMI = 
  | MenhirCell1_SEMI of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_START = 
  | MenhirCell1_START of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_TOKEN = 
  | MenhirCell1_TOKEN of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_TYPE = 
  | MenhirCell1_TYPE of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_UID = 
  | MenhirCell1_UID of 's * ('s, 'r) _menhir_state * (
# 102 "src/stage2/parser.mly"
       (string Positions.located)
# 880 "src/stage2/parser.ml"
) * Lexing.position * Lexing.position

and _menhir_box_grammar = 
  | MenhirBox_grammar of (Syntax.partial_grammar) [@@unboxed]

let _menhir_action_001 =
  fun action ->
    (
# 674 "src/stage2/parser.mly"
    ( XATraditional action )
# 891 "src/stage2/parser.ml"
     : (Syntax.extended_action))

let _menhir_action_002 =
  fun _endpos_action_ _startpos_action_ action ->
    let _endpos = _endpos_action_ in
    let _startpos = _startpos_action_ in
    let _loc = (_startpos, _endpos) in
    (
# 676 "src/stage2/parser.mly"
    ( match ParserAux.validate_pointfree_action action with
      | os ->
          XAPointFree (unparenthesize os)
      | exception Lexpointfree.InvalidPointFreeAction ->
          Error.error [Positions.import _loc]
            "A point-free semantic action must consist \
             of a single OCaml identifier." (* or whitespace *)
    )
# 909 "src/stage2/parser.ml"
     : (Syntax.extended_action))

let _menhir_action_003 =
  fun action attrs ->
    (
# 651 "src/stage2/parser.mly"
    ( EAction (action, None, attrs) )
# 917 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_004 =
  fun action attrs prec ->
    (
# 654 "src/stage2/parser.mly"
    ( EAction (action, Some prec, attrs) )
# 925 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_005 =
  fun action attrs prec ->
    (
# 657 "src/stage2/parser.mly"
    ( EAction (action, Some prec, attrs) )
# 933 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_006 =
  fun params symbol ->
    let p =
      let actuals = 
# 709 "src/stage2/parser.mly"
    ( params )
# 942 "src/stage2/parser.ml"
       in
      
# 458 "src/stage2/parser.mly"
    ( Parameters.app symbol actuals )
# 947 "src/stage2/parser.ml"
      
    in
    (
# 469 "src/stage2/parser.mly"
    ( p )
# 953 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_007 =
  fun m p ->
    let p = 
# 461 "src/stage2/parser.mly"
    ( ParameterApp (m, [ p ]) )
# 961 "src/stage2/parser.ml"
     in
    (
# 469 "src/stage2/parser.mly"
    ( p )
# 966 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_008 =
  fun () ->
    (
# 134 "<standard.mly>"
    ( false )
# 974 "src/stage2/parser.ml"
     : (bool))

let _menhir_action_009 =
  fun () ->
    (
# 137 "<standard.mly>"
    ( true )
# 982 "src/stage2/parser.ml"
     : (bool))

let _menhir_action_010 =
  fun _endpos_h_ _startpos_h_ h ->
    let _endpos = _endpos_h_ in
    let _startpos = _startpos_h_ in
    let _loc = (_startpos, _endpos) in
    (
# 193 "src/stage2/parser.mly"
    ( [ with_loc _loc (DCode h) ] )
# 993 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_011 =
  fun ty xs ->
    let ts = 
# 269 "src/stage2/parser.mly"
    ( xs )
# 1001 "src/stage2/parser.ml"
     in
    (
# 196 "src/stage2/parser.mly"
    ( List.map (Positions.map (fun (terminal, alias, attrs) ->
        DToken (ty, terminal, alias, attrs)
      )) ts )
# 1008 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_012 =
  fun t xs ->
    let nts = 
# 269 "src/stage2/parser.mly"
    ( xs )
# 1016 "src/stage2/parser.ml"
     in
    (
# 202 "src/stage2/parser.mly"
    (
      match t with
      | None ->
          List.map (Positions.map (fun nonterminal -> DStart nonterminal)) nts
      | Some t ->
          Misc.mapd (fun ntloc ->
            Positions.mapd (fun nt -> DStart nt, DType (t, ParameterVar ntloc)) ntloc) nts
    )
# 1028 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_013 =
  fun t xs ->
    let ss = 
# 269 "src/stage2/parser.mly"
    ( xs )
# 1036 "src/stage2/parser.ml"
     in
    (
# 212 "src/stage2/parser.mly"
    ( List.map (Positions.map (fun nt -> DType (t, nt)))
        (List.map Parameters.with_pos ss) )
# 1042 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_014 =
  fun _endpos_k_ _startpos_k_ k xs ->
    let ss = 
# 269 "src/stage2/parser.mly"
    ( xs )
# 1050 "src/stage2/parser.ml"
     in
    let _loc_k_ = (_startpos_k_, _endpos_k_) in
    (
# 216 "src/stage2/parser.mly"
    ( let prec = ParserAux.new_precedence_level _loc_k_ in
      List.map (Positions.map (fun symbol -> DTokenProperties (symbol, k, prec))) ss )
# 1057 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_015 =
  fun _endpos_t_ _startpos__1_ t ->
    let _endpos = _endpos_t_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 220 "src/stage2/parser.mly"
    ( [ with_loc _loc (DParameter t) ] )
# 1068 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_016 =
  fun _endpos_attr_ _startpos_attr_ attr ->
    let _endpos = _endpos_attr_ in
    let _startpos = _startpos_attr_ in
    let _loc = (_startpos, _endpos) in
    (
# 223 "src/stage2/parser.mly"
    ( [ with_loc _loc (DGrammarAttribute attr) ] )
# 1079 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_017 =
  fun _endpos_attrs_ _startpos__1_ attrs xs ->
    let actuals = 
# 269 "src/stage2/parser.mly"
    ( xs )
# 1087 "src/stage2/parser.ml"
     in
    let _endpos = _endpos_attrs_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 226 "src/stage2/parser.mly"
    ( [ with_loc _loc (DSymbolAttributes (actuals, attrs)) ] )
# 1095 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_018 =
  fun xs ->
    let ss = 
# 269 "src/stage2/parser.mly"
    ( xs )
# 1103 "src/stage2/parser.ml"
     in
    (
# 229 "src/stage2/parser.mly"
    ( let prec = ParserAux.new_on_error_reduce_level() in
      List.map (Positions.map (fun nt -> DOnErrorReduce (nt, prec)))
        (List.map Parameters.with_pos ss) )
# 1110 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_019 =
  fun () ->
    (
# 234 "src/stage2/parser.mly"
    ( [] )
# 1118 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_020 =
  fun _endpos__1_ _startpos__1_ ->
    let _1 = 
# 261 "src/stage2/parser.mly"
    ( () )
# 1126 "src/stage2/parser.ml"
     in
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 241 "src/stage2/parser.mly"
    (
      Error.error [Positions.import _loc]
        "syntax error inside a declaration.\n\
         Did you perhaps forget the %%%% that separates declarations and rules?"
    )
# 1138 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_021 =
  fun _endpos__1_ _startpos__1_ ->
    let _1 = 
# 261 "src/stage2/parser.mly"
    ( () )
# 1146 "src/stage2/parser.ml"
     in
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 241 "src/stage2/parser.mly"
    (
      Error.error [Positions.import _loc]
        "syntax error inside a declaration.\n\
         Did you perhaps forget the %%%% that separates declarations and rules?"
    )
# 1158 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_022 =
  fun _endpos__1_ _startpos__1_ ->
    let _1 = 
# 261 "src/stage2/parser.mly"
    ( () )
# 1166 "src/stage2/parser.ml"
     in
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 241 "src/stage2/parser.mly"
    (
      Error.error [Positions.import _loc]
        "syntax error inside a declaration.\n\
         Did you perhaps forget the %%%% that separates declarations and rules?"
    )
# 1178 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_023 =
  fun _endpos__1_ _startpos__1_ ->
    let _1 = 
# 261 "src/stage2/parser.mly"
    ( () )
# 1186 "src/stage2/parser.ml"
     in
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 241 "src/stage2/parser.mly"
    (
      Error.error [Positions.import _loc]
        "syntax error inside a declaration.\n\
         Did you perhaps forget the %%%% that separates declarations and rules?"
    )
# 1198 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_024 =
  fun _endpos__1_ _startpos__1_ ->
    let _1 = 
# 261 "src/stage2/parser.mly"
    ( () )
# 1206 "src/stage2/parser.ml"
     in
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 241 "src/stage2/parser.mly"
    (
      Error.error [Positions.import _loc]
        "syntax error inside a declaration.\n\
         Did you perhaps forget the %%%% that separates declarations and rules?"
    )
# 1218 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list))

let _menhir_action_025 =
  fun () ->
    (
# 544 "src/stage2/parser.mly"
    ( false )
# 1226 "src/stage2/parser.ml"
     : (bool))

let _menhir_action_026 =
  fun () ->
    (
# 546 "src/stage2/parser.mly"
    ( true  )
# 1234 "src/stage2/parser.ml"
     : (bool))

let _menhir_action_027 =
  fun e ->
    (
# 554 "src/stage2/parser.mly"
    ( e )
# 1242 "src/stage2/parser.ml"
     : (Syntax.expression))

let _menhir_action_028 =
  fun () ->
    (
# 350 "src/stage2/parser.mly"
    ( false, false )
# 1250 "src/stage2/parser.ml"
     : (bool * bool))

let _menhir_action_029 =
  fun () ->
    (
# 352 "src/stage2/parser.mly"
    ( true, false )
# 1258 "src/stage2/parser.ml"
     : (bool * bool))

let _menhir_action_030 =
  fun () ->
    (
# 354 "src/stage2/parser.mly"
    ( false, true )
# 1266 "src/stage2/parser.ml"
     : (bool * bool))

let _menhir_action_031 =
  fun () ->
    (
# 357 "src/stage2/parser.mly"
    ( true, true )
# 1274 "src/stage2/parser.ml"
     : (bool * bool))

let _menhir_action_032 =
  fun () ->
    (
# 357 "src/stage2/parser.mly"
    ( true, true )
# 1282 "src/stage2/parser.ml"
     : (bool * bool))

let _menhir_action_033 =
  fun rs t xss ->
    let ds = 
# 271 "<standard.mly>"
    ( List.flatten xss )
# 1290 "src/stage2/parser.ml"
     in
    (
# 177 "src/stage2/parser.mly"
    (
      {
        pg_filename          = ""; (* filled in by the caller *)
        pg_declarations      = ds;
        pg_rules             = rs;
        pg_postlude          = t
      }
    )
# 1302 "src/stage2/parser.ml"
     : (Syntax.partial_grammar))

let _menhir_action_034 =
  fun params symbol ->
    let p =
      let actuals = 
# 709 "src/stage2/parser.mly"
    ( params )
# 1311 "src/stage2/parser.ml"
       in
      
# 458 "src/stage2/parser.mly"
    ( Parameters.app symbol actuals )
# 1316 "src/stage2/parser.ml"
      
    in
    (
# 473 "src/stage2/parser.mly"
    ( p )
# 1322 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_035 =
  fun m p ->
    let p = 
# 461 "src/stage2/parser.mly"
    ( ParameterApp (m, [ p ]) )
# 1330 "src/stage2/parser.ml"
     in
    (
# 473 "src/stage2/parser.mly"
    ( p )
# 1335 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_036 =
  fun branches ->
    (
# 477 "src/stage2/parser.mly"
    ( ParameterAnonymous branches )
# 1343 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_037 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 1351 "src/stage2/parser.ml"
     : (Attribute.attributes))

let _menhir_action_038 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 1359 "src/stage2/parser.ml"
     : (Attribute.attributes))

let _menhir_action_039 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 1367 "src/stage2/parser.ml"
     : (unit list))

let _menhir_action_040 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 1375 "src/stage2/parser.ml"
     : (unit list))

let _menhir_action_041 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 1383 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list list))

let _menhir_action_042 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 1391 "src/stage2/parser.ml"
     : (Syntax.declaration Syntax.located list list))

let _menhir_action_043 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 1399 "src/stage2/parser.ml"
     : (ParserAux.early_producers))

let _menhir_action_044 =
  fun x xs ->
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 1407 "src/stage2/parser.ml"
     : (ParserAux.early_producers))

let _menhir_action_045 =
  fun () ->
    (
# 216 "<standard.mly>"
    ( [] )
# 1415 "src/stage2/parser.ml"
     : (Syntax.parameterized_rule list))

let _menhir_action_046 =
  fun _1 xs ->
    let x = 
# 311 "src/stage2/parser.mly"
    ( _1 )
# 1423 "src/stage2/parser.ml"
     in
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 1428 "src/stage2/parser.ml"
     : (Syntax.parameterized_rule list))

let _menhir_action_047 =
  fun _1 xs ->
    let x = 
# 314 "src/stage2/parser.mly"
    ( NewRuleSyntax.rule _1 )
# 1436 "src/stage2/parser.ml"
     in
    (
# 219 "<standard.mly>"
    ( x :: xs )
# 1441 "src/stage2/parser.ml"
     : (Syntax.parameterized_rule list))

let _menhir_action_048 =
  fun _endpos_prods_ _startpos_prods_ prods ->
    let x = 
# 346 "src/stage2/parser.mly"
    ( List.flatten prods )
# 1449 "src/stage2/parser.ml"
     in
    let (_endpos_x_, _startpos_x_) = (_endpos_prods_, _startpos_prods_) in
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    let _loc = (_startpos, _endpos) in
    (
# 751 "src/stage2/parser.mly"
    ( with_loc _loc x )
# 1458 "src/stage2/parser.ml"
     : (Syntax.parameterized_branch list Syntax.located))

let _menhir_action_049 =
  fun _endpos_xs_ _startpos_xs_ xs ->
    let x =
      let branches =
        let xs = 
# 264 "<standard.mly>"
    ( List.rev xs )
# 1468 "src/stage2/parser.ml"
         in
        
# 732 "src/stage2/parser.mly"
    ( xs )
# 1473 "src/stage2/parser.ml"
        
      in
      
# 569 "src/stage2/parser.mly"
    ( EChoice branches )
# 1479 "src/stage2/parser.ml"
      
    in
    let (_endpos_x_, _startpos_x_) = (_endpos_xs_, _startpos_xs_) in
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    let _loc = (_startpos, _endpos) in
    (
# 751 "src/stage2/parser.mly"
    ( with_loc _loc x )
# 1489 "src/stage2/parser.ml"
     : (Syntax.choice_expression Syntax.located))

let _menhir_action_050 =
  fun _endpos_x_ _startpos_x_ x ->
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    let _loc = (_startpos, _endpos) in
    (
# 751 "src/stage2/parser.mly"
    ( with_loc _loc x )
# 1500 "src/stage2/parser.ml"
     : (string Syntax.located))

let _menhir_action_051 =
  fun _endpos_x_ _startpos_x_ x ->
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    let _loc = (_startpos, _endpos) in
    (
# 751 "src/stage2/parser.mly"
    ( with_loc _loc x )
# 1511 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression Syntax.located))

let _menhir_action_052 =
  fun _endpos_x_ _startpos_x_ x ->
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    let _loc = (_startpos, _endpos) in
    (
# 751 "src/stage2/parser.mly"
    ( with_loc _loc x )
# 1522 "src/stage2/parser.ml"
     : (Syntax.symbol_expression Syntax.located))

let _menhir_action_053 =
  fun () ->
    (
# 145 "<standard.mly>"
    ( [] )
# 1530 "src/stage2/parser.ml"
     : (Syntax.expression list))

let _menhir_action_054 =
  fun x ->
    let x = 
# 205 "<standard.mly>"
    ( x )
# 1538 "src/stage2/parser.ml"
     in
    (
# 148 "<standard.mly>"
    ( x )
# 1543 "src/stage2/parser.ml"
     : (Syntax.expression list))

let _menhir_action_055 =
  fun () ->
    (
# 145 "<standard.mly>"
    ( [] )
# 1551 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_056 =
  fun x ->
    let x = 
# 205 "<standard.mly>"
    ( x )
# 1559 "src/stage2/parser.ml"
     in
    (
# 148 "<standard.mly>"
    ( x )
# 1564 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_057 =
  fun () ->
    (
# 145 "<standard.mly>"
    ( [] )
# 1572 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_058 =
  fun x ->
    let x = 
# 205 "<standard.mly>"
    ( x )
# 1580 "src/stage2/parser.ml"
     in
    (
# 148 "<standard.mly>"
    ( x )
# 1585 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_059 =
  fun () ->
    (
# 145 "<standard.mly>"
    ( [] )
# 1593 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_060 =
  fun x ->
    let x = 
# 205 "<standard.mly>"
    ( x )
# 1601 "src/stage2/parser.ml"
     in
    (
# 148 "<standard.mly>"
    ( x )
# 1606 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_061 =
  fun () ->
    (
# 145 "<standard.mly>"
    ( [] )
# 1614 "src/stage2/parser.ml"
     : (Syntax.pattern list))

let _menhir_action_062 =
  fun x ->
    (
# 148 "<standard.mly>"
    ( x )
# 1622 "src/stage2/parser.ml"
     : (Syntax.pattern list))

let _menhir_action_063 =
  fun () ->
    (
# 491 "src/stage2/parser.mly"
    ( "option" )
# 1630 "src/stage2/parser.ml"
     : (string))

let _menhir_action_064 =
  fun () ->
    (
# 493 "src/stage2/parser.mly"
    ( "nonempty_list" )
# 1638 "src/stage2/parser.ml"
     : (string))

let _menhir_action_065 =
  fun () ->
    (
# 495 "src/stage2/parser.mly"
    ( "list" )
# 1646 "src/stage2/parser.ml"
     : (string))

let _menhir_action_066 =
  fun params rule_attributes rule_inline rule_lhs rule_public rule_rhs ->
    let rule_formals = 
# 709 "src/stage2/parser.mly"
    ( params )
# 1654 "src/stage2/parser.ml"
     in
    (
# 529 "src/stage2/parser.mly"
    ({
       rule_public;
       rule_inline;
       rule_lhs;
       rule_attributes;
       rule_formals;
       rule_rhs;
    })
# 1666 "src/stage2/parser.ml"
     : (Syntax.rule))

let _menhir_action_067 =
  fun x ->
    (
# 228 "<standard.mly>"
    ( [ x ] )
# 1674 "src/stage2/parser.ml"
     : (Attribute.attributes))

let _menhir_action_068 =
  fun x xs ->
    (
# 231 "<standard.mly>"
    ( x :: xs )
# 1682 "src/stage2/parser.ml"
     : (Attribute.attributes))

let _menhir_action_069 =
  fun attributes flags params prods symbol ->
    let branches = 
# 346 "src/stage2/parser.mly"
    ( List.flatten prods )
# 1690 "src/stage2/parser.ml"
     in
    let params = 
# 709 "src/stage2/parser.mly"
    ( params )
# 1695 "src/stage2/parser.ml"
     in
    (
# 330 "src/stage2/parser.mly"
    (
      let public, inline = flags in
      let rule = {
        pr_public_flag = public;
        pr_inline_flag = inline;
        pr_nt          = Positions.value symbol;
        pr_positions   = [ Positions.position symbol ];
        pr_attributes  = attributes;
        pr_parameters  = List.map Positions.value params;
        pr_branches    = branches
      }
      in rule
    )
# 1712 "src/stage2/parser.ml"
     : (Syntax.parameterized_rule))

let _menhir_action_070 =
  fun () ->
    (
# 111 "<standard.mly>"
    ( None )
# 1720 "src/stage2/parser.ml"
     : (unit option))

let _menhir_action_071 =
  fun x ->
    (
# 114 "<standard.mly>"
    ( Some x )
# 1728 "src/stage2/parser.ml"
     : (unit option))

let _menhir_action_072 =
  fun () ->
    (
# 111 "<standard.mly>"
    ( None )
# 1736 "src/stage2/parser.ml"
     : (Stretch.ocamltype option))

let _menhir_action_073 =
  fun x ->
    (
# 114 "<standard.mly>"
    ( Some x )
# 1744 "src/stage2/parser.ml"
     : (Stretch.ocamltype option))

let _menhir_action_074 =
  fun () ->
    (
# 111 "<standard.mly>"
    ( None )
# 1752 "src/stage2/parser.ml"
     : (string Syntax.located option))

let _menhir_action_075 =
  fun x ->
    (
# 114 "<standard.mly>"
    ( Some x )
# 1760 "src/stage2/parser.ml"
     : (string Syntax.located option))

let _menhir_action_076 =
  fun () ->
    (
# 362 "src/stage2/parser.mly"
    ( () )
# 1768 "src/stage2/parser.ml"
     : (unit))

let _menhir_action_077 =
  fun () ->
    (
# 362 "src/stage2/parser.mly"
    ( () )
# 1776 "src/stage2/parser.ml"
     : (unit))

let _menhir_action_078 =
  fun x ->
    (
# 689 "src/stage2/parser.mly"
    ( SemPatVar x )
# 1784 "src/stage2/parser.ml"
     : (Syntax.pattern))

let _menhir_action_079 =
  fun () ->
    (
# 691 "src/stage2/parser.mly"
    ( SemPatWildcard )
# 1792 "src/stage2/parser.ml"
     : (Syntax.pattern))

let _menhir_action_080 =
  fun _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    let _loc = (_startpos, _endpos) in
    (
# 693 "src/stage2/parser.mly"
    ( SemPatTilde (Positions.import _loc) )
# 1803 "src/stage2/parser.ml"
     : (Syntax.pattern))

let _menhir_action_081 =
  fun xs ->
    let ps = 
# 241 "<standard.mly>"
    ( xs )
# 1811 "src/stage2/parser.ml"
     in
    (
# 695 "src/stage2/parser.mly"
    ( SemPatTuple ps )
# 1816 "src/stage2/parser.ml"
     : (Syntax.pattern))

let _menhir_action_082 =
  fun () ->
    (
# 502 "src/stage2/parser.mly"
    ( None )
# 1824 "src/stage2/parser.ml"
     : (Syntax.postlude option))

let _menhir_action_083 =
  fun p ->
    (
# 504 "src/stage2/parser.mly"
    ( Some (Lazy.force p) )
# 1832 "src/stage2/parser.ml"
     : (Syntax.postlude option))

let _menhir_action_084 =
  fun symbol ->
    (
# 402 "src/stage2/parser.mly"
    ( symbol )
# 1840 "src/stage2/parser.ml"
     : (string Syntax.located))

let _menhir_action_085 =
  fun () ->
    (
# 249 "src/stage2/parser.mly"
    ( LeftAssoc )
# 1848 "src/stage2/parser.ml"
     : (Syntax.token_associativity))

let _menhir_action_086 =
  fun () ->
    (
# 251 "src/stage2/parser.mly"
    ( RightAssoc )
# 1856 "src/stage2/parser.ml"
     : (Syntax.token_associativity))

let _menhir_action_087 =
  fun () ->
    (
# 253 "src/stage2/parser.mly"
    ( NonAssoc )
# 1864 "src/stage2/parser.ml"
     : (Syntax.token_associativity))

let _menhir_action_088 =
  fun _endpos__0_ _endpos__4_ attrs p ->
    let id = 
# 123 "<standard.mly>"
    ( None )
# 1872 "src/stage2/parser.ml"
     in
    let _startpos_id_ = _endpos__0_ in
    let _endpos = _endpos__4_ in
    let _startpos = _startpos_id_ in
    let _loc = (_startpos, _endpos) in
    (
# 431 "src/stage2/parser.mly"
    ( position (with_loc _loc ()), id, p, attrs )
# 1881 "src/stage2/parser.ml"
     : (ParserAux.early_producer))

let _menhir_action_089 =
  fun _endpos__4_ _startpos_x_ attrs p x ->
    let id =
      let x = 
# 196 "<standard.mly>"
    ( x )
# 1890 "src/stage2/parser.ml"
       in
      
# 126 "<standard.mly>"
    ( Some x )
# 1895 "src/stage2/parser.ml"
      
    in
    let _startpos_id_ = _startpos_x_ in
    let _endpos = _endpos__4_ in
    let _startpos = _startpos_id_ in
    let _loc = (_startpos, _endpos) in
    (
# 431 "src/stage2/parser.mly"
    ( position (with_loc _loc ()), id, p, attrs )
# 1905 "src/stage2/parser.ml"
     : (ParserAux.early_producer))

let _menhir_action_090 =
  fun _endpos_producers_ _startpos_producers_ producers ->
    let oprec = 
# 123 "<standard.mly>"
    ( None )
# 1913 "src/stage2/parser.ml"
     in
    let _endpos_oprec_ = _endpos_producers_ in
    let _endpos = _endpos_oprec_ in
    let _startpos = _startpos_producers_ in
    let _loc = (_startpos, _endpos) in
    (
# 410 "src/stage2/parser.mly"
    ( producers,
      oprec,
      ParserAux.new_production_level(),
      Positions.import _loc
    )
# 1926 "src/stage2/parser.ml"
     : (ParserAux.early_production))

let _menhir_action_091 =
  fun _endpos_x_ _startpos_producers_ producers x ->
    let oprec = 
# 126 "<standard.mly>"
    ( Some x )
# 1934 "src/stage2/parser.ml"
     in
    let _endpos_oprec_ = _endpos_x_ in
    let _endpos = _endpos_oprec_ in
    let _startpos = _startpos_producers_ in
    let _loc = (_startpos, _endpos) in
    (
# 410 "src/stage2/parser.mly"
    ( producers,
      oprec,
      ParserAux.new_production_level(),
      Positions.import _loc
    )
# 1947 "src/stage2/parser.ml"
     : (ParserAux.early_production))

let _menhir_action_092 =
  fun action attrs productions ->
    let oprec2 = 
# 123 "<standard.mly>"
    ( None )
# 1955 "src/stage2/parser.ml"
     in
    (
# 377 "src/stage2/parser.mly"
    (
      (* If multiple productions share a single semantic action, check
         that all of them bind the same names. *)
      ParserAux.check_production_group productions;
      (* Then, *)
      List.map (fun (producers, oprec1, level, pos) ->
        (* Replace [$i] with [_i]. *)
        let pb_producers = ParserAux.normalize_producers producers in
        (* Distribute the semantic action and attributes onto every production.
           Also, check that every [$i] is within bounds. *)
        let names = ParserAux.producer_names producers in
        let pb_action = action Settings.dollars names in
        {
          pb_producers;
          pb_action;
          pb_prec_annotation  = ParserAux.override pos oprec1 oprec2;
          pb_production_level = level;
          pb_position         = pos;
          pb_attributes       = attrs;
        })
      productions
    )
# 1981 "src/stage2/parser.ml"
     : (Syntax.parameterized_branch list))

let _menhir_action_093 =
  fun action attrs productions x ->
    let oprec2 = 
# 126 "<standard.mly>"
    ( Some x )
# 1989 "src/stage2/parser.ml"
     in
    (
# 377 "src/stage2/parser.mly"
    (
      (* If multiple productions share a single semantic action, check
         that all of them bind the same names. *)
      ParserAux.check_production_group productions;
      (* Then, *)
      List.map (fun (producers, oprec1, level, pos) ->
        (* Replace [$i] with [_i]. *)
        let pb_producers = ParserAux.normalize_producers producers in
        (* Distribute the semantic action and attributes onto every production.
           Also, check that every [$i] is within bounds. *)
        let names = ParserAux.producer_names producers in
        let pb_action = action Settings.dollars names in
        {
          pb_producers;
          pb_action;
          pb_prec_annotation  = ParserAux.override pos oprec1 oprec2;
          pb_production_level = level;
          pb_position         = pos;
          pb_attributes       = attrs;
        })
      productions
    )
# 2015 "src/stage2/parser.ml"
     : (Syntax.parameterized_branch list))

let _menhir_action_094 =
  fun e e1 ->
    let e2 =
      let e2 = 
# 605 "src/stage2/parser.mly"
    ( e )
# 2024 "src/stage2/parser.ml"
       in
      
# 620 "src/stage2/parser.mly"
    ( e2 )
# 2029 "src/stage2/parser.ml"
      
    in
    (
# 609 "src/stage2/parser.mly"
    ( ECons (SemPatWildcard, e1, e2) )
# 2035 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_095 =
  fun e e1 p1 ->
    let e2 =
      let e2 = 
# 605 "src/stage2/parser.mly"
    ( e )
# 2044 "src/stage2/parser.ml"
       in
      
# 620 "src/stage2/parser.mly"
    ( e2 )
# 2049 "src/stage2/parser.ml"
      
    in
    (
# 611 "src/stage2/parser.mly"
    ( ECons (p1, e1, e2) )
# 2055 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_096 =
  fun e ->
    (
# 613 "src/stage2/parser.mly"
    ( ESingleton e )
# 2063 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_097 =
  fun e ->
    (
# 615 "src/stage2/parser.mly"
    ( e )
# 2071 "src/stage2/parser.ml"
     : (Syntax.raw_seq_expression))

let _menhir_action_098 =
  fun e ->
    let x =
      let e = 
# 605 "src/stage2/parser.mly"
    ( e )
# 2080 "src/stage2/parser.ml"
       in
      
# 573 "src/stage2/parser.mly"
    ( Branch (e, ParserAux.new_production_level()) )
# 2085 "src/stage2/parser.ml"
      
    in
    let _1 = 
# 123 "<standard.mly>"
    ( None )
# 2091 "src/stage2/parser.ml"
     in
    (
# 720 "src/stage2/parser.mly"
    ( [x] )
# 2096 "src/stage2/parser.ml"
     : (Syntax.branch list))

let _menhir_action_099 =
  fun e x_inlined1 ->
    let x =
      let e = 
# 605 "src/stage2/parser.mly"
    ( e )
# 2105 "src/stage2/parser.ml"
       in
      
# 573 "src/stage2/parser.mly"
    ( Branch (e, ParserAux.new_production_level()) )
# 2110 "src/stage2/parser.ml"
      
    in
    let _1 =
      let x = x_inlined1 in
      
# 126 "<standard.mly>"
    ( Some x )
# 2118 "src/stage2/parser.ml"
      
    in
    (
# 720 "src/stage2/parser.mly"
    ( [x] )
# 2124 "src/stage2/parser.ml"
     : (Syntax.branch list))

let _menhir_action_100 =
  fun e xs ->
    let x =
      let e = 
# 605 "src/stage2/parser.mly"
    ( e )
# 2133 "src/stage2/parser.ml"
       in
      
# 573 "src/stage2/parser.mly"
    ( Branch (e, ParserAux.new_production_level()) )
# 2138 "src/stage2/parser.ml"
      
    in
    (
# 724 "src/stage2/parser.mly"
    ( x :: xs )
# 2144 "src/stage2/parser.ml"
     : (Syntax.branch list))

let _menhir_action_101 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2152 "src/stage2/parser.ml"
     : (ParserAux.early_productions))

let _menhir_action_102 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2160 "src/stage2/parser.ml"
     : (ParserAux.early_productions))

let _menhir_action_103 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2168 "src/stage2/parser.ml"
     : (Syntax.parameterized_branch list list))

let _menhir_action_104 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2176 "src/stage2/parser.ml"
     : (Syntax.parameterized_branch list list))

let _menhir_action_105 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2184 "src/stage2/parser.ml"
     : (Syntax.expression list))

let _menhir_action_106 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2192 "src/stage2/parser.ml"
     : (Syntax.expression list))

let _menhir_action_107 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2200 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_108 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2208 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_109 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2216 "src/stage2/parser.ml"
     : (Syntax.pattern list))

let _menhir_action_110 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2224 "src/stage2/parser.ml"
     : (Syntax.pattern list))

let _menhir_action_111 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2232 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_112 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2240 "src/stage2/parser.ml"
     : (Syntax.parameters))

let _menhir_action_113 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2248 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_114 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2256 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_115 =
  fun id ->
    let x = 
# 303 "src/stage2/parser.mly"
    ( id )
# 2264 "src/stage2/parser.ml"
     in
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2269 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_116 =
  fun id xs ->
    let x = 
# 303 "src/stage2/parser.mly"
    ( id )
# 2277 "src/stage2/parser.ml"
     in
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2282 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_117 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2290 "src/stage2/parser.ml"
     : (Syntax.parameter list))

let _menhir_action_118 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2298 "src/stage2/parser.ml"
     : (Syntax.parameter list))

let _menhir_action_119 =
  fun x ->
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2306 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_120 =
  fun x xs ->
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2314 "src/stage2/parser.ml"
     : (string Syntax.located list))

let _menhir_action_121 =
  fun alias attrs id ->
    let x = 
# 298 "src/stage2/parser.mly"
    ( let alias = Option.map Positions.value alias in
      Positions.map (fun uid -> uid, alias, attrs) id )
# 2323 "src/stage2/parser.ml"
     in
    (
# 250 "<standard.mly>"
    ( [ x ] )
# 2328 "src/stage2/parser.ml"
     : ((string * Syntax.alias * Attribute.attributes) Syntax.located list))

let _menhir_action_122 =
  fun alias attrs id xs ->
    let x = 
# 298 "src/stage2/parser.mly"
    ( let alias = Option.map Positions.value alias in
      Positions.map (fun uid -> uid, alias, attrs) id )
# 2337 "src/stage2/parser.ml"
     in
    (
# 253 "<standard.mly>"
    ( x :: xs )
# 2342 "src/stage2/parser.ml"
     : ((string * Syntax.alias * Attribute.attributes) Syntax.located list))

let _menhir_action_123 =
  fun params symbol ->
    let p =
      let actuals = 
# 709 "src/stage2/parser.mly"
    ( params )
# 2351 "src/stage2/parser.ml"
       in
      
# 458 "src/stage2/parser.mly"
    ( Parameters.app symbol actuals )
# 2356 "src/stage2/parser.ml"
      
    in
    (
# 465 "src/stage2/parser.mly"
    ( p )
# 2362 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_124 =
  fun m p ->
    let p = 
# 461 "src/stage2/parser.mly"
    ( ParameterApp (m, [ p ]) )
# 2370 "src/stage2/parser.ml"
     in
    (
# 465 "src/stage2/parser.mly"
    ( p )
# 2375 "src/stage2/parser.ml"
     : (Syntax.parameter))

let _menhir_action_125 =
  fun id ->
    (
# 287 "src/stage2/parser.mly"
    ( id )
# 2383 "src/stage2/parser.ml"
     : (string Syntax.located))

let _menhir_action_126 =
  fun id ->
    (
# 287 "src/stage2/parser.mly"
    ( id )
# 2391 "src/stage2/parser.ml"
     : (string Syntax.located))

let _menhir_action_127 =
  fun id ->
    (
# 287 "src/stage2/parser.mly"
    ( id )
# 2399 "src/stage2/parser.ml"
     : (string Syntax.located))

let _menhir_action_128 =
  fun attrs params symbol ->
    let es = 
# 709 "src/stage2/parser.mly"
    ( params )
# 2407 "src/stage2/parser.ml"
     in
    (
# 638 "src/stage2/parser.mly"
    ( ESymbol (symbol, es, attrs) )
# 2412 "src/stage2/parser.ml"
     : (Syntax.symbol_expression))

let _menhir_action_129 =
  fun attrs e m ->
    (
# 643 "src/stage2/parser.mly"
    ( ESymbol (m, [ inject e ], attrs) )
# 2420 "src/stage2/parser.ml"
     : (Syntax.symbol_expression))

let _menhir_print_token : token -> string =
  fun _tok ->
    match _tok with
    | ACTION _ ->
        "ACTION"
    | ATTRIBUTE _ ->
        "ATTRIBUTE"
    | BAR ->
        "BAR"
    | COLON ->
        "COLON"
    | COLONEQUAL ->
        "COLONEQUAL"
    | COMMA ->
        "COMMA"
    | EOF ->
        "EOF"
    | EQUAL ->
        "EQUAL"
    | EQUALEQUAL ->
        "EQUALEQUAL"
    | GRAMMARATTRIBUTE _ ->
        "GRAMMARATTRIBUTE"
    | HEADER _ ->
        "HEADER"
    | INLINE ->
        "INLINE"
    | LEFT ->
        "LEFT"
    | LET ->
        "LET"
    | LID _ ->
        "LID"
    | LPAREN ->
        "LPAREN"
    | NONASSOC ->
        "NONASSOC"
    | OCAMLTYPE _ ->
        "OCAMLTYPE"
    | ON_ERROR_REDUCE ->
        "ON_ERROR_REDUCE"
    | PARAMETER ->
        "PARAMETER"
    | PERCENTATTRIBUTE ->
        "PERCENTATTRIBUTE"
    | PERCENTPERCENT _ ->
        "PERCENTPERCENT"
    | PLUS ->
        "PLUS"
    | PREC ->
        "PREC"
    | PUBLIC ->
        "PUBLIC"
    | QID _ ->
        "QID"
    | QUESTION ->
        "QUESTION"
    | RIGHT ->
        "RIGHT"
    | RPAREN ->
        "RPAREN"
    | SEMI ->
        "SEMI"
    | STAR ->
        "STAR"
    | START ->
        "START"
    | TILDE ->
        "TILDE"
    | TOKEN ->
        "TOKEN"
    | TYPE ->
        "TYPE"
    | UID _ ->
        "UID"
    | UNDERSCORE ->
        "UNDERSCORE"

let _menhir_fail : unit -> 'a =
  fun () ->
    Printf.eprintf "Internal failure -- please contact the parser generator's developers.\n%!";
    assert false

include struct
  
  [@@@ocaml.warning "-4-37"]
  
  let _menhir_goto_postlude : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_list_declaration_ _menhir_cell0_PERCENTPERCENT, _menhir_box_grammar) _menhir_cell1_list_rule_ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _v ->
      let MenhirCell1_list_rule_ (_menhir_stack, _, rs) = _menhir_stack in
      let MenhirCell0_PERCENTPERCENT (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_list_declaration_ (_menhir_stack, _, xss) = _menhir_stack in
      let t = _v in
      let _v = _menhir_action_033 rs t xss in
      MenhirBox_grammar _v
  
  let _menhir_run_301 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_list_declaration_ _menhir_cell0_PERCENTPERCENT as 'stack) -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_list_rule_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | PERCENTPERCENT _v_0 ->
          let p = _v_0 in
          let _v = _menhir_action_083 p in
          _menhir_goto_postlude _menhir_stack _v
      | EOF ->
          let _v = _menhir_action_082 () in
          _menhir_goto_postlude _menhir_stack _v
      | _ ->
          _menhir_fail ()
  
  let rec _menhir_run_300 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_old_rule -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _v _tok ->
      let MenhirCell1_old_rule (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_046 _1 xs in
      _menhir_goto_list_rule_ _menhir_stack _v _menhir_s _tok
  
  and _menhir_goto_list_rule_ : type  ttv_stack. ttv_stack -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState092 ->
          _menhir_run_301 _menhir_stack _v _menhir_s _tok
      | MenhirState097 ->
          _menhir_run_300 _menhir_stack _v _tok
      | MenhirState098 ->
          _menhir_run_099 _menhir_stack _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_099 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_new_rule -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _v _tok ->
      let MenhirCell1_new_rule (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_047 _1 xs in
      _menhir_goto_list_rule_ _menhir_stack _v _menhir_s _tok
  
  let rec _menhir_run_001 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_TYPE (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OCAMLTYPE _v ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_OCAMLTYPE (_menhir_stack, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState002 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 2)
      | _ ->
          _eRR 1
  
  and _menhir_run_003 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_126 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_goto_symbol : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState227 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_234 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState199 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState283 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState245 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_226 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState202 ->
          _menhir_run_206 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState174 ->
          _menhir_run_178 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState155 ->
          _menhir_run_156 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState130 ->
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState160 ->
          _menhir_run_123 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_123 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState185 ->
          _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState117 ->
          _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState144 ->
          _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState119 ->
          _menhir_run_121 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState193 ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState110 ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState108 ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState100 ->
          _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState088 ->
          _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState086 ->
          _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState067 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState059 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState062 ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState017 ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState012 ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState007 ->
          _menhir_run_011 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState076 ->
          _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState032 ->
          _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState002 ->
          _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_234 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState234 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState235 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | BAR ->
              _menhir_run_230 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ACTION _v ->
              _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 235)
      | ACTION _ | ATTRIBUTE _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_7 = _menhir_action_053 () in
          _menhir_run_270 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_7 MenhirState234 _tok
  
  and _menhir_run_200 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _startpos__1_ = _startpos in
      let _v = _menhir_action_079 () in
      _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_pattern : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_282 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_282 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_282 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_282 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_282 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_244 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState208 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState215 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState211 ->
          _menhir_run_214 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_282 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_pattern (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | EQUAL ->
          let _menhir_s = MenhirState283 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 283)
      | _ ->
          _eRR 282
  
  and _menhir_run_175 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_126 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_176 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_127 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_120 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_125 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_244 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_pattern (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | EQUAL ->
          let _menhir_s = MenhirState245 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 245)
      | _ ->
          _eRR 244
  
  and _menhir_run_214 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_pattern (_menhir_stack, _menhir_s, _v, _startpos) in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_COMMA (_menhir_stack, _endpos) in
          let _menhir_s = MenhirState215 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | TILDE ->
              _menhir_run_210 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LPAREN ->
              _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_212 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 215)
      | ACTION _ | ATTRIBUTE _ | BAR | COLON | COLONEQUAL | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let x = _v in
          let _v = _menhir_action_109 x in
          _menhir_goto_separated_nonempty_list_COMMA_pattern_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_209 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _startpos__1_ = _startpos in
      let _v = _menhir_action_079 () in
      _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_210 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_080 _endpos__1_ _startpos__1_ in
      _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_211 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UNDERSCORE ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState211
      | TILDE ->
          _menhir_run_210 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState211
      | LPAREN ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState211
      | LID _v ->
          _menhir_run_212 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState211
      | RPAREN ->
          let _v = _menhir_action_061 () in
          _menhir_run_217 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _eRR 211
  
  and _menhir_run_212 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_startpos_x_, x) = (_startpos, _v) in
      let _v = _menhir_action_078 x in
      _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_217 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAREN ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
          let xs = _v in
          let _v = _menhir_action_081 xs in
          _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR 217
  
  and _menhir_goto_separated_nonempty_list_COMMA_pattern_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState215 ->
          _menhir_run_216 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState208 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState211 ->
          _menhir_run_213 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_216 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_pattern _menhir_cell0_COMMA -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_COMMA (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_pattern (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_110 x xs in
      _menhir_goto_separated_nonempty_list_COMMA_pattern_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_213 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_LPAREN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let x = _v in
      let _v = _menhir_action_062 x in
      _menhir_goto_loption_separated_nonempty_list_COMMA_pattern__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_loption_separated_nonempty_list_COMMA_pattern__ : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_LPAREN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState208 ->
          _menhir_run_219 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState211 ->
          _menhir_run_217 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_219 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAREN ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos__1_, _) = _menhir_stack in
          let xs = _v in
          let _v = _menhir_action_081 xs in
          _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR 219
  
  and _menhir_run_008 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_126 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_201 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_080 _endpos__1_ _startpos__1_ in
      _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_009 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_127 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_202 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UID _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let id = _v in
            _menhir_action_126 id
          in
          _menhir_run_206 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | QID _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let id = _v in
            _menhir_action_127 id
          in
          _menhir_run_206 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | LID _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let id = _v in
            _menhir_action_125 id
          in
          _menhir_run_206 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR 202
  
  and _menhir_run_206 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_PREC -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_symbol_, symbol) = (_endpos, _v) in
      let _v = _menhir_action_084 symbol in
      _menhir_goto_precedence _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_symbol_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_precedence : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState288 ->
          _menhir_run_289 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState199 ->
          _menhir_run_279 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_279 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_279 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_279 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_279 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState253 ->
          _menhir_run_254 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_241 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState173 ->
          _menhir_run_181 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState154 ->
          _menhir_run_157 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState129 ->
          _menhir_run_135 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_289 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_action as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_precedence (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState289
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_290 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_179 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState179
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_180 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_038 x xs in
      _menhir_goto_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_goto_list_ATTRIBUTE_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState288 ->
          _menhir_run_291 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState289 ->
          _menhir_run_290 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState280 ->
          _menhir_run_281 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState276 ->
          _menhir_run_277 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState270 ->
          _menhir_run_271 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState262 ->
          _menhir_run_263 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState253 ->
          _menhir_run_256 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState254 ->
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState249 ->
          _menhir_run_250 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState242 ->
          _menhir_run_243 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState189 ->
          _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState190 ->
          _menhir_run_191 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState173 ->
          _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState181 ->
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState179 ->
          _menhir_run_180 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState165 ->
          _menhir_run_166 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState162 ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState146 ->
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState147 ->
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState129 ->
          _menhir_run_137 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState135 ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState133 ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState104 ->
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState105 ->
          _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState042 ->
          _menhir_run_045 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState043 ->
          _menhir_run_044 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_291 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_action -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_action (_menhir_stack, _menhir_s, action, _startpos_action_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_003 action attrs in
      _menhir_goto_action_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_action_ _v _menhir_s _tok
  
  and _menhir_goto_action_expression : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_287 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_287 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_287 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_287 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_287 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_252 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_287 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_e_, _startpos_e_, e) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_097 e in
      _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e_ _v _menhir_s _tok
  
  and _menhir_goto_raw_seq_expression : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_278 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_278 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_278 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_278 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_278 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_240 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_278 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_051 _endpos_x_ _startpos_x_ x in
      _menhir_goto_located_raw_seq_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_goto_located_raw_seq_expression_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_297 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_296 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState222 ->
          _menhir_run_293 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState225 ->
          _menhir_run_292 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState285 ->
          _menhir_run_286 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState230 ->
          _menhir_run_273 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState233 ->
          _menhir_run_272 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState227 ->
          _menhir_run_265 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_265 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_265 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_264 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState247 ->
          _menhir_run_251 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_297 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_e_, _startpos_e_, e) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_098 e in
      _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e_ _v _menhir_s _tok
  
  and _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_294 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_238 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_294 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | BAR ->
          let _menhir_stack = MenhirCell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_BAR (_menhir_stack, _startpos, _endpos) in
          let _menhir_s = MenhirState295 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 295)
      | EOF | INLINE | LET | LID _ | PERCENTPERCENT _ | PUBLIC | QID _ | UID _ ->
          let (_endpos_xs_, _startpos_xs_, xs) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_049 _endpos_xs_ _startpos_xs_ xs in
          _menhir_goto_located_choice_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 294
  
  and _menhir_run_207 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_action_, _startpos_action_, action) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_002 _endpos_action_ _startpos_action_ action in
      _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_action_ _v _menhir_s _tok
  
  and _menhir_goto_action : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_288 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState279 ->
          _menhir_run_280 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_253 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState241 ->
          _menhir_run_242 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_288 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_action (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | PREC ->
          _menhir_run_174 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState288
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState288
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_291 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_174 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UID _v ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState174
      | QID _v ->
          _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState174
      | LID _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let id = _v in
            _menhir_action_125 id
          in
          _menhir_run_178 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR 174
  
  and _menhir_run_178 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_PREC -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_symbol_, symbol) = (_endpos, _v) in
      let _v = _menhir_action_084 symbol in
      _menhir_goto_precedence _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_symbol_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_280 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_precedence as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_action (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState280
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_281 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_281 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_cell1_action -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_action (_menhir_stack, _, action, _) = _menhir_stack in
      let MenhirCell1_precedence (_menhir_stack, _menhir_s, prec, _startpos_prec_, _) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_004 action attrs prec in
      _menhir_goto_action_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_prec_ _v _menhir_s _tok
  
  and _menhir_run_253 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_action (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | PREC ->
          _menhir_run_130 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState253
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState253
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_256 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_130 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UID _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState130
      | QID _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState130
      | LID _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let id = _v in
            _menhir_action_125 id
          in
          _menhir_run_132 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR 130
  
  and _menhir_run_132 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_PREC -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_symbol_, symbol) = (_endpos, _v) in
      let _v = _menhir_action_084 symbol in
      _menhir_goto_precedence _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_symbol_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_133 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState133
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_134 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_038 x xs in
      _menhir_goto_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_256 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_action -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_action (_menhir_stack, _menhir_s, action, _startpos_action_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_003 action attrs in
      _menhir_goto_action_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_action_ _v _menhir_s _tok
  
  and _menhir_run_242 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_precedence as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_action (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState242
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_243 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_243 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_precedence, _menhir_box_grammar) _menhir_cell1_action -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_action (_menhir_stack, _, action, _) = _menhir_stack in
      let MenhirCell1_precedence (_menhir_stack, _menhir_s, prec, _startpos_prec_, _) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_004 action attrs prec in
      _menhir_goto_action_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_prec_ _v _menhir_s _tok
  
  and _menhir_run_208 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UNDERSCORE ->
          _menhir_run_209 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState208
      | TILDE ->
          _menhir_run_210 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState208
      | LPAREN ->
          _menhir_run_211 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState208
      | LID _v ->
          _menhir_run_212 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState208
      | RPAREN ->
          let _v = _menhir_action_061 () in
          _menhir_run_219 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _eRR 208
  
  and _menhir_run_221 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | EQUAL ->
          let (_startpos_x_, x) = (_startpos, _v) in
          let _v = _menhir_action_078 x in
          _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | ATTRIBUTE _ | BAR | EOF | INLINE | LET | LID _ | LPAREN | PERCENTPERCENT _ | PLUS | PUBLIC | QID _ | QUESTION | SEMI | STAR | UID _ ->
          let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_125 id in
          _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
      | _ ->
          _eRR 221
  
  and _menhir_run_223 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_startpos_action_, action) = (_startpos, _v) in
      let _v = _menhir_action_001 action in
      _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_action_ _v _menhir_s _tok
  
  and _menhir_goto_located_choice_expression_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_298 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_266 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_266 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_266 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_298 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let e = _v in
      let _v = _menhir_action_027 e in
      _menhir_goto_expression _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_expression : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_299 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState227 ->
          _menhir_run_267 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_267 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_267 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_299 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_equality_symbol -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_equality_symbol (_menhir_stack, rule_inline) = _menhir_stack in
      let MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ (_menhir_stack, _, params) = _menhir_stack in
      let MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _, rule_attributes, _) = _menhir_stack in
      let MenhirCell0_LID (_menhir_stack, rule_lhs, _, _) = _menhir_stack in
      let MenhirCell0_LET (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_boption_PUBLIC_ (_menhir_stack, _menhir_s, rule_public) = _menhir_stack in
      let rule_rhs = _v in
      let _v = _menhir_action_066 params rule_attributes rule_inline rule_lhs rule_public rule_rhs in
      let _menhir_stack = MenhirCell1_new_rule (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | PUBLIC ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState098
      | INLINE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState098
      | LET ->
          let _menhir_s = MenhirState098 in
          let _v = _menhir_action_008 () in
          _menhir_goto_boption_PUBLIC_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LID _ | QID _ | UID _ ->
          let _menhir_s = MenhirState098 in
          let _v = _menhir_action_028 () in
          _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | EOF | PERCENTPERCENT _ ->
          let _v_2 = _menhir_action_045 () in
          _menhir_run_099 _menhir_stack _v_2 _tok
      | _ ->
          _eRR 98
  
  and _menhir_run_093 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | INLINE ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v = _menhir_action_031 () in
          _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LET ->
          let _v = _menhir_action_009 () in
          _menhir_goto_boption_PUBLIC_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LID _ | QID _ | UID _ ->
          let _v = _menhir_action_029 () in
          _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 93
  
  and _menhir_goto_flags : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_flags (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_1 =
            let id = _v_0 in
            _menhir_action_126 id
          in
          _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v_1 MenhirState100 _tok
      | QID _v_2 ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_3 =
            let id = _v_2 in
            _menhir_action_127 id
          in
          _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v_3 MenhirState100 _tok
      | LID _v_4 ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_5 =
            let id = _v_4 in
            _menhir_action_125 id
          in
          _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v_5 MenhirState100 _tok
      | _ ->
          _eRR 100
  
  and _menhir_run_104 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_flags as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState104
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_107 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState104 _tok
  
  and _menhir_run_105 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState105
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_106 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_106 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_038 x xs in
      _menhir_goto_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_107 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState107 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState108 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 108)
      | COLON ->
          let _v_4 = _menhir_action_059 () in
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState107 _tok
      | _ ->
          _eRR 107
  
  and _menhir_run_010 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_125 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_114 : type  ttv_stack. ((((ttv_stack, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_ as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | COLON ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_COLON (_menhir_stack, _startpos, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | BAR ->
              let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let _endpos__1_ = _endpos_1 in
              let _v = _menhir_action_077 () in
              _menhir_goto_optional_bar _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _v _tok
          | ACTION _ | LID _ | PREC | QID _ | UID _ ->
              let _v = _menhir_action_076 () in
              _menhir_goto_optional_bar _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              _eRR 115)
      | _ ->
          _eRR 114
  
  and _menhir_goto_optional_bar : type  ttv_stack. ((((ttv_stack, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_COLON -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let _menhir_stack = MenhirCell0_optional_bar (_menhir_stack, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState117
      | QID _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState117
      | LID _v_2 ->
          _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState117
      | ACTION _ | BAR | PREC ->
          let _v_3 = _menhir_action_043 () in
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_3 MenhirState117 _tok
      | _ ->
          _eRR 117
  
  and _menhir_run_118 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | EQUAL ->
          let _menhir_stack = MenhirCell1_LID (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState119 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 119)
      | ACTION _ | ATTRIBUTE _ | BAR | COMMA | LID _ | LPAREN | PLUS | PREC | QID _ | QUESTION | RPAREN | SEMI | STAR | UID _ ->
          let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_125 id in
          _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
      | _ ->
          _eRR 118
  
  and _menhir_run_154 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | PREC ->
          let _menhir_stack = MenhirCell1_list_producer_ (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState154 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos) in
          let _menhir_s = MenhirState155 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 155)
      | ACTION _ | BAR ->
          let (_endpos_producers_, _startpos_producers_, producers) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_090 _endpos_producers_ _startpos_producers_ producers in
          _menhir_goto_production _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_producers_ _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_goto_production : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | BAR ->
          let _menhir_stack = MenhirCell1_production (_menhir_stack, _menhir_s, _v, _startpos) in
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_BAR (_menhir_stack, _startpos_0, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v_1 ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState142
          | QID _v_2 ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState142
          | LID _v_3 ->
              _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState142
          | ACTION _ | BAR | PREC ->
              let _v_4 = _menhir_action_043 () in
              _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_4 MenhirState142 _tok
          | _ ->
              _eRR 142)
      | ACTION _ ->
          let (_startpos_x_, x) = (_startpos, _v) in
          let _v = _menhir_action_101 x in
          _menhir_goto_separated_nonempty_list_BAR_production_ _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | _ ->
          _eRR 141
  
  and _menhir_goto_separated_nonempty_list_BAR_production_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState185 ->
          _menhir_run_172 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState117 ->
          _menhir_run_172 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState160 ->
          _menhir_run_128 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_128 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_128 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_172 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_separated_nonempty_list_BAR_production_ (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | ACTION _v_0 ->
          let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_ACTION (_menhir_stack, _v_0, _startpos_1) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | PREC ->
              _menhir_run_174 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState173
          | ATTRIBUTE _v_2 ->
              _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState173
          | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
              let _v_3 = _menhir_action_037 () in
              _menhir_run_183 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_3 _tok)
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_183 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_ACTION (_menhir_stack, action, _) = _menhir_stack in
      let MenhirCell1_separated_nonempty_list_BAR_production_ (_menhir_stack, _menhir_s, productions, _startpos_productions_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_092 action attrs productions in
      _menhir_goto_production_group _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_productions_ _v _menhir_s _tok
  
  and _menhir_goto_production_group : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState185 ->
          _menhir_run_184 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState117 ->
          _menhir_run_184 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState160 ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_138 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_184 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | BAR ->
          let _menhir_stack = MenhirCell1_production_group (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_BAR (_menhir_stack, _startpos_0, _endpos_1) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v_2 ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState185
          | QID _v_3 ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState185
          | LID _v_4 ->
              _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState185
          | ACTION _ | BAR | PREC ->
              let _v_5 = _menhir_action_043 () in
              _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_1 _endpos_1 _v_5 MenhirState185 _tok
          | _ ->
              _eRR 185)
      | EOF | INLINE | LET | LID _ | PERCENTPERCENT _ | PUBLIC | QID _ | SEMI | UID _ ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_103 x in
          _menhir_goto_separated_nonempty_list_BAR_production_group_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v _menhir_s _tok
      | _ ->
          _eRR 184
  
  and _menhir_goto_separated_nonempty_list_BAR_production_group_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState185 ->
          _menhir_run_186 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState117 ->
          _menhir_run_168 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState160 ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_186 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_production_group _menhir_cell0_BAR -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_BAR (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_production_group (_menhir_stack, _menhir_s, x, _startpos_x_, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_104 x xs in
      _menhir_goto_separated_nonempty_list_BAR_production_group_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_168 : type  ttv_stack. (((((ttv_stack, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_COLON _menhir_cell0_optional_bar as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_separated_nonempty_list_BAR_production_group_ (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState168
      | EOF | INLINE | LET | LID _ | PERCENTPERCENT _ | PUBLIC | QID _ | UID _ ->
          let _ = _menhir_action_039 () in
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _tok
      | _ ->
          _eRR 168
  
  and _menhir_run_169 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_SEMI (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          _menhir_run_169 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState169
      | EOF | INLINE | LET | LID _ | PERCENTPERCENT _ | PUBLIC | QID _ | UID _ ->
          let _v = _menhir_action_039 () in
          _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR 169
  
  and _menhir_run_170 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_SEMI -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_SEMI (_menhir_stack, _menhir_s) = _menhir_stack in
      let (x, _endpos_xs_, xs) = ((), _endpos, _v) in
      let _v = _menhir_action_040 x xs in
      _menhir_goto_list_SEMI_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_goto_list_SEMI_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState168 ->
          _menhir_run_171 _menhir_stack _menhir_lexbuf _menhir_lexer _tok
      | MenhirState169 ->
          _menhir_run_170 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState166 ->
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _tok
      | MenhirState150 ->
          _menhir_run_153 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _tok
      | MenhirState151 ->
          _menhir_run_152 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_171 : type  ttv_stack. (((((ttv_stack, _menhir_box_grammar) _menhir_cell1_flags, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_cell0_COLON _menhir_cell0_optional_bar, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_group_ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _tok ->
      let MenhirCell1_separated_nonempty_list_BAR_production_group_ (_menhir_stack, _, prods, _, _) = _menhir_stack in
      let MenhirCell0_optional_bar (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell0_COLON (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ (_menhir_stack, _, params) = _menhir_stack in
      let MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _, attributes, _) = _menhir_stack in
      let MenhirCell1_symbol (_menhir_stack, _, symbol, _, _) = _menhir_stack in
      let MenhirCell1_flags (_menhir_stack, _menhir_s, flags) = _menhir_stack in
      let _v = _menhir_action_069 attributes flags params prods symbol in
      let _menhir_stack = MenhirCell1_old_rule (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | PUBLIC ->
          _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState097
      | INLINE ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState097
      | LET ->
          let _menhir_s = MenhirState097 in
          let _v = _menhir_action_008 () in
          _menhir_goto_boption_PUBLIC_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LID _ | QID _ | UID _ ->
          let _menhir_s = MenhirState097 in
          let _v = _menhir_action_028 () in
          _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | EOF | PERCENTPERCENT _ ->
          let _v_2 = _menhir_action_045 () in
          _menhir_run_300 _menhir_stack _v_2 _tok
      | _ ->
          _eRR 97
  
  and _menhir_run_095 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | PUBLIC ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v = _menhir_action_032 () in
          _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LID _ | QID _ | UID _ ->
          let _v = _menhir_action_030 () in
          _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 95
  
  and _menhir_goto_boption_PUBLIC_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_boption_PUBLIC_ (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell0_LET (_menhir_stack, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LID _v_0 ->
          let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos_2 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_LID (_menhir_stack, _v_0, _startpos_1, _endpos_2) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | ATTRIBUTE _v_3 ->
              _menhir_run_190 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState189
          | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
              let _v_4 = _menhir_action_037 () in
              _menhir_run_192 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_2 _v_4 MenhirState189 _tok)
      | _ ->
          _eRR 188
  
  and _menhir_run_190 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_190 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState190
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_191 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_191 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_038 x xs in
      _menhir_goto_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_192 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState192 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState193 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 193)
      | COLONEQUAL | EQUALEQUAL ->
          let _v_4 = _menhir_action_059 () in
          _menhir_run_196 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState192 _tok
      | _ ->
          _eRR 192
  
  and _menhir_run_196 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_ as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | EQUALEQUAL ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v = _menhir_action_026 () in
          _menhir_goto_equality_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | COLONEQUAL ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v = _menhir_action_025 () in
          _menhir_goto_equality_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _eRR 196
  
  and _menhir_goto_equality_symbol : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_boption_PUBLIC_ _menhir_cell0_LET _menhir_cell0_LID, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let _menhir_stack = MenhirCell0_equality_symbol (_menhir_stack, _v) in
      match (_tok : MenhirBasics.token) with
      | UNDERSCORE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState199
      | UID _v_0 ->
          _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState199
      | TILDE ->
          _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState199
      | QID _v_1 ->
          _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState199
      | PREC ->
          _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState199
      | OCAMLTYPE _v_2 ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState199
      | LPAREN ->
          _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState199
      | LID _v_3 ->
          _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState199
      | BAR ->
          let _menhir_s = MenhirState199 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_BAR (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState222 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 222)
      | ACTION _v_9 ->
          _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _v_9 MenhirState199
      | _ ->
          _eRR 199
  
  and _menhir_run_167 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _tok ->
      let MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _, attrs, _) = _menhir_stack in
      let MenhirCell1_actual (_menhir_stack, _, p, _) = _menhir_stack in
      let MenhirCell1_LID (_menhir_stack, _menhir_s, x, _startpos_x_, _) = _menhir_stack in
      let _endpos__4_ = _endpos in
      let _v = _menhir_action_089 _endpos__4_ _startpos_x_ attrs p x in
      _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_144 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_producer (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState144
      | QID _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState144
      | LID _v_2 ->
          _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState144
      | ACTION _ | BAR | PREC ->
          let _v_3 = _menhir_action_043 () in
          _menhir_run_145 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_3 _tok
      | _ ->
          _eRR 144
  
  and _menhir_run_145 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_producer -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_producer (_menhir_stack, _menhir_s, x, _startpos_x_, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_044 x xs in
      _menhir_goto_list_producer_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_goto_list_producer_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState117 ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState185 ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState160 ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState144 ->
          _menhir_run_145 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_153 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_actual, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _tok ->
      let MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _, attrs, _) = _menhir_stack in
      let MenhirCell1_actual (_menhir_stack, _menhir_s, p, _startpos_p_) = _menhir_stack in
      _menhir_act_goto_088 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s _tok attrs _startpos_p_ p _endpos
  
  and _menhir_act_goto_088 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s _tok attrs _startpos_p_ p _endpos__4_ ->
      match _menhir_s with
      | MenhirState117 ->
          let MenhirCell0_optional_bar (_, _, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | MenhirState185 ->
          let MenhirCell0_BAR (_, _, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | MenhirState160 ->
          let MenhirCell0_COMMA (_, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | MenhirState122 ->
          let MenhirCell1_LPAREN (_, _, _, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | MenhirState139 ->
          let MenhirCell0_BAR (_, _, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | MenhirState144 ->
          let MenhirCell1_producer (_, _, _, _, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | MenhirState142 ->
          let MenhirCell0_BAR (_, _, _endpos__0_) = _menhir_stack in
          let _v = _menhir_action_088 _endpos__0_ _endpos__4_ attrs p in
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__4_ _startpos_p_ _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_152 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_SEMI -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_SEMI (_menhir_stack, _menhir_s) = _menhir_stack in
      let (x, _endpos_xs_, xs) = ((), _endpos, _v) in
      let _v = _menhir_action_040 x xs in
      _menhir_goto_list_SEMI_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_140 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_production_group _menhir_cell0_BAR -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_BAR (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_production_group (_menhir_stack, _menhir_s, x, _startpos_x_, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_104 x xs in
      _menhir_goto_separated_nonempty_list_BAR_production_group_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_127 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_prods_, _startpos_prods_, prods) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_048 _endpos_prods_ _startpos_prods_ prods in
      let branches = _v in
      let _v = _menhir_action_036 branches in
      _menhir_goto_lax_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_lax_actual : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_lax_actual (_menhir_stack, _menhir_s, _v) in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_COMMA (_menhir_stack, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v_0 ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState160
          | QID _v_1 ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState160
          | LID _v_2 ->
              _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState160
          | ACTION _ | BAR | PREC ->
              let _v_3 = _menhir_action_043 () in
              _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v_3 MenhirState160 _tok
          | _ ->
              _eRR 160)
      | RPAREN ->
          let x = _v in
          let _v = _menhir_action_107 x in
          _menhir_goto_separated_nonempty_list_COMMA_lax_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR 159
  
  and _menhir_goto_separated_nonempty_list_COMMA_lax_actual_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState160 ->
          _menhir_run_161 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState122 ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_161 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_lax_actual _menhir_cell0_COMMA -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell0_COMMA (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_lax_actual (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_108 x xs in
      _menhir_goto_separated_nonempty_list_COMMA_lax_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_125 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let x = _v in
      let _v = _menhir_action_056 x in
      _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_lax_actual__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_lax_actual__RPAREN__ : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState121 ->
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState123 ->
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_164 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _startpos_symbol_, _) = _menhir_stack in
      let params = _v in
      let _v = _menhir_action_006 params symbol in
      _menhir_goto_actual _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_symbol_ _v _menhir_s _tok
  
  and _menhir_goto_actual : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState119 ->
          _menhir_run_165 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState160 ->
          _menhir_run_162 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState117 ->
          _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState185 ->
          _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState144 ->
          _menhir_run_146 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_165 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_LID as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_actual (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState165
      | QUESTION ->
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState165
      | PLUS ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState165
      | ATTRIBUTE _v_0 ->
          _menhir_run_147 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState165
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PREC | PUBLIC | QID _ | RIGHT | RPAREN | SEMI | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_166 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState165 _tok
  
  and _menhir_run_014 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_065 () in
      _menhir_goto_modifier _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_modifier : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState257 ->
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState027 ->
          _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState248 ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState165 ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState162 ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState146 ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState066 ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState013 ->
          _menhir_run_019 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_261 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_050 _endpos_x_ _startpos_x_ x in
      _menhir_goto_located_modifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_located_modifier_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState257 ->
          _menhir_run_262 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState248 ->
          _menhir_run_249 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState162 ->
          _menhir_run_163 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState165 ->
          _menhir_run_149 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState146 ->
          _menhir_run_149 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState066 ->
          _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState027 ->
          _menhir_run_035 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState013 ->
          _menhir_run_020 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_262 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_ as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_located_modifier_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState262
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_263 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_263 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_, _menhir_box_grammar) _menhir_cell1_located_modifier_ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_located_modifier_ (_menhir_stack, _, m) = _menhir_stack in
      let MenhirCell1_located_symbol_expression_ (_menhir_stack, _menhir_s, e, _startpos_e_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_129 attrs e m in
      _menhir_goto_symbol_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_e_ _v _menhir_s _tok
  
  and _menhir_goto_symbol_expression : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState283 ->
          _menhir_run_284 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState245 ->
          _menhir_run_246 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_232 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState199 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_224 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_284 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_pattern as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          let _menhir_stack = MenhirCell1_symbol_expression (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState285 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 285)
      | PLUS | QUESTION | STAR ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_052 _endpos_x_ _startpos_x_ x in
          _menhir_goto_located_symbol_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | _ ->
          _eRR 284
  
  and _menhir_goto_located_symbol_expression_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState199 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState295 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState222 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState225 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState283 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState285 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState245 ->
          _menhir_run_257 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState227 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState230 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState233 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState268 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState235 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState239 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState247 ->
          _menhir_run_248 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_257 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_located_symbol_expression_ (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_1 = _menhir_action_065 () in
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_0 _v_1 MenhirState257 _tok
      | QUESTION ->
          let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_3 = _menhir_action_063 () in
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_2 _v_3 MenhirState257 _tok
      | PLUS ->
          let _startpos_4 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_5 = _menhir_action_064 () in
          _menhir_run_261 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_4 _v_5 MenhirState257 _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_248 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_located_symbol_expression_ (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState248
      | QUESTION ->
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState248
      | PLUS ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState248
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_015 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_063 () in
      _menhir_goto_modifier _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_016 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_064 () in
      _menhir_goto_modifier _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_246 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_pattern as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          let _menhir_stack = MenhirCell1_symbol_expression (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState247 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 247)
      | PLUS | QUESTION | STAR ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_052 _endpos_x_ _startpos_x_ x in
          _menhir_goto_located_symbol_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | _ ->
          _eRR 246
  
  and _menhir_run_228 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_action_, _startpos_action_, action) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_002 _endpos_action_ _startpos_action_ action in
      _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_action_ _v _menhir_s _tok
  
  and _menhir_run_229 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | EQUAL ->
          let (_startpos_x_, x) = (_startpos, _v) in
          let _v = _menhir_action_078 x in
          _menhir_goto_pattern _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | ATTRIBUTE _ | BAR | COMMA | LPAREN | PLUS | QUESTION | RPAREN | SEMI | STAR ->
          let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_125 id in
          _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
      | _ ->
          _eRR 229
  
  and _menhir_run_231 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_startpos_action_, action) = (_startpos, _v) in
      let _v = _menhir_action_001 action in
      _menhir_goto_action _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_action_ _v _menhir_s _tok
  
  and _menhir_run_232 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          let _menhir_stack = MenhirCell1_symbol_expression (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState233 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 233)
      | PLUS | QUESTION | STAR ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_052 _endpos_x_ _startpos_x_ x in
          _menhir_goto_located_symbol_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | BAR | COMMA | RPAREN ->
          let (_endpos_e_, _startpos_e_, e) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_096 e in
          _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e_ _v _menhir_s _tok
      | _ ->
          _eRR 232
  
  and _menhir_run_224 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          let _menhir_stack = MenhirCell1_symbol_expression (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _menhir_s = MenhirState225 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_175 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_176 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_221 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 225)
      | PLUS | QUESTION | STAR ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_052 _endpos_x_ _startpos_x_ x in
          _menhir_goto_located_symbol_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
      | BAR | EOF | INLINE | LET | LID _ | PERCENTPERCENT _ | PUBLIC | QID _ | UID _ ->
          let (_endpos_e_, _startpos_e_, e) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_096 e in
          _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e_ _v _menhir_s _tok
      | _ ->
          _eRR 224
  
  and _menhir_run_249 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_ as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_located_modifier_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState249
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_250 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_250 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_located_symbol_expression_, _menhir_box_grammar) _menhir_cell1_located_modifier_ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_located_modifier_ (_menhir_stack, _, m) = _menhir_stack in
      let MenhirCell1_located_symbol_expression_ (_menhir_stack, _menhir_s, e, _startpos_e_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_129 attrs e m in
      _menhir_goto_symbol_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_e_ _v _menhir_s _tok
  
  and _menhir_run_163 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_actual -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      match (_tok : MenhirBasics.token) with
      | ACTION _ | ATTRIBUTE _ | BAR | LID _ | PLUS | PREC | QID _ | QUESTION | SEMI | STAR | UID _ ->
          let MenhirCell1_actual (_menhir_stack, _menhir_s, p, _startpos_p_) = _menhir_stack in
          let m = _v in
          let _v = _menhir_action_007 m p in
          _menhir_goto_actual _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_p_ _v _menhir_s _tok
      | COMMA | RPAREN ->
          let MenhirCell1_actual (_menhir_stack, _menhir_s, p, _) = _menhir_stack in
          let m = _v in
          let _v = _menhir_action_035 m p in
          _menhir_goto_lax_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 163
  
  and _menhir_run_149 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_actual -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_actual (_menhir_stack, _menhir_s, p, _startpos_p_) = _menhir_stack in
      let m = _v in
      let _v = _menhir_action_007 m p in
      _menhir_goto_actual _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_p_ _v _menhir_s _tok
  
  and _menhir_run_069 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_strict_actual (_menhir_stack, _menhir_s, p) = _menhir_stack in
      let m = _v in
      let _v = _menhir_action_124 m p in
      _menhir_goto_strict_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_strict_actual : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState067 ->
          _menhir_run_066 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState059 ->
          _menhir_run_066 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState076 ->
          _menhir_run_027 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState032 ->
          _menhir_run_027 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState002 ->
          _menhir_run_027 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState062 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState007 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState017 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState012 ->
          _menhir_run_013 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_066 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STAR ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState066
      | QUESTION ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState066
      | PLUS ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState066
      | COMMA ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_031 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState066
      | LID _ | QID _ | UID _ ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          let _v_0 = _menhir_action_070 () in
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState066 _tok
      | ATTRIBUTE _ ->
          let x = _v in
          let _v = _menhir_action_117 x in
          _menhir_goto_separated_nonempty_list_option_COMMA__strict_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 66
  
  and _menhir_run_031 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let x = () in
      let _v = _menhir_action_071 x in
      _menhir_goto_option_COMMA_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_option_COMMA_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState087 ->
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState066 ->
          _menhir_run_067 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState052 ->
          _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState045 ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState027 ->
          _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_088 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_COMMA_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState088
      | QID _v_1 ->
          _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState088
      | LID _v_2 ->
          _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState088
      | _ ->
          _eRR 88
  
  and _menhir_run_004 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_127 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_005 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_125 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_067 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_COMMA_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState067
      | QID _v_1 ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState067
      | LID _v_2 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState067
      | _ ->
          _eRR 67
  
  and _menhir_run_060 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_id_, _startpos_id_, id) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_125 id in
      _menhir_goto_symbol _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_id_ _startpos_id_ _v _menhir_s _tok
  
  and _menhir_run_053 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_LID as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_COMMA_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LID _v_0 ->
          _menhir_run_052 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState053
      | _ ->
          _eRR 53
  
  and _menhir_run_052 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_LID (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          _menhir_run_031 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState052
      | LID _ ->
          let _menhir_stack = MenhirCell1_LID (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _v_0 = _menhir_action_070 () in
          _menhir_run_053 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState052 _tok
      | COLON | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PUBLIC | RIGHT | SEMI | START | TOKEN | TYPE ->
          let id = _v in
          let _v = _menhir_action_115 id in
          _menhir_goto_separated_nonempty_list_option_COMMA__nonterminal_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 52
  
  and _menhir_goto_separated_nonempty_list_option_COMMA__nonterminal_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState051 ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState053 ->
          _menhir_run_054 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_055 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_START, _menhir_box_grammar) _menhir_cell1_option_OCAMLTYPE_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_OCAMLTYPE_ (_menhir_stack, _, t) = _menhir_stack in
      let MenhirCell1_START (_menhir_stack, _menhir_s) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_012 t xs in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_declaration : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_declaration (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | TYPE ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | TOKEN ->
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | START ->
          _menhir_run_049 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | SEMI ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | RIGHT ->
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | PUBLIC ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | PERCENTATTRIBUTE ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | PARAMETER ->
          _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | ON_ERROR_REDUCE ->
          _menhir_run_076 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | NONASSOC ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | LET ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | LEFT ->
          _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | INLINE ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | HEADER _v_0 ->
          _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState306
      | GRAMMARATTRIBUTE _v_1 ->
          _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState306
      | EOF ->
          _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | COLON ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState306
      | PERCENTPERCENT _ ->
          let _v_2 = _menhir_action_041 () in
          _menhir_run_307 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 _tok
      | _ ->
          _eRR 306
  
  and _menhir_run_037 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_TOKEN (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OCAMLTYPE _v ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let x = _v in
            _menhir_action_073 x
          in
          _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState037 _tok
      | UID _ ->
          let _v = _menhir_action_072 () in
          _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState037 _tok
      | _ ->
          _eRR 37
  
  and _menhir_run_039 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_TOKEN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_OCAMLTYPE_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState039
      | _ ->
          _eRR 39
  
  and _menhir_run_040 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_UID (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | QID _v_0 ->
          let _endpos_2 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos, x) = (_endpos_2, _v_0) in
          let _v = _menhir_action_075 x in
          _menhir_goto_option_QID_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | ATTRIBUTE _ | COLON | COMMA | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PUBLIC | RIGHT | SEMI | START | TOKEN | TYPE | UID _ ->
          let _v = _menhir_action_074 () in
          _menhir_goto_option_QID_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR 40
  
  and _menhir_goto_option_QID_ : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_UID -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let _menhir_stack = MenhirCell0_option_QID_ (_menhir_stack, _v) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState042
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_045 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState042 _tok
  
  and _menhir_run_043 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState043
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_044 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_044 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_038 x xs in
      _menhir_goto_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_045 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_UID _menhir_cell0_option_QID_ as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _menhir_s, _v, _endpos) in
          _menhir_run_031 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState045
      | UID _ ->
          let _menhir_stack = MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _menhir_s, _v, _endpos) in
          let _v_0 = _menhir_action_070 () in
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState045 _tok
      | COLON | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PUBLIC | RIGHT | SEMI | START | TOKEN | TYPE ->
          let MenhirCell0_option_QID_ (_menhir_stack, alias) = _menhir_stack in
          let MenhirCell1_UID (_menhir_stack, _menhir_s, id, _, _) = _menhir_stack in
          let attrs = _v in
          let _v = _menhir_action_121 alias attrs id in
          _menhir_goto_separated_nonempty_list_option_COMMA__terminal_alias_attrs_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 45
  
  and _menhir_run_046 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_UID _menhir_cell0_option_QID_, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_ as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_COMMA_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState046
      | _ ->
          _eRR 46
  
  and _menhir_goto_separated_nonempty_list_option_COMMA__terminal_alias_attrs_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState039 ->
          _menhir_run_048 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState046 ->
          _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_048 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_TOKEN, _menhir_box_grammar) _menhir_cell1_option_OCAMLTYPE_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_OCAMLTYPE_ (_menhir_stack, _, ty) = _menhir_stack in
      let MenhirCell1_TOKEN (_menhir_stack, _menhir_s) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_011 ty xs in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_047 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_UID _menhir_cell0_option_QID_, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_option_COMMA_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_COMMA_ (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _, attrs, _) = _menhir_stack in
      let MenhirCell0_option_QID_ (_menhir_stack, alias) = _menhir_stack in
      let MenhirCell1_UID (_menhir_stack, _menhir_s, id, _, _) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_122 alias attrs id xs in
      _menhir_goto_separated_nonempty_list_option_COMMA__terminal_alias_attrs_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_049 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_START (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OCAMLTYPE _v ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v =
            let x = _v in
            _menhir_action_073 x
          in
          _menhir_run_051 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState049 _tok
      | LID _ ->
          let _v = _menhir_action_072 () in
          _menhir_run_051 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState049 _tok
      | _ ->
          _eRR 49
  
  and _menhir_run_051 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_START as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_OCAMLTYPE_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LID _v_0 ->
          _menhir_run_052 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState051
      | _ ->
          _eRR 51
  
  and _menhir_run_056 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let _v = _menhir_action_019 () in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_057 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_086 () in
      _menhir_goto_priority_keyword _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_priority_keyword : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_priority_keyword (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState086
      | QID _v_1 ->
          _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState086
      | LID _v_2 ->
          _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState086
      | _ ->
          _eRR 86
  
  and _menhir_run_058 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_020 _endpos__1_ _startpos__1_ in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_059 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_PERCENTATTRIBUTE (_menhir_stack, _menhir_s, _startpos) in
      let _menhir_s = MenhirState059 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UID _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | QID _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LID _v ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR 59
  
  and _menhir_run_074 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | OCAMLTYPE _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos__1_, _endpos_t_, t) = (_startpos, _endpos, _v) in
          let _v = _menhir_action_015 _endpos_t_ _startpos__1_ t in
          _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 74
  
  and _menhir_run_076 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_ON_ERROR_REDUCE (_menhir_stack, _menhir_s) in
      let _menhir_s = MenhirState076 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UID _v ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | QID _v ->
          _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LID _v ->
          _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR 76
  
  and _menhir_run_078 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_087 () in
      _menhir_goto_priority_keyword _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_079 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_023 _endpos__1_ _startpos__1_ in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_080 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_085 () in
      _menhir_goto_priority_keyword _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_081 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_021 _endpos__1_ _startpos__1_ in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_082 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_h_, _startpos_h_, h) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_010 _endpos_h_ _startpos_h_ h in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_083 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos_attr_, _startpos_attr_, attr) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_016 _endpos_attr_ _startpos_attr_ attr in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_084 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_024 _endpos__1_ _startpos__1_ in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_085 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let (_endpos__1_, _startpos__1_) = (_endpos, _startpos) in
      let _v = _menhir_action_022 _endpos__1_ _startpos__1_ in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_307 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_declaration -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_declaration (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_042 x xs in
      _menhir_goto_list_declaration_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_list_declaration_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState306 ->
          _menhir_run_307 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState000 ->
          _menhir_run_091 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_091 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_list_declaration_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | PERCENTPERCENT _v_0 ->
          let _menhir_stack = MenhirCell0_PERCENTPERCENT (_menhir_stack, _v_0) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | PUBLIC ->
              _menhir_run_093 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState092
          | INLINE ->
              _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState092
          | LET ->
              let _menhir_s = MenhirState092 in
              let _v = _menhir_action_008 () in
              _menhir_goto_boption_PUBLIC_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _ | QID _ | UID _ ->
              let _menhir_s = MenhirState092 in
              let _v = _menhir_action_028 () in
              _menhir_goto_flags _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
          | EOF | PERCENTPERCENT _ ->
              let _v_3 = _menhir_action_045 () in
              _menhir_run_301 _menhir_stack _v_3 MenhirState092 _tok
          | _ ->
              _eRR 92)
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_054 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_cell1_option_COMMA_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_COMMA_ (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_LID (_menhir_stack, _menhir_s, id, _, _) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_116 id xs in
      _menhir_goto_separated_nonempty_list_option_COMMA__nonterminal_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_032 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_option_COMMA_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | UID _v_0 ->
          _menhir_run_003 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState032
      | QID _v_1 ->
          _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState032
      | LID _v_2 ->
          _menhir_run_005 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState032
      | _ ->
          _eRR 32
  
  and _menhir_goto_separated_nonempty_list_option_COMMA__strict_actual_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState076 ->
          _menhir_run_077 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState059 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState067 ->
          _menhir_run_068 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState002 ->
          _menhir_run_036 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState032 ->
          _menhir_run_033 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_077 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ON_ERROR_REDUCE -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_ON_ERROR_REDUCE (_menhir_stack, _menhir_s) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_018 xs in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_070 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_PERCENTATTRIBUTE as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_separated_nonempty_list_option_COMMA__strict_actual_ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState070
      | _ ->
          _eRR 70
  
  and _menhir_run_071 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
          _menhir_run_071 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState071
      | COLON | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PUBLIC | RIGHT | SEMI | START | TOKEN | TYPE ->
          let (_endpos_x_, x) = (_endpos, _v) in
          let _v = _menhir_action_067 x in
          _menhir_goto_nonempty_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _v _menhir_s _tok
      | _ ->
          _eRR 71
  
  and _menhir_goto_nonempty_list_ATTRIBUTE_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState070 ->
          _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState071 ->
          _menhir_run_072 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_073 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_PERCENTATTRIBUTE, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_option_COMMA__strict_actual_ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_separated_nonempty_list_option_COMMA__strict_actual_ (_menhir_stack, _, xs) = _menhir_stack in
      let MenhirCell1_PERCENTATTRIBUTE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_017 _endpos_attrs_ _startpos__1_ attrs xs in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_072 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_068 x xs in
      _menhir_goto_nonempty_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_068 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_cell1_option_COMMA_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_COMMA_ (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_strict_actual (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_118 x xs in
      _menhir_goto_separated_nonempty_list_option_COMMA__strict_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_036 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_TYPE _menhir_cell0_OCAMLTYPE -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_OCAMLTYPE (_menhir_stack, t, _, _) = _menhir_stack in
      let MenhirCell1_TYPE (_menhir_stack, _menhir_s) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_013 t xs in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_033 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_cell1_option_COMMA_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_COMMA_ (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_strict_actual (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_118 x xs in
      _menhir_goto_separated_nonempty_list_option_COMMA__strict_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_027 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STAR ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_0 = _menhir_action_065 () in
          _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v_0 MenhirState027 _tok
      | QUESTION ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_1 = _menhir_action_063 () in
          _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v_1 MenhirState027 _tok
      | PLUS ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _v_2 = _menhir_action_064 () in
          _menhir_run_034 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v_2 MenhirState027 _tok
      | COMMA ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_031 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState027
      | LID _ | QID _ | UID _ ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          let _v_3 = _menhir_action_070 () in
          _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState027 _tok
      | COLON | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PUBLIC | RIGHT | SEMI | START | TOKEN | TYPE ->
          let x = _v in
          let _v = _menhir_action_117 x in
          _menhir_goto_separated_nonempty_list_option_COMMA__strict_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 27
  
  and _menhir_run_034 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_050 _endpos_x_ _startpos_x_ x in
      _menhir_goto_located_modifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_run_013 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STAR ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState013
      | QUESTION ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState013
      | PLUS ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState013
      | COMMA ->
          let _menhir_stack = MenhirCell1_strict_actual (_menhir_stack, _menhir_s, _v) in
          let _menhir_s = MenhirState013 in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_COMMA (_menhir_stack, _menhir_s, _endpos) in
          let _menhir_s = MenhirState017 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 17)
      | RPAREN ->
          let x = _v in
          let _v = _menhir_action_111 x in
          _menhir_goto_separated_nonempty_list_COMMA_strict_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR 13
  
  and _menhir_goto_separated_nonempty_list_COMMA_strict_actual_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState062 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState007 ->
          _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState012 ->
          _menhir_run_021 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState017 ->
          _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_063 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let x = _v in
      let _v = _menhir_action_058 x in
      _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_strict_actual__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_strict_actual__RPAREN__ : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState061 ->
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState006 ->
          _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState011 ->
          _menhir_run_023 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_065 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _, _) = _menhir_stack in
      let params = _v in
      let _v = _menhir_action_123 params symbol in
      _menhir_goto_strict_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_026 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _, _) = _menhir_stack in
      let params = _v in
      let _v = _menhir_action_123 params symbol in
      _menhir_goto_strict_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_023 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _, _) = _menhir_stack in
      let params = _v in
      let _v = _menhir_action_123 params symbol in
      _menhir_goto_strict_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_024 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let x = _v in
      let _v = _menhir_action_058 x in
      _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_strict_actual__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_021 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let x = _v in
      let _v = _menhir_action_058 x in
      _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_strict_actual__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_018 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual, _menhir_box_grammar) _menhir_cell1_COMMA -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_COMMA (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_strict_actual (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_112 x xs in
      _menhir_goto_separated_nonempty_list_COMMA_strict_actual_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_035 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_strict_actual (_menhir_stack, _menhir_s, p) = _menhir_stack in
      let m = _v in
      let _v = _menhir_action_124 m p in
      _menhir_goto_strict_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_020 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_strict_actual -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_strict_actual (_menhir_stack, _menhir_s, p) = _menhir_stack in
      let m = _v in
      let _v = _menhir_action_124 m p in
      _menhir_goto_strict_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_019 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_050 _endpos_x_ _startpos_x_ x in
      _menhir_goto_located_modifier_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_run_147 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, _v, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_147 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState147
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_148 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_148 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_ATTRIBUTE -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_ATTRIBUTE (_menhir_stack, _menhir_s, x, _) = _menhir_stack in
      let (_endpos_xs_, xs) = (_endpos, _v) in
      let _v = _menhir_action_038 x xs in
      _menhir_goto_list_ATTRIBUTE_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_166 : type  ttv_stack. (((ttv_stack, _menhir_box_grammar) _menhir_cell1_LID, _menhir_box_grammar) _menhir_cell1_actual as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState166
      | ACTION _ | BAR | LID _ | PREC | QID _ | UID _ ->
          let _ = _menhir_action_039 () in
          _menhir_run_167 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _tok
      | _ ->
          _eRR 166
  
  and _menhir_run_151 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_SEMI (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState151
      | ACTION _ | BAR | LID _ | PREC | QID _ | UID _ ->
          let _v = _menhir_action_039 () in
          _menhir_run_152 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR 151
  
  and _menhir_run_162 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_actual (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState162
      | QUESTION ->
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState162
      | PLUS ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState162
      | ATTRIBUTE _v_0 ->
          _menhir_run_147 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState162
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PREC | PUBLIC | QID _ | RIGHT | RPAREN | SEMI | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState162 _tok
  
  and _menhir_run_150 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_actual as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_list_ATTRIBUTE_ (_menhir_stack, _menhir_s, _v, _endpos) in
      match (_tok : MenhirBasics.token) with
      | SEMI ->
          _menhir_run_151 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState150
      | ACTION _ | BAR | LID _ | PREC | QID _ | UID _ ->
          let _ = _menhir_action_039 () in
          _menhir_run_153 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _tok
      | _ ->
          _eRR 150
  
  and _menhir_run_146 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_actual (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
      | QUESTION ->
          _menhir_run_015 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
      | PLUS ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
      | ATTRIBUTE _v_0 ->
          _menhir_run_147 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState146
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PREC | PUBLIC | QID _ | RIGHT | RPAREN | SEMI | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_150 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 MenhirState146 _tok
  
  and _menhir_run_124 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      match (_tok : MenhirBasics.token) with
      | ACTION _ | ATTRIBUTE _ | BAR | LID _ | PLUS | PREC | QID _ | QUESTION | SEMI | STAR | UID _ ->
          let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _startpos_symbol_, _) = _menhir_stack in
          let params = _v in
          let _v = _menhir_action_006 params symbol in
          _menhir_goto_actual _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_symbol_ _v _menhir_s _tok
      | COMMA | RPAREN ->
          let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _, _) = _menhir_stack in
          let params = _v in
          let _v = _menhir_action_034 params symbol in
          _menhir_goto_lax_actual _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 124
  
  and _menhir_run_138 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | BAR ->
          let _menhir_stack = MenhirCell1_production_group (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_BAR (_menhir_stack, _startpos_0, _endpos_1) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v_2 ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState139
          | QID _v_3 ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v_3 MenhirState139
          | LID _v_4 ->
              _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v_4 MenhirState139
          | ACTION _ | BAR | PREC ->
              let _v_5 = _menhir_action_043 () in
              _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_1 _endpos_1 _v_5 MenhirState139 _tok
          | _ ->
              _eRR 139)
      | COMMA | RPAREN ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_103 x in
          _menhir_goto_separated_nonempty_list_BAR_production_group_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v _menhir_s _tok
      | _ ->
          _eRR 138
  
  and _menhir_run_143 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_production _menhir_cell0_BAR -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_BAR (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_production (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_102 x xs in
      _menhir_goto_separated_nonempty_list_BAR_production_ _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_128 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_separated_nonempty_list_BAR_production_ (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | ACTION _v_0 ->
          let _startpos_1 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_ACTION (_menhir_stack, _v_0, _startpos_1) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | PREC ->
              _menhir_run_130 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState129
          | ATTRIBUTE _v_2 ->
              _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_2 MenhirState129
          | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
              let _v_3 = _menhir_action_037 () in
              _menhir_run_137 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_3 _tok)
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_137 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_ACTION (_menhir_stack, action, _) = _menhir_stack in
      let MenhirCell1_separated_nonempty_list_BAR_production_ (_menhir_stack, _menhir_s, productions, _startpos_productions_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_092 action attrs productions in
      _menhir_goto_production_group _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_productions_ _v _menhir_s _tok
  
  and _menhir_run_267 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_expression (_menhir_stack, _menhir_s, _v) in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_COMMA (_menhir_stack, _endpos) in
          let _menhir_s = MenhirState268 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | BAR ->
              _menhir_run_230 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ACTION _v ->
              _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 268)
      | RPAREN ->
          let x = _v in
          let _v = _menhir_action_105 x in
          _menhir_goto_separated_nonempty_list_COMMA_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR 267
  
  and _menhir_run_230 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_BAR (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _menhir_s = MenhirState230 in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UNDERSCORE ->
          _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | UID _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | TILDE ->
          _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | QID _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | PREC ->
          _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | OCAMLTYPE _v ->
          _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LPAREN ->
          _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
      | LID _v ->
          _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | ACTION _v ->
          _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _eRR 230
  
  and _menhir_goto_separated_nonempty_list_COMMA_expression_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState227 ->
          _menhir_run_274 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState268 ->
          _menhir_run_269 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState235 ->
          _menhir_run_236 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_274 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let x = _v in
      let _v = _menhir_action_054 x in
      _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState226 ->
          _menhir_run_276 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | MenhirState234 ->
          _menhir_run_270 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_276 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState276
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_277 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_277 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ (_menhir_stack, _, params) = _menhir_stack in
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _startpos_symbol_, _) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_128 attrs params symbol in
      _menhir_goto_symbol_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_symbol_ _v _menhir_s _tok
  
  and _menhir_run_270 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState270
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_271 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_271 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ (_menhir_stack, _, params) = _menhir_stack in
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, symbol, _startpos_symbol_, _) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_128 attrs params symbol in
      _menhir_goto_symbol_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_symbol_ _v _menhir_s _tok
  
  and _menhir_run_269 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_expression _menhir_cell0_COMMA -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell0_COMMA (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_expression (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_106 x xs in
      _menhir_goto_separated_nonempty_list_COMMA_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_236 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let x = _v in
      let _v = _menhir_action_054 x in
      _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_expression__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _menhir_s _tok
  
  and _menhir_run_266 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let e = _v in
      let _v = _menhir_action_027 e in
      _menhir_goto_expression _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_238 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | BAR ->
          let _menhir_stack = MenhirCell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_BAR (_menhir_stack, _startpos, _endpos) in
          let _menhir_s = MenhirState239 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | ACTION _v ->
              _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 239)
      | COMMA | RPAREN ->
          let (_endpos_xs_, _startpos_xs_, xs) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_049 _endpos_xs_ _startpos_xs_ xs in
          _menhir_goto_located_choice_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 238
  
  and _menhir_run_296 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_cell0_BAR -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_BAR (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ (_menhir_stack, _menhir_s, xs, _startpos_xs_, _) = _menhir_stack in
      let (_endpos_e_, e) = (_endpos, _v) in
      let _v = _menhir_action_100 e xs in
      _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_293 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_BAR -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_BAR (_menhir_stack, _menhir_s, _startpos_x_inlined1_, _) = _menhir_stack in
      let (_endpos_e_, e, x_inlined1) = (_endpos, _v, ()) in
      let _v = _menhir_action_099 e x_inlined1 in
      _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_x_inlined1_ _v _menhir_s _tok
  
  and _menhir_run_292 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol_expression -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_symbol_expression (_menhir_stack, _menhir_s, e1, _startpos_e1_, _) = _menhir_stack in
      let (_endpos_e_, e) = (_endpos, _v) in
      let _v = _menhir_action_094 e e1 in
      _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e1_ _v _menhir_s _tok
  
  and _menhir_run_286 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_pattern, _menhir_box_grammar) _menhir_cell1_symbol_expression -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_symbol_expression (_menhir_stack, _, e1, _, _) = _menhir_stack in
      let MenhirCell1_pattern (_menhir_stack, _menhir_s, p1, _startpos_p1_) = _menhir_stack in
      let (_endpos_e_, e) = (_endpos, _v) in
      let _v = _menhir_action_095 e e1 p1 in
      _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_p1_ _v _menhir_s _tok
  
  and _menhir_run_273 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_BAR -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_BAR (_menhir_stack, _menhir_s, _startpos_x_inlined1_, _) = _menhir_stack in
      let (_endpos_e_, e, x_inlined1) = (_endpos, _v, ()) in
      let _v = _menhir_action_099 e x_inlined1 in
      _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_x_inlined1_ _v _menhir_s _tok
  
  and _menhir_run_272 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol_expression -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_symbol_expression (_menhir_stack, _menhir_s, e1, _startpos_e1_, _) = _menhir_stack in
      let (_endpos_e_, e) = (_endpos, _v) in
      let _v = _menhir_action_094 e e1 in
      _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e1_ _v _menhir_s _tok
  
  and _menhir_run_265 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_e_, _startpos_e_, e) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_098 e in
      _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e_ _v _menhir_s _tok
  
  and _menhir_run_264 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_cell0_BAR -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell0_BAR (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ (_menhir_stack, _menhir_s, xs, _startpos_xs_, _) = _menhir_stack in
      let (_endpos_e_, e) = (_endpos, _v) in
      let _v = _menhir_action_100 e xs in
      _menhir_goto_reversed_preceded_or_separated_nonempty_llist_BAR_branch_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_xs_ _v _menhir_s _tok
  
  and _menhir_run_251 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_pattern, _menhir_box_grammar) _menhir_cell1_symbol_expression -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_symbol_expression (_menhir_stack, _, e1, _, _) = _menhir_stack in
      let MenhirCell1_pattern (_menhir_stack, _menhir_s, p1, _startpos_p1_) = _menhir_stack in
      let (_endpos_e_, e) = (_endpos, _v) in
      let _v = _menhir_action_095 e e1 p1 in
      _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_p1_ _v _menhir_s _tok
  
  and _menhir_run_240 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_051 _endpos_x_ _startpos_x_ x in
      _menhir_goto_located_raw_seq_expression_ _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_252 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let (_endpos_e_, _startpos_e_, e) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_097 e in
      _menhir_goto_raw_seq_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_e_ _startpos_e_ _v _menhir_s _tok
  
  and _menhir_run_290 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_cell1_precedence -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_precedence (_menhir_stack, _, prec, _, _) = _menhir_stack in
      let MenhirCell1_action (_menhir_stack, _menhir_s, action, _startpos_action_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_005 action attrs prec in
      _menhir_goto_action_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_action_ _v _menhir_s _tok
  
  and _menhir_run_255 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_action, _menhir_box_grammar) _menhir_cell1_precedence -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_precedence (_menhir_stack, _, prec, _, _) = _menhir_stack in
      let MenhirCell1_action (_menhir_stack, _menhir_s, action, _startpos_action_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_005 action attrs prec in
      _menhir_goto_action_expression _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_action_ _v _menhir_s _tok
  
  and _menhir_run_182 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION, _menhir_box_grammar) _menhir_cell1_precedence -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_precedence (_menhir_stack, _, x, _, _) = _menhir_stack in
      let MenhirCell0_ACTION (_menhir_stack, action, _) = _menhir_stack in
      let MenhirCell1_separated_nonempty_list_BAR_production_ (_menhir_stack, _menhir_s, productions, _startpos_productions_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_093 action attrs productions x in
      _menhir_goto_production_group _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_productions_ _v _menhir_s _tok
  
  and _menhir_run_136 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION, _menhir_box_grammar) _menhir_cell1_precedence -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_precedence (_menhir_stack, _, x, _, _) = _menhir_stack in
      let MenhirCell0_ACTION (_menhir_stack, action, _) = _menhir_stack in
      let MenhirCell1_separated_nonempty_list_BAR_production_ (_menhir_stack, _menhir_s, productions, _startpos_productions_) = _menhir_stack in
      let (_endpos_attrs_, attrs) = (_endpos, _v) in
      let _v = _menhir_action_093 action attrs productions x in
      _menhir_goto_production_group _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_attrs_ _startpos_productions_ _v _menhir_s _tok
  
  and _menhir_run_279 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_precedence (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | OCAMLTYPE _v_0 ->
          _menhir_run_207 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState279
      | ACTION _v_1 ->
          _menhir_run_223 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState279
      | _ ->
          _eRR 279
  
  and _menhir_run_254 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_action as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_precedence (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState254
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_255 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_241 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_precedence (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | OCAMLTYPE _v_0 ->
          _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState241
      | ACTION _v_1 ->
          _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v_1 MenhirState241
      | _ ->
          _eRR 241
  
  and _menhir_run_181 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_precedence (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_179 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState181
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_182 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_157 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_list_producer_ -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_list_producer_ (_menhir_stack, _menhir_s, producers, _startpos_producers_, _) = _menhir_stack in
      let (_endpos_x_, x) = (_endpos, _v) in
      let _v = _menhir_action_091 _endpos_x_ _startpos_producers_ producers x in
      _menhir_goto_production _menhir_stack _menhir_lexbuf _menhir_lexer _startpos_producers_ _v _menhir_s _tok
  
  and _menhir_run_135 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_separated_nonempty_list_BAR_production_ _menhir_cell0_ACTION as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_precedence (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | ATTRIBUTE _v_0 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState135
      | ACTION _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_1 = _menhir_action_037 () in
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_1 _tok
  
  and _menhir_run_226 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState226 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState227 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UNDERSCORE ->
              _menhir_run_200 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | TILDE ->
              _menhir_run_201 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | PREC ->
              _menhir_run_202 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | OCAMLTYPE _v ->
              _menhir_run_228 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LPAREN ->
              _menhir_run_208 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | LID _v ->
              _menhir_run_229 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | BAR ->
              _menhir_run_230 _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s
          | ACTION _v ->
              _menhir_run_231 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 227)
      | ACTION _ | ATTRIBUTE _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_7 = _menhir_action_053 () in
          _menhir_run_276 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_7 MenhirState226 _tok
  
  and _menhir_run_156 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_PREC -> _ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_PREC (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_symbol_, symbol) = (_endpos, _v) in
      let _v = _menhir_action_084 symbol in
      _menhir_goto_precedence _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_symbol_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_123 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          _menhir_run_122 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState123
      | ACTION _ | ATTRIBUTE _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_0 = _menhir_action_055 () in
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
  
  and _menhir_run_122 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol as 'stack) -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UID _v ->
          _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState122
      | QID _v ->
          _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState122
      | LID _v ->
          _menhir_run_118 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState122
      | ACTION _ | BAR | PREC ->
          let _v = _menhir_action_043 () in
          _menhir_run_154 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState122 _tok
      | _ ->
          _eRR 122
  
  and _menhir_run_121 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          _menhir_run_122 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState121
      | ACTION _ | ATTRIBUTE _ | BAR | COLON | COLONEQUAL | COMMA | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let _v_0 = _menhir_action_055 () in
          _menhir_run_164 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v_0 _tok
  
  and _menhir_run_109 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_COMMA (_menhir_stack, _endpos) in
          let _menhir_s = MenhirState110 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 110)
      | ACTION _ | ATTRIBUTE _ | BAR | COLON | COLONEQUAL | EOF | EQUAL | EQUALEQUAL | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | LPAREN | NONASSOC | OCAMLTYPE _ | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PREC | PUBLIC | QID _ | QUESTION | RIGHT | RPAREN | SEMI | STAR | START | TILDE | TOKEN | TYPE | UID _ | UNDERSCORE ->
          let x = _v in
          let _v = _menhir_action_113 x in
          _menhir_goto_separated_nonempty_list_COMMA_symbol_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_goto_separated_nonempty_list_COMMA_symbol_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState193 ->
          _menhir_run_194 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState108 ->
          _menhir_run_112 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState110 ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_194 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAREN ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
          let x = _v in
          let _v = _menhir_action_060 x in
          _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 194
  
  and _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_ as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState192 ->
          _menhir_run_196 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState107 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_112 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_list_ATTRIBUTE_, _menhir_box_grammar) _menhir_cell1_LPAREN -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      match (_tok : MenhirBasics.token) with
      | RPAREN ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          let MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
          let x = _v in
          let _v = _menhir_action_060 x in
          _menhir_goto_loption_delimited_LPAREN_separated_nonempty_list_COMMA_symbol__RPAREN__ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 112
  
  and _menhir_run_111 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol _menhir_cell0_COMMA -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell0_COMMA (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, x, _, _) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_114 x xs in
      _menhir_goto_separated_nonempty_list_COMMA_symbol_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_087 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          _menhir_run_031 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState087
      | LID _ | QID _ | UID _ ->
          let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _v_0 = _menhir_action_070 () in
          _menhir_run_088 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState087 _tok
      | COLON | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PUBLIC | RIGHT | SEMI | START | TOKEN | TYPE ->
          let x = _v in
          let _v = _menhir_action_119 x in
          _menhir_goto_separated_nonempty_list_option_COMMA__symbol_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _eRR 87
  
  and _menhir_goto_separated_nonempty_list_option_COMMA__symbol_ : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState086 ->
          _menhir_run_090 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | MenhirState088 ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_090 : type  ttv_stack. (ttv_stack, _menhir_box_grammar) _menhir_cell1_priority_keyword -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_priority_keyword (_menhir_stack, _menhir_s, k, _startpos_k_, _endpos_k_) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_014 _endpos_k_ _startpos_k_ k xs in
      _menhir_goto_declaration _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_089 : type  ttv_stack. ((ttv_stack, _menhir_box_grammar) _menhir_cell1_symbol, _menhir_box_grammar) _menhir_cell1_option_COMMA_ -> _ -> _ -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let MenhirCell1_option_COMMA_ (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_symbol (_menhir_stack, _menhir_s, x, _, _) = _menhir_stack in
      let xs = _v in
      let _v = _menhir_action_120 x xs in
      _menhir_goto_separated_nonempty_list_option_COMMA__symbol_ _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
  
  and _menhir_run_061 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState061 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState062 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 62)
      | ATTRIBUTE _ | COMMA | LID _ | PLUS | QID _ | QUESTION | STAR | UID _ ->
          let _v_5 = _menhir_action_057 () in
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 _tok
      | _ ->
          _eRR 61
  
  and _menhir_run_011 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState011 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState012 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 12)
      | COMMA | PLUS | QUESTION | RPAREN | STAR ->
          let _v_5 = _menhir_action_057 () in
          _menhir_run_023 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 _tok
      | _ ->
          _eRR 11
  
  and _menhir_run_006 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_grammar) _menhir_state -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_symbol (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | LPAREN ->
          let _menhir_s = MenhirState006 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_LPAREN (_menhir_stack, _menhir_s, _startpos, _endpos) in
          let _menhir_s = MenhirState007 in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UID _v ->
              _menhir_run_008 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | QID _v ->
              _menhir_run_009 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | LID _v ->
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              _eRR 7)
      | COLON | COMMA | EOF | GRAMMARATTRIBUTE _ | HEADER _ | INLINE | LEFT | LET | LID _ | NONASSOC | ON_ERROR_REDUCE | PARAMETER | PERCENTATTRIBUTE | PERCENTPERCENT _ | PLUS | PUBLIC | QID _ | QUESTION | RIGHT | SEMI | STAR | START | TOKEN | TYPE | UID _ ->
          let _v_5 = _menhir_action_057 () in
          _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer _v_5 _tok
      | _ ->
          _eRR 6
  
  let _menhir_run_000 : type  ttv_stack. ttv_stack -> _ -> _ -> _menhir_box_grammar =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TYPE ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | TOKEN ->
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | START ->
          _menhir_run_049 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | SEMI ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | RIGHT ->
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | PUBLIC ->
          _menhir_run_058 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | PERCENTATTRIBUTE ->
          _menhir_run_059 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | PARAMETER ->
          _menhir_run_074 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | ON_ERROR_REDUCE ->
          _menhir_run_076 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | NONASSOC ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | LET ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | LEFT ->
          _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | INLINE ->
          _menhir_run_081 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | HEADER _v ->
          _menhir_run_082 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState000
      | GRAMMARATTRIBUTE _v ->
          _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState000
      | EOF ->
          _menhir_run_084 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | COLON ->
          _menhir_run_085 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | PERCENTPERCENT _ ->
          let _v = _menhir_action_041 () in
          _menhir_run_091 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState000 _tok
      | _ ->
          _eRR 0
  
end

let grammar =
  fun _menhir_lexer _menhir_lexbuf ->
    let _menhir_stack = () in
    let MenhirBox_grammar v = _menhir_run_000 _menhir_stack _menhir_lexbuf _menhir_lexer in
    v

# 753 "src/stage2/parser.mly"
  

# 6588 "src/stage2/parser.ml"
