module type S = sig

type 'a t = 'a array

(*
type 'a t = 'a array
*)
(** @since 4.08.0: type 'a t = 'a array
 *)


module Floatarray = Array.Floatarray

(*
module Floatarray :
sig val create : int -> Stdcompat__init.floatarray
val length : Stdcompat__init.floatarray -> int
val get : Stdcompat__init.floatarray -> int -> float
val set : Stdcompat__init.floatarray -> int -> float -> unit
val unsafe_get : Stdcompat__init.floatarray -> int -> float
val unsafe_set : Stdcompat__init.floatarray -> int -> float -> unit end
*)
(** @since 4.06.0: module Floatarray = Array.Floatarray
 *)

val init_matrix : int -> int -> (int -> int -> 'a) -> 'a array array
(** @since 5.2.0:
    val init_matrix : int -> int -> (int -> int -> 'a) -> 'a array array *)

val shuffle : rand:(int -> int) -> 'a array -> unit
(** @since 5.2.0: val shuffle : rand:(int -> int) -> 'a array -> unit *)

val map_inplace : ('a -> 'a) -> 'a array -> unit
(** @since 5.1.0: val map_inplace : ('a -> 'a) -> 'a array -> unit *)

val mapi_inplace : (int -> 'a -> 'a) -> 'a array -> unit
(** @since 5.1.0: val mapi_inplace : (int -> 'a -> 'a) -> 'a array -> unit *)

val find_index : ('a -> bool) -> 'a array -> int option
(** @since 5.1.0: val find_index : ('a -> bool) -> 'a array -> int option *)

val find_mapi : (int -> 'a -> 'b option) -> 'a array -> 'b option
(** @since 5.1.0:
    val find_mapi : (int -> 'a -> 'b option) -> 'a array -> 'b option *)


val fold_left_map :
  ('acc -> 'a -> ('acc * 'b)) -> 'acc -> 'a array -> ('acc * 'b array)

(*

val fold_left_map :
  ('a -> 'b -> ('a * 'c)) -> 'a -> 'b array -> ('a * 'c array)

(*
val fold_left_map :
  ('acc -> 'a -> ('acc * 'b)) -> 'acc -> 'a array -> ('acc * 'b array)
*)

*)
(** @since 5.1.0:
    val fold_left_map :
      ('acc -> 'a -> ('acc * 'b)) -> 'acc -> 'a array -> ('acc * 'b array)
@since 4.13.0:
val fold_left_map :
  ('a -> 'b -> ('a * 'c)) -> 'a -> 'b array -> ('a * 'c array)
 *)

val find_opt : ('a -> bool) -> 'a array -> 'a option
(** @since 4.13.0: val find_opt : ('a -> bool) -> 'a array -> 'a option *)

val find_map : ('a -> 'b option) -> 'a array -> 'b option
(** @since 4.13.0: val find_map : ('a -> 'b option) -> 'a array -> 'b option *)

val split : ('a * 'b) array -> ('a array * 'b array)
(** @since 4.13.0: val split : ('a * 'b) array -> ('a array * 'b array) *)

val combine : 'a array -> 'b array -> ('a * 'b) array
(** @since 4.13.0: val combine : 'a array -> 'b array -> ('a * 'b) array *)

val for_all2 : ('a -> 'b -> bool) -> 'a array -> 'b array -> bool
(** @since 4.11.0:
    val for_all2 : ('a -> 'b -> bool) -> 'a array -> 'b array -> bool *)

val exists2 : ('a -> 'b -> bool) -> 'a array -> 'b array -> bool
(** @since 4.11.0:
    val exists2 : ('a -> 'b -> bool) -> 'a array -> 'b array -> bool *)


val to_seq : 'a array -> 'a Seq.t

(*
val to_seq : 'a array -> 'a Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seq : 'a array -> 'a Seq.t
 *)


val to_seqi : 'a array -> (int * 'a) Seq.t

(*
val to_seqi : 'a array -> (int * 'a) Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seqi : 'a array -> (int * 'a) Seq.t
 *)


val of_seq : 'a Seq.t -> 'a array

(*
val of_seq : 'a Stdcompat__seq.t -> 'a array
*)
(** @since 4.07.0: val of_seq : 'a Seq.t -> 'a array
 *)


(*
external create_float : int -> float array = "caml_make_float_vect"
*)

external create_float: int -> float array = "caml_array_create_float"


(*
val create_float : int -> float array
*)
(** @since 4.03.0:
    external create_float : int -> float array = "caml_make_float_vect"
 *)

val iter2 : ('a -> 'b -> unit) -> 'a array -> 'b array -> unit
(** @since 4.03.0:
    val iter2 : ('a -> 'b -> unit) -> 'a array -> 'b array -> unit *)

val map2 : ('a -> 'b -> 'c) -> 'a array -> 'b array -> 'c array
(** @since 4.03.0:
    val map2 : ('a -> 'b -> 'c) -> 'a array -> 'b array -> 'c array *)

val for_all : ('a -> bool) -> 'a array -> bool
(** @since 4.03.0: val for_all : ('a -> bool) -> 'a array -> bool *)

val exists : ('a -> bool) -> 'a array -> bool
(** @since 4.03.0: val exists : ('a -> bool) -> 'a array -> bool *)

val mem : 'a -> 'a array -> bool
(** @since 4.03.0: val mem : 'a -> 'a array -> bool *)

val memq : 'a -> 'a array -> bool
(** @since 4.03.0: val memq : 'a -> 'a array -> bool *)

external length : 'a array -> int = "%array_length"
(** Alias for {!Array.length} *)

external get : 'a array -> int -> 'a = "%array_safe_get"
(** Alias for {!Array.get} *)

external set : 'a array -> int -> 'a -> unit = "%array_safe_set"
(** Alias for {!Array.set} *)


(*
external make : int -> 'a -> 'a array = "caml_make_vect"
*)

external make : int -> 'a -> 'a array = "caml_array_make"


(*
external make : int -> 'a -> 'a array = "make_vect"
*)
(** @since 3.08.0: external make : int -> 'a -> 'a array = "caml_make_vect"
@since 3.07.0: external make : int -> 'a -> 'a array = "make_vect"
 *)

val init : int -> (int -> 'a) -> 'a array
(** Alias for {!Array.init} *)

val make_matrix : int -> int -> 'a -> 'a array array
(** Alias for {!Array.make_matrix} *)

val append : 'a array -> 'a array -> 'a array
(** Alias for {!Array.append} *)

val concat : 'a array list -> 'a array
(** Alias for {!Array.concat} *)

val sub : 'a array -> int -> int -> 'a array
(** Alias for {!Array.sub} *)

val copy : 'a array -> 'a array
(** Alias for {!Array.copy} *)

val fill : 'a array -> int -> int -> 'a -> unit
(** Alias for {!Array.fill} *)

val blit : 'a array -> int -> 'a array -> int -> int -> unit
(** Alias for {!Array.blit} *)

val to_list : 'a array -> 'a list
(** Alias for {!Array.to_list} *)

val of_list : 'a list -> 'a array
(** Alias for {!Array.of_list} *)

val iter : ('a -> unit) -> 'a array -> unit
(** Alias for {!Array.iter} *)

val iteri : (int -> 'a -> unit) -> 'a array -> unit
(** Alias for {!Array.iteri} *)

val map : ('a -> 'b) -> 'a array -> 'b array
(** Alias for {!Array.map} *)

val mapi : (int -> 'a -> 'b) -> 'a array -> 'b array
(** Alias for {!Array.mapi} *)


val fold_left : ('acc -> 'a -> 'acc) -> 'acc -> 'a array -> 'acc

(*
val fold_left : ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a
*)
(** @since 5.1.0:
    val fold_left : ('acc -> 'a -> 'acc) -> 'acc -> 'a array -> 'acc
@since 3.07.0: val fold_left : ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a
 *)


val fold_right : ('a -> 'acc -> 'acc) -> 'a array -> 'acc -> 'acc

(*

val fold_right : ('b -> 'a -> 'a) -> 'b array -> 'a -> 'a

(*
val fold_right : ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b
*)

*)
(** @since 5.1.0:
    val fold_right : ('a -> 'acc -> 'acc) -> 'a array -> 'acc -> 'acc
@since 4.00.0: val fold_right : ('b -> 'a -> 'a) -> 'b array -> 'a -> 'a
@since 3.07.0: val fold_right : ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b
 *)

val sort : ('a -> 'a -> int) -> 'a array -> unit
(** Alias for {!Array.sort} *)

val stable_sort : ('a -> 'a -> int) -> 'a array -> unit
(** Alias for {!Array.stable_sort} *)

val fast_sort : ('a -> 'a -> int) -> 'a array -> unit
(** Alias for {!Array.fast_sort} *)

external unsafe_get : 'a array -> int -> 'a = "%array_unsafe_get"
(** Alias for {!Array.unsafe_get} *)

external unsafe_set : 'a array -> int -> 'a -> unit = "%array_unsafe_set"
(** Alias for {!Array.unsafe_set} *)

end
