module type S = sig

type t = bool =
  | false 
  | true 

(*
type t = bool =
  | false 
  | true 
*)
(** @since 4.08.0: type t = bool =
                     | false 
                     | true 
 *)

val seeded_hash : int -> bool -> int
(** @since 5.1.0: val seeded_hash : int -> bool -> int *)

val hash : bool -> int
(** @since 5.1.0: val hash : bool -> int *)

val not : bool -> bool
(** @since 4.08.0: val not : bool -> bool *)


external (&&) : bool -> bool -> bool = "%sequand"

(*

external (&&) : bool -> bool -> bool = "%sequand"[@@ocaml.deprecated
                                                   "Use (&&) instead."]

(*
external (&&) : bool -> bool -> bool = "%sequand"
*)

*)
(** @since 4.08.0: external (&&) : bool -> bool -> bool = "%sequand"
 *)


external (||) : bool -> bool -> bool = "%sequor"

(*

external (||) : bool -> bool -> bool = "%sequor"[@@ocaml.deprecated
                                                  "Use (||) instead."]

(*
external (||) : bool -> bool -> bool = "%sequor"
*)

*)
(** @since 4.08.0: external (||) : bool -> bool -> bool = "%sequor"
 *)

val equal : bool -> bool -> bool
(** @since 4.08.0: val equal : bool -> bool -> bool *)

val compare : bool -> bool -> int
(** @since 4.08.0: val compare : bool -> bool -> int *)

val to_int : bool -> int
(** @since 4.08.0: val to_int : bool -> int *)

val to_float : bool -> float
(** @since 4.08.0: val to_float : bool -> float *)

val to_string : bool -> string
(** @since 4.08.0: val to_string : bool -> string *)

end
