module type S = sig
type t = string
(** Alias for {!Digest.t} *)


module type S =
sig type t = string val hash_length : int val compare : t -> t -> int
val equal : t -> t -> bool val string : string -> t val bytes : bytes -> t
val substring : string -> int -> int -> t
val subbytes : bytes -> int -> int -> t val channel : in_channel -> int -> t
val file : string -> t val output : out_channel -> t -> unit
val input : in_channel -> t val to_hex : t -> string val of_hex : string -> t
end

(*
module type S =
sig type t = string val hash_length : int val compare : t -> t -> int
val equal : t -> t -> bool val string : string -> t
val bytes : Stdcompat__init.bytes -> t
val substring : string -> int -> int -> t
val subbytes : Stdcompat__init.bytes -> int -> int -> t
val channel : in_channel -> int -> t val file : string -> t
val output : out_channel -> t -> unit val input : in_channel -> t
val to_hex : t -> string val of_hex : string -> t end
*)
(** @since 5.2.0:
    module type S  =
      sig
        type t = string
        val hash_length : int
        val compare : t -> t -> int
        val equal : t -> t -> bool
        val string : string -> t
        val bytes : bytes -> t
        val substring : string -> int -> int -> t
        val subbytes : bytes -> int -> int -> t
        val channel : in_channel -> int -> t
        val file : string -> t
        val output : out_channel -> t -> unit
        val input : in_channel -> t
        val to_hex : t -> string
        val of_hex : string -> t
      end
 *)


module BLAKE128 = Digest.BLAKE128

(*
module BLAKE128 : S
*)
(** @since 5.2.0: module BLAKE128 = Digest.BLAKE128
 *)


module BLAKE256 = Digest.BLAKE256

(*
module BLAKE256 : S
*)
(** @since 5.2.0: module BLAKE256 = Digest.BLAKE256
 *)


module BLAKE512 = Digest.BLAKE512

(*
module BLAKE512 : S
*)
(** @since 5.2.0: module BLAKE512 = Digest.BLAKE512
 *)


module MD5 = Digest.MD5

(*
module MD5 : S
*)
(** @since 5.2.0: module MD5 = Digest.MD5
 *)

val of_hex : string -> t
(** @since 5.2.0: val of_hex : string -> t *)

val equal : t -> t -> bool
(** @since 4.03.0: val equal : t -> t -> bool *)


val bytes : bytes -> t

(*
val bytes : Stdcompat__init.bytes -> t
*)
(** @since 4.02.0: val bytes : bytes -> t
 *)


val subbytes : bytes -> int -> int -> t

(*
val subbytes : Stdcompat__init.bytes -> int -> int -> t
*)
(** @since 4.02.0: val subbytes : bytes -> int -> int -> t
 *)

val compare : t -> t -> int
(** @since 4.00.0: val compare : t -> t -> int *)

val from_hex : string -> t
(** @since 4.00.0: val from_hex : string -> t *)

val string : string -> t
(** Alias for {!Digest.string} *)

val substring : string -> int -> int -> t
(** Alias for {!Digest.substring} *)


val channel : in_channel -> int -> t

(*

external channel : in_channel -> int -> t = "caml_md5_chan"

(*
external channel : in_channel -> int -> t = "md5_chan"
*)

*)
(** @since 5.2.0: val channel : in_channel -> int -> t
@since 3.08.0: external channel : in_channel -> int -> t = "caml_md5_chan"
@since 3.07.0: external channel : in_channel -> int -> t = "md5_chan"
 *)

val file : string -> t
(** Alias for {!Digest.file} *)

val output : out_channel -> t -> unit
(** Alias for {!Digest.output} *)

val input : in_channel -> t
(** Alias for {!Digest.input} *)

val to_hex : t -> string
(** Alias for {!Digest.to_hex} *)

end
