module type S = sig

type ('a, 'b) t = ('a, 'b) Stdcompat__init.either =
  | Left of 'a 
  | Right of 'b 

(*
type ('a, 'b) t = ('a, 'b) Stdcompat__init.either =
  | Left of 'a 
  | Right of 'b 
*)
(** @since 4.12.0: type ('a, 'b) t =
                     | Left of 'a 
                     | Right of 'b 
 *)

val left : 'a -> ('a, 'b) t
(** @since 4.12.0: val left : 'a -> ('a, 'b) t *)

val right : 'b -> ('a, 'b) t
(** @since 4.12.0: val right : 'b -> ('a, 'b) t *)

val is_left : ('a, 'b) t -> bool
(** @since 4.12.0: val is_left : ('a, 'b) t -> bool *)

val is_right : ('a, 'b) t -> bool
(** @since 4.12.0: val is_right : ('a, 'b) t -> bool *)

val find_left : ('a, 'b) t -> 'a option
(** @since 4.12.0: val find_left : ('a, 'b) t -> 'a option *)

val find_right : ('a, 'b) t -> 'b option
(** @since 4.12.0: val find_right : ('a, 'b) t -> 'b option *)

val map_left : ('a1 -> 'a2) -> ('a1, 'b) t -> ('a2, 'b) t
(** @since 4.12.0: val map_left : ('a1 -> 'a2) -> ('a1, 'b) t -> ('a2, 'b) t *)

val map_right : ('b1 -> 'b2) -> ('a, 'b1) t -> ('a, 'b2) t
(** @since 4.12.0: val map_right : ('b1 -> 'b2) -> ('a, 'b1) t -> ('a, 'b2) t *)

val map :
  left:('a1 -> 'a2) -> right:('b1 -> 'b2) -> ('a1, 'b1) t -> ('a2, 'b2) t
(** @since 4.12.0:
    val map :
      left:('a1 -> 'a2) -> right:('b1 -> 'b2) -> ('a1, 'b1) t -> ('a2, 'b2) t *)

val fold : left:('a -> 'c) -> right:('b -> 'c) -> ('a, 'b) t -> 'c
(** @since 4.12.0:
    val fold : left:('a -> 'c) -> right:('b -> 'c) -> ('a, 'b) t -> 'c *)

val iter : left:('a -> unit) -> right:('b -> unit) -> ('a, 'b) t -> unit
(** @since 4.12.0:
    val iter : left:('a -> unit) -> right:('b -> unit) -> ('a, 'b) t -> unit *)

val for_all : left:('a -> bool) -> right:('b -> bool) -> ('a, 'b) t -> bool
(** @since 4.12.0:
    val for_all :
      left:('a -> bool) -> right:('b -> bool) -> ('a, 'b) t -> bool *)

val equal :
  left:('a -> 'a -> bool) ->
    right:('b -> 'b -> bool) -> ('a, 'b) t -> ('a, 'b) t -> bool
(** @since 4.12.0:
    val equal :
      left:('a -> 'a -> bool) ->
        right:('b -> 'b -> bool) -> ('a, 'b) t -> ('a, 'b) t -> bool *)

val compare :
  left:('a -> 'a -> int) ->
    right:('b -> 'b -> int) -> ('a, 'b) t -> ('a, 'b) t -> int
(** @since 4.12.0:
    val compare :
      left:('a -> 'a -> int) ->
        right:('b -> 'b -> int) -> ('a, 'b) t -> ('a, 'b) t -> int *)

end
